.TH "Simple Virtual Machine - Plugin uri" 7 "2022-01-30"
.SH SYNOPSIS
.B svm_plugin_uri
A low level URI manager.
.SH DESCRIPTION
This plugin provides low level URI manipulations.
.P
This plugin may be used with a HTTP plugin.
.SH INVOKATION
This plugin can be added to the Simple Virtual Machine using one of these directives:
.SS Local
.nf

LOCAL PLUGIN "svmpluginuri/libsvmuri.so"

.fi
when compiled/installed locally and should be accessible from the application directory.
.SS Machine and System
.nf

PLUGIN "===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from the Simple Virtual Machine installation directory or from system directories. (Recommended)
.SS Absolute path
.nf

PLUGIN "===PLUGINLIBDIR===/===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from an absolute path.
.SH CONTENT
.SS TYPE uri.address
Contain an URI.
.P
This type supports copy, constant construction and conversion to string.
.SS INTERRUPTION uri.bad_address
Interruption raised when an ill-formed URI is decoded.
.SS INSTRUCTION uri.decode STR -> uri.address
Decode a string containing an URI.
This instruction can be called on a string extracted from an HTTP query.
.P
The instruction raises the interruption !uri.bad_address when the string is an ill-formed URI.
.SS INSTRUCTION uri.encode uri.address -> STR
Encode an URI into a string.
The resulting string can be used into an HTTP query.
.SS INSTRUCTION uri.new ( 'ABSOLUTE' STR:protocol STR:server INT ?:port | 'RELATIVE' ) STR:address -> uri.address
Create a new URI with mandatory parameters.
 - RELATIVE address contains only the local part of the resource,
 - ABSOLUTE also contains the protocol, server and port.
.P
The instruction is created without parameter or anchor.
.SS INSTRUCTION uri.absolute uri.address -> BLN
Indicate whether an URI is absolute, by checking the protocol presence.
.SS INTERRUPTION uri.bad_type
Interruption raised when an URI has not the right type among ABSOLUTE and RELATIVE.
.SS INSTRUCTION uri.get_protocol uri.address -> STR
Return the protocol on an absolute URI.
.SS INSTRUCTION uri.set_protocol MUTABLE uri.address STR
Change the protocol on an absolute URI.
.SS INSTRUCTION uri.get_server uri.address -> STR
Return the server on an absolute URI.
.SS INSTRUCTION uri.set_server MUTABLE uri.address STR
Change the server on an absolute URI.
.SS INSTRUCTION uri.get_port uri.address -> INT
Return the port on an absolute URI.
.SS INSTRUCTION uri.set_port MUTABLE uri.address INT ?
Change the port on an absolute URI.
.P
If the port is not specified, the port is removed.
.SS INSTRUCTION uri.get_address uri.address -> STR
Return the address on an URI.
.SS INSTRUCTION uri.set_address MUTABLE uri.address STR
Change the address of an URI.
.SS INSTRUCTION uri.get_anchor uri.address -> STR ?
Return the anchor of an URI.
.P
When the anchor is not specified, a null string is returned.
.SS INSTRUCTION uri.set_anchor MUTABLE uri.address STR ?
Change the anchor of an URI.
.P
If the string is not specified, the anchor is removed.
.SS INSTRUCTION uri.get_parameter uri.address STR:key -> STR ?:value
Return the value of an URI associated to a key.
.P
The null string is returned when the key parameter does not exist.
.SS INSTRUCTION uri.set_parameter MUTABLE uri.address STR:key STR ?:value
Change a parameter value on an URI.
.P
When the value is not specified, the key is removed.
Otherwise, the key is added or modified with the new value.
.SS INSTRUCTION uri.get_parameters uri.address -> PTR
Return all parameters of an URI into an array of arrays.
The main array contains one pointer for each parameter to a two string array containing the key and the value.
.SS INSTRUCTION uri.set_parameters MUTABLE uri.address PTR
Change all parameters of an URI.
The pointer references an array of arrays like the one returned by the instruction uri.get_parameters.
.SH EXAMPLES
.SS Simple example
.nf
#!===SVMBIN===
LOG
PLUGIN "svmcom.so"
PLUGIN "===PLUGINLIB==="
PROCESS "test"
	CODE "main" INLINE
		:memory uri.address/a
		CONST uri.address "ssh://server:22/file" -> &a
		:uri.set_protocol @&a "http"
		:uri.set_anchor @&a "anchor"
		:uri.set_parameter @&a "key" "value"
		:uri.set_port @&a
		:com.message @&a
	END
END
.fi
.SS Display parameters of an URI
.nf
#!===SVMBIN===
LOG
PLUGIN "svmcom.so"
PLUGIN "===PLUGINLIB==="
ARGUMENT STR uri
PROCESS "test"
        CODE "main" INLINE
                :memory uri.address/a, PTR/p, INT/i
                :uri.decode @&uri -> &a
                :uri.get_parameters @&a -> &p
                0 -> &i
        :label loop
                :shutdown :unless @&i IN @&p
                :com.message @(@(@&p/@&i)/0) ": " @(@(@&p/@&i)/1)
                :shift &i
                :goto loop
        END
        MEMORY uri
END
.fi
.SH SEE ALSO
.BR svm (1)
for help on the Simple Virtual Machine.
.BR svm_plugin_http (7)
for HTTP requests.
.SH AUTHOR
This plugin has been written by Julien BRUGUIER and is maintained by Julien BRUGUIER <projet.svm@pappy.tf>.
