/*
 * Copyright (C) 2022-01-30  Julien BRUGUIER
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <string>
#include <sstream>

#line 75 "../plugins/uri/core/uri.svm_plugin"
#include <string>
#include <map>
#include <vector>
#include <sstream>
#line 28 "src/plugin.cpp"

#include <src/plugin.h>

extern "C"
{

void plugin_configure(void *plugin)
{
	::svm_plugin_configure(plugin,
		"PLUGIN uri \n"
		"DEFINE \n"
		"	TYPE uri.address \n"
		"	INTERRUPTION uri.bad_address \n"
		"	INSTRUCTION uri.decode STR -> uri.address \n"
		"	INSTRUCTION uri.encode uri.address -> STR \n"
		"	INSTRUCTION uri.new ( 'ABSOLUTE' STR:protocol STR:server INT ?:port | 'RELATIVE' ) STR:address -> uri.address \n"
		"	INSTRUCTION uri.absolute uri.address -> BLN \n"
		"	INTERRUPTION uri.bad_type \n"
		"	INSTRUCTION uri.get_protocol uri.address -> STR \n"
		"	INSTRUCTION uri.set_protocol MUTABLE uri.address STR \n"
		"	INSTRUCTION uri.get_server uri.address -> STR \n"
		"	INSTRUCTION uri.set_server MUTABLE uri.address STR \n"
		"	INSTRUCTION uri.get_port uri.address -> INT \n"
		"	INSTRUCTION uri.set_port MUTABLE uri.address INT ? \n"
		"	INSTRUCTION uri.get_address uri.address -> STR \n"
		"	INSTRUCTION uri.set_address MUTABLE uri.address STR \n"
		"	INSTRUCTION uri.get_anchor uri.address -> STR ? \n"
		"	INSTRUCTION uri.set_anchor MUTABLE uri.address STR ? \n"
		"	INSTRUCTION uri.get_parameter uri.address STR:key -> STR ?:value \n"
		"	INSTRUCTION uri.set_parameter MUTABLE uri.address STR:key STR ?:value \n"
		"	INSTRUCTION uri.get_parameters uri.address -> PTR \n"
		"	INSTRUCTION uri.set_parameters MUTABLE uri.address PTR \n"
		,SVM_API_SIGNATURE,SVM_VERSION);
}

#ifndef ARGV_VALUE
#define ARGV_VALUE(index,type) ::svm_value_##type##_get(svm,::svm_parameter_value_get(svm,argv[(index)]))
#endif
#ifndef ARGV_PLUGIN
#define ARGV_PLUGIN(index,plugin,name) reinterpret_cast<type_##name*>(::svm_value_plugin_get_internal(svm,::svm_parameter_value_get(svm,argv[(index)])))
#endif
#ifndef ARGV_MARKER
#define ARGV_MARKER(index) std::string(::svm_parameter_marker_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_KEYWORD
#define ARGV_KEYWORD(index) std::string(::svm_parameter_keyword_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_STRUCT
#define ARGV_STRUCT(index,plugin,name) reinterpret_cast<struct_##name*>(::svm_structure_get_internal(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),::svm_parameter_structure_get(svm,argv[(index)])))
#endif
#ifndef ARGV_VARIABLE
#define ARGV_VARIABLE(index) ::svm_parameter_variable_get(svm,argv[(index)]);
#endif
#ifndef NEW_VALUE
#define NEW_VALUE(type,value) ::svm_value_##type##_new(svm,(value))
#endif
#ifndef NEW_PLUGIN
#define NEW_PLUGIN(plugin,name,value) ::svm_value_plugin_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRUCT
#define NEW_STRUCT(plugin,name,value) ::svm_structure_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRING
#define NEW_STRING(raw_string) ::svm_string_new(svm,raw_string.c_str(),raw_string.size())
#endif
#ifndef RAW_STRING
#define RAW_STRING(svm_string) std::string(svm_string.string,svm_string.size)
#endif
#ifndef NEW_BOOLEAN
#define NEW_BOOLEAN(boolean) ((boolean)?TRUE:FALSE)
#endif
#ifndef RAW_BOOLEAN
#define RAW_BOOLEAN(boolean) ((boolean)==TRUE)
#endif
#ifndef NEW_NULL_VALUE
#define NEW_NULL_VALUE(type) ::svm_value_##type##_new_null(svm)
#endif
#ifndef NEW_NULL_PLUGIN
#define NEW_NULL_PLUGIN(plugin,name) ::svm_value_plugin_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef NEW_NULL_STRUCT
#define NEW_NULL_STRUCT(plugin,name) ::svm_structure_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef ERROR_INTERNAL
#define ERROR_INTERNAL(irq,message) ::svm_processor_current_raise_error_internal__raw(svm,irq,message)
#endif
#ifndef ERROR_EXTERNAL
#define ERROR_EXTERNAL(plugin,name,message) ::svm_processor_current_raise_error_external__raw(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),message)
#endif
#ifndef CONST_PEP
#define CONST_PEP(plugin,name) ::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name)
#endif
#ifndef CURRENT
#define CURRENT(object) ::svm_##object##_get_current(svm)
#endif
#ifndef RETURN
#define RETURN return nullptr
#endif
#ifndef VARIABLE_GLOBAL
#define VARIABLE_GLOBAL(variable) ::svm_variable_scope_set_global(svm,(variable))
#endif
#ifndef VARIABLE_LOCAL
#define VARIABLE_LOCAL(variable) ::svm_variable_scope_set_local(svm,(variable))
#endif
#ifndef VARIABLE_DELETE
#define VARIABLE_DELETE(variable) ::svm_variable_delete(svm,(variable))
#endif

}

#line 82 "../plugins/uri/core/uri.svm_plugin"
struct Outils
{
static std::string conversion(const SVM_String& s)
{
	return std::string(s.string,s.size);
}
static std::string uri_encode(const std::string& chaine)
{
	std::string r;
	for(auto& c: chaine)
	{
		if((c>='a') and (c<='z')) { r += c; continue; }
		if((c>='A') and (c<='Z')) { r += c; continue; }
		if((c>='0') and (c<='9')) { r += c; continue; }
		if((c=='-') or (c=='_') or (c=='/')) { r += c; continue; }
		if(c==' ') {  r+= '+'; continue; }
		char cb = c & 0xF;
		char ch = (c & 0xF0) >> 4;
		r += '%';
		if(ch<10) { r += ('0'+ch); } else { r += ('A'+ch-10); }
		if(cb<10) { r += ('0'+cb); } else { r += ('A'+cb-10); }
	}
	return r;
}

static std::string uri_decode(const std::string& chaine)
{
	std::string r;
	for(size_t i = 0 ; i<chaine.size() ; ++i)
	{
		if(chaine[i]=='+')
		{
			r += ' ';
			continue;
		}
		if(chaine[i]=='%')
		{
			unsigned char c = 0;
			for(char ii=0 ; ii<2 ; ++ii)
			{
				if(++i>=chaine.size()) break;
				c <<= 4;
				if((chaine[i]>='0') and (chaine[i]<='9')) { c += (chaine[i]-'0'); continue; } 
				if((chaine[i]>='A') and (chaine[i]<='F')) { c += (chaine[i]-'A'+10); continue; } 
			}
			r += c;
			continue;
		}
		r += chaine[i];
	}
	return r;
}

static std::vector<std::string> decoupage(const std::string& chaine, const std::string& separateur)
{
	std::vector<std::string> v;
	std::string c = chaine;
	size_t p;
	while((p=c.find(separateur))!=std::string::npos)
	{
		v.push_back(c.substr(0,p));
		c = c.substr(p+separateur.size());
	}
	v.push_back(c);
	return v;
}
};
#line 207 "src/plugin.cpp"

extern "C"
{

/* TYPE uri.address */

struct type_address
{
#line 155 "../plugins/uri/core/uri.svm_plugin"
	type_address()
	:_port(0) {}
	std::string _protocole;
	std::string _serveur;
	size_t _port;
	std::string _addresse;
	std::string _ancre;
	std::map<std::string,std::string> _parametres;
#line 225 "src/plugin.cpp"
};

void type_address_delete(const void *svm, void *handler)
{
	type_address * const object = reinterpret_cast<type_address*>(handler);
	{
#line 165 "../plugins/uri/core/uri.svm_plugin"

#line 234 "src/plugin.cpp"
	}
	delete object;
}

void* type_address_copy(const void *svm, const void *handler)
{
	const type_address *object = reinterpret_cast<const type_address*>(handler);
	type_address *copy = new type_address(*object);
	{
#line 166 "../plugins/uri/core/uri.svm_plugin"

#line 246 "src/plugin.cpp"
	}
	return copy;
}

void* type_address_constant(const void *svm, const SVM_String value)
{
	std::string string(value.string,value.size);
	{
#line 168 "../plugins/uri/core/uri.svm_plugin"
	type_address *uri = new type_address();
	size_t protocole = string.find("://");
	if(protocole!=std::string::npos)
	{
		uri->_protocole = Outils::uri_decode(string.substr(0,protocole));
		string = string.substr(protocole+3);
		size_t port = string.find(':'); if(port==std::string::npos) { port = string.size(); }
		size_t adresse = string.find('/'); if(adresse==std::string::npos) { adresse = string.size(); }
		if(port<adresse)
		{
			uri->_serveur = Outils::uri_decode(string.substr(0,port));
			uri->_port = ::atoi(Outils::uri_decode(string.substr(port+1,adresse)).c_str());
		}
		else
		{
			uri->_serveur = Outils::uri_decode(string.substr(0,adresse));
		}
		string = string.substr(adresse);
	}
	size_t ancre = string.find('#'); if(ancre==std::string::npos) { ancre = string.size(); }
	if(ancre!=string.size())
	{
		uri->_ancre = Outils::uri_decode(string.substr(ancre+1));
		string = string.substr(0,ancre);
	}
	size_t parametres = string.find('?'); if(parametres==std::string::npos) { parametres = string.size(); }
	if(parametres!=string.size())
	{
		std::string p = string.substr(parametres+1);
		string = string.substr(0,parametres);
		auto pp = Outils::decoupage(p,"&");
		for(auto ppp: pp)
		{
			auto it=ppp.find('=');
			if(it==std::string::npos) continue;
			uri->_parametres.insert(std::make_pair(Outils::uri_decode(ppp.substr(0,it)),Outils::uri_decode(ppp.substr(it+1))));
		}
	}
	uri->_addresse = Outils::uri_decode(string);
	return uri;
#line 296 "src/plugin.cpp"
	}
}

SVM_String type_address_print(const void *svm, const void *handler)
{
	const type_address *object = reinterpret_cast<const type_address*>(handler);
	{
#line 211 "../plugins/uri/core/uri.svm_plugin"
	std::ostringstream oss;
	if(not object->_protocole.empty())
	{
		oss << Outils::uri_encode(object->_protocole) << "://" << Outils::uri_encode(object->_serveur);
		if(object->_port!=0)
		{
			oss << ":" << object->_port;
		}
		if(not object->_addresse.empty() and object->_addresse[0]!='/')
		{
			oss << '/';
		}
	}
	oss << Outils::uri_encode(object->_addresse);
	if(not object->_parametres.empty())
	{
		oss << '?';
		bool debut = true;
		for(auto p: object->_parametres)
		{
			if(debut)
			{
				debut = false;
			}
			else
			{
				oss << '&';
			}
			oss << Outils::uri_encode(p.first) << "=" << Outils::uri_encode(p.second);
		}
	}
	if(not object->_ancre.empty())
	{
		oss << '#' << Outils::uri_encode(object->_ancre);
	}
	return NEW_STRING(oss.str());
#line 341 "src/plugin.cpp"
	}
}


/* INTERRUPTION uri.bad_address */


/* INSTRUCTION uri.decode STR -> uri.address */

SVM_Value instruction_decode(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 260 "../plugins/uri/core/uri.svm_plugin"
	SVM_String texte = ARGV_VALUE(0,string);
	void *uri = ::type_address_constant(svm,texte);
	return NEW_PLUGIN(uri,address,uri);
#line 357 "src/plugin.cpp"
}


/* INSTRUCTION uri.encode uri.address -> STR */

SVM_Value instruction_encode(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 274 "../plugins/uri/core/uri.svm_plugin"
	void *uri = ::svm_value_plugin_get_internal(svm,::svm_parameter_value_get(svm,argv[0]));
	SVM_String chaine = type_address_print(svm,uri);
	return NEW_VALUE(string,chaine);
#line 369 "src/plugin.cpp"
}


/* INSTRUCTION uri.new ( 'ABSOLUTE' STR:protocol STR:server INT ?:port | 'RELATIVE' ) STR:address -> uri.address */

SVM_Value instruction_new(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 286 "../plugins/uri/core/uri.svm_plugin"
	std::string type = ARGV_KEYWORD(0);
	type_address *uri = new type_address();
	if(type=="ABSOLUTE")
	{
		SVM_String pr = ARGV_VALUE(1,string);
		SVM_String s = ARGV_VALUE(2,string);
		SVM_String a = ARGV_VALUE(4,string);
		uri->_protocole = std::string(pr.string,pr.size);
		uri->_serveur = std::string(s.string,s.size);
		if(argc>3)
		{
			auto pt = ARGV_VALUE(3,integer);
			uri->_port = pt;
		}
		uri->_addresse = std::string(a.string,a.size);
	}
	else
	{
		SVM_String a = ARGV_VALUE(1,string);
		uri->_addresse = std::string(a.string,a.size);
	}
	return NEW_PLUGIN(uri,address,uri);
#line 400 "src/plugin.cpp"
}


/* INSTRUCTION uri.absolute uri.address -> BLN */

SVM_Value instruction_absolute(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 320 "../plugins/uri/core/uri.svm_plugin"
	type_address *uri = ARGV_PLUGIN(0,uri,address);
	return ::svm_value_boolean_new__raw(svm,not uri->_protocole.empty());
#line 411 "src/plugin.cpp"
}


/* INTERRUPTION uri.bad_type */


/* INSTRUCTION uri.get_protocol uri.address -> STR */

SVM_Value instruction_get_protocol(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 333 "../plugins/uri/core/uri.svm_plugin"
	type_address *uri = ARGV_PLUGIN(0,uri,address);
	if(uri->_protocole.empty())
	{
		ERROR_EXTERNAL(uri,bad_type,"Relative URI has no protocol");
	}
	return ::svm_value_string_new__buffer(svm,uri->_protocole.c_str(),uri->_protocole.size());
#line 429 "src/plugin.cpp"
}


/* INSTRUCTION uri.set_protocol MUTABLE uri.address STR */

SVM_Value instruction_set_protocol(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 347 "../plugins/uri/core/uri.svm_plugin"
	type_address *uri = ARGV_PLUGIN(0,uri,address);
	SVM_String valeur = ARGV_VALUE(1,string);
	if(uri->_protocole.empty())
	{
		ERROR_EXTERNAL(uri,bad_type,"Relative URI has no protocol");
	}
	uri->_protocole = Outils::conversion(valeur);
	return nullptr;
#line 446 "src/plugin.cpp"
	return nullptr;
}


/* INSTRUCTION uri.get_server uri.address -> STR */

SVM_Value instruction_get_server(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 363 "../plugins/uri/core/uri.svm_plugin"
	type_address *uri = ARGV_PLUGIN(0,uri,address);
	if(uri->_protocole.empty())
	{
		ERROR_EXTERNAL(uri,bad_type,"Relative URI has no server");
	}
	return ::svm_value_string_new__buffer(svm,uri->_serveur.c_str(),uri->_serveur.size());
#line 462 "src/plugin.cpp"
}


/* INSTRUCTION uri.set_server MUTABLE uri.address STR */

SVM_Value instruction_set_server(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 377 "../plugins/uri/core/uri.svm_plugin"
	type_address *uri = ARGV_PLUGIN(0,uri,address);
	SVM_String valeur = ARGV_VALUE(1,string);
	if(uri->_protocole.empty())
	{
		ERROR_EXTERNAL(uri,bad_type,"Relative URI has no server");
	}
	uri->_serveur = Outils::conversion(valeur);
	return nullptr;
#line 479 "src/plugin.cpp"
	return nullptr;
}


/* INSTRUCTION uri.get_port uri.address -> INT */

SVM_Value instruction_get_port(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 393 "../plugins/uri/core/uri.svm_plugin"
	type_address *uri = ARGV_PLUGIN(0,uri,address);
	if(uri->_protocole.empty())
	{
		ERROR_EXTERNAL(uri,bad_type,"Relative URI has no port");
	}
	return NEW_VALUE(integer,uri->_port);
#line 495 "src/plugin.cpp"
}


/* INSTRUCTION uri.set_port MUTABLE uri.address INT ? */

SVM_Value instruction_set_port(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 407 "../plugins/uri/core/uri.svm_plugin"
	type_address *uri = ARGV_PLUGIN(0,uri,address);
	if(uri->_protocole.empty())
	{
		ERROR_EXTERNAL(uri,bad_type,"Relative URI has no port");
	}
	if(argc>1)
	{
		auto valeur = ARGV_VALUE(1,integer);
		uri->_port = valeur;
	}
	else
	{
		uri->_port=0;
	}
	return nullptr;
#line 519 "src/plugin.cpp"
	return nullptr;
}


/* INSTRUCTION uri.get_address uri.address -> STR */

SVM_Value instruction_get_address(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 432 "../plugins/uri/core/uri.svm_plugin"
	type_address *uri = ARGV_PLUGIN(0,uri,address);
	return ::svm_value_string_new__buffer(svm,uri->_addresse.c_str(),uri->_addresse.size());
#line 531 "src/plugin.cpp"
}


/* INSTRUCTION uri.set_address MUTABLE uri.address STR */

SVM_Value instruction_set_address(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 442 "../plugins/uri/core/uri.svm_plugin"
	type_address *uri = ARGV_PLUGIN(0,uri,address);
	SVM_String valeur = ARGV_VALUE(1,string);
	uri->_addresse = Outils::conversion(valeur);
	return nullptr;
#line 544 "src/plugin.cpp"
	return nullptr;
}


/* INSTRUCTION uri.get_anchor uri.address -> STR ? */

SVM_Value instruction_get_anchor(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 454 "../plugins/uri/core/uri.svm_plugin"
	type_address *uri = ARGV_PLUGIN(0,uri,address);
	if(uri->_ancre.empty())
	{
		return NEW_NULL_VALUE(string);
	}
	return ::svm_value_string_new__buffer(svm,uri->_ancre.c_str(),uri->_ancre.size());
#line 560 "src/plugin.cpp"
}


/* INSTRUCTION uri.set_anchor MUTABLE uri.address STR ? */

SVM_Value instruction_set_anchor(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 470 "../plugins/uri/core/uri.svm_plugin"
	type_address *uri = ARGV_PLUGIN(0,uri,address); 
	if(argc>1)
	{
		SVM_String valeur = ARGV_VALUE(1,string);
		uri->_ancre = Outils::conversion(valeur);
	}
	else
	{
		uri->_ancre = "";
	}
	return nullptr;
#line 580 "src/plugin.cpp"
	return nullptr;
}


/* INSTRUCTION uri.get_parameter uri.address STR:key -> STR ?:value */

SVM_Value instruction_get_parameter(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 491 "../plugins/uri/core/uri.svm_plugin"
	type_address *uri = ARGV_PLUGIN(0,uri,address); 
	SVM_String clef = ARGV_VALUE(1,string);
	auto p = uri->_parametres.find(std::string(clef.string,clef.size));
	if(p==uri->_parametres.end())
	{
		return NEW_NULL_VALUE(string);
	}
	return ::svm_value_string_new__buffer(svm,p->second.c_str(),p->second.size());
#line 598 "src/plugin.cpp"
}


/* INSTRUCTION uri.set_parameter MUTABLE uri.address STR:key STR ?:value */

SVM_Value instruction_set_parameter(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 509 "../plugins/uri/core/uri.svm_plugin"
	type_address *uri = ARGV_PLUGIN(0,uri,address); 
	SVM_String clef_brute = ARGV_VALUE(1,string);
	std::string clef = Outils::conversion(clef_brute);
	if(argc==2)
	{
		auto p = uri->_parametres.find(clef);
		if(p!=uri->_parametres.end())
		{
			uri->_parametres.erase(p);
		}
	}
	else
	{
		SVM_String valeur = ARGV_VALUE(2,string);
		uri->_parametres[clef] = std::string(valeur.string,valeur.size);
	}
	return nullptr;
#line 624 "src/plugin.cpp"
	return nullptr;
}


/* INSTRUCTION uri.get_parameters uri.address -> PTR */

SVM_Value instruction_get_parameters(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 537 "../plugins/uri/core/uri.svm_plugin"
	type_address *uri = ARGV_PLUGIN(0,uri,address); 
	SVM_Memory_Zone zone_tableau_principal = ::svm_memory_zone_new(svm);
	::svm_memory_zone_append_internal__raw(svm,zone_tableau_principal,POINTER,uri->_parametres.size());
	SVM_Value_Pointer tableau_principal = ::svm_memory_allocate(svm,::svm_kernel_get_current(svm),zone_tableau_principal);
	SVM_Address adresse = ::svm_value_pointer_get_address(svm,tableau_principal);
	for(auto e: uri->_parametres)
	{
		SVM_Memory_Zone zone_tableau_secondaire = ::svm_memory_zone_new(svm);
		::svm_memory_zone_append_internal__raw(svm,zone_tableau_secondaire,STRING,2);
		SVM_Value_Pointer tableau_secondaire = ::svm_memory_allocate(svm,::svm_kernel_get_current(svm),zone_tableau_secondaire);
		SVM_Address a = ::svm_value_pointer_get_address(svm,tableau_secondaire);
		::svm_memory_write_address(svm,::svm_kernel_get_current(svm),a,::svm_value_string_new__buffer(svm,e.first.c_str(),e.first.size()));
		::svm_memory_write_address(svm,::svm_kernel_get_current(svm),a+1,::svm_value_string_new__buffer(svm,e.second.c_str(),e.second.size()));
		::svm_memory_write_address(svm,::svm_kernel_get_current(svm),adresse,tableau_secondaire);
		++adresse;
	}
	return tableau_principal;
#line 651 "src/plugin.cpp"
}


/* INSTRUCTION uri.set_parameters MUTABLE uri.address PTR */

SVM_Value instruction_set_parameters(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 563 "../plugins/uri/core/uri.svm_plugin"
	type_address *uri = ARGV_PLUGIN(0,uri,address); 
	std::map<std::string,std::string> parametres;
	SVM_Value_Pointer tableau_principal = ::svm_parameter_value_get(svm,argv[1]);
	SVM_Address adresse = ::svm_value_pointer_get_address(svm,tableau_principal);
	SVM_Size taille = ::svm_value_pointer_get_size(svm,tableau_principal);
	for(SVM_Address a = adresse ; a<(adresse+taille) ; ++a)
	{
		SVM_Value_Pointer tableau_secondaire = ::svm_memory_read_address_type_internal(svm,::svm_kernel_get_current(svm),a,POINTER);
		SVM_Address aa = ::svm_value_pointer_get_address(svm,tableau_secondaire);
		SVM_Value_String clef = ::svm_memory_read_address_type_internal(svm,::svm_kernel_get_current(svm),aa,STRING);
		SVM_Value_String valeur = ::svm_memory_read_address_type_internal(svm,::svm_kernel_get_current(svm),aa+1,STRING);
		parametres[Outils::conversion(::svm_value_string_get(svm,clef))] = Outils::conversion(::svm_value_string_get(svm,valeur));
	}
	uri->_parametres.swap(parametres);
	return nullptr;
#line 675 "src/plugin.cpp"
	return nullptr;
}


/* Generic handling functions */

}
