.TH "Simple Virtual Machine - Plugin ws" 7 "2022-01-30"
.SH SYNOPSIS
.B svm_plugin_ws
A low-level manipulation plugin for WebSocket frames.
.SH DESCRIPTION
This plugin supports decoding and encoding of WebSocket frames, and basic setters and getters on such frames.
.P
This plugin does not support the WebSocket handshake.
.SH INVOKATION
This plugin can be added to the Simple Virtual Machine using one of these directives:
.SS Local
.nf

LOCAL PLUGIN "svmpluginws/libsvmws.so"

.fi
when compiled/installed locally and should be accessible from the application directory.
.SS Machine and System
.nf

PLUGIN "===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from the Simple Virtual Machine installation directory or from system directories. (Recommended)
.SS Absolute path
.nf

PLUGIN "===PLUGINLIBDIR===/===PLUGINLIB==="

.fi
when installed with auto-tools and should be accessible from an absolute path.
.SH DEPENDENCIES
.SS TYPE com.device
This plugin is conceived to work with the official plugin com.
.SS TYPE http.mesg_1_1
This type is mandatory to perform a WebSocket handshake.
.SH CONTENT
.SS FUNCTION ws.protocol_frame STR BLN -> INT ?
Implement the sw.frame protocol for official plugin com.
.SS TYPE ws.frame
Contain a WebSocket frame.
.P
This type supports copy and string conversion.
.SS INTERRUPTION ws.bad_frame
Interruption raised when a string contains an ill-formed WebSocket frame
.SS INSTRUCTION ws.decode STR -> ws.frame
Decode a WebSocket frame into a ws.frame object.
The input string can be extracted from a WebSocket flow.
.P
When the string is not a WebSocket frame, the interruption !ws.bad_frame is raised.
.SS INSTRUCTION ws.encode ws.frame -> STR
Encode a WebSocket frame into a string.
This string can be used for WebSocket flows.
.SS INSTRUCTION ws.new -> ws.frame
Create an empty WebSocket frame.
.P
The end flag is set and the operational code is set to TEXT.
.SS INSTRUCTION ws.get_fin ws.frame -> BLN
Return the end flag on a WebSocket frame.
.SS INSTRUCTION ws.set_fin MUTABLE ws.frame BLN
Change the end flag on a WebSocket frame.
.SS INSTRUCTION ws.get_rsv ws.frame INT -> BLN
Return the status of a reserved flag on a WebSocket frame.
.P
The interruption FAILURE will be raised if the index is not 1, 2 or 3.
.SS INSTRUCTION ws.set_rsv MUTABLE ws.frame INT BLN
Change the status of a reserved flag on a WebSocket frame.
.P
The interruption FAILURE will be raised if the index is not 1, 2 or 3.
.SS INTERRUPTION ws.bad_opcode
Interruption raised when an invalid operational code is encountered.
.SS INSTRUCTION ws.get_opcode ws.frame -> INT
Return the operational code on a WebSocket frame.
.SS INSTRUCTION ws.set_opcode MUTABLE ws.frame [ INT 'CONTINUE' 'TEXT' 'BINARY' 'END' 'PING' 'PONG' ]
Return the operational code on a WebSocket frame.
.P
An interruption !ws.bad_opcode will be raised if the provided operational code does not exist.
.SS INSTRUCTION ws.get_mask ws.frame -> STR ?
Return the mask on a WebSocket frame.
.P
When the mask is not defined, a null string is returned.
.SS INSTRUCTION ws.set_mask MUTABLE ws.frame STR ?
Change the mask on a WebSocket frame.
When the value is not specified, the mask is removed.
.P
An interruption FAILURE is raised if the mask size is not 4.
.SS INSTRUCTION ws.get_payload ws.frame -> STR
Return the payload on a WebSocket frame.
.SS INSTRUCTION ws.set_payload MUTABLE ws.frame STR
Change the payload on a WebSocket frame.
.SS INSTRUCTION ws.explain ws.frame -> STR
Return a textual dump on a WebSocket frame.
This string is not suitable for WebSocket flows.
.SH EXAMPLE
.SS A demonstration WebSocket server
.nf
#!===SVMBIN===
LOG
PLUGIN "svmcom.so"
PLUGIN "svmrun.so"
PLUGIN "svmstr.so"
PLUGIN "svmint.so"
PLUGIN "/usr/local/lib/svmpluginhttp/libsvmhttp.so"
PLUGIN "/usr/local/lib/svmpluginuri/libsvmuri.so"
PLUGIN "/usr/local/lib/svmpluginenc/libsvmenc.so"
PLUGIN "===PLUGINLIB==="
ARGUMENT STR port
PROCESS "server"
	CODE "main" INLINE
		:memory com.device/s
		:com.open com.tcp < "0.0.0.0" @&port -> &s
	:label loop
		:call wait s
		:goto loop
	:label wait
		:memory (com.device, STR)/c
		:com.command @&s CLIENT -> &c
		@&port -> (c/1)
		:run.parallel_call $"client" c "client" SCHED=run.parallel
		:return
	:symbol client
		:memory STR/t, http.mesg_1_1/q, uri.address/u, BLN/b, ws.frame/w, INT/s, INT/i, STR/r, STR/id
	:label loop_http
		:com.read @&P http.mesg_1_1 -> &t
		:shutdown :unless &t INITIALISED
		:http.decode @&t -> &q
		:http.get_header @&q "Upgrade" -> &t
		:goto continue_http :unless &t INITIALISED
		:str.cmp @&t = "websocket" -> &b
		:goto websocket :when @&b TRUE
	:label continue_http
		:http.get_uri @&q -> &t
		:uri.decode @&t -> &u
		:uri.get_address @&u -> &t
		:str.cmp @&t = "/" -> &b
		:goto not_found :unless @&b TRUE
		:http.new REPLY 200 -> &q
		"""<html>
	<head>
	</head>
	<body>
		<input id="tata" type="text"></input><br/>
		<input type="button" onclick="socket.send(document.getElementById('tata').value)">Click me</input>
		<div id="toto"></div>
		<script>
			var socket = new WebSocket('ws://localhost:PORT');
			socket.addEventListener("message",function(event){ document.getElementById('toto').innerHTML= event.data; });
		</script>
	</body>
</html>"""  -> &t
		:str.replace @&t ALL CONST str.pattern "PORT" => @(P/1)
		:http.set_payload @&q @&t
		:str.size @&t -> &s
		:int.print @&s -> &t
		:http.set_header @&q "Content-Length" @&t
		:com.write @&P @&q
		:goto loop_http
	:label not_found
		:http.new REPLY 404 -> &q
		:http.set_header @&q "Content-Length" "0"
		:com.write @&P @&q
		:goto loop_http
	:label websocket
		:http.get_header @&q "Sec-WebSocket-Key" -> &t
		:str.join @&t "258EAFA5-E914-47DA-95CA-C5AB0DC85B11" -> &t
		:enc.sha1 @&t -> &t
		:enc.base64 ENCODE @&t -> &t
		CONST http.mesg_1_1 "HTTP/1.1 101 Switching Protocols\(rsr\(rsnUpgrade: websocket\(rsr\(rsnConnection: Upgrade\(rsr\(rsn\(rsr\(rsn" -> &q
		:http.set_header @&q "Sec-WebSocket-Accept" @&t
		:com.write @&P @&q
		:com.read @&P ws.frame -> &t
		:ws.decode @&t -> &w
		:ws.get_payload @&w -> &r
		0 -> &i
		"" -> &t
	:label loop_websocket
		:int.print @&i -> &id
		:str.join @&t "<div id=\(rs"" @&id "\(rs">" @&r "</div>" -> &t
		:ws.new -> &w
		:ws.set_fin @&w TRUE
		:ws.set_opcode @&w TEXT
		:ws.set_payload @&w @&t
		:com.write @&P @&w
		:com.message @&r " -> " @&i
		:shift &i
		:run.sleep SOFT 1
		:goto loop_websocket :when @&i IN &0*10
		:ws.set_fin @&w TRUE
		:ws.set_opcode @&w END
		:com.write @&P @&w
		:goto loop_http
		
	END
	MEMORY port
END
.fi
.SH SEE ALSO
.BR svm (1)
for help on the Simple Virtual Machine.
.BR svm_plugin_com (7)
for networking, and
.BR svm_plugin_http (7)
and
.BR svm_plugin_enc (7)
for WebSocket handshake.
.SH AUTHOR
This plugin has been written by Julien BRUGUIER and is maintained by Julien BRUGUIER <projet.svm@pappy.tf>.
