/*
 * Copyright (C) 2022-01-30  Julien BRUGUIER
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <string>
#include <sstream>

#line 138 "../plugins/ws/core/ws.svm_plugin"
#include <string>
#include <map>
#include <set>
#include <vector>
#include <sstream>
#include <cstring>
#include <iostream>
#include <cstdint>
#line 32 "src/plugin.cpp"

#include <src/plugin.h>

extern "C"
{

void plugin_configure(void *plugin)
{
	::svm_plugin_configure(plugin,
		"PLUGIN ws \n"
		"USE \n"
		"	TYPE com.device \n"
		"	TYPE http.mesg_1_1 \n"
		"DEFINE \n"
		"	FUNCTION ws.protocol_frame STR BLN -> INT ? \n"
		"	TYPE ws.frame \n"
		"	INTERRUPTION ws.bad_frame \n"
		"	INSTRUCTION ws.decode STR -> ws.frame \n"
		"	INSTRUCTION ws.encode ws.frame -> STR \n"
		"	INSTRUCTION ws.new -> ws.frame \n"
		"	INSTRUCTION ws.get_fin ws.frame -> BLN \n"
		"	INSTRUCTION ws.set_fin MUTABLE ws.frame BLN \n"
		"	INSTRUCTION ws.get_rsv ws.frame INT -> BLN \n"
		"	INSTRUCTION ws.set_rsv MUTABLE ws.frame INT BLN \n"
		"	INTERRUPTION ws.bad_opcode \n"
		"	INSTRUCTION ws.get_opcode ws.frame -> INT \n"
		"	INSTRUCTION ws.set_opcode MUTABLE ws.frame [ INT 'CONTINUE' 'TEXT' 'BINARY' 'END' 'PING' 'PONG' ] \n"
		"	INSTRUCTION ws.get_mask ws.frame -> STR ? \n"
		"	INSTRUCTION ws.set_mask MUTABLE ws.frame STR ? \n"
		"	INSTRUCTION ws.get_payload ws.frame -> STR \n"
		"	INSTRUCTION ws.set_payload MUTABLE ws.frame STR \n"
		"	INSTRUCTION ws.explain ws.frame -> STR \n"
		,SVM_API_SIGNATURE,SVM_VERSION);
}

#ifndef ARGV_VALUE
#define ARGV_VALUE(index,type) ::svm_value_##type##_get(svm,::svm_parameter_value_get(svm,argv[(index)]))
#endif
#ifndef ARGV_PLUGIN
#define ARGV_PLUGIN(index,plugin,name) reinterpret_cast<type_##name*>(::svm_value_plugin_get_internal(svm,::svm_parameter_value_get(svm,argv[(index)])))
#endif
#ifndef ARGV_MARKER
#define ARGV_MARKER(index) std::string(::svm_parameter_marker_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_KEYWORD
#define ARGV_KEYWORD(index) std::string(::svm_parameter_keyword_get(svm,argv[(index)]).string)
#endif
#ifndef ARGV_STRUCT
#define ARGV_STRUCT(index,plugin,name) reinterpret_cast<struct_##name*>(::svm_structure_get_internal(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),::svm_parameter_structure_get(svm,argv[(index)])))
#endif
#ifndef ARGV_VARIABLE
#define ARGV_VARIABLE(index) ::svm_parameter_variable_get(svm,argv[(index)]);
#endif
#ifndef NEW_VALUE
#define NEW_VALUE(type,value) ::svm_value_##type##_new(svm,(value))
#endif
#ifndef NEW_PLUGIN
#define NEW_PLUGIN(plugin,name,value) ::svm_value_plugin_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRUCT
#define NEW_STRUCT(plugin,name,value) ::svm_structure_new(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),(value))
#endif
#ifndef NEW_STRING
#define NEW_STRING(raw_string) ::svm_string_new(svm,raw_string.c_str(),raw_string.size())
#endif
#ifndef RAW_STRING
#define RAW_STRING(svm_string) std::string(svm_string.string,svm_string.size)
#endif
#ifndef NEW_BOOLEAN
#define NEW_BOOLEAN(boolean) ((boolean)?TRUE:FALSE)
#endif
#ifndef RAW_BOOLEAN
#define RAW_BOOLEAN(boolean) ((boolean)==TRUE)
#endif
#ifndef NEW_NULL_VALUE
#define NEW_NULL_VALUE(type) ::svm_value_##type##_new_null(svm)
#endif
#ifndef NEW_NULL_PLUGIN
#define NEW_NULL_PLUGIN(plugin,name) ::svm_value_plugin_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef NEW_NULL_STRUCT
#define NEW_NULL_STRUCT(plugin,name) ::svm_structure_new_null(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name))
#endif
#ifndef ERROR_INTERNAL
#define ERROR_INTERNAL(irq,message) ::svm_processor_current_raise_error_internal__raw(svm,irq,message)
#endif
#ifndef ERROR_EXTERNAL
#define ERROR_EXTERNAL(plugin,name,message) ::svm_processor_current_raise_error_external__raw(svm,::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name),message)
#endif
#ifndef CONST_PEP
#define CONST_PEP(plugin,name) ::svm_value_pluginentrypoint_new__raw(svm,#plugin,#name)
#endif
#ifndef CURRENT
#define CURRENT(object) ::svm_##object##_get_current(svm)
#endif
#ifndef RETURN
#define RETURN return nullptr
#endif
#ifndef VARIABLE_GLOBAL
#define VARIABLE_GLOBAL(variable) ::svm_variable_scope_set_global(svm,(variable))
#endif
#ifndef VARIABLE_LOCAL
#define VARIABLE_LOCAL(variable) ::svm_variable_scope_set_local(svm,(variable))
#endif
#ifndef VARIABLE_DELETE
#define VARIABLE_DELETE(variable) ::svm_variable_delete(svm,(variable))
#endif

}

#line 149 "../plugins/ws/core/ws.svm_plugin"
struct WS
{
	typedef enum {
		CONTINUATION = 0,
		TEXTE = 1,
		BINAIRE = 2,
		FIN = 8,
		PING = 9,
		PONG = 10
		} OpCode;
	WS()
	:_valide(false), _fin(false), _reserve1(false), _reserve2(false), _reserve3(false), _opcode(0) {}
	WS(const bool fin, const char op_code)
	:_valide(true), _fin(fin), _reserve1(false), _reserve2(false), _reserve3(false), _opcode(op_code) {}
	static bool requete_ws_complete(const std::string& tampon, const bool fin, uint64_t& taille, bool& evacue)
	{
		evacue = false;
		if(tampon.size()<2) return false;
		taille=static_cast<uint64_t>(static_cast<unsigned char>(tampon[1])) bitand 0x7F;
		if(taille==126)
		{
			if(tampon.size()<4) return false;
			taille = 4 + (static_cast<uint64_t>(static_cast<unsigned char>(tampon[2])) << 8) + (static_cast<uint64_t>(static_cast<unsigned char>(tampon[3])));
		}
		else if(taille==127)
		{
			if(tampon.size()<10) return false;
			taille = 10 + (static_cast<uint64_t>(static_cast<unsigned char>(tampon[2])) << 56) + (static_cast<uint64_t>(static_cast<unsigned char>(tampon[3])) << 48) + (static_cast<uint64_t>(static_cast<unsigned char>(tampon[4])) << 40) + (static_cast<uint64_t>(static_cast<unsigned char>(tampon[5])) << 32) + (static_cast<uint64_t>(static_cast<unsigned char>(tampon[6])) << 24) + (static_cast<uint64_t>(static_cast<unsigned char>(tampon[7])) << 16) + (static_cast<uint64_t>(static_cast<unsigned char>(tampon[8])) << 8) + static_cast<uint64_t>(static_cast<unsigned char>(tampon[9]));
		}
		else
		{
			taille += 2;
		}
		bool masque = (static_cast<size_t>(static_cast<unsigned char>(tampon[1])) & 0x80) >0;
		if(masque)
		{
			taille += 4;
		}
		if(fin and tampon.size()<taille)
		{
			evacue = true;
			taille = tampon.size();
			return false;
		}
		return tampon.size()>=taille;
	}
	static WS decode_ws(const std::string& requete)
	{
		if(requete.size()<2) return WS();
		WS ws;
		ws._fin = (static_cast<unsigned char>(requete[0]) & 0x80)>0;
		ws._reserve1 = (static_cast<unsigned char>(requete[0]) & 0x40) > 0;
		ws._reserve2 = (static_cast<unsigned char>(requete[0]) & 0x20) > 0;
		ws._reserve3 = (static_cast<unsigned char>(requete[0]) & 0x10) > 0;
		ws._opcode = (static_cast<unsigned char>(requete[0]) & 0x0F);
		bool masque = (static_cast<unsigned char>(requete[1]) & 0x80) > 0;
		uint64_t taille = (static_cast<unsigned char>(requete[1]) & 0x7F);
		size_t entetes = 2;
		if(taille==126)
		{
			if(requete.size()<4)
			{
				return WS();
			}
			entetes = 4;
			taille = (static_cast<uint64_t>(static_cast<unsigned char>(requete[2])) << 8) + static_cast<uint64_t>(static_cast<unsigned char>(requete[3]));
		
		}
		else if(taille==127)
		{
			if(requete.size()<10)
			{
				return WS();
			}
			entetes = 10;
			taille = (static_cast<uint64_t>(static_cast<unsigned char>(requete[2])) << 56) + (static_cast<uint64_t>(static_cast<unsigned char>(requete[3])) << 48) + (static_cast<uint64_t>(static_cast<unsigned char>(requete[4])) << 40) + (static_cast<uint64_t>(static_cast<unsigned char>(requete[5])) << 32) + (static_cast<uint64_t>(static_cast<unsigned char>(requete[6])) << 24) + (static_cast<uint64_t>(static_cast<unsigned char>(requete[7])) << 16) + (static_cast<uint64_t>(static_cast<unsigned char>(requete[8])) << 8) + static_cast<uint64_t>(static_cast<unsigned char>(requete[9]));
		}
		if(masque)
		{
			if(requete.size()<entetes+4)
			{
				return WS();
			}
			ws._masque = requete.substr(entetes,4);	
			entetes += 4;
		}
		ws._message = requete.substr(entetes);
		if(ws._message.size()!=taille)
		{
			return WS();
		}
		if(masque)
		{
			for(size_t i=0 ; i<ws._message.length() ; ++i)
			{
				ws._message[i] ^= ws._masque[i%4];
			}
		}
		ws._valide = true;
		return ws;
	}
	static std::string encode_ws(const WS& ws)
	{
		std::string tampon;
		unsigned char premier = (ws._fin ? (1 << 7) : 0) bitor (ws._reserve1 ? (1 << 6) : 0) bitor (ws._reserve2 ? (1 << 5) : 0)  bitor (ws._reserve3 ? (1 << 4) : 0) bitor (ws._opcode & 0x0F);
		tampon += premier;
		unsigned char second = (ws._masque.empty() ? 0 : (1 << 7));
		uint64_t taille = ws._message.size();
		if(taille<=125)
		{
			second |= (taille & 0x7F);
			tampon += second;
		}
		else if(taille<=65536)
		{
			second |= 126;
			tampon += second;
			tampon += (unsigned char)(taille>>8);
			tampon += (unsigned char)(taille & 0xFF);
		}
		else
		{
			second |= 127;
			tampon += second;
			tampon += (unsigned char)(taille>>56);
			tampon += (unsigned char)(taille>>48 & 0xFF);
			tampon += (unsigned char)(taille>>40 & 0xFF);
			tampon += (unsigned char)(taille>>32 & 0xFF);
			tampon += (unsigned char)(taille>>24 & 0xFF);
			tampon += (unsigned char)(taille>>16 & 0xFF);
			tampon += (unsigned char)(taille>>8 & 0xFF);
			tampon += (unsigned char)(taille & 0xFF);
		}
		std::string message = ws._message;
		if(not ws._masque.empty())
		{
			if(ws._masque.size()!=4)
			{
				return std::string();
			}
			tampon += ws._masque;
			std::string clef(ws._masque);
			for(size_t i=0 ; i<message.length() ; ++i)
			{
				message[i] ^= clef[i%4];
			}
		}
		tampon += message;
		return tampon;
	}
	bool& reservation(const int indice)
	{
		switch(indice)
		{
			case 1:
				return _reserve1;
				break;
			case 2:
				return _reserve2;
				break;
			case 3:
				return _reserve3;
			default:
				throw 0;
				break;
		}
	}
	template<typename Flux>
	friend Flux& operator<<(Flux& f, const WS& w)
	{
		f	<< "WS " << (w._valide?"":"in") << "valid" << std::endl
			<< "End: " << w._fin << std::endl
			<< "Reserved1: " << w._reserve1 << std::endl
			<< "Reserved2: " << w._reserve2 << std::endl
			<< "Reserved3: " << w._reserve3 << std::endl
			<< "OpCode: ";
		switch(w._opcode)
		{
			case CONTINUATION:
				f << "CONTINUATION";
				break;
			case TEXTE:
				f << "TEXT";
				break;
			case BINAIRE:
				f << "BINARY";
				break;
			case FIN:
				f << "END";
				break;
			case PING:
				f << "PING";
				break;
			case PONG:
				f << "PONG";
				break;
			default:
				f << "invalid";
				break;
		}
		f	<< std::endl
			<< "Size: " << w._message.size() << std::endl
			<< "Mask: " << WS::encode_hex(w._masque) << std::endl
			<< "Payload: " << ((w._opcode==TEXTE)?w._message:WS::encode_hex(w._message)) << std::endl;
		return f;
	}
	operator bool () const { return _valide; }
	bool _valide;
	bool _fin;
	bool _reserve1;
	bool _reserve2;
	bool _reserve3;
	unsigned char _opcode;
	std::string _masque;
	std::string _message;
	static bool opcode_valide(const int opcode)
	{
		switch(opcode)
		{
			case OpCode::CONTINUATION:
			case OpCode::TEXTE:
			case OpCode::BINAIRE:
			case OpCode::FIN:
			case OpCode::PING:
			case OpCode::PONG:
				return true;
			default:
				return false;
		}
	}
	static std::string encode_hex(const std::string& source)
	{
		std::string resultat;
		for(const auto& c: source)
		{
			unsigned char cc=c;
			unsigned char hc = cc >> 4;
			unsigned char lc = cc & 0xF;
			resultat += WS::caractere_hex(hc);
			resultat += WS::caractere_hex(lc);
		}
		return resultat;
	}
	static unsigned char caractere_hex(unsigned char c)
	{
		if(c>=10)
			return 'a'+c-10;
		return '0'+c;
	}
};
#line 394 "src/plugin.cpp"

extern "C"
{

/* FUNCTION ws.protocol_frame STR BLN -> INT ? */

SVM_Variable function_protocol_frame(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 419 "../plugins/ws/core/ws.svm_plugin"
	SVM_String tampon_brut = ARGV_VALUE(0,string);
	std::string tampon(tampon_brut.string,tampon_brut.size);
	SVM_Boolean fin = ARGV_VALUE(1,boolean);
	uint64_t taille;
	bool evacuation;
	bool trouve = WS::requete_ws_complete(tampon,fin==TRUE,taille,evacuation);
	if(trouve)
	{
		ssize_t t = taille;
		if(evacuation) t *= -1;
		return NEW_VALUE(integer,t);
	}
	return NEW_NULL_VALUE(integer);
#line 417 "src/plugin.cpp"
}


/* TYPE ws.frame */

struct type_frame
{
#line 440 "../plugins/ws/core/ws.svm_plugin"
	explicit type_frame(const WS& ws)
	:_ws(ws) {}
	WS _ws;
#line 429 "src/plugin.cpp"
};

void type_frame_delete(const void *svm, void *handler)
{
	type_frame * const object = reinterpret_cast<type_frame*>(handler);
	{
#line 445 "../plugins/ws/core/ws.svm_plugin"

#line 438 "src/plugin.cpp"
	}
	delete object;
}

void* type_frame_copy(const void *svm, const void *handler)
{
	const type_frame *object = reinterpret_cast<const type_frame*>(handler);
	type_frame *copy = new type_frame(*object);
	{
#line 446 "../plugins/ws/core/ws.svm_plugin"

#line 450 "src/plugin.cpp"
	}
	return copy;
}

SVM_String type_frame_print(const void *svm, const void *handler)
{
	const type_frame *object = reinterpret_cast<const type_frame*>(handler);
	{
#line 448 "../plugins/ws/core/ws.svm_plugin"
	std::string texte = WS::encode_ws(object->_ws);
	return NEW_STRING(texte);
#line 462 "src/plugin.cpp"
	}
}


/* INTERRUPTION ws.bad_frame */


/* INSTRUCTION ws.decode STR -> ws.frame */

SVM_Value instruction_decode(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 463 "../plugins/ws/core/ws.svm_plugin"
	SVM_String texte = ARGV_VALUE(0,string);
	type_frame *trame = new type_frame(WS::decode_ws(std::string(texte.string,texte.size)));
	if(not trame->_ws._valide)
	{
		delete trame;
		ERROR_EXTERNAL(ws,bad_frame,"Invalid WebSocket frame");
	}
	return NEW_PLUGIN(ws,frame,trame);
#line 483 "src/plugin.cpp"
}


/* INSTRUCTION ws.encode ws.frame -> STR */

SVM_Value instruction_encode(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 482 "../plugins/ws/core/ws.svm_plugin"
	type_frame *trame = ARGV_PLUGIN(0,ws,frame);
	if(not trame->_ws._valide)
	{
		ERROR_EXTERNAL(ws,bad_frame,"Invalid WebSocket frame");
	}
	std::string texte = WS::encode_ws(trame->_ws);
	return ::svm_value_string_new__buffer(svm,texte.c_str(),texte.size());
#line 499 "src/plugin.cpp"
}


/* INSTRUCTION ws.new -> ws.frame */

SVM_Value instruction_new(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 498 "../plugins/ws/core/ws.svm_plugin"
	type_frame *trame = new type_frame(WS(true,WS::OpCode::TEXTE));
	return NEW_PLUGIN(ws,frame,trame);
#line 510 "src/plugin.cpp"
}


/* INSTRUCTION ws.get_fin ws.frame -> BLN */

SVM_Value instruction_get_fin(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 510 "../plugins/ws/core/ws.svm_plugin"
	type_frame *trame = ARGV_PLUGIN(0,ws,frame);
	return NEW_VALUE(boolean,trame->_ws._fin?TRUE:FALSE);
#line 521 "src/plugin.cpp"
}


/* INSTRUCTION ws.set_fin MUTABLE ws.frame BLN */

SVM_Value instruction_set_fin(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 520 "../plugins/ws/core/ws.svm_plugin"
	type_frame *trame = ARGV_PLUGIN(0,ws,frame);
	SVM_Boolean fin = ARGV_VALUE(1,boolean);
	trame->_ws._fin = fin==TRUE;
#line 533 "src/plugin.cpp"
	return nullptr;
}


/* INSTRUCTION ws.get_rsv ws.frame INT -> BLN */

SVM_Value instruction_get_rsv(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 531 "../plugins/ws/core/ws.svm_plugin"
	type_frame *trame = ARGV_PLUGIN(0,ws,frame);
	auto indice = ARGV_VALUE(1,integer);
	try
	{
		bool valeur = trame->_ws.reservation(indice);
		return NEW_VALUE(boolean,valeur?TRUE:FALSE);
	}
	catch(...)
	{
		ERROR_INTERNAL(FAILURE,"Invalid index");
		throw;
	}
#line 555 "src/plugin.cpp"
}


/* INSTRUCTION ws.set_rsv MUTABLE ws.frame INT BLN */

SVM_Value instruction_set_rsv(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 553 "../plugins/ws/core/ws.svm_plugin"
	type_frame *trame = ARGV_PLUGIN(0,ws,frame);
	auto indice = ARGV_VALUE(1,integer);
	auto valeur = ARGV_VALUE(2,boolean);
	try
	{
		bool& v = trame->_ws.reservation(indice);
		v=valeur==TRUE;
	}
	catch(...)
	{
		ERROR_INTERNAL(FAILURE,"Invalid index");
		throw;
	}
#line 577 "src/plugin.cpp"
	return nullptr;
}


/* INTERRUPTION ws.bad_opcode */


/* INSTRUCTION ws.get_opcode ws.frame -> INT */

SVM_Value instruction_get_opcode(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 579 "../plugins/ws/core/ws.svm_plugin"
	type_frame *trame = ARGV_PLUGIN(0,ws,frame);
	return NEW_VALUE(integer,trame->_ws._opcode);
#line 592 "src/plugin.cpp"
}


/* INSTRUCTION ws.set_opcode MUTABLE ws.frame [ INT 'CONTINUE' 'TEXT' 'BINARY' 'END' 'PING' 'PONG' ] */

SVM_Value instruction_set_opcode(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 589 "../plugins/ws/core/ws.svm_plugin"
	type_frame *trame = ARGV_PLUGIN(0,ws,frame);
	int opcode = -1;
	if(::svm_parameter_type_is_keyword(svm,argv[1]))
	{
		std::string texte = ARGV_KEYWORD(1);
		if(texte=="CONTINUE") opcode = 0;
		if(texte=="TEXT") opcode = 1;
		if(texte=="BINARY") opcode = 2;
		if(texte=="END") opcode = 8;
		if(texte=="PING") opcode = 9;
		if(texte=="PONG") opcode = 10;
	}
	else
	{
		opcode = ARGV_VALUE(1,integer);
	}
	if(not WS::opcode_valide(opcode))
	{
		ERROR_EXTERNAL(ws,bad_opcode,"Invalid operational code");
	}
	trame->_ws._opcode = opcode;
#line 622 "src/plugin.cpp"
	return nullptr;
}


/* INSTRUCTION ws.get_mask ws.frame -> STR ? */

SVM_Value instruction_get_mask(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 620 "../plugins/ws/core/ws.svm_plugin"
	type_frame *trame = ARGV_PLUGIN(0,ws,frame);
	if(trame->_ws._masque.empty())
	{
		return NEW_NULL_VALUE(string);
	}
	return ::svm_value_string_new__buffer(svm,trame->_ws._masque.c_str(),trame->_ws._masque.size());
#line 638 "src/plugin.cpp"
}


/* INSTRUCTION ws.set_mask MUTABLE ws.frame STR ? */

SVM_Value instruction_set_mask(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 636 "../plugins/ws/core/ws.svm_plugin"
	type_frame *trame = ARGV_PLUGIN(0,ws,frame);
	if(argc>1)
	{
		SVM_String masque = ARGV_VALUE(1,string);
		if(masque.size != 4)
		{
			ERROR_INTERNAL(FAILURE,"Invalid mask size");
		}
		trame->_ws._masque = std::string(masque.string,masque.size);
	}
	else
	{
		trame->_ws._masque = "";
	}
#line 661 "src/plugin.cpp"
	return nullptr;
}


/* INSTRUCTION ws.get_payload ws.frame -> STR */

SVM_Value instruction_get_payload(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 661 "../plugins/ws/core/ws.svm_plugin"
	type_frame *trame = ARGV_PLUGIN(0,ws,frame);
	return ::svm_value_string_new__buffer(svm,trame->_ws._message.c_str(),trame->_ws._message.size());
#line 673 "src/plugin.cpp"
}


/* INSTRUCTION ws.set_payload MUTABLE ws.frame STR */

SVM_Value instruction_set_payload(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 671 "../plugins/ws/core/ws.svm_plugin"
	type_frame *trame = ARGV_PLUGIN(0,ws,frame);
	SVM_String contenu = ARGV_VALUE(1,string);
	trame->_ws._message = std::string(contenu.string,contenu.size);
#line 685 "src/plugin.cpp"
	return nullptr;
}


/* INSTRUCTION ws.explain ws.frame -> STR */

SVM_Value instruction_explain(const void *svm, SVM_Size argc, SVM_Parameter argv[])
{
#line 682 "../plugins/ws/core/ws.svm_plugin"
	type_frame *trame = ARGV_PLUGIN(0,ws,frame);
	std::ostringstream oss;
	oss << trame->_ws ;
	return ::svm_value_string_new__buffer(svm,oss.str().c_str(),oss.str().size());
#line 699 "src/plugin.cpp"
}


/* Generic handling functions */

}
