; Tests to ensure .ismnemonic is working correctly
; The .ismnemonic function calls FindInstruction internally,
; which is how the assembler detects all instructions
;
; Currently supported CPUs:
;    "6502"
;    "6502X"
;    "6502DTV"
;    "65SC02"
;    "65C02"
;    "65CE02"
;    "W65C02"
;    "4510"
;    "45GS02"
;    "huc6280"
;    "65816"
;    "sweet16"

; count any errors:
ismnemonic_error .set 0

; macro to test an instruction
.macro test_Ismnemonic instr
    .if .ismnemonic(instr)
        ; do nothing
    .else
        ismnemonic_error .set 1
    .endif
.endmacro

; test .feature ubiquitous_idents

 ; allow overloading mnemonics
.feature ubiquitous_idents

.setcpu "6502"

; make an adc macro
.macro adc
.endmacro

; should not match
.if .ismnemonic(adc)
    ismnemonic_error .set 1
.endif

.delmac adc

; test all instructions:

; there is no instruction table for "none", make sure 'adc' (common to all CPUs) and 'add' (sweet16) doesn't match
.setcpu "none"
.if .ismnemonic(adc) || .ismnemonic(add)
    ismnemonic_error .set 1
.endif

.setcpu "6502"
test_Ismnemonic adc
test_Ismnemonic and
test_Ismnemonic asl
test_Ismnemonic bcc
test_Ismnemonic bcs
test_Ismnemonic beq
test_Ismnemonic bit
test_Ismnemonic bmi
test_Ismnemonic bne
test_Ismnemonic bpl
test_Ismnemonic brk
test_Ismnemonic bvc
test_Ismnemonic bvs
test_Ismnemonic clc
test_Ismnemonic cld
test_Ismnemonic cli
test_Ismnemonic clv
test_Ismnemonic cmp
test_Ismnemonic cpx
test_Ismnemonic cpy
test_Ismnemonic dec
test_Ismnemonic dex
test_Ismnemonic dey
test_Ismnemonic eor
test_Ismnemonic inc
test_Ismnemonic inx
test_Ismnemonic iny
test_Ismnemonic jmp
test_Ismnemonic jsr
test_Ismnemonic lda
test_Ismnemonic ldx
test_Ismnemonic ldy
test_Ismnemonic lsr
test_Ismnemonic nop
test_Ismnemonic ora
test_Ismnemonic pha
test_Ismnemonic php
test_Ismnemonic pla
test_Ismnemonic plp
test_Ismnemonic rol
test_Ismnemonic ror
test_Ismnemonic rti
test_Ismnemonic rts
test_Ismnemonic sbc
test_Ismnemonic sec
test_Ismnemonic sed
test_Ismnemonic sei
test_Ismnemonic sta
test_Ismnemonic stx
test_Ismnemonic sty
test_Ismnemonic tax
test_Ismnemonic tay
test_Ismnemonic tsx
test_Ismnemonic txa
test_Ismnemonic txs
test_Ismnemonic tya

.setcpu "6502X"
test_Ismnemonic adc
test_Ismnemonic alr
test_Ismnemonic anc
test_Ismnemonic and
test_Ismnemonic ane
test_Ismnemonic arr
test_Ismnemonic asl
test_Ismnemonic axs
test_Ismnemonic bcc
test_Ismnemonic bcs
test_Ismnemonic beq
test_Ismnemonic bit
test_Ismnemonic bmi
test_Ismnemonic bne
test_Ismnemonic bpl
test_Ismnemonic brk
test_Ismnemonic bvc
test_Ismnemonic bvs
test_Ismnemonic clc
test_Ismnemonic cld
test_Ismnemonic cli
test_Ismnemonic clv
test_Ismnemonic cmp
test_Ismnemonic cpx
test_Ismnemonic cpy
test_Ismnemonic dcp
test_Ismnemonic dec
test_Ismnemonic dex
test_Ismnemonic dey
test_Ismnemonic eor
test_Ismnemonic inc
test_Ismnemonic inx
test_Ismnemonic iny
test_Ismnemonic isc
test_Ismnemonic jam
test_Ismnemonic jmp
test_Ismnemonic jsr
test_Ismnemonic las
test_Ismnemonic lax
test_Ismnemonic lda
test_Ismnemonic ldx
test_Ismnemonic ldy
test_Ismnemonic lsr
test_Ismnemonic nop
test_Ismnemonic ora
test_Ismnemonic pha
test_Ismnemonic php
test_Ismnemonic pla
test_Ismnemonic plp
test_Ismnemonic rla
test_Ismnemonic rol
test_Ismnemonic ror
test_Ismnemonic rra
test_Ismnemonic rti
test_Ismnemonic rts
test_Ismnemonic sax
test_Ismnemonic sbc
test_Ismnemonic sec
test_Ismnemonic sed
test_Ismnemonic sei
test_Ismnemonic sha
test_Ismnemonic shx
test_Ismnemonic shy
test_Ismnemonic slo
test_Ismnemonic sre
test_Ismnemonic sta
test_Ismnemonic stx
test_Ismnemonic sty
test_Ismnemonic tas
test_Ismnemonic tax
test_Ismnemonic tay
test_Ismnemonic tsx
test_Ismnemonic txa
test_Ismnemonic txs
test_Ismnemonic tya

.setcpu "6502DTV"
test_Ismnemonic adc
test_Ismnemonic alr
test_Ismnemonic anc
test_Ismnemonic and
test_Ismnemonic ane
test_Ismnemonic arr
test_Ismnemonic asl
test_Ismnemonic axs
test_Ismnemonic bcc
test_Ismnemonic bcs
test_Ismnemonic beq
test_Ismnemonic bit
test_Ismnemonic bmi
test_Ismnemonic bne
test_Ismnemonic bpl
test_Ismnemonic bra
test_Ismnemonic brk
test_Ismnemonic bvc
test_Ismnemonic bvs
test_Ismnemonic clc
test_Ismnemonic cld
test_Ismnemonic cli
test_Ismnemonic clv
test_Ismnemonic cmp
test_Ismnemonic cpx
test_Ismnemonic cpy
test_Ismnemonic dec
test_Ismnemonic dex
test_Ismnemonic dey
test_Ismnemonic eor
test_Ismnemonic inc
test_Ismnemonic inx
test_Ismnemonic iny
test_Ismnemonic jmp
test_Ismnemonic jsr
test_Ismnemonic las
test_Ismnemonic lax
test_Ismnemonic lda
test_Ismnemonic ldx
test_Ismnemonic ldy
test_Ismnemonic lsr
test_Ismnemonic nop
test_Ismnemonic ora
test_Ismnemonic pha
test_Ismnemonic php
test_Ismnemonic pla
test_Ismnemonic plp
test_Ismnemonic rla
test_Ismnemonic rol
test_Ismnemonic ror
test_Ismnemonic rra
test_Ismnemonic rti
test_Ismnemonic rts
test_Ismnemonic sac
test_Ismnemonic sbc
test_Ismnemonic sec
test_Ismnemonic sed
test_Ismnemonic sei
test_Ismnemonic sha
test_Ismnemonic shx
test_Ismnemonic shy
test_Ismnemonic sir
test_Ismnemonic sta
test_Ismnemonic stx
test_Ismnemonic sty
test_Ismnemonic tax
test_Ismnemonic tay
test_Ismnemonic tsx
test_Ismnemonic txa
test_Ismnemonic txs
test_Ismnemonic tya

.setcpu "65SC02"
test_Ismnemonic adc
test_Ismnemonic and
test_Ismnemonic asl
test_Ismnemonic bcc
test_Ismnemonic bcs
test_Ismnemonic beq
test_Ismnemonic bit
test_Ismnemonic bmi
test_Ismnemonic bne
test_Ismnemonic bpl
test_Ismnemonic bra
test_Ismnemonic brk
test_Ismnemonic bvc
test_Ismnemonic bvs
test_Ismnemonic clc
test_Ismnemonic cld
test_Ismnemonic cli
test_Ismnemonic clv
test_Ismnemonic cmp
test_Ismnemonic cpx
test_Ismnemonic cpy
test_Ismnemonic dea
test_Ismnemonic dec
test_Ismnemonic dex
test_Ismnemonic dey
test_Ismnemonic eor
test_Ismnemonic ina
test_Ismnemonic inc
test_Ismnemonic inx
test_Ismnemonic iny
test_Ismnemonic jmp
test_Ismnemonic jsr
test_Ismnemonic lda
test_Ismnemonic ldx
test_Ismnemonic ldy
test_Ismnemonic lsr
test_Ismnemonic nop
test_Ismnemonic ora
test_Ismnemonic pha
test_Ismnemonic php
test_Ismnemonic phx
test_Ismnemonic phy
test_Ismnemonic pla
test_Ismnemonic plp
test_Ismnemonic plx
test_Ismnemonic ply
test_Ismnemonic rol
test_Ismnemonic ror
test_Ismnemonic rti
test_Ismnemonic rts
test_Ismnemonic sbc
test_Ismnemonic sec
test_Ismnemonic sed
test_Ismnemonic sei
test_Ismnemonic sta
test_Ismnemonic stx
test_Ismnemonic sty
test_Ismnemonic stz
test_Ismnemonic tax
test_Ismnemonic tay
test_Ismnemonic trb
test_Ismnemonic tsb
test_Ismnemonic tsx
test_Ismnemonic txa
test_Ismnemonic txs
test_Ismnemonic tya

.setcpu "65C02"
test_Ismnemonic adc
test_Ismnemonic and
test_Ismnemonic asl
test_Ismnemonic bbr0
test_Ismnemonic bbr1
test_Ismnemonic bbr2
test_Ismnemonic bbr3
test_Ismnemonic bbr4
test_Ismnemonic bbr5
test_Ismnemonic bbr6
test_Ismnemonic bbr7
test_Ismnemonic bbs0
test_Ismnemonic bbs1
test_Ismnemonic bbs2
test_Ismnemonic bbs3
test_Ismnemonic bbs4
test_Ismnemonic bbs5
test_Ismnemonic bbs6
test_Ismnemonic bbs7
test_Ismnemonic bcc
test_Ismnemonic bcs
test_Ismnemonic beq
test_Ismnemonic bit
test_Ismnemonic bmi
test_Ismnemonic bne
test_Ismnemonic bpl
test_Ismnemonic bra
test_Ismnemonic brk
test_Ismnemonic bvc
test_Ismnemonic bvs
test_Ismnemonic clc
test_Ismnemonic cld
test_Ismnemonic cli
test_Ismnemonic clv
test_Ismnemonic cmp
test_Ismnemonic cpx
test_Ismnemonic cpy
test_Ismnemonic dea
test_Ismnemonic dec
test_Ismnemonic dex
test_Ismnemonic dey
test_Ismnemonic eor
test_Ismnemonic ina
test_Ismnemonic inc
test_Ismnemonic inx
test_Ismnemonic iny
test_Ismnemonic jmp
test_Ismnemonic jsr
test_Ismnemonic lda
test_Ismnemonic ldx
test_Ismnemonic ldy
test_Ismnemonic lsr
test_Ismnemonic nop
test_Ismnemonic ora
test_Ismnemonic pha
test_Ismnemonic php
test_Ismnemonic phx
test_Ismnemonic phy
test_Ismnemonic pla
test_Ismnemonic plp
test_Ismnemonic plx
test_Ismnemonic ply
test_Ismnemonic rmb0
test_Ismnemonic rmb1
test_Ismnemonic rmb2
test_Ismnemonic rmb3
test_Ismnemonic rmb4
test_Ismnemonic rmb5
test_Ismnemonic rmb6
test_Ismnemonic rmb7
test_Ismnemonic rol
test_Ismnemonic ror
test_Ismnemonic rti
test_Ismnemonic rts
test_Ismnemonic sbc
test_Ismnemonic sec
test_Ismnemonic sed
test_Ismnemonic sei
test_Ismnemonic smb0
test_Ismnemonic smb1
test_Ismnemonic smb2
test_Ismnemonic smb3
test_Ismnemonic smb4
test_Ismnemonic smb5
test_Ismnemonic smb6
test_Ismnemonic smb7
test_Ismnemonic sta
test_Ismnemonic stx
test_Ismnemonic sty
test_Ismnemonic stz
test_Ismnemonic tax
test_Ismnemonic tay
test_Ismnemonic trb
test_Ismnemonic tsb
test_Ismnemonic tsx
test_Ismnemonic txa
test_Ismnemonic txs
test_Ismnemonic tya


.setcpu "W65C02"
test_Ismnemonic adc
test_Ismnemonic and
test_Ismnemonic asl
test_Ismnemonic bbr0
test_Ismnemonic bbr1
test_Ismnemonic bbr2
test_Ismnemonic bbr3
test_Ismnemonic bbr4
test_Ismnemonic bbr5
test_Ismnemonic bbr6
test_Ismnemonic bbr7
test_Ismnemonic bbs0
test_Ismnemonic bbs1
test_Ismnemonic bbs2
test_Ismnemonic bbs3
test_Ismnemonic bbs4
test_Ismnemonic bbs5
test_Ismnemonic bbs6
test_Ismnemonic bbs7
test_Ismnemonic bcc
test_Ismnemonic bcs
test_Ismnemonic beq
test_Ismnemonic bit
test_Ismnemonic bmi
test_Ismnemonic bne
test_Ismnemonic bpl
test_Ismnemonic bra
test_Ismnemonic brk
test_Ismnemonic bvc
test_Ismnemonic bvs
test_Ismnemonic clc
test_Ismnemonic cld
test_Ismnemonic cli
test_Ismnemonic clv
test_Ismnemonic cmp
test_Ismnemonic cpx
test_Ismnemonic cpy
test_Ismnemonic dea
test_Ismnemonic dec
test_Ismnemonic dex
test_Ismnemonic dey
test_Ismnemonic eor
test_Ismnemonic ina
test_Ismnemonic inc
test_Ismnemonic inx
test_Ismnemonic iny
test_Ismnemonic jmp
test_Ismnemonic jsr
test_Ismnemonic lda
test_Ismnemonic ldx
test_Ismnemonic ldy
test_Ismnemonic lsr
test_Ismnemonic nop
test_Ismnemonic ora
test_Ismnemonic pha
test_Ismnemonic php
test_Ismnemonic phx
test_Ismnemonic phy
test_Ismnemonic pla
test_Ismnemonic plp
test_Ismnemonic plx
test_Ismnemonic ply
test_Ismnemonic rmb0
test_Ismnemonic rmb1
test_Ismnemonic rmb2
test_Ismnemonic rmb3
test_Ismnemonic rmb4
test_Ismnemonic rmb5
test_Ismnemonic rmb6
test_Ismnemonic rmb7
test_Ismnemonic rol
test_Ismnemonic ror
test_Ismnemonic rti
test_Ismnemonic rts
test_Ismnemonic sbc
test_Ismnemonic sec
test_Ismnemonic sed
test_Ismnemonic sei
test_Ismnemonic smb0
test_Ismnemonic smb1
test_Ismnemonic smb2
test_Ismnemonic smb3
test_Ismnemonic smb4
test_Ismnemonic smb5
test_Ismnemonic smb6
test_Ismnemonic smb7
test_Ismnemonic sta
test_Ismnemonic stp
test_Ismnemonic stx
test_Ismnemonic sty
test_Ismnemonic stz
test_Ismnemonic tax
test_Ismnemonic tay
test_Ismnemonic trb
test_Ismnemonic tsb
test_Ismnemonic tsx
test_Ismnemonic txa
test_Ismnemonic txs
test_Ismnemonic tya
test_Ismnemonic wai

.setcpu "65CE02"
test_Ismnemonic adc
test_Ismnemonic and
test_Ismnemonic asl
test_Ismnemonic asr
test_Ismnemonic asw
test_Ismnemonic aug
test_Ismnemonic bbr0
test_Ismnemonic bbr1
test_Ismnemonic bbr2
test_Ismnemonic bbr3
test_Ismnemonic bbr4
test_Ismnemonic bbr5
test_Ismnemonic bbr6
test_Ismnemonic bbr7
test_Ismnemonic bbs0
test_Ismnemonic bbs1
test_Ismnemonic bbs2
test_Ismnemonic bbs3
test_Ismnemonic bbs4
test_Ismnemonic bbs5
test_Ismnemonic bbs6
test_Ismnemonic bbs7
test_Ismnemonic bcc
test_Ismnemonic bcs
test_Ismnemonic beq
test_Ismnemonic bit
test_Ismnemonic bmi
test_Ismnemonic bne
test_Ismnemonic bpl
test_Ismnemonic bra
test_Ismnemonic brk
test_Ismnemonic bsr
test_Ismnemonic bvc
test_Ismnemonic bvs
test_Ismnemonic clc
test_Ismnemonic cld
test_Ismnemonic cle
test_Ismnemonic cli
test_Ismnemonic clv
test_Ismnemonic cmp
test_Ismnemonic cpx
test_Ismnemonic cpy
test_Ismnemonic cpz
test_Ismnemonic dea
test_Ismnemonic dec
test_Ismnemonic dew
test_Ismnemonic dex
test_Ismnemonic dey
test_Ismnemonic dez
test_Ismnemonic eom
test_Ismnemonic eor
test_Ismnemonic ina
test_Ismnemonic inc
test_Ismnemonic inw
test_Ismnemonic inx
test_Ismnemonic iny
test_Ismnemonic inz
test_Ismnemonic jmp
test_Ismnemonic jsr
test_Ismnemonic lbcc
test_Ismnemonic lbcs
test_Ismnemonic lbeq
test_Ismnemonic lbmi
test_Ismnemonic lbne
test_Ismnemonic lbpl
test_Ismnemonic lbra
test_Ismnemonic lbvc
test_Ismnemonic lbvs
test_Ismnemonic lda
test_Ismnemonic ldx
test_Ismnemonic ldy
test_Ismnemonic ldz
test_Ismnemonic lsr
test_Ismnemonic neg
test_Ismnemonic nop
test_Ismnemonic ora
test_Ismnemonic pha
test_Ismnemonic phd
test_Ismnemonic php
test_Ismnemonic phw
test_Ismnemonic phx
test_Ismnemonic phy
test_Ismnemonic phz
test_Ismnemonic pla
test_Ismnemonic plp
test_Ismnemonic plx
test_Ismnemonic ply
test_Ismnemonic plz
test_Ismnemonic rmb0
test_Ismnemonic rmb1
test_Ismnemonic rmb2
test_Ismnemonic rmb3
test_Ismnemonic rmb4
test_Ismnemonic rmb5
test_Ismnemonic rmb6
test_Ismnemonic rmb7
test_Ismnemonic rol
test_Ismnemonic ror
test_Ismnemonic row
test_Ismnemonic rti
test_Ismnemonic rtn
test_Ismnemonic rts
test_Ismnemonic sbc
test_Ismnemonic sec
test_Ismnemonic sed
test_Ismnemonic see
test_Ismnemonic sei
test_Ismnemonic smb0
test_Ismnemonic smb1
test_Ismnemonic smb2
test_Ismnemonic smb3
test_Ismnemonic smb4
test_Ismnemonic smb5
test_Ismnemonic smb6
test_Ismnemonic smb7
test_Ismnemonic sta
test_Ismnemonic stx
test_Ismnemonic sty
test_Ismnemonic stz
test_Ismnemonic tab
test_Ismnemonic tax
test_Ismnemonic tay
test_Ismnemonic taz
test_Ismnemonic tba
test_Ismnemonic trb
test_Ismnemonic tsb
test_Ismnemonic tsx
test_Ismnemonic tsy
test_Ismnemonic txa
test_Ismnemonic txs
test_Ismnemonic tya
test_Ismnemonic tys
test_Ismnemonic tza

.setcpu "4510"
test_Ismnemonic adc
test_Ismnemonic and
test_Ismnemonic asl
test_Ismnemonic asr
test_Ismnemonic asw
test_Ismnemonic bbr0
test_Ismnemonic bbr1
test_Ismnemonic bbr2
test_Ismnemonic bbr3
test_Ismnemonic bbr4
test_Ismnemonic bbr5
test_Ismnemonic bbr6
test_Ismnemonic bbr7
test_Ismnemonic bbs0
test_Ismnemonic bbs1
test_Ismnemonic bbs2
test_Ismnemonic bbs3
test_Ismnemonic bbs4
test_Ismnemonic bbs5
test_Ismnemonic bbs6
test_Ismnemonic bbs7
test_Ismnemonic bcc
test_Ismnemonic bcs
test_Ismnemonic beq
test_Ismnemonic bit
test_Ismnemonic bmi
test_Ismnemonic bne
test_Ismnemonic bpl
test_Ismnemonic bra
test_Ismnemonic brk
test_Ismnemonic bsr
test_Ismnemonic bvc
test_Ismnemonic bvs
test_Ismnemonic clc
test_Ismnemonic cld
test_Ismnemonic cle
test_Ismnemonic cli
test_Ismnemonic clv
test_Ismnemonic cmp
test_Ismnemonic cpx
test_Ismnemonic cpy
test_Ismnemonic cpz
test_Ismnemonic dea
test_Ismnemonic dec
test_Ismnemonic dew
test_Ismnemonic dex
test_Ismnemonic dey
test_Ismnemonic dez
test_Ismnemonic eom
test_Ismnemonic eor
test_Ismnemonic ina
test_Ismnemonic inc
test_Ismnemonic inw
test_Ismnemonic inx
test_Ismnemonic iny
test_Ismnemonic inz
test_Ismnemonic jmp
test_Ismnemonic jsr
test_Ismnemonic lbcc
test_Ismnemonic lbcs
test_Ismnemonic lbeq
test_Ismnemonic lbmi
test_Ismnemonic lbne
test_Ismnemonic lbpl
test_Ismnemonic lbra
test_Ismnemonic lbvc
test_Ismnemonic lbvs
test_Ismnemonic lda
test_Ismnemonic ldx
test_Ismnemonic ldy
test_Ismnemonic ldz
test_Ismnemonic lsr
test_Ismnemonic map
test_Ismnemonic neg
test_Ismnemonic nop
test_Ismnemonic ora
test_Ismnemonic pha
test_Ismnemonic phd
test_Ismnemonic php
test_Ismnemonic phw
test_Ismnemonic phx
test_Ismnemonic phy
test_Ismnemonic phz
test_Ismnemonic pla
test_Ismnemonic plp
test_Ismnemonic plx
test_Ismnemonic ply
test_Ismnemonic plz
test_Ismnemonic rmb0
test_Ismnemonic rmb1
test_Ismnemonic rmb2
test_Ismnemonic rmb3
test_Ismnemonic rmb4
test_Ismnemonic rmb5
test_Ismnemonic rmb6
test_Ismnemonic rmb7
test_Ismnemonic rol
test_Ismnemonic ror
test_Ismnemonic row
test_Ismnemonic rti
test_Ismnemonic rtn
test_Ismnemonic rts
test_Ismnemonic sbc
test_Ismnemonic sec
test_Ismnemonic sed
test_Ismnemonic see
test_Ismnemonic sei
test_Ismnemonic smb0
test_Ismnemonic smb1
test_Ismnemonic smb2
test_Ismnemonic smb3
test_Ismnemonic smb4
test_Ismnemonic smb5
test_Ismnemonic smb6
test_Ismnemonic smb7
test_Ismnemonic sta
test_Ismnemonic stx
test_Ismnemonic sty
test_Ismnemonic stz
test_Ismnemonic tab
test_Ismnemonic tax
test_Ismnemonic tay
test_Ismnemonic taz
test_Ismnemonic tba
test_Ismnemonic trb
test_Ismnemonic tsb
test_Ismnemonic tsx
test_Ismnemonic tsy
test_Ismnemonic txa
test_Ismnemonic txs
test_Ismnemonic tya
test_Ismnemonic tys
test_Ismnemonic tza

.setcpu "45GS02"
test_Ismnemonic adc
test_Ismnemonic and
test_Ismnemonic asl
test_Ismnemonic asr
test_Ismnemonic asw
test_Ismnemonic bbr0
test_Ismnemonic bbr1
test_Ismnemonic bbr2
test_Ismnemonic bbr3
test_Ismnemonic bbr4
test_Ismnemonic bbr5
test_Ismnemonic bbr6
test_Ismnemonic bbr7
test_Ismnemonic bbs0
test_Ismnemonic bbs1
test_Ismnemonic bbs2
test_Ismnemonic bbs3
test_Ismnemonic bbs4
test_Ismnemonic bbs5
test_Ismnemonic bbs6
test_Ismnemonic bbs7
test_Ismnemonic bcc
test_Ismnemonic bcs
test_Ismnemonic beq
test_Ismnemonic bit
test_Ismnemonic bmi
test_Ismnemonic bne
test_Ismnemonic bpl
test_Ismnemonic bra
test_Ismnemonic brk
test_Ismnemonic bsr
test_Ismnemonic bvc
test_Ismnemonic bvs
test_Ismnemonic clc
test_Ismnemonic cld
test_Ismnemonic cle
test_Ismnemonic cli
test_Ismnemonic clv
test_Ismnemonic cmp
test_Ismnemonic cpx
test_Ismnemonic cpy
test_Ismnemonic cpz
test_Ismnemonic dea
test_Ismnemonic dec
test_Ismnemonic dew
test_Ismnemonic dex
test_Ismnemonic dey
test_Ismnemonic dez
test_Ismnemonic eom
test_Ismnemonic eor
test_Ismnemonic ina
test_Ismnemonic inc
test_Ismnemonic inw
test_Ismnemonic inx
test_Ismnemonic iny
test_Ismnemonic inz
test_Ismnemonic jmp
test_Ismnemonic jsr
test_Ismnemonic lbcc
test_Ismnemonic lbcs
test_Ismnemonic lbeq
test_Ismnemonic lbmi
test_Ismnemonic lbne
test_Ismnemonic lbpl
test_Ismnemonic lbra
test_Ismnemonic lbvc
test_Ismnemonic lbvs
test_Ismnemonic lda
test_Ismnemonic ldx
test_Ismnemonic ldy
test_Ismnemonic ldz
test_Ismnemonic lsr
test_Ismnemonic map
test_Ismnemonic neg
test_Ismnemonic nop
test_Ismnemonic ora
test_Ismnemonic pha
test_Ismnemonic phd
test_Ismnemonic php
test_Ismnemonic phw
test_Ismnemonic phx
test_Ismnemonic phy
test_Ismnemonic phz
test_Ismnemonic pla
test_Ismnemonic plp
test_Ismnemonic plx
test_Ismnemonic ply
test_Ismnemonic plz
test_Ismnemonic rmb0
test_Ismnemonic rmb1
test_Ismnemonic rmb2
test_Ismnemonic rmb3
test_Ismnemonic rmb4
test_Ismnemonic rmb5
test_Ismnemonic rmb6
test_Ismnemonic rmb7
test_Ismnemonic rol
test_Ismnemonic ror
test_Ismnemonic row
test_Ismnemonic rti
test_Ismnemonic rtn
test_Ismnemonic rts
test_Ismnemonic sbc
test_Ismnemonic sec
test_Ismnemonic sed
test_Ismnemonic see
test_Ismnemonic sei
test_Ismnemonic smb0
test_Ismnemonic smb1
test_Ismnemonic smb2
test_Ismnemonic smb3
test_Ismnemonic smb4
test_Ismnemonic smb5
test_Ismnemonic smb6
test_Ismnemonic smb7
test_Ismnemonic sta
test_Ismnemonic stx
test_Ismnemonic sty
test_Ismnemonic stz
test_Ismnemonic tab
test_Ismnemonic tax
test_Ismnemonic tay
test_Ismnemonic taz
test_Ismnemonic tba
test_Ismnemonic trb
test_Ismnemonic tsb
test_Ismnemonic tsx
test_Ismnemonic tsy
test_Ismnemonic txa
test_Ismnemonic txs
test_Ismnemonic tya
test_Ismnemonic tys
test_Ismnemonic tza

test_Ismnemonic adcq
test_Ismnemonic andq
test_Ismnemonic aslq
test_Ismnemonic asrq
test_Ismnemonic bitq
test_Ismnemonic cmpq
test_Ismnemonic deq
test_Ismnemonic eorq
test_Ismnemonic inq
test_Ismnemonic ldq
test_Ismnemonic lsrq
test_Ismnemonic orq
test_Ismnemonic sbcq
test_Ismnemonic stq
test_Ismnemonic rolq
test_Ismnemonic rorq


.setcpu "HuC6280"
test_Ismnemonic adc
test_Ismnemonic and
test_Ismnemonic asl
test_Ismnemonic bbr0
test_Ismnemonic bbr1
test_Ismnemonic bbr2
test_Ismnemonic bbr3
test_Ismnemonic bbr4
test_Ismnemonic bbr5
test_Ismnemonic bbr6
test_Ismnemonic bbr7
test_Ismnemonic bbs0
test_Ismnemonic bbs1
test_Ismnemonic bbs2
test_Ismnemonic bbs3
test_Ismnemonic bbs4
test_Ismnemonic bbs5
test_Ismnemonic bbs6
test_Ismnemonic bbs7
test_Ismnemonic bcc
test_Ismnemonic bcs
test_Ismnemonic beq
test_Ismnemonic bit
test_Ismnemonic bmi
test_Ismnemonic bne
test_Ismnemonic bpl
test_Ismnemonic bra
test_Ismnemonic brk
test_Ismnemonic bsr
test_Ismnemonic bvc
test_Ismnemonic bvs
test_Ismnemonic cla
test_Ismnemonic clc
test_Ismnemonic cld
test_Ismnemonic cli
test_Ismnemonic clv
test_Ismnemonic clx
test_Ismnemonic cly
test_Ismnemonic cmp
test_Ismnemonic cpx
test_Ismnemonic cpy
test_Ismnemonic csh
test_Ismnemonic csl
test_Ismnemonic dea
test_Ismnemonic dec
test_Ismnemonic dex
test_Ismnemonic dey
test_Ismnemonic eor
test_Ismnemonic ina
test_Ismnemonic inc
test_Ismnemonic inx
test_Ismnemonic iny
test_Ismnemonic jmp
test_Ismnemonic jsr
test_Ismnemonic lda
test_Ismnemonic ldx
test_Ismnemonic ldy
test_Ismnemonic lsr
test_Ismnemonic nop
test_Ismnemonic ora
test_Ismnemonic pha
test_Ismnemonic php
test_Ismnemonic phx
test_Ismnemonic phy
test_Ismnemonic pla
test_Ismnemonic plp
test_Ismnemonic plx
test_Ismnemonic ply
test_Ismnemonic rmb0
test_Ismnemonic rmb1
test_Ismnemonic rmb2
test_Ismnemonic rmb3
test_Ismnemonic rmb4
test_Ismnemonic rmb5
test_Ismnemonic rmb6
test_Ismnemonic rmb7
test_Ismnemonic rol
test_Ismnemonic ror
test_Ismnemonic rti
test_Ismnemonic rts
test_Ismnemonic sax
test_Ismnemonic say
test_Ismnemonic sbc
test_Ismnemonic sec
test_Ismnemonic sed
test_Ismnemonic sei
test_Ismnemonic set
test_Ismnemonic smb0
test_Ismnemonic smb1
test_Ismnemonic smb2
test_Ismnemonic smb3
test_Ismnemonic smb4
test_Ismnemonic smb5
test_Ismnemonic smb6
test_Ismnemonic smb7
test_Ismnemonic st0
test_Ismnemonic st1
test_Ismnemonic st2
test_Ismnemonic sta
test_Ismnemonic stx
test_Ismnemonic sty
test_Ismnemonic stz
test_Ismnemonic sxy
test_Ismnemonic tai
test_Ismnemonic tam
test_Ismnemonic tam0
test_Ismnemonic tam1
test_Ismnemonic tam2
test_Ismnemonic tam3
test_Ismnemonic tam4
test_Ismnemonic tam5
test_Ismnemonic tam6
test_Ismnemonic tam7
test_Ismnemonic tax
test_Ismnemonic tay
test_Ismnemonic tdd
test_Ismnemonic tia
test_Ismnemonic tii
test_Ismnemonic tin
test_Ismnemonic tma
test_Ismnemonic tma0
test_Ismnemonic tma1
test_Ismnemonic tma2
test_Ismnemonic tma3
test_Ismnemonic tma4
test_Ismnemonic tma5
test_Ismnemonic tma6
test_Ismnemonic tma7
test_Ismnemonic trb
test_Ismnemonic tsb
test_Ismnemonic tst
test_Ismnemonic tsx
test_Ismnemonic txa
test_Ismnemonic txs
test_Ismnemonic tya

.setcpu "65816"
test_Ismnemonic adc
test_Ismnemonic and
test_Ismnemonic asl
test_Ismnemonic bcc
test_Ismnemonic bcs
test_Ismnemonic beq
test_Ismnemonic bit
test_Ismnemonic bmi
test_Ismnemonic bne
test_Ismnemonic bpl
test_Ismnemonic bra
test_Ismnemonic brk
test_Ismnemonic brl
test_Ismnemonic bvc
test_Ismnemonic bvs
test_Ismnemonic clc
test_Ismnemonic cld
test_Ismnemonic cli
test_Ismnemonic clv
test_Ismnemonic cmp
test_Ismnemonic cop
test_Ismnemonic cpa
test_Ismnemonic cpx
test_Ismnemonic cpy
test_Ismnemonic dea
test_Ismnemonic dec
test_Ismnemonic dex
test_Ismnemonic dey
test_Ismnemonic eor
test_Ismnemonic ina
test_Ismnemonic inc
test_Ismnemonic inx
test_Ismnemonic iny
test_Ismnemonic jml
test_Ismnemonic jmp
test_Ismnemonic jsl
test_Ismnemonic jsr
test_Ismnemonic lda
test_Ismnemonic ldx
test_Ismnemonic ldy
test_Ismnemonic lsr
test_Ismnemonic mvn
test_Ismnemonic mvp
test_Ismnemonic nop
test_Ismnemonic ora
test_Ismnemonic pea
test_Ismnemonic pei
test_Ismnemonic per
test_Ismnemonic pha
test_Ismnemonic phb
test_Ismnemonic phd
test_Ismnemonic phk
test_Ismnemonic php
test_Ismnemonic phx
test_Ismnemonic phy
test_Ismnemonic pla
test_Ismnemonic plb
test_Ismnemonic pld
test_Ismnemonic plp
test_Ismnemonic plx
test_Ismnemonic ply
test_Ismnemonic rep
test_Ismnemonic rol
test_Ismnemonic ror
test_Ismnemonic rti
test_Ismnemonic rtl
test_Ismnemonic rts
test_Ismnemonic sbc
test_Ismnemonic sec
test_Ismnemonic sed
test_Ismnemonic sei
test_Ismnemonic sep
test_Ismnemonic sta
test_Ismnemonic stp
test_Ismnemonic stx
test_Ismnemonic sty
test_Ismnemonic stz
test_Ismnemonic swa
test_Ismnemonic tad
test_Ismnemonic tas
test_Ismnemonic tax
test_Ismnemonic tay
test_Ismnemonic tcd
test_Ismnemonic tcs
test_Ismnemonic tda
test_Ismnemonic tdc
test_Ismnemonic trb
test_Ismnemonic tsa
test_Ismnemonic tsb
test_Ismnemonic tsc
test_Ismnemonic tsx
test_Ismnemonic txa
test_Ismnemonic txs
test_Ismnemonic txy
test_Ismnemonic tya
test_Ismnemonic tyx
test_Ismnemonic wai
test_Ismnemonic wdm
test_Ismnemonic xba
test_Ismnemonic xce

.setcpu "sweet16"
test_Ismnemonic add
test_Ismnemonic bc
test_Ismnemonic bk
test_Ismnemonic bm
test_Ismnemonic bm1
test_Ismnemonic bnc
test_Ismnemonic bnm1
test_Ismnemonic bnz
test_Ismnemonic bp
test_Ismnemonic br
test_Ismnemonic bs
test_Ismnemonic bz
test_Ismnemonic cpr
test_Ismnemonic dcr
test_Ismnemonic inr
test_Ismnemonic ld
test_Ismnemonic ldd
test_Ismnemonic pop
test_Ismnemonic popd
test_Ismnemonic rs
test_Ismnemonic rtn
test_Ismnemonic set
test_Ismnemonic st
test_Ismnemonic std
test_Ismnemonic stp
test_Ismnemonic sub

    .setcpu "6502"

    .import _exit
    .export _main

_main:
    .if ismnemonic_error
        ldx #$01
    .else
        ldx #$00
    .endif
    txa
    jmp _exit
