/*
  !!DESCRIPTION!! lzsa2 decompression
  !!ORIGIN!!      cc65 regression tests
  !!LICENCE!!     BSD 2-clause
  !!AUTHOR!!      Colin Leroy-Mira
*/

#include <zlib.h>
#include <stdio.h>
#include <lzsa.h>

/* The sample data is the original lz4.h, compressed with:
 * lzsa -r -f 1 lz4.h lz4.lzsa1
 *
 * We reused lz4.h from the LZ4 test to have a matching adler32 sum.
 */
static const unsigned char compressed[] = {
  0x19, 0xda, 0x2f, 0x2a, 0x0a, 0x20, 0x20, 0x20, 0x4c, 0x5a, 0x34, 0x20, 0x2d, 0x20, 0x46, 0x61, 
  0x73, 0x74, 0x5a, 0xf8, 0x04, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 
  0x6e, 0x20, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0xd9, 0x1a, 0x48, 0x65, 0x61, 
  0x64, 0x65, 0x72, 0x20, 0x46, 0x69, 0x6c, 0x65, 0x81, 0x38, 0x43, 0x6f, 0x70, 0x79, 0x2a, 0x19, 
  0x67, 0x68, 0x74, 0x20, 0x28, 0x43, 0x29, 0x20, 0x32, 0x30, 0x31, 0x31, 0x2d, 0xd4, 0x39, 0x35, 
  0x2c, 0x20, 0x59, 0x61, 0x6e, 0x6e, 0x13, 0x5a, 0x6c, 0x6c, 0x65, 0x74, 0x2e, 0x0a, 0xd6, 0x38, 
  0x00, 0x42, 0x53, 0x44, 0x39, 0xac, 0x2d, 0x43, 0x6c, 0x61, 0x75, 0x73, 0x65, 0x20, 0x4c, 0x69, 
  0x63, 0x65, 0x6e, 0x18, 0x6f, 0x28, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x48, 0x2e, 
  0xb6, 0x01, 0x60, 0x38, 0x6f, 0x75, 0x72, 0x3a, 0x00, 0x5c, 0x13, 0x72, 0x67, 0x2f, 0x6c, 0xdd, 
  0x1d, 0x73, 0x2f, 0x62, 0x73, 0x64, 0x2d, 0x92, 0x5b, 0x2e, 0x70, 0x68, 0x70, 0x29, 0xb2, 0x5b, 
  0x80, 0x52, 0x65, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x5d, 0x5a, 0x6e, 0x64, 
  0x20, 0xa8, 0x08, 0x69, 0xa7, 0x44, 0xbd, 0x23, 0x08, 0x62, 0x89, 0x59, 0x61, 0x72, 0x79, 0x20, 
  0x66, 0x6f, 0x72, 0x6d, 0x73, 0x2c, 0x20, 0x77, 0x3d, 0x08, 0x20, 0xac, 0x23, 0x48, 0x6f, 0xc9, 
  0x42, 0xba, 0xf0, 0x6d, 0x6f, 0x48, 0x66, 0x75, 0x4a, 0x61, 0xbc, 0x50, 0x2c, 0x20, 0xd4, 0xf8, 
  0x10, 0x65, 0x20, 0x70, 0x65, 0x20, 0x48, 0x74, 0xa2, 0x20, 0xb2, 0x19, 0x72, 0x6f, 0x76, 0x69, 
  0x64, 0xb0, 0x30, 0x74, 0x68, 0x01, 0xd2, 0x20, 0x49, 0x66, 0x32, 0x50, 0x6f, 0x77, 0x9d, 0x69, 
  0x67, 0xe2, 0x48, 0x6e, 0x81, 0x42, 0xcb, 0xea, 0x73, 0x43, 0xb6, 0x40, 0x19, 0xe9, 0x3a, 0x04, 
  0xf6, 0x4f, 0x2a, 0x61, 0x48, 0x73, 0x89, 0x4e, 0x66, 0x68, 0x48, 0x63, 0x8d, 0x00, 0xd2, 0x71, 
  0x6d, 0x75, 0x9a, 0x68, 0x72, 0xe6, 0x48, 0x61, 0x50, 0x43, 0xa6, 0x50, 0x61, 0x62, 0x94, 0x01, 
  0x65, 0xb4, 0x43, 0x65, 0x79, 0x00, 0x6e, 0x6f, 0x74, 0xdc, 0x09, 0x2c, 0x48, 0x69, 0xc1, 0x49, 
  0x6c, 0x14, 0x41, 0xbc, 0x47, 0x88, 0x4b, 0x20, 0x47, 0x6b, 0x6f, 0x61, 0xef, 0x50, 0x63, 0x6c, 
  0xae, 0x48, 0x6d, 0x3e, 0x4f, 0x2e, 0x77, 0x02, 0x77, 0x69, 0x6e, 0xea, 0x3f, 0x46, 0x77, 0x41, 
  0x14, 0x51, 0x64, 0x75, 0x63, 0x46, 0x74, 0x63, 0x25, 0xee, 0x63, 0x47, 0x74, 0x25, 0x62, 0x99, 
  0x45, 0x1a, 0x38, 0x17, 0x64, 0x6f, 0x63, 0x75, 0x48, 0x6e, 0x0a, 0x66, 0x4d, 0x69, 0x2f, 0x72, 
  0x29, 0x6f, 0x3d, 0x20, 0x28, 0x6d, 0x6d, 0x20, 0x7f, 0x10, 0x69, 0x61, 0x6c, 0x73, 0x89, 0x64, 
  0x51, 0x00, 0x13, 0x43, 0x75, 0x67, 0x14, 0x84, 0xfb, 0xb2, 0x39, 0x54, 0x48, 0x49, 0x53, 0x20, 
  0x53, 0x4f, 0x46, 0x54, 0x57, 0x41, 0x52, 0x45, 0x20, 0xa8, 0x19, 0x50, 0x52, 0x4f, 0x56, 0x49, 
  0x44, 0x45, 0x44, 0x20, 0x42, 0x59, 0x16, 0x00, 0x38, 0xa4, 0x43, 0x4f, 0x50, 0x59, 0x52, 0x49, 
  0x47, 0x48, 0x54, 0x20, 0x48, 0x4f, 0x4c, 0x39, 0x35, 0x52, 0x53, 0x20, 0x41, 0x4e, 0x44, 0xf0, 
  0x4e, 0x54, 0x18, 0x17, 0x42, 0x55, 0x54, 0x4f, 0x42, 0xb9, 0x59, 0x02, 0x22, 0x41, 0x53, 0xc3, 
  0x2a, 0x22, 0x21, 0x06, 0x40, 0xc6, 0x50, 0x45, 0x58, 0xb8, 0x30, 0x45, 0x53, 0x00, 0x04, 0x00, 
  0x59, 0x12, 0x4d, 0x50, 0x4c, 0x49, 0xb0, 0x41, 0x9f, 0x08, 0x52, 0x10, 0x54, 0x49, 0x46, 0x28, 
  0x2c, 0x38, 0x2d, 0x4e, 0x43, 0x4c, 0x55, 0x44, 0x08, 0x47, 0xa1, 0x41, 0xbc, 0xbb, 0x20, 0x4e, 
  0x4f, 0x54, 0xfa, 0xc6, 0x40, 0xd5, 0x51, 0x49, 0x54, 0xd6, 0x40, 0xab, 0x4a, 0x2c, 0x85, 0x47, 
  0xc6, 0x48, 0x20, 0x57, 0x50, 0x20, 0x4d, 0x7c, 0x11, 0x43, 0x48, 0x80, 0x38, 0x41, 0x42, 0x49, 
  0x1b, 0x53, 0x54, 0x59, 0x71, 0x08, 0x46, 0x4a, 0x4e, 0x91, 0x48, 0x46, 0x71, 0x42, 0x2b, 0xf8, 
  0x7a, 0x41, 0x20, 0x50, 0x41, 0x52, 0x54, 0x49, 0x43, 0x55, 0x4c, 0x00, 0x5a, 0x46, 0x55, 0x52, 
  0x50, 0x4f, 0x53, 0x45, 0x20, 0x20, 0x48, 0x44, 0x5c, 0x28, 0x43, 0x50, 0x49, 0x4d, 0x21, 0x49, 
  0x2e, 0x7c, 0x41, 0x88, 0x40, 0x57, 0x50, 0x56, 0x45, 0xb5, 0x50, 0x20, 0x53, 0xaf, 0x57, 0x4c, 
  0x4c, 0x11, 0x44, 0x43, 0x6f, 0x50, 0x4f, 0x57, 0xaa, 0x49, 0x52, 0x3c, 0x47, 0x11, 0x60, 0xe7, 
  0x49, 0x45, 0x56, 0x40, 0x82, 0x52, 0x4c, 0x45, 0x91, 0x43, 0x12, 0x50, 0x44, 0x49, 0x13, 0x52, 
  0x43, 0x54, 0x29, 0x27, 0xb1, 0x69, 0x43, 0xbb, 0x41, 0x5b, 0x72, 0x4c, 0x2c, 0x9a, 0x30, 0x53, 
  0x50, 0x0a, 0x29, 0x49, 0x61, 0xe8, 0x68, 0x45, 0xf1, 0x41, 0x6a, 0x55, 0x59, 0x2c, 0xa9, 0x40, 
  0x67, 0x51, 0x51, 0x55, 0x7e, 0x01, 0x13, 0x59, 0x20, 0x44, 0x41, 0x4d, 0x41, 0x47, 0x1c, 0x6f, 
  0x28, 0xe2, 0xf2, 0x09, 0x62, 0x5b, 0x50, 0x43, 0x55, 0x8c, 0x49, 0x4d, 0x44, 0x62, 0xed, 0x18, 
  0x53, 0x55, 0x42, 0x53, 0x54, 0x10, 0x08, 0x55, 0x7b, 0x26, 0x20, 0x47, 0x4f, 0x4f, 0x44, 0x89, 
  0x68, 0x53, 0x55, 0x68, 0x56, 0xfe, 0x60, 0x93, 0x48, 0x3b, 0x53, 0x73, 0x4f, 0x53, 0xc7, 0x08, 
  0x55, 0x43, 0x73, 0x70, 0x44, 0x41, 0xc4, 0x42, 0x81, 0x62, 0x15, 0x61, 0xc7, 0x32, 0x53, 0x3b, 
  0xa1, 0x28, 0x42, 0x6b, 0x49, 0xbd, 0x20, 0xd4, 0x70, 0x54, 0x45, 0x57, 0xf0, 0x55, 0x50, 0x40, 
  0x63, 0x69, 0x29, 0x0c, 0x69, 0x57, 0xde, 0x61, 0xff, 0x49, 0x41, 0xc2, 0x6b, 0x44, 0x05, 0x00, 
  0x62, 0x1e, 0x84, 0xf4, 0xc4, 0x50, 0x45, 0x4f, 0x36, 0x62, 0x6c, 0x75, 0x4c, 0x49, 0x72, 0x60, 
  0x47, 0xe8, 0x57, 0x20, 0x61, 0xca, 0xf4, 0x49, 0x4e, 0x6a, 0x41, 0xe7, 0x28, 0x53, 0xc0, 0xe8, 
  0x49, 0x47, 0xd9, 0x44, 0x02, 0x61, 0xb3, 0x62, 0x09, 0x47, 0x10, 0x20, 0x68, 0x20, 0x3b, 0x08, 
  0x47, 0x30, 0x47, 0x45, 0x8c, 0x4a, 0x45, 0x3d, 0x4a, 0x4f, 0xb7, 0x70, 0x57, 0x49, 0x44, 0x69, 
  0x29, 0x43, 0x00, 0x42, 0xdf, 0x4b, 0x49, 0x83, 0x81, 0xff, 0xb4, 0x41, 0x89, 0x4a, 0x55, 0x04, 
  0x62, 0x4b, 0x42, 0x26, 0x63, 0x51, 0x8f, 0x46, 0x31, 0x5e, 0x6b, 0x2c, 0x22, 0x40, 0xcc, 0xe8, 
  0x46, 0x51, 0x44, 0x56, 0xb9, 0x4e, 0x44, 0xd0, 0x69, 0x50, 0xee, 0x4c, 0x49, 0x4f, 0x64, 0xc1, 
  0x75, 0x43, 0x48, 0x82, 0xa4, 0x9d, 0x9a, 0x4e, 0x59, 0x6f, 0x75, 0x20, 0x63, 0x61, 0x6e, 0x61, 
  0x80, 0xed, 0xa5, 0xf4, 0x63, 0x74, 0x28, 0x75, 0xa1, 0xfe, 0x99, 0x81, 0x3d, 0x4a, 0x3a, 0x94, 
  0xaa, 0x2d, 0xee, 0x18, 0xa6, 0xdc, 0xf9, 0x5e, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x6f, 
  0xb2, 0x3a, 0x20, 0x76, 0xa9, 0x73, 0xee, 0x75, 0xa9, 0x67, 0xe1, 0x99, 0x0d, 0x75, 0x62, 0x2e, 
  0xff, 0x5f, 0xa1, 0x2f, 0x43, 0x79, 0x61, 0x6e, 0x34, 0x39, 0x37, 0x33, 0x2f, 0x6c, 0x7a, 0x34, 
  0xc3, 0x28, 0x70, 0x1e, 0xa1, 0x64, 0xa2, 0xe3, 0xaa, 0x57, 0x75, 0x6d, 0xc8, 0x48, 0x72, 0xab, 
  0x00, 0xb4, 0x5b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0xc1, 0x43, 0xde, 0x3b, 0x0c, 0x2f, 
  0x23, 0x21, 0x42, 0xbc, 0xb8, 0xae, 0x63, 0x0a, 0x2a, 0x2f, 0x0a, 0x23, 0x70, 0x72, 0x61, 0x67, 
  0x6d, 0x61, 0x20, 0x8e, 0xf9, 0xa5, 0x63, 0x65, 0x0a, 0x0a, 0x23, 0x69, 0x66, 0x20, 0x64, 0x65, 
  0x66, 0x69, 0x6e, 0x3a, 0x28, 0x5f, 0x5f, 0x63, 0x70, 0x6c, 0x75, 0x73, 0xe1, 0x99, 0x29, 0x0a, 
  0x65, 0x78, 0xe8, 0xed, 0xb9, 0x6e, 0x20, 0x22, 0x43, 0x22, 0x20, 0x7b, 0x0a, 0x23, 0x65, 0x6e, 
  0xed, 0x56, 0x92, 0x0a, 0x0a, 0x55, 0x51, 0x2a, 0x20, 0xb5, 0xb6, 0x2e, 0x68, 0xe4, 0x5f, 0x9f, 
  0x73, 0x20, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0xd4, 0x4e, 0x50, 0x66, 0x75, 0xa3, 0xa3, 0xed, 0x61, 
  0x8b, 0x2c, 0xf8, 0x40, 0x2d, 0x08, 0x76, 0x35, 0x01, 0x7b, 0x60, 0x6c, 0x6c, 0x20, 0x62, 0x75, 
  0x66, 0x66, 0x65, 0x72, 0xde, 0xf8, 0x72, 0x6f, 0x6c, 0x4a, 0x6f, 0xb9, 0x48, 0x67, 0x6e, 0xac, 
  0x6d, 0xe1, 0xc9, 0x68, 0x2a, 0x8a, 0x40, 0x70, 0x69, 0x79, 0xb9, 0x40, 0x70, 0x32, 0x65, 0x64, 
  0x30, 0x67, 0x65, 0xb1, 0x20, 0x8a, 0x74, 0xd0, 0xa6, 0x41, 0x71, 0x39, 0x2d, 0x6f, 0x70, 0x90, 
  0x40, 0x01, 0x4f, 0x65, 0x92, 0x41, 0x49, 0x08, 0x64, 0x09, 0x48, 0x61, 0x44, 0x01, 0x20, 0x26, 
  0x41, 0x8b, 0x73, 0x6e, 0x67, 0x9e, 0x49, 0x66, 0xad, 0x12, 0x65, 0x20, 0x87, 0xd0, 0x9f, 0x51, 
  0x29, 0x2c, 0xa0, 0x42, 0x70, 0x63, 0x5c, 0x74, 0x6c, 0x65, 0x60, 0x60, 0xb5, 0x92, 0x62, 0x72, 
  0xd3, 0x5b, 0x09, 0x68, 0x41, 0xa8, 0x91, 0x69, 0x74, 0xdd, 0xd3, 0x91, 0x77, 0x6e, 0xb0, 0x69, 
  0x6d, 0x69, 0x48, 0x2c, 0x62, 0x20, 0x6d, 0x48, 0x61, 0x9b, 0x82, 0x24, 0x42, 0x0a, 0x43, 0xaa, 
  0x51, 0x2e, 0x68, 0x73, 0xb1, 0x73, 0x74, 0xdf, 0x78, 0x69, 0x2e, 0xb0, 0x62, 0xec, 0x07, 0xff, 
  0x0d, 0x70, 0x0a, 0x2a, 0x01, 0x48, 0x56, 0x42, 0x62, 0xe0, 0x4f, 0x0a, 0xce, 0x0d, 0x62, 0x54, 
  0x64, 0x65, 0x42, 0x2e, 0xb1, 0x5f, 0x56, 0xef, 0xbc, 0xa1, 0xa4, 0x99, 0x1f, 0x5f, 0x4d, 0x41, 
  0x4a, 0x1c, 0x01, 0xfd, 0x0a, 0x31, 0xb2, 0x2f, 0x2a, 0xdd, 0xa1, 0x50, 0x20, 0x62, 0x01, 0x51, 
  0x61, 0x6b, 0x04, 0x64, 0xd9, 0x92, 0x66, 0x61, 0x17, 0x41, 0x2e, 0x69, 0x67, 0x62, 0x4f, 0x20, 
  0xb8, 0xf2, 0x00, 0xf4, 0x49, 0x4e, 0xef, 0x37, 0x80, 0xf3, 0xf9, 0xe8, 0x77, 0x68, 0x6e, 0xd4, 
  0x4e, 0x2d, 0xaf, 0x4f, 0x29, 0xae, 0x70, 0x61, 0x70, 0x84, 0xb1, 0x69, 0x6c, 0xde, 0x87, 0x61, 
  0x0b, 0x47, 0x62, 0xff, 0x45, 0x52, 0x45, 0x4c, 0x45, 0x41, 0x53, 0x45, 0xf1, 0x74, 0x77, 0x71, 
  0x73, 0x2c, 0x03, 0x50, 0x67, 0x2d, 0xce, 0x11, 0x78, 0x65, 0xa5, 0x21, 0x9a, 0x4d, 0x64, 0x65, 
  0x76, 0x65, 0x6c, 0x6f, 0x70, 0x6e, 0x47, 0xb2, 0xf1, 0x00, 0x99, 0x4e, 0x55, 0x4d, 0x42, 0xe9, 
  0xba, 0x4f, 0x28, 0x00, 0x3a, 0x1e, 0x2a, 0x31, 0x30, 0x30, 0x57, 0x20, 0x2b, 0x2b, 0xa3, 0x04, 
  0x47, 0x68, 0xb3, 0x51, 0x29, 0x0a, 0x31, 0x03, 0x6c, 0x76, 0x75, 0x7f, 0xbf, 0x4e, 0x75, 0x6d, 
  0x62, 0x65, 0x72, 0x20, 0x28, 0x76, 0x6f, 0x69, 0x64, 0x29, 0x3b, 0x33, 0x15, 0x7a, 0x0f, 0x54, 
  0x75, 0x6e, 0x8e, 0x92, 0x70, 0x61, 0xeb, 0x61, 0x8a, 0x67, 0x2a, 0xff, 0x10, 0xa4, 0xbb, 0x63, 
  0x2c, 0xb8, 0x0e, 0x4d, 0x45, 0x4d, 0xbc, 0xf0, 0x59, 0x5f, 0xa1, 0xe5, 0x3f, 0x32, 0x20, 0x3a, 
  0x8b, 0x4d, 0xfc, 0x88, 0xa1, 0xb4, 0x68, 0x61, 0x44, 0xa3, 0xcd, 0xc7, 0x79, 0x75, 0x6c, 0x61, 
  0x20, 0x3a, 0x20, 0x4e, 0x2d, 0x3e, 0x32, 0x5e, 0x4e, 0x20, 0x42, 0x79, 0x74, 0x2e, 0x99, 0x2f, 
  0x28, 0x65, 0x78, 0x61, 0x6d, 0x67, 0x09, 0x73, 0x32, 0x68, 0x31, 0xfe, 0x00, 0x20, 0xd0, 0x18, 
  0x4b, 0x42, 0x3b, 0xaa, 0xea, 0x32, 0xe8, 0x34, 0x29, 0x20, 0xea, 0x36, 0x32, 0x36, 0x34, 0x42, 
  0x4c, 0x32, 0xdd, 0xe9, 0x4d, 0xbb, 0x65, 0x74, 0x63, 0x2e, 0x29, 0xff, 0x9a, 0x91, 0x6e, 0x63, 
  0xce, 0xea, 0x73, 0x4f, 0x6d, 0x8e, 0x3c, 0xb2, 0x69, 0x6d, 0x89, 0x97, 0x65, 0x73, 0xb4, 0x80, 
  0xaa, 0x72, 0xcc, 0x60, 0xab, 0x0a, 0xaa, 0x82, 0xc4, 0x5a, 0x4f, 0x64, 0xcd, 0xa2, 0xff, 0xb3, 
  0x45, 0xc9, 0xa3, 0x90, 0x00, 0x0c, 0x60, 0x18, 0x91, 0x64, 0x75, 0x35, 0x29, 0x6f, 0x3c, 0x89, 
  0x63, 0x8a, 0xa9, 0x65, 0xfa, 0x0f, 0x52, 0x63, 0x74, 0x24, 0x08, 0x44, 0x59, 0x5c, 0x61, 0x75, 
  0x6c, 0x74, 0x20, 0x76, 0x61, 0x6c, 0xdf, 0xa1, 0xa9, 0x5a, 0x0b, 0x31, 0x34, 0x2c, 0x1c, 0x41, 
  0x52, 0x91, 0x4b, 0x42, 0xe0, 0x50, 0x68, 0x69, 0xd0, 0x91, 0x20, 0x6e, 0xbb, 0x66, 0x89, 0x6c, 
  0xcc, 0xa2, 0xf7, 0x77, 0x61, 0x54, 0x49, 0x6f, 0x55, 0x08, 0x74, 0x5c, 0x4f, 0x20, 0x78, 0x38, 
  0x36, 0x20, 0x4c, 0x31, 0xad, 0x8f, 0x0a, 0x2d, 0x28, 0x67, 0xb9, 0x41, 0xab, 0x6f, 0x0a, 0x39, 
  0xfe, 0x15, 0x72, 0x53, 0x69, 0xb4, 0x96, 0x20, 0x46, 0x4d, 0x67, 0x39, 0xff, 0x11, 0x87, 0xb5, 
  0x0f, 0x66, 0xd4, 0x54, 0x5f, 0x64, 0x1f, 0x51, 0x28, 0x63, 0xb9, 0xaa, 0x74, 0x7f, 0xb5, 0x72, 
  0x2a, 0xb9, 0xf1, 0x2d, 0x2c, 0xa1, 0xe4, 0xd1, 0x52, 0x74, 0x2c, 0x28, 0x25, 0x40, 0x83, 0x34, 
  0x7a, 0x65, 0x81, 0x19, 0x6d, 0x61, 0x78, 0x44, 0x17, 0x02, 0x56, 0x29, 0x3b, 0xa5, 0x41, 0xae, 
  0x47, 0xa3, 0x0f, 0x60, 0x93, 0xe8, 0x66, 0x47, 0xa5, 0x0c, 0xa7, 0xe2, 0xe4, 0x47, 0xa1, 0x63, 
  0x07, 0x5f, 0x84, 0x11, 0x4f, 0x0a, 0x3e, 0xcd, 0x8c, 0x29, 0x52, 0x56, 0x20, 0x43, 0xce, 0x60, 
  0x53, 0x4f, 0x27, 0x4e, 0x10, 0x9b, 0x27, 0x20, 0x62, 0xf0, 0x77, 0x10, 0x66, 0x72, 0xa5, 0xe0, 
  0x2e, 0x06, 0x4a, 0x27, 0xc9, 0x64, 0x47, 0x91, 0x61, 0x6c, 0xec, 0x6b, 0x31, 0x64, 0x79, 0x81, 
  0xdb, 0xe0, 0xaa, 0x61, 0x2d, 0x4a, 0x27, 0x01, 0x4d, 0x27, 0xce, 0xa3, 0xb5, 0x6c, 0x41, 0x01, 
  0x20, 0x47, 0x05, 0x2a, 0x56, 0x27, 0x2e, 0x89, 0x86, 0x02, 0x82, 0xff, 0xd8, 0xb1, 0x67, 0x75, 
  0x9c, 0x95, 0x6e, 0x74, 0xd1, 0xed, 0x1a, 0x73, 0x75, 0x63, 0x63, 0xa5, 0x57, 0x69, 0x66, 0xc5, 
  0x7f, 0x04, 0x20, 0x3e, 0x3d, 0x71, 0x70, 0x42, 0x6f, 0x2d, 0x77, 0x64, 0x28, 0x98, 0x15, 0x4c, 
  0x29, 0xa4, 0x51, 0x49, 0x74, 0x6e, 0x20, 0x30, 0x20, 0x72, 0x1f, 0x41, 0x3e, 0xb1, 0x61, 0x73, 
  0x46, 0x69, 0x2c, 0xb5, 0xa1, 0xea, 0x06, 0x89, 0x27, 0xb2, 0x00, 0x4b, 0x62, 0x8e, 0xa1, 0xda, 
  0x82, 0xad, 0x86, 0x60, 0xd7, 0x8a, 0x74, 0xaf, 0x45, 0xc8, 0x8b, 0x66, 0xad, 0x7b, 0x86, 0x25, 
  0xa2, 0xd1, 0x17, 0x77, 0x6e, 0x6f, 0x93, 0x67, 0xff, 0x0d, 0x45, 0x03, 0x89, 0x20, 0xc0, 0x82, 
  0xd4, 0xa2, 0x57, 0x6d, 0x69, 0x06, 0x50, 0x64, 0x67, 0xac, 0xa3, 0xcf, 0xb2, 0xa7, 0x9e, 0x42, 
  0x20, 0xb1, 0x6f, 0x70, 0xe0, 0xad, 0x49, 0x69, 0x87, 0x71, 0x64, 0x69, 0xd5, 0xbb, 0x6c, 0x79, 
  0x2a, 0xd5, 0xc6, 0x47, 0x8e, 0x41, 0xd2, 0x61, 0x64, 0x62, 0xef, 0x70, 0x7a, 0x65, 0x86, 0x44, 
  0x6a, 0x4a, 0x41, 0x4c, 0x82, 0xf2, 0x90, 0x99, 0x65, 0x71, 0x75, 0x65, 0x6e, 0xfc, 0x97, 0x65, 
  0x9b, 0x83, 0x7c, 0x00, 0x7f, 0x43, 0xd2, 0xb3, 0x6e, 0x6f, 0x8c, 0x74, 0x69, 0x64, 0xa3, 0x89, 
  0x54, 0xa1, 0x2e, 0x47, 0xab, 0xa9, 0x6e, 0xea, 0x7a, 0xa1, 0x6c, 0x72, 0x72, 0x69, 0x2f, 0xa1, 
  0xaa, 0x69, 0xa9, 0x73, 0x8c, 0x67, 0x57, 0x5f, 0xa0, 0x5c, 0xe9, 0x6e, 0x62, 0x34, 0x26, 0x0a, 
  0x46, 0x14, 0x44, 0xde, 0x87, 0x10, 0x2f, 0x87, 0x2a, 0x2e, 0x89, 0x20, 0x4a, 0x68, 0x4d, 0x62, 
  0x61, 0x52, 0x70, 0x70, 0x70, 0xf6, 0x62, 0x02, 0xa6, 0xfe, 0x09, 0x84, 0x06, 0x5e, 0xbf, 0x41, 
  0x58, 0x5f, 0x49, 0x4e, 0x50, 0x55, 0x54, 0x5f, 0x56, 0x41, 0x4c, 0x55, 0x45, 0xbf, 0xa7, 0xf9, 
  0x3c, 0x94, 0x20, 0x3a, 0xcd, 0xb2, 0x6f, 0x72, 0xea, 0x9c, 0x89, 0x74, 0x62, 0x84, 0xfe, 0xd0, 
  0x55, 0x6f, 0x66, 0x67, 0x46, 0x15, 0x8b, 0x28, 0xc6, 0xa4, 0xaf, 0x2b, 0x97, 0x62, 0x65, 0x88, 
  0x9a, 0x4e, 0x29, 0xa2, 0xa2, 0x0d, 0xf0, 0x75, 0x72, 0x6b, 0x3a, 0xa8, 0xac, 0x6e, 0xef, 0x05, 
  0x94, 0x6f, 0x66, 0x32, 0x63, 0xfc, 0x61, 0xcd, 0x63, 0x40, 0x47, 0x9e, 0x7e, 0x60, 0xda, 0x48, 
  0x63, 0xde, 0xf0, 0x73, 0x61, 0x81, 0x65, 0x52, 0x3c, 0x3d, 0x5a, 0x68, 0x4f, 0xd5, 0x53, 0x70, 
  0x75, 0x58, 0x46, 0xa1, 0x06, 0xff, 0x61, 0xd3, 0x89, 0x30, 0x63, 0xa7, 0xc5, 0xef, 0xbf, 0x3f, 
  0x61, 0x69, 0x6c, 0x73, 0x0a, 0x0a, 0x2d, 0xaf, 0xa6, 0x95, 0xa7, 0xf6, 0x4a, 0x00, 0x55, 0x61, 
  0x18, 0x43, 0x59, 0x01, 0x30, 0x63, 0x69, 0x53, 0x63, 0xf4, 0x66, 0xff, 0x02, 0x47, 0xcf, 0x2c, 
  0xa4, 0x7e, 0x61, 0x22, 0x66, 0xbf, 0x47, 0xb4, 0xee, 0x46, 0xc1, 0x83, 0x79, 0x94, 0x69, 0x6e, 
  0x9f, 0xf8, 0x66, 0x1b, 0x67, 0xbb, 0x07, 0x77, 0x2e, 0x0a, 0xbf, 0xf2, 0x09, 0x4f, 0x64, 0x88, 
  0x63, 0xba, 0x47, 0x98, 0xa7, 0x67, 0xb5, 0x47, 0x50, 0x7a, 0x67, 0xaf, 0x4f, 0x49, 0x50, 0xbf, 
  0x86, 0x28, 0x68, 0x6c, 0x6c, 0x89, 0x67, 0xda, 0x9c, 0x00, 0x5b, 0x1d, 0x75, 0x67, 0x68, 0x2c, 
  0x7e, 0xaa, 0x64, 0x6b, 0x70, 0x77, 0x69, 0xd3, 0xa3, 0xf8, 0xaa, 0x83, 0x78, 0x6b, 0x6f, 0x54, 
  0x01, 0xa8, 0x48, 0x20, 0x7f, 0x68, 0x72, 0x61, 0x84, 0xfc, 0x5f, 0x27, 0x28, 0x3c, 0x30, 0x29, 
  0x2e, 0x96, 0x62, 0xda, 0xa6, 0xbd, 0x62, 0x71, 0x73, 0x74, 0xfd, 0x6a, 0x6d, 0xc5, 0xa9, 0x64, 
  0x21, 0x8a, 0x63, 0xf8, 0x3d, 0xe8, 0x6d, 0x82, 0x33, 0x81, 0xdf, 0x1c, 0xa7, 0x66, 0x42, 0x47, 
  0x91, 0x46, 0x7e, 0x42, 0x88, 0x66, 0xd2, 0xa9, 0x61, 0xff, 0x9b, 0x49, 0x67, 0x43, 0xb5, 0x76, 
  0x65, 0x3d, 0x47, 0x89, 0x2f, 0xa7, 0x6f, 0x99, 0xab, 0x69, 0x7c, 0x45, 0x8f, 0x48, 0x61, 0xc8, 
  0x82, 0xbe, 0x94, 0xa7, 0xcd, 0x0c, 0xa9, 0x76, 0x23, 0xa1, 0x8c, 0xfc, 0x40, 0x38, 0x10, 0x78, 
  0x70, 0x81, 0xbd, 0x54, 0x82, 0xb4, 0x5a, 0x0b, 0x63, 0x6c, 0x75, 0x0c, 0x42, 0x63, 0x50, 0x69, 
  0x63, 0xbe, 0xb4, 0x75, 0x73, 0xee, 0x5f, 0x47, 0x70, 0x61, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x1d, 
  0xaf, 0x74, 0xfc, 0x0e, 0x65, 0xdd, 0xa7, 0xf8, 0x0e, 0x47, 0xdf, 0x10, 0x37, 0x69, 0x6e, 0x1b, 
  0x82, 0x08, 0xa7, 0xdf, 0x9b, 0x16, 0x99, 0x2c, 0x41, 0x64, 0x76, 0x61, 0x6e, 0xc5, 0xa7, 0xdf, 
  0x99, 0x1a, 0xa6, 0xde, 0x17, 0x87, 0xca, 0x61, 0x5e, 0x53, 0x49, 0x5a, 0x45, 0x2c, 0x1b, 0x2f, 
  0x30, 0x78, 0x37, 0x45, 0x30, 0xa4, 0xbc, 0xef, 0xa0, 0xf8, 0xf8, 0x6d, 0x31, 0x31, 0x33, 0x20, 
  0x39, 0x32, 0x39, 0x20, 0x32, 0x85, 0x55, 0x47, 0xb7, 0x60, 0x9b, 0x43, 0x4f, 0x4d, 0x85, 0x97, 
  0xba, 0x42, 0x4f, 0x55, 0x4e, 0x44, 0x28, 0x69, 0x73, 0xf9, 0x39, 0x81, 0xae, 0x89, 0x28, 0xda, 
  0xec, 0xb1, 0x69, 0x67, 0xf4, 0x2e, 0x29, 0x61, 0xf7, 0x3e, 0x20, 0x47, 0x7e, 0xaf, 0xa9, 0x3f, 
  0x15, 0x56, 0x3a, 0x20, 0xd3, 0xe8, 0x2b, 0x05, 0xa1, 0x3a, 0x2f, 0x32, 0x35, 0x35, 0x8d, 0x40, 
  0x80, 0xab, 0x29, 0x9b, 0x87, 0xd9, 0x68, 0xa6, 0xda, 0x9e, 0xac, 0x50, 0xba, 0xa3, 0xfc, 0x14, 
  0x82, 0xfb, 0xb1, 0x69, 0x6d, 0xa7, 0x2a, 0x42, 0xbc, 0x83, 0x08, 0x42, 0x53, 0x87, 0x63, 0xf4, 
  0x41, 0xde, 0x6e, 0x79, 0x54, 0x8a, 0x69, 0xfc, 0xa6, 0x70, 0x22, 0x77, 0x56, 0x82, 0x94, 0xf8, 
  0x17, 0x61, 0x73, 0x65, 0x22, 0xa1, 0x2b, 0x81, 0xef, 0x5c, 0x48, 0x6f, 0x6f, 0x63, 0x52, 0x84, 
  0xf8, 0x87, 0xd3, 0x5b, 0xa9, 0x69, 0xaf, 0xc5, 0x97, 0x29, 0x0a, 0x8c, 0xee, 0x93, 0x69, 0x6d, 
  0x20, 0xa2, 0x7a, 0x38, 0xa1, 0x55, 0x82, 0xab, 0xf1, 0x84, 0xe4, 0xa6, 0xd9, 0x3e, 0x43, 0xd6, 
  0x40, 0xa9, 0x89, 0x72, 0x4c, 0x82, 0xbf, 0x7b, 0xa7, 0x6c, 0xad, 0xaf, 0x73, 0x9a, 0x12, 0x7f, 
  0x4d, 0x61, 0x63, 0x72, 0x6f, 0x95, 0xad, 0x49, 0x29, 0x94, 0xa4, 0x80, 0xa6, 0x7d, 0x20, 0x42, 
  0x97, 0x43, 0x5f, 0x53, 0x69, 0x6c, 0xb3, 0x08, 0x2d, 0xa9, 0x6d, 0xfb, 0x2e, 0x82, 0xdb, 0x44, 
  0xa3, 0xb1, 0x28, 0x73, 0x99, 0xb3, 0x4f, 0x6b, 0x74, 0x43, 0xc7, 0xa4, 0xbc, 0xf5, 0x46, 0x8a, 
  0x48, 0x4e, 0x14, 0x65, 0xc8, 0x87, 0x2a, 0xe6, 0x05, 0xa6, 0xdb, 0x07, 0x81, 0x8c, 0xb3, 0x65, 
  0x6e, 0xc3, 0x6b, 0x47, 0x3d, 0x61, 0xf1, 0x87, 0xce, 0xb4, 0xb7, 0x72, 0x63, 0xe5, 0x0f, 0x63, 
  0x99, 0x86, 0xdc, 0x12, 0xef, 0x6d, 0x87, 0xfa, 0x48, 0x87, 0xd8, 0x71, 0x66, 0x08, 0x65, 0x26, 
  0x43, 0x7b, 0x67, 0x21, 0xfd, 0x03, 0x87, 0x90, 0xac, 0xaa, 0x2c, 0xf2, 0x64, 0x0b, 0x46, 0x3e, 
  0xbd, 0x0e, 0x74, 0x6f, 0x6f, 0xe2, 0x48, 0x28, 0x32, 0x47, 0x7a, 0xa8, 0x89, 0x29, 0xf3, 0x82, 
  0xba, 0x3d, 0x47, 0x18, 0x21, 0x5b, 0x45, 0x25, 0x87, 0xd9, 0xeb, 0x61, 0xc2, 0x87, 0xdc, 0x19, 
  0xaa, 0x53, 0x96, 0x00, 0x7e, 0x67, 0x8d, 0xa2, 0xac, 0x0a, 0x6b, 0x74, 0x4a, 0xb3, 0x77, 0x73, 
  0x42, 0x68, 0x65, 0x52, 0xab, 0x63, 0xe9, 0x74, 0x68, 0x22, 0x2a, 0x09, 0x63, 0x6b, 0x72, 0x33, 
  0x69, 0x22, 0x6e, 0xa9, 0x63, 0x8c, 0xf6, 0x86, 0x5d, 0x4c, 0x65, 0x44, 0xab, 0x72, 0x83, 0xbc, 
  0x47, 0xd7, 0x64, 0xa7, 0xa3, 0xea, 0x80, 0x65, 0x3b, 0x02, 0xa7, 0x51, 0xdc, 0x46, 0x90, 0xb4, 
  0x73, 0x6f, 0x95, 0x21, 0x41, 0x51, 0x44, 0xba, 0xa7, 0xad, 0x3b, 0x85, 0xf6, 0xa4, 0xc5, 0x0e, 
  0xb1, 0x74, 0x72, 0xae, 0x70, 0x2d, 0x6f, 0x01, 0x29, 0x2e, 0x78, 0xa2, 0x40, 0x82, 0xc9, 0xbb, 
  0xa3, 0x89, 0x91, 0x74, 0x75, 0xe5, 0xf5, 0x85, 0x47, 0x89, 0x65, 0xab, 0x33, 0x83, 0x85, 0x42, 
  0xbe, 0x74, 0x76, 0x65, 0x20, 0x84, 0x5d, 0x5b, 0x83, 0x8e, 0x8a, 0x72, 0xdc, 0x7e, 0x81, 0xe2, 
  0x79, 0x1a, 0x2b, 0x7e, 0x33, 0x25, 0x84, 0xa4, 0xf5, 0xa5, 0xc9, 0x5c, 0x4f, 0x6e, 0x3e, 0x83, 
  0xc0, 0x39, 0xbf, 0x22, 0x31, 0x22, 0xd0, 0x66, 0x65, 0xbb, 0x40, 0x5f, 0x51, 0x67, 0x75, 0x06, 
  0x67, 0xb3, 0xec, 0x63, 0xe3, 0x6a, 0x56, 0xff, 0x8a, 0x73, 0x79, 0x8c, 0x30, 0xd7, 0x18, 0x8b, 
  0x62, 0xb6, 0xb2, 0x6c, 0x61, 0xe9, 0xa0, 0x50, 0x62, 0x79, 0x91, 0xb1, 0x43, 0x43, 0x7b, 0xb2, 
  0x52, 0x41, 0x75, 0x76, 0xb9, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0xf8, 0xbb, 0xb3, 
  0x65, 0x65, 0x48, 0xb5, 0x63, 0x29, 0xaa, 0x96, 0xa3, 0x7f, 0x8e, 0x2e, 0xf8, 0xfb, 0x67, 0x21, 
  0x8f, 0x20, 0xaf, 0x3a, 0x25, 0x06, 0x74, 0x67, 0x45, 0xa1, 0x9f, 0xa0, 0x87, 0xb5, 0xd7, 0x89, 
  0x5f, 0x94, 0x91, 0x53, 0x74, 0xaf, 0xdd, 0x87, 0xac, 0x47, 0x87, 0xae, 0xc5, 0x40, 0xaa, 0xaa, 
  0x6a, 0x44, 0x20, 0xed, 0xa4, 0x9c, 0x8c, 0x20, 0x7a, 0x5a, 0x81, 0x9d, 0x87, 0xa2, 0x98, 0x86, 
  0x9f, 0x2d, 0x71, 0x73, 0x70, 0xed, 0x63, 0x74, 0x81, 0xa7, 0x47, 0xb1, 0x5d, 0x4a, 0x73, 0x92, 
  0x64, 0x62, 0x94, 0x55, 0x73, 0xed, 0x82, 0xad, 0x74, 0x55, 0x6f, 0x66, 0x79, 0x42, 0xca, 0xb1, 
  0x6b, 0x6e, 0x97, 0x29, 0x68, 0xeb, 0x70, 0x6d, 0x75, 0xfb, 0x45, 0xac, 0x86, 0x9b, 0xa7, 0xc1, 
  0xe8, 0xea, 0x2c, 0x82, 0x46, 0x00, 0x06, 0x82, 0x7d, 0xbc, 0x49, 0x20, 0x9d, 0x94, 0x38, 0x2d, 
  0x86, 0x8a, 0x62, 0xab, 0x79, 0x81, 0xc6, 0xa2, 0x9f, 0x47, 0x44, 0x49, 0x4b, 0x6d, 0xd6, 0x42, 
  0x9b, 0x70, 0x79, 0x70, 0x77, 0x42, 0x44, 0x8f, 0x29, 0x09, 0x0e, 0xb5, 0x6e, 0x2c, 0xe7, 0x43, 
  0xb9, 0xa9, 0x61, 0xa8, 0x89, 0x82, 0x66, 0x4c, 0x2a, 0x4f, 0x49, 0x27, 0x69, 0x67, 0xea, 0xc7, 
  0x66, 0x39, 0x47, 0x37, 0x85, 0x82, 0x29, 0x06, 0x67, 0x8a, 0xe2, 0x57, 0x20, 0x28, 0x9c, 0x77, 
  0x2c, 0x20, 0x08, 0xfe, 0x09, 0x86, 0xe2, 0x67, 0x09, 0xf1, 0x24, 0x4c, 0x64, 0xd1, 0x67, 0x0e, 
  0xb2, 0x52, 0x65, 0x87, 0x6e, 0xac, 0x65, 0x6c, 0x70, 0x6f, 0x67, 0xe8, 0x89, 0x2c, 0xf7, 0x34, 
  0x46, 0x13, 0x64, 0x12, 0x6b, 0x73, 0x76, 0xa3, 0x10, 0x02, 0x9d, 0x94, 0x70, 0x6f, 0x2f, 0x83, 
  0x9a, 0x79, 0x87, 0x6d, 0x79, 0x87, 0x79, 0xfa, 0x03, 0x87, 0xc2, 0x59, 0x87, 0x79, 0x1e, 0x8a, 
  0x74, 0x8f, 0x8f, 0x74, 0x90, 0x76, 0xa7, 0xab, 0xd3, 0xb3, 0x65, 0x69, 0x4d, 0xd2, 0x46, 0x3a, 
  0xa5, 0x4a, 0xa1, 0x48, 0xad, 0x08, 0x69, 0x46, 0x7e, 0xa7, 0xa0, 0x85, 0x43, 0x81, 0x46, 0x9a, 
  0x93, 0x69, 0x66, 0x9b, 0x9f, 0x87, 0x50, 0x5a, 0x8d, 0x0a, 0xd1, 0x89, 0x66, 0xb9, 0x52, 0xa7, 
  0xe3, 0x39, 0x45, 0x9d, 0x92, 0x6c, 0x65, 0xf6, 0xa3, 0x3f, 0xc8, 0x47, 0x03, 0x0f, 0x87, 0xb1, 
  0x30, 0x8f, 0x2a, 0x81, 0xa0, 0x50, 0x50, 0x74, 0x14, 0x8e, 0x3a, 0xe3, 0xd6, 0xa5, 0x8d, 0xa4, 
  0x66, 0xa3, 0xa9, 0x69, 0x2b, 0x62, 0xed, 0x84, 0xf0, 0x1a, 0xbe, 0x61, 0x6e, 0x79, 0xaa, 0xf6, 
  0x41, 0x1b, 0xab, 0x65, 0x0e, 0x67, 0xa4, 0x62, 0x57, 0x74, 0x6f, 0x54, 0x43, 0x92, 0x27, 0xfe, 
  0xbf, 0x08, 0x4e, 0x65, 0x77, 0x19, 0x1a, 0xa7, 0xc3, 0x69, 0x95, 0x6f, 0x6c, 0xf4, 0xaf, 0x2e, 
  0xd9, 0xf7, 0xb7, 0x4e, 0x62, 0xab, 0x73, 0xa7, 0xae, 0x7a, 0x67, 0x4f, 0x0a, 0xa7, 0x79, 0xfe, 
  0x16, 0x86, 0x0d, 0x87, 0xfb, 0x70, 0xa7, 0x8f, 0x9e, 0x0e, 0x05, 0x36, 0x66, 0xa2, 0x23, 0x47, 
  0x72, 0x6e, 0x87, 0x14, 0x3d, 0xb7, 0x64, 0x65, 0xc7, 0xd2, 0xa9, 0x6f, 0x47, 0x89, 0x69, 0xea, 
  0x44, 0xa7, 0x5c, 0x55, 0x26, 0x84, 0x28, 0x9e, 0x62, 0x76, 0x8a, 0x66, 0xb6, 0xb7, 0x75, 0x6e, 
  0xa1, 0xa3, 0xa3, 0x8a, 0xc8, 0xa7, 0x70, 0xf1, 0x09, 0x67, 0x3f, 0x87, 0xa3, 0x2a, 0xa6, 0xa3, 
  0x79, 0xb5, 0x69, 0x6e, 0x05, 0x81, 0xba, 0xbf, 0x94, 0x64, 0x73, 0x30, 0x47, 0x9e, 0x6a, 0xaf, 
  0x29, 0xe2, 0xfa, 0x6d, 0xaf, 0x44, 0x04, 0x89, 0x87, 0x5b, 0xfd, 0x02, 0xa2, 0x3e, 0x6b, 0x73, 
  0xe2, 0x47, 0xdc, 0x1c, 0xa0, 0xa3, 0xf4, 0x69, 0x6e, 0x81, 0x77, 0xd0, 0x66, 0x8d, 0x87, 0x3a, 
  0x2b, 0x84, 0xc6, 0xea, 0x6e, 0xaf, 0x3a, 0xa5, 0x75, 0x01, 0xbd, 0x82, 0xa8, 0x85, 0x4d, 0xa6, 
  0x85, 0xfe, 0xa7, 0xe3, 0x30, 0x8a, 0x66, 0x84, 0x65, 0x8a, 0x72, 0x6c, 0x41, 0xd9, 0x44, 0x05, 
  0x87, 0x47, 0x67, 0x47, 0x33, 0x4b, 0x93, 0x49, 0x74, 0x02, 0xa1, 0x1c, 0xe8, 0x8f, 0x74, 0x44, 
  0x1c, 0x81, 0x90, 0x87, 0x8c, 0xe9, 0x47, 0xc6, 0x40, 0xba, 0x48, 0x6f, 0x77, 0xed, 0xe0, 0x8a, 
  0x2c, 0xeb, 0x9c, 0x09, 0x64, 0x6f, 0x65, 0x04, 0x86, 0xdf, 0xd7, 0xa1, 0x47, 0x84, 0x99, 0xcd, 
  0x44, 0x4a, 0x86, 0xcc, 0x00, 0xd7, 0x20, 0xe9, 0x6e, 0xa3, 0xdf, 0xe2, 0xa5, 0x08, 0x45, 0x6a, 
  0x66, 0x42, 0x8f, 0x28, 0x90, 0xcc, 0xa4, 0xa5, 0x20, 0x47, 0x8b, 0xaa, 0x55, 0xe3, 0x71, 0x67, 
  0xef, 0x83, 0x1e, 0xb7, 0x51, 0x72, 0x75, 0x47, 0x89, 0x64, 0x0b, 0xe8, 0x76, 0x00, 0x65, 0xa3, 
  0x42, 0x00, 0xc4, 0x41, 0x9f, 0x4b, 0x28, 0xa7, 0x74, 0x74, 0x6f, 0x1b, 0xa3, 0x5e, 0x86, 0x66, 
  0xdd, 0x4e, 0x61, 0xca, 0xa5, 0xf2, 0x8e, 0x29, 0xcc, 0x89, 0x45, 0x06, 0x87, 0x87, 0xf6, 0x1b, 
  0x66, 0x37, 0x87, 0x37, 0x2a, 0x67, 0xba, 0x8d, 0x5f, 0x7b, 0xc7, 0x86, 0x54, 0x67, 0x20, 0x61, 
  0x47, 0xd2, 0xb7, 0x20, 0x61, 0x88, 0xb1, 0x87, 0x61, 0x60, 0xa7, 0x65, 0xc9, 0xa8, 0x27, 0xe0, 
  0x81, 0xea, 0x74, 0x83, 0x80, 0x87, 0x64, 0x09, 0x87, 0x89, 0x0c, 0x87, 0xde, 0x96, 0xa7, 0x6a, 
  0x73, 0x86, 0xd7, 0x91, 0xa7, 0x10, 0x3c, 0x8b, 0x74, 0xcb, 0x96, 0x74, 0x6f, 0x8d, 0xa6, 0xa7, 
  0xf3, 0x33, 0xa3, 0xf7, 0x64, 0x11, 0x69, 0x73, 0xdb, 0x23, 0xcd, 0x86, 0x3d, 0x84, 0x70, 0x65, 
  0x44, 0x54, 0x09, 0x68, 0x91, 0x62, 0x65, 0x7b, 0x2a, 0x8a, 0x72, 0x3f, 0x86, 0xc5, 0x51, 0xaa, 
  0x72, 0x37, 0x83, 0x06, 0x4c, 0x8f, 0x65, 0x79, 0x3a, 0xa2, 0x86, 0xa7, 0x8f, 0x18, 0x0f, 0xa1, 
  0x60, 0xe1, 0x85, 0xa9, 0xa7, 0x8f, 0x1b, 0x28, 0xac, 0x4e, 0xfb, 0x86, 0xe9, 0x74, 0x45, 0x96, 
  0xa6, 0x7c, 0x4f, 0x3c, 0x2f, 0xb7, 0xc9, 0x73, 0xdd, 0xc4, 0xb7, 0x6c, 0x64, 0xff, 0xcf, 0x87, 
  0x83, 0x1c, 0x42, 0xc2, 0xaa, 0x73, 0x99, 0x83, 0x6f, 0x64, 0x07, 0x33, 0x9e, 0x41, 0x6c, 0x77, 
  0x61, 0x79, 0x73, 0x2d, 0x80, 0x87, 0x07, 0x8d, 0x81, 0x08, 0x46, 0x21, 0x87, 0x7f, 0xe4, 0x7b, 
  0xa7, 0x8e, 0x45, 0xaf, 0x66, 0x86, 0x42, 0x42, 0xa0, 0x45, 0xd5, 0xa6, 0x88, 0x3c, 0x46, 0xd6, 
  0xa7, 0x39, 0x5e, 0x84, 0x6f, 0x87, 0xd1, 0x9b, 0x87, 0x79, 0x87, 0x87, 0x7d, 0xab, 0xa7, 0xd4, 
  0xbd, 0xa7, 0xfe, 0x8d, 0x87, 0x4f, 0x55, 0x22, 0x67, 0x0c, 0x34, 0x87, 0x3f, 0xf4, 0x07, 0xa7, 
  0x16, 0x44, 0xa7, 0x0d, 0xf4, 0x13, 0x63, 0x42, 0x61, 0x76, 0x87, 0x97, 0x33, 0x87, 0xfe, 0xb7, 
  0x87, 0x5c, 0xf0, 0x1c, 0x81, 0x4c, 0xba, 0x09, 0x45, 0x41, 0x4d, 0x9e, 0x18, 0x8c, 0x5f, 0x55, 
  0x36, 0x34, 0x20, 0x28, 0x28, 0x31, 0x20, 0x3c, 0x3c, 0xa7, 0x37, 0x11, 0x9a, 0x07, 0x2d, 0x33, 
  0x29, 0xcf, 0x57, 0x34, 0x29, 0xc3, 0xea, 0x63, 0x01, 0x4f, 0x28, 0xaf, 0x94, 0x2a, 0x20, 0xa0, 
  0x56, 0x59, 0x28, 0x6c, 0x6f, 0x3f, 0x02, 0xd2, 0x97, 0x29, 0x29, 0xad, 0x26, 0x84, 0x4a, 0xab, 
  0x5f, 0x3f, 0x8f, 0x92, 0x69, 0x6e, 0x6e, 0xa4, 0x84, 0x47, 0x21, 0x91, 0x75, 0x63, 0x5a, 0x02, 
  0xa3, 0xef, 0x20, 0xa8, 0xa2, 0xae, 0x84, 0xd6, 0x86, 0x85, 0x18, 0x4b, 0x2e, 0xcf, 0xaa, 0x6d, 
  0x5f, 0x54, 0x69, 0x61, 0x26, 0x69, 0x3a, 0x8b, 0xb3, 0x69, 0x74, 0x6a, 0x47, 0xc5, 0x24, 0x86, 
  0xab, 0x8c, 0x62, 0xc7, 0x6c, 0x91, 0x66, 0x69, 0x84, 0xa3, 0x1d, 0xe4, 0x49, 0x21, 0x81, 0xa6, 
  0xbc, 0xb7, 0x6f, 0x6e, 0xa4, 0x73, 0xb1, 0x64, 0x69, 0x46, 0xad, 0x08, 0x74, 0x82, 0x52, 0x7f, 
  0x47, 0xb5, 0xac, 0x69, 0x1a, 0x18, 0x08, 0x61, 0xa3, 0xaa, 0x73, 0xa4, 0xf8, 0xa1, 0x41, 0xd0, 
  0xb5, 0x6e, 0x6b, 0x3d, 0x42, 0xae, 0xa6, 0x60, 0x68, 0x47, 0xd4, 0xa4, 0xa1, 0x07, 0xa2, 0x4b, 
  0xa1, 0x07, 0xed, 0x00, 0xa2, 0x40, 0x4f, 0xbf, 0x44, 0x4c, 0x4c, 0x14, 0x59, 0xb1, 0x62, 0x65, 
  0x67, 0xdf, 0x42, 0x56, 0x44, 0x0e, 0xa3, 0xcb, 0xa9, 0x65, 0x01, 0x7c, 0xb7, 0x64, 0x73, 0x49, 
  0x02, 0x83, 0xbf, 0xa1, 0xad, 0x83, 0x69, 0x65, 0x49, 0x65, 0xe7, 0x73, 0x20, 0x7b, 0xb5, 0x04, 
  0x8a, 0x74, 0x09, 0x9d, 0x6f, 0x5b, 0x33, 0x7f, 0x14, 0x5d, 0x3b, 0x20, 0x7d, 0x9b, 0x77, 0x3b, 
  0x0a, 0x86, 0x26, 0x00, 0x81, 0x3f, 0xd0, 0x84, 0xa5, 0x01, 0x6d, 0xa7, 0xc2, 0x9b, 0xa4, 0x8e, 
  0x8a, 0x69, 0x51, 0x78, 0x67, 0xe1, 0x47, 0xb1, 0x41, 0x67, 0x5b, 0x43, 0x5e, 0x82, 0x17, 0x6c, 
  0x47, 0xa6, 0x57, 0x20, 0x28, 0x80, 0x3b, 0x6d, 0x2a, 0x43, 0x81, 0x7b, 0x4f, 0x29, 0x74, 0x42, 
  0xa2, 0x22, 0x54, 0x74, 0x65, 0xcd, 0x84, 0x80, 0xdb, 0x66, 0x6f, 0xa2, 0x6f, 0x63, 0x24, 0x89, 
  0x69, 0x58, 0xd1, 0x0a, 0x7a, 0x47, 0x7d, 0xed, 0x46, 0xb5, 0xe8, 0x66, 0x46, 0xb7, 0x00, 0x63, 
  0x99, 0xaa, 0x73, 0x00, 0xda, 0xa5, 0xde, 0xa4, 0x0d, 0x4c, 0x82, 0xf7, 0x85, 0xf3, 0xe2, 0xca, 
  0x78, 0xd8, 0xd7, 0x64, 0x69, 0x74, 0x20, 0x28, 0x58, 0x6f, 0x29, 0x60, 0x42, 0xd6, 0x20, 0xb1, 
  0x66, 0x6d, 0x82, 0xa4, 0xae, 0x68, 0xc7, 0xf9, 0x20, 0x86, 0xf9, 0xf4, 0x45, 0x7a, 0x62, 0x57, 
  0xa2, 0xeb, 0x6b, 0x79, 0x05, 0x41, 0x91, 0xa2, 0x3e, 0x81, 0x94, 0x74, 0x75, 0x57, 0x92, 0x6f, 
  0x66, 0x56, 0x03, 0x83, 0x06, 0x43, 0x8e, 0x84, 0x0a, 0x0f, 0x22, 0x67, 0xac, 0x64, 0x41, 0x1a, 
  0x64, 0x0e, 0x07, 0x39, 0x67, 0xd9, 0xa7, 0x93, 0xd4, 0x07, 0xf1, 0x66, 0xfe, 0x67, 0x82, 0xf3, 
  0x15, 0x9a, 0x6c, 0x6f, 0x61, 0x64, 0x44, 0x69, 0x1f, 0x0b, 0x87, 0xf9, 0xe3, 0x42, 0xdf, 0x56, 
  0x20, 0x61, 0x13, 0x12, 0x64, 0x69, 0xc2, 0xd6, 0xd5, 0x83, 0x1f, 0x0e, 0x46, 0x41, 0xa6, 0x6b, 
  0xab, 0x41, 0xc5, 0x21, 0xb7, 0x65, 0x76, 0x25, 0x0a, 0xa5, 0x34, 0x83, 0x03, 0xe0, 0x92, 0x67, 
  0x6f, 0x4c, 0xac, 0x2c, 0xc1, 0x7d, 0x4f, 0x27, 0xb6, 0x4b, 0x27, 0xdb, 0xc1, 0xd7, 0x1c, 0xea, 
  0x6d, 0x00, 0xe3, 0x67, 0x51, 0x48, 0x4c, 0x61, 0x84, 0x43, 0x5d, 0xa6, 0xb0, 0x82, 0x37, 0x50, 
  0xac, 0x73, 0x5c, 0xa1, 0x41, 0x17, 0xa3, 0x16, 0xa5, 0xa3, 0x6f, 0x47, 0x64, 0x8d, 0x73, 0x15, 
  0x54, 0xa4, 0xae, 0xa7, 0x38, 0xec, 0x81, 0xe0, 0x14, 0x91, 0x4b, 0x42, 0xa3, 0x84, 0x64, 0xaa, 
  0x67, 0xf8, 0x67, 0xc9, 0xf8, 0x01, 0x87, 0x93, 0x42, 0x67, 0xf8, 0x83, 0xd8, 0xe3, 0x22, 0x84, 
  0x68, 0x7e, 0x66, 0xa3, 0x87, 0x3c, 0xac, 0x41, 0xc0, 0x81, 0x83, 0x8b, 0x75, 0xf1, 0x52, 0x86, 
  0x53, 0x86, 0xa2, 0x1c, 0xa6, 0xfd, 0xa9, 0x27, 0x67, 0x48, 0x94, 0x27, 0x2c, 0xcc, 0x63, 0xbf, 
  0xa4, 0xa3, 0xeb, 0x66, 0xac, 0xb7, 0x6c, 0x79, 0xb5, 0x83, 0x61, 0xf3, 0x6f, 0x73, 0x69, 0x96, 
  0x74, 0x6f, 0x00, 0x1d, 0xa7, 0xe7, 0x9e, 0xa3, 0xc7, 0xef, 0x49, 0x24, 0x6f, 0x50, 0x54, 0x46, 
  0xb0, 0xaa, 0x72, 0x60, 0xdc, 0x9d, 0x73, 0x75, 0x6d, 0x19, 0x3c, 0x6d, 0x74, 0x3d, 0x42, 0xb4, 
  0x41, 0x5c, 0xc4, 0xd4, 0xbf, 0xae, 0x6e, 0x63, 0xa4, 0xe8, 0xb0, 0x91, 0x27, 0x64, 0xef, 0x87, 
  0xaf, 0x0c, 0x09, 0xc5, 0xda, 0xca, 0x83, 0x02, 0xbf, 0xa4, 0xc7, 0x87, 0x5f, 0x43, 0x06, 0x61, 
  0x8c, 0xa7, 0x1f, 0xa2, 0x0b, 0x83, 0xc1, 0xbb, 0xa7, 0xdc, 0x31, 0x45, 0x99, 0x82, 0xb3, 0x24, 
  0x2a, 0x97, 0x69, 0x66, 0x14, 0x71, 0xa6, 0xed, 0x94, 0x66, 0x69, 0x84, 0x04, 0x47, 0x3f, 0x84, 
  0xf1, 0xc1, 0x87, 0x0a, 0x91, 0x44, 0x97, 0x86, 0x1c, 0xa5, 0x21, 0x5e, 0x61, 0x80, 0x84, 0x1c, 
  0x87, 0xf3, 0xb1, 0x67, 0x06, 0xef, 0x87, 0xa3, 0xf0, 0x0f, 0x41, 0x01, 0xa7, 0x7b, 0x00, 0xa5, 
  0x7c, 0x22, 0x60, 0xa7, 0x7f, 0x56, 0x87, 0x46, 0xff, 0x00, 0xa7, 0x21, 0x51, 0xfe, 0x73, 0x61, 
  0x76, 0x65, 0x97, 0x49, 0x66, 0xfd, 0xb8, 0x67, 0x03, 0x21, 0xa5, 0x7d, 0x67, 0x98, 0x5f, 0xa6, 
  0x66, 0x91, 0x61, 0x76, 0x1e, 0xe6, 0xc3, 0xd9, 0x2e, 0xb7, 0x61, 0x74, 0xa9, 0x24, 0xae, 0x20, 
  0x8f, 0x42, 0x9c, 0x42, 0x90, 0x6e, 0x20, 0xac, 0x09, 0x61, 0x86, 0x62, 0xb1, 0xa3, 0x10, 0x53, 
  0x20, 0x28, 0x23, 0x03, 0x6f, 0x6b, 0x42, 0x99, 0xa2, 0x7f, 0xa5, 0xbd, 0xad, 0xa3, 0xa0, 0x68, 
  0x64, 0xfd, 0xe8, 0x27, 0xc6, 0xd8, 0xb2, 0x82, 0x6f, 0x93, 0xa7, 0x66, 0x30, 0xa2, 0x17, 0x71, 
  0x61, 0x66, 0x22, 0x92, 0x77, 0x61, 0x8d, 0xfb, 0xa7, 0x8d, 0x1e, 0x87, 0x6c, 0x40, 0x97, 0x73, 
  0x20, 0x67, 0x03, 0x83, 0xe1, 0x42, 0x51, 0x4a, 0x2c, 0xa2, 0x62, 0x0f, 0x87, 0x82, 0x5d, 0x46, 
  0xa2, 0x67, 0x57, 0xee, 0x97, 0x28, 0x29, 0xa6, 0x3e, 0x43, 0x2a, 0x8f, 0x64, 0xa0, 0x7e, 0x87, 
  0xa1, 0xfe, 0x01, 0x87, 0xf3, 0x11, 0xae, 0x2c, 0x9f, 0xa4, 0x2e, 0x33, 0x86, 0x8f, 0x67, 0x66, 
  0x0e, 0x87, 0x8f, 0xf7, 0x07, 0x67, 0xcf, 0x87, 0xe8, 0x95, 0x62, 0x16, 0x87, 0xbf, 0xac, 0x25, 
  0x81, 0xab, 0x16, 0x87, 0xaa, 0xfb, 0x2c, 0x41, 0x29, 0x87, 0xa8, 0xa1, 0x38, 0x44, 0x45, 0x43, 
  0x4f, 0xeb, 0x87, 0xa2, 0x0f, 0x57, 0x20, 0x34, 0xdc, 0x03, 0x86, 0xb3, 0xbb, 0x27, 0x7b, 0x87, 
  0xb5, 0x92, 0x86, 0x09, 0x8f, 0x20, 0xb2, 0xac, 0xa7, 0xc9, 0xdf, 0x46, 0xda, 0xa7, 0xc8, 0xd6, 
  0x47, 0x61, 0x7c, 0xa7, 0xd0, 0xe8, 0x8b, 0x44, 0xe7, 0xa1, 0xcb, 0xca, 0x84, 0x51, 0x27, 0x38, 
  0x87, 0xbf, 0x4b, 0x1e, 0x87, 0xbf, 0x57, 0x03, 0x85, 0x4c, 0xd8, 0x63, 0xe5, 0xa5, 0xbe, 0x46, 
  0x7a, 0x8c, 0x20, 0x25, 0x22, 0x21, 0x97, 0x28, 0x29, 0xbd, 0x31, 0x87, 0xcf, 0x27, 0x0c, 0x86, 
  0xb2, 0x88, 0x61, 0x12, 0x81, 0x00, 0xc5, 0xd8, 0x4a, 0x97, 0x6f, 0x66, 0xbc, 0x82, 0x84, 0xbc, 
  0x67, 0x87, 0x2d, 0xf2, 0x2a, 0x66, 0xba, 0x86, 0xda, 0x41, 0x05, 0x46, 0xbc, 0xaf, 0x2e, 0xc9, 
  0x01, 0x46, 0x10, 0x87, 0xbf, 0xfb, 0x11, 0x46, 0x9f, 0x87, 0xbe, 0xf5, 0x47, 0xab, 0x5b, 0x87, 
  0xef, 0xe9, 0x77, 0x2f, 0x0a, 0x0b, 0x47, 0x67, 0xe4, 0x87, 0x5d, 0x4f, 0x07, 0x6d, 0x47, 0x8c, 
  0x4f, 0x28, 0xa4, 0xd6, 0x26, 0xa7, 0xe0, 0x55, 0x67, 0x0a, 0xbb, 0xa7, 0x68, 0xf5, 0x03, 0x44, 
  0x13, 0x84, 0x05, 0x84, 0x56, 0x18, 0xa4, 0x81, 0xa7, 0xc2, 0x62, 0x63, 0xa1, 0xcc, 0x53, 0xd9, 
  0xec, 0xa7, 0xce, 0xc3, 0xb1, 0x20, 0x28, 0x33, 0x37, 0xc6, 0xd7, 0x0c, 0xa4, 0x30, 0x41, 0x7d, 
  0xaf, 0x29, 0xc5, 0xac, 0xaa, 0x31, 0xd0, 0xc4, 0x9f, 0x4f, 0x4b, 0x2c, 0xea, 0x3a, 0x47, 0x4b, 
  0xae, 0x47, 0x0e, 0x27, 0x67, 0xa7, 0xcf, 0xb5, 0x15, 0xaf, 0x2a, 0xe2, 0x6b, 0xa6, 0x7b, 0xe6, 
  0xa3, 0x69, 0xa6, 0x60, 0x5f, 0x67, 0xe3, 0x45, 0x26, 0x87, 0x75, 0xd7, 0x42, 0x0a, 0xa9, 0x6d, 
  0x6f, 0x56, 0x89, 0x69, 0x01, 0xa6, 0xc2, 0xcf, 0xa9, 0x69, 0x2f, 0xae, 0x73, 0x96, 0xa8, 0x8a, 
  0x22, 0x91, 0xa5, 0x3c, 0xa0, 0xaf, 0x50, 0x99, 0x07, 0x86, 0xc7, 0x46, 0xcd, 0x8a, 0x2a, 0xcd, 
  0x2c, 0xaf, 0x2a, 0xf6, 0xc0, 0xfe, 0x74, 0x68, 0x65, 0xa6, 0x7a, 0x95, 0x66, 0x65, 0x81, 0xf1, 
  0xa7, 0x84, 0x58, 0xa1, 0x3b, 0xaa, 0x6a, 0x70, 0x3d, 0x86, 0x80, 0x00, 0xfa, 0x85, 0x70, 0x87, 
  0xa2, 0xe5, 0x69, 0x72, 0x4e, 0x85, 0xc1, 0x78, 0xcf, 0x73, 0xdb, 0xda, 0x87, 0x56, 0xb1, 0xa5, 
  0x42, 0x22, 0x65, 0xf0, 0x9b, 0x2d, 0x20, 0x45, 0x78, 0x61, 0x94, 0x48, 0x62, 0x2e, 0x63, 0x13, 
  0x62, 0x30, 0x57, 0x65, 0x6e, 0xc4, 0x84, 0x1f, 0xe3, 0x44, 0xdd, 0x40, 0x79, 0xaa, 0x64, 0xa5, 
  0x51, 0x72, 0x75, 0x3d, 0x6b, 0x28, 0xea, 0x87, 0x53, 0xd4, 0x00, 0x22, 0x44, 0xb7, 0x46, 0x31, 
  0x4a, 0x73, 0x55, 0x44, 0x53, 0xa4, 0x70, 0x42, 0x51, 0x83, 0x12, 0x28, 0x67, 0x7a, 0x4f, 0x26, 
  0x90, 0x01, 0x47, 0x3d, 0xa5, 0x7c, 0xe0, 0x8a, 0x68, 0xeb, 0x20, 0xcb, 0xa4, 0x69, 0xc7, 0xdb, 
  0xf9, 0x33, 0xa1, 0xb9, 0x8c, 0x79, 0x76, 0x03, 0xa1, 0x68, 0xa2, 0xd1, 0xb7, 0x75, 0x20, 0x3c, 
  0xe4, 0x4d, 0x2e, 0x27, 0xae, 0x4c, 0xa6, 0x57, 0x61, 0x6e, 0x30, 0x95, 0xb7, 0x62, 0x79, 0xcd, 
  0x3b, 0x83, 0xa9, 0x6a, 0x42, 0x51, 0x81, 0xba, 0xa7, 0xa4, 0x7d, 0xa7, 0x53, 0xca, 0x0f, 0x20, 
  0x04, 0x84, 0xce, 0xd6, 0xa1, 0xed, 0xc3, 0xcb, 0x9b, 0xa5, 0x6a, 0x9e, 0x28, 0x70, 0x09, 0x64, 
  0x81, 0xaa, 0x2e, 0x92, 0xc7, 0xdd, 0x1b, 0x9c, 0x82, 0x5c, 0x84, 0x52, 0x57, 0x8f, 0x64, 0x24, 
  0x3c, 0x86, 0x15, 0xa2, 0xef, 0x42, 0x86, 0x9d, 0x6f, 0x2e, 0xd0, 0xc4, 0x63, 0x6f, 0x86, 0xad, 
  0x67, 0x26, 0x7c, 0x89, 0x73, 0x01, 0x82, 0xbc, 0x4f, 0x86, 0x00, 0x83, 0x65, 0xe9, 0x50, 0x79, 
  0x6e, 0xc4, 0x81, 0x47, 0xb4, 0x69, 0x7a, 0x22, 0x44, 0xa5, 0x42, 0x67, 0x97, 0xff, 0x1a, 0x67, 
  0x9c, 0x06, 0x99, 0x00, 0x5f, 0x41, 0x74, 0x84, 0x82, 0xa3, 0x5e, 0x04, 0xa1, 0x84, 0x15, 0xad, 
  0x38, 0x69, 0x6f, 0x2b, 0xac, 0x4f, 0x47, 0x29, 0x79, 0x8f, 0x6c, 0xf1, 0xe2, 0x67, 0xb0, 0x60, 
  0xa5, 0x63, 0xe8, 0x57, 0x83, 0x69, 0x78, 0xa4, 0x36, 0xc7, 0xc8, 0x74, 0x62, 0x43, 0x68, 0xa6, 
  0x66, 0x8b, 0x2c, 0xb0, 0x45, 0xa3, 0x55, 0xe9, 0x6c, 0xc3, 0xd1, 0x70, 0x81, 0xeb, 0xc4, 0x44, 
  0xa9, 0xa5, 0xdc, 0x87, 0xb3, 0x2a, 0x65, 0x49, 0xa7, 0x11, 0xad, 0x86, 0x22, 0x5f, 0x85, 0x6e, 
  0x8a, 0x69, 0x6b, 0x51, 0x84, 0xc7, 0xa7, 0xdf, 0x26, 0x02, 0x97, 0x28, 0x29, 0x6f, 0x62, 0x03, 
  0x86, 0xae, 0xca, 0xa7, 0xab, 0xff, 0x11, 0xc7, 0xd2, 0x90, 0x36, 0x87, 0x4e, 0x0d, 0x47, 0x6a, 
  0xf4, 0x3d, 0xa6, 0xde, 0x87, 0x23, 0x72, 0xc6, 0xd8, 0x79, 0xa7, 0xeb, 0x18, 0x89, 0x3a, 0xda, 
  0xea, 0x63, 0xab, 0x82, 0xe8, 0x87, 0xdf, 0xe9, 0x09, 0x82, 0x23, 0xc9, 0xcf, 0x6b, 0xdd, 0x46, 
  0x64, 0x4c, 0x62, 0xf4, 0x8e, 0x62, 0x4d, 0xf3, 0x77, 0x6f, 0x66, 0x60, 0xc5, 0xc6, 0x37, 0xc3, 
  0xdd, 0x52, 0x67, 0xf1, 0x7a, 0x8f, 0x78, 0xd1, 0x26, 0x46, 0x7f, 0x8e, 0x79, 0xda, 0xf8, 0x0e, 
  0x6e, 0x64, 0x2d, 0x81, 0x2b, 0x2b, 0x2e, 0x5a, 0x87, 0x24, 0x2e, 0xc2, 0xd3, 0x5e, 0xa4, 0x80, 
  0x87, 0xcf, 0x34, 0x09, 0x8f, 0x2e, 0xff, 0xe2, 0x03, 0x47, 0x00, 0x1f, 0xc7, 0xd0, 0x97, 0x34, 
  0xa7, 0xda, 0x65, 0xb0, 0x53, 0x74, 0xd8, 0x66, 0xef, 0x74, 0x87, 0xfe, 0xe2, 0x47, 0x6a, 0xff, 
  0x18, 0x66, 0x07, 0x47, 0x85, 0x14, 0xc7, 0xce, 0xcd, 0xf1, 0x16, 0xf8, 0x4f, 0x62, 0x73, 0x6f, 
  0xcf, 0x74, 0xce, 0xcb, 0xf6, 0x1c, 0xca, 0x2f, 0xcd, 0xf9, 0x41, 0x24, 0x83, 0x75, 0x48, 0x57, 
  0x6b, 0xc2, 0xcc, 0xbd, 0x14, 0x73, 0x20, 0x34, 0xab, 0x53, 0x25, 0x85, 0x62, 0xdf, 0x2e, 0x77, 
  0x81, 0x2b, 0xba, 0xa2, 0xa9, 0xab, 0x73, 0x2b, 0x33, 0xa2, 0xda, 0x89, 0x62, 0xde, 0x9f, 0x82, 
  0xdd, 0x84, 0xe2, 0xf1, 0xc4, 0xc9, 0xde, 0x83, 0x1d, 0xa6, 0x02, 0xec, 0x83, 0x7b, 0x20, 0x3a, 
  0x0b, 0x61, 0x4c, 0x68, 0xd3, 0xa4, 0x03, 0xba, 0x5e, 0x2d, 0x57, 0x6e, 0x6f, 0x2d, 0x64, 0x80, 
  0x09, 0x64, 0xa9, 0xc1, 0xc4, 0x4e, 0xa4, 0x1d, 0xa4, 0x21, 0x32, 0xbc, 0x67, 0x63, 0x63, 0x0a, 
  0x04, 0x6c, 0xda, 0x5f, 0x43, 0x52, 0x54, 0x5f, 0x53, 0x45, 0xc6, 0xd1, 0x9a, 0x97, 0x5f, 0x4e, 
  0x4f, 0x5f, 0x57, 0x41, 0x52, 0x4e, 0x49, 0x4e, 0x47, 0x53, 0x00, 0xa8, 0x56, 0xc3, 0x10, 0xe8, 
  0x75, 0xc7, 0xd7, 0x81, 0xcf, 0x2e, 0xc8, 0x02, 0x2a, 0xc4, 0xd7, 0x22, 0xa7, 0x6b, 0x26, 0x5e, 
  0x44, 0x45, 0x50, 0x52, 0x45, 0x43, 0x41, 0x54, 0x45, 0xbb, 0x21, 0x74, 0x59, 0x46, 0x42, 0x4c, 
  0x4f, 0x43, 0x4b, 0x2e, 0x07, 0xc2, 0xc8, 0x7e, 0xe9, 0x6e, 0x47, 0xd5, 0xff, 0x07, 0x40, 0xd9, 
  0x4d, 0x20, 0xac, 0x47, 0xd7, 0x16, 0xde, 0x00, 0x47, 0x43, 0x43, 0xc9, 0xc6, 0xc2, 0xc8, 0x20, 
  0x38, 0x47, 0x4e, 0x55, 0x87, 0xa9, 0x5f, 0xd4, 0xc4, 0xca, 0xc5, 0x04, 0x71, 0xc4, 0xc9, 0xf5, 
  0x00, 0x49, 0x29, 0x9b, 0x82, 0xb6, 0x65, 0x4f, 0x28, 0xc7, 0x82, 0x7d, 0xb0, 0xd1, 0x34, 0x30, 
  0xd5, 0x30, 0xd6, 0x7c, 0x7c, 0xc7, 0xd4, 0x41, 0xb5, 0x61, 0xc6, 0x55, 0x6e, 0x67, 0xcb, 0x47, 
  0x64, 0x75, 0x44, 0x28, 0x44, 0x49, 0x29, 0x97, 0xd4, 0x61, 0x74, 0xc1, 0xd2, 0x08, 0x65, 0xa1, 
  0x77, 0x28, 0x28, 0x7d, 0x47, 0xdd, 0x0e, 0x4b, 0x29, 0x82, 0x57, 0x65, 0x6c, 0x80, 0x5f, 0x0f, 
  0x33, 0x30, 0x31, 0x96, 0x27, 0x47, 0x9f, 0x11, 0x47, 0x3b, 0x73, 0x4d, 0x53, 0xe2, 0x47, 0x3c, 
  0xff, 0x10, 0x82, 0xd1, 0x82, 0x0a, 0xf4, 0x47, 0x40, 0x46, 0x41, 0x74, 0x73, 0x65, 0xf0, 0xc5, 
  0xc6, 0x9b, 0x25, 0x1f, 0x75, 0x28, 0x22, 0x59, 0x8a, 0x3a, 0xda, 0xa6, 0xdc, 0x48, 0xa7, 0xd3, 
  0x16, 0x67, 0xc8, 0xa2, 0x61, 0x27, 0xa3, 0x86, 0xc5, 0xd4, 0xe8, 0x7f, 0x0f, 0x65, 0x72, 0x22, 
  0x99, 0x0c, 0x63, 0xbe, 0xc4, 0xc6, 0x57, 0x0b, 0x23, 0xcf, 0xc1, 0xd2, 0xf3, 0x87, 0x7e, 0xff, 
  0x07, 0xcc, 0x20, 0xc7, 0x3f, 0xa6, 0x2e, 0xc7, 0xd8, 0x8c, 0xdf, 0xa5, 0x60, 0x85, 0xa5, 0xdd, 
  0x26, 0x84, 0x62, 0x2c, 0xfd, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x82, 0xef, 0x2b, 0xc6, 0xc6, 0x4f, 
  0xa7, 0x3f, 0x20, 0xa9, 0x62, 0xbd, 0xb8, 0x0f, 0x31, 0x33, 0x31, 0x43, 0xe9, 0x70, 0xa1, 0xc7, 
  0x05, 0x83, 0xb9, 0xa7, 0x7b, 0x28, 0xa7, 0xa5, 0x02, 0xc7, 0xd7, 0x7f, 0xfb, 0x18, 0xc7, 0xd9, 
  0x19, 0xc5, 0xcc, 0x81, 0x83, 0x1f, 0xc0, 0xc7, 0xd7, 0x2e, 0x22, 0xa5, 0x1e, 0xb0, 0x47, 0x9c, 
  0x82, 0xef, 0xa7, 0xc4, 0xd8, 0xb9, 0x07, 0x4f, 0xc7, 0xd8, 0xab, 0x20, 0x47, 0x35, 0xf1, 0x0d, 
  0x47, 0x8b, 0x47, 0x99, 0xff, 0x20, 0x47, 0x1f, 0x12, 0xa7, 0x61, 0x97, 0x67, 0x60, 0x74, 0xa7, 
  0xb0, 0x96, 0xa7, 0x84, 0x0f, 0x47, 0x0f, 0x39, 0x46, 0x7b, 0x47, 0x89, 0xfe, 0x33, 0x67, 0x1e, 
  0xa7, 0xf5, 0xf0, 0xb7, 0x64, 0x65, 0xff, 0xee, 0x12, 0xb1, 0x20, 0x6e, 0xc5, 0xf5, 0xa3, 0x15, 
  0xc7, 0xd8, 0x41, 0x3e, 0x87, 0x14, 0x1b, 0x82, 0x2d, 0x84, 0x92, 0x93, 0xb2, 0x6e, 0x6f, 0x47, 
  0xa2, 0xb2, 0x99, 0x8a, 0x62, 0x4b, 0x85, 0x0c, 0x93, 0x86, 0x15, 0xa3, 0x21, 0xbe, 0xc7, 0xd0, 
  0xe0, 0x83, 0xbd, 0x05, 0xc6, 0xd0, 0xdb, 0x81, 0x54, 0xc3, 0xc4, 0x7d, 0xc4, 0xd7, 0xe9, 0xc2, 
  0xd8, 0xb4, 0x20, 0x1a, 0xc6, 0xc2, 0xbd, 0xad, 0x73, 0x1f, 0x63, 0xec, 0xc7, 0xd9, 0xd0, 0x16, 
  0xc7, 0xd3, 0x9d, 0x87, 0xcb, 0x9d, 0x47, 0xc8, 0xca, 0x01, 0xc2, 0xd4, 0xfd, 0x6f, 0x6e, 0xe3, 
  0x16, 0x47, 0xb6, 0xa7, 0xcb, 0xbd, 0x41, 0x38, 0x67, 0xea, 0x60, 0x83, 0xab, 0xaa, 0x6f, 0x2a, 
  0x92, 0x86, 0xdf, 0xae, 0x77, 0xd9, 0x62, 0xd4, 0x64, 0x3b, 0xd9, 0x29, 0x82, 0xd0, 0xa3, 0xd1, 
  0x56, 0x43, 0x06, 0x86, 0xe5, 0xb2, 0x72, 0x65, 0xd5, 0x2a, 0x83, 0x44, 0x03, 0x10, 0x62, 0xdc, 
  0x85, 0x4e, 0xd2, 0x68, 0x69, 0xd2, 0x94, 0xc7, 0xc8, 0x54, 0x31, 0xc6, 0xdc, 0xd9, 0x84, 0xdf, 
  0x84, 0xc2, 0xbc, 0x47, 0x86, 0x64, 0x85, 0x69, 0x69, 0xda, 0xab, 0x74, 0x83, 0x22, 0xa2, 0xea, 
  0x92, 0x74, 0x61, 0xd9, 0x36, 0xa2, 0xdb, 0x66, 0x31, 0x21, 0x66, 0x67, 0xc4, 0xa7, 0xcf, 0x8e, 
  0x0f, 0x87, 0xe2, 0xdf, 0x47, 0xb5, 0xbe, 0x67, 0xb1, 0x47, 0xa3, 0xfe, 0x0e, 0x97, 0x69, 0x73, 
  0x74, 0xfe, 0x00, 0xa7, 0x43, 0x71, 0x85, 0xf3, 0xa7, 0x84, 0x41, 0xaa, 0x3b, 0x21, 0x8c, 0xc2, 
  0xc2, 0x29, 0x05, 0xc7, 0xc1, 0xdc, 0x5a, 0xae, 0x77, 0x35, 0xa6, 0xad, 0x4e, 0x42, 0xad, 0xa7, 
  0x3c, 0x62, 0x49, 0x22, 0xbf, 0xa7, 0xd3, 0x91, 0xae, 0x29, 0xb3, 0x28, 0x22, 0xbe, 0x83, 0x7e, 
  0x47, 0xdd, 0x14, 0x86, 0x6a, 0xa4, 0xf4, 0x98, 0x85, 0x69, 0x4f, 0x3b, 0xa9, 0xf2, 0x1a, 0xa3, 
  0x77, 0xc7, 0xd2, 0x65, 0x32, 0x43, 0x22, 0xc7, 0xd3, 0x28, 0x47, 0xac, 0xe1, 0xa6, 0xcf, 0x47, 
  0xad, 0xa2, 0x46, 0xac, 0x46, 0xdd, 0x47, 0xad, 0xa7, 0xe5, 0x51, 0x47, 0x3f, 0xf3, 0x14, 0x86, 
  0xf1, 0x47, 0x96, 0x4f, 0x01, 0x44, 0xbb, 0x44, 0x3f, 0xa9, 0x6c, 0xf1, 0x36, 0x6f, 0x49, 0xf1, 
  0x87, 0xd4, 0xe3, 0x77, 0x29, 0x3b, 0x3a, 0xe7, 0xa7, 0x72, 0xae, 0x67, 0x60, 0x87, 0xaf, 0x33, 
  0x06, 0x67, 0xaa, 0x7b, 0x47, 0xd2, 0x83, 0xd2, 0x39, 0x81, 0x46, 0x79, 0x33, 0x66, 0x69, 0x78, 
  0x36, 0x34, 0x6b, 0x3e, 0xa7, 0xc5, 0xea, 0x87, 0x05, 0x93, 0xa7, 0xbe, 0xbd, 0x67, 0x65, 0x87, 
  0xae, 0x23, 0x47, 0x5a, 0xeb, 0x47, 0xd2, 0x47, 0x5a, 0xf9, 0x10, 0xa7, 0xfc, 0xef, 0xc7, 0xbd, 
  0x11, 0x04, 0xce, 0x7d, 0xbd, 0x1c, 0xe7, 0xf0, 0xe8,
};

static unsigned char buf[18830];

int main() {

        unsigned long cksum = adler32(0, NULL, 0);

        decompress_lzsa2(compressed, buf);
        cksum = adler32(cksum, buf, 18830);

        return cksum == 0xf748269d ? 0 : 1;
}
