<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* SettingStateDeviceSummary File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Microsoft\Graph\Model;

/**
* SettingStateDeviceSummary class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class SettingStateDeviceSummary extends Entity
{
    /**
    * Gets the compliantDeviceCount
    * Device Compliant count for the setting
    *
    * @return int|null The compliantDeviceCount
    */
    public function getCompliantDeviceCount()
    {
        if (array_key_exists("compliantDeviceCount", $this->_propDict)) {
            return $this->_propDict["compliantDeviceCount"];
        } else {
            return null;
        }
    }

    /**
    * Sets the compliantDeviceCount
    * Device Compliant count for the setting
    *
    * @param int $val The compliantDeviceCount
    *
    * @return SettingStateDeviceSummary
    */
    public function setCompliantDeviceCount($val)
    {
        $this->_propDict["compliantDeviceCount"] = intval($val);
        return $this;
    }

    /**
    * Gets the conflictDeviceCount
    * Device conflict error count for the setting
    *
    * @return int|null The conflictDeviceCount
    */
    public function getConflictDeviceCount()
    {
        if (array_key_exists("conflictDeviceCount", $this->_propDict)) {
            return $this->_propDict["conflictDeviceCount"];
        } else {
            return null;
        }
    }

    /**
    * Sets the conflictDeviceCount
    * Device conflict error count for the setting
    *
    * @param int $val The conflictDeviceCount
    *
    * @return SettingStateDeviceSummary
    */
    public function setConflictDeviceCount($val)
    {
        $this->_propDict["conflictDeviceCount"] = intval($val);
        return $this;
    }

    /**
    * Gets the errorDeviceCount
    * Device error count for the setting
    *
    * @return int|null The errorDeviceCount
    */
    public function getErrorDeviceCount()
    {
        if (array_key_exists("errorDeviceCount", $this->_propDict)) {
            return $this->_propDict["errorDeviceCount"];
        } else {
            return null;
        }
    }

    /**
    * Sets the errorDeviceCount
    * Device error count for the setting
    *
    * @param int $val The errorDeviceCount
    *
    * @return SettingStateDeviceSummary
    */
    public function setErrorDeviceCount($val)
    {
        $this->_propDict["errorDeviceCount"] = intval($val);
        return $this;
    }

    /**
    * Gets the instancePath
    * Name of the InstancePath for the setting
    *
    * @return string|null The instancePath
    */
    public function getInstancePath()
    {
        if (array_key_exists("instancePath", $this->_propDict)) {
            return $this->_propDict["instancePath"];
        } else {
            return null;
        }
    }

    /**
    * Sets the instancePath
    * Name of the InstancePath for the setting
    *
    * @param string $val The instancePath
    *
    * @return SettingStateDeviceSummary
    */
    public function setInstancePath($val)
    {
        $this->_propDict["instancePath"] = $val;
        return $this;
    }

    /**
    * Gets the nonCompliantDeviceCount
    * Device NonCompliant count for the setting
    *
    * @return int|null The nonCompliantDeviceCount
    */
    public function getNonCompliantDeviceCount()
    {
        if (array_key_exists("nonCompliantDeviceCount", $this->_propDict)) {
            return $this->_propDict["nonCompliantDeviceCount"];
        } else {
            return null;
        }
    }

    /**
    * Sets the nonCompliantDeviceCount
    * Device NonCompliant count for the setting
    *
    * @param int $val The nonCompliantDeviceCount
    *
    * @return SettingStateDeviceSummary
    */
    public function setNonCompliantDeviceCount($val)
    {
        $this->_propDict["nonCompliantDeviceCount"] = intval($val);
        return $this;
    }

    /**
    * Gets the notApplicableDeviceCount
    * Device Not Applicable count for the setting
    *
    * @return int|null The notApplicableDeviceCount
    */
    public function getNotApplicableDeviceCount()
    {
        if (array_key_exists("notApplicableDeviceCount", $this->_propDict)) {
            return $this->_propDict["notApplicableDeviceCount"];
        } else {
            return null;
        }
    }

    /**
    * Sets the notApplicableDeviceCount
    * Device Not Applicable count for the setting
    *
    * @param int $val The notApplicableDeviceCount
    *
    * @return SettingStateDeviceSummary
    */
    public function setNotApplicableDeviceCount($val)
    {
        $this->_propDict["notApplicableDeviceCount"] = intval($val);
        return $this;
    }

    /**
    * Gets the remediatedDeviceCount
    * Device Compliant count for the setting
    *
    * @return int|null The remediatedDeviceCount
    */
    public function getRemediatedDeviceCount()
    {
        if (array_key_exists("remediatedDeviceCount", $this->_propDict)) {
            return $this->_propDict["remediatedDeviceCount"];
        } else {
            return null;
        }
    }

    /**
    * Sets the remediatedDeviceCount
    * Device Compliant count for the setting
    *
    * @param int $val The remediatedDeviceCount
    *
    * @return SettingStateDeviceSummary
    */
    public function setRemediatedDeviceCount($val)
    {
        $this->_propDict["remediatedDeviceCount"] = intval($val);
        return $this;
    }

    /**
    * Gets the settingName
    * Name of the setting
    *
    * @return string|null The settingName
    */
    public function getSettingName()
    {
        if (array_key_exists("settingName", $this->_propDict)) {
            return $this->_propDict["settingName"];
        } else {
            return null;
        }
    }

    /**
    * Sets the settingName
    * Name of the setting
    *
    * @param string $val The settingName
    *
    * @return SettingStateDeviceSummary
    */
    public function setSettingName($val)
    {
        $this->_propDict["settingName"] = $val;
        return $this;
    }

    /**
    * Gets the unknownDeviceCount
    * Device Unkown count for the setting
    *
    * @return int|null The unknownDeviceCount
    */
    public function getUnknownDeviceCount()
    {
        if (array_key_exists("unknownDeviceCount", $this->_propDict)) {
            return $this->_propDict["unknownDeviceCount"];
        } else {
            return null;
        }
    }

    /**
    * Sets the unknownDeviceCount
    * Device Unkown count for the setting
    *
    * @param int $val The unknownDeviceCount
    *
    * @return SettingStateDeviceSummary
    */
    public function setUnknownDeviceCount($val)
    {
        $this->_propDict["unknownDeviceCount"] = intval($val);
        return $this;
    }

}
