---
name: Bug report
about: Create a report to help us improve
title: ''
labels: ''
assignees: ''

---

**IMPORTANT: Check the docs**
Before submitting new issue, please check the [Troubleshooting Guide](https://github.com/jgromes/RadioLib/wiki/Troubleshooting-Guide) Wiki page and the [API documentation](https://jgromes.github.io/RadioLib/). If you are seeing an error code, we have [online status code decoder](https://radiolib-org.github.io/status_decoder/decode.html).

**Describe the bug**
A clear and concise description of what the bug is. When applicable, please include [debug mode output](https://github.com/jgromes/RadioLib/wiki/Debug-mode) **using the appropriate debug mode**.

<details><summary>Debug mode output</summary>
<p>

```
paste the debug output here
```

</p>
</details> 

**To Reproduce**
Minimal Arduino sketch to reproduce the behavior. Please use Markdown to style the code to make it readable (see [Markdown Cheatsheet](https://github.com/adam-p/markdown-here/wiki/Markdown-Cheatsheet#code)).

<details><summary>Sketch that is causing the module fail</summary>
<p>

```c++
paste the sketch here, even if it is an unmodified example code
```

</p>
</details> 

**Expected behavior**
A clear and concise description of what you expected to happen.

**Screenshots**
If applicable, add screenshots to help explain your problem.

**Additional info (please complete):**
 - MCU: [e.g. Arduino Uno, ESP8266 etc.]
 - Link to Arduino core: [e.g. https://github.com/stm32duino/Arduino_Core_STM32 when using official STM32 core. See readme for links to all supported cores]
 - Wireless module type [e.g. CC1101, SX1268, etc.]
 - Arduino IDE version  [e.g. 1.8.5]
 - Library version [e.g. 3.0.0 or git hash]
