#if HAS_TFT // VIEW_240x240

#include "graphics/view/TFT/TFTView_240x240.h"
#include "graphics/common/ViewController.h"
#include "graphics/driver/DisplayDriverFactory.h"
#include "ui.h" // this is the ui generated by lvgl / squareline editor
#include "util/ILog.h"
#include <cstdio>
#include <functional>

TFTView_240x240 *TFTView_240x240::gui = nullptr;

TFTView_240x240 *TFTView_240x240::instance(void)
{
    if (!gui)
        gui = new TFTView_240x240(nullptr, DisplayDriverFactory::create(240, 240));
    return gui;
}

TFTView_240x240 *TFTView_240x240::instance(const DisplayDriverConfig &cfg)
{
    if (!gui)
        gui = new TFTView_240x240(&cfg, DisplayDriverFactory::create(cfg));
    return gui;
}

TFTView_240x240::TFTView_240x240(const DisplayDriverConfig *cfg, DisplayDriver *driver)
    : MeshtasticView(cfg, driver, new ViewController)
{
}

void TFTView_240x240::init(IClientBase *client)
{
    ILOG_DEBUG("TFTView init...");
    MeshtasticView::init(client);

    // ui_set_active(ui_HomeButton, ui_HomePanel, ui_TopPanel);
    // ui_events_init();

    // keyboard init
    // lv_keyboard_set_textarea(ui_Keyboard, ui_MessageInputArea);
}

void TFTView_240x240::task_handler(void)
{
    MeshtasticView::task_handler();
}

#endif