/* Automatically generated nanopb header */
/* Generated by nanopb-0.4.9.1 */

#ifndef PB_MESHTASTIC_MESHTASTIC_DEVICE_UI_PB_H_INCLUDED
#define PB_MESHTASTIC_MESHTASTIC_DEVICE_UI_PB_H_INCLUDED
#include <pb.h>

#if PB_PROTO_HEADER_VERSION != 40
#error Regenerate this file with the current version of nanopb generator.
#endif

/* Enum definitions */
typedef enum _meshtastic_CompassMode {
    /* Compass with dynamic ring and heading */
    meshtastic_CompassMode_DYNAMIC = 0,
    /* Compass with fixed ring and heading */
    meshtastic_CompassMode_FIXED_RING = 1,
    /* Compass with heading and freeze option */
    meshtastic_CompassMode_FREEZE_HEADING = 2
} meshtastic_CompassMode;

typedef enum _meshtastic_Theme {
    /* Dark */
    meshtastic_Theme_DARK = 0,
    /* Light */
    meshtastic_Theme_LIGHT = 1,
    /* Red */
    meshtastic_Theme_RED = 2
} meshtastic_Theme;

/* Localization */
typedef enum _meshtastic_Language {
    /* English */
    meshtastic_Language_ENGLISH = 0,
    /* French */
    meshtastic_Language_FRENCH = 1,
    /* German */
    meshtastic_Language_GERMAN = 2,
    /* Italian */
    meshtastic_Language_ITALIAN = 3,
    /* Portuguese */
    meshtastic_Language_PORTUGUESE = 4,
    /* Spanish */
    meshtastic_Language_SPANISH = 5,
    /* Swedish */
    meshtastic_Language_SWEDISH = 6,
    /* Finnish */
    meshtastic_Language_FINNISH = 7,
    /* Polish */
    meshtastic_Language_POLISH = 8,
    /* Turkish */
    meshtastic_Language_TURKISH = 9,
    /* Serbian */
    meshtastic_Language_SERBIAN = 10,
    /* Russian */
    meshtastic_Language_RUSSIAN = 11,
    /* Dutch */
    meshtastic_Language_DUTCH = 12,
    /* Greek */
    meshtastic_Language_GREEK = 13,
    /* Norwegian */
    meshtastic_Language_NORWEGIAN = 14,
    /* Slovenian */
    meshtastic_Language_SLOVENIAN = 15,
    /* Ukrainian */
    meshtastic_Language_UKRAINIAN = 16,
    /* Bulgarian */
    meshtastic_Language_BULGARIAN = 17,
    /* Czech */
    meshtastic_Language_CZECH = 18,
    /* Danish */
    meshtastic_Language_DANISH = 19,
    /* Simplified Chinese (experimental) */
    meshtastic_Language_SIMPLIFIED_CHINESE = 30,
    /* Traditional Chinese (experimental) */
    meshtastic_Language_TRADITIONAL_CHINESE = 31
} meshtastic_Language;

/* How the GPS coordinates are displayed on the OLED screen. */
typedef enum _meshtastic_DeviceUIConfig_GpsCoordinateFormat {
    /* GPS coordinates are displayed in the normal decimal degrees format:
 DD.DDDDDD DDD.DDDDDD */
    meshtastic_DeviceUIConfig_GpsCoordinateFormat_DEC = 0,
    /* GPS coordinates are displayed in the degrees minutes seconds format:
 DD°MM'SS"C DDD°MM'SS"C, where C is the compass point representing the locations quadrant */
    meshtastic_DeviceUIConfig_GpsCoordinateFormat_DMS = 1,
    /* Universal Transverse Mercator format:
 ZZB EEEEEE NNNNNNN, where Z is zone, B is band, E is easting, N is northing */
    meshtastic_DeviceUIConfig_GpsCoordinateFormat_UTM = 2,
    /* Military Grid Reference System format:
 ZZB CD EEEEE NNNNN, where Z is zone, B is band, C is the east 100k square, D is the north 100k square,
 E is easting, N is northing */
    meshtastic_DeviceUIConfig_GpsCoordinateFormat_MGRS = 3,
    /* Open Location Code (aka Plus Codes). */
    meshtastic_DeviceUIConfig_GpsCoordinateFormat_OLC = 4,
    /* Ordnance Survey Grid Reference (the National Grid System of the UK).
 Format: AB EEEEE NNNNN, where A is the east 100k square, B is the north 100k square,
 E is the easting, N is the northing */
    meshtastic_DeviceUIConfig_GpsCoordinateFormat_OSGR = 5,
    /* Maidenhead Locator System
 Described here: https://en.wikipedia.org/wiki/Maidenhead_Locator_System */
    meshtastic_DeviceUIConfig_GpsCoordinateFormat_MLS = 6
} meshtastic_DeviceUIConfig_GpsCoordinateFormat;

/* Struct definitions */
typedef struct _meshtastic_NodeFilter {
    /* Filter unknown nodes */
    bool unknown_switch;
    /* Filter offline nodes */
    bool offline_switch;
    /* Filter nodes w/o public key */
    bool public_key_switch;
    /* Filter based on hops away */
    int8_t hops_away;
    /* Filter nodes w/o position */
    bool position_switch;
    /* Filter nodes by matching name string */
    char node_name[16];
    /* Filter based on channel */
    int8_t channel;
} meshtastic_NodeFilter;

typedef struct _meshtastic_NodeHighlight {
    /* Hightlight nodes w/ active chat */
    bool chat_switch;
    /* Highlight nodes w/ position */
    bool position_switch;
    /* Highlight nodes w/ telemetry data */
    bool telemetry_switch;
    /* Highlight nodes w/ iaq data */
    bool iaq_switch;
    /* Highlight nodes by matching name string */
    char node_name[16];
} meshtastic_NodeHighlight;

typedef struct _meshtastic_GeoPoint {
    /* Zoom level */
    int8_t zoom;
    /* Coordinate: latitude */
    int32_t latitude;
    /* Coordinate: longitude */
    int32_t longitude;
} meshtastic_GeoPoint;

typedef struct _meshtastic_Map {
    /* Home coordinates */
    bool has_home;
    meshtastic_GeoPoint home;
    /* Map tile style */
    char style[20];
    /* Map scroll follows GPS */
    bool follow_gps;
} meshtastic_Map;

typedef PB_BYTES_ARRAY_T(16) meshtastic_DeviceUIConfig_calibration_data_t;
typedef struct _meshtastic_DeviceUIConfig {
    /* A version integer used to invalidate saved files when we make incompatible changes. */
    uint32_t version;
    /* TFT display brightness 1..255 */
    uint8_t screen_brightness;
    /* Screen timeout 0..900 */
    uint16_t screen_timeout;
    /* Screen/Settings lock enabled */
    bool screen_lock;
    bool settings_lock;
    uint32_t pin_code;
    /* Color theme */
    meshtastic_Theme theme;
    /* Audible message, banner and ring tone */
    bool alert_enabled;
    bool banner_enabled;
    uint8_t ring_tone_id;
    /* Localization */
    meshtastic_Language language;
    /* Node list filter */
    bool has_node_filter;
    meshtastic_NodeFilter node_filter;
    /* Node list highlightening */
    bool has_node_highlight;
    meshtastic_NodeHighlight node_highlight;
    /* 8 integers for screen calibration data */
    meshtastic_DeviceUIConfig_calibration_data_t calibration_data;
    /* Map related data */
    bool has_map_data;
    meshtastic_Map map_data;
    /* Compass mode */
    meshtastic_CompassMode compass_mode;
    /* RGB color for BaseUI
 0xRRGGBB format, e.g. 0xFF0000 for red */
    uint32_t screen_rgb_color;
    /* Clockface analog style
 true for analog clockface, false for digital clockface */
    bool is_clockface_analog;
    /* How the GPS coordinates are formatted on the OLED screen. */
    meshtastic_DeviceUIConfig_GpsCoordinateFormat gps_format;
} meshtastic_DeviceUIConfig;


#ifdef __cplusplus
extern "C" {
#endif

/* Helper constants for enums */
#define _meshtastic_CompassMode_MIN meshtastic_CompassMode_DYNAMIC
#define _meshtastic_CompassMode_MAX meshtastic_CompassMode_FREEZE_HEADING
#define _meshtastic_CompassMode_ARRAYSIZE ((meshtastic_CompassMode)(meshtastic_CompassMode_FREEZE_HEADING+1))

#define _meshtastic_Theme_MIN meshtastic_Theme_DARK
#define _meshtastic_Theme_MAX meshtastic_Theme_RED
#define _meshtastic_Theme_ARRAYSIZE ((meshtastic_Theme)(meshtastic_Theme_RED+1))

#define _meshtastic_Language_MIN meshtastic_Language_ENGLISH
#define _meshtastic_Language_MAX meshtastic_Language_TRADITIONAL_CHINESE
#define _meshtastic_Language_ARRAYSIZE ((meshtastic_Language)(meshtastic_Language_TRADITIONAL_CHINESE+1))

#define _meshtastic_DeviceUIConfig_GpsCoordinateFormat_MIN meshtastic_DeviceUIConfig_GpsCoordinateFormat_DEC
#define _meshtastic_DeviceUIConfig_GpsCoordinateFormat_MAX meshtastic_DeviceUIConfig_GpsCoordinateFormat_MLS
#define _meshtastic_DeviceUIConfig_GpsCoordinateFormat_ARRAYSIZE ((meshtastic_DeviceUIConfig_GpsCoordinateFormat)(meshtastic_DeviceUIConfig_GpsCoordinateFormat_MLS+1))

#define meshtastic_DeviceUIConfig_theme_ENUMTYPE meshtastic_Theme
#define meshtastic_DeviceUIConfig_language_ENUMTYPE meshtastic_Language
#define meshtastic_DeviceUIConfig_compass_mode_ENUMTYPE meshtastic_CompassMode
#define meshtastic_DeviceUIConfig_gps_format_ENUMTYPE meshtastic_DeviceUIConfig_GpsCoordinateFormat






/* Initializer values for message structs */
#define meshtastic_DeviceUIConfig_init_default   {0, 0, 0, 0, 0, 0, _meshtastic_Theme_MIN, 0, 0, 0, _meshtastic_Language_MIN, false, meshtastic_NodeFilter_init_default, false, meshtastic_NodeHighlight_init_default, {0, {0}}, false, meshtastic_Map_init_default, _meshtastic_CompassMode_MIN, 0, 0, _meshtastic_DeviceUIConfig_GpsCoordinateFormat_MIN}
#define meshtastic_NodeFilter_init_default       {0, 0, 0, 0, 0, "", 0}
#define meshtastic_NodeHighlight_init_default    {0, 0, 0, 0, ""}
#define meshtastic_GeoPoint_init_default         {0, 0, 0}
#define meshtastic_Map_init_default              {false, meshtastic_GeoPoint_init_default, "", 0}
#define meshtastic_DeviceUIConfig_init_zero      {0, 0, 0, 0, 0, 0, _meshtastic_Theme_MIN, 0, 0, 0, _meshtastic_Language_MIN, false, meshtastic_NodeFilter_init_zero, false, meshtastic_NodeHighlight_init_zero, {0, {0}}, false, meshtastic_Map_init_zero, _meshtastic_CompassMode_MIN, 0, 0, _meshtastic_DeviceUIConfig_GpsCoordinateFormat_MIN}
#define meshtastic_NodeFilter_init_zero          {0, 0, 0, 0, 0, "", 0}
#define meshtastic_NodeHighlight_init_zero       {0, 0, 0, 0, ""}
#define meshtastic_GeoPoint_init_zero            {0, 0, 0}
#define meshtastic_Map_init_zero                 {false, meshtastic_GeoPoint_init_zero, "", 0}

/* Field tags (for use in manual encoding/decoding) */
#define meshtastic_NodeFilter_unknown_switch_tag 1
#define meshtastic_NodeFilter_offline_switch_tag 2
#define meshtastic_NodeFilter_public_key_switch_tag 3
#define meshtastic_NodeFilter_hops_away_tag      4
#define meshtastic_NodeFilter_position_switch_tag 5
#define meshtastic_NodeFilter_node_name_tag      6
#define meshtastic_NodeFilter_channel_tag        7
#define meshtastic_NodeHighlight_chat_switch_tag 1
#define meshtastic_NodeHighlight_position_switch_tag 2
#define meshtastic_NodeHighlight_telemetry_switch_tag 3
#define meshtastic_NodeHighlight_iaq_switch_tag  4
#define meshtastic_NodeHighlight_node_name_tag   5
#define meshtastic_GeoPoint_zoom_tag             1
#define meshtastic_GeoPoint_latitude_tag         2
#define meshtastic_GeoPoint_longitude_tag        3
#define meshtastic_Map_home_tag                  1
#define meshtastic_Map_style_tag                 2
#define meshtastic_Map_follow_gps_tag            3
#define meshtastic_DeviceUIConfig_version_tag    1
#define meshtastic_DeviceUIConfig_screen_brightness_tag 2
#define meshtastic_DeviceUIConfig_screen_timeout_tag 3
#define meshtastic_DeviceUIConfig_screen_lock_tag 4
#define meshtastic_DeviceUIConfig_settings_lock_tag 5
#define meshtastic_DeviceUIConfig_pin_code_tag   6
#define meshtastic_DeviceUIConfig_theme_tag      7
#define meshtastic_DeviceUIConfig_alert_enabled_tag 8
#define meshtastic_DeviceUIConfig_banner_enabled_tag 9
#define meshtastic_DeviceUIConfig_ring_tone_id_tag 10
#define meshtastic_DeviceUIConfig_language_tag   11
#define meshtastic_DeviceUIConfig_node_filter_tag 12
#define meshtastic_DeviceUIConfig_node_highlight_tag 13
#define meshtastic_DeviceUIConfig_calibration_data_tag 14
#define meshtastic_DeviceUIConfig_map_data_tag   15
#define meshtastic_DeviceUIConfig_compass_mode_tag 16
#define meshtastic_DeviceUIConfig_screen_rgb_color_tag 17
#define meshtastic_DeviceUIConfig_is_clockface_analog_tag 18
#define meshtastic_DeviceUIConfig_gps_format_tag 19

/* Struct field encoding specification for nanopb */
#define meshtastic_DeviceUIConfig_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, UINT32,   version,           1) \
X(a, STATIC,   SINGULAR, UINT32,   screen_brightness,   2) \
X(a, STATIC,   SINGULAR, UINT32,   screen_timeout,    3) \
X(a, STATIC,   SINGULAR, BOOL,     screen_lock,       4) \
X(a, STATIC,   SINGULAR, BOOL,     settings_lock,     5) \
X(a, STATIC,   SINGULAR, UINT32,   pin_code,          6) \
X(a, STATIC,   SINGULAR, UENUM,    theme,             7) \
X(a, STATIC,   SINGULAR, BOOL,     alert_enabled,     8) \
X(a, STATIC,   SINGULAR, BOOL,     banner_enabled,    9) \
X(a, STATIC,   SINGULAR, UINT32,   ring_tone_id,     10) \
X(a, STATIC,   SINGULAR, UENUM,    language,         11) \
X(a, STATIC,   OPTIONAL, MESSAGE,  node_filter,      12) \
X(a, STATIC,   OPTIONAL, MESSAGE,  node_highlight,   13) \
X(a, STATIC,   SINGULAR, BYTES,    calibration_data,  14) \
X(a, STATIC,   OPTIONAL, MESSAGE,  map_data,         15) \
X(a, STATIC,   SINGULAR, UENUM,    compass_mode,     16) \
X(a, STATIC,   SINGULAR, UINT32,   screen_rgb_color,  17) \
X(a, STATIC,   SINGULAR, BOOL,     is_clockface_analog,  18) \
X(a, STATIC,   SINGULAR, UENUM,    gps_format,       19)
#define meshtastic_DeviceUIConfig_CALLBACK NULL
#define meshtastic_DeviceUIConfig_DEFAULT NULL
#define meshtastic_DeviceUIConfig_node_filter_MSGTYPE meshtastic_NodeFilter
#define meshtastic_DeviceUIConfig_node_highlight_MSGTYPE meshtastic_NodeHighlight
#define meshtastic_DeviceUIConfig_map_data_MSGTYPE meshtastic_Map

#define meshtastic_NodeFilter_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, BOOL,     unknown_switch,    1) \
X(a, STATIC,   SINGULAR, BOOL,     offline_switch,    2) \
X(a, STATIC,   SINGULAR, BOOL,     public_key_switch,   3) \
X(a, STATIC,   SINGULAR, INT32,    hops_away,         4) \
X(a, STATIC,   SINGULAR, BOOL,     position_switch,   5) \
X(a, STATIC,   SINGULAR, STRING,   node_name,         6) \
X(a, STATIC,   SINGULAR, INT32,    channel,           7)
#define meshtastic_NodeFilter_CALLBACK NULL
#define meshtastic_NodeFilter_DEFAULT NULL

#define meshtastic_NodeHighlight_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, BOOL,     chat_switch,       1) \
X(a, STATIC,   SINGULAR, BOOL,     position_switch,   2) \
X(a, STATIC,   SINGULAR, BOOL,     telemetry_switch,   3) \
X(a, STATIC,   SINGULAR, BOOL,     iaq_switch,        4) \
X(a, STATIC,   SINGULAR, STRING,   node_name,         5)
#define meshtastic_NodeHighlight_CALLBACK NULL
#define meshtastic_NodeHighlight_DEFAULT NULL

#define meshtastic_GeoPoint_FIELDLIST(X, a) \
X(a, STATIC,   SINGULAR, INT32,    zoom,              1) \
X(a, STATIC,   SINGULAR, INT32,    latitude,          2) \
X(a, STATIC,   SINGULAR, INT32,    longitude,         3)
#define meshtastic_GeoPoint_CALLBACK NULL
#define meshtastic_GeoPoint_DEFAULT NULL

#define meshtastic_Map_FIELDLIST(X, a) \
X(a, STATIC,   OPTIONAL, MESSAGE,  home,              1) \
X(a, STATIC,   SINGULAR, STRING,   style,             2) \
X(a, STATIC,   SINGULAR, BOOL,     follow_gps,        3)
#define meshtastic_Map_CALLBACK NULL
#define meshtastic_Map_DEFAULT NULL
#define meshtastic_Map_home_MSGTYPE meshtastic_GeoPoint

extern const pb_msgdesc_t meshtastic_DeviceUIConfig_msg;
extern const pb_msgdesc_t meshtastic_NodeFilter_msg;
extern const pb_msgdesc_t meshtastic_NodeHighlight_msg;
extern const pb_msgdesc_t meshtastic_GeoPoint_msg;
extern const pb_msgdesc_t meshtastic_Map_msg;

/* Defines for backwards compatibility with code written before nanopb-0.4.0 */
#define meshtastic_DeviceUIConfig_fields &meshtastic_DeviceUIConfig_msg
#define meshtastic_NodeFilter_fields &meshtastic_NodeFilter_msg
#define meshtastic_NodeHighlight_fields &meshtastic_NodeHighlight_msg
#define meshtastic_GeoPoint_fields &meshtastic_GeoPoint_msg
#define meshtastic_Map_fields &meshtastic_Map_msg

/* Maximum encoded size of messages (where known) */
#define MESHTASTIC_MESHTASTIC_DEVICE_UI_PB_H_MAX_SIZE meshtastic_DeviceUIConfig_size
#define meshtastic_DeviceUIConfig_size           204
#define meshtastic_GeoPoint_size                 33
#define meshtastic_Map_size                      58
#define meshtastic_NodeFilter_size               47
#define meshtastic_NodeHighlight_size            25

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif
