
# Espressif 32: development platform for [PlatformIO](https://platformio.org)

ESP32 is a series of low-cost, low-power system on a chip microcontrollers with integrated Wi-Fi and Bluetooth. ESP32 integrates an antenna switch, RF balun, power amplifier, low-noise receive amplifier, filters, and power management modules.

* [Home](https://platformio.org/platforms/espressif32) (home page in PlatformIO Registry)
* [Documentation](https://docs.platformio.org/page/platforms/espressif32.html) (advanced usage, packages, boards, frameworks, etc.)

# Examples

* [arduino-ble5-advertising](https://github.com/platformio/platform-espressif32/tree/master/examples/arduino-ble5-advertising)
* [arduino-blink](https://github.com/platformio/platform-espressif32/tree/master/examples/arduino-blink)
* [arduino-briki-internal-libs](https://github.com/platformio/platform-espressif32/tree/master/examples/arduino-briki-internal-libs)
* [arduino-usb-keyboard](https://github.com/platformio/platform-espressif32/tree/master/examples/arduino-usb-keyboard)
* [arduino-wifiscan](https://github.com/platformio/platform-espressif32/tree/master/examples/arduino-wifiscan)
* [espidf-arduino-blink](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-arduino-blink)
* [espidf-arduino-wifiscan](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-arduino-wifiscan)
* [espidf-aws-iot](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-aws-iot)
* [espidf-ble-eddystone](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-ble-eddystone)
* [espidf-coap-server](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-coap-server)
* [espidf-exceptions](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-exceptions)
* [espidf-hello-world](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-hello-world)
* [espidf-http-request](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-http-request)
* [espidf-peripherals-uart](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-peripherals-uart)
* [espidf-peripherals-usb](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-peripherals-usb)
* [espidf-storage-sdcard](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-storage-sdcard)
* [espidf-storage-spiffs](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-storage-spiffs)
* [espidf-ulp-adc](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-ulp-adc)
* [espidf-ulp-pulse](https://github.com/platformio/platform-espressif32/tree/master/examples/espidf-ulp-pulse)
