/*******************************************************************************
 * Size: 12 px
 * Bpp: 4
 * Opts: --bpp 4 --size 12 --no-compress --font MontserratZ-Medium.ttf --range 32-127,160-255,256-383,880-1023,1024-1279,1280-1327,7936-131071 --format lvgl
 ******************************************************************************/

#ifdef __has_include
    #if __has_include("lvgl.h")
        #ifndef LV_LVGL_H_INCLUDE_SIMPLE
            #define LV_LVGL_H_INCLUDE_SIMPLE
        #endif
    #endif
#endif

#ifdef LV_LVGL_H_INCLUDE_SIMPLE
    #include "lvgl.h"
#else
    #include "lvgl.h"
#endif

#ifndef UI_FONT_MONTSERRAT_12
#define UI_FONT_MONTSERRAT_12 1
#endif

#if UI_FONT_MONTSERRAT_12

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t glyph_bitmap[] = {
    /* U+0020 " " */

    /* U+0021 "!" */
    0xf, 0x40, 0xf3, 0xf, 0x30, 0xf2, 0xe, 0x20,
    0xd1, 0x3, 0x0, 0x91, 0x1e, 0x30,

    /* U+0022 "\"" */
    0x3b, 0x1e, 0x3b, 0xe, 0x3b, 0xd, 0x15, 0x7,

    /* U+0023 "#" */
    0x0, 0x48, 0x3, 0xa0, 0x0, 0x7, 0x60, 0x58,
    0x0, 0x4f, 0xff, 0xff, 0xff, 0x10, 0xa, 0x20,
    0x84, 0x0, 0x0, 0xc1, 0xa, 0x30, 0x0, 0xd,
    0x0, 0xb1, 0x0, 0xaf, 0xff, 0xff, 0xfb, 0x0,
    0x1c, 0x0, 0xd0, 0x0, 0x3, 0xa0, 0x1c, 0x0,
    0x0,

    /* U+0024 "$" */
    0x0, 0x9, 0x20, 0x0, 0x0, 0x92, 0x0, 0x4,
    0xcf, 0xfb, 0x31, 0xf7, 0xa5, 0x74, 0x4e, 0x9,
    0x20, 0x1, 0xf9, 0xb2, 0x0, 0x3, 0xbf, 0xe8,
    0x0, 0x0, 0x97, 0xda, 0x0, 0x9, 0x24, 0xe5,
    0xc4, 0xa5, 0xbb, 0x8, 0xef, 0xea, 0x10, 0x0,
    0x92, 0x0, 0x0, 0x4, 0x10, 0x0,

    /* U+0025 "%" */
    0xb, 0xc8, 0x0, 0xc, 0x10, 0x56, 0xa, 0x20,
    0x76, 0x0, 0x83, 0x7, 0x42, 0xc0, 0x0, 0x57,
    0xa, 0x2b, 0x20, 0x0, 0x9, 0xc6, 0x68, 0x5c,
    0xa0, 0x0, 0x1, 0xc1, 0xc0, 0x67, 0x0, 0xa,
    0x43, 0x90, 0x29, 0x0, 0x49, 0x1, 0xb0, 0x47,
    0x0, 0xc1, 0x0, 0x7b, 0xb0,

    /* U+0026 "&" */
    0x0, 0x9e, 0xd4, 0x0, 0x0, 0x5c, 0x3, 0xd0,
    0x0, 0x5, 0xc0, 0x4b, 0x0, 0x0, 0xc, 0xad,
    0x20, 0x0, 0x3, 0xdd, 0x80, 0x10, 0x1, 0xe2,
    0x1d, 0x77, 0x80, 0x6b, 0x0, 0x1d, 0xe2, 0x4,
    0xf5, 0x13, 0xcf, 0x60, 0x6, 0xdf, 0xd6, 0x2b,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+0027 "'" */
    0x3c, 0x3b, 0x3b, 0x15,

    /* U+0028 "(" */
    0xa, 0x71, 0xf1, 0x5c, 0x9, 0x80, 0xb6, 0xc,
    0x50, 0xd4, 0xc, 0x50, 0xb6, 0x9, 0x80, 0x5c,
    0x1, 0xf1, 0xa, 0x70,

    /* U+0029 ")" */
    0x6b, 0x0, 0xf2, 0xb, 0x60, 0x8a, 0x5, 0xc0,
    0x4d, 0x3, 0xe0, 0x4d, 0x5, 0xc0, 0x7a, 0xb,
    0x60, 0xf2, 0x6b, 0x0,

    /* U+002A "*" */
    0x0, 0xb0, 0x8, 0x9c, 0xb5, 0xb, 0xf8, 0x8,
    0x7c, 0x95, 0x0, 0xa0, 0x0,

    /* U+002B "+" */
    0x0, 0xb, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x0,
    0xf, 0x0, 0x2, 0xee, 0xfe, 0xe2, 0x1, 0x1f,
    0x11, 0x0, 0x0, 0xf0, 0x0,

    /* U+002C "," */
    0x18, 0x4, 0xf1, 0xd, 0x3, 0x80,

    /* U+002D "-" */
    0x4f, 0xfd, 0x2, 0x22,

    /* U+002E "." */
    0x2a, 0x4, 0xd0,

    /* U+002F "/" */
    0x0, 0x0, 0x34, 0x0, 0x0, 0xb5, 0x0, 0x0,
    0xf0, 0x0, 0x5, 0xb0, 0x0, 0xa, 0x60, 0x0,
    0xe, 0x10, 0x0, 0x4c, 0x0, 0x0, 0x97, 0x0,
    0x0, 0xe2, 0x0, 0x3, 0xd0, 0x0, 0x8, 0x70,
    0x0, 0xd, 0x20, 0x0, 0x2d, 0x0, 0x0,

    /* U+0030 "0" */
    0x0, 0x9e, 0xe9, 0x0, 0xa, 0xd4, 0x4d, 0xa0,
    0x1f, 0x20, 0x2, 0xf1, 0x5d, 0x0, 0x0, 0xd5,
    0x6c, 0x0, 0x0, 0xc6, 0x5d, 0x0, 0x0, 0xd5,
    0x1f, 0x20, 0x2, 0xf1, 0xa, 0xd4, 0x4d, 0xa0,
    0x0, 0x9e, 0xe9, 0x0,

    /* U+0031 "1" */
    0xef, 0xf3, 0x22, 0xf3, 0x0, 0xf3, 0x0, 0xf3,
    0x0, 0xf3, 0x0, 0xf3, 0x0, 0xf3, 0x0, 0xf3,
    0x0, 0xf3,

    /* U+0032 "2" */
    0x1a, 0xef, 0xc3, 0x8, 0xb4, 0x3a, 0xe0, 0x0,
    0x0, 0x1f, 0x10, 0x0, 0x4, 0xe0, 0x0, 0x2,
    0xe5, 0x0, 0x1, 0xd7, 0x0, 0x1, 0xd8, 0x0,
    0x1, 0xda, 0x22, 0x21, 0x8f, 0xff, 0xff, 0x70,

    /* U+0033 "3" */
    0x9f, 0xff, 0xff, 0x1, 0x22, 0x2d, 0x80, 0x0,
    0x9, 0xb0, 0x0, 0x5, 0xf3, 0x0, 0x0, 0x7c,
    0xf8, 0x0, 0x0, 0x2, 0xf2, 0x0, 0x0, 0xe,
    0x4b, 0x94, 0x39, 0xf1, 0x3b, 0xef, 0xc3, 0x0,

    /* U+0034 "4" */
    0x0, 0x0, 0x9b, 0x0, 0x0, 0x4, 0xe1, 0x0,
    0x0, 0x1e, 0x50, 0x0, 0x0, 0xaa, 0x0, 0x0,
    0x5, 0xe1, 0xd, 0x40, 0x1e, 0x40, 0xd, 0x40,
    0x8f, 0xff, 0xff, 0xfd, 0x12, 0x22, 0x2e, 0x62,
    0x0, 0x0, 0xe, 0x40,

    /* U+0035 "5" */
    0xc, 0xff, 0xff, 0x0, 0xe5, 0x22, 0x20, 0xf,
    0x10, 0x0, 0x1, 0xff, 0xeb, 0x30, 0x2, 0x23,
    0x9f, 0x10, 0x0, 0x0, 0xd6, 0x0, 0x0, 0xd,
    0x69, 0xb4, 0x38, 0xf1, 0x2a, 0xef, 0xc4, 0x0,

    /* U+0036 "6" */
    0x0, 0x6d, 0xfd, 0x50, 0x8, 0xd5, 0x23, 0x20,
    0x1f, 0x20, 0x0, 0x0, 0x5d, 0x6d, 0xea, 0x10,
    0x6f, 0xc4, 0x3c, 0xb0, 0x5f, 0x30, 0x2, 0xf0,
    0x2f, 0x20, 0x3, 0xf0, 0xb, 0xb2, 0x2b, 0xa0,
    0x0, 0x9e, 0xfa, 0x10,

    /* U+0037 "7" */
    0xaf, 0xff, 0xff, 0xba, 0x92, 0x22, 0xd7, 0x76,
    0x0, 0x3f, 0x10, 0x0, 0xa, 0x90, 0x0, 0x1,
    0xf2, 0x0, 0x0, 0x7c, 0x0, 0x0, 0xe, 0x50,
    0x0, 0x5, 0xe0, 0x0, 0x0, 0xc8, 0x0, 0x0,

    /* U+0038 "8" */
    0x3, 0xcf, 0xe9, 0x10, 0xe, 0x81, 0x2c, 0xa0,
    0x2f, 0x10, 0x5, 0xd0, 0xe, 0x70, 0x1b, 0xa0,
    0x6, 0xff, 0xff, 0x20, 0x3f, 0x50, 0x18, 0xe0,
    0x6c, 0x0, 0x0, 0xf2, 0x3f, 0x61, 0x29, 0xe0,
    0x5, 0xdf, 0xfb, 0x20,

    /* U+0039 "9" */
    0x7, 0xef, 0xc3, 0x6, 0xe4, 0x16, 0xe2, 0x99,
    0x0, 0xb, 0x87, 0xd2, 0x3, 0xfc, 0xa, 0xff,
    0xd9, 0xc0, 0x0, 0x10, 0x8b, 0x0, 0x0, 0xe,
    0x70, 0x62, 0x4b, 0xd0, 0x1c, 0xfe, 0xa1, 0x0,

    /* U+003A ":" */
    0x4d, 0x2, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xa0, 0x4d, 0x0,

    /* U+003B ";" */
    0x4d, 0x2, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x80, 0x4f, 0x10, 0xd0, 0x48, 0x0,

    /* U+003C "<" */
    0x0, 0x0, 0x2, 0x10, 0x0, 0x4b, 0xe1, 0x7,
    0xdc, 0x50, 0x3, 0xf7, 0x0, 0x0, 0x4, 0xbe,
    0x71, 0x0, 0x0, 0x29, 0xe2, 0x0, 0x0, 0x0,
    0x0,

    /* U+003D "=" */
    0x3f, 0xff, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xee, 0xee, 0xe2, 0x1, 0x11,
    0x11, 0x0,

    /* U+003E ">" */
    0x12, 0x0, 0x0, 0x2, 0xeb, 0x40, 0x0, 0x0,
    0x5c, 0xd6, 0x0, 0x0, 0x8, 0xf2, 0x1, 0x7e,
    0xb4, 0x2, 0xe9, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+003F "?" */
    0x19, 0xef, 0xc3, 0x9, 0xa3, 0x2a, 0xe0, 0x0,
    0x0, 0x3f, 0x0, 0x0, 0xa, 0xa0, 0x0, 0x9,
    0xc0, 0x0, 0x2, 0xf1, 0x0, 0x0, 0x1, 0x0,
    0x0, 0x2, 0x80, 0x0, 0x0, 0x4d, 0x0, 0x0,

    /* U+0040 "@" */
    0x0, 0x5, 0xbd, 0xdd, 0x81, 0x0, 0x0, 0x9b,
    0x30, 0x0, 0x5d, 0x30, 0x7, 0xa0, 0x8e, 0xe7,
    0xd5, 0xd1, 0xd, 0x7, 0xc2, 0x19, 0xf3, 0x67,
    0x4a, 0xd, 0x40, 0x0, 0xf3, 0x1b, 0x67, 0xf,
    0x20, 0x0, 0xd3, 0xc, 0x67, 0xd, 0x40, 0x0,
    0xf3, 0x1c, 0x3a, 0x7, 0xd2, 0x19, 0xf5, 0x68,
    0xd, 0x0, 0x8e, 0xe7, 0x5f, 0xc1, 0x7, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9b, 0x20, 0x2,
    0x40, 0x0, 0x0, 0x5, 0xbe, 0xed, 0x60, 0x0,

    /* U+0041 "A" */
    0x0, 0x0, 0x6f, 0x30, 0x0, 0x0, 0x0, 0xdd,
    0x90, 0x0, 0x0, 0x4, 0xe3, 0xf1, 0x0, 0x0,
    0xb, 0x80, 0xc7, 0x0, 0x0, 0x1f, 0x20, 0x6e,
    0x0, 0x0, 0x8c, 0x0, 0x1f, 0x50, 0x0, 0xef,
    0xee, 0xef, 0xb0, 0x6, 0xe2, 0x11, 0x14, 0xf2,
    0xc, 0x70, 0x0, 0x0, 0xb9,

    /* U+0042 "B" */
    0xbf, 0xff, 0xfb, 0x20, 0xb7, 0x11, 0x2a, 0xd0,
    0xb7, 0x0, 0x3, 0xf0, 0xb7, 0x0, 0x9, 0xc0,
    0xbf, 0xff, 0xff, 0x40, 0xb8, 0x22, 0x26, 0xe2,
    0xb7, 0x0, 0x0, 0xc7, 0xb7, 0x11, 0x15, 0xf4,
    0xbf, 0xff, 0xfd, 0x60,

    /* U+0043 "C" */
    0x0, 0x3b, 0xff, 0xb3, 0x0, 0x4f, 0x94, 0x38,
    0xe0, 0xe, 0x70, 0x0, 0x0, 0x4, 0xf0, 0x0,
    0x0, 0x0, 0x6d, 0x0, 0x0, 0x0, 0x4, 0xf0,
    0x0, 0x0, 0x0, 0xe, 0x70, 0x0, 0x0, 0x0,
    0x4f, 0x94, 0x48, 0xe0, 0x0, 0x3b, 0xff, 0xb3,
    0x0,

    /* U+0044 "D" */
    0xbf, 0xff, 0xea, 0x30, 0xb, 0x82, 0x23, 0x9f,
    0x40, 0xb7, 0x0, 0x0, 0x7e, 0xb, 0x70, 0x0,
    0x0, 0xf3, 0xb7, 0x0, 0x0, 0xe, 0x5b, 0x70,
    0x0, 0x0, 0xf3, 0xb7, 0x0, 0x0, 0x7e, 0xb,
    0x82, 0x23, 0x9f, 0x40, 0xbf, 0xff, 0xea, 0x30,
    0x0,

    /* U+0045 "E" */
    0xbf, 0xff, 0xff, 0x3b, 0x82, 0x22, 0x20, 0xb7,
    0x0, 0x0, 0xb, 0x70, 0x0, 0x0, 0xbf, 0xff,
    0xfa, 0xb, 0x82, 0x22, 0x10, 0xb7, 0x0, 0x0,
    0xb, 0x82, 0x22, 0x20, 0xbf, 0xff, 0xff, 0x50,

    /* U+0046 "F" */
    0xbf, 0xff, 0xff, 0x3b, 0x82, 0x22, 0x20, 0xb7,
    0x0, 0x0, 0xb, 0x70, 0x0, 0x0, 0xbf, 0xff,
    0xfa, 0xb, 0x82, 0x22, 0x10, 0xb7, 0x0, 0x0,
    0xb, 0x70, 0x0, 0x0, 0xb7, 0x0, 0x0, 0x0,

    /* U+0047 "G" */
    0x0, 0x3b, 0xff, 0xc4, 0x0, 0x4f, 0x94, 0x37,
    0xe1, 0xe, 0x70, 0x0, 0x0, 0x4, 0xf0, 0x0,
    0x0, 0x0, 0x6d, 0x0, 0x0, 0x8, 0x24, 0xf0,
    0x0, 0x0, 0xe3, 0xe, 0x70, 0x0, 0xe, 0x30,
    0x4f, 0x94, 0x37, 0xf3, 0x0, 0x3b, 0xff, 0xc5,
    0x0,

    /* U+0048 "H" */
    0xb7, 0x0, 0x0, 0xb7, 0xb7, 0x0, 0x0, 0xb7,
    0xb7, 0x0, 0x0, 0xb7, 0xb7, 0x0, 0x0, 0xb7,
    0xbf, 0xff, 0xff, 0xf7, 0xb8, 0x22, 0x22, 0xc7,
    0xb7, 0x0, 0x0, 0xb7, 0xb7, 0x0, 0x0, 0xb7,
    0xb7, 0x0, 0x0, 0xb7,

    /* U+0049 "I" */
    0xb7, 0xb7, 0xb7, 0xb7, 0xb7, 0xb7, 0xb7, 0xb7,
    0xb7,

    /* U+004A "J" */
    0x4, 0xff, 0xff, 0x0, 0x22, 0x5f, 0x0, 0x0,
    0x3f, 0x0, 0x0, 0x3f, 0x0, 0x0, 0x3f, 0x0,
    0x0, 0x3f, 0x0, 0x0, 0x4e, 0xd, 0x63, 0xbb,
    0x5, 0xdf, 0xb2,

    /* U+004B "K" */
    0xb7, 0x0, 0x6, 0xd1, 0xb7, 0x0, 0x5e, 0x20,
    0xb7, 0x4, 0xe3, 0x0, 0xb7, 0x3e, 0x40, 0x0,
    0xb9, 0xef, 0x20, 0x0, 0xbf, 0x89, 0xd0, 0x0,
    0xba, 0x0, 0xca, 0x0, 0xb7, 0x0, 0x1e, 0x70,
    0xb7, 0x0, 0x3, 0xf3,

    /* U+004C "L" */
    0xb7, 0x0, 0x0, 0xb, 0x70, 0x0, 0x0, 0xb7,
    0x0, 0x0, 0xb, 0x70, 0x0, 0x0, 0xb7, 0x0,
    0x0, 0xb, 0x70, 0x0, 0x0, 0xb7, 0x0, 0x0,
    0xb, 0x82, 0x22, 0x20, 0xbf, 0xff, 0xff, 0x0,

    /* U+004D "M" */
    0xb8, 0x0, 0x0, 0x1, 0xf2, 0xbf, 0x10, 0x0,
    0x9, 0xf3, 0xbe, 0xa0, 0x0, 0x2e, 0xf3, 0xb7,
    0xe3, 0x0, 0xb7, 0xf3, 0xb6, 0x7b, 0x4, 0xd0,
    0xf3, 0xb6, 0xd, 0x4c, 0x50, 0xf3, 0xb6, 0x5,
    0xfc, 0x0, 0xf3, 0xb6, 0x0, 0xb3, 0x0, 0xf3,
    0xb6, 0x0, 0x0, 0x0, 0xf3,

    /* U+004E "N" */
    0xb9, 0x0, 0x0, 0xb7, 0xbf, 0x50, 0x0, 0xb7,
    0xbc, 0xf2, 0x0, 0xb7, 0xb7, 0xad, 0x0, 0xb7,
    0xb7, 0xd, 0x90, 0xb7, 0xb7, 0x2, 0xf5, 0xb7,
    0xb7, 0x0, 0x6f, 0xd7, 0xb7, 0x0, 0xa, 0xf7,
    0xb7, 0x0, 0x0, 0xd7,

    /* U+004F "O" */
    0x0, 0x3b, 0xff, 0xb4, 0x0, 0x4, 0xf9, 0x44,
    0x8f, 0x60, 0xe, 0x70, 0x0, 0x6, 0xf1, 0x4f,
    0x0, 0x0, 0x0, 0xe6, 0x6d, 0x0, 0x0, 0x0,
    0xc7, 0x4f, 0x0, 0x0, 0x0, 0xe6, 0xe, 0x70,
    0x0, 0x6, 0xf1, 0x4, 0xf9, 0x44, 0x8f, 0x60,
    0x0, 0x3b, 0xff, 0xc4, 0x0,

    /* U+0050 "P" */
    0xbf, 0xff, 0xe8, 0x0, 0xb8, 0x22, 0x4d, 0x90,
    0xb7, 0x0, 0x4, 0xf0, 0xb7, 0x0, 0x3, 0xf0,
    0xb7, 0x0, 0x2c, 0xb0, 0xbf, 0xff, 0xfb, 0x10,
    0xb8, 0x22, 0x0, 0x0, 0xb7, 0x0, 0x0, 0x0,
    0xb7, 0x0, 0x0, 0x0,

    /* U+0051 "Q" */
    0x0, 0x3b, 0xff, 0xb4, 0x0, 0x4, 0xf9, 0x44,
    0x8f, 0x60, 0xe, 0x70, 0x0, 0x6, 0xf1, 0x4f,
    0x0, 0x0, 0x0, 0xe6, 0x6d, 0x0, 0x0, 0x0,
    0xc7, 0x4f, 0x0, 0x0, 0x0, 0xe6, 0xe, 0x60,
    0x0, 0x5, 0xf1, 0x4, 0xf8, 0x33, 0x8f, 0x60,
    0x0, 0x3c, 0xff, 0xc4, 0x0, 0x0, 0x0, 0xc,
    0xb0, 0x28, 0x0, 0x0, 0x1, 0xbf, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+0052 "R" */
    0xbf, 0xff, 0xe8, 0x0, 0xb8, 0x22, 0x4d, 0x90,
    0xb7, 0x0, 0x4, 0xf0, 0xb7, 0x0, 0x3, 0xf0,
    0xb7, 0x0, 0x2b, 0xb0, 0xbf, 0xff, 0xfb, 0x10,
    0xb8, 0x22, 0xb9, 0x0, 0xb7, 0x0, 0x1f, 0x30,
    0xb7, 0x0, 0x7, 0xd0,

    /* U+0053 "S" */
    0x4, 0xcf, 0xeb, 0x31, 0xf8, 0x23, 0x74, 0x4e,
    0x0, 0x0, 0x1, 0xf9, 0x20, 0x0, 0x3, 0xbf,
    0xd8, 0x0, 0x0, 0x4, 0xda, 0x0, 0x0, 0x4,
    0xe5, 0xc4, 0x23, 0xbb, 0x8, 0xdf, 0xea, 0x10,

    /* U+0054 "T" */
    0xff, 0xff, 0xff, 0xf2, 0x23, 0xf3, 0x22, 0x0,
    0x1f, 0x10, 0x0, 0x1, 0xf1, 0x0, 0x0, 0x1f,
    0x10, 0x0, 0x1, 0xf1, 0x0, 0x0, 0x1f, 0x10,
    0x0, 0x1, 0xf1, 0x0, 0x0, 0x1f, 0x10, 0x0,

    /* U+0055 "U" */
    0xd6, 0x0, 0x0, 0xe4, 0xd6, 0x0, 0x0, 0xe4,
    0xd6, 0x0, 0x0, 0xe4, 0xd6, 0x0, 0x0, 0xe4,
    0xd6, 0x0, 0x0, 0xe4, 0xc7, 0x0, 0x0, 0xf3,
    0x9a, 0x0, 0x2, 0xf1, 0x2f, 0x83, 0x5d, 0xa0,
    0x4, 0xcf, 0xd8, 0x0,

    /* U+0056 "V" */
    0xc, 0x70, 0x0, 0x0, 0xd5, 0x6, 0xe0, 0x0,
    0x4, 0xe0, 0x0, 0xf4, 0x0, 0xa, 0x80, 0x0,
    0x9b, 0x0, 0x1f, 0x20, 0x0, 0x2f, 0x20, 0x7b,
    0x0, 0x0, 0xc, 0x80, 0xe4, 0x0, 0x0, 0x5,
    0xe5, 0xe0, 0x0, 0x0, 0x0, 0xee, 0x70, 0x0,
    0x0, 0x0, 0x8f, 0x10, 0x0,

    /* U+0057 "W" */
    0x7c, 0x0, 0x0, 0xe8, 0x0, 0x2, 0xf0, 0x2f,
    0x10, 0x3, 0xfd, 0x0, 0x7, 0xa0, 0xd, 0x60,
    0x8, 0x9f, 0x20, 0xc, 0x50, 0x8, 0xb0, 0xd,
    0x3b, 0x70, 0x1f, 0x0, 0x3, 0xf0, 0x3e, 0x6,
    0xc0, 0x6b, 0x0, 0x0, 0xe5, 0x89, 0x1, 0xf1,
    0xb6, 0x0, 0x0, 0x9a, 0xd4, 0x0, 0xb7, 0xf1,
    0x0, 0x0, 0x4f, 0xe0, 0x0, 0x6f, 0xc0, 0x0,
    0x0, 0xf, 0xa0, 0x0, 0x1f, 0x70, 0x0,

    /* U+0058 "X" */
    0x5f, 0x10, 0x0, 0xe5, 0xa, 0xb0, 0x9, 0xa0,
    0x1, 0xe6, 0x4e, 0x10, 0x0, 0x4f, 0xe4, 0x0,
    0x0, 0xd, 0xe0, 0x0, 0x0, 0x7d, 0xd8, 0x0,
    0x2, 0xf3, 0x2f, 0x30, 0xc, 0x80, 0x7, 0xd0,
    0x8d, 0x0, 0x0, 0xc9,

    /* U+0059 "Y" */
    0xc, 0x80, 0x0, 0xa, 0x80, 0x3f, 0x10, 0x3,
    0xe0, 0x0, 0xaa, 0x0, 0xc6, 0x0, 0x1, 0xf3,
    0x6c, 0x0, 0x0, 0x7, 0xce, 0x30, 0x0, 0x0,
    0xe, 0xa0, 0x0, 0x0, 0x0, 0xb7, 0x0, 0x0,
    0x0, 0xb, 0x70, 0x0, 0x0, 0x0, 0xb7, 0x0,
    0x0,

    /* U+005A "Z" */
    0x6f, 0xff, 0xff, 0xf5, 0x2, 0x22, 0x29, 0xd0,
    0x0, 0x0, 0x3f, 0x30, 0x0, 0x1, 0xe6, 0x0,
    0x0, 0xb, 0xa0, 0x0, 0x0, 0x8d, 0x0, 0x0,
    0x4, 0xf2, 0x0, 0x0, 0x1e, 0x82, 0x22, 0x21,
    0x7f, 0xff, 0xff, 0xf8,

    /* U+005B "[" */
    0xbf, 0xcb, 0x60, 0xb6, 0xb, 0x60, 0xb6, 0xb,
    0x60, 0xb6, 0xb, 0x60, 0xb6, 0xb, 0x60, 0xb6,
    0xb, 0x60, 0xbf, 0xc0,

    /* U+005C "\\" */
    0x35, 0x0, 0x0, 0x2e, 0x0, 0x0, 0xd, 0x30,
    0x0, 0x8, 0x80, 0x0, 0x3, 0xd0, 0x0, 0x0,
    0xd2, 0x0, 0x0, 0x87, 0x0, 0x0, 0x3c, 0x0,
    0x0, 0xe, 0x20, 0x0, 0x9, 0x70, 0x0, 0x4,
    0xc0, 0x0, 0x0, 0xe1, 0x0, 0x0, 0xa6,

    /* U+005D "]" */
    0xcf, 0xb0, 0x7b, 0x6, 0xb0, 0x6b, 0x6, 0xb0,
    0x6b, 0x6, 0xb0, 0x6b, 0x6, 0xb0, 0x6b, 0x6,
    0xb0, 0x7b, 0xcf, 0xb0,

    /* U+005E "^" */
    0x0, 0x7, 0x0, 0x0, 0x5, 0xe5, 0x0, 0x0,
    0xb4, 0xb0, 0x0, 0x2c, 0xc, 0x20, 0x8, 0x60,
    0x68, 0x0, 0xd0, 0x0, 0xd0,

    /* U+005F "_" */
    0xdd, 0xdd, 0xdd,

    /* U+0060 "`" */
    0x27, 0x10, 0x5, 0xc1,

    /* U+0061 "a" */
    0x1, 0xbf, 0xe6, 0xf3, 0xd, 0xb2, 0x3d, 0xf3,
    0x4e, 0x0, 0x2, 0xf3, 0x6c, 0x0, 0x0, 0xf3,
    0x4e, 0x0, 0x2, 0xf3, 0xd, 0xb2, 0x3d, 0xf3,
    0x1, 0xbf, 0xe6, 0xe3,

    /* U+0062 "b" */
    0xe4, 0x0, 0x0, 0xe, 0x40, 0x0, 0x0, 0xe4,
    0x0, 0x0, 0xe, 0x7c, 0xfc, 0x40, 0xef, 0x52,
    0x7f, 0x2e, 0x60, 0x0, 0xa8, 0xe4, 0x0, 0x8,
    0xae, 0x70, 0x0, 0xb8, 0xef, 0x52, 0x8f, 0x2e,
    0x6c, 0xfc, 0x40,

    /* U+0063 "c" */
    0x2, 0xbf, 0xe8, 0x0, 0xda, 0x24, 0xd3, 0x5d,
    0x0, 0x0, 0x7, 0xb0, 0x0, 0x0, 0x5d, 0x0,
    0x0, 0x0, 0xda, 0x24, 0xd3, 0x2, 0xbf, 0xe8,
    0x0,

    /* U+0064 "d" */
    0x0, 0x0, 0x1, 0xf1, 0x0, 0x0, 0x1, 0xf1,
    0x0, 0x0, 0x1, 0xf1, 0x2, 0xbf, 0xd5, 0xf1,
    0xe, 0xa2, 0x3e, 0xf1, 0x5d, 0x0, 0x3, 0xf1,
    0x7b, 0x0, 0x1, 0xf1, 0x5d, 0x0, 0x4, 0xf1,
    0xe, 0xa2, 0x4d, 0xf1, 0x2, 0xbf, 0xd5, 0xf1,

    /* U+0065 "e" */
    0x2, 0xbf, 0xd6, 0x0, 0xe8, 0x14, 0xf4, 0x5d,
    0x0, 0x6, 0xa7, 0xfe, 0xee, 0xec, 0x5d, 0x0,
    0x0, 0x0, 0xda, 0x23, 0xa2, 0x2, 0xbf, 0xe9,
    0x0,

    /* U+0066 "f" */
    0x1, 0xcf, 0x70, 0x9a, 0x11, 0xb, 0x60, 0xd,
    0xff, 0xf4, 0xb, 0x60, 0x0, 0xb6, 0x0, 0xb,
    0x60, 0x0, 0xb6, 0x0, 0xb, 0x60, 0x0, 0xb6,
    0x0,

    /* U+0067 "g" */
    0x2, 0xbf, 0xd5, 0xe2, 0xe, 0xa2, 0x3d, 0xf2,
    0x5d, 0x0, 0x2, 0xf2, 0x7b, 0x0, 0x0, 0xf2,
    0x5d, 0x0, 0x2, 0xf2, 0xe, 0xa2, 0x3d, 0xf2,
    0x2, 0xbf, 0xe6, 0xf2, 0x0, 0x0, 0x2, 0xf0,
    0xc, 0x62, 0x3b, 0xb0, 0x6, 0xcf, 0xea, 0x10,

    /* U+0068 "h" */
    0xe4, 0x0, 0x0, 0xe, 0x40, 0x0, 0x0, 0xe4,
    0x0, 0x0, 0xe, 0x7d, 0xfc, 0x20, 0xee, 0x42,
    0xad, 0xe, 0x60, 0x1, 0xf1, 0xe4, 0x0, 0xf,
    0x2e, 0x40, 0x0, 0xf2, 0xe4, 0x0, 0xf, 0x2e,
    0x40, 0x0, 0xf2,

    /* U+0069 "i" */
    0xd, 0x40, 0x82, 0x0, 0x0, 0xe3, 0xe, 0x30,
    0xe3, 0xe, 0x30, 0xe3, 0xe, 0x30, 0xe3,

    /* U+006A "j" */
    0x0, 0xd, 0x50, 0x0, 0x72, 0x0, 0x0, 0x0,
    0x0, 0xd4, 0x0, 0xd, 0x40, 0x0, 0xd4, 0x0,
    0xd, 0x40, 0x0, 0xd4, 0x0, 0xd, 0x40, 0x0,
    0xd4, 0x0, 0xd, 0x40, 0x22, 0xf2, 0xd, 0xf8,
    0x0,

    /* U+006B "k" */
    0xe4, 0x0, 0x0, 0xe, 0x40, 0x0, 0x0, 0xe4,
    0x0, 0x0, 0xe, 0x40, 0xb, 0xa0, 0xe4, 0xb,
    0xb0, 0xe, 0x4b, 0xc0, 0x0, 0xee, 0xfd, 0x0,
    0xe, 0xc1, 0xd9, 0x0, 0xe4, 0x2, 0xf4, 0xe,
    0x40, 0x6, 0xe1,

    /* U+006C "l" */
    0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4,
    0xe4, 0xe4,

    /* U+006D "m" */
    0xe7, 0xdf, 0xb1, 0x8e, 0xf8, 0xe, 0xe4, 0x2c,
    0xeb, 0x24, 0xf5, 0xe6, 0x0, 0x4f, 0x20, 0x9,
    0x9e, 0x40, 0x3, 0xf0, 0x0, 0x8a, 0xe4, 0x0,
    0x3f, 0x0, 0x8, 0xae, 0x40, 0x3, 0xf0, 0x0,
    0x8a, 0xe4, 0x0, 0x3f, 0x0, 0x8, 0xa0,

    /* U+006E "n" */
    0xe6, 0xdf, 0xc2, 0xe, 0xe4, 0x2a, 0xd0, 0xe6,
    0x0, 0x1f, 0x1e, 0x40, 0x0, 0xf2, 0xe4, 0x0,
    0xf, 0x2e, 0x40, 0x0, 0xf2, 0xe4, 0x0, 0xf,
    0x20,

    /* U+006F "o" */
    0x2, 0xbf, 0xe8, 0x0, 0xd, 0xa2, 0x3e, 0x80,
    0x5d, 0x0, 0x3, 0xf0, 0x7b, 0x0, 0x1, 0xf1,
    0x5d, 0x0, 0x4, 0xf0, 0xd, 0xa2, 0x4e, 0x80,
    0x2, 0xbf, 0xe8, 0x0,

    /* U+0070 "p" */
    0xe6, 0xdf, 0xc4, 0xe, 0xf4, 0x17, 0xf2, 0xe6,
    0x0, 0xa, 0x8e, 0x40, 0x0, 0x8a, 0xe7, 0x0,
    0xb, 0x8e, 0xf5, 0x28, 0xf2, 0xe6, 0xcf, 0xc4,
    0xe, 0x40, 0x0, 0x0, 0xe4, 0x0, 0x0, 0xe,
    0x40, 0x0, 0x0,

    /* U+0071 "q" */
    0x2, 0xbf, 0xd5, 0xf1, 0xe, 0xa2, 0x3d, 0xf1,
    0x5d, 0x0, 0x3, 0xf1, 0x7b, 0x0, 0x1, 0xf1,
    0x5d, 0x0, 0x4, 0xf1, 0xe, 0xa2, 0x3e, 0xf1,
    0x2, 0xbf, 0xd5, 0xf1, 0x0, 0x0, 0x1, 0xf1,
    0x0, 0x0, 0x1, 0xf1, 0x0, 0x0, 0x1, 0xf1,

    /* U+0072 "r" */
    0xe6, 0xd8, 0xee, 0x51, 0xe6, 0x0, 0xe4, 0x0,
    0xe4, 0x0, 0xe4, 0x0, 0xe4, 0x0,

    /* U+0073 "s" */
    0x9, 0xef, 0xc2, 0x6d, 0x22, 0x61, 0x6d, 0x20,
    0x0, 0xa, 0xfe, 0x91, 0x0, 0x2, 0xc8, 0x56,
    0x22, 0xb8, 0x4c, 0xee, 0xa1,

    /* U+0074 "t" */
    0x5, 0x30, 0x0, 0xb6, 0x0, 0xdf, 0xff, 0x40,
    0xb6, 0x0, 0xb, 0x60, 0x0, 0xb6, 0x0, 0xb,
    0x60, 0x0, 0xaa, 0x11, 0x2, 0xdf, 0x60,

    /* U+0075 "u" */
    0xf3, 0x0, 0x2f, 0xf, 0x30, 0x2, 0xf0, 0xf3,
    0x0, 0x2f, 0xf, 0x30, 0x2, 0xf0, 0xe4, 0x0,
    0x5f, 0xa, 0xc3, 0x3d, 0xf0, 0x1b, 0xfd, 0x6f,
    0x0,

    /* U+0076 "v" */
    0xd, 0x50, 0x0, 0x98, 0x6, 0xc0, 0x0, 0xf2,
    0x1, 0xf2, 0x6, 0xb0, 0x0, 0xa8, 0xc, 0x50,
    0x0, 0x3e, 0x3e, 0x0, 0x0, 0xd, 0xd8, 0x0,
    0x0, 0x6, 0xf2, 0x0,

    /* U+0077 "w" */
    0xc5, 0x0, 0x3f, 0x10, 0x7, 0x86, 0xa0, 0x9,
    0xf6, 0x0, 0xd3, 0x1f, 0x0, 0xe7, 0xb0, 0x2d,
    0x0, 0xb5, 0x4c, 0xe, 0x18, 0x80, 0x6, 0xa9,
    0x60, 0xa6, 0xd3, 0x0, 0x1e, 0xe1, 0x4, 0xed,
    0x0, 0x0, 0xbb, 0x0, 0xe, 0x80, 0x0,

    /* U+0078 "x" */
    0x5d, 0x0, 0x4e, 0x10, 0xa9, 0x1e, 0x40, 0x1,
    0xed, 0x90, 0x0, 0x8, 0xf1, 0x0, 0x2, 0xeb,
    0xb0, 0x0, 0xc7, 0xd, 0x60, 0x7c, 0x0, 0x3f,
    0x20,

    /* U+0079 "y" */
    0xd, 0x50, 0x0, 0x98, 0x7, 0xb0, 0x0, 0xe2,
    0x1, 0xf2, 0x5, 0xc0, 0x0, 0xb8, 0xb, 0x50,
    0x0, 0x4e, 0x1e, 0x0, 0x0, 0xe, 0xb9, 0x0,
    0x0, 0x8, 0xf3, 0x0, 0x0, 0x5, 0xd0, 0x0,
    0x5, 0x2c, 0x60, 0x0, 0x1c, 0xf9, 0x0, 0x0,

    /* U+007A "z" */
    0x7f, 0xff, 0xfb, 0x0, 0x2, 0xf3, 0x0, 0xc,
    0x70, 0x0, 0x8b, 0x0, 0x4, 0xe1, 0x0, 0x1e,
    0x50, 0x0, 0x8f, 0xff, 0xfd,

    /* U+007B "{" */
    0x0, 0xbf, 0x4, 0xe1, 0x5, 0xc0, 0x5, 0xc0,
    0x5, 0xc0, 0x6, 0xc0, 0x4f, 0x70, 0x8, 0xb0,
    0x5, 0xc0, 0x5, 0xc0, 0x5, 0xc0, 0x4, 0xf1,
    0x0, 0xbf,

    /* U+007C "|" */
    0xb5, 0xb5, 0xb5, 0xb5, 0xb5, 0xb5, 0xb5, 0xb5,
    0xb5, 0xb5, 0xb5, 0xb5, 0xb5,

    /* U+007D "}" */
    0xcd, 0x10, 0xc, 0x70, 0x9, 0x90, 0x9, 0x90,
    0x9, 0x90, 0x8, 0xa0, 0x4, 0xf7, 0x8, 0xb0,
    0x9, 0x90, 0x9, 0x90, 0x9, 0x90, 0xc, 0x80,
    0xcd, 0x20,

    /* U+007E "~" */
    0xb, 0xe8, 0xa, 0x33, 0xa1, 0x9e, 0xb0,

    /* U+00A0 " " */

    /* U+00A1 "¡" */
    0xe, 0x30, 0x81, 0x0, 0x0, 0xd1, 0xe, 0x10,
    0xf2, 0xf, 0x30, 0xf3, 0xf, 0x40,

    /* U+00A2 "¢" */
    0x0, 0x9, 0x20, 0x0, 0x0, 0x92, 0x0, 0x2,
    0xbf, 0xf9, 0x0, 0xea, 0xa5, 0xc3, 0x5d, 0x9,
    0x20, 0x7, 0xb0, 0x92, 0x0, 0x5d, 0x9, 0x20,
    0x0, 0xda, 0xa5, 0xc3, 0x2, 0xbf, 0xf9, 0x0,
    0x0, 0x92, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+00A3 "£" */
    0x0, 0x1a, 0xef, 0xc4, 0x0, 0xdb, 0x43, 0x63,
    0x3, 0xf0, 0x0, 0x0, 0x5, 0xd0, 0x0, 0x0,
    0x8e, 0xfe, 0xee, 0x0, 0x5, 0xd0, 0x0, 0x0,
    0x5, 0xd0, 0x0, 0x0, 0x16, 0xe2, 0x22, 0x20,
    0xaf, 0xff, 0xff, 0xf6,

    /* U+00A4 "¤" */
    0x23, 0x0, 0x0, 0x4, 0x4, 0xe7, 0xce, 0x9a,
    0xb0, 0x9, 0xe4, 0x2a, 0xf0, 0x0, 0xd2, 0x0,
    0xb, 0x40, 0xe, 0x0, 0x0, 0x76, 0x0, 0xd1,
    0x0, 0xa, 0x40, 0x9, 0xc1, 0x7, 0xe0, 0x2,
    0xea, 0xff, 0xcd, 0x70, 0x45, 0x0, 0x10, 0x18,
    0x0,

    /* U+00A5 "¥" */
    0xb, 0x80, 0x0, 0x1, 0xe3, 0x1, 0xf3, 0x0,
    0xa, 0x80, 0x0, 0x6d, 0x0, 0x5d, 0x0, 0x0,
    0xc, 0x71, 0xe4, 0x0, 0x0, 0x2, 0xfb, 0x90,
    0x0, 0x0, 0xac, 0xef, 0xcc, 0x40, 0x0, 0x0,
    0x5d, 0x0, 0x0, 0x0, 0xac, 0xdf, 0xcc, 0x40,
    0x0, 0x0, 0x5d, 0x0, 0x0,

    /* U+00A6 "¦" */
    0xb5, 0xb5, 0xb5, 0xb5, 0x63, 0x0, 0x0, 0x0,
    0x63, 0xb5, 0xb5, 0xb5, 0xb5,

    /* U+00A7 "§" */
    0x6, 0xdf, 0xd5, 0x2e, 0x20, 0x33, 0x3d, 0x0,
    0x0, 0xe, 0xe8, 0x20, 0x5c, 0x48, 0xe3, 0x88,
    0x0, 0x78, 0x4f, 0x95, 0xd6, 0x3, 0x9e, 0xe0,
    0x0, 0x0, 0xd3, 0x44, 0x1, 0xd3, 0x5d, 0xff,
    0x80, 0x0, 0x0, 0x0,

    /* U+00A8 "¨" */
    0x0, 0x0, 0x0, 0xe0, 0xc3, 0x2, 0x2, 0x0,

    /* U+00A9 "©" */
    0x0, 0x18, 0x99, 0x60, 0x0, 0x2, 0xa1, 0x0,
    0x49, 0x0, 0x9, 0x6, 0xdd, 0x44, 0x60, 0x36,
    0x4d, 0x12, 0x60, 0x90, 0x62, 0x86, 0x0, 0x0,
    0x80, 0x62, 0x86, 0x0, 0x0, 0x80, 0x36, 0x4d,
    0x12, 0x60, 0x90, 0x9, 0x6, 0xdd, 0x44, 0x60,
    0x2, 0xa1, 0x0, 0x59, 0x0, 0x0, 0x18, 0x99,
    0x50, 0x0,

    /* U+00AA "ª" */
    0x29, 0xa9, 0x2, 0x98, 0xe0, 0x85, 0xd, 0x12,
    0xa8, 0xa0,

    /* U+00AB "«" */
    0x0, 0x0, 0x0, 0x2, 0xd1, 0xc4, 0xc, 0x47,
    0x90, 0x4c, 0xf, 0x10, 0xc, 0x47, 0x90, 0x2,
    0xd1, 0xc4,

    /* U+00AC "¬" */
    0x2e, 0xee, 0xee, 0x20, 0x11, 0x11, 0xd3, 0x0,
    0x0, 0xd, 0x30, 0x0, 0x0, 0x81,

    /* U+00AD "­" */
    0x5f, 0xfd, 0x2, 0x22,

    /* U+00AE "®" */
    0x0, 0x18, 0x99, 0x60, 0x0, 0x2, 0xa1, 0x0,
    0x49, 0x0, 0x9, 0xc, 0xbb, 0x44, 0x60, 0x36,
    0xc, 0x0, 0xc0, 0x90, 0x62, 0xc, 0x0, 0xc0,
    0x80, 0x62, 0xd, 0xbe, 0x40, 0x80, 0x36, 0xd,
    0x6, 0x60, 0x90, 0x9, 0x8, 0x0, 0x84, 0x60,
    0x2, 0xa1, 0x0, 0x59, 0x0, 0x0, 0x18, 0x99,
    0x50, 0x0,

    /* U+00AF "¯" */
    0x4c, 0xcc, 0x60,

    /* U+00B0 "°" */
    0x7, 0xb7, 0x3, 0x80, 0x84, 0x64, 0x4, 0x73,
    0x80, 0x84, 0x7, 0xb7, 0x0,

    /* U+00B1 "±" */
    0x0, 0xf, 0x0, 0x0, 0x0, 0xf0, 0x0, 0x2e,
    0xef, 0xee, 0x20, 0x11, 0xf1, 0x10, 0x0, 0xf,
    0x0, 0x0, 0x0, 0x90, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xff, 0xff, 0xf3,

    /* U+00B2 "²" */
    0x4b, 0xbb, 0x0, 0x0, 0x93, 0x0, 0x4b, 0x0,
    0x5a, 0x0, 0x5f, 0xbb, 0x60,

    /* U+00B3 "³" */
    0x5b, 0xbf, 0x30, 0x8, 0x60, 0x1, 0xab, 0x21,
    0x0, 0x57, 0x5b, 0xbb, 0x10,

    /* U+00B4 "´" */
    0x9, 0x41, 0xe0,

    /* U+00B5 "µ" */
    0xe3, 0x0, 0x1f, 0x1e, 0x30, 0x1, 0xf1, 0xe3,
    0x0, 0x1f, 0x1e, 0x30, 0x1, 0xf1, 0xe5, 0x0,
    0x4f, 0x1e, 0xc2, 0x2c, 0xf1, 0xea, 0xee, 0x7f,
    0x1e, 0x30, 0x0, 0x0, 0xe3, 0x0, 0x0, 0xe,
    0x30, 0x0, 0x0,

    /* U+00B6 "¶" */
    0x1a, 0xff, 0xff, 0x89, 0xff, 0xb0, 0x78, 0xbf,
    0xfb, 0x7, 0x86, 0xff, 0xb0, 0x78, 0x5, 0xbb,
    0x7, 0x80, 0x4, 0xb0, 0x78, 0x0, 0x4b, 0x7,
    0x80, 0x4, 0xb0, 0x78, 0x0, 0x4b, 0x7, 0x80,
    0x4, 0xb0, 0x78, 0x0, 0x4a, 0x6, 0x80,

    /* U+00B7 "·" */
    0xa, 0x21, 0xe3,

    /* U+00B8 "¸" */
    0x0, 0x0, 0xb0, 0x5, 0xb7, 0xb5,

    /* U+00B9 "¹" */
    0xa, 0xe3, 0x0, 0xa, 0x30, 0x0, 0xa3, 0x0,
    0xa, 0x30, 0xb, 0xec, 0x40,

    /* U+00BA "º" */
    0x1a, 0xaa, 0x18, 0x50, 0x48, 0x76, 0x6, 0x80,
    0x8a, 0x80,

    /* U+00BB "»" */
    0x0, 0x0, 0x0, 0x4c, 0x1d, 0x20, 0x9, 0x74,
    0xc0, 0x1, 0xf0, 0xc4, 0x9, 0x74, 0xc0, 0x4c,
    0x1d, 0x20,

    /* U+00BC "¼" */
    0xb, 0xd2, 0x0, 0x0, 0x93, 0x0, 0x0, 0xa,
    0x30, 0x0, 0x3a, 0x0, 0x0, 0x0, 0xa3, 0x0,
    0xc, 0x10, 0x0, 0x0, 0xa, 0x30, 0x7, 0x60,
    0x0, 0x0, 0x0, 0xa3, 0x2, 0xc0, 0x6, 0x70,
    0x0, 0xbd, 0xc4, 0xb3, 0x2, 0xb0, 0x0, 0x0,
    0x0, 0x58, 0x0, 0xc1, 0xa1, 0x0, 0x0, 0xc,
    0x0, 0x6d, 0xce, 0xc0, 0x0, 0x9, 0x50, 0x0,
    0x0, 0xb1, 0x0, 0x0, 0x50, 0x0, 0x0, 0x4,
    0x0,

    /* U+00BD "½" */
    0xb, 0xd2, 0x0, 0x0, 0x93, 0x0, 0x0, 0xa3,
    0x0, 0x4, 0x90, 0x0, 0x0, 0xa3, 0x0, 0xc,
    0x10, 0x0, 0x0, 0xa3, 0x0, 0x96, 0xac, 0xb1,
    0xc, 0xdc, 0x54, 0xa1, 0x30, 0x67, 0x0, 0x0,
    0xc, 0x10, 0x0, 0x95, 0x0, 0x0, 0x95, 0x0,
    0x7, 0xa0, 0x0, 0x3, 0xa0, 0x0, 0x7a, 0x0,
    0x0, 0xa, 0x10, 0x2, 0xdc, 0xc9,

    /* U+00BE "¾" */
    0x6c, 0xcd, 0x30, 0x0, 0x93, 0x0, 0x0, 0x4,
    0xa0, 0x0, 0x3a, 0x0, 0x0, 0x0, 0xe6, 0x0,
    0xc, 0x10, 0x0, 0x0, 0x3, 0xa6, 0x7, 0x60,
    0x0, 0x0, 0x31, 0x6, 0x72, 0xc0, 0x6, 0x70,
    0x4, 0xbb, 0x90, 0xb3, 0x3, 0xb0, 0x0, 0x0,
    0x0, 0x58, 0x0, 0xc1, 0xa1, 0x0, 0x0, 0xc,
    0x0, 0x6d, 0xce, 0xc0, 0x0, 0x9, 0x50, 0x0,
    0x0, 0xb1, 0x0, 0x0, 0x50, 0x0, 0x0, 0x4,
    0x0,

    /* U+00BF "¿" */
    0x0, 0x1e, 0x20, 0x0, 0x0, 0x91, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xf0, 0x0, 0x1, 0xc8,
    0x0, 0x0, 0xb9, 0x0, 0x0, 0x1f, 0x10, 0x0,
    0x1, 0xf6, 0x1, 0xa6, 0x6, 0xff, 0xfb, 0x10,
    0x0, 0x21, 0x0,

    /* U+00C0 "À" */
    0x0, 0x3, 0x70, 0x0, 0x0, 0x0, 0x0, 0x7a,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0x20, 0x0, 0x0, 0x0, 0xdd, 0x90,
    0x0, 0x0, 0x4, 0xe3, 0xf1, 0x0, 0x0, 0xb,
    0x80, 0xc7, 0x0, 0x0, 0x2f, 0x20, 0x6d, 0x0,
    0x0, 0x8c, 0x0, 0x1f, 0x40, 0x0, 0xef, 0xee,
    0xef, 0xb0, 0x6, 0xe2, 0x11, 0x14, 0xf2, 0xd,
    0x70, 0x0, 0x0, 0xb9,

    /* U+00C1 "Á" */
    0x0, 0x0, 0xb, 0x20, 0x0, 0x0, 0x0, 0x4c,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0x20, 0x0, 0x0, 0x0, 0xdd, 0x90,
    0x0, 0x0, 0x4, 0xe3, 0xf1, 0x0, 0x0, 0xb,
    0x80, 0xc7, 0x0, 0x0, 0x2f, 0x20, 0x6d, 0x0,
    0x0, 0x8c, 0x0, 0x1f, 0x40, 0x0, 0xef, 0xee,
    0xef, 0xb0, 0x6, 0xe2, 0x11, 0x14, 0xf2, 0xd,
    0x70, 0x0, 0x0, 0xb9,

    /* U+00C2 "Â" */
    0x0, 0x0, 0x37, 0x10, 0x0, 0x0, 0x4, 0xb5,
    0xc2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0x20, 0x0, 0x0, 0x0, 0xdd, 0x90,
    0x0, 0x0, 0x4, 0xe3, 0xf1, 0x0, 0x0, 0xb,
    0x80, 0xc7, 0x0, 0x0, 0x2f, 0x20, 0x6d, 0x0,
    0x0, 0x8c, 0x0, 0x1f, 0x40, 0x0, 0xef, 0xee,
    0xef, 0xb0, 0x6, 0xe2, 0x11, 0x14, 0xf2, 0xd,
    0x70, 0x0, 0x0, 0xb9,

    /* U+00C3 "Ã" */
    0x0, 0x3, 0xc5, 0x54, 0x0, 0x0, 0x8, 0x18,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0x20, 0x0, 0x0, 0x0, 0xdd, 0x90,
    0x0, 0x0, 0x4, 0xe3, 0xf1, 0x0, 0x0, 0xb,
    0x80, 0xc7, 0x0, 0x0, 0x2f, 0x20, 0x6d, 0x0,
    0x0, 0x8c, 0x0, 0x1f, 0x40, 0x0, 0xef, 0xee,
    0xef, 0xb0, 0x6, 0xe2, 0x11, 0x14, 0xf2, 0xd,
    0x70, 0x0, 0x0, 0xb9,

    /* U+00C4 "Ä" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xc0,
    0xf0, 0x0, 0x0, 0x0, 0x20, 0x20, 0x0, 0x0,
    0x0, 0x6f, 0x20, 0x0, 0x0, 0x0, 0xdd, 0x90,
    0x0, 0x0, 0x4, 0xe3, 0xf1, 0x0, 0x0, 0xb,
    0x80, 0xc7, 0x0, 0x0, 0x2f, 0x20, 0x6d, 0x0,
    0x0, 0x8c, 0x0, 0x1f, 0x40, 0x0, 0xef, 0xee,
    0xef, 0xb0, 0x6, 0xe2, 0x11, 0x14, 0xf2, 0xd,
    0x70, 0x0, 0x0, 0xb9,

    /* U+00C5 "Å" */
    0x0, 0x0, 0x59, 0x30, 0x0, 0x0, 0x0, 0x90,
    0x90, 0x0, 0x0, 0x0, 0x58, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x20,
    0x0, 0x0, 0x0, 0xdd, 0x90, 0x0, 0x0, 0x4,
    0xe3, 0xf1, 0x0, 0x0, 0xb, 0x80, 0xc7, 0x0,
    0x0, 0x2f, 0x20, 0x6d, 0x0, 0x0, 0x8c, 0x0,
    0x1f, 0x40, 0x0, 0xef, 0xee, 0xef, 0xb0, 0x6,
    0xe2, 0x11, 0x14, 0xf2, 0xd, 0x70, 0x0, 0x0,
    0xb9,

    /* U+00C6 "Æ" */
    0x0, 0x0, 0x4, 0xff, 0xff, 0xff, 0xb0, 0x0,
    0x0, 0xd9, 0xf2, 0x22, 0x21, 0x0, 0x0, 0x6d,
    0x3f, 0x0, 0x0, 0x0, 0x0, 0xe, 0x53, 0xf0,
    0x0, 0x0, 0x0, 0x8, 0xd0, 0x3f, 0xff, 0xff,
    0x30, 0x1, 0xf5, 0x3, 0xf2, 0x22, 0x20, 0x0,
    0xaf, 0xee, 0xff, 0x0, 0x0, 0x0, 0x3f, 0x41,
    0x14, 0xf2, 0x22, 0x22, 0xb, 0x80, 0x0, 0x3f,
    0xff, 0xff, 0xe0,

    /* U+00C7 "Ç" */
    0x0, 0x3b, 0xff, 0xb3, 0x0, 0x4f, 0x94, 0x38,
    0xe0, 0xe, 0x70, 0x0, 0x0, 0x5, 0xf0, 0x0,
    0x0, 0x0, 0x6c, 0x0, 0x0, 0x0, 0x5, 0xf0,
    0x0, 0x0, 0x0, 0xe, 0x70, 0x0, 0x0, 0x0,
    0x4f, 0x94, 0x48, 0xe0, 0x0, 0x4b, 0xff, 0xb3,
    0x0, 0x0, 0xb, 0x30, 0x0, 0x0, 0x0, 0x1d,
    0x0, 0x0, 0x0, 0x5b, 0xa0, 0x0,

    /* U+00C8 "È" */
    0x5, 0x60, 0x0, 0x0, 0x9, 0x90, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xf2, 0xc8, 0x22,
    0x22, 0xc, 0x70, 0x0, 0x0, 0xc7, 0x0, 0x0,
    0xc, 0xff, 0xff, 0xa0, 0xc8, 0x22, 0x21, 0xc,
    0x70, 0x0, 0x0, 0xc8, 0x22, 0x22, 0xc, 0xff,
    0xff, 0xf5,

    /* U+00C9 "É" */
    0x0, 0x2a, 0x0, 0x0, 0x6, 0x90, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xf2, 0xc8, 0x22,
    0x22, 0xc, 0x70, 0x0, 0x0, 0xc7, 0x0, 0x0,
    0xc, 0xff, 0xff, 0xa0, 0xc8, 0x22, 0x21, 0xc,
    0x70, 0x0, 0x0, 0xc8, 0x22, 0x22, 0xc, 0xff,
    0xff, 0xf5,

    /* U+00CA "Ê" */
    0x0, 0x47, 0x0, 0x0, 0x6a, 0x5b, 0x10, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xf2, 0xc8, 0x22,
    0x22, 0xc, 0x70, 0x0, 0x0, 0xc7, 0x0, 0x0,
    0xc, 0xff, 0xff, 0xa0, 0xc8, 0x22, 0x21, 0xc,
    0x70, 0x0, 0x0, 0xc8, 0x22, 0x22, 0xc, 0xff,
    0xff, 0xf5,

    /* U+00CB "Ë" */
    0x0, 0x0, 0x0, 0x0, 0x69, 0x2d, 0x0, 0x0,
    0x10, 0x20, 0xc, 0xff, 0xff, 0xf2, 0xc8, 0x22,
    0x22, 0xc, 0x70, 0x0, 0x0, 0xc7, 0x0, 0x0,
    0xc, 0xff, 0xff, 0xa0, 0xc8, 0x22, 0x21, 0xc,
    0x70, 0x0, 0x0, 0xc8, 0x22, 0x22, 0xc, 0xff,
    0xff, 0xf5,

    /* U+00CC "Ì" */
    0x7, 0x30, 0x2, 0xc4, 0x0, 0x0, 0x0, 0xc7,
    0x0, 0xc7, 0x0, 0xc7, 0x0, 0xc7, 0x0, 0xc7,
    0x0, 0xc7, 0x0, 0xc7, 0x0, 0xc7, 0x0, 0xc7,

    /* U+00CD "Í" */
    0x67, 0xc3, 0x0, 0xc7, 0xc7, 0xc7, 0xc7, 0xc7,
    0xc7, 0xc7, 0xc7, 0xc7,

    /* U+00CE "Î" */
    0x0, 0x75, 0x0, 0xb6, 0xa7, 0x0, 0x0, 0x0,
    0xc, 0x70, 0x0, 0xc7, 0x0, 0xc, 0x70, 0x0,
    0xc7, 0x0, 0xc, 0x70, 0x0, 0xc7, 0x0, 0xc,
    0x70, 0x0, 0xc7, 0x0, 0xc, 0x70,

    /* U+00CF "Ï" */
    0x0, 0x0, 0xc3, 0x87, 0x20, 0x11, 0xc, 0x70,
    0xc, 0x70, 0xc, 0x70, 0xc, 0x70, 0xc, 0x70,
    0xc, 0x70, 0xc, 0x70, 0xc, 0x70, 0xc, 0x70,

    /* U+00D0 "Ð" */
    0xa, 0xff, 0xfe, 0xb3, 0x0, 0xa, 0x92, 0x23,
    0x8f, 0x50, 0xa, 0x80, 0x0, 0x6, 0xe0, 0xa,
    0x80, 0x0, 0x0, 0xe4, 0xdf, 0xfe, 0xd0, 0x0,
    0xc6, 0x1c, 0xa1, 0x10, 0x0, 0xe4, 0xa, 0x80,
    0x0, 0x6, 0xe0, 0xa, 0x92, 0x23, 0x8f, 0x50,
    0xa, 0xff, 0xfe, 0xb3, 0x0,

    /* U+00D1 "Ñ" */
    0x0, 0x9a, 0x9, 0x0, 0x1, 0x83, 0xc6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc9, 0x0, 0x0, 0xb7,
    0xcf, 0x50, 0x0, 0xb7, 0xcc, 0xf2, 0x0, 0xb7,
    0xc7, 0xad, 0x0, 0xb7, 0xc7, 0xd, 0x90, 0xb7,
    0xc7, 0x2, 0xf5, 0xb7, 0xc7, 0x0, 0x6f, 0xd7,
    0xc7, 0x0, 0xa, 0xf7, 0xc7, 0x0, 0x0, 0xd7,

    /* U+00D2 "Ò" */
    0x0, 0x6, 0x40, 0x0, 0x0, 0x0, 0x1, 0xb6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b, 0xff, 0xb4, 0x0, 0x4, 0xf9, 0x44, 0x9f,
    0x60, 0xe, 0x70, 0x0, 0x6, 0xf1, 0x5f, 0x0,
    0x0, 0x0, 0xe5, 0x6c, 0x0, 0x0, 0x0, 0xc7,
    0x5f, 0x0, 0x0, 0x0, 0xe5, 0xe, 0x70, 0x0,
    0x6, 0xf1, 0x4, 0xf9, 0x44, 0x8f, 0x60, 0x0,
    0x3b, 0xff, 0xc4, 0x0,

    /* U+00D3 "Ó" */
    0x0, 0x0, 0x49, 0x0, 0x0, 0x0, 0x0, 0x96,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b, 0xff, 0xb4, 0x0, 0x4, 0xf9, 0x44, 0x9f,
    0x60, 0xe, 0x70, 0x0, 0x6, 0xf1, 0x5f, 0x0,
    0x0, 0x0, 0xe5, 0x6c, 0x0, 0x0, 0x0, 0xc7,
    0x5f, 0x0, 0x0, 0x0, 0xe5, 0xe, 0x70, 0x0,
    0x6, 0xf1, 0x4, 0xf9, 0x44, 0x8f, 0x60, 0x0,
    0x3b, 0xff, 0xc4, 0x0,

    /* U+00D4 "Ô" */
    0x0, 0x0, 0x66, 0x0, 0x0, 0x0, 0x9, 0x87,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b, 0xff, 0xb4, 0x0, 0x4, 0xf9, 0x44, 0x9f,
    0x60, 0xe, 0x70, 0x0, 0x6, 0xf1, 0x5f, 0x0,
    0x0, 0x0, 0xe5, 0x6c, 0x0, 0x0, 0x0, 0xc7,
    0x5f, 0x0, 0x0, 0x0, 0xe5, 0xe, 0x70, 0x0,
    0x6, 0xf1, 0x4, 0xf9, 0x44, 0x8f, 0x60, 0x0,
    0x3b, 0xff, 0xc4, 0x0,

    /* U+00D5 "Õ" */
    0x0, 0x7, 0xb1, 0xa0, 0x0, 0x0, 0xa, 0x1b,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b, 0xff, 0xb4, 0x0, 0x4, 0xf9, 0x44, 0x9f,
    0x60, 0xe, 0x70, 0x0, 0x6, 0xf1, 0x5f, 0x0,
    0x0, 0x0, 0xe5, 0x6c, 0x0, 0x0, 0x0, 0xc7,
    0x5f, 0x0, 0x0, 0x0, 0xe5, 0xe, 0x70, 0x0,
    0x6, 0xf1, 0x4, 0xf9, 0x44, 0x8f, 0x60, 0x0,
    0x3b, 0xff, 0xc4, 0x0,

    /* U+00D6 "Ö" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0x65,
    0xa0, 0x0, 0x0, 0x1, 0x0, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 0xff, 0xb4,
    0x0, 0x4, 0xf9, 0x44, 0x9f, 0x60, 0xe, 0x70,
    0x0, 0x6, 0xf1, 0x5f, 0x0, 0x0, 0x0, 0xe5,
    0x6c, 0x0, 0x0, 0x0, 0xc7, 0x5f, 0x0, 0x0,
    0x0, 0xe5, 0xe, 0x70, 0x0, 0x6, 0xf1, 0x4,
    0xf9, 0x44, 0x8f, 0x60, 0x0, 0x3b, 0xff, 0xc4,
    0x0,

    /* U+00D7 "×" */
    0x0, 0x0, 0x7, 0x60, 0x67, 0x1e, 0x9e, 0x10,
    0x6f, 0x60, 0x3e, 0x6e, 0x36, 0x40, 0x45,

    /* U+00D8 "Ø" */
    0x0, 0x0, 0x0, 0x2, 0xc0, 0x0, 0x3b, 0xff,
    0xcf, 0x20, 0x4, 0xf9, 0x44, 0xff, 0x60, 0xe,
    0x70, 0x2, 0xc6, 0xf1, 0x5f, 0x0, 0xb, 0x20,
    0xe5, 0x6c, 0x0, 0x68, 0x0, 0xc7, 0x5f, 0x2,
    0xc0, 0x0, 0xe5, 0xe, 0x7b, 0x30, 0x6, 0xf1,
    0x4, 0xff, 0x44, 0x8f, 0x60, 0x1, 0xfc, 0xff,
    0xc4, 0x0, 0xb, 0x30, 0x0, 0x0, 0x0,

    /* U+00D9 "Ù" */
    0x1, 0x72, 0x0, 0x0, 0x0, 0x3c, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xd6, 0x0, 0x0, 0xe4,
    0xd6, 0x0, 0x0, 0xe4, 0xd6, 0x0, 0x0, 0xe4,
    0xd6, 0x0, 0x0, 0xe4, 0xd6, 0x0, 0x0, 0xe4,
    0xc6, 0x0, 0x0, 0xf3, 0x9a, 0x0, 0x3, 0xf1,
    0x2f, 0x83, 0x5d, 0xa0, 0x4, 0xcf, 0xd8, 0x0,

    /* U+00DA "Ú" */
    0x0, 0x7, 0x60, 0x0, 0x0, 0xe, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xd6, 0x0, 0x0, 0xe4,
    0xd6, 0x0, 0x0, 0xe4, 0xd6, 0x0, 0x0, 0xe4,
    0xd6, 0x0, 0x0, 0xe4, 0xd6, 0x0, 0x0, 0xe4,
    0xc6, 0x0, 0x0, 0xf3, 0x9a, 0x0, 0x3, 0xf1,
    0x2f, 0x83, 0x5d, 0xa0, 0x4, 0xcf, 0xd8, 0x0,

    /* U+00DB "Û" */
    0x0, 0x7, 0x40, 0x0, 0x1, 0xb5, 0xb5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xd6, 0x0, 0x0, 0xe4,
    0xd6, 0x0, 0x0, 0xe4, 0xd6, 0x0, 0x0, 0xe4,
    0xd6, 0x0, 0x0, 0xe4, 0xd6, 0x0, 0x0, 0xe4,
    0xc6, 0x0, 0x0, 0xf3, 0x9a, 0x0, 0x3, 0xf1,
    0x2f, 0x83, 0x5d, 0xa0, 0x4, 0xcf, 0xd8, 0x0,

    /* U+00DC "Ü" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xd2, 0xa5, 0x0,
    0x0, 0x20, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xd6, 0x0, 0x0, 0xe4, 0xd6, 0x0, 0x0, 0xe4,
    0xd6, 0x0, 0x0, 0xe4, 0xd6, 0x0, 0x0, 0xe4,
    0xd6, 0x0, 0x0, 0xe4, 0xc6, 0x0, 0x0, 0xf3,
    0x9a, 0x0, 0x3, 0xf1, 0x2f, 0x83, 0x5d, 0xa0,
    0x4, 0xcf, 0xd8, 0x0,

    /* U+00DD "Ý" */
    0x0, 0x0, 0x57, 0x0, 0x0, 0x0, 0xc, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc8, 0x0,
    0x0, 0xa8, 0x3, 0xf1, 0x0, 0x3e, 0x0, 0xa,
    0xa0, 0xc, 0x60, 0x0, 0x1f, 0x36, 0xc0, 0x0,
    0x0, 0x7c, 0xe3, 0x0, 0x0, 0x0, 0xea, 0x0,
    0x0, 0x0, 0xb, 0x70, 0x0, 0x0, 0x0, 0xb7,
    0x0, 0x0, 0x0, 0xb, 0x70, 0x0,

    /* U+00DE "Þ" */
    0xb7, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xd8, 0x0,
    0xb8, 0x22, 0x5d, 0x90, 0xb7, 0x0, 0x4, 0xf0,
    0xb7, 0x0, 0x3, 0xf0, 0xb7, 0x0, 0x2b, 0xb0,
    0xbf, 0xff, 0xfb, 0x10, 0xb8, 0x22, 0x0, 0x0,
    0xb7, 0x0, 0x0, 0x0,

    /* U+00DF "ß" */
    0x8, 0xef, 0xb1, 0x7, 0xd3, 0x2b, 0xa0, 0xc6,
    0x0, 0x4d, 0xe, 0x40, 0xa, 0x80, 0xe4, 0x2f,
    0xf4, 0xe, 0x40, 0x26, 0xf3, 0xe4, 0x0, 0xa,
    0x8e, 0x40, 0x0, 0xa8, 0xe4, 0x11, 0x5f, 0x4e,
    0x48, 0xfe, 0x60,

    /* U+00E0 "à" */
    0x3, 0xe3, 0x0, 0x0, 0x0, 0x3c, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xbf, 0xe5, 0xf2,
    0xd, 0xb2, 0x3d, 0xf2, 0x4e, 0x0, 0x2, 0xf2,
    0x6c, 0x0, 0x0, 0xf2, 0x4e, 0x0, 0x2, 0xf2,
    0xd, 0xb2, 0x3d, 0xf2, 0x1, 0xbf, 0xe5, 0xe2,

    /* U+00E1 "á" */
    0x0, 0xf, 0x30, 0x0, 0x0, 0x28, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xbf, 0xe5, 0xf2,
    0xd, 0xb2, 0x3d, 0xf2, 0x4e, 0x0, 0x2, 0xf2,
    0x6c, 0x0, 0x0, 0xf2, 0x4e, 0x0, 0x2, 0xf2,
    0xd, 0xb2, 0x3d, 0xf2, 0x1, 0xbf, 0xe5, 0xe2,

    /* U+00E2 "â" */
    0x0, 0x7f, 0x70, 0x0, 0x4, 0xb1, 0xc3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xbf, 0xe5, 0xf2,
    0xd, 0xb2, 0x3d, 0xf2, 0x4e, 0x0, 0x2, 0xf2,
    0x6c, 0x0, 0x0, 0xf2, 0x4e, 0x0, 0x2, 0xf2,
    0xd, 0xb2, 0x3d, 0xf2, 0x1, 0xbf, 0xe5, 0xe2,

    /* U+00E3 "ã" */
    0x2, 0xd7, 0x46, 0x0, 0x6, 0x36, 0xb1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xbf, 0xe5, 0xf2,
    0xd, 0xb2, 0x3d, 0xf2, 0x4e, 0x0, 0x2, 0xf2,
    0x6c, 0x0, 0x0, 0xf2, 0x4e, 0x0, 0x2, 0xf2,
    0xd, 0xb2, 0x3d, 0xf2, 0x1, 0xbf, 0xe5, 0xe2,

    /* U+00E4 "ä" */
    0x2, 0xc0, 0xd1, 0x0, 0x0, 0x30, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xbf, 0xe5, 0xf2,
    0xd, 0xb2, 0x3d, 0xf2, 0x4e, 0x0, 0x2, 0xf2,
    0x6c, 0x0, 0x0, 0xf2, 0x4e, 0x0, 0x2, 0xf2,
    0xd, 0xb2, 0x3d, 0xf2, 0x1, 0xbf, 0xe5, 0xe2,

    /* U+00E5 "å" */
    0x0, 0x49, 0x40, 0x0, 0x0, 0x90, 0x90, 0x0,
    0x0, 0x59, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xbf, 0xe5, 0xf2, 0xd, 0xb2, 0x3d, 0xf2,
    0x4e, 0x0, 0x2, 0xf2, 0x6c, 0x0, 0x0, 0xf2,
    0x4e, 0x0, 0x2, 0xf2, 0xd, 0xb2, 0x3d, 0xf2,
    0x1, 0xbf, 0xe5, 0xe2,

    /* U+00E6 "æ" */
    0x8, 0xdf, 0xc3, 0x6e, 0xfa, 0x10, 0x9, 0x42,
    0x9f, 0xd4, 0x2a, 0xc0, 0x0, 0x0, 0x1f, 0x50,
    0x0, 0xe2, 0x8, 0xee, 0xef, 0xee, 0xee, 0xf5,
    0x4d, 0x10, 0xf, 0x50, 0x0, 0x0, 0x4e, 0x32,
    0x9e, 0xe4, 0x26, 0x80, 0x8, 0xee, 0xa1, 0x7d,
    0xfd, 0x30,

    /* U+00E7 "ç" */
    0x2, 0xbf, 0xe8, 0x0, 0xea, 0x24, 0xd3, 0x5d,
    0x0, 0x0, 0x7, 0xa0, 0x0, 0x0, 0x5d, 0x0,
    0x0, 0x0, 0xea, 0x24, 0xd3, 0x2, 0xbf, 0xe8,
    0x0, 0x0, 0xc1, 0x0, 0x0, 0x4, 0xb0, 0x0,
    0x7, 0xc6, 0x0,

    /* U+00E8 "è" */
    0x2, 0xd5, 0x0, 0x0, 0x1, 0xc3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2b, 0xfd, 0x50, 0xe, 0x81,
    0x4f, 0x46, 0xc0, 0x0, 0x7a, 0x7f, 0xee, 0xee,
    0xc5, 0xd0, 0x0, 0x0, 0xe, 0xa2, 0x3a, 0x20,
    0x2b, 0xfe, 0x90,

    /* U+00E9 "é" */
    0x0, 0xc, 0x60, 0x0, 0x0, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2b, 0xfd, 0x50, 0xe, 0x81,
    0x4f, 0x46, 0xc0, 0x0, 0x7a, 0x7f, 0xee, 0xee,
    0xc5, 0xd0, 0x0, 0x0, 0xe, 0xa2, 0x3a, 0x20,
    0x2b, 0xfe, 0x90,

    /* U+00EA "ê" */
    0x0, 0x4f, 0xa0, 0x0, 0x2c, 0x19, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x2b, 0xfd, 0x50, 0xe, 0x81,
    0x4f, 0x46, 0xc0, 0x0, 0x7a, 0x7f, 0xee, 0xee,
    0xc5, 0xd0, 0x0, 0x0, 0xe, 0xa2, 0x3a, 0x20,
    0x2b, 0xfe, 0x90,

    /* U+00EB "ë" */
    0x0, 0xd1, 0xa4, 0x0, 0x3, 0x3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2b, 0xfd, 0x50, 0xe, 0x81,
    0x4f, 0x46, 0xc0, 0x0, 0x7a, 0x7f, 0xee, 0xee,
    0xc5, 0xd0, 0x0, 0x0, 0xe, 0xa2, 0x3a, 0x20,
    0x2b, 0xfe, 0x90,

    /* U+00EC "ì" */
    0x2d, 0x50, 0x1, 0xc2, 0x0, 0x0, 0x0, 0xe3,
    0x0, 0xe3, 0x0, 0xe3, 0x0, 0xe3, 0x0, 0xe3,
    0x0, 0xe3, 0x0, 0xe3,

    /* U+00ED "í" */
    0xc, 0x60, 0xa0, 0x0, 0x0, 0xe3, 0xe, 0x30,
    0xe3, 0xe, 0x30, 0xe3, 0xe, 0x30, 0xe3,

    /* U+00EE "î" */
    0x3, 0xf8, 0x0, 0xb2, 0xb2, 0x0, 0x0, 0x0,
    0xe, 0x30, 0x0, 0xe3, 0x0, 0xe, 0x30, 0x0,
    0xe3, 0x0, 0xe, 0x30, 0x0, 0xe3, 0x0, 0xe,
    0x30,

    /* U+00EF "ï" */
    0xa4, 0xd0, 0x20, 0x30, 0x0, 0x0, 0xe, 0x30,
    0xe, 0x30, 0xe, 0x30, 0xe, 0x30, 0xe, 0x30,
    0xe, 0x30, 0xe, 0x30,

    /* U+00F0 "ð" */
    0xb, 0xff, 0xb7, 0x60, 0x3, 0x28, 0xff, 0x50,
    0x3, 0xea, 0x29, 0xb0, 0x1, 0x20, 0x2, 0xf0,
    0x3, 0xbe, 0xc3, 0xf1, 0x1f, 0x72, 0x5d, 0xf2,
    0x6c, 0x0, 0x7, 0xf0, 0x7c, 0x0, 0x7, 0xc0,
    0x2f, 0x71, 0x4e, 0x50, 0x4, 0xdf, 0xd5, 0x0,

    /* U+00F1 "ñ" */
    0x7, 0xc2, 0xa0, 0x0, 0x90, 0xa8, 0x0, 0x0,
    0x0, 0x0, 0xe, 0x6d, 0xfc, 0x20, 0xee, 0x42,
    0xad, 0xe, 0x60, 0x2, 0xf1, 0xe4, 0x0, 0xf,
    0x1e, 0x30, 0x0, 0xf2, 0xe3, 0x0, 0xf, 0x2e,
    0x30, 0x0, 0xf2,

    /* U+00F2 "ò" */
    0x1, 0xc7, 0x0, 0x0, 0x0, 0x1c, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xbf, 0xe8, 0x0,
    0xe, 0xa2, 0x3e, 0x80, 0x5d, 0x0, 0x4, 0xf0,
    0x7a, 0x0, 0x1, 0xf1, 0x5d, 0x0, 0x4, 0xf0,
    0xe, 0xa2, 0x4e, 0x80, 0x2, 0xbf, 0xe8, 0x0,

    /* U+00F3 "ó" */
    0x0, 0xa, 0x80, 0x0, 0x0, 0xa, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xbf, 0xe8, 0x0,
    0xe, 0xa2, 0x3e, 0x80, 0x5d, 0x0, 0x4, 0xf0,
    0x7a, 0x0, 0x1, 0xf1, 0x5d, 0x0, 0x4, 0xf0,
    0xe, 0xa2, 0x4e, 0x80, 0x2, 0xbf, 0xe8, 0x0,

    /* U+00F4 "ô" */
    0x0, 0x3e, 0xb0, 0x0, 0x1, 0xc2, 0x88, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xbf, 0xe8, 0x0,
    0xe, 0xa2, 0x3e, 0x80, 0x5d, 0x0, 0x4, 0xf0,
    0x7a, 0x0, 0x1, 0xf1, 0x5d, 0x0, 0x4, 0xf0,
    0xe, 0xa2, 0x4e, 0x80, 0x2, 0xbf, 0xe8, 0x0,

    /* U+00F5 "õ" */
    0x0, 0xba, 0xa, 0x0, 0x2, 0x72, 0xc4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xbf, 0xe8, 0x0,
    0xe, 0xa2, 0x3e, 0x80, 0x5d, 0x0, 0x4, 0xf0,
    0x7a, 0x0, 0x1, 0xf1, 0x5d, 0x0, 0x4, 0xf0,
    0xe, 0xa2, 0x4e, 0x80, 0x2, 0xbf, 0xe8, 0x0,

    /* U+00F6 "ö" */
    0x0, 0xc2, 0x95, 0x0, 0x0, 0x30, 0x21, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xbf, 0xe8, 0x0,
    0xe, 0xa2, 0x3e, 0x80, 0x5d, 0x0, 0x4, 0xf0,
    0x7a, 0x0, 0x1, 0xf1, 0x5d, 0x0, 0x4, 0xf0,
    0xe, 0xa2, 0x4e, 0x80, 0x2, 0xbf, 0xe8, 0x0,

    /* U+00F7 "÷" */
    0x0, 0x7, 0x0, 0x0, 0x1, 0xe1, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xee, 0xee, 0xe2, 0x1, 0x11,
    0x11, 0x0, 0x0, 0x70, 0x0, 0x0, 0x1e, 0x10,
    0x0,

    /* U+00F8 "ø" */
    0x0, 0x0, 0x3, 0x70, 0x2, 0xbf, 0xef, 0x0,
    0xe, 0xa2, 0xaf, 0x80, 0x5d, 0x1, 0xa4, 0xf0,
    0x7a, 0x8, 0x21, 0xf1, 0x5d, 0x38, 0x4, 0xf0,
    0xe, 0xf3, 0x4e, 0x80, 0x7, 0xff, 0xe8, 0x0,
    0xa, 0x0, 0x0, 0x0,

    /* U+00F9 "ù" */
    0xa, 0xb0, 0x0, 0x0, 0x8, 0x70, 0x0, 0x0,
    0x0, 0x0, 0xf, 0x20, 0x2, 0xf0, 0xf2, 0x0,
    0x2f, 0xf, 0x20, 0x2, 0xf0, 0xf2, 0x0, 0x2f,
    0xe, 0x40, 0x5, 0xf0, 0xac, 0x33, 0xdf, 0x1,
    0xbf, 0xd6, 0xf0,

    /* U+00FA "ú" */
    0x0, 0x6c, 0x0, 0x0, 0x7, 0x30, 0x0, 0x0,
    0x0, 0x0, 0xf, 0x20, 0x2, 0xf0, 0xf2, 0x0,
    0x2f, 0xf, 0x20, 0x2, 0xf0, 0xf2, 0x0, 0x2f,
    0xe, 0x40, 0x5, 0xf0, 0xac, 0x33, 0xdf, 0x1,
    0xbf, 0xd6, 0xf0,

    /* U+00FB "û" */
    0x1, 0xdd, 0x10, 0x0, 0xa5, 0x4a, 0x0, 0x0,
    0x0, 0x0, 0xf, 0x20, 0x2, 0xf0, 0xf2, 0x0,
    0x2f, 0xf, 0x20, 0x2, 0xf0, 0xf2, 0x0, 0x2f,
    0xe, 0x40, 0x5, 0xf0, 0xac, 0x33, 0xdf, 0x1,
    0xbf, 0xd6, 0xf0,

    /* U+00FC "ü" */
    0x9, 0x55, 0x90, 0x0, 0x21, 0x12, 0x0, 0x0,
    0x0, 0x0, 0xf, 0x20, 0x2, 0xf0, 0xf2, 0x0,
    0x2f, 0xf, 0x20, 0x2, 0xf0, 0xf2, 0x0, 0x2f,
    0xe, 0x40, 0x5, 0xf0, 0xac, 0x33, 0xdf, 0x1,
    0xbf, 0xd6, 0xf0,

    /* U+00FD "ý" */
    0x0, 0x4, 0xe0, 0x0, 0x0, 0x5, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xd, 0x50, 0x0, 0x98,
    0x7, 0xb0, 0x0, 0xf2, 0x1, 0xf1, 0x5, 0xb0,
    0x0, 0xb7, 0xb, 0x50, 0x0, 0x5d, 0x2e, 0x0,
    0x0, 0xe, 0xb9, 0x0, 0x0, 0x8, 0xf3, 0x0,
    0x0, 0x5, 0xc0, 0x0, 0x5, 0x2c, 0x60, 0x0,
    0x1c, 0xf9, 0x0, 0x0,

    /* U+00FE "þ" */
    0xe4, 0x0, 0x0, 0xe, 0x40, 0x0, 0x0, 0xe4,
    0x0, 0x0, 0xe, 0x7c, 0xfc, 0x40, 0xef, 0x52,
    0x7f, 0x2e, 0x60, 0x0, 0xa8, 0xe4, 0x0, 0x8,
    0xae, 0x70, 0x0, 0xb8, 0xef, 0x52, 0x7f, 0x2e,
    0x6c, 0xfc, 0x40, 0xe4, 0x0, 0x0, 0xe, 0x40,
    0x0, 0x0, 0xe4, 0x0, 0x0, 0x0,

    /* U+00FF "ÿ" */
    0x0, 0x68, 0x3b, 0x0, 0x0, 0x12, 0x3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xd, 0x50, 0x0, 0x98,
    0x7, 0xb0, 0x0, 0xf2, 0x1, 0xf1, 0x5, 0xb0,
    0x0, 0xb7, 0xb, 0x50, 0x0, 0x5d, 0x2e, 0x0,
    0x0, 0xe, 0xb9, 0x0, 0x0, 0x8, 0xf3, 0x0,
    0x0, 0x5, 0xc0, 0x0, 0x5, 0x2c, 0x60, 0x0,
    0x1c, 0xf9, 0x0, 0x0,

    /* U+0100 "Ā" */
    0x0, 0x7, 0xcc, 0xc4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0x20, 0x0, 0x0,
    0x0, 0xdd, 0x90, 0x0, 0x0, 0x4, 0xe3, 0xf1,
    0x0, 0x0, 0xb, 0x80, 0xc7, 0x0, 0x0, 0x2f,
    0x20, 0x6d, 0x0, 0x0, 0x8c, 0x0, 0x1f, 0x40,
    0x0, 0xef, 0xee, 0xef, 0xb0, 0x6, 0xe2, 0x11,
    0x14, 0xf2, 0xd, 0x70, 0x0, 0x0, 0xb9,

    /* U+0101 "ā" */
    0x5, 0xcc, 0xc5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xbf, 0xe5, 0xf2, 0xd, 0xb2, 0x3d, 0xf2,
    0x4e, 0x0, 0x2, 0xf2, 0x6c, 0x0, 0x0, 0xf2,
    0x4e, 0x0, 0x2, 0xf2, 0xd, 0xb2, 0x3d, 0xf2,
    0x1, 0xbf, 0xe5, 0xe2,

    /* U+0102 "Ă" */
    0x0, 0x3, 0x20, 0x42, 0x0, 0x0, 0x1, 0xab,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0x20, 0x0, 0x0, 0x0, 0xdd, 0x90,
    0x0, 0x0, 0x4, 0xe3, 0xf1, 0x0, 0x0, 0xb,
    0x80, 0xc7, 0x0, 0x0, 0x2f, 0x20, 0x6d, 0x0,
    0x0, 0x8c, 0x0, 0x1f, 0x40, 0x0, 0xef, 0xee,
    0xef, 0xb0, 0x6, 0xe2, 0x11, 0x14, 0xf2, 0xd,
    0x70, 0x0, 0x0, 0xb9,

    /* U+0103 "ă" */
    0x5, 0x70, 0x84, 0x0, 0x0, 0x9b, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xbf, 0xe5, 0xf2,
    0xd, 0xb2, 0x3d, 0xf2, 0x4e, 0x0, 0x2, 0xf2,
    0x6c, 0x0, 0x0, 0xf2, 0x4e, 0x0, 0x2, 0xf2,
    0xd, 0xb2, 0x3d, 0xf2, 0x1, 0xbf, 0xe5, 0xe2,

    /* U+0104 "Ą" */
    0x0, 0x0, 0x6f, 0x20, 0x0, 0x0, 0x0, 0xd,
    0xd9, 0x0, 0x0, 0x0, 0x4, 0xe3, 0xf1, 0x0,
    0x0, 0x0, 0xb8, 0xc, 0x70, 0x0, 0x0, 0x2f,
    0x20, 0x6d, 0x0, 0x0, 0x8, 0xc0, 0x1, 0xf4,
    0x0, 0x0, 0xef, 0xee, 0xef, 0xb0, 0x0, 0x6e,
    0x21, 0x11, 0x4f, 0x20, 0xd, 0x70, 0x0, 0x0,
    0xbb, 0x0, 0x0, 0x0, 0x0, 0xb, 0x30, 0x0,
    0x0, 0x0, 0x6, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x2d, 0xb0,

    /* U+0105 "ą" */
    0x1, 0xbf, 0xe5, 0xf2, 0xd, 0xb2, 0x3d, 0xf2,
    0x4e, 0x0, 0x2, 0xf2, 0x6c, 0x0, 0x0, 0xf2,
    0x4e, 0x0, 0x2, 0xf2, 0xd, 0xb2, 0x3d, 0xf2,
    0x1, 0xbf, 0xeb, 0xe2, 0x0, 0x0, 0xa5, 0x0,
    0x0, 0x1, 0xc0, 0x0, 0x0, 0x0, 0xbc, 0x30,

    /* U+0106 "Ć" */
    0x0, 0x0, 0x58, 0x0, 0x0, 0x0, 0xb, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xbf,
    0xfb, 0x30, 0x4, 0xf9, 0x43, 0x8e, 0x0, 0xe7,
    0x0, 0x0, 0x0, 0x5f, 0x0, 0x0, 0x0, 0x6,
    0xc0, 0x0, 0x0, 0x0, 0x5f, 0x0, 0x0, 0x0,
    0x0, 0xe7, 0x0, 0x0, 0x0, 0x4, 0xf9, 0x44,
    0x8e, 0x0, 0x4, 0xbf, 0xfb, 0x30,

    /* U+0107 "ć" */
    0x0, 0xd, 0x50, 0x0, 0x0, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2b, 0xfe, 0x80, 0xe, 0xa2,
    0x4d, 0x35, 0xd0, 0x0, 0x0, 0x7a, 0x0, 0x0,
    0x5, 0xd0, 0x0, 0x0, 0xe, 0xa2, 0x4d, 0x30,
    0x2b, 0xfe, 0x80,

    /* U+0108 "Ĉ" */
    0x0, 0x0, 0x65, 0x0, 0x0, 0x0, 0xa7, 0x98,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xbf,
    0xfb, 0x30, 0x4, 0xf9, 0x43, 0x8e, 0x0, 0xe7,
    0x0, 0x0, 0x0, 0x5f, 0x0, 0x0, 0x0, 0x6,
    0xc0, 0x0, 0x0, 0x0, 0x5f, 0x0, 0x0, 0x0,
    0x0, 0xe7, 0x0, 0x0, 0x0, 0x4, 0xf9, 0x44,
    0x8e, 0x0, 0x4, 0xbf, 0xfb, 0x30,

    /* U+0109 "ĉ" */
    0x0, 0x5f, 0x90, 0x0, 0x2c, 0x1a, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x2b, 0xfe, 0x80, 0xe, 0xa2,
    0x4d, 0x35, 0xd0, 0x0, 0x0, 0x7a, 0x0, 0x0,
    0x5, 0xd0, 0x0, 0x0, 0xe, 0xa2, 0x4d, 0x30,
    0x2b, 0xfe, 0x80,

    /* U+010A "Ċ" */
    0x0, 0x0, 0x97, 0x0, 0x0, 0x0, 0x4, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xbf,
    0xfb, 0x30, 0x4, 0xf9, 0x43, 0x8e, 0x0, 0xe7,
    0x0, 0x0, 0x0, 0x5f, 0x0, 0x0, 0x0, 0x6,
    0xc0, 0x0, 0x0, 0x0, 0x5f, 0x0, 0x0, 0x0,
    0x0, 0xe7, 0x0, 0x0, 0x0, 0x4, 0xf9, 0x44,
    0x8e, 0x0, 0x4, 0xbf, 0xfb, 0x30,

    /* U+010B "ċ" */
    0x0, 0xd, 0x30, 0x0, 0x0, 0x61, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2b, 0xfe, 0x80, 0xe, 0xa2,
    0x4d, 0x35, 0xd0, 0x0, 0x0, 0x7a, 0x0, 0x0,
    0x5, 0xd0, 0x0, 0x0, 0xe, 0xa2, 0x4d, 0x30,
    0x2b, 0xfe, 0x80,

    /* U+010C "Č" */
    0x0, 0x7, 0x12, 0x60, 0x0, 0x0, 0x3d, 0xc2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xbf,
    0xfb, 0x30, 0x4, 0xf9, 0x43, 0x8e, 0x0, 0xe7,
    0x0, 0x0, 0x0, 0x5f, 0x0, 0x0, 0x0, 0x6,
    0xc0, 0x0, 0x0, 0x0, 0x5f, 0x0, 0x0, 0x0,
    0x0, 0xe7, 0x0, 0x0, 0x0, 0x4, 0xf9, 0x44,
    0x8e, 0x0, 0x4, 0xbf, 0xfb, 0x30,

    /* U+010D "č" */
    0x2, 0xd2, 0xb5, 0x0, 0x4, 0xe8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2b, 0xfe, 0x80, 0xe, 0xa2,
    0x4d, 0x35, 0xd0, 0x0, 0x0, 0x7a, 0x0, 0x0,
    0x5, 0xd0, 0x0, 0x0, 0xe, 0xa2, 0x4d, 0x30,
    0x2b, 0xfe, 0x80,

    /* U+010E "Ď" */
    0x2, 0x50, 0x53, 0x0, 0x0, 0x8, 0xd9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0xfe,
    0xa3, 0x0, 0xc8, 0x22, 0x39, 0xf4, 0xc, 0x70,
    0x0, 0x7, 0xd0, 0xc7, 0x0, 0x0, 0xf, 0x3c,
    0x70, 0x0, 0x0, 0xe4, 0xc7, 0x0, 0x0, 0xf,
    0x3c, 0x70, 0x0, 0x7, 0xd0, 0xc8, 0x22, 0x39,
    0xf4, 0xc, 0xff, 0xfe, 0xa3, 0x0,

    /* U+010F "ď" */
    0x0, 0x0, 0x1, 0xf1, 0xd1, 0x0, 0x0, 0x1,
    0xf1, 0xd0, 0x0, 0x0, 0x1, 0xf1, 0x70, 0x2,
    0xbf, 0xd6, 0xf1, 0x0, 0xe, 0xa2, 0x3e, 0xf1,
    0x0, 0x6d, 0x0, 0x4, 0xf1, 0x0, 0x7a, 0x0,
    0x1, 0xf1, 0x0, 0x6d, 0x0, 0x4, 0xf1, 0x0,
    0xe, 0xa2, 0x4e, 0xf1, 0x0, 0x2, 0xbf, 0xd5,
    0xf1, 0x0,

    /* U+0110 "Đ" */
    0xa, 0xff, 0xfe, 0xb3, 0x0, 0xa, 0x92, 0x23,
    0x8f, 0x50, 0xa, 0x80, 0x0, 0x6, 0xe0, 0xa,
    0x80, 0x0, 0x0, 0xe4, 0xdf, 0xfe, 0xd0, 0x0,
    0xc6, 0x1c, 0xa1, 0x10, 0x0, 0xe4, 0xa, 0x80,
    0x0, 0x6, 0xe0, 0xa, 0x92, 0x23, 0x8f, 0x50,
    0xa, 0xff, 0xfe, 0xb3, 0x0,

    /* U+0111 "đ" */
    0x0, 0x0, 0x1, 0xf1, 0x0, 0x0, 0x8e, 0xff,
    0xf2, 0x0, 0x0, 0x1, 0xf1, 0x0, 0x2b, 0xfd,
    0x6f, 0x10, 0xe, 0xa2, 0x3e, 0xf1, 0x6, 0xd0,
    0x0, 0x4f, 0x10, 0x7a, 0x0, 0x1, 0xf1, 0x6,
    0xd0, 0x0, 0x4f, 0x10, 0xe, 0xa2, 0x4e, 0xf1,
    0x0, 0x2b, 0xfd, 0x5f, 0x10,

    /* U+0112 "Ē" */
    0x9, 0xcc, 0xc2, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0xff, 0xff, 0x2c, 0x82, 0x22, 0x20, 0xc7, 0x0,
    0x0, 0xc, 0x70, 0x0, 0x0, 0xcf, 0xff, 0xfa,
    0xc, 0x82, 0x22, 0x10, 0xc7, 0x0, 0x0, 0xc,
    0x82, 0x22, 0x20, 0xcf, 0xff, 0xff, 0x50,

    /* U+0113 "ē" */
    0x3, 0xcc, 0xc7, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xbf, 0xd5, 0x0, 0xe8, 0x14, 0xf4, 0x6c, 0x0,
    0x7, 0xa7, 0xfe, 0xee, 0xec, 0x5d, 0x0, 0x0,
    0x0, 0xea, 0x23, 0xa2, 0x2, 0xbf, 0xe9, 0x0,

    /* U+0114 "Ĕ" */
    0x5, 0x10, 0x60, 0x0, 0x3b, 0xb7, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xf2, 0xc8, 0x22,
    0x22, 0xc, 0x70, 0x0, 0x0, 0xc7, 0x0, 0x0,
    0xc, 0xff, 0xff, 0xa0, 0xc8, 0x22, 0x21, 0xc,
    0x70, 0x0, 0x0, 0xc8, 0x22, 0x22, 0xc, 0xff,
    0xff, 0xf5,

    /* U+0115 "ĕ" */
    0x2, 0xa0, 0x57, 0x0, 0x7, 0xba, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2b, 0xfd, 0x50, 0xe, 0x81,
    0x4f, 0x46, 0xc0, 0x0, 0x7a, 0x7f, 0xee, 0xee,
    0xc5, 0xd0, 0x0, 0x0, 0xe, 0xa2, 0x3a, 0x20,
    0x2b, 0xfe, 0x90,

    /* U+0116 "Ė" */
    0x0, 0x15, 0x0, 0x0, 0x5, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xf2, 0xc8, 0x22,
    0x22, 0xc, 0x70, 0x0, 0x0, 0xc7, 0x0, 0x0,
    0xc, 0xff, 0xff, 0xa0, 0xc8, 0x22, 0x21, 0xc,
    0x70, 0x0, 0x0, 0xc8, 0x22, 0x22, 0xc, 0xff,
    0xff, 0xf5,

    /* U+0117 "ė" */
    0x0, 0xd, 0x30, 0x0, 0x0, 0x61, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2b, 0xfd, 0x50, 0xe, 0x81,
    0x4f, 0x46, 0xc0, 0x0, 0x7a, 0x7f, 0xee, 0xee,
    0xc5, 0xd0, 0x0, 0x0, 0xe, 0xa2, 0x3a, 0x20,
    0x2b, 0xfe, 0x90,

    /* U+0118 "Ę" */
    0xcf, 0xff, 0xff, 0x2c, 0x82, 0x22, 0x20, 0xc7,
    0x0, 0x0, 0xc, 0x70, 0x0, 0x0, 0xcf, 0xff,
    0xfa, 0xc, 0x82, 0x22, 0x10, 0xc7, 0x0, 0x0,
    0xc, 0x82, 0x22, 0x20, 0xcf, 0xff, 0xff, 0x60,
    0x0, 0x6, 0x90, 0x0, 0x0, 0xd0, 0x0, 0x0,
    0x8, 0xc6,

    /* U+0119 "ę" */
    0x2, 0xbf, 0xd6, 0x0, 0xe8, 0x14, 0xf4, 0x5d,
    0x0, 0x6, 0xa7, 0xfe, 0xee, 0xec, 0x5d, 0x0,
    0x0, 0x0, 0xda, 0x23, 0xa2, 0x2, 0xbf, 0xfc,
    0x0, 0x0, 0xd, 0x10, 0x0, 0x2, 0xa0, 0x0,
    0x0, 0xb, 0xc2,

    /* U+011A "Ě" */
    0x5, 0x30, 0x71, 0x0, 0x1c, 0xd5, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xff, 0xff, 0xf2, 0xc8, 0x22,
    0x22, 0xc, 0x70, 0x0, 0x0, 0xc7, 0x0, 0x0,
    0xc, 0xff, 0xff, 0xa0, 0xc8, 0x22, 0x21, 0xc,
    0x70, 0x0, 0x0, 0xc8, 0x22, 0x22, 0xc, 0xff,
    0xff, 0xf5,

    /* U+011B "ě" */
    0x2, 0xd2, 0xb6, 0x0, 0x4, 0xe9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2b, 0xfd, 0x50, 0xe, 0x81,
    0x4f, 0x46, 0xc0, 0x0, 0x7a, 0x7f, 0xee, 0xee,
    0xc5, 0xd0, 0x0, 0x0, 0xe, 0xa2, 0x3a, 0x20,
    0x2b, 0xfe, 0x90,

    /* U+011C "Ĝ" */
    0x0, 0x0, 0x75, 0x0, 0x0, 0x0, 0xa7, 0x98,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xbf,
    0xfc, 0x40, 0x5, 0xf9, 0x43, 0x7e, 0x10, 0xe7,
    0x0, 0x0, 0x0, 0x5f, 0x0, 0x0, 0x0, 0x6,
    0xc0, 0x0, 0x0, 0x81, 0x5f, 0x0, 0x0, 0xf,
    0x30, 0xe7, 0x0, 0x0, 0xf3, 0x4, 0xf9, 0x43,
    0x7f, 0x30, 0x3, 0xbf, 0xfc, 0x50,

    /* U+011D "ĝ" */
    0x0, 0x1e, 0xd0, 0x0, 0x0, 0xb4, 0x6a, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xbf, 0xd5, 0xe2,
    0xe, 0xa2, 0x3d, 0xf2, 0x6d, 0x0, 0x2, 0xf2,
    0x7a, 0x0, 0x0, 0xf2, 0x5d, 0x0, 0x2, 0xf2,
    0xe, 0xa2, 0x3d, 0xf2, 0x2, 0xbf, 0xd5, 0xf2,
    0x0, 0x0, 0x2, 0xf0, 0xc, 0x62, 0x3b, 0xb0,
    0x6, 0xcf, 0xe9, 0x10,

    /* U+011E "Ğ" */
    0x0, 0x6, 0x0, 0x60, 0x0, 0x0, 0x6b, 0xb4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xbf,
    0xfc, 0x40, 0x5, 0xf9, 0x43, 0x7e, 0x10, 0xe7,
    0x0, 0x0, 0x0, 0x5f, 0x0, 0x0, 0x0, 0x6,
    0xc0, 0x0, 0x0, 0x81, 0x5f, 0x0, 0x0, 0xf,
    0x30, 0xe7, 0x0, 0x0, 0xf3, 0x4, 0xf9, 0x43,
    0x7f, 0x30, 0x3, 0xbf, 0xfc, 0x50,

    /* U+011F "ğ" */
    0x0, 0xc0, 0xc, 0x0, 0x0, 0xb2, 0x49, 0x0,
    0x0, 0x2b, 0xa1, 0x0, 0x2, 0xbf, 0xd5, 0xe2,
    0xe, 0xa2, 0x3d, 0xf2, 0x6d, 0x0, 0x2, 0xf2,
    0x7a, 0x0, 0x0, 0xf2, 0x5d, 0x0, 0x2, 0xf2,
    0xe, 0xa2, 0x3d, 0xf2, 0x2, 0xbf, 0xd5, 0xf2,
    0x0, 0x0, 0x2, 0xf0, 0xc, 0x62, 0x3b, 0xb0,
    0x6, 0xcf, 0xe9, 0x10,

    /* U+0120 "Ġ" */
    0x0, 0x0, 0x97, 0x0, 0x0, 0x0, 0x4, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xbf,
    0xfc, 0x40, 0x5, 0xf9, 0x43, 0x7e, 0x10, 0xe7,
    0x0, 0x0, 0x0, 0x5f, 0x0, 0x0, 0x0, 0x6,
    0xc0, 0x0, 0x0, 0x81, 0x5f, 0x0, 0x0, 0xf,
    0x30, 0xe7, 0x0, 0x0, 0xf3, 0x4, 0xf9, 0x43,
    0x7f, 0x30, 0x3, 0xbf, 0xfc, 0x50,

    /* U+0121 "ġ" */
    0x0, 0x9, 0x70, 0x0, 0x0, 0x4, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xbf, 0xd5, 0xe2,
    0xe, 0xa2, 0x3d, 0xf2, 0x6d, 0x0, 0x2, 0xf2,
    0x7a, 0x0, 0x0, 0xf2, 0x5d, 0x0, 0x2, 0xf2,
    0xe, 0xa2, 0x3d, 0xf2, 0x2, 0xbf, 0xd5, 0xf2,
    0x0, 0x0, 0x2, 0xf0, 0xc, 0x62, 0x3b, 0xb0,
    0x6, 0xcf, 0xe9, 0x10,

    /* U+0122 "Ģ" */
    0x0, 0x3b, 0xff, 0xc4, 0x0, 0x5f, 0x94, 0x37,
    0xe1, 0xe, 0x70, 0x0, 0x0, 0x5, 0xf0, 0x0,
    0x0, 0x0, 0x6c, 0x0, 0x0, 0x8, 0x15, 0xf0,
    0x0, 0x0, 0xf3, 0xe, 0x70, 0x0, 0xf, 0x30,
    0x4f, 0x94, 0x37, 0xf3, 0x0, 0x3b, 0xff, 0xc5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa5,
    0x0, 0x0, 0x0, 0x7, 0x30, 0x0, 0x0, 0x0,
    0x10, 0x0, 0x0,

    /* U+0123 "ģ" */
    0x0, 0x4, 0x60, 0x0, 0x0, 0xa, 0x60, 0x0,
    0x0, 0x3, 0x20, 0x0, 0x2, 0xbf, 0xd5, 0xe2,
    0xe, 0xa2, 0x3d, 0xf2, 0x6d, 0x0, 0x2, 0xf2,
    0x7a, 0x0, 0x0, 0xf2, 0x5d, 0x0, 0x2, 0xf2,
    0xe, 0xa2, 0x3d, 0xf2, 0x2, 0xbf, 0xd5, 0xf2,
    0x0, 0x0, 0x2, 0xf0, 0xc, 0x62, 0x3b, 0xb0,
    0x6, 0xcf, 0xe9, 0x10,

    /* U+0124 "Ĥ" */
    0x0, 0x7, 0x50, 0x0, 0x0, 0xb6, 0xa7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc7, 0x0, 0x0, 0xb7,
    0xc7, 0x0, 0x0, 0xb7, 0xc7, 0x0, 0x0, 0xb7,
    0xc7, 0x0, 0x0, 0xb7, 0xcf, 0xff, 0xff, 0xf7,
    0xc8, 0x22, 0x22, 0xc7, 0xc7, 0x0, 0x0, 0xb7,
    0xc7, 0x0, 0x0, 0xb7, 0xc7, 0x0, 0x0, 0xb7,

    /* U+0125 "ĥ" */
    0x6, 0xcb, 0x0, 0x0, 0x1, 0x60, 0x44, 0x0,
    0x0, 0x0, 0xe3, 0x0, 0x0, 0x0, 0xe, 0x30,
    0x0, 0x0, 0x0, 0xe3, 0x0, 0x0, 0x0, 0xe,
    0x7d, 0xfc, 0x20, 0x0, 0xee, 0x42, 0xad, 0x0,
    0xe, 0x60, 0x2, 0xf1, 0x0, 0xe4, 0x0, 0xf,
    0x10, 0xe, 0x30, 0x0, 0xf2, 0x0, 0xe3, 0x0,
    0xf, 0x20, 0xe, 0x30, 0x0, 0xf2,

    /* U+0126 "Ħ" */
    0xa, 0x80, 0x0, 0xa, 0x90, 0xdf, 0xfe, 0xee,
    0xef, 0xfb, 0x1c, 0xa1, 0x11, 0x1b, 0xa1, 0xa,
    0x80, 0x0, 0xa, 0x90, 0xa, 0xff, 0xff, 0xff,
    0x90, 0xa, 0x92, 0x22, 0x2a, 0x90, 0xa, 0x80,
    0x0, 0xa, 0x90, 0xa, 0x80, 0x0, 0xa, 0x90,
    0xa, 0x80, 0x0, 0xa, 0x90,

    /* U+0127 "ħ" */
    0x0, 0xe3, 0x0, 0x0, 0x0, 0xef, 0xfe, 0xa0,
    0x0, 0x0, 0xe3, 0x0, 0x0, 0x0, 0xe, 0x7d,
    0xfc, 0x20, 0x0, 0xee, 0x42, 0xad, 0x0, 0xe,
    0x60, 0x2, 0xf1, 0x0, 0xe4, 0x0, 0xf, 0x10,
    0xe, 0x30, 0x0, 0xf2, 0x0, 0xe3, 0x0, 0xf,
    0x20, 0xe, 0x30, 0x0, 0xf2,

    /* U+0128 "Ĩ" */
    0x9, 0xa0, 0x91, 0x83, 0xc6, 0x0, 0x0, 0x0,
    0xc, 0x70, 0x0, 0xc7, 0x0, 0xc, 0x70, 0x0,
    0xc7, 0x0, 0xc, 0x70, 0x0, 0xc7, 0x0, 0xc,
    0x70, 0x0, 0xc7, 0x0, 0xc, 0x70,

    /* U+0129 "ĩ" */
    0xa, 0x95, 0x50, 0x94, 0xc1, 0x0, 0x0, 0x0,
    0xe, 0x30, 0x0, 0xe3, 0x0, 0xe, 0x30, 0x0,
    0xe3, 0x0, 0xe, 0x30, 0x0, 0xe3, 0x0, 0xe,
    0x30,

    /* U+012A "Ī" */
    0x9c, 0xc5, 0x0, 0x0, 0xc, 0x70, 0xc, 0x70,
    0xc, 0x70, 0xc, 0x70, 0xc, 0x70, 0xc, 0x70,
    0xc, 0x70, 0xc, 0x70, 0xc, 0x70,

    /* U+012B "ī" */
    0xbc, 0xc3, 0x0, 0x0, 0xe, 0x30, 0xe, 0x30,
    0xe, 0x30, 0xe, 0x30, 0xe, 0x30, 0xe, 0x30,
    0xe, 0x30,

    /* U+012C "Ĭ" */
    0x6, 0x1, 0x50, 0x7b, 0xb3, 0x0, 0x0, 0x0,
    0xc, 0x70, 0x0, 0xc7, 0x0, 0xc, 0x70, 0x0,
    0xc7, 0x0, 0xc, 0x70, 0x0, 0xc7, 0x0, 0xc,
    0x70, 0x0, 0xc7, 0x0, 0xc, 0x70,

    /* U+012D "ĭ" */
    0xc0, 0x93, 0x5b, 0x80, 0x0, 0x0, 0xe, 0x30,
    0xe, 0x30, 0xe, 0x30, 0xe, 0x30, 0xe, 0x30,
    0xe, 0x30, 0xe, 0x30,

    /* U+012E "Į" */
    0xc, 0x70, 0xc7, 0xc, 0x70, 0xc7, 0xc, 0x70,
    0xc7, 0xc, 0x70, 0xc7, 0xd, 0x80, 0xa2, 0xc,
    0x0, 0xb9,

    /* U+012F "į" */
    0xd, 0x40, 0x82, 0x0, 0x0, 0xe3, 0xe, 0x30,
    0xe3, 0xe, 0x30, 0xe3, 0xe, 0x30, 0xf4, 0xb,
    0x3, 0x90, 0x1d, 0x60,

    /* U+0130 "İ" */
    0x52, 0xb6, 0x0, 0xc7, 0xc7, 0xc7, 0xc7, 0xc7,
    0xc7, 0xc7, 0xc7, 0xc7,

    /* U+0131 "ı" */
    0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4,

    /* U+0132 "Ĳ" */
    0xd6, 0x0, 0xc, 0x7d, 0x60, 0x0, 0xc7, 0xd6,
    0x0, 0xc, 0x7d, 0x60, 0x0, 0xc7, 0xd6, 0x0,
    0xc, 0x71, 0x0, 0x0, 0xc6, 0x0, 0x0, 0x1f,
    0x39, 0x73, 0x4c, 0xc0, 0x4c, 0xfe, 0xa1, 0x0,

    /* U+0133 "ĳ" */
    0xd, 0x40, 0x8a, 0x8, 0x20, 0x45, 0x0, 0x0,
    0x0, 0xe, 0x30, 0x8a, 0xe, 0x30, 0x8a, 0xe,
    0x30, 0x8a, 0xe, 0x30, 0x8a, 0xe, 0x30, 0x8a,
    0xe, 0x30, 0x8a, 0xe, 0x30, 0x8a, 0x0, 0x0,
    0x8a, 0x0, 0x21, 0xb7, 0x0, 0x8f, 0xc1,

    /* U+0134 "Ĵ" */
    0x0, 0x7, 0x50, 0x0, 0xb6, 0xa7, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xff, 0x0, 0x22, 0x5f, 0x0,
    0x0, 0x3f, 0x0, 0x0, 0x3f, 0x0, 0x0, 0x3f,
    0x0, 0x0, 0x3f, 0x0, 0x0, 0x4e, 0xd, 0x63,
    0xba, 0x5, 0xdf, 0xb1,

    /* U+0135 "ĵ" */
    0x0, 0x3f, 0x90, 0x0, 0xb3, 0xa3, 0x0, 0x0,
    0x0, 0x0, 0xd, 0x40, 0x0, 0xd, 0x40, 0x0,
    0xd, 0x40, 0x0, 0xd, 0x40, 0x0, 0xd, 0x40,
    0x0, 0xd, 0x40, 0x0, 0xd, 0x40, 0x0, 0xd,
    0x40, 0x2, 0x2f, 0x20, 0xd, 0xf8, 0x0,

    /* U+0136 "Ķ" */
    0xc7, 0x0, 0x6, 0xd1, 0xc7, 0x0, 0x5e, 0x20,
    0xc7, 0x4, 0xe3, 0x0, 0xc7, 0x3e, 0x40, 0x0,
    0xc9, 0xef, 0x20, 0x0, 0xcf, 0x89, 0xd0, 0x0,
    0xca, 0x0, 0xca, 0x0, 0xc7, 0x0, 0x1e, 0x70,
    0xc7, 0x0, 0x3, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe, 0x0, 0x0, 0x0, 0xb, 0x0, 0x0,
    0x0, 0x1, 0x0, 0x0,

    /* U+0137 "ķ" */
    0xe3, 0x0, 0x0, 0xe, 0x30, 0x0, 0x0, 0xe3,
    0x0, 0x0, 0xe, 0x30, 0xc, 0xa0, 0xe3, 0xb,
    0xb0, 0xe, 0x4b, 0xc0, 0x0, 0xee, 0xfd, 0x0,
    0xe, 0xc1, 0xd9, 0x0, 0xe3, 0x3, 0xf4, 0xe,
    0x30, 0x6, 0xe1, 0x0, 0x0, 0x0, 0x0, 0xb,
    0x40, 0x0, 0x0, 0x91, 0x0, 0x0, 0x2, 0x0,
    0x0,

    /* U+0138 "ĸ" */
    0xe4, 0x0, 0xba, 0xe, 0x40, 0xbb, 0x0, 0xe4,
    0xbc, 0x0, 0xe, 0xef, 0xd0, 0x0, 0xec, 0x1d,
    0x90, 0xe, 0x40, 0x2f, 0x40, 0xe4, 0x0, 0x6e,
    0x10,

    /* U+0139 "Ĺ" */
    0x67, 0x0, 0x0, 0xc3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc7, 0x0, 0x0, 0xc7, 0x0, 0x0, 0xc7,
    0x0, 0x0, 0xc7, 0x0, 0x0, 0xc7, 0x0, 0x0,
    0xc7, 0x0, 0x0, 0xc7, 0x0, 0x0, 0xc8, 0x22,
    0x22, 0xcf, 0xff, 0xff,

    /* U+013A "ĺ" */
    0x8, 0x50, 0xe1, 0x0, 0x0, 0xe3, 0xe, 0x30,
    0xe3, 0xe, 0x30, 0xe3, 0xe, 0x30, 0xe3, 0xe,
    0x30, 0xe3, 0xe, 0x30,

    /* U+013B "Ļ" */
    0xc7, 0x0, 0x0, 0xc7, 0x0, 0x0, 0xc7, 0x0,
    0x0, 0xc7, 0x0, 0x0, 0xc7, 0x0, 0x0, 0xc7,
    0x0, 0x0, 0xc7, 0x0, 0x0, 0xc8, 0x22, 0x22,
    0xcf, 0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x3b,
    0x0, 0x0, 0x19, 0x0, 0x0, 0x1, 0x0,

    /* U+013C "ļ" */
    0xe3, 0xe3, 0xe3, 0xe3, 0xe3, 0xe3, 0xe3, 0xe3,
    0xe3, 0xe3, 0x0, 0xc2, 0xa0, 0x10,

    /* U+013D "Ľ" */
    0x0, 0x0, 0xc2, 0xc7, 0x0, 0xc1, 0xc7, 0x0,
    0x60, 0xc7, 0x0, 0x0, 0xc7, 0x0, 0x0, 0xc7,
    0x0, 0x0, 0xc7, 0x0, 0x0, 0xc7, 0x0, 0x0,
    0xc8, 0x22, 0x22, 0xcf, 0xff, 0xff,

    /* U+013E "ľ" */
    0xe3, 0xb3, 0xe3, 0xb2, 0xe3, 0x51, 0xe3, 0x0,
    0xe3, 0x0, 0xe3, 0x0, 0xe3, 0x0, 0xe3, 0x0,
    0xe3, 0x0, 0xe3, 0x0,

    /* U+013F "Ŀ" */
    0xc7, 0x0, 0x0, 0xc7, 0x0, 0x0, 0xc7, 0x0,
    0x0, 0xc7, 0x2, 0xd0, 0xc7, 0x1, 0x80, 0xc7,
    0x0, 0x0, 0xc7, 0x0, 0x0, 0xc8, 0x22, 0x22,
    0xcf, 0xff, 0xff,

    /* U+0140 "ŀ" */
    0xe3, 0x0, 0xe3, 0x0, 0xe3, 0x0, 0xe3, 0x0,
    0xe3, 0x0, 0xe3, 0xd5, 0xe3, 0x20, 0xe3, 0x0,
    0xe3, 0x0, 0xe3, 0x0,

    /* U+0141 "Ł" */
    0xa, 0x80, 0x0, 0x0, 0xa, 0x80, 0x0, 0x0,
    0xa, 0x9a, 0x20, 0x0, 0xc, 0xf7, 0x0, 0x0,
    0x4f, 0xd0, 0x0, 0x0, 0x8d, 0x80, 0x0, 0x0,
    0xa, 0x80, 0x0, 0x0, 0xa, 0x92, 0x22, 0x20,
    0xa, 0xff, 0xff, 0xf1,

    /* U+0142 "ł" */
    0x0, 0xd5, 0x0, 0xd, 0x50, 0x0, 0xd5, 0x0,
    0xd, 0x72, 0x0, 0xff, 0x40, 0x5f, 0x80, 0x9,
    0xe5, 0x0, 0xd, 0x50, 0x0, 0xd5, 0x0, 0xd,
    0x50,

    /* U+0143 "Ń" */
    0x0, 0x6, 0x70, 0x0, 0x0, 0xc, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc9, 0x0, 0x0, 0xb7,
    0xcf, 0x50, 0x0, 0xb7, 0xcc, 0xf2, 0x0, 0xb7,
    0xc7, 0xad, 0x0, 0xb7, 0xc7, 0xd, 0x90, 0xb7,
    0xc7, 0x2, 0xf5, 0xb7, 0xc7, 0x0, 0x6f, 0xd7,
    0xc7, 0x0, 0xa, 0xf7, 0xc7, 0x0, 0x0, 0xd7,

    /* U+0144 "ń" */
    0x0, 0x5d, 0x0, 0x0, 0x6, 0x40, 0x0, 0x0,
    0x0, 0x0, 0xe, 0x6d, 0xfc, 0x20, 0xee, 0x42,
    0xad, 0xe, 0x60, 0x2, 0xf1, 0xe4, 0x0, 0xf,
    0x1e, 0x30, 0x0, 0xf2, 0xe3, 0x0, 0xf, 0x2e,
    0x30, 0x0, 0xf2,

    /* U+0145 "Ņ" */
    0xc9, 0x0, 0x0, 0xb7, 0xcf, 0x50, 0x0, 0xb7,
    0xcc, 0xf2, 0x0, 0xb7, 0xc7, 0xad, 0x0, 0xb7,
    0xc7, 0xd, 0x90, 0xb7, 0xc7, 0x2, 0xf5, 0xb7,
    0xc7, 0x0, 0x6f, 0xd7, 0xc7, 0x0, 0xa, 0xf7,
    0xc7, 0x0, 0x0, 0xd7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0x50, 0x0, 0x0, 0x7, 0x30, 0x0,
    0x0, 0x1, 0x0, 0x0,

    /* U+0146 "ņ" */
    0xe6, 0xdf, 0xc2, 0xe, 0xe4, 0x2a, 0xd0, 0xe6,
    0x0, 0x2f, 0x1e, 0x40, 0x0, 0xf1, 0xe3, 0x0,
    0xf, 0x2e, 0x30, 0x0, 0xf2, 0xe3, 0x0, 0xf,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x69, 0x0, 0x0,
    0x3, 0x70, 0x0, 0x0, 0x10, 0x0, 0x0,

    /* U+0147 "Ň" */
    0x0, 0x70, 0x25, 0x0, 0x0, 0x4d, 0xc1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc9, 0x0, 0x0, 0xb7,
    0xcf, 0x50, 0x0, 0xb7, 0xcc, 0xf2, 0x0, 0xb7,
    0xc7, 0xad, 0x0, 0xb7, 0xc7, 0xd, 0x90, 0xb7,
    0xc7, 0x2, 0xf5, 0xb7, 0xc7, 0x0, 0x6f, 0xd7,
    0xc7, 0x0, 0xa, 0xf7, 0xc7, 0x0, 0x0, 0xd7,

    /* U+0148 "ň" */
    0xa, 0x74, 0xc0, 0x0, 0xc, 0xd1, 0x0, 0x0,
    0x0, 0x0, 0xe, 0x6d, 0xfc, 0x20, 0xee, 0x42,
    0xad, 0xe, 0x60, 0x2, 0xf1, 0xe4, 0x0, 0xf,
    0x1e, 0x30, 0x0, 0xf2, 0xe3, 0x0, 0xf, 0x2e,
    0x30, 0x0, 0xf2,

    /* U+0149 "ŉ" */
    0xc6, 0x0, 0x0, 0x0, 0xb7, 0x0, 0x0, 0x0,
    0xa2, 0x0, 0x0, 0x0, 0x75, 0xc8, 0xef, 0x90,
    0x5, 0xfa, 0x24, 0xe6, 0x5, 0xf0, 0x0, 0x8a,
    0x5, 0xd0, 0x0, 0x7a, 0x5, 0xc0, 0x0, 0x7b,
    0x5, 0xc0, 0x0, 0x7b, 0x5, 0xc0, 0x0, 0x7b,

    /* U+014A "Ŋ" */
    0xb9, 0x0, 0x0, 0xb7, 0xbf, 0x50, 0x0, 0xb7,
    0xbc, 0xf2, 0x0, 0xb7, 0xb7, 0xad, 0x0, 0xb7,
    0xb7, 0xd, 0x90, 0xb7, 0xb7, 0x2, 0xf5, 0xb7,
    0xb7, 0x0, 0x6f, 0xd7, 0xb7, 0x0, 0xa, 0xf7,
    0xb7, 0x0, 0x0, 0xd7, 0x0, 0x0, 0x0, 0xd6,
    0x0, 0x1c, 0x35, 0xf2, 0x0, 0x9, 0xfe, 0x60,

    /* U+014B "ŋ" */
    0xe6, 0xdf, 0xc2, 0xe, 0xe4, 0x2a, 0xd0, 0xe6,
    0x0, 0x2f, 0x1e, 0x40, 0x0, 0xf2, 0xe4, 0x0,
    0xf, 0x2e, 0x40, 0x0, 0xf2, 0xe4, 0x0, 0xf,
    0x20, 0x0, 0x0, 0xf2, 0x0, 0x3, 0x4f, 0x0,
    0x1, 0xee, 0x60,

    /* U+014C "Ō" */
    0x0, 0xb, 0xcc, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3b, 0xff, 0xb4, 0x0, 0x4,
    0xf9, 0x44, 0x9f, 0x60, 0xe, 0x70, 0x0, 0x6,
    0xf1, 0x5f, 0x0, 0x0, 0x0, 0xe5, 0x6c, 0x0,
    0x0, 0x0, 0xc7, 0x5f, 0x0, 0x0, 0x0, 0xe5,
    0xe, 0x70, 0x0, 0x6, 0xf1, 0x4, 0xf9, 0x44,
    0x8f, 0x60, 0x0, 0x3b, 0xff, 0xc4, 0x0,

    /* U+014D "ō" */
    0x1, 0xcc, 0xc9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xbf, 0xe8, 0x0, 0xe, 0xa2, 0x3e, 0x80,
    0x5d, 0x0, 0x4, 0xf0, 0x7a, 0x0, 0x1, 0xf1,
    0x5d, 0x0, 0x4, 0xf0, 0xe, 0xa2, 0x4e, 0x80,
    0x2, 0xbf, 0xe8, 0x0,

    /* U+014E "Ŏ" */
    0x0, 0x6, 0x0, 0x60, 0x0, 0x0, 0x4, 0xbb,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b, 0xff, 0xb4, 0x0, 0x4, 0xf9, 0x44, 0x9f,
    0x60, 0xe, 0x70, 0x0, 0x6, 0xf1, 0x5f, 0x0,
    0x0, 0x0, 0xe5, 0x6c, 0x0, 0x0, 0x0, 0xc7,
    0x5f, 0x0, 0x0, 0x0, 0xe5, 0xe, 0x70, 0x0,
    0x6, 0xf1, 0x4, 0xf9, 0x44, 0x8f, 0x60, 0x0,
    0x3b, 0xff, 0xc4, 0x0,

    /* U+014F "ŏ" */
    0x0, 0xc0, 0x39, 0x0, 0x0, 0x5b, 0xa1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xbf, 0xe8, 0x0,
    0xe, 0xa2, 0x3e, 0x80, 0x5d, 0x0, 0x4, 0xf0,
    0x7a, 0x0, 0x1, 0xf1, 0x5d, 0x0, 0x4, 0xf0,
    0xe, 0xa2, 0x4e, 0x80, 0x2, 0xbf, 0xe8, 0x0,

    /* U+0150 "Ő" */
    0x0, 0x0, 0x75, 0x66, 0x0, 0x0, 0x3, 0xc2,
    0xd1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3b, 0xff, 0xb4, 0x0, 0x4, 0xf9, 0x44, 0x9f,
    0x60, 0xe, 0x70, 0x0, 0x6, 0xf1, 0x5f, 0x0,
    0x0, 0x0, 0xe5, 0x6c, 0x0, 0x0, 0x0, 0xc7,
    0x5f, 0x0, 0x0, 0x0, 0xe5, 0xe, 0x70, 0x0,
    0x6, 0xf1, 0x4, 0xf9, 0x44, 0x8f, 0x60, 0x0,
    0x3b, 0xff, 0xc4, 0x0,

    /* U+0151 "ő" */
    0x0, 0x1e, 0x3d, 0x40, 0x0, 0x55, 0x46, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xbf, 0xe8, 0x0,
    0xe, 0xa2, 0x3e, 0x80, 0x5d, 0x0, 0x4, 0xf0,
    0x7a, 0x0, 0x1, 0xf1, 0x5d, 0x0, 0x4, 0xf0,
    0xe, 0xa2, 0x4e, 0x80, 0x2, 0xbf, 0xe8, 0x0,

    /* U+0152 "Œ" */
    0x0, 0x3b, 0xef, 0xff, 0xff, 0xff, 0xa0, 0x5f,
    0x83, 0x25, 0xe2, 0x22, 0x21, 0xe, 0x60, 0x0,
    0x4e, 0x0, 0x0, 0x4, 0xe0, 0x0, 0x4, 0xe0,
    0x0, 0x0, 0x6c, 0x0, 0x0, 0x4f, 0xff, 0xff,
    0x24, 0xe0, 0x0, 0x4, 0xe2, 0x22, 0x20, 0xf,
    0x60, 0x0, 0x4e, 0x0, 0x0, 0x0, 0x5f, 0x83,
    0x25, 0xe2, 0x22, 0x21, 0x0, 0x3b, 0xef, 0xff,
    0xff, 0xff, 0xd0,

    /* U+0153 "œ" */
    0x2, 0xbf, 0xe7, 0x7, 0xef, 0xa1, 0x0, 0xda,
    0x13, 0xdc, 0xd3, 0x2a, 0xb0, 0x5d, 0x0, 0x3,
    0xf4, 0x0, 0xf, 0x17, 0xb0, 0x0, 0x1f, 0xee,
    0xee, 0xe3, 0x5d, 0x0, 0x4, 0xf4, 0x0, 0x0,
    0x0, 0xda, 0x24, 0xec, 0xe4, 0x26, 0x80, 0x2,
    0xbf, 0xe7, 0x6, 0xdf, 0xc3, 0x0,

    /* U+0154 "Ŕ" */
    0x0, 0xa, 0x20, 0x0, 0x0, 0x3d, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0xff, 0xe8, 0x0,
    0xc8, 0x22, 0x5d, 0x90, 0xc7, 0x0, 0x4, 0xf0,
    0xc7, 0x0, 0x4, 0xf0, 0xc7, 0x0, 0x2c, 0xa0,
    0xcf, 0xff, 0xfb, 0x10, 0xc8, 0x22, 0xb9, 0x0,
    0xc7, 0x0, 0x2f, 0x30, 0xc7, 0x0, 0x7, 0xd0,

    /* U+0155 "ŕ" */
    0xa, 0x80, 0xa, 0x10, 0x0, 0x0, 0xe6, 0xd7,
    0xee, 0x51, 0xe6, 0x0, 0xe4, 0x0, 0xe3, 0x0,
    0xe3, 0x0, 0xe3, 0x0,

    /* U+0156 "Ŗ" */
    0xcf, 0xff, 0xe8, 0x0, 0xc8, 0x22, 0x5d, 0x90,
    0xc7, 0x0, 0x4, 0xf0, 0xc7, 0x0, 0x4, 0xf0,
    0xc7, 0x0, 0x2c, 0xa0, 0xcf, 0xff, 0xfb, 0x10,
    0xc8, 0x22, 0xb9, 0x0, 0xc7, 0x0, 0x2f, 0x30,
    0xc7, 0x0, 0x7, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1e, 0x0, 0x0, 0x0, 0xb, 0x0, 0x0,
    0x0, 0x1, 0x0, 0x0,

    /* U+0157 "ŗ" */
    0xe6, 0xd7, 0xee, 0x51, 0xe6, 0x0, 0xe4, 0x0,
    0xe3, 0x0, 0xe3, 0x0, 0xe3, 0x0, 0x0, 0x0,
    0xc2, 0x0, 0xa0, 0x0, 0x10, 0x0,

    /* U+0158 "Ř" */
    0x3, 0x50, 0x62, 0x0, 0x0, 0xad, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0xff, 0xe8, 0x0,
    0xc8, 0x22, 0x5d, 0x90, 0xc7, 0x0, 0x4, 0xf0,
    0xc7, 0x0, 0x4, 0xf0, 0xc7, 0x0, 0x2c, 0xa0,
    0xcf, 0xff, 0xfb, 0x10, 0xc8, 0x22, 0xb9, 0x0,
    0xc7, 0x0, 0x2f, 0x30, 0xc7, 0x0, 0x7, 0xd0,

    /* U+0159 "ř" */
    0x1c, 0x39, 0x80, 0x2d, 0xa0, 0x0, 0x0, 0x0,
    0xe6, 0xd7, 0xe, 0xe5, 0x10, 0xe6, 0x0, 0xe,
    0x40, 0x0, 0xe3, 0x0, 0xe, 0x30, 0x0, 0xe3,
    0x0,

    /* U+015A "Ś" */
    0x0, 0x6, 0x70, 0x0, 0x0, 0xc3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4c, 0xfe, 0xa3, 0x1f, 0x82,
    0x37, 0x44, 0xe0, 0x0, 0x0, 0x1f, 0x81, 0x0,
    0x0, 0x3b, 0xfd, 0x70, 0x0, 0x0, 0x4d, 0xa0,
    0x0, 0x0, 0x4e, 0x5c, 0x42, 0x3b, 0xb0, 0x8d,
    0xfe, 0xa1,

    /* U+015B "ś" */
    0x0, 0x7b, 0x0, 0x0, 0x82, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xef, 0xc2, 0x6d, 0x22, 0x61, 0x6d,
    0x20, 0x0, 0xa, 0xfe, 0x90, 0x0, 0x3, 0xc8,
    0x56, 0x22, 0xb8, 0x4c, 0xee, 0xa1,

    /* U+015C "Ŝ" */
    0x0, 0x7, 0x50, 0x0, 0xb, 0x6a, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x4c, 0xfe, 0xa3, 0x1f, 0x82,
    0x37, 0x44, 0xe0, 0x0, 0x0, 0x1f, 0x81, 0x0,
    0x0, 0x3b, 0xfd, 0x70, 0x0, 0x0, 0x4d, 0xa0,
    0x0, 0x0, 0x4e, 0x5c, 0x42, 0x3b, 0xb0, 0x8d,
    0xfe, 0xa1,

    /* U+015D "ŝ" */
    0x1, 0xdd, 0x10, 0xb, 0x45, 0xa0, 0x0, 0x0,
    0x0, 0x9, 0xef, 0xc2, 0x6d, 0x22, 0x61, 0x6d,
    0x20, 0x0, 0xa, 0xfe, 0x90, 0x0, 0x3, 0xc8,
    0x56, 0x22, 0xb8, 0x4c, 0xee, 0xa1,

    /* U+015E "Ş" */
    0x4, 0xcf, 0xea, 0x31, 0xf8, 0x23, 0x74, 0x4e,
    0x0, 0x0, 0x1, 0xf8, 0x10, 0x0, 0x3, 0xbf,
    0xd7, 0x0, 0x0, 0x4, 0xda, 0x0, 0x0, 0x4,
    0xe5, 0xc4, 0x23, 0xbb, 0x8, 0xdf, 0xfa, 0x10,
    0x0, 0xa4, 0x0, 0x0, 0x1, 0xd0, 0x0, 0x4,
    0xba, 0x0,

    /* U+015F "ş" */
    0x9, 0xef, 0xc2, 0x6d, 0x22, 0x61, 0x6d, 0x20,
    0x0, 0xa, 0xfe, 0x90, 0x0, 0x3, 0xc8, 0x56,
    0x22, 0xb8, 0x4c, 0xff, 0xa1, 0x0, 0x85, 0x0,
    0x0, 0x1c, 0x10, 0x3, 0xbb, 0x0,

    /* U+0160 "Š" */
    0x0, 0x70, 0x25, 0x0, 0x4, 0xdc, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x4c, 0xfe, 0xa3, 0x1f, 0x82,
    0x37, 0x44, 0xe0, 0x0, 0x0, 0x1f, 0x81, 0x0,
    0x0, 0x3b, 0xfd, 0x70, 0x0, 0x0, 0x4d, 0xa0,
    0x0, 0x0, 0x4e, 0x5c, 0x42, 0x3b, 0xb0, 0x8d,
    0xfe, 0xa1,

    /* U+0161 "š" */
    0xb, 0x56, 0xb0, 0x1, 0xdc, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xef, 0xc2, 0x6d, 0x22, 0x61, 0x6d,
    0x20, 0x0, 0xa, 0xfe, 0x90, 0x0, 0x3, 0xc8,
    0x56, 0x22, 0xb8, 0x4c, 0xee, 0xa1,

    /* U+0162 "Ţ" */
    0xff, 0xff, 0xff, 0xf2, 0x23, 0xf3, 0x22, 0x0,
    0x1f, 0x10, 0x0, 0x1, 0xf1, 0x0, 0x0, 0x1f,
    0x10, 0x0, 0x1, 0xf1, 0x0, 0x0, 0x1f, 0x10,
    0x0, 0x1, 0xf1, 0x0, 0x0, 0x1f, 0x10, 0x0,
    0x0, 0xc0, 0x0, 0x0, 0x6, 0x90, 0x0, 0x8,
    0xc5, 0x0,

    /* U+0163 "ţ" */
    0x6, 0x30, 0x0, 0xc6, 0x0, 0xdf, 0xff, 0x30,
    0xc6, 0x0, 0xc, 0x60, 0x0, 0xc6, 0x0, 0xb,
    0x60, 0x0, 0xaa, 0x11, 0x2, 0xef, 0x60, 0x7,
    0x60, 0x0, 0x1c, 0x20, 0x2b, 0xb0,

    /* U+0164 "Ť" */
    0x3, 0x50, 0x53, 0x0, 0x9, 0xd9, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0x22, 0x3f,
    0x32, 0x20, 0x1, 0xf1, 0x0, 0x0, 0x1f, 0x10,
    0x0, 0x1, 0xf1, 0x0, 0x0, 0x1f, 0x10, 0x0,
    0x1, 0xf1, 0x0, 0x0, 0x1f, 0x10, 0x0, 0x1,
    0xf1, 0x0,

    /* U+0165 "ť" */
    0x0, 0x9, 0x40, 0x52, 0x93, 0xc, 0x61, 0xd,
    0xff, 0xf3, 0xc, 0x60, 0x0, 0xc6, 0x0, 0xc,
    0x60, 0x0, 0xb6, 0x0, 0xa, 0xa1, 0x10, 0x2d,
    0xf6,

    /* U+0166 "Ŧ" */
    0xff, 0xff, 0xff, 0xf2, 0x23, 0xf3, 0x22, 0x0,
    0x1f, 0x10, 0x0, 0x1, 0xf1, 0x0, 0xd, 0xff,
    0xfd, 0x0, 0x13, 0xf3, 0x10, 0x0, 0x1f, 0x10,
    0x0, 0x1, 0xf1, 0x0, 0x0, 0x1f, 0x10, 0x0,

    /* U+0167 "ŧ" */
    0x5, 0x30, 0x0, 0xb7, 0x0, 0xcf, 0xff, 0x40,
    0xb7, 0x0, 0xb, 0x70, 0x8, 0xff, 0xe2, 0xa,
    0x70, 0x0, 0x9b, 0x11, 0x2, 0xcf, 0x70,

    /* U+0168 "Ũ" */
    0x0, 0xb9, 0x9, 0x0, 0x3, 0x64, 0xc4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xd6, 0x0, 0x0, 0xe4,
    0xd6, 0x0, 0x0, 0xe4, 0xd6, 0x0, 0x0, 0xe4,
    0xd6, 0x0, 0x0, 0xe4, 0xd6, 0x0, 0x0, 0xe4,
    0xc6, 0x0, 0x0, 0xf3, 0x9a, 0x0, 0x3, 0xf1,
    0x2f, 0x83, 0x5d, 0xa0, 0x4, 0xcf, 0xd8, 0x0,

    /* U+0169 "ũ" */
    0x8, 0xc1, 0xb0, 0x0, 0x91, 0xa7, 0x0, 0x0,
    0x0, 0x0, 0xf, 0x20, 0x2, 0xf0, 0xf2, 0x0,
    0x2f, 0xf, 0x20, 0x2, 0xf0, 0xf2, 0x0, 0x2f,
    0xe, 0x40, 0x5, 0xf0, 0xac, 0x33, 0xdf, 0x1,
    0xbf, 0xd6, 0xf0,

    /* U+016A "Ū" */
    0x2, 0xcc, 0xc8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xd6, 0x0, 0x0, 0xe4, 0xd6, 0x0, 0x0, 0xe4,
    0xd6, 0x0, 0x0, 0xe4, 0xd6, 0x0, 0x0, 0xe4,
    0xd6, 0x0, 0x0, 0xe4, 0xc6, 0x0, 0x0, 0xf3,
    0x9a, 0x0, 0x3, 0xf1, 0x2f, 0x83, 0x5d, 0xa0,
    0x4, 0xcf, 0xd8, 0x0,

    /* U+016B "ū" */
    0xb, 0xcc, 0xc0, 0x0, 0x0, 0x0, 0x0, 0xf2,
    0x0, 0x2f, 0xf, 0x20, 0x2, 0xf0, 0xf2, 0x0,
    0x2f, 0xf, 0x20, 0x2, 0xf0, 0xe4, 0x0, 0x5f,
    0xa, 0xc3, 0x3d, 0xf0, 0x1b, 0xfd, 0x6f, 0x0,

    /* U+016C "Ŭ" */
    0x1, 0x50, 0x14, 0x0, 0x0, 0x8b, 0xb2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xd6, 0x0, 0x0, 0xe4,
    0xd6, 0x0, 0x0, 0xe4, 0xd6, 0x0, 0x0, 0xe4,
    0xd6, 0x0, 0x0, 0xe4, 0xd6, 0x0, 0x0, 0xe4,
    0xc6, 0x0, 0x0, 0xf3, 0x9a, 0x0, 0x3, 0xf1,
    0x2f, 0x83, 0x5d, 0xa0, 0x4, 0xcf, 0xd8, 0x0,

    /* U+016D "ŭ" */
    0xc, 0x11, 0xc0, 0x0, 0x3b, 0xb3, 0x0, 0x0,
    0x0, 0x0, 0xf, 0x20, 0x2, 0xf0, 0xf2, 0x0,
    0x2f, 0xf, 0x20, 0x2, 0xf0, 0xf2, 0x0, 0x2f,
    0xe, 0x40, 0x5, 0xf0, 0xac, 0x33, 0xdf, 0x1,
    0xbf, 0xd6, 0xf0,

    /* U+016E "Ů" */
    0x0, 0x29, 0x60, 0x0, 0x0, 0x80, 0x90, 0x0,
    0x0, 0x28, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xd6, 0x0, 0x0, 0xe4, 0xd6, 0x0, 0x0, 0xe4,
    0xd6, 0x0, 0x0, 0xe4, 0xd6, 0x0, 0x0, 0xe4,
    0xd6, 0x0, 0x0, 0xe4, 0xc6, 0x0, 0x0, 0xf3,
    0x9a, 0x0, 0x3, 0xf1, 0x2f, 0x83, 0x5d, 0xa0,
    0x4, 0xcf, 0xd8, 0x0,

    /* U+016F "ů" */
    0x0, 0x88, 0x0, 0x0, 0x35, 0x44, 0x0, 0x0,
    0x88, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf2, 0x0,
    0x2f, 0xf, 0x20, 0x2, 0xf0, 0xf2, 0x0, 0x2f,
    0xf, 0x20, 0x2, 0xf0, 0xe4, 0x0, 0x5f, 0xa,
    0xc3, 0x3d, 0xf0, 0x1b, 0xfd, 0x6f, 0x0,

    /* U+0170 "Ű" */
    0x0, 0xa, 0x29, 0x30, 0x0, 0x79, 0x6a, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xd6, 0x0, 0x0, 0xe4,
    0xd6, 0x0, 0x0, 0xe4, 0xd6, 0x0, 0x0, 0xe4,
    0xd6, 0x0, 0x0, 0xe4, 0xd6, 0x0, 0x0, 0xe4,
    0xc6, 0x0, 0x0, 0xf3, 0x9a, 0x0, 0x3, 0xf1,
    0x2f, 0x83, 0x5d, 0xa0, 0x4, 0xcf, 0xd8, 0x0,

    /* U+0171 "ű" */
    0x0, 0xc6, 0xa7, 0x0, 0x38, 0x29, 0x0, 0x0,
    0x0, 0x0, 0xf, 0x20, 0x2, 0xf0, 0xf2, 0x0,
    0x2f, 0xf, 0x20, 0x2, 0xf0, 0xf2, 0x0, 0x2f,
    0xe, 0x40, 0x5, 0xf0, 0xac, 0x33, 0xdf, 0x1,
    0xbf, 0xd6, 0xf0,

    /* U+0172 "Ų" */
    0xd6, 0x0, 0x0, 0xe4, 0xd6, 0x0, 0x0, 0xe4,
    0xd6, 0x0, 0x0, 0xe4, 0xd6, 0x0, 0x0, 0xe4,
    0xd6, 0x0, 0x0, 0xe4, 0xc7, 0x0, 0x0, 0xe4,
    0x9a, 0x0, 0x2, 0xf2, 0x3f, 0x72, 0x4c, 0xb0,
    0x5, 0xdf, 0xfb, 0x10, 0x0, 0x1d, 0x40, 0x0,
    0x0, 0x57, 0x0, 0x0, 0x0, 0x2c, 0xb0, 0x0,

    /* U+0173 "ų" */
    0xf2, 0x0, 0x2f, 0xf, 0x20, 0x2, 0xf0, 0xf2,
    0x0, 0x2f, 0xf, 0x20, 0x2, 0xf0, 0xe4, 0x0,
    0x5f, 0xa, 0xc3, 0x3d, 0xf0, 0x1b, 0xfd, 0x6f,
    0x0, 0x0, 0xb, 0x40, 0x0, 0x2, 0xa0, 0x0,
    0x0, 0xc, 0xb1,

    /* U+0174 "Ŵ" */
    0x0, 0x0, 0x0, 0x74, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1b, 0x5b, 0x60, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7c, 0x0, 0x0,
    0xe7, 0x0, 0x3, 0xe0, 0x2f, 0x10, 0x3, 0xfd,
    0x0, 0x8, 0xa0, 0xd, 0x60, 0x9, 0x9f, 0x20,
    0xd, 0x50, 0x8, 0xb0, 0xe, 0x3b, 0x70, 0x2f,
    0x0, 0x3, 0xf0, 0x3e, 0x6, 0xc0, 0x7b, 0x0,
    0x0, 0xe5, 0x89, 0x1, 0xf1, 0xc6, 0x0, 0x0,
    0x9a, 0xd4, 0x0, 0xc7, 0xf1, 0x0, 0x0, 0x4f,
    0xe0, 0x0, 0x6f, 0xc0, 0x0, 0x0, 0xf, 0xa0,
    0x0, 0x1f, 0x70, 0x0,

    /* U+0175 "ŵ" */
    0x0, 0x0, 0x9f, 0x50, 0x0, 0x0, 0x0, 0x69,
    0x1c, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0x50, 0x4, 0xf1, 0x0, 0x88, 0x6a, 0x0,
    0x9f, 0x60, 0xd, 0x31, 0xf0, 0xe, 0x7b, 0x2,
    0xd0, 0xc, 0x44, 0xc0, 0xf1, 0x88, 0x0, 0x6a,
    0xa6, 0xa, 0x6d, 0x20, 0x1, 0xee, 0x10, 0x4e,
    0xd0, 0x0, 0xb, 0xb0, 0x0, 0xe7, 0x0,

    /* U+0176 "Ŷ" */
    0x0, 0x0, 0x86, 0x0, 0x0, 0x0, 0xa8, 0xb6,
    0x0, 0x0, 0x2, 0x0, 0x30, 0x0, 0xc8, 0x0,
    0x0, 0xa8, 0x3, 0xf1, 0x0, 0x3e, 0x0, 0xa,
    0xa0, 0xc, 0x60, 0x0, 0x1f, 0x36, 0xc0, 0x0,
    0x0, 0x7c, 0xe3, 0x0, 0x0, 0x0, 0xea, 0x0,
    0x0, 0x0, 0xb, 0x70, 0x0, 0x0, 0x0, 0xb7,
    0x0, 0x0, 0x0, 0xb, 0x70, 0x0,

    /* U+0177 "ŷ" */
    0x0, 0xc, 0xe3, 0x0, 0x0, 0x87, 0x2b, 0x10,
    0x0, 0x0, 0x0, 0x0, 0xd, 0x50, 0x0, 0x98,
    0x7, 0xb0, 0x0, 0xf2, 0x1, 0xf1, 0x5, 0xb0,
    0x0, 0xb7, 0xb, 0x50, 0x0, 0x5d, 0x2e, 0x0,
    0x0, 0xe, 0xb9, 0x0, 0x0, 0x8, 0xf3, 0x0,
    0x0, 0x5, 0xc0, 0x0, 0x5, 0x2c, 0x60, 0x0,
    0x1c, 0xf9, 0x0, 0x0,

    /* U+0178 "Ÿ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb4, 0x87,
    0x0, 0x0, 0x2, 0x1, 0x10, 0x0, 0xc8, 0x0,
    0x0, 0xa8, 0x3, 0xf1, 0x0, 0x3e, 0x0, 0xa,
    0xa0, 0xc, 0x60, 0x0, 0x1f, 0x36, 0xc0, 0x0,
    0x0, 0x7c, 0xe3, 0x0, 0x0, 0x0, 0xea, 0x0,
    0x0, 0x0, 0xb, 0x70, 0x0, 0x0, 0x0, 0xb7,
    0x0, 0x0, 0x0, 0xb, 0x70, 0x0,

    /* U+0179 "Ź" */
    0x0, 0x4, 0x90, 0x0, 0x0, 0xa, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff, 0xf5,
    0x2, 0x22, 0x29, 0xd0, 0x0, 0x0, 0x4f, 0x30,
    0x0, 0x1, 0xe6, 0x0, 0x0, 0xc, 0xa0, 0x0,
    0x0, 0x8d, 0x0, 0x0, 0x4, 0xf2, 0x0, 0x0,
    0x1e, 0x72, 0x22, 0x21, 0x7f, 0xff, 0xff, 0xf8,

    /* U+017A "ź" */
    0x0, 0x5d, 0x0, 0x0, 0x64, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0xff, 0xfb, 0x0, 0x2, 0xf3, 0x0,
    0xc, 0x70, 0x0, 0x9b, 0x0, 0x4, 0xe1, 0x0,
    0x1e, 0x50, 0x0, 0x8f, 0xff, 0xfc,

    /* U+017B "Ż" */
    0x0, 0x3, 0x30, 0x0, 0x0, 0x8, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff, 0xf5,
    0x2, 0x22, 0x29, 0xd0, 0x0, 0x0, 0x4f, 0x30,
    0x0, 0x1, 0xe6, 0x0, 0x0, 0xc, 0xa0, 0x0,
    0x0, 0x8d, 0x0, 0x0, 0x4, 0xf2, 0x0, 0x0,
    0x1e, 0x72, 0x22, 0x21, 0x7f, 0xff, 0xff, 0xf8,

    /* U+017C "ż" */
    0x0, 0x6a, 0x0, 0x0, 0x24, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0xff, 0xfb, 0x0, 0x2, 0xf3, 0x0,
    0xc, 0x70, 0x0, 0x9b, 0x0, 0x4, 0xe1, 0x0,
    0x1e, 0x50, 0x0, 0x8f, 0xff, 0xfc,

    /* U+017D "Ž" */
    0x0, 0x61, 0x16, 0x0, 0x0, 0x2d, 0xd3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff, 0xf5,
    0x2, 0x22, 0x29, 0xd0, 0x0, 0x0, 0x4f, 0x30,
    0x0, 0x1, 0xe6, 0x0, 0x0, 0xc, 0xa0, 0x0,
    0x0, 0x8d, 0x0, 0x0, 0x4, 0xf2, 0x0, 0x0,
    0x1e, 0x72, 0x22, 0x21, 0x7f, 0xff, 0xff, 0xf8,

    /* U+017E "ž" */
    0x9, 0x84, 0xc0, 0x0, 0xbd, 0x10, 0x0, 0x0,
    0x0, 0x7f, 0xff, 0xfb, 0x0, 0x2, 0xf3, 0x0,
    0xc, 0x70, 0x0, 0x9b, 0x0, 0x4, 0xe1, 0x0,
    0x1e, 0x50, 0x0, 0x8f, 0xff, 0xfc,

    /* U+017F "ſ" */
    0x1, 0xbf, 0x80, 0x7c, 0x12, 0x9, 0x80, 0xb,
    0xf8, 0x0, 0xa, 0x80, 0x0, 0xa8, 0x0, 0xa,
    0x80, 0x0, 0xa8, 0x0, 0xa, 0x80, 0x0, 0xa8,
    0x0,

    /* U+0384 "΄" */
    0x67, 0xc3,

    /* U+0386 "Ά" */
    0x1, 0xb1, 0x0, 0x0, 0x0, 0x5, 0xa0, 0x6f,
    0x30, 0x0, 0x0, 0x0, 0xdb, 0x90, 0x0, 0x0,
    0x4, 0xd2, 0xf1, 0x0, 0x0, 0xb, 0x80, 0xc7,
    0x0, 0x0, 0x1f, 0x20, 0x6e, 0x0, 0x0, 0x8c,
    0x0, 0xf, 0x50, 0x0, 0xef, 0xee, 0xef, 0xb0,
    0x6, 0xe2, 0x11, 0x14, 0xf2, 0xc, 0x70, 0x0,
    0x0, 0xb9,

    /* U+0388 "Έ" */
    0x27, 0x0, 0x0, 0x0, 0x9, 0x84, 0xff, 0xff,
    0xfa, 0x10, 0x4e, 0x22, 0x22, 0x10, 0x4, 0xe0,
    0x0, 0x0, 0x0, 0x4e, 0x0, 0x0, 0x0, 0x4,
    0xff, 0xff, 0xf2, 0x0, 0x4e, 0x22, 0x22, 0x0,
    0x4, 0xe0, 0x0, 0x0, 0x0, 0x4e, 0x22, 0x22,
    0x10, 0x4, 0xff, 0xff, 0xfd,

    /* U+0389 "Ή" */
    0x57, 0x0, 0x0, 0x0, 0x0, 0xc4, 0x6c, 0x0,
    0x0, 0x6d, 0x0, 0x6c, 0x0, 0x0, 0x6d, 0x0,
    0x6c, 0x0, 0x0, 0x6d, 0x0, 0x6c, 0x0, 0x0,
    0x6d, 0x0, 0x6f, 0xff, 0xff, 0xfd, 0x0, 0x6d,
    0x22, 0x22, 0x7d, 0x0, 0x6c, 0x0, 0x0, 0x6d,
    0x0, 0x6c, 0x0, 0x0, 0x6d, 0x0, 0x6c, 0x0,
    0x0, 0x6d,

    /* U+038A "Ί" */
    0x57, 0x0, 0xc4, 0x5d, 0x0, 0x5d, 0x0, 0x5d,
    0x0, 0x5d, 0x0, 0x5d, 0x0, 0x5d, 0x0, 0x5d,
    0x0, 0x5d, 0x0, 0x5d,

    /* U+038C "Ό" */
    0x24, 0x0, 0x0, 0x0, 0x0, 0xa7, 0x3b, 0xff,
    0xb4, 0x0, 0x45, 0xfb, 0x66, 0xbf, 0x60, 0xe,
    0x80, 0x0, 0x7, 0xf1, 0x4f, 0x0, 0x0, 0x0,
    0xe6, 0x6d, 0x0, 0x0, 0x0, 0xc7, 0x4f, 0x0,
    0x0, 0x0, 0xe6, 0xe, 0x60, 0x0, 0x5, 0xf1,
    0x4, 0xf9, 0x44, 0x8f, 0x60, 0x0, 0x3b, 0xff,
    0xc4, 0x0,

    /* U+038E "Ύ" */
    0x58, 0x0, 0x0, 0x0, 0x0, 0xb, 0x41, 0xf3,
    0x0, 0x1, 0xe3, 0x0, 0x7, 0xc0, 0x0, 0x99,
    0x0, 0x0, 0xe, 0x50, 0x2e, 0x10, 0x0, 0x0,
    0x5e, 0xb, 0x70, 0x0, 0x0, 0x0, 0xcc, 0xd0,
    0x0, 0x0, 0x0, 0x3, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0xf, 0x20, 0x0, 0x0, 0x0, 0x0, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0xf, 0x20, 0x0,

    /* U+038F "Ώ" */
    0x25, 0x0, 0x0, 0x0, 0x0, 0x9, 0x81, 0x9e,
    0xfd, 0x70, 0x0, 0x42, 0xee, 0x76, 0x8f, 0xb0,
    0x0, 0x9d, 0x0, 0x0, 0x2f, 0x60, 0xf, 0x50,
    0x0, 0x0, 0x9b, 0x0, 0xf2, 0x0, 0x0, 0x6,
    0xd0, 0xe, 0x40, 0x0, 0x0, 0x8b, 0x0, 0x9b,
    0x0, 0x0, 0xe, 0x50, 0x23, 0xe9, 0x0, 0x1c,
    0xc2, 0x1e, 0xff, 0xf4, 0x7, 0xff, 0xfa,

    /* U+0390 "ΐ" */
    0x4, 0xd0, 0x6, 0x40, 0xd1, 0x95, 0x30, 0x21,
    0xd, 0x50, 0xd, 0x50, 0xd, 0x50, 0xd, 0x50,
    0xd, 0x50, 0xd, 0x50, 0xd, 0x50,

    /* U+0391 "Α" */
    0x0, 0x0, 0x6f, 0x30, 0x0, 0x0, 0x0, 0xdd,
    0x90, 0x0, 0x0, 0x4, 0xe3, 0xf1, 0x0, 0x0,
    0xb, 0x80, 0xc7, 0x0, 0x0, 0x1f, 0x20, 0x6e,
    0x0, 0x0, 0x8c, 0x0, 0x1f, 0x50, 0x0, 0xef,
    0xee, 0xef, 0xb0, 0x6, 0xe2, 0x11, 0x14, 0xf2,
    0xc, 0x70, 0x0, 0x0, 0xb9,

    /* U+0392 "Β" */
    0xbf, 0xff, 0xfb, 0x20, 0xb7, 0x11, 0x2a, 0xd0,
    0xb7, 0x0, 0x3, 0xf0, 0xb7, 0x0, 0x9, 0xc0,
    0xbf, 0xff, 0xff, 0x40, 0xb8, 0x22, 0x26, 0xe2,
    0xb7, 0x0, 0x0, 0xc7, 0xb7, 0x11, 0x15, 0xf4,
    0xbf, 0xff, 0xfd, 0x60,

    /* U+0393 "Γ" */
    0xbf, 0xff, 0xfc, 0xb8, 0x22, 0x21, 0xb7, 0x0,
    0x0, 0xb7, 0x0, 0x0, 0xb7, 0x0, 0x0, 0xb7,
    0x0, 0x0, 0xb7, 0x0, 0x0, 0xb7, 0x0, 0x0,
    0xb7, 0x0, 0x0,

    /* U+0394 "Δ" */
    0x0, 0x0, 0x6f, 0x30, 0x0, 0x0, 0x0, 0xdc,
    0x90, 0x0, 0x0, 0x4, 0xd2, 0xf1, 0x0, 0x0,
    0xb, 0x70, 0xb7, 0x0, 0x0, 0x1f, 0x10, 0x4e,
    0x0, 0x0, 0x8a, 0x0, 0xe, 0x50, 0x0, 0xe3,
    0x0, 0x7, 0xb0, 0x6, 0xd2, 0x22, 0x23, 0xf2,
    0xc, 0xff, 0xff, 0xff, 0xf9,

    /* U+0395 "Ε" */
    0xbf, 0xff, 0xff, 0x3b, 0x82, 0x22, 0x20, 0xb7,
    0x0, 0x0, 0xb, 0x70, 0x0, 0x0, 0xbf, 0xff,
    0xfa, 0xb, 0x82, 0x22, 0x10, 0xb7, 0x0, 0x0,
    0xb, 0x82, 0x22, 0x20, 0xbf, 0xff, 0xff, 0x50,

    /* U+0396 "Ζ" */
    0x6f, 0xff, 0xff, 0xf5, 0x2, 0x22, 0x29, 0xd0,
    0x0, 0x0, 0x3f, 0x30, 0x0, 0x1, 0xe6, 0x0,
    0x0, 0xb, 0xa0, 0x0, 0x0, 0x8d, 0x0, 0x0,
    0x4, 0xf2, 0x0, 0x0, 0x1e, 0x82, 0x22, 0x21,
    0x7f, 0xff, 0xff, 0xf8,

    /* U+0397 "Η" */
    0xb7, 0x0, 0x0, 0xb7, 0xb7, 0x0, 0x0, 0xb7,
    0xb7, 0x0, 0x0, 0xb7, 0xb7, 0x0, 0x0, 0xb7,
    0xbf, 0xff, 0xff, 0xf7, 0xb8, 0x22, 0x22, 0xc7,
    0xb7, 0x0, 0x0, 0xb7, 0xb7, 0x0, 0x0, 0xb7,
    0xb7, 0x0, 0x0, 0xb7,

    /* U+0398 "Θ" */
    0x0, 0x3b, 0xff, 0xb4, 0x0, 0x4, 0xf9, 0x44,
    0x8f, 0x60, 0xe, 0x70, 0x0, 0x6, 0xf1, 0x4f,
    0x0, 0x0, 0x0, 0xe6, 0x6d, 0x5f, 0xff, 0xf7,
    0xc7, 0x4f, 0x13, 0x33, 0x31, 0xe6, 0xe, 0x70,
    0x0, 0x6, 0xf1, 0x4, 0xf9, 0x44, 0x8f, 0x60,
    0x0, 0x3b, 0xff, 0xc4, 0x0,

    /* U+0399 "Ι" */
    0xb7, 0xb7, 0xb7, 0xb7, 0xb7, 0xb7, 0xb7, 0xb7,
    0xb7,

    /* U+039A "Κ" */
    0xb7, 0x0, 0x6, 0xd1, 0xb7, 0x0, 0x5e, 0x20,
    0xb7, 0x4, 0xe3, 0x0, 0xb7, 0x3e, 0x40, 0x0,
    0xb9, 0xef, 0x20, 0x0, 0xbf, 0x89, 0xd0, 0x0,
    0xba, 0x0, 0xca, 0x0, 0xb7, 0x0, 0x1e, 0x70,
    0xb7, 0x0, 0x3, 0xf3,

    /* U+039B "Λ" */
    0x0, 0x0, 0x6f, 0x30, 0x0, 0x0, 0x0, 0xdc,
    0x90, 0x0, 0x0, 0x4, 0xe2, 0xf1, 0x0, 0x0,
    0xb, 0x70, 0xb7, 0x0, 0x0, 0x1f, 0x10, 0x5e,
    0x0, 0x0, 0x8a, 0x0, 0xe, 0x50, 0x0, 0xe3,
    0x0, 0x7, 0xb0, 0x6, 0xd0, 0x0, 0x1, 0xf2,
    0xc, 0x60, 0x0, 0x0, 0xa9,

    /* U+039C "Μ" */
    0xb8, 0x0, 0x0, 0x1, 0xf2, 0xbf, 0x10, 0x0,
    0x9, 0xf3, 0xbe, 0xa0, 0x0, 0x2e, 0xf3, 0xb7,
    0xe3, 0x0, 0xb7, 0xf3, 0xb6, 0x7b, 0x4, 0xd0,
    0xf3, 0xb6, 0xd, 0x4c, 0x50, 0xf3, 0xb6, 0x5,
    0xfc, 0x0, 0xf3, 0xb6, 0x0, 0xb3, 0x0, 0xf3,
    0xb6, 0x0, 0x0, 0x0, 0xf3,

    /* U+039D "Ν" */
    0xb9, 0x0, 0x0, 0xb7, 0xbf, 0x50, 0x0, 0xb7,
    0xbc, 0xf2, 0x0, 0xb7, 0xb7, 0xad, 0x0, 0xb7,
    0xb7, 0xd, 0x90, 0xb7, 0xb7, 0x2, 0xf5, 0xb7,
    0xb7, 0x0, 0x6f, 0xd7, 0xb7, 0x0, 0xa, 0xf7,
    0xb7, 0x0, 0x0, 0xd7,

    /* U+039E "Ξ" */
    0x9f, 0xff, 0xff, 0xf5, 0x12, 0x22, 0x22, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xff, 0xff, 0x70, 0x1, 0x22, 0x22, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x12, 0x22, 0x22, 0x21,
    0xbf, 0xff, 0xff, 0xf8,

    /* U+039F "Ο" */
    0x0, 0x3b, 0xff, 0xb4, 0x0, 0x4, 0xf9, 0x44,
    0x8f, 0x60, 0xe, 0x70, 0x0, 0x6, 0xf1, 0x4f,
    0x0, 0x0, 0x0, 0xe6, 0x6d, 0x0, 0x0, 0x0,
    0xc7, 0x4f, 0x0, 0x0, 0x0, 0xe6, 0xe, 0x70,
    0x0, 0x6, 0xf1, 0x4, 0xf9, 0x44, 0x8f, 0x60,
    0x0, 0x3b, 0xff, 0xc4, 0x0,

    /* U+03A0 "Π" */
    0xbf, 0xff, 0xff, 0xf8, 0xb9, 0x22, 0x22, 0xa8,
    0xb8, 0x0, 0x0, 0xa8, 0xb8, 0x0, 0x0, 0xa8,
    0xb8, 0x0, 0x0, 0xa8, 0xb8, 0x0, 0x0, 0xa8,
    0xb8, 0x0, 0x0, 0xa8, 0xb8, 0x0, 0x0, 0xa8,
    0xb8, 0x0, 0x0, 0xa8,

    /* U+03A1 "Ρ" */
    0xbf, 0xff, 0xe8, 0x0, 0xb8, 0x22, 0x4d, 0x90,
    0xb7, 0x0, 0x4, 0xf0, 0xb7, 0x0, 0x3, 0xf0,
    0xb7, 0x0, 0x2c, 0xb0, 0xbf, 0xff, 0xfb, 0x10,
    0xb8, 0x22, 0x0, 0x0, 0xb7, 0x0, 0x0, 0x0,
    0xb7, 0x0, 0x0, 0x0,

    /* U+03A3 "Σ" */
    0x7f, 0xff, 0xff, 0xf2, 0xeb, 0x44, 0x43, 0x3,
    0xf6, 0x0, 0x0, 0x4, 0xf5, 0x0, 0x0, 0x9,
    0xe0, 0x0, 0x5, 0xf5, 0x0, 0x3, 0xf6, 0x0,
    0x2, 0xeb, 0x44, 0x43, 0x7f, 0xff, 0xff, 0xf0,

    /* U+03A4 "Τ" */
    0xff, 0xff, 0xff, 0xf2, 0x23, 0xf3, 0x22, 0x0,
    0x1f, 0x10, 0x0, 0x1, 0xf1, 0x0, 0x0, 0x1f,
    0x10, 0x0, 0x1, 0xf1, 0x0, 0x0, 0x1f, 0x10,
    0x0, 0x1, 0xf1, 0x0, 0x0, 0x1f, 0x10, 0x0,

    /* U+03A5 "Υ" */
    0xc, 0x80, 0x0, 0xa, 0x80, 0x3f, 0x10, 0x3,
    0xe0, 0x0, 0xaa, 0x0, 0xc6, 0x0, 0x1, 0xf3,
    0x6c, 0x0, 0x0, 0x7, 0xce, 0x30, 0x0, 0x0,
    0xe, 0xa0, 0x0, 0x0, 0x0, 0xb7, 0x0, 0x0,
    0x0, 0xb, 0x70, 0x0, 0x0, 0x0, 0xb7, 0x0,
    0x0,

    /* U+03A6 "Φ" */
    0x0, 0x0, 0x59, 0x0, 0x0, 0x0, 0x18, 0xcf,
    0xfd, 0x92, 0x0, 0x1d, 0xa4, 0x7b, 0x38, 0xf3,
    0x9, 0xb0, 0x6, 0xb0, 0x7, 0xd0, 0xd5, 0x0,
    0x6b, 0x0, 0x1f, 0x1d, 0x50, 0x6, 0xb0, 0x1,
    0xf1, 0xa9, 0x0, 0x6b, 0x0, 0x5e, 0x2, 0xf8,
    0x16, 0xb0, 0x5e, 0x50, 0x2, 0xbf, 0xff, 0xfd,
    0x50, 0x0, 0x0, 0x7, 0xb0, 0x0, 0x0,

    /* U+03A7 "Χ" */
    0x5f, 0x10, 0x0, 0xe5, 0xa, 0xb0, 0x9, 0xa0,
    0x1, 0xe6, 0x4e, 0x10, 0x0, 0x4f, 0xe4, 0x0,
    0x0, 0xd, 0xe0, 0x0, 0x0, 0x7d, 0xd8, 0x0,
    0x2, 0xf3, 0x2f, 0x30, 0xc, 0x80, 0x7, 0xd0,
    0x8d, 0x0, 0x0, 0xc9,

    /* U+03A8 "Ψ" */
    0xd4, 0x0, 0x7a, 0x0, 0xf, 0x1e, 0x40, 0x7,
    0xa0, 0x0, 0xf1, 0xd4, 0x0, 0x7a, 0x0, 0x1f,
    0x1c, 0x60, 0x7, 0xa0, 0x3, 0xf0, 0x7c, 0x0,
    0x7a, 0x0, 0x9a, 0x0, 0xd9, 0x17, 0xa0, 0x7f,
    0x20, 0x1, 0xaf, 0xff, 0xfc, 0x30, 0x0, 0x0,
    0x7, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x7a, 0x0,
    0x0, 0x0, 0x0, 0x5, 0x90, 0x0, 0x0,

    /* U+03A9 "Ω" */
    0x0, 0x19, 0xef, 0xd7, 0x0, 0x0, 0x1e, 0xc5,
    0x36, 0xeb, 0x0, 0x9, 0xc0, 0x0, 0x1, 0xe6,
    0x0, 0xf5, 0x0, 0x0, 0x8, 0xb0, 0xf, 0x20,
    0x0, 0x0, 0x6d, 0x0, 0xe4, 0x0, 0x0, 0x8,
    0xb0, 0x9, 0xb0, 0x0, 0x1, 0xe5, 0x2, 0x3e,
    0x90, 0x1, 0xcc, 0x21, 0xef, 0xff, 0x40, 0x7f,
    0xff, 0xa0,

    /* U+03AA "Ϊ" */
    0x0, 0x0, 0x0, 0xe1, 0xb4, 0x2, 0x1, 0x0,
    0xd, 0x50, 0x0, 0xd5, 0x0, 0xd, 0x50, 0x0,
    0xd5, 0x0, 0xd, 0x50, 0x0, 0xd5, 0x0, 0xd,
    0x50, 0x0, 0xd5, 0x0, 0xd, 0x50,

    /* U+03AB "Ϋ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb4, 0x78,
    0x0, 0x0, 0x1, 0x1, 0x10, 0x0, 0xc8, 0x0,
    0x0, 0xa8, 0x3, 0xf1, 0x0, 0x3e, 0x0, 0xa,
    0xa0, 0xc, 0x60, 0x0, 0x1f, 0x36, 0xc0, 0x0,
    0x0, 0x7c, 0xe3, 0x0, 0x0, 0x0, 0xea, 0x0,
    0x0, 0x0, 0xb, 0x70, 0x0, 0x0, 0x0, 0xb7,
    0x0, 0x0, 0x0, 0xb, 0x70, 0x0,

    /* U+03AC "ά" */
    0x0, 0x0, 0x67, 0x0, 0x0, 0x0, 0xc3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xbf, 0xe6, 0xf2,
    0xd, 0xb2, 0x3d, 0xf2, 0x4e, 0x0, 0x2, 0xf2,
    0x6c, 0x0, 0x0, 0xf2, 0x4e, 0x0, 0x2, 0xf2,
    0xd, 0xb2, 0x3d, 0xf2, 0x1, 0xbf, 0xe5, 0xe2,

    /* U+03AD "έ" */
    0x0, 0x5, 0x80, 0x0, 0x0, 0xb5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4d, 0xfe, 0x90, 0x1f, 0x50,
    0x14, 0x1, 0xf2, 0x0, 0x0, 0xa, 0xff, 0xf1,
    0x5, 0xd1, 0x0, 0x0, 0x5e, 0x31, 0x28, 0x10,
    0x7e, 0xfd, 0x91,

    /* U+03AE "ή" */
    0x0, 0xe, 0x40, 0x0, 0x1, 0x90, 0x0, 0xe6,
    0xdf, 0xc2, 0xe, 0xe4, 0x2a, 0xd0, 0xe6, 0x0,
    0x2f, 0x1e, 0x40, 0x0, 0xf2, 0xe4, 0x0, 0xf,
    0x2e, 0x40, 0x0, 0xf2, 0xe4, 0x0, 0xf, 0x20,
    0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20, 0x0,
    0x0, 0xf2,

    /* U+03AF "ί" */
    0x49, 0x9, 0x60, 0x0, 0xe, 0x40, 0xe4, 0xe,
    0x40, 0xe4, 0xe, 0x40, 0xe4, 0xe, 0x40,

    /* U+03B0 "ΰ" */
    0x0, 0xe, 0x40, 0x0, 0x1, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x68, 0x3b, 0x0, 0x1, 0x20,
    0x30, 0xf, 0x30, 0x2, 0xf0, 0xf3, 0x0, 0x2f,
    0xf, 0x30, 0x2, 0xf0, 0xf3, 0x0, 0x2f, 0xe,
    0x50, 0x3, 0xe0, 0x9d, 0x33, 0xc9, 0x0, 0x9f,
    0xfa, 0x0,

    /* U+03B1 "α" */
    0x1, 0xbf, 0xe6, 0xf3, 0xd, 0xb2, 0x3d, 0xf3,
    0x4e, 0x0, 0x2, 0xf3, 0x6c, 0x0, 0x0, 0xf3,
    0x4e, 0x0, 0x2, 0xf3, 0xd, 0xb2, 0x3d, 0xf3,
    0x1, 0xbf, 0xe6, 0xe3,

    /* U+03B2 "β" */
    0x0, 0x5d, 0xfc, 0x20, 0x5, 0xf6, 0x2a, 0xb0,
    0xd, 0x60, 0xb, 0x90, 0xf, 0x20, 0x9e, 0x10,
    0x1f, 0x17, 0xfd, 0xe2, 0x1f, 0x8d, 0x20, 0xaa,
    0x1f, 0xd1, 0x0, 0x8a, 0x1f, 0xb4, 0x26, 0xf7,
    0x1f, 0xbe, 0xfe, 0x90, 0x1f, 0x10, 0x0, 0x0,
    0x1f, 0x10, 0x0, 0x0, 0x1f, 0x10, 0x0, 0x0,

    /* U+03B3 "γ" */
    0x1f, 0x20, 0x0, 0xe4, 0xa, 0x90, 0x4, 0xe0,
    0x3, 0xe0, 0xa, 0x70, 0x0, 0xd5, 0x1f, 0x10,
    0x0, 0x6b, 0x7a, 0x0, 0x0, 0xf, 0xe4, 0x0,
    0x0, 0x9, 0xd0, 0x0, 0x0, 0x7, 0xb0, 0x0,
    0x0, 0x7, 0xb0, 0x0, 0x0, 0x7, 0xb0, 0x0,

    /* U+03B4 "δ" */
    0x0, 0x8d, 0xfc, 0x30, 0x5, 0xe3, 0x15, 0x10,
    0x3, 0xe8, 0x41, 0x0, 0x3, 0xeb, 0xae, 0x50,
    0xe, 0x50, 0x4, 0xf1, 0x3e, 0x0, 0x0, 0xd4,
    0x2f, 0x10, 0x0, 0xf3, 0xc, 0xc3, 0x2b, 0xd0,
    0x1, 0xaf, 0xfa, 0x10,

    /* U+03B5 "ε" */
    0x4, 0xdf, 0xe9, 0x1, 0xf5, 0x1, 0x40, 0x1f,
    0x20, 0x0, 0x0, 0xaf, 0xff, 0x10, 0x5d, 0x10,
    0x0, 0x5, 0xe3, 0x12, 0x81, 0x7, 0xef, 0xd9,
    0x10,

    /* U+03B6 "ζ" */
    0xd, 0xff, 0xfe, 0x1, 0x12, 0xe9, 0x0, 0xa,
    0xd0, 0x0, 0x6f, 0x20, 0x1, 0xe6, 0x0, 0x9,
    0xc0, 0x0, 0xf, 0x50, 0x0, 0xf, 0xa4, 0x20,
    0x6, 0xef, 0xf6, 0x0, 0x0, 0xab, 0x0, 0x0,
    0x8b, 0x0, 0x0, 0xc7,

    /* U+03B7 "η" */
    0xe6, 0xdf, 0xc2, 0xe, 0xe4, 0x2a, 0xd0, 0xe6,
    0x0, 0x2f, 0x1e, 0x40, 0x0, 0xf2, 0xe4, 0x0,
    0xf, 0x2e, 0x40, 0x0, 0xf2, 0xe4, 0x0, 0xf,
    0x20, 0x0, 0x0, 0xf2, 0x0, 0x0, 0xf, 0x20,
    0x0, 0x0, 0xf2,

    /* U+03B8 "θ" */
    0x0, 0x7e, 0xfd, 0x50, 0x0, 0x8e, 0x53, 0x7f,
    0x50, 0x1f, 0x40, 0x0, 0x8d, 0x4, 0xe0, 0x0,
    0x2, 0xf1, 0x6f, 0xff, 0xff, 0xff, 0x24, 0xe3,
    0x33, 0x34, 0xf1, 0x1f, 0x30, 0x0, 0x7d, 0x0,
    0x8e, 0x53, 0x7f, 0x50, 0x0, 0x7e, 0xfd, 0x50,
    0x0,

    /* U+03B9 "ι" */
    0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4,

    /* U+03BA "κ" */
    0xe4, 0x0, 0xba, 0xe, 0x40, 0xbb, 0x0, 0xe4,
    0xbc, 0x0, 0xe, 0xdf, 0xc0, 0x0, 0xec, 0x1d,
    0x80, 0xe, 0x40, 0x3f, 0x40, 0xe4, 0x0, 0x6e,
    0x10,

    /* U+03BB "λ" */
    0x1c, 0xfa, 0x0, 0x0, 0x4, 0x2c, 0x70, 0x0,
    0x0, 0x5, 0xe0, 0x0, 0x0, 0xa, 0xf5, 0x0,
    0x0, 0x1f, 0x6c, 0x0, 0x0, 0x8a, 0xe, 0x30,
    0x0, 0xe3, 0x7, 0xa0, 0x5, 0xd0, 0x1, 0xf1,
    0xc, 0x60, 0x0, 0x98,

    /* U+03BC "μ" */
    0xf3, 0x0, 0x2f, 0xf, 0x30, 0x2, 0xf0, 0xf3,
    0x0, 0x2f, 0xf, 0x30, 0x2, 0xf0, 0xf4, 0x0,
    0x4f, 0xf, 0xb2, 0x2d, 0xf0, 0xfa, 0xfe, 0x7f,
    0xf, 0x30, 0x0, 0x0, 0xf3, 0x0, 0x0, 0xf,
    0x30, 0x0, 0x0,

    /* U+03BD "ν" */
    0x7c, 0x0, 0x3, 0xe0, 0x1f, 0x20, 0xa, 0x80,
    0xa, 0x80, 0xf, 0x10, 0x4, 0xe0, 0x6b, 0x0,
    0x0, 0xd5, 0xd4, 0x0, 0x0, 0x7d, 0xe0, 0x0,
    0x0, 0x1f, 0x80, 0x0,

    /* U+03BE "ξ" */
    0x5f, 0xff, 0xf3, 0x1b, 0xc5, 0x40, 0x2f, 0x20,
    0x0, 0x2f, 0x71, 0x0, 0x8, 0xff, 0xb0, 0x5f,
    0x74, 0x30, 0x99, 0x0, 0x0, 0x7e, 0x53, 0x0,
    0xa, 0xff, 0xd0, 0x0, 0x3, 0xf1, 0x0, 0x1,
    0xf1, 0x0, 0x5, 0xd0,

    /* U+03BF "ο" */
    0x2, 0xbf, 0xe8, 0x0, 0xd, 0xa2, 0x3e, 0x80,
    0x5d, 0x0, 0x3, 0xf0, 0x7b, 0x0, 0x1, 0xf1,
    0x5d, 0x0, 0x4, 0xf0, 0xd, 0xa2, 0x4e, 0x80,
    0x2, 0xbf, 0xe8, 0x0,

    /* U+03C0 "π" */
    0xf, 0xff, 0xff, 0xf0, 0xf, 0x20, 0x2, 0xf0,
    0xf, 0x20, 0x2, 0xf0, 0xf, 0x20, 0x2, 0xf0,
    0xf, 0x20, 0x2, 0xf0, 0xf, 0x20, 0x2, 0xf0,
    0xf, 0x20, 0x2, 0xf0,

    /* U+03C1 "ρ" */
    0x1, 0xaf, 0xe8, 0x0, 0xc, 0xa2, 0x3c, 0x90,
    0x3e, 0x0, 0x2, 0xf1, 0x6c, 0x0, 0x0, 0xf2,
    0x6e, 0x0, 0x2, 0xf1, 0x6f, 0xb2, 0x3d, 0x90,
    0x6c, 0xaf, 0xe8, 0x0, 0x6b, 0x0, 0x0, 0x0,
    0x6b, 0x0, 0x0, 0x0, 0x6b, 0x0, 0x0, 0x0,

    /* U+03C2 "ς" */
    0x9, 0xef, 0xc2, 0x6d, 0x22, 0x61, 0x6d, 0x20,
    0x0, 0xa, 0xfe, 0x91, 0x0, 0x2, 0xc8, 0x56,
    0x22, 0xb8, 0x4c, 0xee, 0xa1,

    /* U+03C3 "σ" */
    0x2, 0xbe, 0xff, 0xe8, 0xd, 0x80, 0x1c, 0x80,
    0x5d, 0x0, 0x3, 0xf0, 0x7b, 0x0, 0x1, 0xf1,
    0x5e, 0x0, 0x4, 0xf0, 0xd, 0xa2, 0x4e, 0x80,
    0x2, 0xbf, 0xe8, 0x0,

    /* U+03C4 "τ" */
    0xcf, 0xff, 0xff, 0x40, 0x5, 0xc0, 0x0, 0x0,
    0x5c, 0x0, 0x0, 0x5, 0xc0, 0x0, 0x0, 0x5c,
    0x0, 0x0, 0x5, 0xc0, 0x0, 0x0, 0x5c, 0x0,
    0x0,

    /* U+03C5 "υ" */
    0xf3, 0x0, 0x2f, 0xf, 0x30, 0x2, 0xf0, 0xf3,
    0x0, 0x2f, 0xf, 0x30, 0x2, 0xf0, 0xd5, 0x0,
    0x3e, 0x9, 0xd3, 0x3c, 0x90, 0x9, 0xff, 0xa0,
    0x0,

    /* U+03C6 "φ" */
    0x0, 0x0, 0xc4, 0x0, 0x0, 0x1, 0xae, 0xff,
    0xd5, 0x0, 0xc, 0xb3, 0xc6, 0x6f, 0x50, 0x5e,
    0x0, 0xc5, 0x6, 0xd0, 0x7b, 0x0, 0xc5, 0x3,
    0xf0, 0x5e, 0x0, 0xc5, 0x6, 0xd0, 0xd, 0xb2,
    0xd6, 0x5f, 0x50, 0x1, 0xae, 0xff, 0xd5, 0x0,
    0x0, 0x0, 0xd5, 0x0, 0x0, 0x0, 0x0, 0xd5,
    0x0, 0x0, 0x0, 0x0, 0xd5, 0x0, 0x0,

    /* U+03C7 "χ" */
    0x7c, 0x0, 0x2f, 0x10, 0xe4, 0x9, 0x90, 0x7,
    0xb1, 0xf1, 0x0, 0xe, 0xa9, 0x0, 0x0, 0x7f,
    0x10, 0x0, 0x8, 0xf2, 0x0, 0x1, 0xf9, 0xa0,
    0x0, 0x99, 0x1f, 0x20, 0x1f, 0x20, 0x9a, 0x9,
    0xa0, 0x1, 0xf3,

    /* U+03C8 "ψ" */
    0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0xf, 0x20,
    0x0, 0x7c, 0x0, 0xf2, 0x9, 0xa8, 0xb0, 0xf,
    0x20, 0x8b, 0x8b, 0x0, 0xf2, 0x7, 0xb6, 0xc0,
    0xf, 0x20, 0x99, 0x3f, 0x10, 0xf2, 0xd, 0x60,
    0xcc, 0x3f, 0x4b, 0xe0, 0x1, 0xcf, 0xff, 0xd3,
    0x0, 0x0, 0x2f, 0x50, 0x0, 0x0, 0x0, 0xf2,
    0x0, 0x0, 0x0, 0xf, 0x20, 0x0,

    /* U+03C9 "ω" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0x50, 0x0,
    0x2, 0xa0, 0x1f, 0x40, 0x0, 0x1, 0xe5, 0x5c,
    0x0, 0x7b, 0x0, 0x99, 0x7a, 0x0, 0x7b, 0x0,
    0x7b, 0x6c, 0x0, 0x9c, 0x0, 0x89, 0x1f, 0x96,
    0xfe, 0x78, 0xf5, 0x4, 0xee, 0x64, 0xee, 0x70,

    /* U+03CA "ϊ" */
    0xd1, 0xa5, 0x30, 0x21, 0xe, 0x40, 0xe, 0x40,
    0xe, 0x40, 0xe, 0x40, 0xe, 0x40, 0xe, 0x40,
    0xe, 0x40,

    /* U+03CB "ϋ" */
    0x8, 0x64, 0xa0, 0x0, 0x11, 0x2, 0x0, 0xf3,
    0x0, 0x2f, 0xf, 0x30, 0x2, 0xf0, 0xf3, 0x0,
    0x2f, 0xf, 0x30, 0x2, 0xf0, 0xe5, 0x0, 0x3e,
    0x9, 0xd3, 0x3c, 0x90, 0x9, 0xff, 0xa0, 0x0,

    /* U+03CC "ό" */
    0x0, 0x3, 0xa0, 0x0, 0x0, 0x8, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xbf, 0xe8, 0x0,
    0xd, 0xa2, 0x3e, 0x80, 0x5d, 0x0, 0x3, 0xf0,
    0x7b, 0x0, 0x1, 0xf1, 0x5d, 0x0, 0x4, 0xf0,
    0xd, 0xa2, 0x4e, 0x80, 0x2, 0xbf, 0xe8, 0x0,

    /* U+03CD "ύ" */
    0x0, 0xb, 0x20, 0x0, 0x4c, 0x0, 0x0, 0x0,
    0x0, 0xf3, 0x0, 0x2f, 0xf3, 0x0, 0x2f, 0xf3,
    0x0, 0x2f, 0xf3, 0x0, 0x2f, 0xe4, 0x0, 0x4e,
    0x9d, 0x33, 0xc9, 0x9, 0xff, 0x90,

    /* U+03CE "ώ" */
    0x0, 0x0, 0xa, 0x30, 0x0, 0x0, 0x0, 0x3d,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0x30, 0x0, 0x1, 0x70, 0x1f, 0x50, 0x0, 0x2,
    0xf4, 0x5b, 0x0, 0x69, 0x0, 0x99, 0x79, 0x0,
    0x7b, 0x0, 0x7b, 0x6c, 0x0, 0x9c, 0x0, 0x99,
    0x1f, 0xa8, 0xff, 0x89, 0xf5, 0x5, 0xef, 0x75,
    0xee, 0x60,

    /* U+0400 "Ѐ" */
    0x4, 0x60, 0x0, 0x0, 0x8, 0x90, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xf3, 0xb9, 0x22,
    0x22, 0xb, 0x80, 0x0, 0x0, 0xb8, 0x0, 0x0,
    0xb, 0xff, 0xff, 0xa0, 0xb9, 0x22, 0x21, 0xb,
    0x80, 0x0, 0x0, 0xb9, 0x22, 0x22, 0xb, 0xff,
    0xff, 0xf6,

    /* U+0401 "Ё" */
    0x0, 0x0, 0x0, 0x0, 0x5a, 0x2e, 0x0, 0x0,
    0x10, 0x20, 0xb, 0xff, 0xff, 0xf3, 0xb9, 0x22,
    0x22, 0xb, 0x80, 0x0, 0x0, 0xb8, 0x0, 0x0,
    0xb, 0xff, 0xff, 0xa0, 0xb9, 0x22, 0x21, 0xb,
    0x80, 0x0, 0x0, 0xb9, 0x22, 0x22, 0xb, 0xff,
    0xff, 0xf6,

    /* U+0402 "Ђ" */
    0xdf, 0xff, 0xff, 0xf6, 0x0, 0x12, 0x2f, 0x52,
    0x20, 0x0, 0x0, 0xf, 0x30, 0x0, 0x0, 0x0,
    0xf, 0xbd, 0xfd, 0x50, 0x0, 0xf, 0xa4, 0x27,
    0xf3, 0x0, 0xf, 0x30, 0x0, 0xb7, 0x0, 0xf,
    0x30, 0x0, 0xb8, 0x0, 0xf, 0x30, 0x25, 0xf3,
    0x0, 0xf, 0x33, 0xfe, 0x60,

    /* U+0403 "Ѓ" */
    0x0, 0x58, 0x0, 0x0, 0xb5, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0xff, 0xfc, 0xb8, 0x22, 0x21, 0xb7,
    0x0, 0x0, 0xb7, 0x0, 0x0, 0xb7, 0x0, 0x0,
    0xb7, 0x0, 0x0, 0xb7, 0x0, 0x0, 0xb7, 0x0,
    0x0, 0xb7, 0x0, 0x0,

    /* U+0404 "Є" */
    0x0, 0x4c, 0xfe, 0xa2, 0x0, 0x5f, 0x94, 0x49,
    0xd0, 0xe, 0x70, 0x0, 0x0, 0x3, 0xf0, 0x0,
    0x0, 0x0, 0x5f, 0xff, 0xfe, 0x0, 0x3, 0xf2,
    0x22, 0x10, 0x0, 0xe, 0x70, 0x0, 0x0, 0x0,
    0x5f, 0x94, 0x49, 0xd0, 0x0, 0x4c, 0xff, 0xb2,
    0x0,

    /* U+0405 "Ѕ" */
    0x3, 0xcf, 0xeb, 0x30, 0xe, 0x92, 0x27, 0x50,
    0x3f, 0x0, 0x0, 0x0, 0xe, 0x92, 0x0, 0x0,
    0x2, 0xaf, 0xd8, 0x0, 0x0, 0x0, 0x4c, 0xc0,
    0x0, 0x0, 0x3, 0xf0, 0x3c, 0x52, 0x2a, 0xc0,
    0x7, 0xdf, 0xea, 0x10,

    /* U+0406 "І" */
    0xb8, 0xb8, 0xb8, 0xb8, 0xb8, 0xb8, 0xb8, 0xb8,
    0xb8,

    /* U+0407 "Ї" */
    0x0, 0x0, 0xc3, 0x87, 0x20, 0x11, 0xb, 0x70,
    0xb, 0x70, 0xb, 0x70, 0xb, 0x70, 0xb, 0x70,
    0xb, 0x70, 0xb, 0x70, 0xb, 0x70, 0xb, 0x70,

    /* U+0408 "Ј" */
    0xf, 0xff, 0xf4, 0x2, 0x22, 0xe4, 0x0, 0x0,
    0xe4, 0x0, 0x0, 0xe4, 0x0, 0x0, 0xe4, 0x0,
    0x0, 0xe4, 0x0, 0x0, 0xf3, 0x99, 0x37, 0xf0,
    0x2c, 0xfd, 0x40,

    /* U+0409 "Љ" */
    0x0, 0xcf, 0xff, 0xff, 0x50, 0x0, 0x0, 0x0,
    0xc5, 0x22, 0x2f, 0x50, 0x0, 0x0, 0x0, 0xd3,
    0x0, 0xf, 0x50, 0x0, 0x0, 0x0, 0xd3, 0x0,
    0xf, 0xfe, 0xec, 0x70, 0x0, 0xe2, 0x0, 0xf,
    0x61, 0x25, 0xe6, 0x0, 0xf0, 0x0, 0xf, 0x50,
    0x0, 0x8a, 0x3, 0xe0, 0x0, 0xf, 0x50, 0x0,
    0x9a, 0x3b, 0xa0, 0x0, 0xf, 0x73, 0x37, 0xf5,
    0xcd, 0x20, 0x0, 0xf, 0xff, 0xfd, 0x60,

    /* U+040A "Њ" */
    0xb8, 0x0, 0x0, 0xd5, 0x0, 0x0, 0xb, 0x80,
    0x0, 0xd, 0x50, 0x0, 0x0, 0xb8, 0x0, 0x0,
    0xd5, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0x70, 0xb9, 0x22, 0x22, 0xd7, 0x22, 0x6f,
    0x6b, 0x80, 0x0, 0xd, 0x50, 0x0, 0x9a, 0xb8,
    0x0, 0x0, 0xd5, 0x0, 0x9, 0xab, 0x80, 0x0,
    0xd, 0x50, 0x4, 0xe5, 0xb8, 0x0, 0x0, 0xdf,
    0xff, 0xd7, 0x0,

    /* U+040B "Ћ" */
    0xdf, 0xff, 0xff, 0xf5, 0x0, 0x12, 0x2f, 0x52,
    0x20, 0x0, 0x0, 0xf, 0x30, 0x0, 0x0, 0x0,
    0xf, 0xad, 0xfd, 0x40, 0x0, 0xf, 0xb5, 0x39,
    0xf2, 0x0, 0xf, 0x30, 0x0, 0xd6, 0x0, 0xf,
    0x30, 0x0, 0xa8, 0x0, 0xf, 0x30, 0x0, 0xa8,
    0x0, 0xf, 0x30, 0x0, 0xa8,

    /* U+040C "Ќ" */
    0x0, 0x1b, 0x10, 0x0, 0x0, 0x5a, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb7, 0x0, 0x7, 0xd0,
    0xb7, 0x0, 0x2e, 0x20, 0xb7, 0x0, 0xb7, 0x0,
    0xb7, 0x6, 0xc0, 0x0, 0xbf, 0xff, 0x50, 0x0,
    0xb8, 0x29, 0xd0, 0x0, 0xb7, 0x0, 0xc9, 0x0,
    0xb7, 0x0, 0x2f, 0x40, 0xb7, 0x0, 0x6, 0xe1,

    /* U+040D "Ѝ" */
    0x0, 0x73, 0x0, 0x0, 0x0, 0x2c, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb7, 0x0, 0x0, 0xd9,
    0xb7, 0x0, 0x9, 0xf9, 0xb7, 0x0, 0x5f, 0xb9,
    0xb7, 0x1, 0xe5, 0xa9, 0xb7, 0xc, 0xa0, 0xa9,
    0xb7, 0x7d, 0x0, 0xa9, 0xbb, 0xf3, 0x0, 0xa9,
    0xbf, 0x70, 0x0, 0xa9, 0xbc, 0x0, 0x0, 0xa9,

    /* U+040E "Ў" */
    0x0, 0x70, 0x6, 0x0, 0x0, 0x6, 0xcc, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xb0, 0x0,
    0x4, 0xe0, 0x1f, 0x30, 0x0, 0xc6, 0x0, 0x8a,
    0x0, 0x4d, 0x0, 0x1, 0xf2, 0xc, 0x60, 0x0,
    0x8, 0xa4, 0xd0, 0x0, 0x0, 0x1f, 0xd5, 0x0,
    0x0, 0x0, 0x9d, 0x0, 0x0, 0x2, 0x3e, 0x40,
    0x0, 0x0, 0xdf, 0x70, 0x0, 0x0,

    /* U+040F "Џ" */
    0xb8, 0x0, 0x0, 0xd5, 0xb8, 0x0, 0x0, 0xd5,
    0xb8, 0x0, 0x0, 0xd5, 0xb8, 0x0, 0x0, 0xd5,
    0xb8, 0x0, 0x0, 0xd5, 0xb8, 0x0, 0x0, 0xd5,
    0xb8, 0x0, 0x0, 0xd5, 0xb9, 0x22, 0x22, 0xd5,
    0xbf, 0xff, 0xff, 0xf5, 0x0, 0xb, 0x60, 0x0,
    0x0, 0xb, 0x60, 0x0,

    /* U+0410 "А" */
    0x0, 0x4, 0xf5, 0x0, 0x0, 0x0, 0xbd, 0xc0,
    0x0, 0x0, 0x2f, 0x2f, 0x20, 0x0, 0x8, 0xb0,
    0xa9, 0x0, 0x0, 0xe5, 0x4, 0xf1, 0x0, 0x6e,
    0x0, 0xd, 0x70, 0xd, 0xfe, 0xee, 0xfd, 0x3,
    0xf3, 0x11, 0x12, 0xf4, 0xa9, 0x0, 0x0, 0x8,
    0xb0,

    /* U+0411 "Б" */
    0xbf, 0xff, 0xff, 0xa0, 0xb8, 0x11, 0x11, 0x10,
    0xb8, 0x0, 0x0, 0x0, 0xbf, 0xee, 0xda, 0x10,
    0xb8, 0x11, 0x3b, 0xc0, 0xb8, 0x0, 0x1, 0xf1,
    0xb8, 0x0, 0x1, 0xf1, 0xb8, 0x0, 0x2a, 0xc0,
    0xbf, 0xff, 0xea, 0x10,

    /* U+0412 "В" */
    0xbf, 0xff, 0xea, 0x10, 0xb8, 0x0, 0x2c, 0xa0,
    0xb8, 0x0, 0x6, 0xc0, 0xb8, 0x0, 0x1b, 0x70,
    0xbf, 0xff, 0xfe, 0x20, 0xb8, 0x0, 0x6, 0xe0,
    0xb8, 0x0, 0x0, 0xf3, 0xb8, 0x0, 0x17, 0xf1,
    0xbf, 0xff, 0xfc, 0x40,

    /* U+0413 "Г" */
    0xbf, 0xff, 0xfc, 0xb8, 0x22, 0x21, 0xb7, 0x0,
    0x0, 0xb7, 0x0, 0x0, 0xb7, 0x0, 0x0, 0xb7,
    0x0, 0x0, 0xb7, 0x0, 0x0, 0xb7, 0x0, 0x0,
    0xb7, 0x0, 0x0,

    /* U+0414 "Д" */
    0x0, 0xdf, 0xff, 0xff, 0x10, 0x0, 0xd4, 0x22,
    0x3f, 0x10, 0x0, 0xe2, 0x0, 0x1f, 0x10, 0x0,
    0xf1, 0x0, 0x1f, 0x10, 0x0, 0xf0, 0x0, 0x1f,
    0x10, 0x2, 0xf0, 0x0, 0x1f, 0x10, 0x5, 0xc0,
    0x0, 0x1f, 0x10, 0x2c, 0x72, 0x22, 0x3f, 0x30,
    0xdf, 0xff, 0xff, 0xff, 0xf5, 0xd4, 0x0, 0x0,
    0x0, 0xc5, 0xd4, 0x0, 0x0, 0x0, 0xc5,

    /* U+0415 "Е" */
    0xbf, 0xff, 0xff, 0x3b, 0x92, 0x22, 0x20, 0xb8,
    0x0, 0x0, 0xb, 0x80, 0x0, 0x0, 0xbf, 0xff,
    0xfa, 0xb, 0x92, 0x22, 0x10, 0xb8, 0x0, 0x0,
    0xb, 0x92, 0x22, 0x20, 0xbf, 0xff, 0xff, 0x60,

    /* U+0416 "Ж" */
    0x4e, 0x10, 0x6, 0xc0, 0x0, 0xaa, 0x0, 0xa8,
    0x0, 0x6c, 0x0, 0x3f, 0x10, 0x1, 0xe2, 0x6,
    0xc0, 0xc, 0x70, 0x0, 0x7, 0xa0, 0x6c, 0x5,
    0xd0, 0x0, 0x0, 0x2f, 0xff, 0xff, 0xf7, 0x0,
    0x0, 0xb, 0xc2, 0x8c, 0x27, 0xe1, 0x0, 0x4,
    0xf2, 0x6, 0xc0, 0xc, 0x90, 0x0, 0xd8, 0x0,
    0x6c, 0x0, 0x3f, 0x30, 0x7e, 0x0, 0x6, 0xc0,
    0x0, 0x9c, 0x0,

    /* U+0417 "З" */
    0x19, 0xdf, 0xd5, 0x0, 0x1a, 0x42, 0x6f, 0x50,
    0x0, 0x0, 0x9, 0x90, 0x0, 0x0, 0x1d, 0x60,
    0x0, 0xff, 0xfc, 0x0, 0x0, 0x22, 0x3b, 0xa0,
    0x0, 0x0, 0x4, 0xf0, 0x58, 0x21, 0x4d, 0xb0,
    0x19, 0xef, 0xe9, 0x0,

    /* U+0418 "И" */
    0xb8, 0x0, 0x0, 0xd9, 0xb8, 0x0, 0x9, 0xf9,
    0xb8, 0x0, 0x5f, 0xb9, 0xb8, 0x1, 0xe5, 0x99,
    0xb8, 0xb, 0xa0, 0x99, 0xb8, 0x7d, 0x0, 0x99,
    0xbb, 0xf3, 0x0, 0x99, 0xbf, 0x70, 0x0, 0x99,
    0xbc, 0x0, 0x0, 0x99,

    /* U+0419 "Й" */
    0x0, 0x60, 0x6, 0x0, 0x0, 0x8c, 0xb5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb7, 0x0, 0x0, 0xd9,
    0xb7, 0x0, 0x9, 0xf9, 0xb7, 0x0, 0x5f, 0xb9,
    0xb7, 0x1, 0xe5, 0xa9, 0xb7, 0xc, 0xa0, 0xa9,
    0xb7, 0x7d, 0x0, 0xa9, 0xbb, 0xf3, 0x0, 0xa9,
    0xbf, 0x70, 0x0, 0xa9, 0xbc, 0x0, 0x0, 0xa9,

    /* U+041A "К" */
    0xb7, 0x0, 0x6, 0xd0, 0xb7, 0x0, 0x2e, 0x30,
    0xb7, 0x0, 0xb8, 0x0, 0xb7, 0x6, 0xd0, 0x0,
    0xbf, 0xff, 0x50, 0x0, 0xb9, 0x29, 0xd0, 0x0,
    0xb7, 0x0, 0xc9, 0x0, 0xb7, 0x0, 0x2f, 0x40,
    0xb7, 0x0, 0x6, 0xe1,

    /* U+041B "Л" */
    0x0, 0xcf, 0xff, 0xff, 0x20, 0xc, 0x52, 0x22,
    0xf2, 0x0, 0xd3, 0x0, 0xf, 0x20, 0xd, 0x30,
    0x0, 0xf2, 0x0, 0xe2, 0x0, 0xf, 0x20, 0xf,
    0x10, 0x0, 0xf2, 0x3, 0xe0, 0x0, 0xf, 0x23,
    0xba, 0x0, 0x0, 0xf2, 0xcd, 0x20, 0x0, 0xf,
    0x20,

    /* U+041C "М" */
    0xb9, 0x0, 0x0, 0x1, 0xf3, 0xbf, 0x20, 0x0,
    0x9, 0xf3, 0xbe, 0xa0, 0x0, 0x2e, 0xf3, 0xb8,
    0xe3, 0x0, 0xa7, 0xe3, 0xb7, 0x6c, 0x3, 0xe0,
    0xe3, 0xb7, 0xd, 0x5c, 0x60, 0xe3, 0xb7, 0x4,
    0xfd, 0x0, 0xe3, 0xb7, 0x0, 0xa4, 0x0, 0xe3,
    0xb7, 0x0, 0x0, 0x0, 0xe3,

    /* U+041D "Н" */
    0xb8, 0x0, 0x0, 0xb8, 0xb8, 0x0, 0x0, 0xb8,
    0xb8, 0x0, 0x0, 0xb8, 0xb8, 0x0, 0x0, 0xb8,
    0xbf, 0xff, 0xff, 0xf8, 0xb9, 0x22, 0x22, 0xb8,
    0xb8, 0x0, 0x0, 0xb8, 0xb8, 0x0, 0x0, 0xb8,
    0xb8, 0x0, 0x0, 0xb8,

    /* U+041E "О" */
    0x0, 0x3b, 0xff, 0xc4, 0x0, 0x4, 0xf9, 0x44,
    0x8f, 0x60, 0xe, 0x70, 0x0, 0x5, 0xf1, 0x4f,
    0x0, 0x0, 0x0, 0xd6, 0x6d, 0x0, 0x0, 0x0,
    0xb8, 0x4f, 0x0, 0x0, 0x0, 0xd6, 0xe, 0x70,
    0x0, 0x5, 0xf1, 0x4, 0xf9, 0x43, 0x8f, 0x60,
    0x0, 0x3b, 0xff, 0xc4, 0x0,

    /* U+041F "П" */
    0xbf, 0xff, 0xff, 0xf8, 0xb9, 0x22, 0x22, 0xa8,
    0xb8, 0x0, 0x0, 0xa8, 0xb8, 0x0, 0x0, 0xa8,
    0xb8, 0x0, 0x0, 0xa8, 0xb8, 0x0, 0x0, 0xa8,
    0xb8, 0x0, 0x0, 0xa8, 0xb8, 0x0, 0x0, 0xa8,
    0xb8, 0x0, 0x0, 0xa8,

    /* U+0420 "Р" */
    0xbf, 0xff, 0xe8, 0x0, 0xb9, 0x22, 0x4d, 0xa0,
    0xb8, 0x0, 0x3, 0xf0, 0xb8, 0x0, 0x3, 0xf0,
    0xb8, 0x0, 0x2b, 0xb0, 0xbf, 0xff, 0xfb, 0x10,
    0xb9, 0x22, 0x0, 0x0, 0xb8, 0x0, 0x0, 0x0,
    0xb8, 0x0, 0x0, 0x0,

    /* U+0421 "С" */
    0x0, 0x3b, 0xff, 0xb4, 0x0, 0x4f, 0xa4, 0x38,
    0xe1, 0xd, 0x70, 0x0, 0x0, 0x4, 0xf0, 0x0,
    0x0, 0x0, 0x5d, 0x0, 0x0, 0x0, 0x4, 0xf0,
    0x0, 0x0, 0x0, 0xe, 0x70, 0x0, 0x0, 0x0,
    0x4f, 0x94, 0x38, 0xe0, 0x0, 0x3b, 0xff, 0xc3,
    0x0,

    /* U+0422 "Т" */
    0xdf, 0xff, 0xff, 0xf1, 0x12, 0x2f, 0x52, 0x20,
    0x0, 0xf, 0x30, 0x0, 0x0, 0xf, 0x30, 0x0,
    0x0, 0xf, 0x30, 0x0, 0x0, 0xf, 0x30, 0x0,
    0x0, 0xf, 0x30, 0x0, 0x0, 0xf, 0x30, 0x0,
    0x0, 0xf, 0x30, 0x0,

    /* U+0423 "У" */
    0x9b, 0x0, 0x0, 0x4e, 0x1, 0xf3, 0x0, 0xc,
    0x60, 0x8, 0xb0, 0x4, 0xe0, 0x0, 0x1f, 0x20,
    0xc6, 0x0, 0x0, 0x8a, 0x4d, 0x0, 0x0, 0x1,
    0xfd, 0x50, 0x0, 0x0, 0x9, 0xd0, 0x0, 0x0,
    0x23, 0xe5, 0x0, 0x0, 0xc, 0xf8, 0x0, 0x0,
    0x0,

    /* U+0424 "Ф" */
    0x0, 0x0, 0xd, 0x10, 0x0, 0x0, 0x5, 0xbe,
    0xfe, 0xb6, 0x0, 0x8, 0xe6, 0x2f, 0x45, 0xda,
    0x2, 0xf2, 0x0, 0xf2, 0x1, 0xf4, 0x6c, 0x0,
    0xf, 0x20, 0xa, 0x86, 0xc0, 0x0, 0xf2, 0x0,
    0xa8, 0x3f, 0x10, 0xf, 0x20, 0xe, 0x50, 0xbc,
    0x30, 0xf2, 0x2b, 0xc0, 0x0, 0x8e, 0xff, 0xfe,
    0x91, 0x0, 0x0, 0x1, 0xf3, 0x0, 0x0,

    /* U+0425 "Х" */
    0x4f, 0x20, 0x2, 0xf4, 0x9, 0xc0, 0xc, 0x90,
    0x1, 0xe7, 0x7e, 0x0, 0x0, 0x4f, 0xf4, 0x0,
    0x0, 0xe, 0xe0, 0x0, 0x0, 0x7d, 0xe8, 0x0,
    0x2, 0xf4, 0x4f, 0x30, 0xc, 0x90, 0x9, 0xc0,
    0x7d, 0x0, 0x0, 0xe7,

    /* U+0426 "Ц" */
    0xb8, 0x0, 0x0, 0xd5, 0xb, 0x80, 0x0, 0xd,
    0x50, 0xb8, 0x0, 0x0, 0xd5, 0xb, 0x80, 0x0,
    0xd, 0x50, 0xb8, 0x0, 0x0, 0xd5, 0xb, 0x80,
    0x0, 0xd, 0x50, 0xb8, 0x0, 0x0, 0xd5, 0xb,
    0x92, 0x22, 0x2d, 0x71, 0xbf, 0xff, 0xff, 0xff,
    0xa0, 0x0, 0x0, 0x0, 0x7a, 0x0, 0x0, 0x0,
    0x7, 0xa0,

    /* U+0427 "Ч" */
    0x5d, 0x0, 0x0, 0xa8, 0x5d, 0x0, 0x0, 0xa8,
    0x5d, 0x0, 0x0, 0xa8, 0x4f, 0x0, 0x0, 0xa8,
    0x1f, 0x81, 0x3, 0xd8, 0x4, 0xef, 0xfe, 0xe8,
    0x0, 0x1, 0x10, 0xa8, 0x0, 0x0, 0x0, 0xa8,
    0x0, 0x0, 0x0, 0xa8,

    /* U+0428 "Ш" */
    0xb8, 0x0, 0xf, 0x20, 0x5, 0xdb, 0x80, 0x0,
    0xf2, 0x0, 0x5d, 0xb8, 0x0, 0xf, 0x20, 0x5,
    0xdb, 0x80, 0x0, 0xf2, 0x0, 0x5d, 0xb8, 0x0,
    0xf, 0x20, 0x5, 0xdb, 0x80, 0x0, 0xf2, 0x0,
    0x5d, 0xb8, 0x0, 0xf, 0x20, 0x5, 0xdb, 0x92,
    0x22, 0xf4, 0x22, 0x6d, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xd0,

    /* U+0429 "Щ" */
    0xb7, 0x0, 0xf, 0x20, 0x5, 0xd0, 0xb, 0x70,
    0x0, 0xf2, 0x0, 0x5d, 0x0, 0xb7, 0x0, 0xf,
    0x20, 0x5, 0xd0, 0xb, 0x70, 0x0, 0xf2, 0x0,
    0x5d, 0x0, 0xb7, 0x0, 0xf, 0x20, 0x5, 0xd0,
    0xb, 0x70, 0x0, 0xf2, 0x0, 0x5d, 0x0, 0xb7,
    0x0, 0xf, 0x20, 0x5, 0xd0, 0xb, 0x82, 0x22,
    0xf4, 0x22, 0x8f, 0x20, 0xbf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0x10,

    /* U+042A "Ъ" */
    0xdf, 0xfe, 0x0, 0x0, 0x0, 0x12, 0x6e, 0x0,
    0x0, 0x0, 0x0, 0x4e, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0xee, 0xeb, 0x40, 0x0, 0x4e, 0x11, 0x27,
    0xf2, 0x0, 0x4e, 0x0, 0x0, 0xd6, 0x0, 0x4e,
    0x0, 0x0, 0xd5, 0x0, 0x4e, 0x0, 0x17, 0xf1,
    0x0, 0x4f, 0xff, 0xfc, 0x40,

    /* U+042B "Ы" */
    0xb7, 0x0, 0x0, 0x0, 0x99, 0xb7, 0x0, 0x0,
    0x0, 0x99, 0xb7, 0x0, 0x0, 0x0, 0x99, 0xbf,
    0xee, 0xd9, 0x10, 0x99, 0xb8, 0x11, 0x3c, 0xb0,
    0x99, 0xb7, 0x0, 0x3, 0xf0, 0x99, 0xb7, 0x0,
    0x3, 0xf0, 0x99, 0xb8, 0x0, 0x2c, 0xa0, 0x99,
    0xbf, 0xff, 0xe9, 0x10, 0x99,

    /* U+042C "Ь" */
    0xb8, 0x0, 0x0, 0x0, 0xb8, 0x0, 0x0, 0x0,
    0xb8, 0x0, 0x0, 0x0, 0xbf, 0xee, 0xd9, 0x10,
    0xb8, 0x11, 0x3c, 0xb0, 0xb8, 0x0, 0x3, 0xf0,
    0xb8, 0x0, 0x3, 0xf0, 0xb8, 0x0, 0x2b, 0xb0,
    0xbf, 0xff, 0xe9, 0x10,

    /* U+042D "Э" */
    0x7, 0xdf, 0xe8, 0x0, 0x6d, 0x53, 0x5e, 0xc0,
    0x0, 0x0, 0x1, 0xf6, 0x0, 0x0, 0x0, 0x8b,
    0x0, 0x6f, 0xff, 0xfd, 0x0, 0x2, 0x22, 0x8b,
    0x0, 0x0, 0x0, 0xe6, 0x6c, 0x53, 0x5d, 0xc0,
    0x7, 0xdf, 0xe8, 0x0,

    /* U+042E "Ю" */
    0xb8, 0x0, 0x19, 0xef, 0xc5, 0x0, 0xb8, 0x0,
    0xdb, 0x32, 0x6e, 0x70, 0xb8, 0x8, 0xc0, 0x0,
    0x4, 0xf1, 0xb8, 0xd, 0x60, 0x0, 0x0, 0xd6,
    0xbf, 0xff, 0x40, 0x0, 0x0, 0xb8, 0xb9, 0x3e,
    0x60, 0x0, 0x0, 0xd6, 0xb8, 0x9, 0xd0, 0x0,
    0x5, 0xf2, 0xb8, 0x1, 0xec, 0x53, 0x7f, 0x70,
    0xb8, 0x0, 0x19, 0xef, 0xc5, 0x0,

    /* U+042F "Я" */
    0x2, 0xbf, 0xff, 0xf7, 0xd, 0xb3, 0x22, 0xc7,
    0x3f, 0x0, 0x0, 0xb7, 0x4f, 0x0, 0x0, 0xb7,
    0xf, 0x80, 0x0, 0xb7, 0x4, 0xef, 0xff, 0xf7,
    0x0, 0xc7, 0x22, 0xc7, 0x6, 0xd0, 0x0, 0xb7,
    0x1e, 0x40, 0x0, 0xb7,

    /* U+0430 "а" */
    0x2, 0xbf, 0xe5, 0xf2, 0xd, 0xa2, 0x3d, 0xf2,
    0x4e, 0x0, 0x2, 0xf2, 0x6c, 0x0, 0x0, 0xf2,
    0x4e, 0x0, 0x3, 0xf2, 0xd, 0xb2, 0x3d, 0xf2,
    0x2, 0xbf, 0xe5, 0xf2,

    /* U+0431 "б" */
    0x0, 0x0, 0x1, 0x40, 0x0, 0x17, 0xcf, 0xd0,
    0x1, 0xea, 0x51, 0x0, 0xb, 0x80, 0x0, 0x0,
    0xf, 0x4d, 0xeb, 0x20, 0x2f, 0xd4, 0x3b, 0xd0,
    0x3f, 0x40, 0x0, 0xe4, 0x2f, 0x10, 0x0, 0xc6,
    0xf, 0x40, 0x0, 0xe4, 0x9, 0xd3, 0x1a, 0xd0,
    0x0, 0x9e, 0xfa, 0x10,

    /* U+0432 "в" */
    0xef, 0xff, 0xa0, 0xe4, 0x1, 0xd6, 0xe4, 0x0,
    0xd4, 0xee, 0xef, 0xd0, 0xe4, 0x0, 0xa8, 0xe4,
    0x0, 0xa9, 0xef, 0xff, 0xc2,

    /* U+0433 "г" */
    0xef, 0xff, 0xce, 0x51, 0x11, 0xe4, 0x0, 0xe,
    0x40, 0x0, 0xe4, 0x0, 0xe, 0x40, 0x0, 0xe4,
    0x0, 0x0,

    /* U+0434 "д" */
    0x5, 0xff, 0xff, 0x90, 0x6, 0xb1, 0x19, 0x90,
    0x6, 0xa0, 0x8, 0x90, 0x8, 0x90, 0x8, 0x90,
    0xa, 0x70, 0x8, 0x90, 0x2e, 0x31, 0x19, 0xa0,
    0xef, 0xff, 0xff, 0xf9, 0xe3, 0x0, 0x0, 0x89,
    0x81, 0x0, 0x0, 0x45,

    /* U+0435 "е" */
    0x2, 0xbf, 0xd6, 0x0, 0xe9, 0x14, 0xe4, 0x5d,
    0x0, 0x6, 0xb7, 0xfe, 0xee, 0xec, 0x5d, 0x0,
    0x0, 0x0, 0xda, 0x23, 0xa2, 0x1, 0xbf, 0xf9,
    0x0,

    /* U+0436 "ж" */
    0x6d, 0x0, 0x7a, 0x0, 0xa9, 0x0, 0xc6, 0x7,
    0xa0, 0x3e, 0x10, 0x3, 0xe0, 0x7a, 0xc, 0x60,
    0x0, 0xd, 0xff, 0xff, 0xf0, 0x0, 0x5, 0xf3,
    0x8b, 0x2d, 0x70, 0x0, 0xe7, 0x7, 0xa0, 0x4f,
    0x20, 0x8d, 0x0, 0x7a, 0x0, 0xab, 0x0,

    /* U+0437 "з" */
    0x2b, 0xfe, 0xa1, 0x16, 0x22, 0xc9, 0x0, 0x0,
    0xa8, 0x0, 0xdf, 0xe1, 0x0, 0x0, 0x8c, 0x45,
    0x22, 0xbc, 0x3b, 0xee, 0xb2,

    /* U+0438 "и" */
    0xe4, 0x0, 0x3f, 0x3e, 0x40, 0x1e, 0xf3, 0xe4,
    0xb, 0x9f, 0x3e, 0x48, 0xc0, 0xf3, 0xe8, 0xe2,
    0xf, 0x3e, 0xf5, 0x0, 0xf3, 0xe8, 0x0, 0xf,
    0x30,

    /* U+0439 "й" */
    0x5, 0x0, 0x60, 0x0, 0x4b, 0xc6, 0x0, 0x0,
    0x0, 0x0, 0xe, 0x40, 0x3, 0xf3, 0xe4, 0x1,
    0xef, 0x3e, 0x40, 0xb9, 0xf3, 0xe4, 0x8c, 0xf,
    0x3e, 0x8e, 0x20, 0xf3, 0xef, 0x40, 0xf, 0x3e,
    0x80, 0x0, 0xf3,

    /* U+043A "к" */
    0xe4, 0x0, 0xa8, 0xe, 0x40, 0x5d, 0x0, 0xe4,
    0x1e, 0x30, 0xe, 0xff, 0xb0, 0x0, 0xe5, 0x3f,
    0x40, 0xe, 0x40, 0x6e, 0x10, 0xe4, 0x0, 0xab,
    0x0,

    /* U+043B "л" */
    0x5, 0xff, 0xff, 0x90, 0x6b, 0x11, 0x99, 0x6,
    0x90, 0x9, 0x90, 0x78, 0x0, 0x99, 0x9, 0x70,
    0x9, 0x91, 0xe3, 0x0, 0x99, 0xea, 0x0, 0x9,
    0x90,

    /* U+043C "м" */
    0xe8, 0x0, 0x0, 0xd7, 0xef, 0x10, 0x7, 0xf7,
    0xea, 0x90, 0xe, 0xb7, 0xe3, 0xe2, 0x88, 0x97,
    0xe2, 0x6b, 0xe0, 0x97, 0xe2, 0xd, 0x60, 0x97,
    0xe2, 0x1, 0x0, 0x97,

    /* U+043D "н" */
    0xe4, 0x0, 0x1f, 0xe, 0x40, 0x1, 0xf0, 0xe4,
    0x0, 0x1f, 0xe, 0xff, 0xff, 0xf0, 0xe5, 0x22,
    0x3f, 0xe, 0x40, 0x1, 0xf0, 0xe4, 0x0, 0x1f,
    0x0,

    /* U+043E "о" */
    0x2, 0xbf, 0xe8, 0x0, 0xd, 0xa2, 0x3d, 0x80,
    0x5d, 0x0, 0x3, 0xf0, 0x7b, 0x0, 0x0, 0xf1,
    0x5d, 0x0, 0x3, 0xf0, 0xd, 0xa2, 0x4e, 0x80,
    0x2, 0xbf, 0xe8, 0x0,

    /* U+043F "п" */
    0xef, 0xff, 0xff, 0xe, 0x51, 0x13, 0xf0, 0xe4,
    0x0, 0x2f, 0xe, 0x40, 0x2, 0xf0, 0xe4, 0x0,
    0x2f, 0xe, 0x40, 0x2, 0xf0, 0xe4, 0x0, 0x2f,
    0x0,

    /* U+0440 "р" */
    0xe6, 0xdf, 0xc4, 0xe, 0xf4, 0x17, 0xf2, 0xe6,
    0x0, 0xa, 0x8e, 0x40, 0x0, 0x7a, 0xe7, 0x0,
    0xa, 0x8e, 0xf5, 0x28, 0xf2, 0xe6, 0xcf, 0xc4,
    0xe, 0x40, 0x0, 0x0, 0xe4, 0x0, 0x0, 0xe,
    0x40, 0x0, 0x0,

    /* U+0441 "с" */
    0x1, 0xbf, 0xe8, 0x0, 0xda, 0x24, 0xc3, 0x5d,
    0x0, 0x0, 0x7, 0xb0, 0x0, 0x0, 0x5d, 0x0,
    0x0, 0x0, 0xda, 0x24, 0xc3, 0x1, 0xbf, 0xe8,
    0x0,

    /* U+0442 "т" */
    0xff, 0xff, 0xfd, 0x11, 0xa9, 0x11, 0x0, 0xa8,
    0x0, 0x0, 0xa8, 0x0, 0x0, 0xa8, 0x0, 0x0,
    0xa8, 0x0, 0x0, 0xa8, 0x0,

    /* U+0443 "у" */
    0xc, 0x60, 0x0, 0x89, 0x6, 0xc0, 0x0, 0xe3,
    0x0, 0xf2, 0x4, 0xd0, 0x0, 0xa8, 0xa, 0x60,
    0x0, 0x3e, 0x1f, 0x10, 0x0, 0xd, 0xba, 0x0,
    0x0, 0x7, 0xf4, 0x0, 0x0, 0x4, 0xe0, 0x0,
    0x5, 0x2b, 0x70, 0x0, 0xc, 0xfa, 0x0, 0x0,

    /* U+0444 "ф" */
    0x0, 0x0, 0xb6, 0x0, 0x0, 0x0, 0x0, 0xb6,
    0x0, 0x0, 0x1, 0xae, 0xff, 0xd7, 0x0, 0xe,
    0xa3, 0xc7, 0x4d, 0x90, 0x5d, 0x0, 0xb6, 0x3,
    0xf0, 0x7a, 0x0, 0xb6, 0x0, 0xf1, 0x5d, 0x0,
    0xb6, 0x3, 0xf0, 0xe, 0xa3, 0xc7, 0x5d, 0x90,
    0x1, 0xae, 0xff, 0xd7, 0x0, 0x0, 0x0, 0xb6,
    0x0, 0x0, 0x0, 0x0, 0xb6, 0x0, 0x0, 0x0,
    0x0, 0xb6, 0x0, 0x0,

    /* U+0445 "х" */
    0x6d, 0x0, 0x5d, 0x0, 0xb8, 0x1e, 0x30, 0x1,
    0xed, 0x80, 0x0, 0x9, 0xf1, 0x0, 0x2, 0xeb,
    0x90, 0x0, 0xd6, 0x1e, 0x50, 0x8b, 0x0, 0x4e,
    0x10,

    /* U+0446 "ц" */
    0xe4, 0x0, 0x4e, 0xe, 0x40, 0x4, 0xe0, 0xe4,
    0x0, 0x4e, 0xe, 0x40, 0x4, 0xe0, 0xe4, 0x0,
    0x4e, 0xe, 0x51, 0x15, 0xe1, 0xef, 0xff, 0xff,
    0xe0, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x1, 0x80,

    /* U+0447 "ч" */
    0x8a, 0x0, 0xf, 0x38, 0xa0, 0x0, 0xf3, 0x7a,
    0x0, 0xf, 0x35, 0xe1, 0x3, 0xf3, 0xa, 0xff,
    0xcf, 0x30, 0x0, 0x0, 0xf3, 0x0, 0x0, 0xf,
    0x30,

    /* U+0448 "ш" */
    0xe4, 0x0, 0xe3, 0x0, 0xf2, 0xe4, 0x0, 0xe3,
    0x0, 0xf2, 0xe4, 0x0, 0xe3, 0x0, 0xf2, 0xe4,
    0x0, 0xe3, 0x0, 0xf2, 0xe4, 0x0, 0xe3, 0x0,
    0xf2, 0xe5, 0x11, 0xe4, 0x11, 0xf2, 0xef, 0xff,
    0xff, 0xff, 0xf2,

    /* U+0449 "щ" */
    0xe4, 0x0, 0xf3, 0x0, 0xf2, 0xe, 0x40, 0xf,
    0x30, 0xf, 0x20, 0xe4, 0x0, 0xf3, 0x0, 0xf2,
    0xe, 0x40, 0xf, 0x30, 0xf, 0x20, 0xe4, 0x0,
    0xf3, 0x0, 0xf2, 0xe, 0x51, 0x1f, 0x41, 0x1f,
    0x40, 0xef, 0xff, 0xff, 0xff, 0xff, 0x10, 0x0,
    0x0, 0x0, 0x0, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x7, 0x0,

    /* U+044A "ъ" */
    0xff, 0xf2, 0x0, 0x0, 0x11, 0xf2, 0x0, 0x0,
    0x0, 0xff, 0xfd, 0x60, 0x0, 0xf2, 0x3, 0xf2,
    0x0, 0xf2, 0x0, 0xe4, 0x0, 0xf2, 0x3, 0xf1,
    0x0, 0xff, 0xfd, 0x60,

    /* U+044B "ы" */
    0xe4, 0x0, 0x0, 0x99, 0xe4, 0x0, 0x0, 0x99,
    0xee, 0xed, 0x80, 0x99, 0xe4, 0x2, 0xe4, 0x99,
    0xe4, 0x0, 0xb6, 0x99, 0xe4, 0x2, 0xe3, 0x99,
    0xef, 0xfe, 0x70, 0x99,

    /* U+044C "ь" */
    0xe4, 0x0, 0x0, 0xe4, 0x0, 0x0, 0xee, 0xee,
    0x80, 0xe4, 0x1, 0xe5, 0xe4, 0x0, 0xa8, 0xe4,
    0x1, 0xe5, 0xef, 0xfe, 0x80,

    /* U+044D "э" */
    0x2b, 0xfe, 0x91, 0x5, 0x71, 0x2b, 0xc0, 0x0,
    0x0, 0xe, 0x30, 0xd, 0xee, 0xf5, 0x0, 0x0,
    0xe, 0x35, 0x71, 0x1a, 0xc0, 0x1b, 0xfe, 0x91,
    0x0,

    /* U+044E "ю" */
    0xe4, 0x2, 0xbf, 0xe7, 0xe, 0x40, 0xd9, 0x13,
    0xe6, 0xe4, 0x4d, 0x0, 0x5, 0xde, 0xff, 0xa0,
    0x0, 0x3f, 0xe6, 0x7d, 0x0, 0x6, 0xde, 0x40,
    0xe9, 0x24, 0xf6, 0xe4, 0x2, 0xbf, 0xe6, 0x0,

    /* U+044F "я" */
    0x5, 0xdf, 0xff, 0x32, 0xf5, 0x11, 0xd3, 0x5d,
    0x0, 0xd, 0x32, 0xf2, 0x0, 0xd3, 0x6, 0xfe,
    0xef, 0x30, 0x6c, 0x0, 0xd3, 0x2e, 0x20, 0xd,
    0x30,

    /* U+0450 "ѐ" */
    0x1, 0x71, 0x0, 0x0, 0x4, 0xc2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2b, 0xfd, 0x60, 0xe, 0x91,
    0x4e, 0x45, 0xd0, 0x0, 0x6b, 0x7f, 0xee, 0xee,
    0xc5, 0xd0, 0x0, 0x0, 0xd, 0xa2, 0x3a, 0x20,
    0x1b, 0xff, 0x90,

    /* U+0451 "ё" */
    0x0, 0xd1, 0xa4, 0x0, 0x3, 0x2, 0x0, 0x2,
    0xbf, 0xd6, 0x0, 0xe9, 0x14, 0xe4, 0x5d, 0x0,
    0x6, 0xb7, 0xfe, 0xee, 0xec, 0x5d, 0x0, 0x0,
    0x0, 0xda, 0x23, 0xa2, 0x1, 0xbf, 0xf9, 0x0,

    /* U+0452 "ђ" */
    0x0, 0x71, 0x0, 0x0, 0x0, 0xe, 0x30, 0x0,
    0x0, 0x1e, 0xfe, 0xee, 0x10, 0x0, 0xe, 0x6d,
    0xfc, 0x20, 0x0, 0xee, 0x42, 0xad, 0x0, 0xe,
    0x70, 0x1, 0xf1, 0x0, 0xe4, 0x0, 0xf, 0x20,
    0xe, 0x40, 0x0, 0xf2, 0x0, 0xe4, 0x0, 0xf,
    0x20, 0xe, 0x40, 0x0, 0xf2, 0x0, 0x0, 0x0,
    0xf, 0x20, 0x0, 0x0, 0x34, 0xf0, 0x0, 0x0,
    0x1e, 0xe6, 0x0,

    /* U+0453 "ѓ" */
    0x0, 0xa3, 0x0, 0x2d, 0x0, 0x0, 0x0, 0xe,
    0xff, 0xfc, 0xe5, 0x11, 0x1e, 0x40, 0x0, 0xe4,
    0x0, 0xe, 0x40, 0x0, 0xe4, 0x0, 0xe, 0x40,
    0x0,

    /* U+0454 "є" */
    0x1, 0xaf, 0xfa, 0x10, 0xd9, 0x22, 0x84, 0x4c,
    0x0, 0x0, 0x7, 0xff, 0xfc, 0x0, 0x5d, 0x0,
    0x0, 0x0, 0xd9, 0x11, 0x84, 0x1, 0xaf, 0xfa,
    0x10,

    /* U+0455 "ѕ" */
    0x6, 0xef, 0xd5, 0x2f, 0x41, 0x53, 0x3f, 0x30,
    0x0, 0x7, 0xef, 0xb2, 0x0, 0x2, 0x9c, 0x28,
    0x31, 0x9c, 0x2b, 0xee, 0xb2,

    /* U+0456 "і" */
    0xd, 0x40, 0x82, 0x0, 0x0, 0xe4, 0xe, 0x40,
    0xe4, 0xe, 0x40, 0xe4, 0xe, 0x40, 0xe4,

    /* U+0457 "ї" */
    0xa4, 0xd0, 0x20, 0x30, 0xe, 0x30, 0xe, 0x30,
    0xe, 0x30, 0xe, 0x30, 0xe, 0x30, 0xe, 0x30,
    0xe, 0x30,

    /* U+0458 "ј" */
    0x0, 0x8, 0x20, 0x0, 0xd4, 0x0, 0x0, 0x0,
    0x0, 0xe4, 0x0, 0xe, 0x40, 0x0, 0xe4, 0x0,
    0xe, 0x40, 0x0, 0xe4, 0x0, 0xe, 0x40, 0x0,
    0xe4, 0x0, 0xe, 0x40, 0x23, 0xf1, 0xd, 0xf7,
    0x0,

    /* U+0459 "љ" */
    0x5, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x6b, 0x11,
    0xff, 0x0, 0x0, 0x6, 0x90, 0xf, 0xfe, 0xeb,
    0x10, 0x78, 0x0, 0xff, 0x0, 0xaa, 0x9, 0x60,
    0xf, 0xf0, 0x6, 0xc1, 0xe3, 0x0, 0xff, 0x1,
    0xb9, 0xea, 0x0, 0xf, 0xff, 0xfb, 0x10,

    /* U+045A "њ" */
    0xe4, 0x0, 0x3e, 0x0, 0x0, 0xe, 0x40, 0x3,
    0xe0, 0x0, 0x0, 0xe4, 0x0, 0x3e, 0x0, 0x0,
    0xe, 0xff, 0xff, 0xff, 0xed, 0x50, 0xe5, 0x22,
    0x5e, 0x22, 0x6f, 0xe, 0x40, 0x3, 0xe0, 0x4,
    0xf0, 0xe4, 0x0, 0x3f, 0xee, 0xd5, 0x0,

    /* U+045B "ћ" */
    0x0, 0x93, 0x0, 0x0, 0x5, 0xcf, 0xdc, 0xc1,
    0x0, 0x0, 0xe4, 0x0, 0x0, 0x0, 0xe, 0x7d,
    0xfc, 0x30, 0x0, 0xef, 0x42, 0xad, 0x0, 0xe,
    0x70, 0x1, 0xf1, 0x0, 0xe4, 0x0, 0xf, 0x20,
    0xe, 0x40, 0x0, 0xf2, 0x0, 0xe4, 0x0, 0xf,
    0x20, 0xe, 0x40, 0x0, 0xf2,

    /* U+045C "ќ" */
    0x0, 0x85, 0x0, 0x0, 0xe, 0x10, 0x0, 0x0,
    0x0, 0x0, 0xe, 0x40, 0xa, 0x80, 0xe4, 0x5,
    0xd0, 0xe, 0x41, 0xe3, 0x0, 0xef, 0xfa, 0x0,
    0xe, 0x53, 0xf4, 0x0, 0xe4, 0x6, 0xe1, 0xe,
    0x40, 0xa, 0xb0,

    /* U+045D "ѝ" */
    0x6, 0x40, 0x0, 0x0, 0x1b, 0x70, 0x0, 0x0,
    0x0, 0x0, 0xe, 0x40, 0x3, 0xf3, 0xe4, 0x1,
    0xef, 0x3e, 0x40, 0xb9, 0xf3, 0xe4, 0x8c, 0xf,
    0x3e, 0x8e, 0x20, 0xf3, 0xef, 0x40, 0xf, 0x3e,
    0x80, 0x0, 0xf3,

    /* U+045E "ў" */
    0x0, 0x41, 0x5, 0x0, 0x0, 0x76, 0xd, 0x0,
    0x0, 0xa, 0xb5, 0x0, 0xc, 0x60, 0x0, 0x89,
    0x6, 0xc0, 0x0, 0xe3, 0x0, 0xf2, 0x4, 0xd0,
    0x0, 0xa8, 0xa, 0x60, 0x0, 0x3e, 0x1f, 0x10,
    0x0, 0xd, 0xba, 0x0, 0x0, 0x7, 0xf4, 0x0,
    0x0, 0x4, 0xe0, 0x0, 0x5, 0x2b, 0x70, 0x0,
    0xc, 0xfa, 0x0, 0x0,

    /* U+045F "џ" */
    0xe4, 0x0, 0x8a, 0xe4, 0x0, 0x8a, 0xe4, 0x0,
    0x8a, 0xe4, 0x0, 0x8a, 0xe4, 0x0, 0x8a, 0xe5,
    0x11, 0x9a, 0xef, 0xff, 0xfa, 0x0, 0xa6, 0x0,
    0x0, 0x53, 0x0,

    /* U+0462 "Ѣ" */
    0x0, 0x45, 0x0, 0x0, 0x0, 0x0, 0x8a, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xff, 0x30, 0x0, 0x0,
    0x8a, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xee, 0xeb,
    0x20, 0x0, 0x8a, 0x11, 0x3a, 0xd0, 0x0, 0x8a,
    0x0, 0x0, 0xf2, 0x0, 0x8a, 0x0, 0x0, 0xf2,
    0x0, 0x8a, 0x0, 0x19, 0xd0, 0x0, 0x8f, 0xff,
    0xeb, 0x20,

    /* U+0463 "ѣ" */
    0x3, 0x50, 0x0, 0x0, 0x6b, 0x0, 0x0, 0x6,
    0xb0, 0x0, 0xe, 0xff, 0xee, 0x10, 0x6, 0xb0,
    0x0, 0x0, 0x6f, 0xee, 0xc2, 0x6, 0xb0, 0x8,
    0xc0, 0x6b, 0x0, 0x3f, 0x6, 0xb0, 0x8, 0xc0,
    0x6f, 0xff, 0xc2,

    /* U+046A "Ѫ" */
    0xc, 0xff, 0xff, 0xff, 0xf9, 0x0, 0x3d, 0x20,
    0x0, 0x4d, 0x10, 0x0, 0x4d, 0x10, 0x3d, 0x20,
    0x0, 0x0, 0x5d, 0x4d, 0x20, 0x0, 0x0, 0x6e,
    0xff, 0xfd, 0x40, 0x0, 0x4f, 0x42, 0xf0, 0x6f,
    0x20, 0xc, 0x60, 0x2f, 0x0, 0xa9, 0x3, 0xf0,
    0x2, 0xf0, 0x3, 0xf0, 0x9a, 0x0, 0x2f, 0x0,
    0xd, 0x60,

    /* U+046B "ѫ" */
    0x1f, 0xee, 0xee, 0xf7, 0x0, 0x6a, 0x0, 0x4c,
    0x0, 0x0, 0x79, 0x3c, 0x10, 0x0, 0x2c, 0xff,
    0xe7, 0x0, 0xd, 0x64, 0xb1, 0xd4, 0x4, 0xd0,
    0x4b, 0x6, 0xb0, 0xa7, 0x4, 0xb0, 0x1f, 0x10,

    /* U+0472 "Ѳ" */
    0x0, 0x3b, 0xff, 0xc4, 0x0, 0x4, 0xf9, 0x44,
    0x8f, 0x60, 0xe, 0x70, 0x0, 0x5, 0xf1, 0x4f,
    0x0, 0x0, 0x0, 0xe6, 0x6f, 0xee, 0xee, 0xee,
    0xf8, 0x4f, 0x21, 0x11, 0x11, 0xd6, 0xe, 0x60,
    0x0, 0x4, 0xf1, 0x4, 0xf9, 0x43, 0x8f, 0x60,
    0x0, 0x3b, 0xff, 0xc4, 0x0,

    /* U+0473 "ѳ" */
    0x2, 0xbf, 0xe9, 0x0, 0xd, 0x90, 0x1b, 0xa0,
    0x5d, 0x0, 0x1, 0xf1, 0x7f, 0xee, 0xee, 0xf3,
    0x5d, 0x0, 0x1, 0xf1, 0xd, 0x81, 0x2b, 0xa0,
    0x1, 0xaf, 0xe9, 0x0,

    /* U+0474 "Ѵ" */
    0xaa, 0x0, 0x0, 0x2d, 0xe4, 0xf1, 0x0, 0xc,
    0xa3, 0xd, 0x60, 0x2, 0xf1, 0x0, 0x7d, 0x0,
    0x8a, 0x0, 0x1, 0xf3, 0xd, 0x50, 0x0, 0xb,
    0x93, 0xf0, 0x0, 0x0, 0x5e, 0x9a, 0x0, 0x0,
    0x0, 0xef, 0x50, 0x0, 0x0, 0x9, 0xf0, 0x0,
    0x0,

    /* U+0475 "ѵ" */
    0xb8, 0x0, 0xa, 0xf0, 0x5e, 0x0, 0x3f, 0x40,
    0xe, 0x40, 0x99, 0x0, 0x8, 0xb0, 0xe3, 0x0,
    0x2, 0xf5, 0xe0, 0x0, 0x0, 0xcf, 0x80, 0x0,
    0x0, 0x5f, 0x20, 0x0,

    /* U+048A "Ҋ" */
    0x0, 0x60, 0x6, 0x0, 0x0, 0x8, 0xcb, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0x70, 0x0,
    0xd, 0x90, 0xb7, 0x0, 0xa, 0xf9, 0xb, 0x70,
    0x5, 0xfb, 0x90, 0xb7, 0x1, 0xf5, 0xa9, 0xb,
    0x70, 0xca, 0xa, 0x90, 0xb7, 0x7d, 0x0, 0xa9,
    0xb, 0xbf, 0x30, 0xa, 0x90, 0xbf, 0x70, 0x0,
    0xbb, 0x1b, 0xc0, 0x0, 0xf, 0xf9, 0x0, 0x0,
    0x0, 0xb, 0x50, 0x0, 0x0, 0x0, 0xe1,

    /* U+048B "ҋ" */
    0x6, 0x0, 0x60, 0x0, 0x4, 0xbb, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe4, 0x0, 0x3f, 0x30,
    0xe4, 0x1, 0xef, 0x30, 0xe4, 0xb, 0x9f, 0x30,
    0xe4, 0x8c, 0xf, 0x30, 0xe8, 0xe2, 0xf, 0x30,
    0xef, 0x40, 0xf, 0x40, 0xe8, 0x0, 0xf, 0xf0,
    0x0, 0x0, 0x3, 0xc0, 0x0, 0x0, 0x2, 0x40,

    /* U+048C "Ҍ" */
    0x3, 0x60, 0x0, 0x0, 0x0, 0x6c, 0x0, 0x0,
    0x0, 0x9f, 0xff, 0xf5, 0x0, 0x0, 0x6c, 0x0,
    0x0, 0x0, 0x6, 0xfe, 0xee, 0xb3, 0x0, 0x6d,
    0x11, 0x28, 0xf1, 0x6, 0xc0, 0x0, 0xe, 0x50,
    0x6c, 0x0, 0x0, 0xe5, 0x6, 0xc0, 0x1, 0x8e,
    0x10, 0x6f, 0xff, 0xfc, 0x30,

    /* U+048D "ҍ" */
    0x8, 0xa0, 0x0, 0xb, 0xff, 0xff, 0x0, 0x8,
    0xa0, 0x0, 0x0, 0x8f, 0xee, 0xc3, 0x8, 0xa0,
    0x7, 0xd0, 0x8a, 0x0, 0x8c, 0x8, 0xff, 0xfc,
    0x30,

    /* U+048E "Ҏ" */
    0xbf, 0xff, 0xe9, 0x0, 0xb9, 0x22, 0x4d, 0xa0,
    0xb8, 0x0, 0x3, 0xf0, 0xb8, 0xa, 0x43, 0xf0,
    0xb8, 0x1, 0xdb, 0xb0, 0xbf, 0xff, 0xff, 0x10,
    0xb9, 0x22, 0x9, 0x70, 0xb8, 0x0, 0x0, 0x70,
    0xb8, 0x0, 0x0, 0x0,

    /* U+048F "ҏ" */
    0xe5, 0xbf, 0xd5, 0xe, 0xe4, 0x16, 0xf3, 0xe7,
    0x0, 0x9, 0x9e, 0x40, 0x0, 0x6b, 0xe7, 0x3,
    0xa9, 0x9e, 0xe5, 0x2d, 0xf3, 0xe6, 0xbf, 0xdd,
    0x2e, 0x40, 0x0, 0x44, 0xe4, 0x0, 0x0, 0xe,
    0x40, 0x0, 0x0,

    /* U+0490 "Ґ" */
    0x0, 0x0, 0x4d, 0x0, 0x0, 0x4d, 0xbf, 0xff,
    0xfd, 0xb9, 0x22, 0x21, 0xb8, 0x0, 0x0, 0xb8,
    0x0, 0x0, 0xb8, 0x0, 0x0, 0xb8, 0x0, 0x0,
    0xb8, 0x0, 0x0, 0xb8, 0x0, 0x0, 0xb8, 0x0,
    0x0,

    /* U+0491 "ґ" */
    0x0, 0x4, 0x40, 0x0, 0x98, 0xef, 0xff, 0x8e,
    0x51, 0x10, 0xe4, 0x0, 0xe, 0x40, 0x0, 0xe4,
    0x0, 0xe, 0x40, 0x0, 0xe4, 0x0, 0x0,

    /* U+0492 "Ғ" */
    0x6, 0xff, 0xff, 0xf2, 0x6, 0xd2, 0x22, 0x20,
    0x6, 0xc0, 0x0, 0x0, 0x6, 0xc0, 0x0, 0x0,
    0x9f, 0xff, 0xff, 0x50, 0x6, 0xd0, 0x0, 0x0,
    0x6, 0xd0, 0x0, 0x0, 0x6, 0xd0, 0x0, 0x0,
    0x6, 0xd0, 0x0, 0x0,

    /* U+0493 "ғ" */
    0xb, 0xff, 0xff, 0xb, 0x81, 0x11, 0xb, 0x70,
    0x0, 0xb, 0x70, 0x0, 0x6f, 0xee, 0xe2, 0xb,
    0x70, 0x0, 0xb, 0x70, 0x0,

    /* U+0494 "Ҕ" */
    0xbf, 0xff, 0xff, 0x1b, 0x92, 0x22, 0x20, 0xb8,
    0x0, 0x0, 0xb, 0x80, 0x0, 0x0, 0xbb, 0xbe,
    0xc6, 0xb, 0xd5, 0x26, 0xf5, 0xb8, 0x0, 0x8,
    0xbb, 0x80, 0x0, 0x5d, 0xb8, 0x0, 0x7, 0xb0,
    0x0, 0x3, 0xe4, 0x0, 0xf, 0xf7, 0x0, 0x0,
    0x10, 0x0,

    /* U+0495 "ҕ" */
    0xef, 0xff, 0xa0, 0xe5, 0x11, 0x10, 0xe4, 0x0,
    0x0, 0xe4, 0x0, 0x0, 0xeb, 0xde, 0x90, 0xe8,
    0x23, 0xd8, 0xe4, 0x0, 0x5e, 0x0, 0x0, 0x5d,
    0x0, 0x24, 0xd7, 0x0, 0xee, 0x90,

    /* U+0496 "Җ" */
    0x4e, 0x0, 0x6, 0xc0, 0x0, 0xa9, 0x0, 0xb8,
    0x0, 0x6c, 0x0, 0x3f, 0x10, 0x2, 0xe2, 0x6,
    0xc0, 0xc, 0x70, 0x0, 0x8, 0xa0, 0x6c, 0x5,
    0xd0, 0x0, 0x0, 0x2f, 0xff, 0xff, 0xf7, 0x0,
    0x0, 0xb, 0xc2, 0x8c, 0x27, 0xe1, 0x0, 0x4,
    0xf2, 0x6, 0xc0, 0xd, 0x90, 0x0, 0xd8, 0x0,
    0x6c, 0x0, 0x3f, 0x51, 0x7e, 0x0, 0x6, 0xc0,
    0x0, 0xef, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xa0,

    /* U+0497 "җ" */
    0x6d, 0x0, 0x8a, 0x0, 0xa9, 0x0, 0xc6, 0x8,
    0xa0, 0x3e, 0x10, 0x3, 0xe0, 0x8a, 0xc, 0x60,
    0x0, 0xd, 0xff, 0xff, 0xf0, 0x0, 0x5, 0xf2,
    0x9b, 0x2d, 0x70, 0x0, 0xe6, 0x8, 0xa0, 0x4f,
    0x30, 0x8c, 0x0, 0x8a, 0x0, 0xff, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x88, 0x0, 0x0, 0x0, 0x0,
    0x4, 0x40,

    /* U+0498 "Ҙ" */
    0x19, 0xef, 0xd5, 0x1, 0xa4, 0x26, 0xf5, 0x0,
    0x0, 0x9, 0x90, 0x0, 0x1, 0xd6, 0x0, 0xff,
    0xfc, 0x0, 0x2, 0x23, 0xba, 0x0, 0x0, 0x4,
    0xf5, 0x82, 0x14, 0xdb, 0x19, 0xef, 0xf8, 0x0,
    0x0, 0xe3, 0x0, 0x0, 0xe, 0x30, 0x0,

    /* U+0499 "ҙ" */
    0x2b, 0xfe, 0xa1, 0x16, 0x22, 0xc9, 0x0, 0x0,
    0xa8, 0x0, 0xdf, 0xe1, 0x0, 0x0, 0x8b, 0x44,
    0x1, 0xac, 0x4c, 0xff, 0xc2, 0x0, 0x89, 0x0,
    0x0, 0x34, 0x0,

    /* U+049A "Қ" */
    0xb7, 0x0, 0x7, 0xd0, 0xb7, 0x0, 0x2e, 0x20,
    0xb7, 0x0, 0xb7, 0x0, 0xb7, 0x6, 0xc0, 0x0,
    0xbf, 0xff, 0x50, 0x0, 0xb8, 0x29, 0xd0, 0x0,
    0xb7, 0x0, 0xc9, 0x0, 0xb7, 0x0, 0x2f, 0x61,
    0xb7, 0x0, 0x7, 0xff, 0x0, 0x0, 0x0, 0x3e,
    0x0, 0x0, 0x0, 0x3e,

    /* U+049B "қ" */
    0xe4, 0x0, 0xa8, 0xe, 0x40, 0x5d, 0x0, 0xe4,
    0x1e, 0x30, 0xe, 0xff, 0xa0, 0x0, 0xe5, 0x3f,
    0x40, 0xe, 0x40, 0x6e, 0x20, 0xe4, 0x0, 0xef,
    0x90, 0x0, 0x0, 0x79, 0x0, 0x0, 0x3, 0x40,

    /* U+049C "Ҝ" */
    0xb7, 0x0, 0x2, 0xf2, 0xb7, 0x0, 0xb, 0x80,
    0xb7, 0xa3, 0x5e, 0x0, 0xb7, 0xa4, 0xd5, 0x0,
    0xbf, 0xff, 0xe0, 0x0, 0xb9, 0xb6, 0xe6, 0x0,
    0xb7, 0x82, 0x5f, 0x10, 0xb7, 0x0, 0xb, 0xb0,
    0xb7, 0x0, 0x1, 0xf5,

    /* U+049D "ҝ" */
    0xe4, 0x0, 0x7b, 0xe, 0x40, 0x1e, 0x20, 0xe6,
    0xb9, 0x80, 0xe, 0xff, 0xf1, 0x0, 0xe7, 0xbb,
    0x90, 0xe, 0x57, 0x1f, 0x40, 0xe4, 0x0, 0x7d,
    0x0,

    /* U+049E "Ҟ" */
    0x6, 0xc0, 0x0, 0x3f, 0x28, 0xff, 0xeb, 0xc,
    0x70, 0x6, 0xc0, 0x7, 0xc0, 0x0, 0x6c, 0x2,
    0xe2, 0x0, 0x6, 0xff, 0xf9, 0x0, 0x0, 0x6c,
    0x25, 0xf3, 0x0, 0x6, 0xc0, 0x8, 0xd0, 0x0,
    0x6c, 0x0, 0xd, 0x80, 0x6, 0xc0, 0x0, 0x2f,
    0x40,

    /* U+049F "ҟ" */
    0x9, 0x30, 0x0, 0x0, 0xef, 0xee, 0x10, 0x0,
    0xe, 0x40, 0x0, 0x0, 0xe, 0x40, 0xa, 0x80,
    0xe, 0x40, 0x5d, 0x0, 0xe, 0x41, 0xe3, 0x0,
    0xe, 0xff, 0xa0, 0x0, 0xe, 0x53, 0xf4, 0x0,
    0xe, 0x40, 0x6e, 0x10, 0xe, 0x40, 0xa, 0xb0,

    /* U+04A0 "Ҡ" */
    0xdf, 0xfe, 0x0, 0x1, 0xe3, 0x12, 0x6e, 0x0,
    0xb, 0x90, 0x0, 0x4e, 0x0, 0x5d, 0x0, 0x0,
    0x4e, 0x1, 0xe3, 0x0, 0x0, 0x4f, 0xff, 0xb0,
    0x0, 0x0, 0x4e, 0x24, 0xf4, 0x0, 0x0, 0x4e,
    0x0, 0x6e, 0x10, 0x0, 0x4e, 0x0, 0xb, 0xa0,
    0x0, 0x4e, 0x0, 0x1, 0xe5,

    /* U+04A1 "ҡ" */
    0xff, 0xf2, 0x0, 0xc6, 0x11, 0xf2, 0x7, 0xb0,
    0x0, 0xf2, 0x2e, 0x10, 0x0, 0xff, 0xf8, 0x0,
    0x0, 0xf3, 0x5f, 0x20, 0x0, 0xf2, 0x8, 0xd0,
    0x0, 0xf2, 0x0, 0xc9,

    /* U+04A2 "Ң" */
    0xb8, 0x0, 0x0, 0xb8, 0xb, 0x80, 0x0, 0xb,
    0x80, 0xb8, 0x0, 0x0, 0xb8, 0xb, 0x80, 0x0,
    0xb, 0x80, 0xbf, 0xff, 0xff, 0xf8, 0xb, 0x92,
    0x22, 0x2b, 0x80, 0xb8, 0x0, 0x0, 0xb8, 0xb,
    0x80, 0x0, 0xc, 0xa1, 0xb8, 0x0, 0x0, 0xff,
    0xd0, 0x0, 0x0, 0x0, 0x4d, 0x0, 0x0, 0x0,
    0x4, 0xd0,

    /* U+04A3 "ң" */
    0xe4, 0x0, 0x2f, 0x0, 0xe4, 0x0, 0x2f, 0x0,
    0xe4, 0x0, 0x2f, 0x0, 0xef, 0xff, 0xff, 0x0,
    0xe5, 0x22, 0x3f, 0x0, 0xe4, 0x0, 0x2f, 0x20,
    0xe4, 0x0, 0x4f, 0xf0, 0x0, 0x0, 0x0, 0xf0,
    0x0, 0x0, 0x0, 0x80,

    /* U+04A4 "Ҥ" */
    0xb8, 0x0, 0x0, 0xff, 0xff, 0xfd, 0xb8, 0x0,
    0x0, 0xff, 0x22, 0x21, 0xb8, 0x0, 0x0, 0xff,
    0x0, 0x0, 0xb8, 0x0, 0x0, 0xff, 0x0, 0x0,
    0xbf, 0xff, 0xff, 0xff, 0x0, 0x0, 0xb9, 0x22,
    0x22, 0xff, 0x0, 0x0, 0xb8, 0x0, 0x0, 0xff,
    0x0, 0x0, 0xb8, 0x0, 0x0, 0xff, 0x0, 0x0,
    0xb8, 0x0, 0x0, 0xff, 0x0, 0x0,

    /* U+04A5 "ҥ" */
    0xe4, 0x0, 0x4f, 0xff, 0xf9, 0xe4, 0x0, 0x4f,
    0x21, 0x10, 0xe4, 0x0, 0x4f, 0x10, 0x0, 0xef,
    0xff, 0xff, 0x10, 0x0, 0xe5, 0x22, 0x5f, 0x10,
    0x0, 0xe4, 0x0, 0x4f, 0x10, 0x0, 0xe4, 0x0,
    0x4f, 0x10, 0x0,

    /* U+04A6 "Ҧ" */
    0xbf, 0xff, 0xff, 0xf8, 0x0, 0x0, 0xb, 0x92,
    0x22, 0x2a, 0x80, 0x0, 0x0, 0xb8, 0x0, 0x0,
    0xa8, 0x0, 0x0, 0xb, 0x80, 0x0, 0xa, 0x80,
    0x0, 0x0, 0xb8, 0x0, 0x0, 0xac, 0xbe, 0xd6,
    0xb, 0x80, 0x0, 0xa, 0xd5, 0x26, 0xf5, 0xb8,
    0x0, 0x0, 0xa8, 0x0, 0x8, 0xcb, 0x80, 0x0,
    0xa, 0x80, 0x0, 0x5d, 0xb8, 0x0, 0x0, 0xa8,
    0x0, 0x7, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x10, 0x0,

    /* U+04A7 "ҧ" */
    0xef, 0xff, 0xfd, 0x0, 0x0, 0xe, 0x51, 0x16,
    0xd0, 0x0, 0x0, 0xe4, 0x0, 0x5d, 0x0, 0x0,
    0xe, 0x40, 0x5, 0xd0, 0x0, 0x0, 0xe4, 0x0,
    0x5e, 0xbe, 0xc4, 0xe, 0x40, 0x5, 0xe4, 0x27,
    0xf2, 0xe4, 0x0, 0x5d, 0x0, 0xd, 0x60, 0x0,
    0x0, 0x0, 0x0, 0xc6, 0x0, 0x0, 0x0, 0x2,
    0x7e, 0x10, 0x0, 0x0, 0x6, 0xfd, 0x30,

    /* U+04A8 "Ҩ" */
    0x0, 0xa5, 0x4, 0xcf, 0xd4, 0x0, 0x8d, 0x2,
    0xf8, 0x38, 0xf2, 0xf, 0x40, 0x9b, 0x0, 0xb,
    0x93, 0xf0, 0xb, 0x80, 0x0, 0x8b, 0x4e, 0x0,
    0xb7, 0x0, 0x7, 0xa2, 0xf1, 0x8, 0xa0, 0x0,
    0xb6, 0xc, 0x80, 0x2e, 0x10, 0x2d, 0x0, 0x3f,
    0x92, 0x5c, 0x3b, 0x21, 0x0, 0x2a, 0xef, 0xdb,
    0xef, 0xa0,

    /* U+04A9 "ҩ" */
    0x5, 0xb0, 0x5e, 0xfa, 0x1, 0xf4, 0x2f, 0x52,
    0xc9, 0x5d, 0x7, 0xb0, 0x5, 0xd6, 0xc0, 0x7a,
    0x0, 0x5c, 0x3f, 0x3, 0xe0, 0x9, 0x60, 0xbb,
    0x29, 0xa7, 0xb1, 0x0, 0x8e, 0xfd, 0xdf, 0xc0,

    /* U+04AA "Ҫ" */
    0x0, 0x3b, 0xff, 0xb4, 0x0, 0x4f, 0xa4, 0x38,
    0xe1, 0xd, 0x70, 0x0, 0x0, 0x4, 0xf0, 0x0,
    0x0, 0x0, 0x5d, 0x0, 0x0, 0x0, 0x4, 0xf0,
    0x0, 0x0, 0x0, 0xe, 0x70, 0x0, 0x0, 0x0,
    0x4f, 0x94, 0x38, 0xe0, 0x0, 0x3b, 0xff, 0xc3,
    0x0, 0x0, 0xb, 0x60, 0x0, 0x0, 0x0, 0xb6,
    0x0, 0x0,

    /* U+04AB "ҫ" */
    0x1, 0xbf, 0xe8, 0x0, 0xda, 0x24, 0xc3, 0x5d,
    0x0, 0x0, 0x7, 0xb0, 0x0, 0x0, 0x5d, 0x0,
    0x0, 0x0, 0xda, 0x24, 0xc3, 0x1, 0xbf, 0xf8,
    0x0, 0x0, 0xc5, 0x0, 0x0, 0x6, 0x20, 0x0,

    /* U+04AC "Ҭ" */
    0xdf, 0xff, 0xff, 0xf1, 0x12, 0x2f, 0x52, 0x20,
    0x0, 0xf, 0x30, 0x0, 0x0, 0xf, 0x30, 0x0,
    0x0, 0xf, 0x30, 0x0, 0x0, 0xf, 0x30, 0x0,
    0x0, 0xf, 0x30, 0x0, 0x0, 0xf, 0x51, 0x0,
    0x0, 0xf, 0xf7, 0x0, 0x0, 0x0, 0xa7, 0x0,
    0x0, 0x0, 0xa7, 0x0,

    /* U+04AD "ҭ" */
    0xff, 0xff, 0xfd, 0x11, 0xa9, 0x11, 0x0, 0xa8,
    0x0, 0x0, 0xa8, 0x0, 0x0, 0xa8, 0x0, 0x0,
    0xa8, 0x0, 0x0, 0xaf, 0x80, 0x0, 0x9, 0x80,
    0x0, 0x5, 0x40,

    /* U+04AE "Ү" */
    0xaa, 0x0, 0x0, 0x8a, 0x1f, 0x30, 0x2, 0xe1,
    0x8, 0xc0, 0xa, 0x80, 0x0, 0xe5, 0x3e, 0x0,
    0x0, 0x5e, 0xd5, 0x0, 0x0, 0xc, 0xc0, 0x0,
    0x0, 0x9, 0x90, 0x0, 0x0, 0x9, 0x90, 0x0,
    0x0, 0x9, 0x90, 0x0,

    /* U+04AF "ү" */
    0xb7, 0x0, 0x7, 0x95, 0xd0, 0x0, 0xd3, 0xf,
    0x30, 0x4d, 0x0, 0x99, 0xa, 0x70, 0x3, 0xe1,
    0xf1, 0x0, 0xd, 0xbb, 0x0, 0x0, 0x7f, 0x50,
    0x0, 0x2, 0xf0, 0x0, 0x0, 0x2f, 0x0, 0x0,
    0x2, 0xf0, 0x0,

    /* U+04B0 "Ұ" */
    0x9a, 0x0, 0x0, 0x8a, 0x1e, 0x40, 0x2, 0xe1,
    0x6, 0xd0, 0xc, 0x60, 0x0, 0xc7, 0x5d, 0x0,
    0x0, 0x3f, 0xe3, 0x0, 0x8, 0xef, 0xfe, 0x70,
    0x0, 0x9, 0x90, 0x0, 0x0, 0x9, 0x90, 0x0,
    0x0, 0x9, 0x90, 0x0,

    /* U+04B1 "ұ" */
    0xb7, 0x0, 0x7, 0xa6, 0xd0, 0x0, 0xd4, 0xf,
    0x20, 0x3e, 0x0, 0xa8, 0x9, 0x80, 0x4, 0xe0,
    0xe2, 0x0, 0xe, 0x9d, 0x0, 0x0, 0x9f, 0x70,
    0x2, 0xee, 0xfe, 0xe0, 0x0, 0x2f, 0x0, 0x0,
    0x2, 0xf0, 0x0,

    /* U+04B2 "Ҳ" */
    0x4f, 0x20, 0x2, 0xf4, 0x0, 0xac, 0x0, 0xd9,
    0x0, 0x1, 0xe7, 0x8e, 0x0, 0x0, 0x5, 0xff,
    0x40, 0x0, 0x0, 0xe, 0xe0, 0x0, 0x0, 0x8,
    0xde, 0x80, 0x0, 0x2, 0xf3, 0x4f, 0x20, 0x0,
    0xc9, 0x0, 0x9e, 0x20, 0x7d, 0x0, 0x0, 0xff,
    0x50, 0x0, 0x0, 0x0, 0xc5, 0x0, 0x0, 0x0,
    0xc, 0x50,

    /* U+04B3 "ҳ" */
    0x6d, 0x0, 0x5d, 0x0, 0xb8, 0x1e, 0x30, 0x1,
    0xed, 0x80, 0x0, 0x9, 0xf1, 0x0, 0x2, 0xeb,
    0x90, 0x0, 0xd6, 0x1e, 0x61, 0x8b, 0x0, 0x4f,
    0xf0, 0x0, 0x0, 0x2e, 0x0, 0x0, 0x1, 0x70,

    /* U+04B4 "Ҵ" */
    0xdf, 0xff, 0xff, 0xc0, 0x1f, 0x10, 0x12, 0x2f,
    0x52, 0x10, 0x1f, 0x10, 0x0, 0xf, 0x30, 0x0,
    0x1f, 0x10, 0x0, 0xf, 0x30, 0x0, 0x1f, 0x10,
    0x0, 0xf, 0x30, 0x0, 0x1f, 0x10, 0x0, 0xf,
    0x30, 0x0, 0x1f, 0x10, 0x0, 0xf, 0x30, 0x0,
    0x1f, 0x10, 0x0, 0xf, 0x52, 0x22, 0x3f, 0x30,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb6, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xb6,

    /* U+04B5 "ҵ" */
    0xff, 0xff, 0xf6, 0x4e, 0x1, 0x1a, 0x91, 0x4,
    0xe0, 0x0, 0x98, 0x0, 0x4e, 0x0, 0x9, 0x80,
    0x4, 0xe0, 0x0, 0x98, 0x0, 0x4e, 0x0, 0x9,
    0x91, 0x15, 0xe1, 0x0, 0x9f, 0xff, 0xff, 0xd0,
    0x0, 0x0, 0x0, 0x4d, 0x0, 0x0, 0x0, 0x2,
    0x60,

    /* U+04B6 "Ҷ" */
    0x5d, 0x0, 0x0, 0xa8, 0x5, 0xd0, 0x0, 0xa,
    0x80, 0x5d, 0x0, 0x0, 0xa8, 0x4, 0xe0, 0x0,
    0xa, 0x80, 0x1f, 0x80, 0x3, 0xd8, 0x0, 0x4e,
    0xff, 0xde, 0x80, 0x0, 0x1, 0x10, 0xa8, 0x0,
    0x0, 0x0, 0xc, 0xa1, 0x0, 0x0, 0x0, 0xff,
    0xc0, 0x0, 0x0, 0x0, 0x5c, 0x0, 0x0, 0x0,
    0x5, 0xc0,

    /* U+04B7 "ҷ" */
    0x8a, 0x0, 0xf, 0x30, 0x8a, 0x0, 0xf, 0x30,
    0x7a, 0x0, 0xf, 0x30, 0x5e, 0x10, 0x3f, 0x30,
    0xa, 0xff, 0xcf, 0x30, 0x0, 0x0, 0xf, 0x40,
    0x0, 0x0, 0xf, 0xf2, 0x0, 0x0, 0x0, 0xe2,
    0x0, 0x0, 0x0, 0x71,

    /* U+04B8 "Ҹ" */
    0x5d, 0x0, 0x0, 0xa8, 0x5d, 0x0, 0x0, 0xa8,
    0x5d, 0x0, 0x0, 0xa8, 0x4f, 0x7, 0x70, 0xa8,
    0xe, 0xa9, 0x86, 0xe8, 0x3, 0xcf, 0xfb, 0xd8,
    0x0, 0x7, 0x70, 0xa8, 0x0, 0x6, 0x50, 0xa8,
    0x0, 0x0, 0x0, 0xa8,

    /* U+04B9 "ҹ" */
    0x8a, 0x0, 0xf, 0x38, 0xa0, 0x0, 0xf3, 0x7b,
    0x18, 0xf, 0x33, 0xf9, 0xd9, 0xf3, 0x4, 0xae,
    0x6f, 0x30, 0x2, 0xb0, 0xf3, 0x0, 0x0, 0xf,
    0x30,

    /* U+04BA "Һ" */
    0xb8, 0x0, 0x0, 0x0, 0xb8, 0x0, 0x0, 0x0,
    0xb8, 0x0, 0x0, 0x0, 0xbc, 0xce, 0xea, 0x10,
    0xbd, 0x63, 0x4c, 0xc0, 0xb8, 0x0, 0x2, 0xf1,
    0xb8, 0x0, 0x0, 0xf2, 0xb8, 0x0, 0x0, 0xf3,
    0xb8, 0x0, 0x0, 0xf3,

    /* U+04BB "һ" */
    0xa2, 0x0, 0x0, 0xe, 0x40, 0x0, 0x0, 0xe4,
    0x0, 0x0, 0xe, 0x7d, 0xfc, 0x30, 0xee, 0x42,
    0xad, 0xe, 0x70, 0x1, 0xf1, 0xe4, 0x0, 0xf,
    0x2e, 0x40, 0x0, 0xf2, 0xe4, 0x0, 0xf, 0x2e,
    0x40, 0x0, 0xf2,

    /* U+04BC "Ҽ" */
    0x0, 0x0, 0x2a, 0xef, 0xb3, 0x0, 0x11, 0x3,
    0xfa, 0x43, 0x9f, 0x40, 0x8a, 0xc, 0x90, 0x0,
    0x7, 0xe0, 0x8b, 0x2f, 0x10, 0x0, 0x0, 0xf4,
    0x2e, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x3f,
    0x32, 0x22, 0x22, 0x20, 0x0, 0xc, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xfa, 0x43, 0x7f, 0x40,
    0x0, 0x0, 0x2a, 0xef, 0xc5, 0x0,

    /* U+04BD "ҽ" */
    0x0, 0x4, 0xdf, 0xd4, 0x5, 0x33, 0xf5, 0x15,
    0xf3, 0xb6, 0xa8, 0x0, 0x8, 0x95, 0xef, 0xfe,
    0xee, 0xeb, 0x0, 0xa9, 0x0, 0x0, 0x0, 0x3,
    0xf7, 0x23, 0xb1, 0x0, 0x4, 0xcf, 0xe7, 0x0,

    /* U+04BE "Ҿ" */
    0x0, 0x0, 0x2a, 0xff, 0xb3, 0x0, 0x11, 0x3,
    0xfa, 0x43, 0x9f, 0x40, 0x8a, 0xc, 0x90, 0x0,
    0x7, 0xe0, 0x8b, 0x2f, 0x10, 0x0, 0x0, 0xf3,
    0x2e, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x3f,
    0x32, 0x22, 0x22, 0x20, 0x0, 0xd, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xfa, 0x43, 0x8f, 0x40,
    0x0, 0x0, 0x2a, 0xff, 0xc5, 0x0, 0x0, 0x0,
    0x0, 0x6b, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6b,
    0x0, 0x0,

    /* U+04BF "ҿ" */
    0x0, 0x4, 0xdf, 0xd4, 0x5, 0x33, 0xf5, 0x15,
    0xf3, 0xb6, 0xa8, 0x0, 0x8, 0x95, 0xef, 0xfe,
    0xee, 0xeb, 0x0, 0xa9, 0x0, 0x0, 0x0, 0x3,
    0xf7, 0x23, 0xa1, 0x0, 0x4, 0xcf, 0xf7, 0x0,
    0x0, 0x0, 0xf1, 0x0, 0x0, 0x0, 0x7, 0x0,
    0x0,

    /* U+04C0 "Ӏ" */
    0xb8, 0xb8, 0xb8, 0xb8, 0xb8, 0xb8, 0xb8, 0xb8,
    0xb8,

    /* U+04C1 "Ӂ" */
    0x0, 0x0, 0x60, 0x5, 0x10, 0x0, 0x0, 0x0,
    0x5, 0xbb, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xe0, 0x0, 0x6c, 0x0,
    0xa, 0x90, 0xb, 0x80, 0x6, 0xc0, 0x3, 0xf1,
    0x0, 0x2e, 0x20, 0x6c, 0x0, 0xc7, 0x0, 0x0,
    0x8a, 0x6, 0xc0, 0x5d, 0x0, 0x0, 0x2, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x0, 0xbc, 0x28, 0xc2,
    0x7e, 0x10, 0x0, 0x4f, 0x20, 0x6c, 0x0, 0xd9,
    0x0, 0xd, 0x80, 0x6, 0xc0, 0x3, 0xf3, 0x7,
    0xe0, 0x0, 0x6c, 0x0, 0x9, 0xc0,

    /* U+04C2 "ӂ" */
    0x0, 0x6, 0x0, 0x60, 0x0, 0x0, 0x0, 0x4b,
    0xc6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xd0, 0x8, 0xa0, 0xa, 0x90, 0xc, 0x60,
    0x8a, 0x3, 0xe1, 0x0, 0x3e, 0x8, 0xa0, 0xc6,
    0x0, 0x0, 0xdf, 0xff, 0xff, 0x0, 0x0, 0x5f,
    0x29, 0xb2, 0xd7, 0x0, 0xe, 0x60, 0x8a, 0x4,
    0xf2, 0x8, 0xc0, 0x8, 0xa0, 0xa, 0xb0,

    /* U+04C3 "Ӄ" */
    0xb7, 0x0, 0x7, 0xd0, 0xb7, 0x0, 0x2f, 0x30,
    0xb7, 0x0, 0xb8, 0x0, 0xb7, 0x6, 0xd0, 0x0,
    0xbf, 0xff, 0x60, 0x0, 0xb9, 0x28, 0xe2, 0x0,
    0xb7, 0x0, 0xad, 0x0, 0xb7, 0x0, 0xe, 0x80,
    0xb7, 0x0, 0x5, 0xf0, 0x0, 0x0, 0x1, 0xf4,
    0x0, 0x0, 0x35, 0xf2, 0x0, 0x0, 0xdf, 0x80,

    /* U+04C4 "ӄ" */
    0xe4, 0x0, 0xa8, 0xe4, 0x5, 0xd0, 0xe4, 0x1e,
    0x30, 0xef, 0xfc, 0x0, 0xe5, 0x2d, 0x80, 0xe4,
    0x2, 0xf2, 0xe4, 0x0, 0x99, 0x0, 0x0, 0x5d,
    0x0, 0x12, 0x8b, 0x0, 0x4f, 0xe3,

    /* U+04C6 "ӆ" */
    0x5, 0xff, 0xff, 0x90, 0x6, 0xb1, 0x1a, 0x90,
    0x6, 0x90, 0x9, 0x90, 0x7, 0x80, 0x9, 0x90,
    0x9, 0x60, 0x9, 0x90, 0x1e, 0x30, 0x9, 0x90,
    0xea, 0x0, 0xf, 0xf6, 0x0, 0x0, 0x0, 0xd2,
    0x0, 0x0, 0x0, 0x70,

    /* U+04C7 "Ӈ" */
    0xb8, 0x0, 0x0, 0xb7, 0xb8, 0x0, 0x0, 0xb7,
    0xb8, 0x0, 0x0, 0xb7, 0xb8, 0x0, 0x0, 0xb7,
    0xbf, 0xff, 0xff, 0xf7, 0xb9, 0x22, 0x22, 0xc7,
    0xb8, 0x0, 0x0, 0xb7, 0xb8, 0x0, 0x0, 0xb7,
    0xb8, 0x0, 0x0, 0xb7, 0x0, 0x0, 0x0, 0xb7,
    0x0, 0x0, 0x32, 0xe5, 0x0, 0x0, 0xbf, 0xb0,

    /* U+04C8 "ӈ" */
    0xe4, 0x0, 0xf, 0x1e, 0x40, 0x0, 0xf1, 0xe4,
    0x0, 0xf, 0x1e, 0xff, 0xff, 0xf1, 0xe5, 0x22,
    0x2f, 0x1e, 0x40, 0x0, 0xf1, 0xe4, 0x0, 0xf,
    0x10, 0x0, 0x0, 0xf1, 0x0, 0x3, 0x5f, 0x0,
    0x1, 0xee, 0x60,

    /* U+04C9 "Ӊ" */
    0xb8, 0x0, 0x0, 0xb8, 0xb, 0x80, 0x0, 0xb,
    0x80, 0xb8, 0x0, 0x0, 0xb8, 0xb, 0x80, 0x0,
    0xb, 0x80, 0xbf, 0xff, 0xff, 0xf8, 0xb, 0x92,
    0x22, 0x2b, 0x80, 0xb8, 0x0, 0x0, 0xb8, 0xb,
    0x80, 0x0, 0xc, 0xa1, 0xb8, 0x0, 0x0, 0xff,
    0x90, 0x0, 0x0, 0x0, 0xb4, 0x0, 0x0, 0x0,
    0xe, 0x0,

    /* U+04CA "ӊ" */
    0xe4, 0x0, 0x2f, 0x0, 0xe4, 0x0, 0x2f, 0x0,
    0xe4, 0x0, 0x2f, 0x0, 0xef, 0xff, 0xff, 0x0,
    0xe5, 0x22, 0x3f, 0x0, 0xe4, 0x0, 0x2f, 0x20,
    0xe4, 0x0, 0x3f, 0xe0, 0x0, 0x0, 0x5, 0x90,
    0x0, 0x0, 0x4, 0x30,

    /* U+04CB "Ӌ" */
    0x6c, 0x0, 0x0, 0xb7, 0x6c, 0x0, 0x0, 0xb7,
    0x6c, 0x0, 0x0, 0xb7, 0x4e, 0x0, 0x0, 0xb7,
    0x1f, 0x80, 0x4, 0xd7, 0x4, 0xef, 0xfd, 0xe7,
    0x0, 0x1, 0x10, 0xb7, 0x0, 0x0, 0x2, 0xc7,
    0x0, 0x0, 0x2f, 0xf7, 0x0, 0x0, 0x2f, 0x0,
    0x0, 0x0, 0x2f, 0x0,

    /* U+04CC "ӌ" */
    0x8a, 0x0, 0xf, 0x28, 0xa0, 0x0, 0xf2, 0x6d,
    0x10, 0x2f, 0x20, 0xcf, 0xfc, 0xf2, 0x0, 0x0,
    0xf, 0x20, 0x0, 0x0, 0xf2, 0x0, 0x1, 0xff,
    0x20, 0x0, 0x1f, 0x0, 0x0, 0x0, 0x80, 0x0,

    /* U+04CD "Ӎ" */
    0xb8, 0x0, 0x0, 0x1, 0xf3, 0xb, 0xf2, 0x0,
    0x0, 0x9f, 0x30, 0xbe, 0xa0, 0x0, 0x2e, 0xf3,
    0xb, 0x8e, 0x30, 0xa, 0x7e, 0x30, 0xb7, 0x6c,
    0x3, 0xe0, 0xe3, 0xb, 0x70, 0xd5, 0xc5, 0xe,
    0x30, 0xb7, 0x4, 0xfc, 0x0, 0xe3, 0xb, 0x70,
    0xa, 0x30, 0xf, 0x51, 0xb7, 0x0, 0x0, 0x0,
    0xff, 0x60, 0x0, 0x0, 0x0, 0x0, 0xe1, 0x0,
    0x0, 0x0, 0x0, 0x2d, 0x0,

    /* U+04CE "ӎ" */
    0xe8, 0x0, 0x0, 0xe7, 0xe, 0xf1, 0x0, 0x7f,
    0x70, 0xea, 0x90, 0x1e, 0xb7, 0xe, 0x3e, 0x28,
    0x89, 0x70, 0xe2, 0x6b, 0xe0, 0x97, 0xe, 0x20,
    0xd6, 0xa, 0x80, 0xe2, 0x1, 0x0, 0xff, 0x60,
    0x0, 0x0, 0x0, 0xd1, 0x0, 0x0, 0x0, 0x7,
    0x0,

    /* U+04CF "ӏ" */
    0x93, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4,
    0xe4, 0xe4,

    /* U+04D0 "Ӑ" */
    0x0, 0x33, 0x2, 0x40, 0x0, 0x1, 0xab, 0xb2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0x50, 0x0, 0x0, 0xb, 0xdc, 0x0, 0x0, 0x2,
    0xf2, 0xf2, 0x0, 0x0, 0x8b, 0xa, 0x90, 0x0,
    0xe, 0x50, 0x4f, 0x10, 0x6, 0xe0, 0x0, 0xd7,
    0x0, 0xdf, 0xee, 0xef, 0xd0, 0x3f, 0x31, 0x11,
    0x2f, 0x4a, 0x90, 0x0, 0x0, 0x8b,

    /* U+04D1 "ӑ" */
    0x2, 0x30, 0x42, 0x0, 0x1, 0xab, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xbf, 0xe5, 0xf2,
    0xd, 0xa2, 0x3d, 0xf2, 0x4e, 0x0, 0x2, 0xf2,
    0x6c, 0x0, 0x0, 0xf2, 0x4e, 0x0, 0x3, 0xf2,
    0xd, 0xb2, 0x3d, 0xf2, 0x2, 0xbf, 0xe5, 0xf2,

    /* U+04D2 "Ӓ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xe0, 0xd2,
    0x0, 0x0, 0x2, 0x2, 0x0, 0x0, 0x0, 0x4f,
    0x50, 0x0, 0x0, 0xb, 0xdc, 0x0, 0x0, 0x2,
    0xf2, 0xf2, 0x0, 0x0, 0x8b, 0xa, 0x90, 0x0,
    0xe, 0x50, 0x4f, 0x10, 0x6, 0xe0, 0x0, 0xd7,
    0x0, 0xdf, 0xee, 0xef, 0xd0, 0x3f, 0x31, 0x11,
    0x2f, 0x4a, 0x90, 0x0, 0x0, 0x8b,

    /* U+04D3 "ӓ" */
    0x2, 0xc0, 0xd1, 0x0, 0x0, 0x30, 0x30, 0x0,
    0x2, 0xbf, 0xe5, 0xf2, 0xd, 0xa2, 0x3d, 0xf2,
    0x4e, 0x0, 0x2, 0xf2, 0x6c, 0x0, 0x0, 0xf2,
    0x4e, 0x0, 0x3, 0xf2, 0xd, 0xb2, 0x3d, 0xf2,
    0x2, 0xbf, 0xe5, 0xf2,

    /* U+04D4 "Ӕ" */
    0x0, 0x0, 0x3f, 0xff, 0xff, 0xfd, 0x0, 0x0,
    0xc9, 0xf3, 0x22, 0x21, 0x0, 0x5, 0xe2, 0xf1,
    0x0, 0x0, 0x0, 0xd, 0x62, 0xf1, 0x0, 0x0,
    0x0, 0x6e, 0x2, 0xff, 0xff, 0xf4, 0x0, 0xe6,
    0x2, 0xf3, 0x22, 0x20, 0x8, 0xfe, 0xee, 0xf1,
    0x0, 0x0, 0x1f, 0x51, 0x13, 0xf3, 0x22, 0x22,
    0xaa, 0x0, 0x2, 0xff, 0xff, 0xff,

    /* U+04D5 "ӕ" */
    0x8, 0xdf, 0xc2, 0x7e, 0xfa, 0x10, 0x9, 0x32,
    0x9f, 0xd3, 0x2b, 0xb0, 0x0, 0x0, 0x1f, 0x40,
    0x0, 0xf2, 0x9, 0xee, 0xef, 0xee, 0xee, 0xf4,
    0x4d, 0x0, 0x1f, 0x40, 0x0, 0x0, 0x5e, 0x32,
    0xae, 0xe4, 0x26, 0x80, 0x9, 0xee, 0xa1, 0x7d,
    0xfc, 0x30,

    /* U+04D6 "Ӗ" */
    0x5, 0x10, 0x52, 0x0, 0x4b, 0xb9, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0xff, 0xf3, 0xb9, 0x22,
    0x22, 0xb, 0x80, 0x0, 0x0, 0xb8, 0x0, 0x0,
    0xb, 0xff, 0xff, 0xa0, 0xb9, 0x22, 0x21, 0xb,
    0x80, 0x0, 0x0, 0xb9, 0x22, 0x22, 0xb, 0xff,
    0xff, 0xf6,

    /* U+04D7 "ӗ" */
    0x1, 0x50, 0x24, 0x0, 0x8, 0xbb, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x2b, 0xfd, 0x60, 0xe, 0x91,
    0x4e, 0x45, 0xd0, 0x0, 0x6b, 0x7f, 0xee, 0xee,
    0xc5, 0xd0, 0x0, 0x0, 0xd, 0xa2, 0x3a, 0x20,
    0x1b, 0xff, 0x90,

    /* U+04D8 "Ә" */
    0x0, 0x6c, 0xfe, 0xa2, 0x0, 0x6, 0xe7, 0x35,
    0xbf, 0x30, 0x0, 0x10, 0x0, 0xa, 0xd0, 0x0,
    0x0, 0x0, 0x2, 0xf2, 0x7f, 0xff, 0xff, 0xff,
    0xf3, 0x6d, 0x0, 0x0, 0x1, 0xf2, 0x1f, 0x40,
    0x0, 0x9, 0xc0, 0x6, 0xf7, 0x34, 0xaf, 0x30,
    0x0, 0x5c, 0xfe, 0xa2, 0x0,

    /* U+04D9 "ә" */
    0x4, 0xcf, 0xd6, 0x0, 0x8, 0x52, 0x4e, 0x60,
    0x0, 0x0, 0x5, 0xd0, 0x4e, 0xdd, 0xdd, 0xf0,
    0x2e, 0x0, 0x5, 0xd0, 0xc, 0xa2, 0x3e, 0x70,
    0x1, 0xaf, 0xe7, 0x0,

    /* U+04DA "Ӛ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0x57,
    0x80, 0x0, 0x0, 0x1, 0x0, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6c, 0xfe, 0xa2,
    0x0, 0x6, 0xe6, 0x35, 0xbf, 0x30, 0x0, 0x10,
    0x0, 0xa, 0xc0, 0x0, 0x0, 0x0, 0x2, 0xf1,
    0x7f, 0xff, 0xff, 0xff, 0xf3, 0x6c, 0x0, 0x0,
    0x1, 0xf1, 0x2f, 0x40, 0x0, 0x9, 0xc0, 0x7,
    0xf7, 0x34, 0xaf, 0x30, 0x0, 0x5c, 0xfe, 0xa2,
    0x0,

    /* U+04DB "ӛ" */
    0x0, 0xb3, 0x86, 0x0, 0x3, 0x2, 0x10, 0x4,
    0xdf, 0xd6, 0x0, 0x85, 0x25, 0xe6, 0x0, 0x0,
    0x5, 0xd4, 0xed, 0xdd, 0xdf, 0x2e, 0x0, 0x5,
    0xd0, 0xca, 0x23, 0xe6, 0x1, 0xaf, 0xe7, 0x0,

    /* U+04DC "Ӝ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0x83, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x2, 0x0, 0x0, 0x4, 0xe0, 0x0, 0x6c, 0x0,
    0xa, 0x90, 0xb, 0x80, 0x6, 0xc0, 0x3, 0xf1,
    0x0, 0x2e, 0x20, 0x6c, 0x0, 0xc7, 0x0, 0x0,
    0x8a, 0x6, 0xc0, 0x5d, 0x0, 0x0, 0x2, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x0, 0xbc, 0x28, 0xc2,
    0x7e, 0x10, 0x0, 0x4f, 0x20, 0x6c, 0x0, 0xd9,
    0x0, 0xd, 0x80, 0x6, 0xc0, 0x3, 0xf3, 0x7,
    0xe0, 0x0, 0x6c, 0x0, 0x9, 0xc0,

    /* U+04DD "ӝ" */
    0x0, 0x8, 0x64, 0xa0, 0x0, 0x0, 0x0, 0x21,
    0x2, 0x0, 0x0, 0x6d, 0x0, 0x8a, 0x0, 0xa9,
    0x0, 0xc6, 0x8, 0xa0, 0x3e, 0x10, 0x3, 0xe0,
    0x8a, 0xc, 0x60, 0x0, 0xd, 0xff, 0xff, 0xf0,
    0x0, 0x5, 0xf2, 0x9b, 0x2d, 0x70, 0x0, 0xe6,
    0x8, 0xa0, 0x4f, 0x20, 0x8c, 0x0, 0x8a, 0x0,
    0xab, 0x0,

    /* U+04DE "Ӟ" */
    0x0, 0x0, 0x0, 0x0, 0xc, 0x39, 0x60, 0x0,
    0x20, 0x10, 0x1, 0x9e, 0xfd, 0x50, 0x1a, 0x42,
    0x6f, 0x50, 0x0, 0x0, 0x99, 0x0, 0x0, 0x1d,
    0x60, 0xf, 0xff, 0xc0, 0x0, 0x22, 0x3b, 0xa0,
    0x0, 0x0, 0x4f, 0x58, 0x21, 0x4d, 0xb1, 0x9e,
    0xfe, 0x80,

    /* U+04DF "ӟ" */
    0x7, 0x73, 0xb0, 0x1, 0x20, 0x30, 0x2b, 0xfe,
    0xa1, 0x26, 0x22, 0xc9, 0x0, 0x0, 0xb8, 0x0,
    0xdf, 0xe1, 0x0, 0x0, 0x8b, 0x45, 0x22, 0xbb,
    0x3b, 0xee, 0xb1,

    /* U+04E0 "Ӡ" */
    0x4f, 0xff, 0xff, 0x70, 0x11, 0x15, 0xe1, 0x0,
    0x1, 0xe4, 0x0, 0x0, 0xc7, 0x0, 0x0, 0x3f,
    0xea, 0x10, 0x0, 0x2, 0xca, 0x0, 0x0, 0x6,
    0xd6, 0x94, 0x24, 0xd9, 0x19, 0xef, 0xe9, 0x0,

    /* U+04E1 "ӡ" */
    0xf, 0xff, 0xff, 0x80, 0x11, 0x14, 0xf2, 0x0,
    0x0, 0xc6, 0x0, 0x0, 0x9b, 0x0, 0x0, 0xf,
    0xfa, 0x10, 0x0, 0x1, 0xc9, 0x0, 0x0, 0x5,
    0xd0, 0x10, 0x0, 0x6d, 0x1e, 0x63, 0x4e, 0x80,
    0x6d, 0xfe, 0x80,

    /* U+04E2 "Ӣ" */
    0x0, 0xcc, 0xca, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xb7, 0x0, 0x0, 0xd9, 0xb7, 0x0, 0x9, 0xf9,
    0xb7, 0x0, 0x5f, 0xb9, 0xb7, 0x1, 0xe5, 0xa9,
    0xb7, 0xc, 0xa0, 0xa9, 0xb7, 0x7d, 0x0, 0xa9,
    0xbb, 0xf3, 0x0, 0xa9, 0xbf, 0x70, 0x0, 0xa9,
    0xbc, 0x0, 0x0, 0xa9,

    /* U+04E3 "ӣ" */
    0xb, 0xcc, 0xc0, 0x0, 0x0, 0x0, 0x0, 0xe4,
    0x0, 0x3f, 0x3e, 0x40, 0x1e, 0xf3, 0xe4, 0xb,
    0x9f, 0x3e, 0x48, 0xc0, 0xf3, 0xe8, 0xe2, 0xf,
    0x3e, 0xf4, 0x0, 0xf3, 0xe8, 0x0, 0xf, 0x30,

    /* U+04E4 "Ӥ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xb4, 0x78, 0x0,
    0x0, 0x10, 0x11, 0x0, 0xb7, 0x0, 0x0, 0xd9,
    0xb7, 0x0, 0x9, 0xf9, 0xb7, 0x0, 0x5f, 0xb9,
    0xb7, 0x1, 0xe5, 0xa9, 0xb7, 0xc, 0xa0, 0xa9,
    0xb7, 0x7d, 0x0, 0xa9, 0xbb, 0xf3, 0x0, 0xa9,
    0xbf, 0x70, 0x0, 0xa9, 0xbc, 0x0, 0x0, 0xa9,

    /* U+04E5 "ӥ" */
    0x8, 0x64, 0xa0, 0x0, 0x21, 0x2, 0x0, 0xe4,
    0x0, 0x3f, 0x3e, 0x40, 0x1e, 0xf3, 0xe4, 0xb,
    0x9f, 0x3e, 0x48, 0xc0, 0xf3, 0xe8, 0xe2, 0xf,
    0x3e, 0xf4, 0x0, 0xf3, 0xe8, 0x0, 0xf, 0x30,

    /* U+04E6 "Ӧ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x75,
    0xa0, 0x0, 0x0, 0x1, 0x10, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 0xff, 0xc4,
    0x0, 0x4, 0xf9, 0x44, 0x8f, 0x60, 0xe, 0x70,
    0x0, 0x5, 0xf1, 0x4f, 0x0, 0x0, 0x0, 0xd6,
    0x6d, 0x0, 0x0, 0x0, 0xb8, 0x4f, 0x0, 0x0,
    0x0, 0xd6, 0xe, 0x70, 0x0, 0x5, 0xf1, 0x4,
    0xf9, 0x43, 0x8f, 0x60, 0x0, 0x3b, 0xff, 0xc4,
    0x0,

    /* U+04E7 "ӧ" */
    0x0, 0xb3, 0x86, 0x0, 0x0, 0x30, 0x21, 0x0,
    0x2, 0xbf, 0xe8, 0x0, 0xd, 0xa2, 0x3d, 0x80,
    0x5d, 0x0, 0x3, 0xf0, 0x7b, 0x0, 0x0, 0xf1,
    0x5d, 0x0, 0x3, 0xf0, 0xd, 0xa2, 0x4e, 0x80,
    0x2, 0xbf, 0xe8, 0x0,

    /* U+04E8 "Ө" */
    0x0, 0x3b, 0xff, 0xc4, 0x0, 0x4, 0xfa, 0x44,
    0x8f, 0x60, 0xd, 0x80, 0x0, 0x5, 0xf1, 0x4f,
    0x0, 0x0, 0x0, 0xd6, 0x5f, 0xee, 0xee, 0xee,
    0xf8, 0x4f, 0x21, 0x11, 0x11, 0xd6, 0xd, 0x70,
    0x0, 0x4, 0xf1, 0x4, 0xf9, 0x43, 0x8f, 0x60,
    0x0, 0x3b, 0xff, 0xc4, 0x0,

    /* U+04E9 "ө" */
    0x1, 0xbf, 0xe9, 0x0, 0xd, 0x91, 0x1b, 0xa0,
    0x5d, 0x0, 0x1, 0xf1, 0x7f, 0xee, 0xee, 0xf3,
    0x5d, 0x0, 0x1, 0xf1, 0xd, 0x91, 0x2b, 0xa0,
    0x1, 0xaf, 0xe9, 0x0,

    /* U+04EA "Ӫ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x75,
    0xa0, 0x0, 0x0, 0x1, 0x10, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3b, 0xff, 0xc4,
    0x0, 0x4, 0xf9, 0x44, 0x8f, 0x60, 0xe, 0x70,
    0x0, 0x5, 0xf1, 0x4f, 0x0, 0x0, 0x0, 0xe6,
    0x6f, 0xee, 0xee, 0xee, 0xf8, 0x4f, 0x21, 0x11,
    0x11, 0xd6, 0xe, 0x60, 0x0, 0x4, 0xf1, 0x4,
    0xf9, 0x43, 0x8f, 0x60, 0x0, 0x3b, 0xff, 0xc4,
    0x0,

    /* U+04EB "ӫ" */
    0x0, 0xb4, 0x77, 0x0, 0x0, 0x30, 0x11, 0x0,
    0x2, 0xbf, 0xe9, 0x0, 0xd, 0x90, 0x1b, 0xa0,
    0x5d, 0x0, 0x1, 0xf1, 0x7f, 0xee, 0xee, 0xf3,
    0x5d, 0x0, 0x1, 0xf1, 0xd, 0x81, 0x2b, 0xa0,
    0x1, 0xaf, 0xe9, 0x0,

    /* U+04EC "Ӭ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc3, 0x97, 0x0,
    0x0, 0x20, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xdf, 0xe8, 0x0, 0x6d, 0x53, 0x5e, 0xc0,
    0x0, 0x0, 0x1, 0xf6, 0x0, 0x0, 0x0, 0x9b,
    0x0, 0x7f, 0xff, 0xfd, 0x0, 0x2, 0x22, 0x9b,
    0x0, 0x0, 0x0, 0xe6, 0x6c, 0x53, 0x5d, 0xc0,
    0x7, 0xdf, 0xe8, 0x0,

    /* U+04ED "ӭ" */
    0x7, 0x73, 0xb0, 0x0, 0x12, 0x3, 0x0, 0x2b,
    0xfe, 0x91, 0x5, 0x71, 0x2b, 0xc0, 0x0, 0x0,
    0xe, 0x30, 0xd, 0xee, 0xf5, 0x0, 0x0, 0xe,
    0x35, 0x71, 0x2b, 0xc0, 0x1b, 0xfe, 0x91, 0x0,

    /* U+04EE "Ӯ" */
    0x0, 0xbc, 0xcc, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9b, 0x0, 0x0, 0x4e, 0x1, 0xf3, 0x0,
    0xc, 0x60, 0x8, 0xa0, 0x4, 0xd0, 0x0, 0x1f,
    0x20, 0xc6, 0x0, 0x0, 0x8a, 0x4d, 0x0, 0x0,
    0x1, 0xfd, 0x50, 0x0, 0x0, 0x9, 0xd0, 0x0,
    0x0, 0x23, 0xe4, 0x0, 0x0, 0xd, 0xf7, 0x0,
    0x0, 0x0,

    /* U+04EF "ӯ" */
    0x0, 0x8c, 0xcc, 0x20, 0x0, 0x0, 0x0, 0x0,
    0xc, 0x60, 0x0, 0x89, 0x6, 0xc0, 0x0, 0xe3,
    0x0, 0xf2, 0x4, 0xd0, 0x0, 0xa8, 0xa, 0x60,
    0x0, 0x3e, 0x1f, 0x10, 0x0, 0xd, 0xba, 0x0,
    0x0, 0x7, 0xf4, 0x0, 0x0, 0x4, 0xe0, 0x0,
    0x5, 0x2b, 0x70, 0x0, 0xc, 0xfa, 0x0, 0x0,

    /* U+04F0 "Ӱ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0x75, 0xa0,
    0x0, 0x0, 0x10, 0x1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9b, 0x0, 0x0, 0x4e, 0x1, 0xf3,
    0x0, 0xc, 0x60, 0x8, 0xa0, 0x4, 0xd0, 0x0,
    0x1f, 0x20, 0xc6, 0x0, 0x0, 0x8a, 0x4d, 0x0,
    0x0, 0x1, 0xfd, 0x50, 0x0, 0x0, 0x9, 0xd0,
    0x0, 0x0, 0x23, 0xe4, 0x0, 0x0, 0xd, 0xf7,
    0x0, 0x0, 0x0,

    /* U+04F1 "ӱ" */
    0x0, 0x59, 0x2c, 0x0, 0x0, 0x12, 0x3, 0x0,
    0xc, 0x60, 0x0, 0x89, 0x6, 0xc0, 0x0, 0xe3,
    0x0, 0xf2, 0x4, 0xd0, 0x0, 0xa8, 0xa, 0x60,
    0x0, 0x3e, 0x1f, 0x10, 0x0, 0xd, 0xba, 0x0,
    0x0, 0x7, 0xf4, 0x0, 0x0, 0x4, 0xe0, 0x0,
    0x5, 0x2b, 0x70, 0x0, 0xc, 0xfa, 0x0, 0x0,

    /* U+04F2 "Ӳ" */
    0x0, 0x6, 0x65, 0x70, 0x0, 0x2, 0xd2, 0xd1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xb0, 0x0,
    0x4, 0xe0, 0x1f, 0x30, 0x0, 0xc6, 0x0, 0x8a,
    0x0, 0x4d, 0x0, 0x1, 0xf2, 0xc, 0x60, 0x0,
    0x8, 0xa4, 0xd0, 0x0, 0x0, 0x1f, 0xd5, 0x0,
    0x0, 0x0, 0x9d, 0x0, 0x0, 0x2, 0x3e, 0x40,
    0x0, 0x0, 0xdf, 0x70, 0x0, 0x0,

    /* U+04F3 "ӳ" */
    0x0, 0x8, 0xa6, 0xb0, 0x0, 0x9, 0x19, 0x10,
    0xc, 0x60, 0x0, 0x89, 0x6, 0xc0, 0x0, 0xe3,
    0x0, 0xf2, 0x4, 0xd0, 0x0, 0xa8, 0xa, 0x60,
    0x0, 0x3e, 0x1f, 0x10, 0x0, 0xd, 0xba, 0x0,
    0x0, 0x7, 0xf4, 0x0, 0x0, 0x4, 0xe0, 0x0,
    0x5, 0x2b, 0x70, 0x0, 0xc, 0xfa, 0x0, 0x0,

    /* U+04F4 "Ӵ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x87, 0x5b, 0x0,
    0x0, 0x11, 0x1, 0x0, 0x5d, 0x0, 0x0, 0xa8,
    0x5d, 0x0, 0x0, 0xa8, 0x5d, 0x0, 0x0, 0xa8,
    0x4e, 0x0, 0x0, 0xa8, 0x1f, 0x80, 0x3, 0xd8,
    0x4, 0xef, 0xfd, 0xe8, 0x0, 0x1, 0x10, 0xa8,
    0x0, 0x0, 0x0, 0xa8, 0x0, 0x0, 0x0, 0xa8,

    /* U+04F5 "ӵ" */
    0x4, 0xa1, 0xd0, 0x0, 0x2, 0x3, 0x0, 0x8a,
    0x0, 0xf, 0x38, 0xa0, 0x0, 0xf3, 0x7a, 0x0,
    0xf, 0x35, 0xe1, 0x3, 0xf3, 0xa, 0xff, 0xcf,
    0x30, 0x0, 0x0, 0xf3, 0x0, 0x0, 0xf, 0x30,

    /* U+04F6 "Ӷ" */
    0xbf, 0xff, 0xfc, 0xb8, 0x22, 0x21, 0xb7, 0x0,
    0x0, 0xb7, 0x0, 0x0, 0xb7, 0x0, 0x0, 0xb7,
    0x0, 0x0, 0xb7, 0x0, 0x0, 0xc9, 0x10, 0x0,
    0xff, 0xc0, 0x0, 0x5, 0xc0, 0x0, 0x5, 0xc0,
    0x0,

    /* U+04F7 "ӷ" */
    0xef, 0xff, 0xce, 0x51, 0x11, 0xe4, 0x0, 0xe,
    0x40, 0x0, 0xe4, 0x0, 0xf, 0x50, 0x0, 0xff,
    0x40, 0x0, 0xd4, 0x0, 0x6, 0x20, 0x0,

    /* U+04F8 "Ӹ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0x56,
    0x90, 0x0, 0x0, 0x1, 0x0, 0x10, 0x0, 0xb7,
    0x0, 0x0, 0x0, 0x99, 0xb7, 0x0, 0x0, 0x0,
    0x99, 0xb7, 0x0, 0x0, 0x0, 0x99, 0xbf, 0xee,
    0xd9, 0x10, 0x99, 0xb8, 0x11, 0x3c, 0xb0, 0x99,
    0xb7, 0x0, 0x3, 0xf0, 0x99, 0xb7, 0x0, 0x3,
    0xf0, 0x99, 0xb8, 0x0, 0x2c, 0xa0, 0x99, 0xbf,
    0xff, 0xe9, 0x10, 0x99,

    /* U+04F9 "ӹ" */
    0x0, 0x95, 0x68, 0x0, 0x0, 0x21, 0x12, 0x0,
    0xe4, 0x0, 0x0, 0x98, 0xe4, 0x0, 0x0, 0x98,
    0xee, 0xed, 0x70, 0x98, 0xe4, 0x2, 0xe3, 0x98,
    0xe4, 0x0, 0xc6, 0x98, 0xe4, 0x2, 0xf3, 0x98,
    0xef, 0xfe, 0x70, 0x98,

    /* U+04FA "Ӻ" */
    0x6, 0xff, 0xff, 0xf2, 0x6, 0xd2, 0x22, 0x20,
    0x6, 0xd0, 0x0, 0x0, 0x6, 0xd0, 0x0, 0x0,
    0x6, 0xd0, 0x0, 0x0, 0xaf, 0xff, 0xff, 0x50,
    0x6, 0xd0, 0x0, 0x0, 0x6, 0xd2, 0x0, 0x0,
    0x6, 0xff, 0x0, 0x0, 0x0, 0x2f, 0x0, 0x0,
    0x2, 0x7e, 0x0, 0x0, 0x3e, 0xe4, 0x0, 0x0,

    /* U+04FB "ӻ" */
    0x9, 0xff, 0xf9, 0x9, 0x91, 0x11, 0x9, 0x90,
    0x0, 0x9, 0x90, 0x0, 0x8f, 0xfe, 0xe1, 0x9,
    0x90, 0x0, 0x9, 0xe6, 0x0, 0x0, 0xa8, 0x0,
    0x21, 0xd6, 0x0, 0x9f, 0xb0, 0x0,

    /* U+04FC "Ӽ" */
    0x5f, 0x10, 0x1, 0xe5, 0xa, 0xb0, 0xa, 0xa0,
    0x1, 0xe6, 0x4e, 0x10, 0x0, 0x4f, 0xe4, 0x0,
    0x0, 0xd, 0xe0, 0x0, 0x0, 0x7d, 0xc9, 0x0,
    0x2, 0xf3, 0x2f, 0x40, 0xc, 0x80, 0x8, 0xd0,
    0x7d, 0x0, 0x0, 0xe6, 0x0, 0x0, 0x0, 0xaa,
    0x0, 0x0, 0x11, 0xc9, 0x0, 0x0, 0x7f, 0xc1,

    /* U+04FD "ӽ" */
    0x6d, 0x0, 0x5e, 0x0, 0xb9, 0x1e, 0x40, 0x1,
    0xed, 0x80, 0x0, 0x9, 0xf2, 0x0, 0x2, 0xfb,
    0xc0, 0x0, 0xc7, 0xd, 0x60, 0x8c, 0x0, 0x3e,
    0x0, 0x0, 0x0, 0xe4, 0x0, 0x2, 0x2e, 0x40,
    0x0, 0xbf, 0x90,

    /* U+04FE "Ӿ" */
    0x2f, 0x30, 0x1, 0xe5, 0x8, 0xd0, 0xa, 0xb0,
    0x0, 0xd8, 0x5f, 0x10, 0x0, 0x4f, 0xe6, 0x0,
    0xd, 0xff, 0xff, 0xf0, 0x0, 0x5f, 0xd9, 0x0,
    0x1, 0xe6, 0x3f, 0x40, 0xa, 0xb0, 0x8, 0xd0,
    0x5e, 0x10, 0x0, 0xd9,

    /* U+04FF "ӿ" */
    0x4e, 0x10, 0x2e, 0x20, 0x9b, 0xd, 0x60, 0x0,
    0xec, 0xb0, 0x0, 0xdf, 0xfe, 0xb0, 0x1, 0xeb,
    0xd0, 0x0, 0xb9, 0xc, 0x80, 0x6d, 0x0, 0x2f,
    0x30,

    /* U+0510 "Ԑ" */
    0x0, 0x9e, 0xfd, 0x70, 0xa, 0xd4, 0x36, 0xa0,
    0xe, 0x40, 0x0, 0x0, 0xb, 0x90, 0x0, 0x0,
    0x2, 0xff, 0xfb, 0x0, 0xe, 0x72, 0x21, 0x0,
    0x4f, 0x0, 0x0, 0x0, 0x1e, 0x93, 0x14, 0xb1,
    0x2, 0xbe, 0xfd, 0x70,

    /* U+0511 "ԑ" */
    0x5, 0xdf, 0xd8, 0x1, 0xf6, 0x13, 0x50, 0x1f,
    0x30, 0x0, 0x0, 0x7f, 0xe6, 0x0, 0x3e, 0x10,
    0x0, 0x3, 0xf5, 0x13, 0x80, 0x6, 0xdf, 0xd8,
    0x0,

    /* U+0512 "Ԓ" */
    0x0, 0xcf, 0xff, 0xff, 0x20, 0xc, 0x52, 0x22,
    0xf2, 0x0, 0xd3, 0x0, 0xf, 0x20, 0xd, 0x30,
    0x0, 0xf2, 0x0, 0xe2, 0x0, 0xf, 0x20, 0xf,
    0x0, 0x0, 0xf2, 0x3, 0xe0, 0x0, 0xf, 0x23,
    0xba, 0x0, 0x0, 0xf2, 0xcd, 0x20, 0x0, 0xf,
    0x20, 0x0, 0x0, 0x0, 0xf2, 0x0, 0x0, 0x3,
    0x5f, 0x10, 0x0, 0x1, 0xee, 0x70,

    /* U+0513 "ԓ" */
    0x5, 0xff, 0xff, 0x90, 0x6b, 0x11, 0x99, 0x6,
    0x90, 0x9, 0x90, 0x78, 0x0, 0x99, 0x9, 0x70,
    0x9, 0x92, 0xe3, 0x0, 0x99, 0xea, 0x0, 0x9,
    0x90, 0x0, 0x0, 0x99, 0x0, 0x2, 0x1c, 0x60,
    0x0, 0x9f, 0xb0,

    /* U+051A "Ԛ" */
    0x0, 0x3b, 0xff, 0xc4, 0x0, 0x4, 0xf9, 0x44,
    0x8f, 0x60, 0xd, 0x70, 0x0, 0x5, 0xf1, 0x4f,
    0x0, 0x0, 0x0, 0xd6, 0x6d, 0x0, 0x0, 0x0,
    0xb8, 0x4f, 0x0, 0x0, 0x0, 0xd6, 0xe, 0x70,
    0x0, 0x5, 0xf1, 0x4, 0xf9, 0x33, 0x8f, 0x70,
    0x0, 0x3c, 0xff, 0xd5, 0x0, 0x0, 0x0, 0xc,
    0xb0, 0x28, 0x0, 0x0, 0x1, 0xbf, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0,

    /* U+051B "ԛ" */
    0x2, 0xbf, 0xd5, 0xf2, 0xe, 0xa2, 0x3d, 0xf2,
    0x5e, 0x0, 0x3, 0xf2, 0x6b, 0x0, 0x0, 0xf2,
    0x5e, 0x0, 0x3, 0xf2, 0xe, 0xa2, 0x3d, 0xf2,
    0x2, 0xbf, 0xd5, 0xf2, 0x0, 0x0, 0x0, 0xf2,
    0x0, 0x0, 0x0, 0xf2, 0x0, 0x0, 0x0, 0xf2,

    /* U+051C "Ԝ" */
    0x9a, 0x0, 0x2, 0xf4, 0x0, 0x8, 0xa4, 0xe0,
    0x0, 0x7f, 0x90, 0x0, 0xd5, 0xf, 0x40, 0xc,
    0x9e, 0x0, 0x2f, 0x0, 0xa9, 0x1, 0xf1, 0xe2,
    0x7, 0xb0, 0x5, 0xd0, 0x6b, 0xa, 0x70, 0xc6,
    0x0, 0x1f, 0x2b, 0x60, 0x5c, 0x1f, 0x10, 0x0,
    0xb8, 0xf1, 0x0, 0xf8, 0xc0, 0x0, 0x6, 0xfc,
    0x0, 0xb, 0xf7, 0x0, 0x0, 0x2f, 0x70, 0x0,
    0x6f, 0x20, 0x0,

    /* U+051D "ԝ" */
    0xb7, 0x0, 0x1f, 0x50, 0x2, 0xe0, 0x5d, 0x0,
    0x6f, 0xb0, 0x8, 0x90, 0xf, 0x20, 0xc6, 0xf1,
    0xd, 0x40, 0xa, 0x81, 0xf0, 0xb6, 0x3e, 0x0,
    0x5, 0xd7, 0xa0, 0x6b, 0x88, 0x0, 0x0, 0xee,
    0x40, 0xf, 0xe3, 0x0, 0x0, 0x9e, 0x0, 0xa,
    0xd0, 0x0,

    /* U+0524 "Ԥ" */
    0xbf, 0xff, 0xff, 0xf8, 0xb, 0x82, 0x22, 0x2b,
    0x80, 0xb7, 0x0, 0x0, 0xa8, 0xb, 0x70, 0x0,
    0xa, 0x80, 0xb7, 0x0, 0x0, 0xa8, 0xb, 0x70,
    0x0, 0xa, 0x80, 0xb7, 0x0, 0x0, 0xa8, 0xb,
    0x70, 0x0, 0xb, 0xa1, 0xb7, 0x0, 0x0, 0xff,
    0xd0, 0x0, 0x0, 0x0, 0x4d, 0x0, 0x0, 0x0,
    0x4, 0xd0,

    /* U+0525 "ԥ" */
    0xef, 0xff, 0xff, 0xe, 0x51, 0x13, 0xf0, 0xe4,
    0x0, 0x2f, 0xe, 0x40, 0x2, 0xf0, 0xe4, 0x0,
    0x2f, 0xe, 0x40, 0x2, 0xf1, 0xe4, 0x0, 0x5f,
    0xf0, 0x0, 0x0, 0x1f, 0x0, 0x0, 0x0, 0x70,

    /* U+0526 "Ԧ" */
    0xb7, 0x0, 0x0, 0x0, 0xb, 0x70, 0x0, 0x0,
    0x0, 0xb7, 0x0, 0x0, 0x0, 0xb, 0xbc, 0xee,
    0xa1, 0x0, 0xbd, 0x63, 0x4c, 0xc0, 0xb, 0x70,
    0x0, 0x2f, 0x10, 0xb7, 0x0, 0x0, 0xf2, 0xb,
    0x70, 0x0, 0xf, 0x51, 0xb7, 0x0, 0x0, 0xff,
    0x70, 0x0, 0x0, 0x0, 0xa7, 0x0, 0x0, 0x0,
    0xa, 0x70,

    /* U+0527 "ԧ" */
    0xa2, 0x0, 0x0, 0x0, 0xe4, 0x0, 0x0, 0x0,
    0xe4, 0x0, 0x0, 0x0, 0xe6, 0xcf, 0xd3, 0x0,
    0xee, 0x53, 0xad, 0x0, 0xe7, 0x0, 0x1f, 0x10,
    0xe4, 0x0, 0xf, 0x20, 0xe4, 0x0, 0xf, 0x20,
    0xe4, 0x0, 0xf, 0x20, 0xe4, 0x0, 0xf, 0xf1,
    0x0, 0x0, 0x0, 0xf1, 0x0, 0x0, 0x0, 0x90,

    /* U+0528 "Ԩ" */
    0x0, 0xb8, 0x0, 0x0, 0xb7, 0x0, 0xb8, 0x0,
    0x0, 0xb7, 0x0, 0xb8, 0x0, 0x0, 0xb7, 0x0,
    0xb8, 0x0, 0x0, 0xb7, 0x0, 0xbf, 0xff, 0xff,
    0xf7, 0x0, 0xb9, 0x22, 0x22, 0xc7, 0x0, 0xb8,
    0x0, 0x0, 0xb7, 0x0, 0xb8, 0x0, 0x0, 0xb7,
    0x0, 0xb8, 0x0, 0x0, 0xb7, 0x0, 0xb7, 0x0,
    0x0, 0x0, 0x32, 0xe6, 0x0, 0x0, 0x0, 0xaf,
    0xb0, 0x0, 0x0, 0x0,

    /* U+0529 "ԩ" */
    0x0, 0xe, 0x40, 0x1, 0xf1, 0x0, 0xe, 0x40,
    0x1, 0xf1, 0x0, 0xe, 0x40, 0x1, 0xf1, 0x0,
    0xe, 0xff, 0xff, 0xf1, 0x0, 0xe, 0x62, 0x23,
    0xf1, 0x0, 0xe, 0x40, 0x1, 0xf1, 0x0, 0xe,
    0x40, 0x1, 0xf1, 0x0, 0xe, 0x40, 0x0, 0x0,
    0x3, 0x2f, 0x20, 0x0, 0x0, 0xd, 0xf8, 0x0,
    0x0, 0x0,

    /* U+052E "Ԯ" */
    0x0, 0xcf, 0xff, 0xff, 0x20, 0x0, 0xc5, 0x22,
    0x2f, 0x20, 0x0, 0xd3, 0x0, 0xf, 0x20, 0x0,
    0xd3, 0x0, 0xf, 0x20, 0x0, 0xe2, 0x0, 0xf,
    0x20, 0x0, 0xf1, 0x0, 0xf, 0x20, 0x3, 0xe0,
    0x0, 0xf, 0x20, 0x3b, 0xa0, 0x0, 0xf, 0x51,
    0xcd, 0x20, 0x0, 0xf, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0xa7, 0x0, 0x0, 0x0, 0x0, 0xa7,

    /* U+052F "ԯ" */
    0x5, 0xff, 0xff, 0x90, 0x6, 0xb1, 0x1a, 0x90,
    0x6, 0x90, 0x9, 0x90, 0x7, 0x80, 0x9, 0x90,
    0x9, 0x60, 0x9, 0x90, 0x1e, 0x30, 0x9, 0x90,
    0xea, 0x0, 0xf, 0xf8, 0x0, 0x0, 0x0, 0x88,
    0x0, 0x0, 0x0, 0x44,

    /* U+2007 " " */

    /* U+2008 " " */

    /* U+2009 " " */

    /* U+200A " " */

    /* U+200B "​" */

    /* U+2010 "‐" */
    0x5f, 0xfd, 0x2, 0x22,

    /* U+2012 "‒" */
    0x6e, 0xee, 0xee, 0xeb,

    /* U+2013 "–" */
    0xee, 0xee, 0xee,

    /* U+2014 "—" */
    0xee, 0xee, 0xee, 0xee, 0xee, 0xee,

    /* U+2015 "―" */
    0xe, 0xee, 0xee, 0xee, 0xee, 0xee, 0xd0,

    /* U+2018 "‘" */
    0xc, 0x2, 0xb0, 0x6f, 0x1, 0x80,

    /* U+2019 "’" */
    0x3e, 0x2, 0xf1, 0x1b, 0x2, 0x50,

    /* U+201A "‚" */
    0x18, 0x4, 0xf1, 0xd, 0x3, 0x80,

    /* U+201C "“" */
    0xc, 0x9, 0x32, 0xb0, 0xd0, 0x6f, 0x2f, 0x42,
    0x80, 0x81,

    /* U+201D "”" */
    0x4d, 0x1e, 0x42, 0xf1, 0xd4, 0x1b, 0xc, 0x3,
    0x40, 0x70,

    /* U+201E "„" */
    0x18, 0x8, 0x14, 0xf2, 0xf5, 0xd, 0xc, 0x14,
    0x80, 0xc0,

    /* U+2020 "†" */
    0x0, 0x3e, 0x0, 0x0, 0x3, 0xe0, 0x0, 0x0,
    0x3e, 0x0, 0x9, 0xff, 0xff, 0xf5, 0x12, 0x5e,
    0x22, 0x0, 0x3, 0xe0, 0x0, 0x0, 0x3e, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x0, 0x3e, 0x0, 0x0,
    0x3, 0xe0, 0x0, 0x0, 0x3e, 0x0, 0x0, 0x3,
    0xe0, 0x0,

    /* U+2021 "‡" */
    0x0, 0x3e, 0x0, 0x0, 0x3, 0xe0, 0x0, 0x0,
    0x3e, 0x0, 0x9, 0xff, 0xff, 0xf5, 0x12, 0x5e,
    0x22, 0x0, 0x3, 0xe0, 0x0, 0x0, 0x3e, 0x0,
    0x0, 0x3, 0xe0, 0x0, 0x9f, 0xff, 0xff, 0x51,
    0x25, 0xe2, 0x20, 0x0, 0x3e, 0x0, 0x0, 0x3,
    0xe0, 0x0,

    /* U+2022 "•" */
    0x3, 0x21, 0xfd, 0xd, 0xa0,

    /* U+2026 "…" */
    0x2a, 0x5, 0x80, 0x85, 0x4d, 0x7, 0xb0, 0xa8,

    /* U+2030 "‰" */
    0xb, 0xc8, 0x0, 0xc, 0x10, 0x0, 0x0, 0x5,
    0x60, 0xa2, 0x7, 0x60, 0x0, 0x0, 0x0, 0x83,
    0x7, 0x42, 0xc0, 0x0, 0x0, 0x0, 0x5, 0x70,
    0xa2, 0xb2, 0x0, 0x0, 0x0, 0x0, 0x9, 0xc6,
    0x68, 0x5c, 0xa0, 0x1b, 0xc3, 0x0, 0x0, 0x1c,
    0x1c, 0x6, 0x79, 0x31, 0xc0, 0x0, 0xa, 0x43,
    0x90, 0x29, 0xb0, 0xb, 0x0, 0x4, 0x90, 0x1b,
    0x4, 0x7a, 0x10, 0xc0, 0x0, 0xc1, 0x0, 0x7b,
    0xb0, 0x2b, 0xb4, 0x0,

    /* U+2032 "′" */
    0x3c, 0x3b, 0x3b, 0x15,

    /* U+2033 "″" */
    0x3c, 0xe, 0x3b, 0xe, 0x3b, 0xe, 0x15, 0x7,

    /* U+2039 "‹" */
    0x0, 0x0, 0x2, 0xd1, 0xc, 0x50, 0x4c, 0x0,
    0xc, 0x50, 0x1, 0xd1,

    /* U+203A "›" */
    0x0, 0x0, 0x4c, 0x0, 0x9, 0x80, 0x1, 0xf0,
    0x9, 0x70, 0x4c, 0x0,

    /* U+2044 "⁄" */
    0x0, 0x0, 0x0, 0xc1, 0x0, 0x0, 0x8, 0x60,
    0x0, 0x0, 0x2b, 0x0, 0x0, 0x0, 0xb2, 0x0,
    0x0, 0x6, 0x70, 0x0, 0x0, 0x1c, 0x0, 0x0,
    0x0, 0xa3, 0x0, 0x0, 0x5, 0x90, 0x0, 0x0,
    0xc, 0x0, 0x0, 0x0,

    /* U+2052 "⁒" */
    0xd, 0x30, 0xd0, 0x6, 0x3, 0xa0, 0x0, 0x8,
    0x50, 0x0, 0xd, 0x0, 0x0, 0x3a, 0x0, 0x0,
    0x85, 0x0, 0x0, 0xd0, 0x0, 0x3, 0xa0, 0x52,
    0x9, 0x40, 0xb5,

    /* U+2070 "⁰" */
    0xa, 0xbb, 0x17, 0x60, 0x49, 0xa3, 0x1, 0xc7,
    0x60, 0x49, 0xa, 0xbb, 0x10,

    /* U+2074 "⁴" */
    0x0, 0xb3, 0x0, 0x77, 0x0, 0x3b, 0xa, 0x9,
    0xbb, 0xe9, 0x0, 0xd, 0x0,

    /* U+2075 "⁵" */
    0xe, 0xbb, 0x21, 0xa0, 0x0, 0x2c, 0xaa, 0x10,
    0x0, 0x67, 0x5b, 0xbb, 0x20,

    /* U+2076 "⁶" */
    0x8, 0xcb, 0x45, 0xa0, 0x0, 0x8a, 0xaa, 0x26,
    0x90, 0x3b, 0x9, 0xab, 0x40,

    /* U+2077 "⁷" */
    0x9c, 0xbc, 0xb5, 0x10, 0xa4, 0x0, 0x3c, 0x0,
    0xb, 0x30, 0x3, 0xb0, 0x0,

    /* U+2078 "⁸" */
    0x2b, 0xab, 0x37, 0x60, 0x49, 0x2e, 0xae, 0x49,
    0x40, 0x2c, 0x3b, 0xab, 0x40,

    /* U+2079 "⁹" */
    0x2b, 0xaa, 0x18, 0x40, 0x78, 0x1a, 0xa9, 0xa0,
    0x0, 0x87, 0x2b, 0xc9, 0x0,

    /* U+2080 "₀" */
    0xa, 0xbb, 0x17, 0x60, 0x49, 0xa3, 0x1, 0xc7,
    0x60, 0x49, 0xa, 0xbb, 0x10,

    /* U+2081 "₁" */
    0xa, 0xe3, 0x0, 0xa, 0x30, 0x0, 0xa3, 0x0,
    0xa, 0x30, 0xb, 0xec, 0x40,

    /* U+2082 "₂" */
    0x4b, 0xbb, 0x0, 0x0, 0x93, 0x0, 0x4b, 0x0,
    0x5a, 0x0, 0x5f, 0xbb, 0x60,

    /* U+2083 "₃" */
    0x5b, 0xbf, 0x30, 0x8, 0x60, 0x1, 0xab, 0x21,
    0x0, 0x57, 0x6c, 0xbb, 0x10,

    /* U+2084 "₄" */
    0x0, 0xb3, 0x0, 0x77, 0x0, 0x3b, 0xa, 0x9,
    0xbb, 0xe9, 0x0, 0xd, 0x0,

    /* U+2085 "₅" */
    0xe, 0xbb, 0x21, 0xa0, 0x0, 0x2c, 0xaa, 0x20,
    0x0, 0x67, 0x6b, 0xbb, 0x20,

    /* U+2086 "₆" */
    0x8, 0xcb, 0x45, 0xa0, 0x0, 0x8a, 0xaa, 0x26,
    0x90, 0x3b, 0x9, 0xab, 0x40,

    /* U+2087 "₇" */
    0x9c, 0xbc, 0xb5, 0x10, 0xa4, 0x0, 0x3c, 0x0,
    0xb, 0x30, 0x3, 0xb0, 0x0,

    /* U+2088 "₈" */
    0x2b, 0xab, 0x37, 0x60, 0x49, 0x2e, 0xae, 0x49,
    0x40, 0x2c, 0x3b, 0xab, 0x40,

    /* U+2089 "₉" */
    0x2b, 0xaa, 0x18, 0x40, 0x78, 0x1a, 0xa9, 0xa0,
    0x0, 0x87, 0x2b, 0xc9, 0x0,

    /* U+20A1 "₡" */
    0x0, 0x0, 0x29, 0x56, 0x0, 0x0, 0x39, 0x68,
    0x30, 0x0, 0xbf, 0xff, 0xf4, 0x0, 0x9e, 0x4c,
    0x3e, 0xe0, 0x1f, 0x41, 0xb3, 0x80, 0x5, 0xe0,
    0x47, 0x64, 0x0, 0x6d, 0x8, 0x3a, 0x0, 0x4,
    0xf0, 0xb0, 0xb0, 0x0, 0xd, 0x7b, 0x28, 0x0,
    0x0, 0x3f, 0xc8, 0x88, 0xe0, 0x0, 0x8c, 0xff,
    0xb3, 0x0, 0xa, 0xb, 0x0, 0x0, 0x0, 0x50,
    0x50, 0x0, 0x0,

    /* U+20A3 "₣" */
    0x6, 0xff, 0xff, 0xf8, 0x6, 0xd2, 0x22, 0x21,
    0x6, 0xc0, 0x0, 0x0, 0x6, 0xc0, 0x0, 0x0,
    0x6, 0xff, 0xff, 0xf0, 0x6, 0xd2, 0x22, 0x20,
    0x6, 0xc0, 0x0, 0x0, 0x7d, 0xfc, 0xc5, 0x0,
    0x6, 0xc0, 0x0, 0x0,

    /* U+20A4 "₤" */
    0x0, 0x1a, 0xef, 0xc4, 0x0, 0xdb, 0x43, 0x63,
    0x3, 0xf0, 0x0, 0x0, 0x7c, 0xfb, 0xbb, 0x0,
    0x5, 0xd0, 0x0, 0x0, 0x7c, 0xfb, 0xbb, 0x0,
    0x5, 0xd0, 0x0, 0x0, 0x16, 0xe2, 0x22, 0x20,
    0xaf, 0xff, 0xff, 0xf6,

    /* U+20A6 "₦" */
    0x5, 0xe1, 0x0, 0x5, 0xe0, 0x0, 0x5f, 0xc0,
    0x0, 0x5e, 0x0, 0x5, 0xed, 0x90, 0x5, 0xe0,
    0x7, 0xcf, 0xcf, 0xdb, 0xcf, 0xb2, 0x5, 0xd0,
    0x7f, 0x15, 0xe0, 0x7, 0xcf, 0xbb, 0xee, 0xcf,
    0xb2, 0x5, 0xd0, 0x1, 0xec, 0xe0, 0x0, 0x5d,
    0x0, 0x4, 0xfe, 0x0, 0x5, 0xd0, 0x0, 0x7,
    0xe0, 0x0,

    /* U+20A7 "₧" */
    0xcf, 0xff, 0xe8, 0x0, 0x4, 0x0, 0x0, 0x0,
    0x0, 0xc, 0x82, 0x25, 0xd9, 0x0, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0xc7, 0x0, 0x4, 0xf1, 0xff,
    0xff, 0x2, 0xbf, 0xea, 0xc, 0x70, 0x0, 0x4f,
    0x0, 0xf2, 0x0, 0xb9, 0x12, 0x50, 0xc7, 0x0,
    0x2c, 0xa0, 0xf, 0x20, 0xb, 0xa1, 0x0, 0xc,
    0xff, 0xff, 0xb1, 0x0, 0xf2, 0x0, 0x3d, 0xfe,
    0x70, 0xc8, 0x22, 0x0, 0x0, 0xf, 0x20, 0x0,
    0x1, 0x5f, 0x3c, 0x70, 0x0, 0x0, 0x0, 0xe5,
    0x10, 0x73, 0x2, 0xe3, 0xc7, 0x0, 0x0, 0x0,
    0x5, 0xee, 0x38, 0xdf, 0xd7, 0x0,

    /* U+20A9 "₩" */
    0x4e, 0x0, 0x0, 0x9e, 0x0, 0x0, 0x99, 0xe,
    0x40, 0x0, 0xef, 0x40, 0x0, 0xe4, 0x9, 0x90,
    0x4, 0xe9, 0x90, 0x4, 0xe0, 0x7c, 0xfb, 0xbe,
    0xec, 0xfb, 0xbe, 0xeb, 0x0, 0xf3, 0xe, 0x40,
    0xe3, 0xe, 0x40, 0x7b, 0xed, 0xcf, 0xbb, 0xed,
    0xcf, 0xbb, 0x0, 0x6d, 0x89, 0x0, 0x4d, 0x8b,
    0x0, 0x0, 0xf, 0xf4, 0x0, 0xe, 0xf5, 0x0,
    0x0, 0xb, 0xe0, 0x0, 0x9, 0xf0, 0x0,

    /* U+20AB "₫" */
    0x0, 0x0, 0x1, 0xf1, 0x0, 0x0, 0x6b, 0xbf,
    0xb2, 0x0, 0x0, 0x1, 0xf1, 0x0, 0x2b, 0xfd,
    0x5f, 0x10, 0xe, 0xa2, 0x3e, 0xf1, 0x5, 0xd0,
    0x0, 0x3f, 0x10, 0x7b, 0x0, 0x1, 0xf1, 0x5,
    0xd0, 0x0, 0x4f, 0x10, 0xe, 0xa2, 0x4d, 0xf1,
    0x0, 0x2b, 0xfd, 0x5f, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xbb, 0xbb, 0xbb, 0x10,

    /* U+20AC "€" */
    0x0, 0x4, 0xbf, 0xfb, 0x30, 0x0, 0x5f, 0x94,
    0x38, 0xe0, 0x1, 0xf6, 0x0, 0x0, 0x0, 0x7c,
    0xfb, 0xbb, 0x90, 0x0, 0x6, 0xc0, 0x0, 0x0,
    0x0, 0x7c, 0xfb, 0xbb, 0x90, 0x0, 0x1, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0x94, 0x37, 0xd0,
    0x0, 0x3, 0xbf, 0xfb, 0x30,

    /* U+20AD "₭" */
    0x6, 0xc0, 0x1, 0xd7, 0x6, 0xc0, 0xb, 0xa0,
    0x6, 0xc0, 0x9c, 0x0, 0x6, 0xc7, 0xe1, 0x0,
    0x8e, 0xff, 0xfe, 0xe0, 0x6, 0xc7, 0xe1, 0x0,
    0x6, 0xc0, 0x9c, 0x0, 0x6, 0xc0, 0xb, 0xa0,
    0x6, 0xc0, 0x1, 0xd7,

    /* U+20AE "₮" */
    0x6f, 0xff, 0xff, 0xf9, 0x2, 0x29, 0xb2, 0x21,
    0x0, 0x8, 0xb1, 0x50, 0x0, 0x8, 0xea, 0x30,
    0x0, 0x7e, 0xb3, 0x70, 0x5, 0x58, 0xe8, 0x10,
    0x1, 0x9d, 0xb0, 0x0, 0x4, 0x28, 0xb0, 0x0,
    0x0, 0x8, 0xb0, 0x0,

    /* U+20B1 "₱" */
    0x5, 0xff, 0xff, 0xb2, 0x0, 0x5, 0xe2, 0x23,
    0xae, 0x10, 0x7d, 0xfb, 0xbb, 0xbf, 0xd8, 0x7c,
    0xfb, 0xbb, 0xbf, 0xc8, 0x5, 0xd0, 0x1, 0xae,
    0x0, 0x5, 0xff, 0xff, 0xd2, 0x0, 0x5, 0xe2,
    0x21, 0x0, 0x0, 0x5, 0xd0, 0x0, 0x0, 0x0,
    0x5, 0xd0, 0x0, 0x0, 0x0,

    /* U+20B2 "₲" */
    0x0, 0x0, 0x83, 0x0, 0x0, 0x0, 0x8, 0x30,
    0x0, 0x0, 0x3b, 0xff, 0xc4, 0x0, 0x4f, 0x9a,
    0x67, 0xe1, 0xe, 0x70, 0x83, 0x0, 0x4, 0xf0,
    0x8, 0x30, 0x0, 0x6d, 0x0, 0x83, 0x8, 0x24,
    0xf0, 0x8, 0x30, 0xe3, 0xe, 0x70, 0x83, 0xe,
    0x30, 0x4f, 0x9a, 0x67, 0xf3, 0x0, 0x4b, 0xff,
    0xc5, 0x0, 0x0, 0x8, 0x30, 0x0, 0x0, 0x0,
    0x41, 0x0, 0x0,

    /* U+20B4 "₴" */
    0x6, 0xcf, 0xea, 0x10, 0x6, 0x52, 0x3b, 0xc0,
    0x0, 0x0, 0x4, 0xf0, 0xab, 0xbb, 0xbc, 0xd8,
    0x0, 0x0, 0x0, 0x0, 0xbd, 0xcb, 0xbb, 0xb8,
    0x3f, 0x10, 0x0, 0x0, 0x1f, 0x82, 0x35, 0xb0,
    0x3, 0xcf, 0xfc, 0x40,

    /* U+20B5 "₵" */
    0x0, 0x0, 0x83, 0x0, 0x0, 0x0, 0x8, 0x30,
    0x0, 0x0, 0x4c, 0xff, 0xc4, 0x0, 0x4f, 0x9a,
    0x68, 0xe0, 0xe, 0x70, 0x83, 0x0, 0x4, 0xf0,
    0x8, 0x30, 0x0, 0x6d, 0x0, 0x83, 0x0, 0x4,
    0xf0, 0x8, 0x30, 0x0, 0xe, 0x70, 0x83, 0x0,
    0x0, 0x4f, 0x9a, 0x68, 0xe0, 0x0, 0x4b, 0xff,
    0xc3, 0x0, 0x0, 0x8, 0x30, 0x0, 0x0, 0x0,
    0x41, 0x0, 0x0,

    /* U+20B8 "₸" */
    0x1c, 0xcc, 0xcc, 0xca, 0x1c, 0xcc, 0xdc, 0xca,
    0x0, 0x3, 0xf0, 0x0, 0x0, 0x3, 0xf0, 0x0,
    0x0, 0x3, 0xf0, 0x0, 0x0, 0x3, 0xf0, 0x0,
    0x0, 0x3, 0xf0, 0x0, 0x0, 0x3, 0xf0, 0x0,
    0x0, 0x3, 0xf0, 0x0,

    /* U+20B9 "₹" */
    0x46, 0x66, 0x66, 0x66, 0x2, 0x44, 0x58, 0xf7,
    0x40, 0x7b, 0xbb, 0xbe, 0xeb, 0x0, 0x0, 0x0,
    0x6c, 0x0, 0x0, 0x0, 0x2d, 0x80, 0x0, 0xae,
    0xff, 0x90, 0x0, 0x1, 0x12, 0xe5, 0x0, 0x0,
    0x0, 0x5, 0xe1, 0x0, 0x0, 0x0, 0xa, 0xa0,
    0x0,

    /* U+20BA "₺" */
    0x5, 0xd0, 0x2, 0x0, 0x0, 0x5d, 0x19, 0x90,
    0x0, 0x5, 0xfa, 0x25, 0x0, 0x4, 0xdd, 0x3b,
    0x60, 0x0, 0x36, 0xf8, 0x0, 0x18, 0x6, 0xcd,
    0x0, 0x5, 0xe0, 0x15, 0xd0, 0x0, 0xba, 0x0,
    0x5e, 0x24, 0xbe, 0x10, 0x5, 0xff, 0xd9, 0x10,
    0x0,

    /* U+20BC "₼" */
    0x0, 0x0, 0xc0, 0x0, 0x0, 0x0, 0xc, 0x0,
    0x0, 0x0, 0x9e, 0xfe, 0x80, 0x0, 0xbb, 0x3c,
    0x2b, 0xa0, 0x4e, 0x0, 0xc0, 0xe, 0x49, 0x80,
    0xc, 0x0, 0x89, 0xb6, 0x0, 0xc0, 0x6, 0xbb,
    0x60, 0xc, 0x0, 0x6b, 0xb6, 0x0, 0xc0, 0x6,
    0xbb, 0x60, 0x1, 0x0, 0x6b, 0xb6, 0x0, 0x0,
    0x6, 0xb0,

    /* U+20BD "₽" */
    0x6, 0xff, 0xfe, 0xa2, 0x0, 0x6d, 0x22, 0x3a,
    0xe0, 0x6, 0xc0, 0x0, 0xf, 0x40, 0x6c, 0x0,
    0x0, 0xe4, 0x6, 0xc0, 0x0, 0x8e, 0x10, 0x6f,
    0xff, 0xfd, 0x30, 0x6, 0xd2, 0x20, 0x0, 0x7,
    0xdf, 0xcc, 0x50, 0x0, 0x6, 0xc0, 0x0, 0x0,
    0x0,

    /* U+2113 "ℓ" */
    0x0, 0x19, 0x50, 0xa, 0x1b, 0x1, 0x90, 0xa0,
    0x36, 0x57, 0x6, 0x7c, 0x0, 0x9d, 0x10, 0x4e,
    0x20, 0x1, 0xb2, 0x8, 0x5, 0xdb, 0x30,

    /* U+2116 "№" */
    0x51, 0x0, 0x0, 0x51, 0x3, 0x63, 0xe, 0xc0,
    0x0, 0xe, 0x44, 0xa3, 0xa5, 0xef, 0x90, 0x0,
    0xe4, 0x93, 0x3, 0x9e, 0x6f, 0x60, 0xe, 0x44,
    0xb5, 0xb4, 0xe4, 0x5f, 0x30, 0xe4, 0x2, 0x52,
    0xe, 0x40, 0x8e, 0x1e, 0x43, 0xaa, 0xa4, 0xe4,
    0x0, 0xbc, 0xe4, 0x2, 0x22, 0xe, 0x40, 0x0,
    0xdf, 0x40, 0x0, 0x0, 0xe4, 0x0, 0x2, 0xf4,
    0x0, 0x0, 0x0,

    /* U+2122 "™" */
    0x23, 0x33, 0x12, 0x0, 0x0, 0x20, 0x79, 0xd8,
    0x4c, 0x60, 0x2, 0xf0, 0x2, 0xb0, 0xc, 0xc1,
    0xb, 0xe0, 0x2, 0xb0, 0xc, 0x4a, 0x66, 0xd0,
    0x2, 0xb0, 0xc, 0x18, 0xb0, 0xd0, 0x1, 0x90,
    0x9, 0x0, 0x10, 0xa0,

    /* U+2126 "Ω" */
    0x0, 0x0, 0x24, 0x20, 0x0, 0x0, 0x4, 0xdf,
    0xdf, 0xd4, 0x0, 0x5, 0xf6, 0x0, 0x6, 0xf4,
    0x0, 0xd7, 0x0, 0x0, 0x8, 0xc0, 0xf, 0x30,
    0x0, 0x0, 0x3f, 0x0, 0xf3, 0x0, 0x0, 0x4,
    0xf0, 0xb, 0x90, 0x0, 0x0, 0xaa, 0x0, 0x2e,
    0x70, 0x0, 0x8e, 0x20, 0xef, 0xff, 0x30, 0x4f,
    0xff, 0xd0,

    /* U+212A "K" */
    0x51, 0x0, 0x2, 0x60, 0xe4, 0x0, 0x2e, 0x50,
    0xe4, 0x1, 0xe6, 0x0, 0xe4, 0x1d, 0x70, 0x0,
    0xe6, 0xdd, 0x0, 0x0, 0xef, 0x9e, 0x80, 0x0,
    0xe9, 0x2, 0xf5, 0x0, 0xe4, 0x0, 0x4f, 0x30,
    0xe4, 0x0, 0x6, 0xe1,

    /* U+212B "Å" */
    0x0, 0x0, 0x58, 0x30, 0x0, 0x0, 0x0, 0x80,
    0x90, 0x0, 0x0, 0x0, 0x58, 0x30, 0x0, 0x0,
    0x0, 0x16, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x60,
    0x0, 0x0, 0x1, 0xf6, 0xd0, 0x0, 0x0, 0x8,
    0xa0, 0xe4, 0x0, 0x0, 0xe, 0x30, 0x7b, 0x0,
    0x0, 0x6c, 0x0, 0x1f, 0x30, 0x0, 0xde, 0xee,
    0xef, 0xa0, 0x5, 0xd0, 0x0, 0x2, 0xf1, 0xc,
    0x70, 0x0, 0x0, 0xb9, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+212E "℮" */
    0x0, 0x2, 0x44, 0x30, 0x0, 0x1, 0x83, 0x0,
    0x28, 0x20, 0xd, 0x10, 0x0, 0x0, 0xd1, 0x6f,
    0x10, 0x0, 0x0, 0xf8, 0x9f, 0x43, 0x33, 0x33,
    0xda, 0x8f, 0x10, 0x0, 0x0, 0x0, 0x3f, 0x10,
    0x0, 0x0, 0x0, 0x7, 0x40, 0x0, 0x2, 0x40,
    0x0, 0x34, 0x44, 0x55, 0x0,

    /* U+2153 "⅓" */
    0xb, 0xe3, 0x0, 0x0, 0xb3, 0x0, 0x0, 0xa3,
    0x0, 0x5, 0x80, 0x0, 0x0, 0xa3, 0x0, 0x1c,
    0x0, 0x0, 0x0, 0xa3, 0x0, 0x97, 0xcc, 0xd7,
    0xc, 0xdc, 0x54, 0xa0, 0x1, 0xc1, 0x0, 0x0,
    0xc, 0x10, 0xb, 0x90, 0x0, 0x0, 0x85, 0x0,
    0x4, 0x89, 0x0, 0x2, 0xb0, 0x1, 0x10, 0x1b,
    0x0, 0xc, 0x20, 0x3, 0xcb, 0xc3,

    /* U+2154 "⅔" */
    0x4c, 0xcb, 0x0, 0x0, 0xb3, 0x0, 0x0, 0x9,
    0x30, 0x5, 0x80, 0x0, 0x0, 0x4a, 0x0, 0x1c,
    0x0, 0x0, 0x7, 0x80, 0x0, 0x97, 0xcc, 0xd7,
    0x5d, 0xcc, 0x64, 0xa0, 0x1, 0xc1, 0x0, 0x0,
    0xc, 0x10, 0xb, 0x90, 0x0, 0x0, 0x85, 0x0,
    0x4, 0x89, 0x0, 0x2, 0xb0, 0x1, 0x10, 0x1b,
    0x0, 0xc, 0x20, 0x3, 0xcb, 0xc3,

    /* U+215B "⅛" */
    0xb, 0xe3, 0x0, 0x0, 0xb3, 0x0, 0x0, 0xa,
    0x30, 0x0, 0x58, 0x0, 0x0, 0x0, 0xa3, 0x0,
    0x1c, 0x0, 0x0, 0x0, 0xa, 0x30, 0x9, 0x46,
    0xba, 0x20, 0xc, 0xdc, 0x54, 0xa2, 0xb0, 0x2c,
    0x0, 0x0, 0x0, 0xc1, 0x2b, 0x2, 0xc0, 0x0,
    0x0, 0x85, 0x0, 0xcc, 0xe7, 0x0, 0x0, 0x2b,
    0x0, 0x58, 0x0, 0xd0, 0x0, 0xc, 0x20, 0x1,
    0xa9, 0xa8, 0x0,

    /* U+215C "⅜" */
    0x6c, 0xcf, 0x30, 0x0, 0xb3, 0x0, 0x0, 0x8,
    0x60, 0x0, 0x58, 0x0, 0x0, 0x0, 0x9b, 0x20,
    0x1c, 0x0, 0x0, 0x2, 0x0, 0x67, 0x9, 0x46,
    0xba, 0x20, 0x4b, 0xca, 0x14, 0xa2, 0xb0, 0x2c,
    0x0, 0x0, 0x0, 0xc1, 0x2b, 0x2, 0xc0, 0x0,
    0x0, 0x85, 0x0, 0xcc, 0xe7, 0x0, 0x0, 0x2b,
    0x0, 0x58, 0x0, 0xd0, 0x0, 0xc, 0x20, 0x1,
    0xa9, 0xa8, 0x0,

    /* U+215D "⅝" */
    0xe, 0xcc, 0x20, 0x0, 0xb3, 0x0, 0x1, 0xa0,
    0x0, 0x0, 0x58, 0x0, 0x0, 0x2c, 0xcc, 0x30,
    0x1c, 0x0, 0x0, 0x2, 0x0, 0x67, 0x9, 0x46,
    0xba, 0x20, 0x4b, 0xca, 0x14, 0xa2, 0xb0, 0x2c,
    0x0, 0x0, 0x0, 0xc1, 0x2b, 0x2, 0xc0, 0x0,
    0x0, 0x85, 0x0, 0xcc, 0xe7, 0x0, 0x0, 0x2b,
    0x0, 0x58, 0x0, 0xd0, 0x0, 0xc, 0x20, 0x1,
    0xa9, 0xa8, 0x0,

    /* U+215E "⅞" */
    0x9c, 0xcd, 0xb0, 0x0, 0xb3, 0x0, 0x6, 0x10,
    0x95, 0x0, 0x58, 0x0, 0x0, 0x0, 0x1d, 0x0,
    0x1c, 0x0, 0x0, 0x0, 0x9, 0x50, 0x9, 0x46,
    0xba, 0x20, 0x1, 0xd0, 0x4, 0xa2, 0xb0, 0x2c,
    0x0, 0x23, 0x0, 0xc1, 0x2b, 0x2, 0xc0, 0x0,
    0x0, 0x85, 0x0, 0xcc, 0xe7, 0x0, 0x0, 0x2b,
    0x0, 0x58, 0x0, 0xd0, 0x0, 0xc, 0x20, 0x1,
    0xa9, 0xa8, 0x0,

    /* U+2190 "←" */
    0x7, 0x80, 0x0, 0x2d, 0x0, 0x0, 0xaf, 0xee,
    0xe5, 0x3d, 0x0, 0x0, 0x8, 0x80, 0x0, 0x0,
    0x0, 0x0,

    /* U+2191 "↑" */
    0x3, 0xc5, 0x0, 0x7c, 0xeb, 0xa0, 0x50, 0xe1,
    0x50, 0x0, 0xe1, 0x0, 0x0, 0xe1, 0x0, 0x0,
    0x40, 0x0,

    /* U+2192 "→" */
    0x0, 0x5, 0x90, 0x0, 0x0, 0xc, 0x50, 0x2e,
    0xee, 0xed, 0x0, 0x0, 0xb, 0x60, 0x0, 0x5,
    0xb0, 0x0, 0x0, 0x0, 0x0,

    /* U+2193 "↓" */
    0x0, 0xd0, 0x0, 0xe, 0x0, 0x0, 0xe0, 0xc,
    0x5e, 0x4d, 0x1b, 0xfb, 0x10, 0x3, 0x0,

    /* U+2194 "↔" */
    0x1, 0xc1, 0x3, 0xb0, 0x0, 0xb6, 0x0, 0xa,
    0x60, 0x3f, 0xee, 0xee, 0xef, 0x0, 0xc5, 0x0,
    0x9, 0x80, 0x2, 0xd1, 0x3, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+2195 "↕" */
    0x1, 0x93, 0x0, 0x5d, 0xfd, 0x70, 0x81, 0xe1,
    0x80, 0x0, 0xe1, 0x0, 0x0, 0xe1, 0x0, 0xb4,
    0xe3, 0xc0, 0x2c, 0xfd, 0x30, 0x0, 0x50, 0x0,

    /* U+2196 "↖" */
    0x5, 0x8b, 0x24, 0xf9, 0x10, 0x78, 0xe4, 0x9,
    0x22, 0xe4, 0x10, 0x2, 0x80,

    /* U+2197 "↗" */
    0x8, 0x95, 0x10, 0x1, 0x5f, 0x90, 0x0, 0xc8,
    0xc0, 0xc, 0x80, 0xc0, 0x48, 0x0, 0x20,

    /* U+2198 "↘" */
    0x13, 0x0, 0x0, 0x3e, 0x40, 0xa0, 0x3, 0xe4,
    0xc0, 0x0, 0x3f, 0xa0, 0xa, 0xda, 0x40, 0x0,
    0x0, 0x0,

    /* U+2199 "↙" */
    0x0, 0x1, 0x68, 0x21, 0xd7, 0x77, 0xd7, 0x4,
    0xf9, 0x0, 0x18, 0xbd, 0x20,

    /* U+2202 "∂" */
    0x5, 0xcd, 0xb4, 0x0, 0x2, 0x33, 0x6e, 0x60,
    0x0, 0x0, 0x4, 0xf0, 0x0, 0x1, 0x0, 0xe4,
    0x3, 0xde, 0xe9, 0xc5, 0xe, 0x70, 0x8, 0xf5,
    0x1f, 0x10, 0x2, 0xf2, 0xe, 0x70, 0x9, 0xb0,
    0x3, 0xdf, 0xfb, 0x10, 0x0, 0x0, 0x0, 0x0,

    /* U+2205 "∅" */
    0x0, 0x0, 0x0, 0x0, 0x8, 0xc9, 0x74, 0xa,
    0x60, 0xac, 0x0, 0xd0, 0x66, 0xc0, 0xd, 0x56,
    0xc, 0x0, 0xbb, 0x6, 0x90, 0x47, 0x9c, 0x80,
    0x0, 0x0, 0x0, 0x0,

    /* U+2206 "∆" */
    0x0, 0x0, 0x26, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x50, 0x0, 0x0, 0x2, 0xf6, 0xc0, 0x0, 0x0,
    0x9, 0x90, 0xe4, 0x0, 0x0, 0x1f, 0x20, 0x7b,
    0x0, 0x0, 0x7b, 0x0, 0x1f, 0x20, 0x0, 0xe4,
    0x0, 0x9, 0xa0, 0x5, 0xd0, 0x0, 0x3, 0xf1,
    0xd, 0xff, 0xff, 0xff, 0xf8,

    /* U+220F "∏" */
    0x23, 0x33, 0x33, 0x30, 0xee, 0xee, 0xee, 0xf4,
    0xe4, 0x0, 0x0, 0xe4, 0xe4, 0x0, 0x0, 0xe4,
    0xe4, 0x0, 0x0, 0xe4, 0xe4, 0x0, 0x0, 0xe4,
    0xe4, 0x0, 0x0, 0xe4, 0xe4, 0x0, 0x0, 0xe4,
    0xe4, 0x0, 0x0, 0xe4, 0xe4, 0x0, 0x0, 0xe4,
    0xe4, 0x0, 0x0, 0xe4, 0x82, 0x0, 0x0, 0x82,

    /* U+2211 "∑" */
    0x3, 0x33, 0x33, 0x32, 0x1f, 0xfd, 0xdd, 0xd9,
    0x5, 0xe2, 0x0, 0x0, 0x0, 0x7e, 0x10, 0x0,
    0x0, 0x9, 0xc0, 0x0, 0x0, 0x0, 0xba, 0x0,
    0x0, 0x0, 0xc9, 0x0, 0x0, 0xb, 0xb0, 0x0,
    0x0, 0xac, 0x0, 0x0, 0x8, 0xc0, 0x0, 0x0,
    0x3f, 0xff, 0xff, 0xfb, 0x1, 0x11, 0x11, 0x11,

    /* U+2212 "−" */
    0x2e, 0xee, 0xee, 0x20, 0x11, 0x11, 0x10,

    /* U+2215 "∕" */
    0x0, 0x0, 0x1, 0x0, 0x0, 0x97, 0x0, 0x0,
    0xe1, 0x0, 0x4, 0xb0, 0x0, 0xa, 0x60, 0x0,
    0xe, 0x10, 0x0, 0x5b, 0x0, 0x0, 0xb5, 0x0,
    0x1, 0xe0, 0x0, 0x6, 0xa0, 0x0, 0xc, 0x40,
    0x0, 0x1e, 0x0, 0x0, 0x12, 0x0, 0x0,

    /* U+2219 "∙" */
    0x0, 0x0, 0xe5, 0x7, 0x20,

    /* U+221A "√" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0,
    0x0, 0xa6, 0x0, 0x0, 0x0, 0x0, 0xf1, 0x0,
    0x0, 0x0, 0x5, 0xb0, 0x0, 0x0, 0x0, 0xb,
    0x60, 0x2e, 0xe5, 0x0, 0xf, 0x10, 0x0, 0x7b,
    0x0, 0x6b, 0x0, 0x0, 0x1f, 0x10, 0xb5, 0x0,
    0x0, 0xb, 0x71, 0xf0, 0x0, 0x0, 0x5, 0xc6,
    0xb0, 0x0, 0x0, 0x0, 0xfd, 0x50, 0x0, 0x0,
    0x0, 0x9f, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0,
    0x0,

    /* U+221E "∞" */
    0x6, 0xb9, 0x10, 0x5b, 0xa2, 0x6, 0xc3, 0x5d,
    0x8a, 0x36, 0xd0, 0xa4, 0x0, 0x5d, 0x0, 0xc,
    0x39, 0x80, 0xb, 0xd4, 0x1, 0xe1, 0x1c, 0xde,
    0x61, 0xcd, 0xe6, 0x0, 0x1, 0x0, 0x0, 0x10,
    0x0,

    /* U+222B "∫" */
    0x0, 0x8, 0xfe, 0x0, 0x1, 0xf2, 0x10, 0x0,
    0x3f, 0x0, 0x0, 0x3, 0xf0, 0x0, 0x0, 0x3f,
    0x0, 0x0, 0x3, 0xf0, 0x0, 0x0, 0x3f, 0x0,
    0x0, 0x3, 0xf0, 0x0, 0x0, 0x3f, 0x0, 0x0,
    0x4, 0xe0, 0x0, 0x4e, 0xf7, 0x0, 0x0, 0x11,
    0x0, 0x0,

    /* U+2248 "≈" */
    0x5, 0xc8, 0x1, 0x80, 0xd1, 0x8d, 0xd5, 0x1,
    0x0, 0x11, 0x0, 0x7e, 0xa1, 0x29, 0xd, 0x6,
    0xed, 0x40, 0x0, 0x0, 0x0,

    /* U+2260 "≠" */
    0x0, 0x0, 0x24, 0x0, 0x0, 0xb, 0x40, 0x3f,
    0xff, 0xff, 0x20, 0x0, 0xb3, 0x0, 0x0, 0x4b,
    0x0, 0x2, 0xef, 0xee, 0xe2, 0x5, 0xa0, 0x0,
    0x0, 0x31, 0x0, 0x0,

    /* U+2264 "≤" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x39, 0xe2, 0x7,
    0xdc, 0x60, 0x2, 0xfa, 0x20, 0x0, 0x1, 0x7d,
    0xc6, 0x0, 0x0, 0x3, 0x92, 0x0, 0x0, 0x0,
    0x3, 0xff, 0xff, 0xf2,

    /* U+2265 "≥" */
    0x0, 0x0, 0x0, 0x2, 0xe9, 0x30, 0x0, 0x0,
    0x6c, 0xd7, 0x0, 0x0, 0x2a, 0xf2, 0x6, 0xcd,
    0x71, 0x2, 0x93, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xff, 0xff, 0xf2,

    /* U+25A0 "■" */
    0x79, 0x99, 0x8b, 0xff, 0xfe, 0xbf, 0xff, 0xeb,
    0xff, 0xfe, 0xbf, 0xff, 0xe0, 0x0, 0x0,

    /* U+25A1 "□" */
    0x8b, 0xbb, 0xaa, 0x0, 0xa, 0xa0, 0x0, 0xaa,
    0x0, 0xa, 0xbb, 0xbb, 0xd0,

    /* U+25B2 "▲" */
    0x0, 0x40, 0x0, 0x1, 0xf3, 0x0, 0x8, 0xfb,
    0x0, 0x1f, 0xff, 0x30, 0x8f, 0xff, 0xb0, 0x56,
    0x66, 0x50,

    /* U+25B3 "△" */
    0x0, 0x20, 0x0, 0x0, 0xd2, 0x0, 0x6, 0x48,
    0x0, 0x9, 0x7, 0x20, 0x62, 0x0, 0x80, 0x79,
    0x99, 0x80,

    /* U+25B6 "▶" */
    0x53, 0x0, 0x0, 0xaf, 0xa2, 0x0, 0xaf, 0xff,
    0xa1, 0xaf, 0xfc, 0x40, 0xac, 0x40, 0x0, 0x20,
    0x0, 0x0,

    /* U+25B7 "▷" */
    0x53, 0x0, 0x0, 0x87, 0x92, 0x0, 0x80, 0x6,
    0xa1, 0x80, 0x59, 0x40, 0x9a, 0x40, 0x0, 0x20,
    0x0, 0x0,

    /* U+25BC "▼" */
    0x9b, 0xbb, 0xb0, 0x5f, 0xff, 0x80, 0xd, 0xff,
    0x10, 0x5, 0xf8, 0x0, 0x0, 0xc1, 0x0, 0x0,
    0x10, 0x0,

    /* U+25BD "▽" */
    0x89, 0x99, 0xa0, 0x54, 0x1, 0x70, 0x9, 0x8,
    0x10, 0x5, 0x68, 0x0, 0x0, 0xc1, 0x0, 0x0,
    0x10, 0x0,

    /* U+25C0 "◀" */
    0x0, 0x0, 0x16, 0x0, 0x19, 0xfd, 0x9, 0xff,
    0xfd, 0x3, 0xbf, 0xfd, 0x0, 0x3, 0xbc, 0x0,
    0x0, 0x2,

    /* U+25C1 "◁" */
    0x0, 0x0, 0x16, 0x0, 0x18, 0x89, 0x9, 0x81,
    0x8, 0x3, 0x96, 0x8, 0x0, 0x3, 0x9b, 0x0,
    0x0, 0x2,

    /* U+25C6 "◆" */
    0x0, 0x3, 0x0, 0x0, 0x6, 0xf9, 0x0, 0x6,
    0xff, 0xf9, 0x5, 0xff, 0xff, 0xf8, 0x2e, 0xff,
    0xff, 0x30, 0x2e, 0xff, 0x30, 0x0, 0x2d, 0x30,
    0x0, 0x0, 0x0, 0x0,

    /* U+25C7 "◇" */
    0x0, 0x3, 0x0, 0x0, 0x6, 0xb9, 0x0, 0x6,
    0x80, 0x69, 0x5, 0x90, 0x0, 0x68, 0x2b, 0x10,
    0xa, 0x30, 0x2b, 0x2a, 0x30, 0x0, 0x2d, 0x30,
    0x0, 0x0, 0x0, 0x0,

    /* U+25CA "◊" */
    0x0, 0x22, 0x0, 0x0, 0xbb, 0x0, 0x7, 0x66,
    0x70, 0x2a, 0x0, 0xa2, 0x39, 0x0, 0x93, 0x8,
    0x45, 0x80, 0x0, 0xcc, 0x0, 0x0, 0x33, 0x0,

    /* U+27E8 "⟨" */
    0x0, 0xb4, 0x1, 0xe0, 0x7, 0x90, 0xc, 0x40,
    0x2e, 0x0, 0x7a, 0x0, 0x4d, 0x0, 0xe, 0x20,
    0x9, 0x80, 0x3, 0xd0, 0x0, 0xe2, 0x0, 0x21,

    /* U+27E9 "⟩" */
    0x4b, 0x0, 0xf, 0x10, 0xa, 0x60, 0x5, 0xc0,
    0x0, 0xf1, 0x0, 0xb6, 0x0, 0xe3, 0x3, 0xd0,
    0x8, 0x80, 0xe, 0x20, 0x3d, 0x0, 0x12, 0x0,

    /* U+A78B "Ꞌ" */
    0xf, 0x10, 0xf1, 0xf, 0x10, 0xf0, 0xf, 0x0,
    0x40,

    /* U+A78C "ꞌ" */
    0xc, 0x10, 0xf1, 0xf, 0x0, 0xf0, 0xf, 0x0,

    /* U+FB01 "ﬁ" */
    0x1, 0xcf, 0x6b, 0x70, 0x9a, 0x11, 0x43, 0xb,
    0x60, 0x0, 0xd, 0xff, 0xf3, 0xb7, 0xc, 0x60,
    0xb, 0x70, 0xc6, 0x0, 0xb7, 0xc, 0x60, 0xb,
    0x70, 0xc6, 0x0, 0xb7, 0xc, 0x60, 0xb, 0x70,
    0xc6, 0x0, 0xb7,

    /* U+FB02 "ﬂ" */
    0x1, 0xcf, 0x6b, 0x70, 0x9a, 0x11, 0xb7, 0xb,
    0x60, 0xb, 0x7d, 0xff, 0xf3, 0xb7, 0xc, 0x60,
    0xb, 0x70, 0xc6, 0x0, 0xb7, 0xc, 0x60, 0xb,
    0x70, 0xc6, 0x0, 0xb7, 0xc, 0x60, 0xb, 0x70,
    0xc6, 0x0, 0xb7
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 52, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 51, .box_w = 3, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14, .adv_w = 75, .box_w = 4, .box_h = 4, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 22, .adv_w = 135, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 63, .adv_w = 119, .box_w = 7, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 109, .adv_w = 162, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 154, .adv_w = 132, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 199, .adv_w = 40, .box_w = 2, .box_h = 4, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 203, .adv_w = 65, .box_w = 3, .box_h = 13, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 223, .adv_w = 65, .box_w = 3, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 243, .adv_w = 77, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 256, .adv_w = 112, .box_w = 7, .box_h = 6, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 277, .adv_w = 44, .box_w = 3, .box_h = 4, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 283, .adv_w = 74, .box_w = 4, .box_h = 2, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 287, .adv_w = 44, .box_w = 3, .box_h = 2, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 290, .adv_w = 68, .box_w = 6, .box_h = 13, .ofs_x = -1, .ofs_y = -1},
    {.bitmap_index = 329, .adv_w = 128, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 365, .adv_w = 71, .box_w = 4, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 383, .adv_w = 110, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 415, .adv_w = 110, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 447, .adv_w = 128, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 483, .adv_w = 110, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 515, .adv_w = 118, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 551, .adv_w = 115, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 583, .adv_w = 124, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 619, .adv_w = 118, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 651, .adv_w = 44, .box_w = 3, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 662, .adv_w = 44, .box_w = 3, .box_h = 9, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 676, .adv_w = 112, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 701, .adv_w = 112, .box_w = 7, .box_h = 5, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 719, .adv_w = 112, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 744, .adv_w = 110, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 776, .adv_w = 199, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 848, .adv_w = 141, .box_w = 10, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 893, .adv_w = 145, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 929, .adv_w = 139, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 970, .adv_w = 159, .box_w = 9, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1011, .adv_w = 129, .box_w = 7, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1043, .adv_w = 122, .box_w = 7, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1075, .adv_w = 148, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1116, .adv_w = 156, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1152, .adv_w = 60, .box_w = 2, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1161, .adv_w = 98, .box_w = 6, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1188, .adv_w = 138, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1224, .adv_w = 114, .box_w = 7, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1256, .adv_w = 183, .box_w = 10, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1301, .adv_w = 156, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1337, .adv_w = 161, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1382, .adv_w = 139, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1418, .adv_w = 161, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1478, .adv_w = 140, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1514, .adv_w = 119, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1546, .adv_w = 113, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1578, .adv_w = 152, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1614, .adv_w = 137, .box_w = 10, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1659, .adv_w = 216, .box_w = 14, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1722, .adv_w = 129, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1758, .adv_w = 124, .box_w = 9, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1799, .adv_w = 126, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1835, .adv_w = 64, .box_w = 3, .box_h = 13, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 1855, .adv_w = 68, .box_w = 6, .box_h = 13, .ofs_x = -1, .ofs_y = -1},
    {.bitmap_index = 1894, .adv_w = 64, .box_w = 3, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1914, .adv_w = 112, .box_w = 7, .box_h = 6, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 1935, .adv_w = 96, .box_w = 6, .box_h = 1, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1938, .adv_w = 115, .box_w = 4, .box_h = 2, .ofs_x = 1, .ofs_y = 8},
    {.bitmap_index = 1942, .adv_w = 131, .box_w = 8, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1970, .adv_w = 131, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2005, .adv_w = 110, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2030, .adv_w = 131, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2070, .adv_w = 118, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2095, .adv_w = 68, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2120, .adv_w = 132, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2160, .adv_w = 131, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2195, .adv_w = 54, .box_w = 3, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2210, .adv_w = 55, .box_w = 5, .box_h = 13, .ofs_x = -2, .ofs_y = -3},
    {.bitmap_index = 2243, .adv_w = 118, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2278, .adv_w = 54, .box_w = 2, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2288, .adv_w = 203, .box_w = 11, .box_h = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2327, .adv_w = 131, .box_w = 7, .box_h = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2352, .adv_w = 122, .box_w = 8, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2380, .adv_w = 131, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 2415, .adv_w = 131, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2455, .adv_w = 79, .box_w = 4, .box_h = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2469, .adv_w = 96, .box_w = 6, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2490, .adv_w = 79, .box_w = 5, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2513, .adv_w = 130, .box_w = 7, .box_h = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2538, .adv_w = 107, .box_w = 8, .box_h = 7, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2566, .adv_w = 173, .box_w = 11, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2605, .adv_w = 106, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2630, .adv_w = 107, .box_w = 8, .box_h = 10, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 2670, .adv_w = 100, .box_w = 6, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2691, .adv_w = 67, .box_w = 4, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2717, .adv_w = 57, .box_w = 2, .box_h = 13, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 2730, .adv_w = 67, .box_w = 4, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2756, .adv_w = 112, .box_w = 7, .box_h = 2, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 2763, .adv_w = 52, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2763, .adv_w = 51, .box_w = 3, .box_h = 9, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 2777, .adv_w = 110, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 2816, .adv_w = 124, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2852, .adv_w = 134, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2893, .adv_w = 136, .box_w = 10, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2938, .adv_w = 57, .box_w = 2, .box_h = 13, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 2951, .adv_w = 96, .box_w = 6, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2987, .adv_w = 115, .box_w = 5, .box_h = 3, .ofs_x = 1, .ofs_y = 7},
    {.bitmap_index = 2995, .adv_w = 154, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3045, .adv_w = 78, .box_w = 5, .box_h = 4, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 3055, .adv_w = 97, .box_w = 6, .box_h = 6, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 3073, .adv_w = 112, .box_w = 7, .box_h = 4, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 3087, .adv_w = 74, .box_w = 4, .box_h = 2, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 3091, .adv_w = 154, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3141, .adv_w = 115, .box_w = 5, .box_h = 1, .ofs_x = 1, .ofs_y = 8},
    {.bitmap_index = 3144, .adv_w = 80, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 3157, .adv_w = 112, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3185, .adv_w = 83, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 3198, .adv_w = 83, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 3211, .adv_w = 115, .box_w = 3, .box_h = 2, .ofs_x = 2, .ofs_y = 8},
    {.bitmap_index = 3214, .adv_w = 131, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 3249, .adv_w = 124, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3288, .adv_w = 51, .box_w = 3, .box_h = 2, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 3291, .adv_w = 115, .box_w = 3, .box_h = 4, .ofs_x = 2, .ofs_y = -3},
    {.bitmap_index = 3297, .adv_w = 83, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 3310, .adv_w = 80, .box_w = 5, .box_h = 4, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 3320, .adv_w = 97, .box_w = 6, .box_h = 6, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 3338, .adv_w = 199, .box_w = 13, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3403, .adv_w = 199, .box_w = 12, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3457, .adv_w = 199, .box_w = 13, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 3522, .adv_w = 110, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3557, .adv_w = 141, .box_w = 10, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3617, .adv_w = 141, .box_w = 10, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3677, .adv_w = 141, .box_w = 10, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3737, .adv_w = 141, .box_w = 10, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3797, .adv_w = 141, .box_w = 10, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3857, .adv_w = 141, .box_w = 10, .box_h = 13, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3922, .adv_w = 201, .box_w = 13, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3981, .adv_w = 139, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4035, .adv_w = 129, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4077, .adv_w = 129, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4119, .adv_w = 129, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4161, .adv_w = 129, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4203, .adv_w = 60, .box_w = 4, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4227, .adv_w = 60, .box_w = 2, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4239, .adv_w = 60, .box_w = 5, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4269, .adv_w = 60, .box_w = 4, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4293, .adv_w = 160, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4338, .adv_w = 156, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4386, .adv_w = 161, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4446, .adv_w = 161, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4506, .adv_w = 161, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4566, .adv_w = 161, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4626, .adv_w = 161, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4691, .adv_w = 112, .box_w = 5, .box_h = 6, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 4706, .adv_w = 161, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 4761, .adv_w = 152, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4809, .adv_w = 152, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4857, .adv_w = 152, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4905, .adv_w = 152, .box_w = 8, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4957, .adv_w = 124, .box_w = 9, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 5011, .adv_w = 139, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5047, .adv_w = 130, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5082, .adv_w = 115, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5122, .adv_w = 115, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5162, .adv_w = 115, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5202, .adv_w = 115, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5242, .adv_w = 115, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5282, .adv_w = 115, .box_w = 8, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5326, .adv_w = 190, .box_w = 12, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5368, .adv_w = 110, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 5403, .adv_w = 118, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5438, .adv_w = 118, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5473, .adv_w = 118, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5508, .adv_w = 118, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5543, .adv_w = 54, .box_w = 4, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 5563, .adv_w = 54, .box_w = 3, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5578, .adv_w = 54, .box_w = 5, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 5603, .adv_w = 54, .box_w = 4, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5623, .adv_w = 123, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5663, .adv_w = 131, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5698, .adv_w = 122, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5738, .adv_w = 122, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5778, .adv_w = 122, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5818, .adv_w = 122, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5858, .adv_w = 122, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5898, .adv_w = 112, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 5923, .adv_w = 122, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 5959, .adv_w = 130, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5994, .adv_w = 130, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6029, .adv_w = 130, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6064, .adv_w = 130, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6099, .adv_w = 107, .box_w = 8, .box_h = 13, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 6151, .adv_w = 131, .box_w = 7, .box_h = 13, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 6197, .adv_w = 107, .box_w = 8, .box_h = 13, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 6249, .adv_w = 141, .box_w = 10, .box_h = 11, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 6304, .adv_w = 115, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6340, .adv_w = 141, .box_w = 10, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 6400, .adv_w = 115, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6440, .adv_w = 141, .box_w = 11, .box_h = 12, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 6506, .adv_w = 115, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 6546, .adv_w = 139, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6600, .adv_w = 110, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6635, .adv_w = 139, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6689, .adv_w = 110, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6724, .adv_w = 139, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6778, .adv_w = 110, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6813, .adv_w = 139, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6867, .adv_w = 110, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6902, .adv_w = 159, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6956, .adv_w = 131, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7006, .adv_w = 160, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7051, .adv_w = 131, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7096, .adv_w = 129, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7135, .adv_w = 118, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7167, .adv_w = 129, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7209, .adv_w = 118, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7244, .adv_w = 129, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7286, .adv_w = 118, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7321, .adv_w = 129, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 7363, .adv_w = 118, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7398, .adv_w = 129, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7440, .adv_w = 118, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7475, .adv_w = 148, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7529, .adv_w = 132, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7581, .adv_w = 148, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7635, .adv_w = 132, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7687, .adv_w = 148, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7741, .adv_w = 132, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7793, .adv_w = 148, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 7852, .adv_w = 132, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7904, .adv_w = 156, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7952, .adv_w = 131, .box_w = 9, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 8006, .adv_w = 159, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8051, .adv_w = 131, .box_w = 9, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 8096, .adv_w = 60, .box_w = 5, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 8126, .adv_w = 54, .box_w = 5, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 8151, .adv_w = 60, .box_w = 4, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8173, .adv_w = 54, .box_w = 4, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8191, .adv_w = 60, .box_w = 5, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 8221, .adv_w = 54, .box_w = 4, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8241, .adv_w = 60, .box_w = 3, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8259, .adv_w = 54, .box_w = 3, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8279, .adv_w = 60, .box_w = 2, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8291, .adv_w = 54, .box_w = 2, .box_h = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8298, .adv_w = 138, .box_w = 7, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8330, .adv_w = 108, .box_w = 6, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8369, .adv_w = 98, .box_w = 6, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 8405, .adv_w = 55, .box_w = 6, .box_h = 13, .ofs_x = -2, .ofs_y = -3},
    {.bitmap_index = 8444, .adv_w = 138, .box_w = 8, .box_h = 13, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 8496, .adv_w = 118, .box_w = 7, .box_h = 14, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 8545, .adv_w = 116, .box_w = 7, .box_h = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8570, .adv_w = 114, .box_w = 6, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8606, .adv_w = 54, .box_w = 3, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8626, .adv_w = 114, .box_w = 6, .box_h = 13, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 8665, .adv_w = 54, .box_w = 2, .box_h = 14, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 8679, .adv_w = 114, .box_w = 6, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8709, .adv_w = 54, .box_w = 4, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8729, .adv_w = 114, .box_w = 6, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8756, .adv_w = 66, .box_w = 4, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8776, .adv_w = 115, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 8812, .adv_w = 56, .box_w = 5, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 8837, .adv_w = 156, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8885, .adv_w = 131, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8920, .adv_w = 156, .box_w = 8, .box_h = 13, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 8972, .adv_w = 131, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 9011, .adv_w = 156, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9059, .adv_w = 131, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9094, .adv_w = 140, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9134, .adv_w = 156, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 9182, .adv_w = 131, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 9217, .adv_w = 161, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9272, .adv_w = 122, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9308, .adv_w = 161, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9368, .adv_w = 122, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9408, .adv_w = 161, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9468, .adv_w = 122, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9508, .adv_w = 216, .box_w = 13, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9567, .adv_w = 205, .box_w = 13, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9613, .adv_w = 140, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9661, .adv_w = 79, .box_w = 4, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9681, .adv_w = 140, .box_w = 8, .box_h = 13, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 9733, .adv_w = 79, .box_w = 4, .box_h = 11, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 9755, .adv_w = 140, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 9803, .adv_w = 79, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9828, .adv_w = 119, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9870, .adv_w = 96, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9900, .adv_w = 119, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9942, .adv_w = 96, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 9972, .adv_w = 119, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 10014, .adv_w = 96, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 10044, .adv_w = 119, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10086, .adv_w = 96, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10116, .adv_w = 113, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 10158, .adv_w = 79, .box_w = 5, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 10188, .adv_w = 113, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10230, .adv_w = 79, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10255, .adv_w = 113, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10287, .adv_w = 81, .box_w = 5, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10310, .adv_w = 152, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10358, .adv_w = 130, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10393, .adv_w = 152, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10437, .adv_w = 130, .box_w = 7, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10469, .adv_w = 152, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10517, .adv_w = 130, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10552, .adv_w = 152, .box_w = 8, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10604, .adv_w = 130, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10643, .adv_w = 152, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10691, .adv_w = 130, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10726, .adv_w = 152, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 10774, .adv_w = 130, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 10809, .adv_w = 216, .box_w = 14, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10893, .adv_w = 173, .box_w = 11, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10948, .adv_w = 124, .box_w = 9, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 11002, .adv_w = 107, .box_w = 8, .box_h = 13, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 11054, .adv_w = 124, .box_w = 9, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 11108, .adv_w = 126, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11156, .adv_w = 100, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11186, .adv_w = 126, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11234, .adv_w = 100, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11264, .adv_w = 126, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11312, .adv_w = 100, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11342, .adv_w = 59, .box_w = 5, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11367, .adv_w = 31, .box_w = 2, .box_h = 2, .ofs_x = 0, .ofs_y = 8},
    {.bitmap_index = 11369, .adv_w = 141, .box_w = 10, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 11419, .adv_w = 152, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11464, .adv_w = 177, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11514, .adv_w = 82, .box_w = 4, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11534, .adv_w = 161, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11584, .adv_w = 167, .box_w = 11, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11639, .adv_w = 172, .box_w = 11, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11694, .adv_w = 55, .box_w = 4, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11716, .adv_w = 141, .box_w = 10, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 11761, .adv_w = 145, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11797, .adv_w = 111, .box_w = 6, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11824, .adv_w = 141, .box_w = 10, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 11869, .adv_w = 129, .box_w = 7, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11901, .adv_w = 126, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11937, .adv_w = 156, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11973, .adv_w = 161, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12018, .adv_w = 60, .box_w = 2, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12027, .adv_w = 138, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12063, .adv_w = 141, .box_w = 10, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 12108, .adv_w = 183, .box_w = 10, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12153, .adv_w = 156, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12189, .adv_w = 156, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12225, .adv_w = 161, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12270, .adv_w = 158, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12306, .adv_w = 139, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12342, .adv_w = 122, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12374, .adv_w = 113, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12406, .adv_w = 124, .box_w = 9, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 12447, .adv_w = 164, .box_w = 11, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12502, .adv_w = 129, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12538, .adv_w = 163, .box_w = 11, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 12593, .adv_w = 172, .box_w = 11, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12643, .adv_w = 86, .box_w = 5, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12673, .adv_w = 124, .box_w = 9, .box_h = 12, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 12727, .adv_w = 131, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12767, .adv_w = 107, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12802, .adv_w = 131, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 12844, .adv_w = 54, .box_w = 3, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12859, .adv_w = 130, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12901, .adv_w = 131, .box_w = 8, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12929, .adv_w = 133, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 12977, .adv_w = 104, .box_w = 8, .box_h = 10, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 13017, .adv_w = 129, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13053, .adv_w = 109, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13078, .adv_w = 102, .box_w = 6, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 13114, .adv_w = 131, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 13149, .adv_w = 141, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13190, .adv_w = 54, .box_w = 2, .box_h = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13197, .adv_w = 118, .box_w = 7, .box_h = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13222, .adv_w = 107, .box_w = 8, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 13258, .adv_w = 129, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 13293, .adv_w = 119, .box_w = 8, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13321, .adv_w = 95, .box_w = 6, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 13357, .adv_w = 122, .box_w = 8, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13385, .adv_w = 128, .box_w = 8, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13413, .adv_w = 121, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 13453, .adv_w = 96, .box_w = 6, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13474, .adv_w = 130, .box_w = 8, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13502, .adv_w = 103, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13527, .adv_w = 130, .box_w = 7, .box_h = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13552, .adv_w = 152, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 13607, .adv_w = 106, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 13642, .adv_w = 147, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 13696, .adv_w = 164, .box_w = 10, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13736, .adv_w = 55, .box_w = 4, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13754, .adv_w = 130, .box_w = 7, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13786, .adv_w = 122, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13826, .adv_w = 129, .box_w = 6, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13856, .adv_w = 164, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13906, .adv_w = 128, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13948, .adv_w = 128, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13990, .adv_w = 160, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14035, .adv_w = 111, .box_w = 6, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14071, .adv_w = 136, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14112, .adv_w = 122, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14148, .adv_w = 61, .box_w = 2, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14157, .adv_w = 60, .box_w = 4, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14181, .adv_w = 104, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14208, .adv_w = 228, .box_w = 14, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14271, .adv_w = 227, .box_w = 13, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14330, .adv_w = 162, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14375, .adv_w = 137, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14423, .adv_w = 158, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14471, .adv_w = 133, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14525, .adv_w = 155, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 14569, .adv_w = 146, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14610, .adv_w = 140, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14646, .adv_w = 143, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14682, .adv_w = 111, .box_w = 6, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14709, .adv_w = 154, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 14764, .adv_w = 128, .box_w = 7, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14796, .adv_w = 198, .box_w = 13, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14855, .adv_w = 123, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14891, .adv_w = 158, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14927, .adv_w = 158, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14975, .adv_w = 137, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15011, .adv_w = 152, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15052, .adv_w = 185, .box_w = 10, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15097, .adv_w = 157, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15133, .adv_w = 163, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15178, .adv_w = 158, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15214, .adv_w = 137, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15250, .adv_w = 138, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15291, .adv_w = 116, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15327, .adv_w = 133, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15368, .adv_w = 178, .box_w = 11, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15423, .adv_w = 128, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15459, .adv_w = 159, .box_w = 9, .box_h = 11, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 15509, .adv_w = 141, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15545, .adv_w = 210, .box_w = 11, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15595, .adv_w = 215, .box_w = 13, .box_h = 11, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 15667, .adv_w = 159, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15712, .adv_w = 191, .box_w = 10, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15757, .adv_w = 137, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15793, .adv_w = 136, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15829, .adv_w = 211, .box_w = 12, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 15883, .adv_w = 140, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15919, .adv_w = 113, .box_w = 8, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15947, .adv_w = 127, .box_w = 8, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15991, .adv_w = 118, .box_w = 6, .box_h = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16012, .adv_w = 94, .box_w = 5, .box_h = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16030, .adv_w = 127, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 16066, .adv_w = 121, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16091, .adv_w = 163, .box_w = 11, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16130, .adv_w = 104, .box_w = 6, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16151, .adv_w = 133, .box_w = 7, .box_h = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16176, .adv_w = 133, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16211, .adv_w = 115, .box_w = 7, .box_h = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16236, .adv_w = 123, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16261, .adv_w = 153, .box_w = 8, .box_h = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16289, .adv_w = 131, .box_w = 7, .box_h = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16314, .adv_w = 123, .box_w = 8, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16342, .adv_w = 130, .box_w = 7, .box_h = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16367, .adv_w = 132, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 16402, .adv_w = 110, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16427, .adv_w = 95, .box_w = 6, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16448, .adv_w = 110, .box_w = 8, .box_h = 10, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 16488, .adv_w = 155, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 16548, .adv_w = 104, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16573, .adv_w = 132, .box_w = 7, .box_h = 9, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 16605, .adv_w = 117, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16630, .adv_w = 181, .box_w = 10, .box_h = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16665, .adv_w = 181, .box_w = 11, .box_h = 9, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 16715, .adv_w = 123, .box_w = 8, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16743, .adv_w = 155, .box_w = 8, .box_h = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16771, .adv_w = 110, .box_w = 6, .box_h = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16792, .adv_w = 110, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16817, .adv_w = 168, .box_w = 9, .box_h = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 16849, .adv_w = 118, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16874, .adv_w = 121, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16909, .adv_w = 121, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16941, .adv_w = 130, .box_w = 9, .box_h = 13, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 17000, .adv_w = 94, .box_w = 5, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 17025, .adv_w = 111, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17050, .adv_w = 103, .box_w = 6, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17071, .adv_w = 54, .box_w = 3, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17086, .adv_w = 54, .box_w = 4, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17104, .adv_w = 55, .box_w = 5, .box_h = 13, .ofs_x = -2, .ofs_y = -3},
    {.bitmap_index = 17137, .adv_w = 179, .box_w = 11, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17176, .adv_w = 183, .box_w = 11, .box_h = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 17215, .adv_w = 129, .box_w = 9, .box_h = 10, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 17260, .adv_w = 115, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 17295, .adv_w = 133, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 17330, .adv_w = 110, .box_w = 8, .box_h = 13, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 17382, .adv_w = 124, .box_w = 6, .box_h = 9, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 17409, .adv_w = 156, .box_w = 10, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17459, .adv_w = 118, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17494, .adv_w = 173, .box_w = 11, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17544, .adv_w = 135, .box_w = 9, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17576, .adv_w = 163, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17621, .adv_w = 125, .box_w = 8, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17649, .adv_w = 146, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17690, .adv_w = 114, .box_w = 8, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17718, .adv_w = 164, .box_w = 9, .box_h = 14, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 17781, .adv_w = 137, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 17829, .adv_w = 142, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17874, .adv_w = 116, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17899, .adv_w = 141, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 17935, .adv_w = 134, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 17970, .adv_w = 112, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 18003, .adv_w = 89, .box_w = 5, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 18026, .adv_w = 119, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18062, .adv_w = 99, .box_w = 6, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18083, .adv_w = 135, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 18125, .adv_w = 115, .box_w = 6, .box_h = 10, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 18155, .adv_w = 205, .box_w = 13, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 18227, .adv_w = 170, .box_w = 11, .box_h = 9, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 18277, .adv_w = 123, .box_w = 7, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 18316, .adv_w = 104, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 18343, .adv_w = 145, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 18387, .adv_w = 115, .box_w = 7, .box_h = 9, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 18419, .adv_w = 142, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 18455, .adv_w = 118, .box_w = 7, .box_h = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 18480, .adv_w = 141, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18521, .adv_w = 115, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18561, .adv_w = 159, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18606, .adv_w = 129, .box_w = 8, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18634, .adv_w = 163, .box_w = 9, .box_h = 11, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 18684, .adv_w = 135, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 18720, .adv_w = 209, .box_w = 12, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 18774, .adv_w = 170, .box_w = 10, .box_h = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 18809, .adv_w = 230, .box_w = 13, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 18887, .adv_w = 187, .box_w = 11, .box_h = 10, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 18942, .adv_w = 187, .box_w = 11, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18992, .adv_w = 155, .box_w = 9, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19024, .adv_w = 138, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 19074, .adv_w = 110, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 19106, .adv_w = 116, .box_w = 8, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 19150, .adv_w = 95, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 19177, .adv_w = 128, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19213, .adv_w = 110, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 19248, .adv_w = 128, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19284, .adv_w = 110, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 19319, .adv_w = 135, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 19369, .adv_w = 104, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 19401, .adv_w = 187, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 19467, .adv_w = 148, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 19508, .adv_w = 146, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 19558, .adv_w = 122, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 19594, .adv_w = 141, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19630, .adv_w = 117, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19655, .adv_w = 141, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 19691, .adv_w = 129, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 19726, .adv_w = 190, .box_w = 12, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19780, .adv_w = 148, .box_w = 9, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19812, .adv_w = 190, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 19878, .adv_w = 148, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 19919, .adv_w = 61, .box_w = 2, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 19928, .adv_w = 198, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20006, .adv_w = 163, .box_w = 11, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20061, .adv_w = 137, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 20109, .adv_w = 115, .box_w = 6, .box_h = 10, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 20139, .adv_w = 127, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 20175, .adv_w = 156, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 20223, .adv_w = 132, .box_w = 7, .box_h = 10, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 20258, .adv_w = 163, .box_w = 9, .box_h = 11, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 20308, .adv_w = 135, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 20344, .adv_w = 141, .box_w = 8, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 20388, .adv_w = 116, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 20420, .adv_w = 192, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 20481, .adv_w = 159, .box_w = 9, .box_h = 9, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 20522, .adv_w = 54, .box_w = 2, .box_h = 10, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 20532, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20586, .adv_w = 113, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20626, .adv_w = 146, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20680, .adv_w = 113, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20716, .adv_w = 201, .box_w = 12, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20770, .adv_w = 191, .box_w = 12, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20812, .adv_w = 128, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 20854, .adv_w = 121, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20889, .adv_w = 158, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20934, .adv_w = 120, .box_w = 8, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 20962, .adv_w = 158, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21027, .adv_w = 120, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21059, .adv_w = 198, .box_w = 13, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21137, .adv_w = 163, .box_w = 11, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21187, .adv_w = 123, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21229, .adv_w = 104, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21256, .adv_w = 120, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21288, .adv_w = 101, .box_w = 7, .box_h = 10, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 21323, .adv_w = 158, .box_w = 8, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21367, .adv_w = 133, .box_w = 7, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21399, .adv_w = 158, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21447, .adv_w = 133, .box_w = 7, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21479, .adv_w = 163, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21544, .adv_w = 123, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21580, .adv_w = 163, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21625, .adv_w = 125, .box_w = 8, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21653, .adv_w = 163, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21718, .adv_w = 125, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21754, .adv_w = 136, .box_w = 8, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21806, .adv_w = 110, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21838, .adv_w = 133, .box_w = 9, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21888, .adv_w = 110, .box_w = 8, .box_h = 12, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 21936, .adv_w = 133, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21995, .adv_w = 110, .box_w = 8, .box_h = 12, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 22043, .adv_w = 133, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22097, .adv_w = 110, .box_w = 8, .box_h = 12, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 22145, .adv_w = 141, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22193, .adv_w = 117, .box_w = 7, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22225, .adv_w = 111, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 22258, .adv_w = 94, .box_w = 5, .box_h = 9, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 22281, .adv_w = 191, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 22341, .adv_w = 155, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 22377, .adv_w = 119, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 22425, .adv_w = 94, .box_w = 6, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 22455, .adv_w = 129, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 22503, .adv_w = 104, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 22538, .adv_w = 131, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22574, .adv_w = 109, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22599, .adv_w = 123, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22635, .adv_w = 104, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22660, .adv_w = 152, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 22714, .adv_w = 123, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 22749, .adv_w = 164, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 22809, .adv_w = 132, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 22849, .adv_w = 208, .box_w = 13, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22908, .adv_w = 180, .box_w = 12, .box_h = 7, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22950, .adv_w = 163, .box_w = 9, .box_h = 11, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 23000, .adv_w = 130, .box_w = 7, .box_h = 9, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 23032, .adv_w = 155, .box_w = 9, .box_h = 11, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 23082, .adv_w = 134, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 23130, .adv_w = 157, .box_w = 10, .box_h = 12, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 23190, .adv_w = 131, .box_w = 10, .box_h = 10, .ofs_x = -2, .ofs_y = -3},
    {.bitmap_index = 23240, .adv_w = 157, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 23295, .adv_w = 127, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 23331, .adv_w = 134, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23331, .adv_w = 44, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23331, .adv_w = 26, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23331, .adv_w = 19, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23331, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23331, .adv_w = 74, .box_w = 4, .box_h = 2, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 23335, .adv_w = 134, .box_w = 8, .box_h = 1, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 23339, .adv_w = 96, .box_w = 6, .box_h = 1, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 23342, .adv_w = 192, .box_w = 12, .box_h = 1, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 23348, .adv_w = 192, .box_w = 13, .box_h = 1, .ofs_x = -1, .ofs_y = 3},
    {.bitmap_index = 23355, .adv_w = 44, .box_w = 3, .box_h = 4, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 23361, .adv_w = 44, .box_w = 3, .box_h = 4, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 23367, .adv_w = 44, .box_w = 3, .box_h = 4, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 23373, .adv_w = 80, .box_w = 5, .box_h = 4, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 23383, .adv_w = 80, .box_w = 5, .box_h = 4, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 23393, .adv_w = 80, .box_w = 5, .box_h = 4, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 23403, .adv_w = 108, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 23445, .adv_w = 108, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 23487, .adv_w = 60, .box_w = 3, .box_h = 3, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 23492, .adv_w = 133, .box_w = 8, .box_h = 2, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23500, .adv_w = 232, .box_w = 15, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23568, .adv_w = 40, .box_w = 2, .box_h = 4, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 23572, .adv_w = 75, .box_w = 4, .box_h = 4, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 23580, .adv_w = 60, .box_w = 4, .box_h = 6, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 23592, .adv_w = 60, .box_w = 4, .box_h = 6, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 23604, .adv_w = 33, .box_w = 8, .box_h = 9, .ofs_x = -3, .ofs_y = 0},
    {.bitmap_index = 23640, .adv_w = 103, .box_w = 6, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23667, .adv_w = 83, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 23680, .adv_w = 83, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 23693, .adv_w = 83, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 23706, .adv_w = 83, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 23719, .adv_w = 83, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 23732, .adv_w = 83, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 23745, .adv_w = 83, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 23758, .adv_w = 83, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 23771, .adv_w = 83, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 23784, .adv_w = 83, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 23797, .adv_w = 83, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 23810, .adv_w = 83, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 23823, .adv_w = 83, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 23836, .adv_w = 83, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 23849, .adv_w = 83, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 23862, .adv_w = 83, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 23875, .adv_w = 83, .box_w = 5, .box_h = 5, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 23888, .adv_w = 139, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 23947, .adv_w = 127, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23983, .adv_w = 124, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24019, .adv_w = 169, .box_w = 11, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24069, .adv_w = 315, .box_w = 19, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 24155, .adv_w = 229, .box_w = 14, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24218, .adv_w = 131, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 24272, .adv_w = 155, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24317, .adv_w = 127, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24353, .adv_w = 131, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24389, .adv_w = 162, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24434, .adv_w = 148, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 24493, .adv_w = 158, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 24529, .adv_w = 139, .box_w = 9, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 24588, .adv_w = 138, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24624, .adv_w = 138, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24665, .adv_w = 137, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24706, .adv_w = 176, .box_w = 9, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 24756, .adv_w = 144, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24797, .adv_w = 90, .box_w = 5, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24820, .adv_w = 231, .box_w = 13, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 24879, .adv_w = 198, .box_w = 12, .box_h = 6, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 24915, .adv_w = 172, .box_w = 11, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24965, .adv_w = 138, .box_w = 8, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 25001, .adv_w = 141, .box_w = 10, .box_h = 13, .ofs_x = -1, .ofs_y = -1},
    {.bitmap_index = 25066, .adv_w = 169, .box_w = 10, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 25111, .adv_w = 199, .box_w = 12, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 25165, .adv_w = 199, .box_w = 12, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 25219, .adv_w = 199, .box_w = 13, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 25278, .adv_w = 199, .box_w = 13, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 25337, .adv_w = 199, .box_w = 13, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 25396, .adv_w = 199, .box_w = 13, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 25455, .adv_w = 115, .box_w = 6, .box_h = 6, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 25473, .adv_w = 115, .box_w = 6, .box_h = 6, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 25491, .adv_w = 115, .box_w = 7, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 25512, .adv_w = 115, .box_w = 5, .box_h = 6, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 25527, .adv_w = 140, .box_w = 9, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 25554, .adv_w = 115, .box_w = 6, .box_h = 8, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 25578, .adv_w = 115, .box_w = 5, .box_h = 5, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 25591, .adv_w = 115, .box_w = 6, .box_h = 5, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 25606, .adv_w = 115, .box_w = 6, .box_h = 6, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 25624, .adv_w = 115, .box_w = 5, .box_h = 5, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 25637, .adv_w = 134, .box_w = 8, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 25677, .adv_w = 112, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 25705, .adv_w = 141, .box_w = 10, .box_h = 9, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 25750, .adv_w = 156, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 25798, .adv_w = 126, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 25846, .adv_w = 112, .box_w = 7, .box_h = 2, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 25853, .adv_w = 68, .box_w = 6, .box_h = 13, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 25892, .adv_w = 55, .box_w = 3, .box_h = 3, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 25897, .adv_w = 154, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 25962, .adv_w = 177, .box_w = 11, .box_h = 6, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 25995, .adv_w = 77, .box_w = 7, .box_h = 12, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 26037, .adv_w = 112, .box_w = 7, .box_h = 6, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 26058, .adv_w = 112, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 26086, .adv_w = 112, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 26114, .adv_w = 112, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 26142, .adv_w = 115, .box_w = 5, .box_h = 6, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 26157, .adv_w = 115, .box_w = 5, .box_h = 5, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 26170, .adv_w = 115, .box_w = 6, .box_h = 6, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 26188, .adv_w = 115, .box_w = 6, .box_h = 6, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 26206, .adv_w = 115, .box_w = 6, .box_h = 6, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 26224, .adv_w = 115, .box_w = 6, .box_h = 6, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 26242, .adv_w = 115, .box_w = 6, .box_h = 6, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 26260, .adv_w = 115, .box_w = 6, .box_h = 6, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 26278, .adv_w = 115, .box_w = 6, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 26296, .adv_w = 115, .box_w = 6, .box_h = 6, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 26314, .adv_w = 115, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 26342, .adv_w = 115, .box_w = 7, .box_h = 8, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 26370, .adv_w = 96, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 26394, .adv_w = 63, .box_w = 4, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 26418, .adv_w = 63, .box_w = 4, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 26442, .adv_w = 50, .box_w = 3, .box_h = 6, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 26451, .adv_w = 49, .box_w = 3, .box_h = 5, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 26459, .adv_w = 121, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 26494, .adv_w = 121, .box_w = 7, .box_h = 10, .ofs_x = 0, .ofs_y = 0}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint8_t glyph_id_ofs_list_2[] = {
    0, 0, 1, 0, 2, 3, 4, 0,
    5
};

static const uint16_t unicode_list_6[] = {
    0x0, 0x1, 0x8, 0x9, 0x10, 0x11, 0x12, 0x13
};

static const uint16_t unicode_list_9[] = {
    0x0, 0x1, 0x2, 0x3, 0xa, 0xb, 0xc, 0xd,
    0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1e, 0x1f,
    0x1af7, 0x1af8, 0x1af9, 0x1afa, 0x1afb, 0x1b00, 0x1b02, 0x1b03,
    0x1b04, 0x1b05, 0x1b08, 0x1b09, 0x1b0a, 0x1b0c, 0x1b0d, 0x1b0e,
    0x1b10, 0x1b11, 0x1b12, 0x1b16, 0x1b20, 0x1b22, 0x1b23, 0x1b29,
    0x1b2a, 0x1b34, 0x1b42, 0x1b60, 0x1b64, 0x1b65, 0x1b66, 0x1b67,
    0x1b68, 0x1b69, 0x1b70, 0x1b71, 0x1b72, 0x1b73, 0x1b74, 0x1b75,
    0x1b76, 0x1b77, 0x1b78, 0x1b79, 0x1b91, 0x1b93, 0x1b94, 0x1b96,
    0x1b97, 0x1b99, 0x1b9b, 0x1b9c, 0x1b9d, 0x1b9e, 0x1ba1, 0x1ba2,
    0x1ba4, 0x1ba5, 0x1ba8, 0x1ba9, 0x1baa, 0x1bac, 0x1bad, 0x1c03,
    0x1c06, 0x1c12, 0x1c16, 0x1c1a, 0x1c1b, 0x1c1e, 0x1c43, 0x1c44,
    0x1c4b, 0x1c4c, 0x1c4d, 0x1c4e, 0x1c80, 0x1c81, 0x1c82, 0x1c83,
    0x1c84, 0x1c85, 0x1c86, 0x1c87, 0x1c88, 0x1c89, 0x1cf2, 0x1cf5,
    0x1cf6, 0x1cff, 0x1d01, 0x1d02, 0x1d05, 0x1d09, 0x1d0a, 0x1d0e,
    0x1d1b, 0x1d38, 0x1d50, 0x1d54, 0x1d55, 0x2090, 0x2091, 0x20a2,
    0x20a3, 0x20a6, 0x20a7, 0x20ac, 0x20ad, 0x20b0, 0x20b1, 0x20b6,
    0x20b7, 0x20ba, 0x22d8, 0x22d9, 0xa27b, 0xa27c, 0xf5f1, 0xf5f2
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 160, .range_length = 224, .glyph_id_start = 96,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 900, .range_length = 9, .glyph_id_start = 320,
        .unicode_list = NULL, .glyph_id_ofs_list = glyph_id_ofs_list_2, .list_length = 9, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_FULL
    },
    {
        .range_start = 910, .range_length = 20, .glyph_id_start = 326,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 931, .range_length = 44, .glyph_id_start = 346,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 1024, .range_length = 96, .glyph_id_start = 390,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 1122, .range_length = 20, .glyph_id_start = 486,
        .unicode_list = unicode_list_6, .glyph_id_ofs_list = NULL, .list_length = 8, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    },
    {
        .range_start = 1162, .range_length = 59, .glyph_id_start = 494,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 1222, .range_length = 58, .glyph_id_start = 553,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 1296, .range_length = 62963, .glyph_id_start = 611,
        .unicode_list = unicode_list_9, .glyph_id_ofs_list = NULL, .list_length = 136, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    }
};



/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

#if LVGL_VERSION_MAJOR == 8
/*Store all the custom data of the font*/
static  lv_font_fmt_txt_glyph_cache_t cache;
#endif

#if LVGL_VERSION_MAJOR >= 8
static const lv_font_fmt_txt_dsc_t font_dsc = {
#else
static lv_font_fmt_txt_dsc_t font_dsc = {
#endif
    .glyph_bitmap = glyph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = NULL,
    .kern_scale = 0,
    .cmap_num = 10,
    .bpp = 4,
    .kern_classes = 0,
    .bitmap_format = 0,
#if LVGL_VERSION_MAJOR == 8
    .cache = &cache
#endif
};



/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
#if LVGL_VERSION_MAJOR >= 8
const lv_font_t ui_font_montserrat_12 = {
#else
lv_font_t ui_font_montserrat_12 = {
#endif
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 17,          /*The maximum line height required by the font*/
    .base_line = 4,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
#if LV_VERSION_CHECK(7, 4, 0) || LVGL_VERSION_MAJOR >= 8
    .underline_position = -1,
    .underline_thickness = 1,
#endif
    .dsc = &font_dsc,          /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
#if LV_VERSION_CHECK(8, 2, 0) || LVGL_VERSION_MAJOR >= 9
    .fallback = NULL,
#endif
    .user_data = NULL,
};



#endif /*#if UI_FONT_MONTSERRAT_12*/

