/*******************************************************************************
 * Size: 20 px
 * Bpp: 4
 * Opts: --bpp 4 --size 20 --no-compress --font MontserratZ-Medium.ttf --range 32-127,160-255,256-383,880-1023,1024-1279,1280-1327,7936-131071 --format lvgl
 ******************************************************************************/

#ifdef __has_include
    #if __has_include("lvgl.h")
        #ifndef LV_LVGL_H_INCLUDE_SIMPLE
            #define LV_LVGL_H_INCLUDE_SIMPLE
        #endif
    #endif
#endif

#ifdef LV_LVGL_H_INCLUDE_SIMPLE
    #include "lvgl.h"
#else
    #include "lvgl.h"
#endif

#ifndef UI_FONT_MONTSERRAT_20
#define UI_FONT_MONTSERRAT_20 1
#endif

#if UI_FONT_MONTSERRAT_20

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t glyph_bitmap[] = {
    /* U+0020 " " */

    /* U+0021 "!" */
    0x6f, 0xc6, 0xfc, 0x5f, 0xb4, 0xfa, 0x4f, 0xa3,
    0xf9, 0x3f, 0x92, 0xf8, 0x2f, 0x71, 0xd6, 0x0,
    0x1, 0x95, 0x9f, 0xe4, 0xe9,

    /* U+0022 "\"" */
    0xce, 0x2, 0xf8, 0xbe, 0x1, 0xf8, 0xbd, 0x1,
    0xf7, 0xbd, 0x1, 0xf7, 0xac, 0x0, 0xf6, 0x56,
    0x0, 0x83,

    /* U+0023 "#" */
    0x0, 0x0, 0x7f, 0x0, 0x4, 0xf2, 0x0, 0x0,
    0x0, 0xac, 0x0, 0x7, 0xf0, 0x0, 0x0, 0x0,
    0xca, 0x0, 0x9, 0xd0, 0x0, 0xd, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0x6, 0x88, 0xfb, 0x88,
    0x8e, 0xc8, 0x84, 0x0, 0x2, 0xf4, 0x0, 0xf,
    0x70, 0x0, 0x0, 0x4, 0xf3, 0x0, 0xf, 0x50,
    0x0, 0x0, 0x5, 0xf1, 0x0, 0x2f, 0x40, 0x0,
    0x0, 0x7, 0xf0, 0x0, 0x4f, 0x20, 0x0, 0x7f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xe0, 0x38, 0x8d,
    0xd8, 0x88, 0xcf, 0x88, 0x70, 0x0, 0xd, 0x90,
    0x0, 0xac, 0x0, 0x0, 0x0, 0xf, 0x70, 0x0,
    0xca, 0x0, 0x0, 0x0, 0x1f, 0x50, 0x0, 0xe8,
    0x0, 0x0,

    /* U+0024 "$" */
    0x0, 0x0, 0x5, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xf0,
    0x0, 0x0, 0x0, 0x7, 0xcf, 0xff, 0xd8, 0x10,
    0x0, 0xcf, 0xfe, 0xfd, 0xff, 0xd0, 0x8, 0xfb,
    0x15, 0xf0, 0x5, 0x60, 0xc, 0xf3, 0x5, 0xf0,
    0x0, 0x0, 0xc, 0xf4, 0x5, 0xf0, 0x0, 0x0,
    0x7, 0xfe, 0x76, 0xf0, 0x0, 0x0, 0x0, 0x9f,
    0xff, 0xf9, 0x50, 0x0, 0x0, 0x1, 0x7c, 0xff,
    0xfe, 0x50, 0x0, 0x0, 0x5, 0xf3, 0xaf, 0xf3,
    0x0, 0x0, 0x5, 0xf0, 0x9, 0xf8, 0x1, 0x0,
    0x5, 0xf0, 0x6, 0xf8, 0xd, 0xa2, 0x5, 0xf0,
    0x2d, 0xf4, 0xb, 0xff, 0xed, 0xfd, 0xff, 0x90,
    0x0, 0x4a, 0xef, 0xff, 0xb5, 0x0, 0x0, 0x0,
    0x5, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0x70, 0x0, 0x0,

    /* U+0025 "%" */
    0x0, 0x9e, 0xe9, 0x0, 0x0, 0x0, 0xda, 0x0,
    0x0, 0xbd, 0x44, 0xda, 0x0, 0x0, 0x9e, 0x10,
    0x0, 0x1f, 0x40, 0x4, 0xf1, 0x0, 0x4f, 0x40,
    0x0, 0x3, 0xf1, 0x0, 0x1f, 0x30, 0x1e, 0x90,
    0x0, 0x0, 0x2f, 0x30, 0x2, 0xf1, 0xa, 0xd0,
    0x0, 0x0, 0x0, 0xcb, 0x11, 0xbc, 0x5, 0xf3,
    0x0, 0x0, 0x0, 0x2, 0xcf, 0xfc, 0x21, 0xe8,
    0xa, 0xee, 0x70, 0x0, 0x0, 0x11, 0x0, 0xad,
    0xb, 0xd4, 0x5f, 0x60, 0x0, 0x0, 0x0, 0x5f,
    0x32, 0xf3, 0x0, 0x7e, 0x0, 0x0, 0x0, 0x1f,
    0x70, 0x5f, 0x0, 0x4, 0xf1, 0x0, 0x0, 0xb,
    0xc0, 0x5, 0xf0, 0x0, 0x3f, 0x10, 0x0, 0x6,
    0xf2, 0x0, 0x2f, 0x20, 0x6, 0xe0, 0x0, 0x2,
    0xf7, 0x0, 0x0, 0xbb, 0x24, 0xe7, 0x0, 0x0,
    0xcc, 0x0, 0x0, 0x1, 0xaf, 0xe7, 0x0,

    /* U+0026 "&" */
    0x0, 0x1, 0x9e, 0xfd, 0x70, 0x0, 0x0, 0x0,
    0xd, 0xfa, 0x7b, 0xf7, 0x0, 0x0, 0x0, 0x4f,
    0x90, 0x0, 0xdd, 0x0, 0x0, 0x0, 0x4f, 0x70,
    0x0, 0xdc, 0x0, 0x0, 0x0, 0x1e, 0xd0, 0x8,
    0xf5, 0x0, 0x0, 0x0, 0x5, 0xfb, 0xcf, 0x60,
    0x0, 0x0, 0x0, 0x4, 0xef, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0x84, 0xfd, 0x20, 0x8, 0x30,
    0x7, 0xf6, 0x0, 0x3f, 0xe2, 0x1f, 0x80, 0xf,
    0xe0, 0x0, 0x3, 0xfe, 0xaf, 0x30, 0xf, 0xd0,
    0x0, 0x0, 0x3f, 0xfc, 0x0, 0xd, 0xf6, 0x0,
    0x0, 0x5f, 0xfe, 0x30, 0x4, 0xff, 0xdb, 0xbe,
    0xfd, 0x6f, 0xf2, 0x0, 0x29, 0xdf, 0xec, 0x60,
    0x3, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+0027 "'" */
    0xbe, 0xbe, 0xad, 0xad, 0xad, 0x57,

    /* U+0028 "(" */
    0x0, 0xe, 0xd0, 0x0, 0x7f, 0x60, 0x0, 0xef,
    0x0, 0x3, 0xfa, 0x0, 0x8, 0xf5, 0x0, 0xb,
    0xf2, 0x0, 0xe, 0xf0, 0x0, 0xf, 0xe0, 0x0,
    0xf, 0xd0, 0x0, 0x1f, 0xc0, 0x0, 0xf, 0xd0,
    0x0, 0xf, 0xe0, 0x0, 0xe, 0xf0, 0x0, 0xb,
    0xf2, 0x0, 0x8, 0xf5, 0x0, 0x3, 0xfa, 0x0,
    0x0, 0xef, 0x0, 0x0, 0x7f, 0x60, 0x0, 0xe,
    0xd0,

    /* U+0029 ")" */
    0x2f, 0xb0, 0x0, 0xaf, 0x40, 0x3, 0xfa, 0x0,
    0xe, 0xf0, 0x0, 0x9f, 0x40, 0x6, 0xf7, 0x0,
    0x3f, 0xa0, 0x2, 0xfb, 0x0, 0x1f, 0xc0, 0x0,
    0xfd, 0x0, 0x1f, 0xc0, 0x2, 0xfb, 0x0, 0x3f,
    0xa0, 0x6, 0xf7, 0x0, 0x9f, 0x40, 0xe, 0xf0,
    0x3, 0xfa, 0x0, 0xaf, 0x30, 0x2f, 0xb0, 0x0,

    /* U+002A "*" */
    0x0, 0x9, 0x90, 0x0, 0x26, 0x9, 0x90, 0x62,
    0x5f, 0xcb, 0xbc, 0xf5, 0x2, 0xbf, 0xfb, 0x20,
    0x7, 0xef, 0xfe, 0x70, 0x6f, 0x79, 0x97, 0xf6,
    0x1, 0x9, 0x90, 0x10, 0x0, 0x6, 0x60, 0x0,

    /* U+002B "+" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0xfa, 0x0, 0x0, 0x0, 0x0, 0xfa, 0x0,
    0x0, 0xaf, 0xff, 0xff, 0xff, 0xf4, 0x6a, 0xaa,
    0xfd, 0xaa, 0xa2, 0x0, 0x0, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0xfa, 0x0, 0x0, 0x0, 0x0, 0xfa,
    0x0, 0x0,

    /* U+002C "," */
    0x6, 0xa2, 0xf, 0xf8, 0xb, 0xf7, 0x5, 0xf2,
    0x9, 0xc0, 0xd, 0x70,

    /* U+002D "-" */
    0x9b, 0xbb, 0xb5, 0xdf, 0xff, 0xf8,

    /* U+002E "." */
    0x7, 0xb2, 0xf, 0xf8, 0xa, 0xe4,

    /* U+002F "/" */
    0x0, 0x0, 0x0, 0x7, 0x50, 0x0, 0x0, 0x4,
    0xf7, 0x0, 0x0, 0x0, 0xaf, 0x10, 0x0, 0x0,
    0xf, 0xc0, 0x0, 0x0, 0x4, 0xf6, 0x0, 0x0,
    0x0, 0xaf, 0x10, 0x0, 0x0, 0xf, 0xc0, 0x0,
    0x0, 0x5, 0xf6, 0x0, 0x0, 0x0, 0xaf, 0x10,
    0x0, 0x0, 0xf, 0xb0, 0x0, 0x0, 0x5, 0xf6,
    0x0, 0x0, 0x0, 0xaf, 0x10, 0x0, 0x0, 0xf,
    0xb0, 0x0, 0x0, 0x5, 0xf6, 0x0, 0x0, 0x0,
    0xbf, 0x10, 0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0,
    0x6, 0xf5, 0x0, 0x0, 0x0, 0xbf, 0x0, 0x0,
    0x0, 0x1f, 0xb0, 0x0, 0x0, 0x6, 0xf5, 0x0,
    0x0, 0x0,

    /* U+0030 "0" */
    0x0, 0x1, 0x8d, 0xfe, 0xa3, 0x0, 0x0, 0x2,
    0xdf, 0xfd, 0xff, 0xf6, 0x0, 0x0, 0xdf, 0xa1,
    0x0, 0x6f, 0xf3, 0x0, 0x6f, 0xc0, 0x0, 0x0,
    0x7f, 0xb0, 0xb, 0xf5, 0x0, 0x0, 0x0, 0xff,
    0x10, 0xef, 0x10, 0x0, 0x0, 0xc, 0xf3, 0xf,
    0xf0, 0x0, 0x0, 0x0, 0xaf, 0x50, 0xff, 0x0,
    0x0, 0x0, 0xa, 0xf5, 0xe, 0xf1, 0x0, 0x0,
    0x0, 0xcf, 0x30, 0xbf, 0x50, 0x0, 0x0, 0xf,
    0xf1, 0x6, 0xfc, 0x0, 0x0, 0x7, 0xfb, 0x0,
    0xd, 0xfa, 0x10, 0x6, 0xff, 0x30, 0x0, 0x2d,
    0xff, 0xef, 0xff, 0x60, 0x0, 0x0, 0x18, 0xdf,
    0xea, 0x30, 0x0,

    /* U+0031 "1" */
    0xdf, 0xff, 0xf4, 0xac, 0xce, 0xf4, 0x0, 0xb,
    0xf4, 0x0, 0xb, 0xf4, 0x0, 0xb, 0xf4, 0x0,
    0xb, 0xf4, 0x0, 0xb, 0xf4, 0x0, 0xb, 0xf4,
    0x0, 0xb, 0xf4, 0x0, 0xb, 0xf4, 0x0, 0xb,
    0xf4, 0x0, 0xb, 0xf4, 0x0, 0xb, 0xf4, 0x0,
    0xb, 0xf4,

    /* U+0032 "2" */
    0x0, 0x6c, 0xef, 0xea, 0x30, 0x2, 0xef, 0xfe,
    0xdf, 0xff, 0x50, 0x5f, 0x91, 0x0, 0x9, 0xfe,
    0x0, 0x10, 0x0, 0x0, 0xe, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0x10, 0x0, 0x0, 0x0, 0x3f,
    0xd0, 0x0, 0x0, 0x0, 0xd, 0xf5, 0x0, 0x0,
    0x0, 0x1c, 0xf8, 0x0, 0x0, 0x0, 0x1d, 0xf8,
    0x0, 0x0, 0x0, 0x1d, 0xf8, 0x0, 0x0, 0x0,
    0x2e, 0xf7, 0x0, 0x0, 0x0, 0x2e, 0xf6, 0x0,
    0x0, 0x0, 0x2e, 0xff, 0xcc, 0xcc, 0xcc, 0x94,
    0xff, 0xff, 0xff, 0xff, 0xfc,

    /* U+0033 "3" */
    0x4f, 0xff, 0xff, 0xff, 0xff, 0x3, 0xcc, 0xcc,
    0xcc, 0xef, 0xd0, 0x0, 0x0, 0x0, 0x2f, 0xe2,
    0x0, 0x0, 0x0, 0x1d, 0xf4, 0x0, 0x0, 0x0,
    0xc, 0xf6, 0x0, 0x0, 0x0, 0x9, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0xff, 0xfe, 0x80, 0x0, 0x0,
    0x6, 0x68, 0xef, 0xc0, 0x0, 0x0, 0x0, 0x1,
    0xdf, 0x50, 0x0, 0x0, 0x0, 0x8, 0xf8, 0x1,
    0x0, 0x0, 0x0, 0xaf, 0x77, 0xe6, 0x10, 0x0,
    0x7f, 0xf2, 0x7f, 0xff, 0xee, 0xff, 0xf7, 0x0,
    0x28, 0xcf, 0xfe, 0xa3, 0x0,

    /* U+0034 "4" */
    0x0, 0x0, 0x0, 0x7, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xd1, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xef, 0x30, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xfd, 0x0, 0x1,
    0x0, 0x0, 0x0, 0x2e, 0xf2, 0x0, 0x6f, 0x70,
    0x0, 0x0, 0xcf, 0x60, 0x0, 0x6f, 0x70, 0x0,
    0x9, 0xf9, 0x0, 0x0, 0x6f, 0x70, 0x0, 0x3f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x2c, 0xcc,
    0xcc, 0xcc, 0xdf, 0xec, 0xc1, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0x70, 0x0,

    /* U+0035 "5" */
    0x0, 0xff, 0xff, 0xff, 0xff, 0x0, 0x1f, 0xfc,
    0xcc, 0xcc, 0xc0, 0x2, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0x90, 0x0, 0x0, 0x0, 0x6, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0xec, 0xcb, 0x72,
    0x0, 0x9, 0xff, 0xff, 0xff, 0xf7, 0x0, 0x0,
    0x0, 0x3, 0x8f, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0xa0, 0x0, 0x0, 0x0, 0x4, 0xfb, 0x2,
    0x0, 0x0, 0x0, 0x6f, 0xa3, 0xf8, 0x20, 0x0,
    0x5f, 0xf4, 0x4e, 0xff, 0xed, 0xff, 0xf9, 0x0,
    0x17, 0xbe, 0xfe, 0xb5, 0x0,

    /* U+0036 "6" */
    0x0, 0x0, 0x4a, 0xef, 0xec, 0x60, 0x0, 0xa,
    0xff, 0xec, 0xdf, 0xb0, 0x0, 0xaf, 0xb2, 0x0,
    0x1, 0x10, 0x4, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xf4, 0x0, 0x0, 0x0, 0x0, 0xe, 0xf0,
    0x6c, 0xff, 0xc6, 0x0, 0xf, 0xfb, 0xfd, 0xbc,
    0xff, 0xa0, 0xf, 0xff, 0x60, 0x0, 0x2e, 0xf5,
    0xe, 0xfa, 0x0, 0x0, 0x5, 0xfa, 0xc, 0xf7,
    0x0, 0x0, 0x2, 0xfc, 0x7, 0xfa, 0x0, 0x0,
    0x5, 0xfa, 0x0, 0xef, 0x60, 0x0, 0x2e, 0xf4,
    0x0, 0x3e, 0xfd, 0xbc, 0xff, 0x80, 0x0, 0x1,
    0x8d, 0xfe, 0xb5, 0x0,

    /* U+0037 "7" */
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xf2, 0x6f, 0xec,
    0xcc, 0xcc, 0xdf, 0xf1, 0x6f, 0x80, 0x0, 0x0,
    0x6f, 0xa0, 0x6f, 0x80, 0x0, 0x0, 0xdf, 0x30,
    0x14, 0x20, 0x0, 0x5, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x60, 0x0,
    0x0, 0x0, 0x2, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x90, 0x0, 0x0,
    0x0, 0x0, 0xef, 0x20, 0x0, 0x0, 0x0, 0x6,
    0xfb, 0x0, 0x0, 0x0,

    /* U+0038 "8" */
    0x0, 0x6, 0xce, 0xfe, 0xb5, 0x0, 0x0, 0xcf,
    0xfc, 0xac, 0xff, 0xb0, 0x7, 0xfc, 0x10, 0x0,
    0x2d, 0xf4, 0x9, 0xf6, 0x0, 0x0, 0x8, 0xf7,
    0x6, 0xfb, 0x0, 0x0, 0x1d, 0xf4, 0x0, 0xaf,
    0xea, 0x9a, 0xff, 0x80, 0x0, 0x6f, 0xff, 0xff,
    0xfe, 0x40, 0x6, 0xfe, 0x61, 0x2, 0x7f, 0xf4,
    0xe, 0xf3, 0x0, 0x0, 0x5, 0xfc, 0x1f, 0xe0,
    0x0, 0x0, 0x0, 0xff, 0xf, 0xf1, 0x0, 0x0,
    0x3, 0xfe, 0xa, 0xfb, 0x10, 0x0, 0x2d, 0xf8,
    0x1, 0xdf, 0xfc, 0xbc, 0xff, 0xc0, 0x0, 0x7,
    0xce, 0xfe, 0xb6, 0x0,

    /* U+0039 "9" */
    0x0, 0x3a, 0xef, 0xeb, 0x40, 0x0, 0x6, 0xff,
    0xca, 0xbf, 0xf8, 0x0, 0x1f, 0xf4, 0x0, 0x1,
    0xcf, 0x40, 0x5f, 0x90, 0x0, 0x0, 0x2f, 0xc0,
    0x6f, 0x90, 0x0, 0x0, 0x3f, 0xf1, 0x2f, 0xf4,
    0x0, 0x1, 0xcf, 0xf4, 0x7, 0xff, 0xda, 0xbf,
    0xec, 0xf5, 0x0, 0x4b, 0xef, 0xe9, 0x1a, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0x90, 0x0, 0x40, 0x0, 0x1a, 0xfe, 0x10,
    0x6, 0xfe, 0xdd, 0xff, 0xe3, 0x0, 0x3, 0xad,
    0xfe, 0xc7, 0x10, 0x0,

    /* U+003A ":" */
    0xb, 0xe3, 0xf, 0xf8, 0x8, 0xb2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xb2, 0xf, 0xf8, 0xa, 0xe3,

    /* U+003B ";" */
    0xb, 0xe3, 0xf, 0xf8, 0x8, 0xb2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xa1, 0xf, 0xf8, 0xb, 0xf6, 0x5, 0xf1,
    0x9, 0xc0, 0xd, 0x70,

    /* U+003C "<" */
    0x0, 0x0, 0x0, 0x0, 0x63, 0x0, 0x0, 0x2,
    0x9f, 0xf4, 0x0, 0x5, 0xcf, 0xfb, 0x40, 0x28,
    0xef, 0xe7, 0x10, 0x0, 0xaf, 0xb4, 0x0, 0x0,
    0x0, 0x8f, 0xfa, 0x40, 0x0, 0x0, 0x2, 0x9e,
    0xfd, 0x71, 0x0, 0x0, 0x0, 0x6c, 0xff, 0xa2,
    0x0, 0x0, 0x0, 0x39, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x1,

    /* U+003D "=" */
    0xaf, 0xff, 0xff, 0xff, 0xf4, 0x6a, 0xaa, 0xaa,
    0xaa, 0xa2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0xff, 0xff, 0xff, 0xf4, 0x6a, 0xaa,
    0xaa, 0xaa, 0xa2,

    /* U+003E ">" */
    0x63, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xd6, 0x10,
    0x0, 0x0, 0x17, 0xdf, 0xf9, 0x30, 0x0, 0x0,
    0x3, 0xaf, 0xfc, 0x60, 0x0, 0x0, 0x1, 0x6e,
    0xf4, 0x0, 0x0, 0x6, 0xcf, 0xf3, 0x0, 0x39,
    0xff, 0xd6, 0x0, 0x5d, 0xff, 0xa3, 0x0, 0x0,
    0xad, 0x71, 0x0, 0x0, 0x0, 0x20, 0x0, 0x0,
    0x0, 0x0,

    /* U+003F "?" */
    0x0, 0x7c, 0xef, 0xea, 0x30, 0x2, 0xef, 0xfc,
    0xce, 0xff, 0x50, 0x6f, 0x80, 0x0, 0x8, 0xfe,
    0x0, 0x10, 0x0, 0x0, 0xf, 0xf1, 0x0, 0x0,
    0x0, 0x1, 0xfe, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0x60, 0x0, 0x0, 0x1, 0xcf, 0x80, 0x0, 0x0,
    0x0, 0xbf, 0x80, 0x0, 0x0, 0x0, 0x3f, 0xc0,
    0x0, 0x0, 0x0, 0x2, 0x74, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x93,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0xc0, 0x0, 0x0,
    0x0, 0x5, 0xf8, 0x0, 0x0,

    /* U+0040 "@" */
    0x0, 0x0, 0x0, 0x49, 0xde, 0xfe, 0xc8, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x3d, 0xfd, 0x96, 0x67,
    0x9d, 0xfb, 0x10, 0x0, 0x0, 0x6, 0xfc, 0x30,
    0x0, 0x0, 0x0, 0x4d, 0xe3, 0x0, 0x0, 0x4f,
    0xa0, 0x4, 0xbf, 0xeb, 0x46, 0xf6, 0xbe, 0x20,
    0x0, 0xec, 0x0, 0x6f, 0xfb, 0xad, 0xfb, 0xf5,
    0xd, 0xa0, 0x6, 0xf3, 0x3, 0xfd, 0x20, 0x0,
    0x8f, 0xf5, 0x5, 0xf2, 0xb, 0xd0, 0x9, 0xf4,
    0x0, 0x0, 0xc, 0xf5, 0x0, 0xf7, 0xe, 0x90,
    0xd, 0xf0, 0x0, 0x0, 0x7, 0xf5, 0x0, 0xb9,
    0xf, 0x70, 0xe, 0xd0, 0x0, 0x0, 0x5, 0xf5,
    0x0, 0xab, 0xf, 0x70, 0xd, 0xf0, 0x0, 0x0,
    0x7, 0xf5, 0x0, 0xba, 0xe, 0x90, 0x9, 0xf4,
    0x0, 0x0, 0xc, 0xf5, 0x0, 0xd8, 0xb, 0xd0,
    0x2, 0xfd, 0x10, 0x0, 0x7f, 0xf7, 0x3, 0xf4,
    0x6, 0xf3, 0x0, 0x6f, 0xfa, 0x9d, 0xf7, 0xfe,
    0x9e, 0xc0, 0x0, 0xdc, 0x0, 0x4, 0xbf, 0xeb,
    0x40, 0x5e, 0xfa, 0x10, 0x0, 0x4f, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xfc, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3c, 0xfd, 0x97, 0x68, 0xaf, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x49, 0xde, 0xfd,
    0xb6, 0x10, 0x0, 0x0,

    /* U+0041 "A" */
    0x0, 0x0, 0x0, 0xe, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xaf, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xfa, 0x1f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xf3, 0xa, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xc0, 0x3, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x50, 0x0, 0xcf, 0x30, 0x0,
    0x0, 0x1, 0xfe, 0x0, 0x0, 0x5f, 0xb0, 0x0,
    0x0, 0x8, 0xf7, 0x0, 0x0, 0xe, 0xf2, 0x0,
    0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x0,
    0x0, 0x6f, 0xda, 0xaa, 0xaa, 0xaa, 0xff, 0x10,
    0x0, 0xdf, 0x30, 0x0, 0x0, 0x0, 0x9f, 0x80,
    0x5, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xe0,
    0xc, 0xf4, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf6,

    /* U+0042 "B" */
    0xef, 0xff, 0xff, 0xfe, 0xb5, 0x0, 0xe, 0xfb,
    0xaa, 0xab, 0xdf, 0xf9, 0x0, 0xef, 0x10, 0x0,
    0x0, 0x4f, 0xf3, 0xe, 0xf1, 0x0, 0x0, 0x0,
    0xaf, 0x60, 0xef, 0x10, 0x0, 0x0, 0xc, 0xf4,
    0xe, 0xf1, 0x0, 0x0, 0x29, 0xfc, 0x0, 0xef,
    0xff, 0xff, 0xff, 0xfe, 0x10, 0xe, 0xfb, 0xaa,
    0xaa, 0xce, 0xfd, 0x20, 0xef, 0x10, 0x0, 0x0,
    0x8, 0xfc, 0xe, 0xf1, 0x0, 0x0, 0x0, 0xf,
    0xf0, 0xef, 0x10, 0x0, 0x0, 0x0, 0xff, 0x1e,
    0xf1, 0x0, 0x0, 0x0, 0x8f, 0xe0, 0xef, 0xbb,
    0xbb, 0xbc, 0xef, 0xf4, 0xe, 0xff, 0xff, 0xff,
    0xfd, 0x92, 0x0,

    /* U+0043 "C" */
    0x0, 0x0, 0x17, 0xce, 0xfe, 0xb5, 0x0, 0x0,
    0x5, 0xff, 0xfe, 0xdf, 0xff, 0xc1, 0x0, 0x5f,
    0xf9, 0x20, 0x0, 0x3b, 0xf5, 0x1, 0xff, 0x50,
    0x0, 0x0, 0x0, 0x30, 0x9, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xff,
    0x50, 0x0, 0x0, 0x0, 0x30, 0x0, 0x6f, 0xf9,
    0x20, 0x0, 0x3b, 0xf5, 0x0, 0x5, 0xff, 0xfe,
    0xdf, 0xff, 0xc1, 0x0, 0x0, 0x17, 0xce, 0xfe,
    0xb5, 0x0,

    /* U+0044 "D" */
    0xef, 0xff, 0xff, 0xfd, 0xa4, 0x0, 0x0, 0xef,
    0xdc, 0xcc, 0xdf, 0xff, 0xb1, 0x0, 0xef, 0x10,
    0x0, 0x0, 0x5d, 0xfd, 0x10, 0xef, 0x10, 0x0,
    0x0, 0x0, 0xbf, 0xa0, 0xef, 0x10, 0x0, 0x0,
    0x0, 0x1f, 0xf1, 0xef, 0x10, 0x0, 0x0, 0x0,
    0xa, 0xf6, 0xef, 0x10, 0x0, 0x0, 0x0, 0x8,
    0xf8, 0xef, 0x10, 0x0, 0x0, 0x0, 0x7, 0xf7,
    0xef, 0x10, 0x0, 0x0, 0x0, 0xa, 0xf6, 0xef,
    0x10, 0x0, 0x0, 0x0, 0x1f, 0xf1, 0xef, 0x10,
    0x0, 0x0, 0x0, 0xbf, 0xa0, 0xef, 0x10, 0x0,
    0x0, 0x4d, 0xfd, 0x10, 0xef, 0xcc, 0xcc, 0xdf,
    0xff, 0xb1, 0x0, 0xef, 0xff, 0xff, 0xfd, 0xa4,
    0x0, 0x0,

    /* U+0045 "E" */
    0xef, 0xff, 0xff, 0xff, 0xff, 0xe, 0xfd, 0xcc,
    0xcc, 0xcc, 0xc0, 0xef, 0x10, 0x0, 0x0, 0x0,
    0xe, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xef, 0x10,
    0x0, 0x0, 0x0, 0xe, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0xef, 0xff, 0xff, 0xff, 0xf2, 0xe, 0xfc,
    0xcc, 0xcc, 0xcc, 0x10, 0xef, 0x10, 0x0, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x10, 0x0, 0x0, 0x0, 0xe, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0xef, 0xcc, 0xcc, 0xcc, 0xcc, 0x3e,
    0xff, 0xff, 0xff, 0xff, 0xf4,

    /* U+0046 "F" */
    0xef, 0xff, 0xff, 0xff, 0xff, 0xef, 0xdc, 0xcc,
    0xcc, 0xcc, 0xef, 0x10, 0x0, 0x0, 0x0, 0xef,
    0x10, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0, 0x0,
    0x0, 0xef, 0x10, 0x0, 0x0, 0x0, 0xef, 0xcc,
    0xcc, 0xcc, 0xc1, 0xef, 0xff, 0xff, 0xff, 0xf2,
    0xef, 0x10, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0,
    0x0, 0x0, 0xef, 0x10, 0x0, 0x0, 0x0, 0xef,
    0x10, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0, 0x0,
    0x0, 0xef, 0x10, 0x0, 0x0, 0x0,

    /* U+0047 "G" */
    0x0, 0x0, 0x17, 0xce, 0xfe, 0xb6, 0x0, 0x0,
    0x5, 0xff, 0xfe, 0xde, 0xff, 0xe2, 0x0, 0x5f,
    0xf9, 0x20, 0x0, 0x29, 0xf7, 0x1, 0xff, 0x50,
    0x0, 0x0, 0x0, 0x20, 0x9, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x11, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x3, 0xfb,
    0xd, 0xf3, 0x0, 0x0, 0x0, 0x3, 0xfb, 0x9,
    0xf9, 0x0, 0x0, 0x0, 0x3, 0xfb, 0x1, 0xff,
    0x60, 0x0, 0x0, 0x3, 0xfb, 0x0, 0x5f, 0xf9,
    0x20, 0x0, 0x29, 0xfb, 0x0, 0x5, 0xff, 0xfe,
    0xde, 0xff, 0xe4, 0x0, 0x0, 0x17, 0xce, 0xfe,
    0xb6, 0x0,

    /* U+0048 "H" */
    0xef, 0x10, 0x0, 0x0, 0x0, 0xdf, 0x2e, 0xf1,
    0x0, 0x0, 0x0, 0xd, 0xf2, 0xef, 0x10, 0x0,
    0x0, 0x0, 0xdf, 0x2e, 0xf1, 0x0, 0x0, 0x0,
    0xd, 0xf2, 0xef, 0x10, 0x0, 0x0, 0x0, 0xdf,
    0x2e, 0xf1, 0x0, 0x0, 0x0, 0xd, 0xf2, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x2e, 0xfd, 0xcc,
    0xcc, 0xcc, 0xcf, 0xf2, 0xef, 0x10, 0x0, 0x0,
    0x0, 0xdf, 0x2e, 0xf1, 0x0, 0x0, 0x0, 0xd,
    0xf2, 0xef, 0x10, 0x0, 0x0, 0x0, 0xdf, 0x2e,
    0xf1, 0x0, 0x0, 0x0, 0xd, 0xf2, 0xef, 0x10,
    0x0, 0x0, 0x0, 0xdf, 0x2e, 0xf1, 0x0, 0x0,
    0x0, 0xd, 0xf2,

    /* U+0049 "I" */
    0xef, 0x1e, 0xf1, 0xef, 0x1e, 0xf1, 0xef, 0x1e,
    0xf1, 0xef, 0x1e, 0xf1, 0xef, 0x1e, 0xf1, 0xef,
    0x1e, 0xf1, 0xef, 0x1e, 0xf1,

    /* U+004A "J" */
    0x0, 0xcf, 0xff, 0xff, 0xf4, 0x0, 0x9c, 0xcc,
    0xcf, 0xf4, 0x0, 0x0, 0x0, 0xb, 0xf4, 0x0,
    0x0, 0x0, 0xb, 0xf4, 0x0, 0x0, 0x0, 0xb,
    0xf4, 0x0, 0x0, 0x0, 0xb, 0xf4, 0x0, 0x0,
    0x0, 0xb, 0xf4, 0x0, 0x0, 0x0, 0xb, 0xf4,
    0x0, 0x0, 0x0, 0xb, 0xf4, 0x0, 0x0, 0x0,
    0xb, 0xf4, 0x1, 0x0, 0x0, 0xd, 0xf2, 0xc,
    0xc2, 0x0, 0x6f, 0xe0, 0xa, 0xff, 0xde, 0xff,
    0x60, 0x0, 0x6c, 0xff, 0xc5, 0x0,

    /* U+004B "K" */
    0xef, 0x10, 0x0, 0x0, 0xb, 0xf8, 0xe, 0xf1,
    0x0, 0x0, 0xb, 0xf8, 0x0, 0xef, 0x10, 0x0,
    0xb, 0xf9, 0x0, 0xe, 0xf1, 0x0, 0xa, 0xfa,
    0x0, 0x0, 0xef, 0x10, 0xa, 0xfb, 0x0, 0x0,
    0xe, 0xf1, 0xa, 0xfb, 0x0, 0x0, 0x0, 0xef,
    0x19, 0xff, 0x30, 0x0, 0x0, 0xe, 0xfa, 0xff,
    0xfe, 0x10, 0x0, 0x0, 0xef, 0xfd, 0x1b, 0xfc,
    0x0, 0x0, 0xe, 0xfd, 0x10, 0xc, 0xfa, 0x0,
    0x0, 0xef, 0x20, 0x0, 0x1e, 0xf7, 0x0, 0xe,
    0xf1, 0x0, 0x0, 0x2f, 0xf4, 0x0, 0xef, 0x10,
    0x0, 0x0, 0x4f, 0xf2, 0xe, 0xf1, 0x0, 0x0,
    0x0, 0x6f, 0xd1,

    /* U+004C "L" */
    0xef, 0x10, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0,
    0x0, 0x0, 0xef, 0x10, 0x0, 0x0, 0x0, 0xef,
    0x10, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0, 0x0,
    0x0, 0xef, 0x10, 0x0, 0x0, 0x0, 0xef, 0x10,
    0x0, 0x0, 0x0, 0xef, 0x10, 0x0, 0x0, 0x0,
    0xef, 0x10, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0,
    0x0, 0x0, 0xef, 0x10, 0x0, 0x0, 0x0, 0xef,
    0x10, 0x0, 0x0, 0x0, 0xef, 0xcc, 0xcc, 0xcc,
    0xc8, 0xef, 0xff, 0xff, 0xff, 0xfb,

    /* U+004D "M" */
    0xef, 0x10, 0x0, 0x0, 0x0, 0x0, 0xe, 0xfe,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xef,
    0xf3, 0x0, 0x0, 0x0, 0x2, 0xff, 0xfe, 0xff,
    0xc0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xef, 0x9f,
    0x60, 0x0, 0x0, 0x4f, 0xaf, 0xfe, 0xf1, 0xee,
    0x10, 0x0, 0xd, 0xf1, 0xff, 0xef, 0x6, 0xf9,
    0x0, 0x7, 0xf7, 0xe, 0xfe, 0xf0, 0xc, 0xf3,
    0x1, 0xfd, 0x0, 0xef, 0xef, 0x0, 0x3f, 0xc0,
    0xaf, 0x40, 0xe, 0xfe, 0xf0, 0x0, 0x9f, 0x9f,
    0xa0, 0x0, 0xef, 0xef, 0x0, 0x1, 0xef, 0xf1,
    0x0, 0xe, 0xfe, 0xf0, 0x0, 0x6, 0xf7, 0x0,
    0x0, 0xef, 0xef, 0x0, 0x0, 0x4, 0x0, 0x0,
    0xe, 0xfe, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xef,

    /* U+004E "N" */
    0xef, 0x20, 0x0, 0x0, 0x0, 0xdf, 0x2e, 0xfd,
    0x10, 0x0, 0x0, 0xd, 0xf2, 0xef, 0xfb, 0x0,
    0x0, 0x0, 0xdf, 0x2e, 0xfe, 0xf8, 0x0, 0x0,
    0xd, 0xf2, 0xef, 0x4f, 0xf5, 0x0, 0x0, 0xdf,
    0x2e, 0xf1, 0x5f, 0xf3, 0x0, 0xd, 0xf2, 0xef,
    0x10, 0x8f, 0xe1, 0x0, 0xdf, 0x2e, 0xf1, 0x0,
    0xbf, 0xc0, 0xd, 0xf2, 0xef, 0x10, 0x1, 0xdf,
    0x90, 0xdf, 0x2e, 0xf1, 0x0, 0x2, 0xff, 0x6d,
    0xf2, 0xef, 0x10, 0x0, 0x5, 0xff, 0xff, 0x2e,
    0xf1, 0x0, 0x0, 0x8, 0xff, 0xf2, 0xef, 0x10,
    0x0, 0x0, 0xb, 0xff, 0x2e, 0xf1, 0x0, 0x0,
    0x0, 0xd, 0xf2,

    /* U+004F "O" */
    0x0, 0x0, 0x17, 0xce, 0xfe, 0xb6, 0x0, 0x0,
    0x0, 0x5, 0xef, 0xfe, 0xdf, 0xff, 0xd3, 0x0,
    0x0, 0x5f, 0xf9, 0x20, 0x0, 0x3b, 0xff, 0x30,
    0x1, 0xff, 0x50, 0x0, 0x0, 0x0, 0x8f, 0xd0,
    0x9, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf5,
    0xd, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfa,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfc,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfc,
    0xd, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfa,
    0x9, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf5,
    0x1, 0xff, 0x50, 0x0, 0x0, 0x0, 0x8f, 0xd0,
    0x0, 0x5f, 0xf9, 0x20, 0x0, 0x3b, 0xff, 0x30,
    0x0, 0x5, 0xef, 0xfe, 0xdf, 0xff, 0xd3, 0x0,
    0x0, 0x0, 0x17, 0xce, 0xfe, 0xb6, 0x0, 0x0,

    /* U+0050 "P" */
    0xef, 0xff, 0xff, 0xec, 0x70, 0x0, 0xef, 0xdc,
    0xcd, 0xef, 0xfe, 0x20, 0xef, 0x10, 0x0, 0x2,
    0xbf, 0xc0, 0xef, 0x10, 0x0, 0x0, 0xe, 0xf3,
    0xef, 0x10, 0x0, 0x0, 0xa, 0xf5, 0xef, 0x10,
    0x0, 0x0, 0xb, 0xf5, 0xef, 0x10, 0x0, 0x0,
    0x2f, 0xf2, 0xef, 0x10, 0x0, 0x15, 0xdf, 0xa0,
    0xef, 0xff, 0xff, 0xff, 0xfa, 0x0, 0xef, 0xcc,
    0xcc, 0xb8, 0x30, 0x0, 0xef, 0x10, 0x0, 0x0,
    0x0, 0x0, 0xef, 0x10, 0x0, 0x0, 0x0, 0x0,
    0xef, 0x10, 0x0, 0x0, 0x0, 0x0, 0xef, 0x10,
    0x0, 0x0, 0x0, 0x0,

    /* U+0051 "Q" */
    0x0, 0x0, 0x7, 0xce, 0xfe, 0xb6, 0x0, 0x0,
    0x0, 0x0, 0x5e, 0xff, 0xed, 0xff, 0xfd, 0x30,
    0x0, 0x0, 0x5f, 0xf9, 0x20, 0x0, 0x3b, 0xff,
    0x30, 0x0, 0x1f, 0xf5, 0x0, 0x0, 0x0, 0x8,
    0xfd, 0x0, 0x8, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xf5, 0x0, 0xdf, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xa0, 0xf, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xfc, 0x0, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xc0, 0xe, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xfa, 0x0, 0x9f, 0x90, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0x50, 0x2, 0xff, 0x50,
    0x0, 0x0, 0x0, 0x8f, 0xd0, 0x0, 0x6, 0xff,
    0x91, 0x0, 0x2, 0xaf, 0xf3, 0x0, 0x0, 0x6,
    0xff, 0xfe, 0xde, 0xff, 0xe3, 0x0, 0x0, 0x0,
    0x1, 0x8d, 0xff, 0xfd, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0xd2, 0x0, 0x1a, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0xfb, 0xbf, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4b, 0xff, 0xb3,
    0x0,

    /* U+0052 "R" */
    0xef, 0xff, 0xff, 0xec, 0x70, 0x0, 0xef, 0xdc,
    0xcd, 0xef, 0xfe, 0x20, 0xef, 0x10, 0x0, 0x2,
    0xbf, 0xc0, 0xef, 0x10, 0x0, 0x0, 0xe, 0xf3,
    0xef, 0x10, 0x0, 0x0, 0xa, 0xf5, 0xef, 0x10,
    0x0, 0x0, 0xb, 0xf5, 0xef, 0x10, 0x0, 0x0,
    0x2f, 0xf2, 0xef, 0x10, 0x0, 0x15, 0xdf, 0xa0,
    0xef, 0xff, 0xff, 0xff, 0xfa, 0x0, 0xef, 0xcc,
    0xcb, 0xdf, 0x90, 0x0, 0xef, 0x10, 0x0, 0x1e,
    0xf3, 0x0, 0xef, 0x10, 0x0, 0x4, 0xfd, 0x0,
    0xef, 0x10, 0x0, 0x0, 0x9f, 0x90, 0xef, 0x10,
    0x0, 0x0, 0xd, 0xf4,

    /* U+0053 "S" */
    0x0, 0x6, 0xce, 0xfe, 0xc7, 0x10, 0x0, 0xcf,
    0xfd, 0xcd, 0xff, 0xd0, 0x8, 0xfc, 0x10, 0x0,
    0x6, 0x60, 0xc, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfe,
    0x61, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xc8,
    0x40, 0x0, 0x0, 0x1, 0x6b, 0xef, 0xfd, 0x40,
    0x0, 0x0, 0x0, 0x3, 0x9f, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xf8, 0x1, 0x0, 0x0, 0x0,
    0x6, 0xf8, 0xd, 0xb3, 0x0, 0x0, 0x3e, 0xf4,
    0xa, 0xff, 0xfc, 0xcd, 0xff, 0x90, 0x0, 0x39,
    0xdf, 0xfe, 0xa4, 0x0,

    /* U+0054 "T" */
    0xef, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xbc, 0xcc,
    0xdf, 0xfc, 0xcc, 0xc8, 0x0, 0x0, 0x2f, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xd0, 0x0, 0x0,

    /* U+0055 "U" */
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0xff,
    0x0, 0x0, 0x0, 0x2, 0xfd, 0xf, 0xf0, 0x0,
    0x0, 0x0, 0x2f, 0xd0, 0xff, 0x0, 0x0, 0x0,
    0x2, 0xfd, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x2f,
    0xd0, 0xff, 0x0, 0x0, 0x0, 0x2, 0xfd, 0xf,
    0xf0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0xff, 0x0,
    0x0, 0x0, 0x2, 0xfd, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x2f, 0xc0, 0xdf, 0x30, 0x0, 0x0, 0x5,
    0xfa, 0x9, 0xf9, 0x0, 0x0, 0x0, 0xcf, 0x60,
    0x2f, 0xf8, 0x10, 0x1, 0xaf, 0xe0, 0x0, 0x5f,
    0xff, 0xee, 0xff, 0xe3, 0x0, 0x0, 0x29, 0xdf,
    0xfd, 0x81, 0x0,

    /* U+0056 "V" */
    0xc, 0xf5, 0x0, 0x0, 0x0, 0x0, 0xe, 0xf1,
    0x5, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x90,
    0x0, 0xef, 0x30, 0x0, 0x0, 0x0, 0xdf, 0x20,
    0x0, 0x7f, 0xa0, 0x0, 0x0, 0x4, 0xfb, 0x0,
    0x0, 0x1f, 0xf1, 0x0, 0x0, 0xb, 0xf4, 0x0,
    0x0, 0x9, 0xf8, 0x0, 0x0, 0x2f, 0xd0, 0x0,
    0x0, 0x2, 0xff, 0x0, 0x0, 0x9f, 0x60, 0x0,
    0x0, 0x0, 0xbf, 0x60, 0x1, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xd0, 0x7, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xf4, 0xe, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xfb, 0x5f, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xef, 0xef, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0xf5, 0x0, 0x0, 0x0,

    /* U+0057 "W" */
    0x3f, 0xd0, 0x0, 0x0, 0x0, 0xcf, 0x60, 0x0,
    0x0, 0x3, 0xfb, 0xd, 0xf3, 0x0, 0x0, 0x1,
    0xff, 0xc0, 0x0, 0x0, 0x8, 0xf5, 0x8, 0xf8,
    0x0, 0x0, 0x7, 0xff, 0xf1, 0x0, 0x0, 0xd,
    0xf1, 0x3, 0xfd, 0x0, 0x0, 0xc, 0xf9, 0xf7,
    0x0, 0x0, 0x3f, 0xb0, 0x0, 0xdf, 0x30, 0x0,
    0x2f, 0xb2, 0xfc, 0x0, 0x0, 0x8f, 0x50, 0x0,
    0x8f, 0x80, 0x0, 0x7f, 0x50, 0xdf, 0x10, 0x0,
    0xdf, 0x10, 0x0, 0x3f, 0xd0, 0x0, 0xdf, 0x0,
    0x7f, 0x70, 0x3, 0xfb, 0x0, 0x0, 0xd, 0xf3,
    0x2, 0xfa, 0x0, 0x2f, 0xc0, 0x8, 0xf5, 0x0,
    0x0, 0x8, 0xf8, 0x8, 0xf5, 0x0, 0xc, 0xf2,
    0xe, 0xf1, 0x0, 0x0, 0x3, 0xfd, 0xd, 0xf0,
    0x0, 0x7, 0xf7, 0x3f, 0xb0, 0x0, 0x0, 0x0,
    0xdf, 0x6f, 0xa0, 0x0, 0x1, 0xfc, 0x8f, 0x50,
    0x0, 0x0, 0x0, 0x8f, 0xff, 0x40, 0x0, 0x0,
    0xcf, 0xef, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0x0, 0x0, 0x0, 0x6f, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xf9, 0x0, 0x0, 0x0, 0x1f, 0xf5,
    0x0, 0x0,

    /* U+0058 "X" */
    0x1f, 0xf3, 0x0, 0x0, 0x0, 0xbf, 0x70, 0x5,
    0xfe, 0x10, 0x0, 0x6, 0xfb, 0x0, 0x0, 0x9f,
    0xa0, 0x0, 0x2f, 0xe1, 0x0, 0x0, 0xd, 0xf6,
    0x0, 0xdf, 0x40, 0x0, 0x0, 0x3, 0xff, 0x29,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xef, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x1e, 0xff, 0x70, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0x9f, 0xf3, 0x0, 0x0, 0x0,
    0x7, 0xfc, 0x6, 0xfd, 0x0, 0x0, 0x0, 0x3f,
    0xf2, 0x0, 0xaf, 0xa0, 0x0, 0x0, 0xdf, 0x50,
    0x0, 0xd, 0xf5, 0x0, 0xa, 0xfa, 0x0, 0x0,
    0x3, 0xff, 0x20, 0x5f, 0xd0, 0x0, 0x0, 0x0,
    0x7f, 0xc0,

    /* U+0059 "Y" */
    0xc, 0xf5, 0x0, 0x0, 0x0, 0x4, 0xfb, 0x0,
    0x2f, 0xe1, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0,
    0x8f, 0x90, 0x0, 0x0, 0x7f, 0x70, 0x0, 0x0,
    0xef, 0x30, 0x0, 0x2f, 0xd0, 0x0, 0x0, 0x5,
    0xfc, 0x0, 0xb, 0xf4, 0x0, 0x0, 0x0, 0xb,
    0xf6, 0x5, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0xe2, 0xef, 0x10, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0xef, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xf7, 0x0, 0x0,
    0x0,

    /* U+005A "Z" */
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0xcc,
    0xcc, 0xcc, 0xcc, 0xef, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x1d, 0xf6, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x8, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xfe, 0x10, 0x0, 0x0,
    0x0, 0x3, 0xff, 0x30, 0x0, 0x0, 0x0, 0x1,
    0xef, 0x50, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x1e, 0xfe,
    0xcc, 0xcc, 0xcc, 0xcc, 0x72, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf9,

    /* U+005B "[" */
    0xef, 0xff, 0x4e, 0xfa, 0xa2, 0xef, 0x0, 0xe,
    0xf0, 0x0, 0xef, 0x0, 0xe, 0xf0, 0x0, 0xef,
    0x0, 0xe, 0xf0, 0x0, 0xef, 0x0, 0xe, 0xf0,
    0x0, 0xef, 0x0, 0xe, 0xf0, 0x0, 0xef, 0x0,
    0xe, 0xf0, 0x0, 0xef, 0x0, 0xe, 0xf0, 0x0,
    0xef, 0x0, 0xe, 0xfa, 0xa2, 0xef, 0xff, 0x40,

    /* U+005C "\\" */
    0x57, 0x0, 0x0, 0x0, 0x6, 0xf5, 0x0, 0x0,
    0x0, 0x1f, 0xa0, 0x0, 0x0, 0x0, 0xcf, 0x0,
    0x0, 0x0, 0x6, 0xf5, 0x0, 0x0, 0x0, 0x1f,
    0xa0, 0x0, 0x0, 0x0, 0xbf, 0x0, 0x0, 0x0,
    0x6, 0xf5, 0x0, 0x0, 0x0, 0x1f, 0xb0, 0x0,
    0x0, 0x0, 0xbf, 0x0, 0x0, 0x0, 0x6, 0xf5,
    0x0, 0x0, 0x0, 0x1f, 0xb0, 0x0, 0x0, 0x0,
    0xbf, 0x10, 0x0, 0x0, 0x5, 0xf6, 0x0, 0x0,
    0x0, 0xf, 0xb0, 0x0, 0x0, 0x0, 0xaf, 0x10,
    0x0, 0x0, 0x5, 0xf6, 0x0, 0x0, 0x0, 0xf,
    0xb0, 0x0, 0x0, 0x0, 0xaf, 0x10, 0x0, 0x0,
    0x5, 0xf6,

    /* U+005D "]" */
    0xaf, 0xff, 0x96, 0xac, 0xf9, 0x0, 0x5f, 0x90,
    0x5, 0xf9, 0x0, 0x5f, 0x90, 0x5, 0xf9, 0x0,
    0x5f, 0x90, 0x5, 0xf9, 0x0, 0x5f, 0x90, 0x5,
    0xf9, 0x0, 0x5f, 0x90, 0x5, 0xf9, 0x0, 0x5f,
    0x90, 0x5, 0xf9, 0x0, 0x5f, 0x90, 0x5, 0xf9,
    0x0, 0x5f, 0x96, 0xac, 0xf9, 0xaf, 0xff, 0x90,

    /* U+005E "^" */
    0x0, 0x0, 0x75, 0x0, 0x0, 0x0, 0x5, 0xff,
    0x10, 0x0, 0x0, 0xc, 0xbf, 0x70, 0x0, 0x0,
    0x3f, 0x49, 0xd0, 0x0, 0x0, 0x9d, 0x3, 0xf4,
    0x0, 0x1, 0xf7, 0x0, 0xcb, 0x0, 0x7, 0xf1,
    0x0, 0x6f, 0x20, 0xd, 0xa0, 0x0, 0xf, 0x80,
    0x4f, 0x40, 0x0, 0x9, 0xe0,

    /* U+005F "_" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x33, 0x33, 0x33, 0x33, 0x33,

    /* U+0060 "`" */
    0x28, 0x70, 0x0, 0x6, 0xfc, 0x10, 0x0, 0x2d,
    0xd1,

    /* U+0061 "a" */
    0x0, 0x3a, 0xef, 0xd7, 0xf, 0xf0, 0x6f, 0xfe,
    0xce, 0xfc, 0xff, 0x3f, 0xf5, 0x0, 0x5, 0xff,
    0xfa, 0xf7, 0x0, 0x0, 0x6, 0xff, 0xef, 0x10,
    0x0, 0x0, 0xf, 0xff, 0xf0, 0x0, 0x0, 0x0,
    0xff, 0xef, 0x10, 0x0, 0x0, 0x1f, 0xfa, 0xf7,
    0x0, 0x0, 0x7, 0xff, 0x3f, 0xf6, 0x0, 0x5,
    0xff, 0xf0, 0x6f, 0xfe, 0xce, 0xfc, 0xef, 0x0,
    0x3a, 0xef, 0xd7, 0xd, 0xf0,

    /* U+0062 "b" */
    0x3f, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xb1, 0x9e, 0xfd, 0x92, 0x0, 0x3f, 0xde,
    0xfd, 0xce, 0xfe, 0x30, 0x3f, 0xfe, 0x30, 0x0,
    0x8f, 0xe1, 0x3f, 0xf3, 0x0, 0x0, 0xa, 0xf7,
    0x3f, 0xd0, 0x0, 0x0, 0x4, 0xfa, 0x3f, 0xb0,
    0x0, 0x0, 0x2, 0xfc, 0x3f, 0xd0, 0x0, 0x0,
    0x4, 0xfa, 0x3f, 0xf3, 0x0, 0x0, 0xa, 0xf6,
    0x3f, 0xfe, 0x30, 0x0, 0x8f, 0xe1, 0x3f, 0xce,
    0xfd, 0xcf, 0xff, 0x30, 0x3f, 0xa1, 0x9e, 0xfe,
    0x92, 0x0,

    /* U+0063 "c" */
    0x0, 0x3, 0xae, 0xfe, 0x91, 0x0, 0x7, 0xff,
    0xdc, 0xef, 0xf3, 0x4, 0xfe, 0x40, 0x0, 0x7f,
    0x60, 0xcf, 0x40, 0x0, 0x0, 0x10, 0xf, 0xe0,
    0x0, 0x0, 0x0, 0x2, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0x40, 0x0, 0x0, 0x10, 0x4, 0xfe, 0x40, 0x0,
    0x7f, 0x60, 0x7, 0xff, 0xec, 0xef, 0xe2, 0x0,
    0x3, 0xae, 0xfe, 0x91, 0x0,

    /* U+0064 "d" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x1, 0xfd,
    0x0, 0x4, 0xbe, 0xfc, 0x61, 0xfd, 0x0, 0x8f,
    0xfd, 0xce, 0xfb, 0xfd, 0x5, 0xfe, 0x40, 0x0,
    0x7f, 0xfd, 0xc, 0xf4, 0x0, 0x0, 0x9, 0xfd,
    0xf, 0xe0, 0x0, 0x0, 0x3, 0xfd, 0x2f, 0xc0,
    0x0, 0x0, 0x1, 0xfd, 0xf, 0xe0, 0x0, 0x0,
    0x3, 0xfd, 0xc, 0xf4, 0x0, 0x0, 0x9, 0xfd,
    0x5, 0xfe, 0x40, 0x0, 0x7f, 0xfd, 0x0, 0x8f,
    0xfd, 0xce, 0xfa, 0xfd, 0x0, 0x4, 0xbe, 0xfc,
    0x60, 0xfd,

    /* U+0065 "e" */
    0x0, 0x4, 0xbe, 0xfc, 0x60, 0x0, 0x0, 0x8f,
    0xfc, 0xbe, 0xfb, 0x0, 0x5, 0xfd, 0x20, 0x0,
    0xaf, 0x80, 0xc, 0xf3, 0x0, 0x0, 0xd, 0xf0,
    0xf, 0xe1, 0x11, 0x11, 0x19, 0xf4, 0x2f, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0xf, 0xe4, 0x44, 0x44,
    0x44, 0x41, 0xc, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xfe, 0x40, 0x0, 0x2b, 0x20, 0x0, 0x7f,
    0xfe, 0xcd, 0xff, 0x60, 0x0, 0x3, 0xae, 0xfe,
    0xa3, 0x0,

    /* U+0066 "f" */
    0x0, 0x6, 0xdf, 0xd6, 0x0, 0x6f, 0xea, 0xc6,
    0x0, 0xcf, 0x20, 0x0, 0x0, 0xef, 0x0, 0x0,
    0xbf, 0xff, 0xff, 0xf1, 0x7a, 0xff, 0xaa, 0xa0,
    0x0, 0xef, 0x0, 0x0, 0x0, 0xef, 0x0, 0x0,
    0x0, 0xef, 0x0, 0x0, 0x0, 0xef, 0x0, 0x0,
    0x0, 0xef, 0x0, 0x0, 0x0, 0xef, 0x0, 0x0,
    0x0, 0xef, 0x0, 0x0, 0x0, 0xef, 0x0, 0x0,
    0x0, 0xef, 0x0, 0x0,

    /* U+0067 "g" */
    0x0, 0x4, 0xbe, 0xfd, 0x70, 0xdf, 0x0, 0x8f,
    0xfd, 0xce, 0xfc, 0xef, 0x5, 0xfe, 0x40, 0x0,
    0x5f, 0xff, 0xc, 0xf4, 0x0, 0x0, 0x7, 0xff,
    0xf, 0xe0, 0x0, 0x0, 0x0, 0xff, 0x2f, 0xc0,
    0x0, 0x0, 0x0, 0xff, 0xf, 0xe0, 0x0, 0x0,
    0x1, 0xff, 0xc, 0xf4, 0x0, 0x0, 0x7, 0xff,
    0x5, 0xfe, 0x40, 0x0, 0x5f, 0xff, 0x0, 0x8f,
    0xfd, 0xbe, 0xfc, 0xff, 0x0, 0x4, 0xbe, 0xfd,
    0x71, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfb,
    0x1, 0xa4, 0x0, 0x0, 0x2d, 0xf5, 0x4, 0xff,
    0xec, 0xbd, 0xff, 0x90, 0x0, 0x28, 0xce, 0xfe,
    0xb5, 0x0,

    /* U+0068 "h" */
    0x3f, 0xb0, 0x0, 0x0, 0x0, 0x3, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xb0, 0x0, 0x0, 0x0,
    0x3, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xb1,
    0x9e, 0xfe, 0x91, 0x3, 0xfd, 0xef, 0xdd, 0xff,
    0xd0, 0x3f, 0xfc, 0x20, 0x2, 0xdf, 0x73, 0xff,
    0x20, 0x0, 0x4, 0xfc, 0x3f, 0xd0, 0x0, 0x0,
    0x1f, 0xe3, 0xfb, 0x0, 0x0, 0x0, 0xfe, 0x3f,
    0xb0, 0x0, 0x0, 0xf, 0xe3, 0xfb, 0x0, 0x0,
    0x0, 0xfe, 0x3f, 0xb0, 0x0, 0x0, 0xf, 0xe3,
    0xfb, 0x0, 0x0, 0x0, 0xfe, 0x3f, 0xb0, 0x0,
    0x0, 0xf, 0xe0,

    /* U+0069 "i" */
    0x3e, 0xb0, 0x7f, 0xf0, 0x8, 0x40, 0x0, 0x0,
    0x3f, 0xb0, 0x3f, 0xb0, 0x3f, 0xb0, 0x3f, 0xb0,
    0x3f, 0xb0, 0x3f, 0xb0, 0x3f, 0xb0, 0x3f, 0xb0,
    0x3f, 0xb0, 0x3f, 0xb0, 0x3f, 0xb0,

    /* U+006A "j" */
    0x0, 0x2, 0xec, 0x0, 0x0, 0x5f, 0xf1, 0x0,
    0x0, 0x75, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xfd, 0x0, 0x0, 0x1f, 0xd0, 0x0, 0x1, 0xfd,
    0x0, 0x0, 0x1f, 0xd0, 0x0, 0x1, 0xfd, 0x0,
    0x0, 0x1f, 0xd0, 0x0, 0x1, 0xfd, 0x0, 0x0,
    0x1f, 0xd0, 0x0, 0x1, 0xfd, 0x0, 0x0, 0x1f,
    0xd0, 0x0, 0x1, 0xfd, 0x0, 0x0, 0x1f, 0xc0,
    0x0, 0x5, 0xfa, 0x8, 0xdb, 0xff, 0x30, 0x7e,
    0xfd, 0x50, 0x0,

    /* U+006B "k" */
    0x3f, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xb0, 0x0, 0x2, 0xdf, 0x50, 0x3f, 0xb0,
    0x0, 0x2e, 0xf6, 0x0, 0x3f, 0xb0, 0x3, 0xef,
    0x60, 0x0, 0x3f, 0xb0, 0x3f, 0xf6, 0x0, 0x0,
    0x3f, 0xb4, 0xff, 0x90, 0x0, 0x0, 0x3f, 0xef,
    0xff, 0xf2, 0x0, 0x0, 0x3f, 0xff, 0x49, 0xfd,
    0x0, 0x0, 0x3f, 0xf4, 0x0, 0xcf, 0x90, 0x0,
    0x3f, 0xb0, 0x0, 0x1e, 0xf6, 0x0, 0x3f, 0xb0,
    0x0, 0x4, 0xff, 0x20, 0x3f, 0xb0, 0x0, 0x0,
    0x7f, 0xd0,

    /* U+006C "l" */
    0x3f, 0xb3, 0xfb, 0x3f, 0xb3, 0xfb, 0x3f, 0xb3,
    0xfb, 0x3f, 0xb3, 0xfb, 0x3f, 0xb3, 0xfb, 0x3f,
    0xb3, 0xfb, 0x3f, 0xb3, 0xfb, 0x3f, 0xb0,

    /* U+006D "m" */
    0x3f, 0xa2, 0xae, 0xfd, 0x70, 0x5, 0xbe, 0xfc,
    0x50, 0x3, 0xfd, 0xff, 0xcd, 0xff, 0xa8, 0xff,
    0xce, 0xff, 0x60, 0x3f, 0xfc, 0x10, 0x4, 0xff,
    0xfa, 0x0, 0x6, 0xff, 0x3, 0xff, 0x20, 0x0,
    0x9, 0xfe, 0x0, 0x0, 0xc, 0xf4, 0x3f, 0xd0,
    0x0, 0x0, 0x6f, 0xa0, 0x0, 0x0, 0x8f, 0x63,
    0xfb, 0x0, 0x0, 0x5, 0xf9, 0x0, 0x0, 0x8,
    0xf6, 0x3f, 0xb0, 0x0, 0x0, 0x5f, 0x90, 0x0,
    0x0, 0x8f, 0x63, 0xfb, 0x0, 0x0, 0x5, 0xf9,
    0x0, 0x0, 0x8, 0xf6, 0x3f, 0xb0, 0x0, 0x0,
    0x5f, 0x90, 0x0, 0x0, 0x8f, 0x63, 0xfb, 0x0,
    0x0, 0x5, 0xf9, 0x0, 0x0, 0x8, 0xf6, 0x3f,
    0xb0, 0x0, 0x0, 0x5f, 0x90, 0x0, 0x0, 0x8f,
    0x60,

    /* U+006E "n" */
    0x3f, 0xa2, 0x9e, 0xfe, 0x91, 0x3, 0xfc, 0xff,
    0xdd, 0xff, 0xd0, 0x3f, 0xfc, 0x20, 0x2, 0xdf,
    0x73, 0xff, 0x20, 0x0, 0x4, 0xfc, 0x3f, 0xd0,
    0x0, 0x0, 0x1f, 0xe3, 0xfb, 0x0, 0x0, 0x0,
    0xfe, 0x3f, 0xb0, 0x0, 0x0, 0xf, 0xe3, 0xfb,
    0x0, 0x0, 0x0, 0xfe, 0x3f, 0xb0, 0x0, 0x0,
    0xf, 0xe3, 0xfb, 0x0, 0x0, 0x0, 0xfe, 0x3f,
    0xb0, 0x0, 0x0, 0xf, 0xe0,

    /* U+006F "o" */
    0x0, 0x3, 0xae, 0xfd, 0x91, 0x0, 0x0, 0x7f,
    0xfd, 0xce, 0xfe, 0x40, 0x4, 0xfe, 0x40, 0x0,
    0x7f, 0xe1, 0xc, 0xf4, 0x0, 0x0, 0x9, 0xf7,
    0xf, 0xe0, 0x0, 0x0, 0x3, 0xfb, 0x2f, 0xc0,
    0x0, 0x0, 0x1, 0xfd, 0xf, 0xe0, 0x0, 0x0,
    0x3, 0xfb, 0xc, 0xf4, 0x0, 0x0, 0x9, 0xf7,
    0x4, 0xfe, 0x40, 0x0, 0x7f, 0xe1, 0x0, 0x7f,
    0xfd, 0xce, 0xfe, 0x30, 0x0, 0x3, 0xae, 0xfd,
    0x91, 0x0,

    /* U+0070 "p" */
    0x3f, 0xa2, 0x9e, 0xfd, 0x92, 0x0, 0x3f, 0xdf,
    0xfb, 0xad, 0xfe, 0x30, 0x3f, 0xfd, 0x20, 0x0,
    0x6f, 0xe1, 0x3f, 0xf3, 0x0, 0x0, 0x9, 0xf7,
    0x3f, 0xd0, 0x0, 0x0, 0x4, 0xfa, 0x3f, 0xb0,
    0x0, 0x0, 0x2, 0xfc, 0x3f, 0xd0, 0x0, 0x0,
    0x4, 0xfa, 0x3f, 0xf4, 0x0, 0x0, 0xa, 0xf6,
    0x3f, 0xfe, 0x30, 0x0, 0x8f, 0xe1, 0x3f, 0xde,
    0xfd, 0xcf, 0xff, 0x30, 0x3f, 0xb1, 0x8e, 0xfe,
    0x92, 0x0, 0x3f, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xb0, 0x0, 0x0,
    0x0, 0x0,

    /* U+0071 "q" */
    0x0, 0x4, 0xbe, 0xfc, 0x60, 0xfd, 0x0, 0x8f,
    0xfd, 0xce, 0xfb, 0xfd, 0x5, 0xfe, 0x40, 0x0,
    0x7f, 0xfd, 0xc, 0xf4, 0x0, 0x0, 0x9, 0xfd,
    0xf, 0xe0, 0x0, 0x0, 0x3, 0xfd, 0x2f, 0xc0,
    0x0, 0x0, 0x1, 0xfd, 0xf, 0xe0, 0x0, 0x0,
    0x3, 0xfd, 0xc, 0xf4, 0x0, 0x0, 0x9, 0xfd,
    0x5, 0xfe, 0x40, 0x0, 0x7f, 0xfd, 0x0, 0x8f,
    0xfd, 0xce, 0xfb, 0xfd, 0x0, 0x4, 0xbe, 0xfc,
    0x61, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x1, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xfd,

    /* U+0072 "r" */
    0x3f, 0xa2, 0xae, 0x83, 0xfc, 0xff, 0xe6, 0x3f,
    0xfd, 0x30, 0x3, 0xff, 0x30, 0x0, 0x3f, 0xe0,
    0x0, 0x3, 0xfc, 0x0, 0x0, 0x3f, 0xb0, 0x0,
    0x3, 0xfb, 0x0, 0x0, 0x3f, 0xb0, 0x0, 0x3,
    0xfb, 0x0, 0x0, 0x3f, 0xb0, 0x0, 0x0,

    /* U+0073 "s" */
    0x0, 0x6c, 0xff, 0xea, 0x50, 0x8, 0xff, 0xcb,
    0xdf, 0xd0, 0x1f, 0xe1, 0x0, 0x2, 0x30, 0x2f,
    0xd0, 0x0, 0x0, 0x0, 0xd, 0xfc, 0x73, 0x0,
    0x0, 0x1, 0xbf, 0xff, 0xfb, 0x30, 0x0, 0x1,
    0x47, 0xcf, 0xf2, 0x0, 0x0, 0x0, 0x9, 0xf6,
    0x9, 0x30, 0x0, 0xb, 0xf5, 0x5f, 0xfe, 0xbb,
    0xef, 0xc0, 0x4, 0xae, 0xff, 0xd7, 0x0,

    /* U+0074 "t" */
    0x0, 0x78, 0x0, 0x0, 0x0, 0xef, 0x0, 0x0,
    0x0, 0xef, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xf1,
    0x7a, 0xff, 0xaa, 0xa0, 0x0, 0xef, 0x0, 0x0,
    0x0, 0xef, 0x0, 0x0, 0x0, 0xef, 0x0, 0x0,
    0x0, 0xef, 0x0, 0x0, 0x0, 0xef, 0x0, 0x0,
    0x0, 0xef, 0x0, 0x0, 0x0, 0xcf, 0x40, 0x0,
    0x0, 0x6f, 0xfb, 0xd7, 0x0, 0x7, 0xdf, 0xd5,

    /* U+0075 "u" */
    0x4f, 0xa0, 0x0, 0x0, 0x3f, 0xb4, 0xfa, 0x0,
    0x0, 0x3, 0xfb, 0x4f, 0xa0, 0x0, 0x0, 0x3f,
    0xb4, 0xfa, 0x0, 0x0, 0x3, 0xfb, 0x4f, 0xa0,
    0x0, 0x0, 0x3f, 0xb4, 0xfa, 0x0, 0x0, 0x3,
    0xfb, 0x4f, 0xb0, 0x0, 0x0, 0x5f, 0xb2, 0xfe,
    0x0, 0x0, 0xa, 0xfb, 0xd, 0xf8, 0x0, 0x6,
    0xff, 0xb0, 0x4f, 0xfe, 0xce, 0xfb, 0xfb, 0x0,
    0x3b, 0xef, 0xd6, 0x2f, 0xb0,

    /* U+0076 "v" */
    0xd, 0xf2, 0x0, 0x0, 0x0, 0xef, 0x0, 0x6f,
    0x90, 0x0, 0x0, 0x5f, 0x90, 0x0, 0xff, 0x0,
    0x0, 0xb, 0xf2, 0x0, 0x9, 0xf6, 0x0, 0x2,
    0xfb, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x9f, 0x40,
    0x0, 0x0, 0xbf, 0x30, 0xf, 0xd0, 0x0, 0x0,
    0x4, 0xfa, 0x7, 0xf7, 0x0, 0x0, 0x0, 0xd,
    0xf1, 0xdf, 0x10, 0x0, 0x0, 0x0, 0x7f, 0xbf,
    0x90, 0x0, 0x0, 0x0, 0x1, 0xff, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xfc, 0x0, 0x0, 0x0,

    /* U+0077 "w" */
    0xbf, 0x10, 0x0, 0x0, 0xef, 0x0, 0x0, 0x1,
    0xfa, 0x5f, 0x70, 0x0, 0x5, 0xff, 0x60, 0x0,
    0x6, 0xf5, 0xf, 0xd0, 0x0, 0xb, 0xff, 0xb0,
    0x0, 0xc, 0xe0, 0xa, 0xf2, 0x0, 0x1f, 0xbb,
    0xf1, 0x0, 0x2f, 0x90, 0x4, 0xf8, 0x0, 0x6f,
    0x55, 0xf7, 0x0, 0x7f, 0x30, 0x0, 0xed, 0x0,
    0xce, 0x0, 0xed, 0x0, 0xde, 0x0, 0x0, 0x8f,
    0x32, 0xf9, 0x0, 0x9f, 0x23, 0xf8, 0x0, 0x0,
    0x3f, 0x98, 0xf3, 0x0, 0x3f, 0x89, 0xf2, 0x0,
    0x0, 0xd, 0xee, 0xd0, 0x0, 0xd, 0xee, 0xc0,
    0x0, 0x0, 0x7, 0xff, 0x70, 0x0, 0x7, 0xff,
    0x70, 0x0, 0x0, 0x1, 0xff, 0x10, 0x0, 0x2,
    0xff, 0x10, 0x0,

    /* U+0078 "x" */
    0x2f, 0xe1, 0x0, 0x0, 0xdf, 0x30, 0x6f, 0xb0,
    0x0, 0xaf, 0x60, 0x0, 0xaf, 0x70, 0x6f, 0xb0,
    0x0, 0x0, 0xdf, 0x5f, 0xe1, 0x0, 0x0, 0x3,
    0xff, 0xf3, 0x0, 0x0, 0x0, 0xb, 0xfc, 0x0,
    0x0, 0x0, 0x6, 0xff, 0xf6, 0x0, 0x0, 0x2,
    0xfe, 0x2e, 0xf2, 0x0, 0x0, 0xdf, 0x40, 0x4f,
    0xd0, 0x0, 0x9f, 0x80, 0x0, 0x8f, 0xa0, 0x5f,
    0xc0, 0x0, 0x0, 0xcf, 0x60,

    /* U+0079 "y" */
    0xd, 0xf2, 0x0, 0x0, 0x0, 0xef, 0x0, 0x6f,
    0x90, 0x0, 0x0, 0x5f, 0x80, 0x0, 0xef, 0x0,
    0x0, 0xb, 0xf2, 0x0, 0x8, 0xf6, 0x0, 0x2,
    0xfb, 0x0, 0x0, 0x1f, 0xd0, 0x0, 0x9f, 0x40,
    0x0, 0x0, 0xaf, 0x40, 0xf, 0xd0, 0x0, 0x0,
    0x4, 0xfb, 0x7, 0xf6, 0x0, 0x0, 0x0, 0xd,
    0xf2, 0xdf, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xcf,
    0x80, 0x0, 0x0, 0x0, 0x0, 0xef, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x40, 0x0, 0x0, 0x3, 0x0,
    0x3f, 0xc0, 0x0, 0x0, 0x2, 0xfd, 0xbf, 0xf3,
    0x0, 0x0, 0x0, 0x8, 0xef, 0xc4, 0x0, 0x0,
    0x0, 0x0,

    /* U+007A "z" */
    0x1f, 0xff, 0xff, 0xff, 0xf8, 0xa, 0xaa, 0xaa,
    0xaf, 0xf5, 0x0, 0x0, 0x0, 0x9f, 0x90, 0x0,
    0x0, 0x6, 0xfc, 0x0, 0x0, 0x0, 0x3f, 0xe1,
    0x0, 0x0, 0x1, 0xdf, 0x40, 0x0, 0x0, 0xb,
    0xf7, 0x0, 0x0, 0x0, 0x7f, 0xa0, 0x0, 0x0,
    0x4, 0xfd, 0x0, 0x0, 0x0, 0x1e, 0xfc, 0xaa,
    0xaa, 0xa6, 0x3f, 0xff, 0xff, 0xff, 0xfb,

    /* U+007B "{" */
    0x0, 0x3c, 0xfa, 0x0, 0xef, 0xc6, 0x3, 0xfc,
    0x0, 0x4, 0xfa, 0x0, 0x4, 0xfa, 0x0, 0x4,
    0xfa, 0x0, 0x4, 0xfa, 0x0, 0x4, 0xfa, 0x0,
    0x8e, 0xf5, 0x0, 0xdf, 0xe2, 0x0, 0x7, 0xf9,
    0x0, 0x4, 0xfa, 0x0, 0x4, 0xfa, 0x0, 0x4,
    0xfa, 0x0, 0x4, 0xfa, 0x0, 0x4, 0xfa, 0x0,
    0x2, 0xfd, 0x0, 0x0, 0xef, 0xc6, 0x0, 0x3c,
    0xfa,

    /* U+007C "|" */
    0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee,
    0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee,
    0xee, 0xee, 0xee,

    /* U+007D "}" */
    0xaf, 0xc4, 0x0, 0x6c, 0xfe, 0x0, 0x0, 0xcf,
    0x30, 0x0, 0xaf, 0x40, 0x0, 0xaf, 0x40, 0x0,
    0xaf, 0x40, 0x0, 0xaf, 0x40, 0x0, 0x9f, 0x50,
    0x0, 0x5f, 0xe8, 0x0, 0x2e, 0xfd, 0x0, 0x9f,
    0x70, 0x0, 0x9f, 0x40, 0x0, 0xaf, 0x40, 0x0,
    0xaf, 0x40, 0x0, 0xaf, 0x40, 0x0, 0xaf, 0x40,
    0x0, 0xcf, 0x30, 0x6c, 0xfe, 0x0, 0xaf, 0xc3,
    0x0,

    /* U+007E "~" */
    0x2, 0x76, 0x0, 0x0, 0x63, 0x2f, 0xff, 0xd2,
    0x0, 0xf5, 0x9d, 0x13, 0xdf, 0x9c, 0xf1, 0xc7,
    0x0, 0x9, 0xfd, 0x40,

    /* U+00A0 " " */

    /* U+00A1 "¡" */
    0x4e, 0x99, 0xfe, 0x19, 0x40, 0x0, 0x8, 0x31,
    0xf7, 0x2f, 0x83, 0xf8, 0x3f, 0x94, 0xfa, 0x4f,
    0xa5, 0xfb, 0x6f, 0xc6, 0xfc,

    /* U+00A2 "¢" */
    0x0, 0x0, 0x4, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x5e, 0x0, 0x0, 0x0, 0x0, 0x5, 0xe0, 0x0,
    0x0, 0x0, 0x4c, 0xff, 0xeb, 0x20, 0x0, 0x8f,
    0xfe, 0xfd, 0xff, 0x30, 0x5f, 0xe3, 0x5e, 0x6,
    0xf5, 0xc, 0xf4, 0x5, 0xe0, 0x1, 0x0, 0xfe,
    0x0, 0x5e, 0x0, 0x0, 0x2f, 0xc0, 0x5, 0xe0,
    0x0, 0x0, 0xfe, 0x0, 0x5e, 0x0, 0x0, 0xc,
    0xf4, 0x5, 0xe0, 0x1, 0x0, 0x5f, 0xe3, 0x5e,
    0x6, 0xf6, 0x0, 0x8f, 0xfe, 0xfe, 0xff, 0x30,
    0x0, 0x4b, 0xff, 0xea, 0x20, 0x0, 0x0, 0x5,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x5e, 0x0, 0x0,

    /* U+00A3 "£" */
    0x0, 0x0, 0x6, 0xbe, 0xff, 0xd8, 0x10, 0x0,
    0xc, 0xff, 0xfd, 0xef, 0xf6, 0x0, 0xa, 0xfc,
    0x30, 0x0, 0x5, 0x0, 0x0, 0xff, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x14, 0xfc, 0x11, 0x11, 0x10, 0x0, 0x6f,
    0xff, 0xff, 0xff, 0xff, 0x10, 0x1, 0x46, 0xfd,
    0x44, 0x44, 0x40, 0x0, 0x0, 0x3f, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x5c, 0xdf,
    0xfc, 0xcc, 0xcc, 0xcc, 0x36, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf5,

    /* U+00A4 "¤" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc,
    0x50, 0x0, 0x0, 0x0, 0x5, 0xc0, 0x1e, 0xf4,
    0x5c, 0xff, 0xc5, 0x5f, 0xe1, 0x2, 0xef, 0xfe,
    0xbb, 0xef, 0xfe, 0x20, 0x0, 0x8f, 0x90, 0x0,
    0x9, 0xf8, 0x0, 0x1, 0xfb, 0x0, 0x0, 0x0,
    0xbf, 0x10, 0x4, 0xf5, 0x0, 0x0, 0x0, 0x4f,
    0x50, 0x6, 0xf3, 0x0, 0x0, 0x0, 0x2f, 0x60,
    0x4, 0xf5, 0x0, 0x0, 0x0, 0x4f, 0x50, 0x1,
    0xfb, 0x0, 0x0, 0x0, 0xbf, 0x10, 0x0, 0x8f,
    0x90, 0x0, 0x9, 0xf8, 0x0, 0x1, 0xdf, 0xfe,
    0xbb, 0xef, 0xfd, 0x10, 0x1d, 0xf5, 0x5c, 0xff,
    0xc5, 0x6f, 0xd1, 0xd, 0x60, 0x0, 0x0, 0x0,
    0x6, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+00A5 "¥" */
    0xb, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0x1, 0xef, 0x20, 0x0, 0x0, 0x0, 0xdf, 0x30,
    0x0, 0x5f, 0xc0, 0x0, 0x0, 0x8, 0xf7, 0x0,
    0x0, 0xa, 0xf7, 0x0, 0x0, 0x4f, 0xc0, 0x0,
    0x0, 0x1, 0xef, 0x20, 0x1, 0xef, 0x20, 0x0,
    0x0, 0x0, 0x4f, 0xd0, 0xa, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xf8, 0x5f, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xfe, 0x10, 0x0, 0x0,
    0x0, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0x2, 0x22, 0x2e, 0xf3, 0x22, 0x20, 0x0,
    0x0, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0x0, 0x2, 0x22, 0x2e, 0xf3, 0x22, 0x20, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf1, 0x0, 0x0, 0x0,

    /* U+00A6 "¦" */
    0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0x22,
    0x0, 0x0, 0x0, 0x22, 0xee, 0xee, 0xee, 0xee,
    0xee, 0xee, 0xee,

    /* U+00A7 "§" */
    0x0, 0x2a, 0xef, 0xec, 0x70, 0x3, 0xff, 0xb9,
    0xbe, 0xf3, 0xb, 0xf2, 0x0, 0x0, 0x40, 0xd,
    0xe0, 0x0, 0x0, 0x0, 0x9, 0xfa, 0x20, 0x0,
    0x0, 0x1, 0xff, 0xfe, 0x93, 0x0, 0xb, 0xf7,
    0x7b, 0xff, 0x80, 0x2f, 0x80, 0x0, 0x1c, 0xf2,
    0x3f, 0x80, 0x0, 0x6, 0xf4, 0xe, 0xf7, 0x10,
    0xb, 0xf1, 0x2, 0xcf, 0xfd, 0xdf, 0x70, 0x0,
    0x2, 0x7b, 0xff, 0x30, 0x0, 0x0, 0x0, 0x3f,
    0xc0, 0x0, 0x0, 0x0, 0xe, 0xd0, 0x2e, 0x72,
    0x1, 0x8f, 0x90, 0x2d, 0xff, 0xff, 0xfc, 0x0,
    0x0, 0x37, 0x88, 0x40, 0x0,

    /* U+00A8 "¨" */
    0x0, 0x0, 0x0, 0xbe, 0x1, 0xfb, 0xad, 0x1,
    0xe9,

    /* U+00A9 "©" */
    0x0, 0x0, 0x7, 0xce, 0xec, 0x71, 0x0, 0x0,
    0x0, 0x3, 0xd8, 0x20, 0x2, 0x8e, 0x50, 0x0,
    0x0, 0x3d, 0x20, 0x0, 0x0, 0x2, 0xd4, 0x0,
    0x0, 0xd2, 0x0, 0x0, 0x0, 0x0, 0x2e, 0x10,
    0x6, 0x90, 0x3, 0xbf, 0xfe, 0x60, 0x8, 0x80,
    0xc, 0x30, 0x2f, 0xd6, 0x5a, 0xf3, 0x2, 0xd0,
    0xf, 0x0, 0xae, 0x10, 0x0, 0x20, 0x0, 0xe0,
    0xe, 0x0, 0xe9, 0x0, 0x0, 0x0, 0x0, 0xe0,
    0xf, 0x0, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xe0,
    0xc, 0x30, 0xcd, 0x0, 0x0, 0x0, 0x2, 0xc0,
    0x7, 0x90, 0x4f, 0xb3, 0x27, 0xe2, 0x9, 0x70,
    0x0, 0xe2, 0x5, 0xef, 0xff, 0x90, 0x2e, 0x0,
    0x0, 0x4d, 0x20, 0x3, 0x41, 0x2, 0xd4, 0x0,
    0x0, 0x4, 0xe8, 0x20, 0x2, 0x8e, 0x40, 0x0,
    0x0, 0x0, 0x17, 0xce, 0xec, 0x70, 0x0, 0x0,

    /* U+00AA "ª" */
    0x7, 0xcf, 0xea, 0x0, 0x95, 0x14, 0xf9, 0x0,
    0x0, 0xa, 0xc0, 0x8d, 0xdd, 0xec, 0x3f, 0x40,
    0x1c, 0xc0, 0x9e, 0xfc, 0xac,

    /* U+00AB "«" */
    0x0, 0x7, 0xd3, 0x9, 0xd1, 0x0, 0x3f, 0x80,
    0x6f, 0x60, 0x1, 0xed, 0x2, 0xfa, 0x0, 0xa,
    0xf2, 0xd, 0xe1, 0x0, 0xc, 0xe1, 0x1e, 0xd0,
    0x0, 0x1, 0xeb, 0x3, 0xf9, 0x0, 0x0, 0x5f,
    0x70, 0x7f, 0x40, 0x0, 0x9, 0xf3, 0xb, 0xe1,

    /* U+00AC "¬" */
    0x6a, 0xaa, 0xaa, 0xaa, 0xa2, 0xaf, 0xff, 0xff,
    0xff, 0xf4, 0x0, 0x0, 0x0, 0x6, 0xf4, 0x0,
    0x0, 0x0, 0x6, 0xf4, 0x0, 0x0, 0x0, 0x6,
    0xf4, 0x0, 0x0, 0x0, 0x3, 0x82,

    /* U+00AD "­" */
    0x9b, 0xbb, 0xb5, 0xef, 0xff, 0xf8,

    /* U+00AE "®" */
    0x0, 0x0, 0x7, 0xce, 0xec, 0x71, 0x0, 0x0,
    0x0, 0x3, 0xd8, 0x20, 0x2, 0x8e, 0x50, 0x0,
    0x0, 0x3d, 0x20, 0x0, 0x0, 0x2, 0xd4, 0x0,
    0x0, 0xd2, 0x0, 0x0, 0x0, 0x0, 0x2e, 0x10,
    0x6, 0x90, 0xc, 0xff, 0xfd, 0x60, 0x8, 0x80,
    0xc, 0x30, 0xd, 0x92, 0x37, 0xf5, 0x2, 0xd0,
    0xf, 0x0, 0xd, 0x80, 0x0, 0xc9, 0x0, 0xe0,
    0xe, 0x0, 0xd, 0x80, 0x3, 0xf6, 0x0, 0xe0,
    0xf, 0x0, 0xd, 0xff, 0xff, 0x90, 0x0, 0xe0,
    0xc, 0x30, 0xd, 0x92, 0x3f, 0x40, 0x2, 0xc0,
    0x7, 0x90, 0xd, 0x80, 0x7, 0xe0, 0x9, 0x70,
    0x0, 0xe2, 0xa, 0x70, 0x0, 0xb6, 0x2e, 0x0,
    0x0, 0x4d, 0x20, 0x0, 0x0, 0x2, 0xd4, 0x0,
    0x0, 0x4, 0xe8, 0x20, 0x2, 0x8e, 0x40, 0x0,
    0x0, 0x0, 0x17, 0xce, 0xec, 0x70, 0x0, 0x0,

    /* U+00AF "¯" */
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xf3,
    0x3, 0x33, 0x33, 0x30,

    /* U+00B0 "°" */
    0x0, 0x6d, 0xea, 0x10, 0x7, 0xe4, 0x3b, 0xc0,
    0xe, 0x40, 0x0, 0xe4, 0x1f, 0x0, 0x0, 0xa7,
    0xf, 0x20, 0x0, 0xd5, 0x9, 0xd1, 0x8, 0xe0,
    0x0, 0x9f, 0xfd, 0x20, 0x0, 0x0, 0x10, 0x0,

    /* U+00B1 "±" */
    0x0, 0x0, 0xc8, 0x0, 0x0, 0x0, 0x0, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0xfa, 0x0, 0x0, 0xaf, 0xff, 0xff, 0xff,
    0xf4, 0x6a, 0xaa, 0xfd, 0xaa, 0xa2, 0x0, 0x0,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6a,
    0xaa, 0xaa, 0xaa, 0xa2, 0xaf, 0xff, 0xff, 0xff,
    0xf4,

    /* U+00B2 "²" */
    0x6, 0xdf, 0xeb, 0x30, 0x2d, 0x74, 0x4b, 0xf0,
    0x0, 0x0, 0x4, 0xf2, 0x0, 0x0, 0xc, 0xc0,
    0x0, 0x1, 0xdc, 0x10, 0x0, 0x3e, 0x90, 0x0,
    0x6, 0xf9, 0x22, 0x21, 0x1f, 0xff, 0xff, 0xf9,

    /* U+00B3 "³" */
    0x3f, 0xff, 0xff, 0xf3, 0x2, 0x22, 0x4e, 0x90,
    0x0, 0x1, 0xd9, 0x0, 0x0, 0xc, 0xf9, 0x30,
    0x0, 0x3, 0x59, 0xf3, 0x0, 0x0, 0x0, 0xd8,
    0x3c, 0x64, 0x38, 0xf5, 0x18, 0xdf, 0xfc, 0x50,

    /* U+00B4 "´" */
    0x6, 0xa4, 0xe, 0xe1, 0x3f, 0x70,

    /* U+00B5 "µ" */
    0x3f, 0xb0, 0x0, 0x0, 0x2f, 0xc3, 0xfb, 0x0,
    0x0, 0x2, 0xfc, 0x3f, 0xb0, 0x0, 0x0, 0x2f,
    0xc3, 0xfb, 0x0, 0x0, 0x2, 0xfc, 0x3f, 0xb0,
    0x0, 0x0, 0x2f, 0xc3, 0xfb, 0x0, 0x0, 0x2,
    0xfc, 0x3f, 0xc0, 0x0, 0x0, 0x3f, 0xc3, 0xfe,
    0x0, 0x0, 0x7, 0xfc, 0x3f, 0xf8, 0x0, 0x3,
    0xff, 0xc3, 0xff, 0xfd, 0xac, 0xfd, 0xfc, 0x3f,
    0xb6, 0xdf, 0xd9, 0x1f, 0xc3, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xb0, 0x0, 0x0, 0x0, 0x3,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xb0, 0x0,
    0x0, 0x0, 0x0,

    /* U+00B6 "¶" */
    0x0, 0x8d, 0xff, 0xff, 0xff, 0xd0, 0xcf, 0xff,
    0xf9, 0x88, 0xed, 0x6f, 0xff, 0xff, 0x20, 0xb,
    0xd9, 0xff, 0xff, 0xf2, 0x0, 0xbd, 0x8f, 0xff,
    0xff, 0x20, 0xb, 0xd2, 0xff, 0xff, 0xf2, 0x0,
    0xbd, 0x5, 0xff, 0xff, 0x20, 0xb, 0xd0, 0x0,
    0x5a, 0xf2, 0x0, 0xbd, 0x0, 0x0, 0x7f, 0x20,
    0xb, 0xd0, 0x0, 0x7, 0xf2, 0x0, 0xbd, 0x0,
    0x0, 0x7f, 0x20, 0xb, 0xd0, 0x0, 0x7, 0xf2,
    0x0, 0xbd, 0x0, 0x0, 0x7f, 0x20, 0xb, 0xd0,
    0x0, 0x7, 0xf2, 0x0, 0xbd, 0x0, 0x0, 0x7f,
    0x20, 0xb, 0xd0, 0x0, 0x7, 0xf2, 0x0, 0xbd,
    0x0, 0x0, 0x7f, 0x20, 0xb, 0xd0, 0x0, 0x3,
    0x81, 0x0, 0x67,

    /* U+00B7 "·" */
    0x3c, 0x7a, 0xff, 0x5f, 0x90,

    /* U+00B8 "¸" */
    0x0, 0xb6, 0x0, 0xf, 0xc3, 0x0, 0x9, 0xd0,
    0x30, 0x9e, 0x2f, 0xfe, 0x50, 0x1, 0x0,

    /* U+00B9 "¹" */
    0x3f, 0xff, 0x50, 0x0, 0x23, 0xf5, 0x0, 0x0,
    0x1f, 0x50, 0x0, 0x1, 0xf5, 0x0, 0x0, 0x1f,
    0x50, 0x0, 0x1, 0xf5, 0x0, 0x12, 0x3f, 0x72,
    0x6, 0xff, 0xff, 0xf6,

    /* U+00BA "º" */
    0x1, 0xae, 0xfc, 0x40, 0xd, 0xc4, 0x38, 0xf3,
    0x4f, 0x10, 0x0, 0xca, 0x4f, 0x10, 0x0, 0xba,
    0xe, 0xa1, 0x6, 0xf5, 0x3, 0xcf, 0xfe, 0x60,
    0x0, 0x1, 0x20, 0x0,

    /* U+00BB "»" */
    0x1d, 0xa0, 0x2d, 0x80, 0x0, 0x5, 0xf6, 0x8,
    0xf4, 0x0, 0x0, 0xaf, 0x20, 0xce, 0x10, 0x0,
    0xd, 0xd0, 0x2f, 0xb0, 0x0, 0xc, 0xe1, 0x1e,
    0xc0, 0x0, 0x8f, 0x40, 0xbf, 0x20, 0x4, 0xf8,
    0x6, 0xf5, 0x0, 0x1e, 0xc0, 0x2f, 0xa0, 0x0,

    /* U+00BC "¼" */
    0x3f, 0xff, 0x50, 0x0, 0x0, 0x0, 0x1e, 0x80,
    0x0, 0x0, 0x3, 0x4f, 0x50, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x50, 0x0,
    0x0, 0x5, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0x50, 0x0, 0x0, 0x1e, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0x50, 0x0, 0x0, 0xbc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0x50, 0x0, 0x5, 0xf2,
    0x0, 0x4, 0x50, 0x0, 0x0, 0x1f, 0x50, 0x0,
    0x1e, 0x70, 0x0, 0x2f, 0x60, 0x0, 0x6f, 0xff,
    0xff, 0x60, 0xbc, 0x0, 0x0, 0xdb, 0x0, 0x0,
    0x13, 0x33, 0x33, 0x16, 0xf2, 0x0, 0x8, 0xe1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x70, 0x0,
    0x4f, 0x40, 0xa6, 0x0, 0x0, 0x0, 0x0, 0xbc,
    0x0, 0x1, 0xe9, 0x0, 0xc8, 0x0, 0x0, 0x0,
    0x6, 0xf2, 0x0, 0x7, 0xff, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0x2f, 0x60, 0x0, 0x1, 0x33, 0x33,
    0xe9, 0x30, 0x0, 0x0, 0xcc, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe8, 0x0, 0x0, 0x0, 0x31, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x21, 0x0,

    /* U+00BD "½" */
    0x3f, 0xff, 0x50, 0x0, 0x0, 0x0, 0x1e, 0x80,
    0x0, 0x0, 0x34, 0xf5, 0x0, 0x0, 0x0, 0xa,
    0xd0, 0x0, 0x0, 0x0, 0x1f, 0x50, 0x0, 0x0,
    0x5, 0xf3, 0x0, 0x0, 0x0, 0x1, 0xf5, 0x0,
    0x0, 0x1, 0xe7, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0x50, 0x0, 0x0, 0xbc, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xf5, 0x0, 0x0, 0x5f, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0x50, 0x0, 0x1e, 0x70, 0x8d,
    0xff, 0xc4, 0x6, 0xff, 0xff, 0xf6, 0xb, 0xc0,
    0x6, 0x30, 0x18, 0xf1, 0x13, 0x33, 0x33, 0x16,
    0xf2, 0x0, 0x0, 0x0, 0x3f, 0x30, 0x0, 0x0,
    0x1, 0xf7, 0x0, 0x0, 0x0, 0xb, 0xd0, 0x0,
    0x0, 0x0, 0xbc, 0x0, 0x0, 0x0, 0x1c, 0xd2,
    0x0, 0x0, 0x0, 0x6f, 0x20, 0x0, 0x0, 0x2d,
    0xc1, 0x0, 0x0, 0x0, 0x2f, 0x60, 0x0, 0x0,
    0x3e, 0xa0, 0x0, 0x0, 0x0, 0xc, 0xc0, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xfa, 0x0, 0x0, 0x31,
    0x0, 0x0, 0x0, 0x33, 0x33, 0x33, 0x10,

    /* U+00BE "¾" */
    0x3f, 0xff, 0xff, 0xf3, 0x0, 0x0, 0x1, 0xe8,
    0x0, 0x0, 0x0, 0x33, 0x34, 0xea, 0x0, 0x0,
    0x0, 0xad, 0x0, 0x0, 0x0, 0x0, 0x1, 0xda,
    0x0, 0x0, 0x0, 0x5f, 0x30, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0x82, 0x0, 0x0, 0x1e, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x5, 0x6b, 0xf2, 0x0, 0xb,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd,
    0x80, 0x5, 0xf2, 0x0, 0x4, 0x60, 0x0, 0x29,
    0x31, 0x5, 0xf6, 0x1, 0xe7, 0x0, 0x2, 0xf6,
    0x0, 0x2, 0xbf, 0xff, 0xf9, 0x0, 0xbc, 0x0,
    0x0, 0xda, 0x0, 0x0, 0x0, 0x2, 0x20, 0x0,
    0x6f, 0x20, 0x0, 0x9e, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0x70, 0x0, 0x4f, 0x40, 0xb7,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xc0, 0x0, 0x1e,
    0x80, 0xc, 0x80, 0x0, 0x0, 0x0, 0x6, 0xf2,
    0x0, 0x7, 0xff, 0xff, 0xff, 0xf2, 0x0, 0x0,
    0x2, 0xf6, 0x0, 0x0, 0x13, 0x33, 0x3e, 0x93,
    0x0, 0x0, 0x0, 0xcc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe8, 0x0, 0x0, 0x0, 0x3, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x2, 0x10, 0x0,

    /* U+00BF "¿" */
    0x0, 0x2, 0xec, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0x87, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x65, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xb0, 0x0,
    0x0, 0x0, 0x2e, 0xf4, 0x0, 0x0, 0x0, 0x2e,
    0xf6, 0x0, 0x0, 0x0, 0xe, 0xf4, 0x0, 0x0,
    0x0, 0x6, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0x70, 0x0, 0x0, 0x10, 0x7, 0xfd, 0x20, 0x0,
    0x4e, 0xc1, 0xd, 0xff, 0xdc, 0xef, 0xf7, 0x0,
    0x7, 0xdf, 0xfd, 0x93, 0x0,

    /* U+00C0 "À" */
    0x0, 0x0, 0xa, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0x84, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xaf, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xfa, 0x1f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xf3, 0xa, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xc0, 0x3, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x50, 0x0, 0xcf, 0x30, 0x0,
    0x0, 0x1, 0xfe, 0x0, 0x0, 0x5f, 0xa0, 0x0,
    0x0, 0x8, 0xf7, 0x0, 0x0, 0xe, 0xf2, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x0,
    0x0, 0x7f, 0xda, 0xaa, 0xaa, 0xaa, 0xff, 0x10,
    0x0, 0xef, 0x20, 0x0, 0x0, 0x0, 0x9f, 0x80,
    0x5, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xe0,
    0xd, 0xf3, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf6,

    /* U+00C1 "Á" */
    0x0, 0x0, 0x0, 0x5, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xaf, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xfa, 0x1f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xf3, 0xa, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xc0, 0x3, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x50, 0x0, 0xcf, 0x30, 0x0,
    0x0, 0x1, 0xfe, 0x0, 0x0, 0x5f, 0xa0, 0x0,
    0x0, 0x8, 0xf7, 0x0, 0x0, 0xe, 0xf2, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x0,
    0x0, 0x7f, 0xda, 0xaa, 0xaa, 0xaa, 0xff, 0x10,
    0x0, 0xef, 0x20, 0x0, 0x0, 0x0, 0x9f, 0x80,
    0x5, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xe0,
    0xd, 0xf3, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf6,

    /* U+00C2 "Â" */
    0x0, 0x0, 0x0, 0x3e, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xfa, 0x4e, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0x60, 0x1, 0x74, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xaf, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xfa, 0x1f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xf3, 0xa, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xc0, 0x3, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x50, 0x0, 0xcf, 0x30, 0x0,
    0x0, 0x1, 0xfe, 0x0, 0x0, 0x5f, 0xa0, 0x0,
    0x0, 0x8, 0xf7, 0x0, 0x0, 0xe, 0xf2, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x0,
    0x0, 0x7f, 0xda, 0xaa, 0xaa, 0xaa, 0xff, 0x10,
    0x0, 0xef, 0x20, 0x0, 0x0, 0x0, 0x9f, 0x80,
    0x5, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xe0,
    0xd, 0xf3, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf6,

    /* U+00C3 "Ã" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xee, 0x70, 0xa9, 0x0, 0x0,
    0x0, 0x0, 0xe, 0x52, 0xcf, 0xe2, 0x0, 0x0,
    0x0, 0x0, 0x3, 0x0, 0x2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xaf, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xfa, 0x1f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xf3, 0xa, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xc0, 0x3, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x50, 0x0, 0xcf, 0x30, 0x0,
    0x0, 0x1, 0xfe, 0x0, 0x0, 0x5f, 0xa0, 0x0,
    0x0, 0x8, 0xf7, 0x0, 0x0, 0xe, 0xf2, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x0,
    0x0, 0x7f, 0xda, 0xaa, 0xaa, 0xaa, 0xff, 0x10,
    0x0, 0xef, 0x20, 0x0, 0x0, 0x0, 0x9f, 0x80,
    0x5, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xe0,
    0xd, 0xf3, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf6,

    /* U+00C4 "Ä" */
    0x0, 0x0, 0x5, 0xf3, 0x9, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xf4, 0xb, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xaf, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xfa, 0x1f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xf3, 0xa, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xc0, 0x3, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x50, 0x0, 0xcf, 0x30, 0x0,
    0x0, 0x1, 0xfe, 0x0, 0x0, 0x5f, 0xa0, 0x0,
    0x0, 0x8, 0xf7, 0x0, 0x0, 0xe, 0xf2, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x0,
    0x0, 0x7f, 0xda, 0xaa, 0xaa, 0xaa, 0xff, 0x10,
    0x0, 0xef, 0x20, 0x0, 0x0, 0x0, 0x9f, 0x80,
    0x5, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xe0,
    0xd, 0xf3, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf6,

    /* U+00C5 "Å" */
    0x0, 0x0, 0x0, 0x2c, 0xe8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc3, 0xa, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd3, 0x9, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2c, 0xd8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xaf, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xfa, 0x1f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xf3, 0xa, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xc0, 0x3, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x50, 0x0, 0xcf, 0x30, 0x0,
    0x0, 0x1, 0xfe, 0x0, 0x0, 0x5f, 0xa0, 0x0,
    0x0, 0x8, 0xf7, 0x0, 0x0, 0xe, 0xf2, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x0,
    0x0, 0x7f, 0xda, 0xaa, 0xaa, 0xaa, 0xff, 0x10,
    0x0, 0xef, 0x20, 0x0, 0x0, 0x0, 0x9f, 0x80,
    0x5, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xe0,
    0xd, 0xf3, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf6,

    /* U+00C6 "Æ" */
    0x0, 0x0, 0x0, 0x0, 0x1e, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x9, 0xfe,
    0xfe, 0xcc, 0xcc, 0xcc, 0xc6, 0x0, 0x0, 0x0,
    0x2, 0xfd, 0x5f, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0x45, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xa0, 0x5f,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xf2, 0x5, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xf8, 0x0, 0x5f, 0xff, 0xff, 0xff,
    0xfa, 0x0, 0x0, 0x2, 0xfe, 0x0, 0x5, 0xfe,
    0xcc, 0xcc, 0xcc, 0x70, 0x0, 0x0, 0xbf, 0x50,
    0x0, 0x5f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xff, 0xff, 0xff, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xfa, 0xaa, 0xaa, 0xcf, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xf9, 0x0, 0x0,
    0x5, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x2, 0xfe,
    0x0, 0x0, 0x0, 0x5f, 0xec, 0xcc, 0xcc, 0xcc,
    0xa0, 0xbf, 0x50, 0x0, 0x0, 0x5, 0xff, 0xff,
    0xff, 0xff, 0xfd,

    /* U+00C7 "Ç" */
    0x0, 0x0, 0x17, 0xce, 0xfe, 0xa5, 0x0, 0x0,
    0x5, 0xff, 0xfe, 0xdf, 0xff, 0xc1, 0x0, 0x6f,
    0xf9, 0x20, 0x0, 0x3b, 0xf5, 0x2, 0xff, 0x50,
    0x0, 0x0, 0x0, 0x30, 0x9, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xff,
    0x50, 0x0, 0x0, 0x0, 0x30, 0x0, 0x6f, 0xf9,
    0x20, 0x0, 0x3b, 0xf5, 0x0, 0x5, 0xff, 0xfe,
    0xdf, 0xff, 0xc1, 0x0, 0x0, 0x17, 0xcf, 0xfe,
    0xb5, 0x0, 0x0, 0x0, 0x0, 0xc, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xda, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x10, 0x7f, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xff, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0x0, 0x0, 0x0,

    /* U+00C8 "È" */
    0x2, 0xcf, 0x50, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x48, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xe, 0xfd, 0xcc, 0xcc, 0xcc,
    0xc0, 0xef, 0x10, 0x0, 0x0, 0x0, 0xe, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xef,
    0xff, 0xff, 0xff, 0xf1, 0xe, 0xfc, 0xcc, 0xcc,
    0xcc, 0x10, 0xef, 0x10, 0x0, 0x0, 0x0, 0xe,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0,
    0x0, 0x0, 0xe, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xcc, 0xcc, 0xcc, 0xcc, 0x2e, 0xff, 0xff,
    0xff, 0xff, 0xf3,

    /* U+00C9 "É" */
    0x0, 0x0, 0x9f, 0x60, 0x0, 0x0, 0x0, 0xe,
    0xd0, 0x0, 0x0, 0x0, 0x2, 0xa4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xe, 0xfd, 0xcc, 0xcc, 0xcc,
    0xc0, 0xef, 0x10, 0x0, 0x0, 0x0, 0xe, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xef,
    0xff, 0xff, 0xff, 0xf1, 0xe, 0xfc, 0xcc, 0xcc,
    0xcc, 0x10, 0xef, 0x10, 0x0, 0x0, 0x0, 0xe,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0,
    0x0, 0x0, 0xe, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xcc, 0xcc, 0xcc, 0xcc, 0x2e, 0xff, 0xff,
    0xff, 0xff, 0xf3,

    /* U+00CA "Ê" */
    0x0, 0x6, 0xff, 0x70, 0x0, 0x0, 0x7, 0xf7,
    0x6f, 0x80, 0x0, 0x2, 0x84, 0x0, 0x38, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xe, 0xfd, 0xcc, 0xcc, 0xcc,
    0xc0, 0xef, 0x10, 0x0, 0x0, 0x0, 0xe, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xef,
    0xff, 0xff, 0xff, 0xf1, 0xe, 0xfc, 0xcc, 0xcc,
    0xcc, 0x10, 0xef, 0x10, 0x0, 0x0, 0x0, 0xe,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0,
    0x0, 0x0, 0xe, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xcc, 0xcc, 0xcc, 0xcc, 0x2e, 0xff, 0xff,
    0xff, 0xff, 0xf3,

    /* U+00CB "Ë" */
    0x0, 0x9e, 0x10, 0xda, 0x0, 0x0, 0xb, 0xf1,
    0xe, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xe, 0xfd, 0xcc, 0xcc, 0xcc,
    0xc0, 0xef, 0x10, 0x0, 0x0, 0x0, 0xe, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xef,
    0xff, 0xff, 0xff, 0xf1, 0xe, 0xfc, 0xcc, 0xcc,
    0xcc, 0x10, 0xef, 0x10, 0x0, 0x0, 0x0, 0xe,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0,
    0x0, 0x0, 0xe, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xcc, 0xcc, 0xcc, 0xcc, 0x2e, 0xff, 0xff,
    0xff, 0xff, 0xf3,

    /* U+00CC "Ì" */
    0x2c, 0xf6, 0x0, 0x0, 0x8f, 0x70, 0x0, 0x4,
    0x82, 0x0, 0x0, 0x0, 0x0, 0xe, 0xf1, 0x0,
    0xe, 0xf1, 0x0, 0xe, 0xf1, 0x0, 0xe, 0xf1,
    0x0, 0xe, 0xf1, 0x0, 0xe, 0xf1, 0x0, 0xe,
    0xf1, 0x0, 0xe, 0xf1, 0x0, 0xe, 0xf1, 0x0,
    0xe, 0xf1, 0x0, 0xe, 0xf1, 0x0, 0xe, 0xf1,
    0x0, 0xe, 0xf1, 0x0, 0xe, 0xf1,

    /* U+00CD "Í" */
    0x9, 0xf7, 0xe, 0xe0, 0x1a, 0x40, 0x0, 0x0,
    0xe, 0xf1, 0xe, 0xf1, 0xe, 0xf1, 0xe, 0xf1,
    0xe, 0xf1, 0xe, 0xf1, 0xe, 0xf1, 0xe, 0xf1,
    0xe, 0xf1, 0xe, 0xf1, 0xe, 0xf1, 0xe, 0xf1,
    0xe, 0xf1, 0xe, 0xf1,

    /* U+00CE "Î" */
    0x0, 0x6f, 0xf8, 0x0, 0x7, 0xf7, 0x5f, 0x90,
    0x17, 0x40, 0x3, 0x83, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0xe, 0xf1, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0xe, 0xf1, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0xe, 0xf1, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0xe, 0xf1, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0xe, 0xf1, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0xe, 0xf1, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0xe, 0xf1, 0x0,

    /* U+00CF "Ï" */
    0x8e, 0x10, 0xdb, 0xaf, 0x10, 0xec, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0,
    0xef, 0x10, 0x0, 0xef, 0x10, 0x0, 0xef, 0x10,
    0x0, 0xef, 0x10, 0x0, 0xef, 0x10, 0x0, 0xef,
    0x10, 0x0, 0xef, 0x10, 0x0, 0xef, 0x10, 0x0,
    0xef, 0x10, 0x0, 0xef, 0x10, 0x0, 0xef, 0x10,
    0x0, 0xef, 0x10, 0x0, 0xef, 0x10,

    /* U+00D0 "Ð" */
    0x0, 0xcf, 0xff, 0xff, 0xfd, 0xa5, 0x0, 0x0,
    0x0, 0xcf, 0xdc, 0xcc, 0xdf, 0xff, 0xc2, 0x0,
    0x0, 0xcf, 0x30, 0x0, 0x0, 0x4c, 0xfe, 0x20,
    0x0, 0xcf, 0x30, 0x0, 0x0, 0x0, 0xaf, 0xc0,
    0x0, 0xcf, 0x30, 0x0, 0x0, 0x0, 0xe, 0xf3,
    0x0, 0xcf, 0x30, 0x0, 0x0, 0x0, 0x8, 0xf8,
    0xdf, 0xff, 0xff, 0xff, 0x30, 0x0, 0x5, 0xfa,
    0x8a, 0xff, 0xda, 0xaa, 0x10, 0x0, 0x5, 0xfa,
    0x0, 0xcf, 0x30, 0x0, 0x0, 0x0, 0x8, 0xf8,
    0x0, 0xcf, 0x30, 0x0, 0x0, 0x0, 0xe, 0xf3,
    0x0, 0xcf, 0x30, 0x0, 0x0, 0x0, 0xaf, 0xc0,
    0x0, 0xcf, 0x30, 0x0, 0x0, 0x3c, 0xfe, 0x20,
    0x0, 0xcf, 0xdc, 0xcc, 0xdf, 0xff, 0xc2, 0x0,
    0x0, 0xcf, 0xff, 0xff, 0xfd, 0xa5, 0x0, 0x0,

    /* U+00D1 "Ñ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xd5, 0x1d, 0x50, 0x0, 0x0, 0x2f, 0x24,
    0xef, 0xd0, 0x0, 0x0, 0x0, 0x20, 0x0, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xf2, 0x0, 0x0, 0x0, 0xe, 0xf2, 0xef,
    0xd1, 0x0, 0x0, 0x0, 0xef, 0x2e, 0xff, 0xb0,
    0x0, 0x0, 0xe, 0xf2, 0xef, 0xef, 0x80, 0x0,
    0x0, 0xef, 0x2e, 0xf4, 0xff, 0x50, 0x0, 0xe,
    0xf2, 0xef, 0x15, 0xff, 0x30, 0x0, 0xef, 0x2e,
    0xf1, 0x8, 0xfd, 0x10, 0xe, 0xf2, 0xef, 0x10,
    0xb, 0xfb, 0x0, 0xef, 0x2e, 0xf1, 0x0, 0x1d,
    0xf9, 0xe, 0xf2, 0xef, 0x10, 0x0, 0x2f, 0xf5,
    0xef, 0x2e, 0xf1, 0x0, 0x0, 0x5f, 0xff, 0xf2,
    0xef, 0x10, 0x0, 0x0, 0x8f, 0xff, 0x2e, 0xf1,
    0x0, 0x0, 0x0, 0xbf, 0xf2, 0xef, 0x10, 0x0,
    0x0, 0x1, 0xdf, 0x20,

    /* U+00D2 "Ò" */
    0x0, 0x0, 0x7, 0x83, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xee, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2d, 0xe1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x75, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x17, 0xce, 0xfe, 0xb6, 0x0, 0x0,
    0x0, 0x5, 0xff, 0xfe, 0xdf, 0xff, 0xd3, 0x0,
    0x0, 0x5f, 0xf9, 0x20, 0x0, 0x3b, 0xff, 0x30,
    0x2, 0xff, 0x50, 0x0, 0x0, 0x0, 0x9f, 0xd0,
    0x9, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf5,
    0xe, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfa,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfc,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfc,
    0xe, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfa,
    0x9, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf5,
    0x2, 0xff, 0x50, 0x0, 0x0, 0x0, 0x9f, 0xd0,
    0x0, 0x5f, 0xf9, 0x20, 0x0, 0x3b, 0xff, 0x30,
    0x0, 0x5, 0xff, 0xfe, 0xdf, 0xff, 0xd3, 0x0,
    0x0, 0x0, 0x17, 0xce, 0xfe, 0xb6, 0x0, 0x0,

    /* U+00D3 "Ó" */
    0x0, 0x0, 0x0, 0x2, 0xa9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x17, 0xce, 0xfe, 0xb6, 0x0, 0x0,
    0x0, 0x5, 0xff, 0xfe, 0xdf, 0xff, 0xd3, 0x0,
    0x0, 0x5f, 0xf9, 0x20, 0x0, 0x3b, 0xff, 0x30,
    0x2, 0xff, 0x50, 0x0, 0x0, 0x0, 0x9f, 0xd0,
    0x9, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf5,
    0xe, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfa,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfc,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfc,
    0xe, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfa,
    0x9, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf5,
    0x2, 0xff, 0x50, 0x0, 0x0, 0x0, 0x9f, 0xd0,
    0x0, 0x5f, 0xf9, 0x20, 0x0, 0x3b, 0xff, 0x30,
    0x0, 0x5, 0xff, 0xfe, 0xdf, 0xff, 0xd3, 0x0,
    0x0, 0x0, 0x17, 0xce, 0xfe, 0xb6, 0x0, 0x0,

    /* U+00D4 "Ô" */
    0x0, 0x0, 0x0, 0x5, 0x84, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xef, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xf9, 0xb, 0xe2, 0x0, 0x0,
    0x0, 0x0, 0x7, 0x60, 0x0, 0x76, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x17, 0xce, 0xfe, 0xb6, 0x0, 0x0,
    0x0, 0x5, 0xff, 0xfe, 0xdf, 0xff, 0xd3, 0x0,
    0x0, 0x5f, 0xf9, 0x20, 0x0, 0x3b, 0xff, 0x30,
    0x2, 0xff, 0x50, 0x0, 0x0, 0x0, 0x9f, 0xd0,
    0x9, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf5,
    0xe, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfa,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfc,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfc,
    0xe, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfa,
    0x9, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf5,
    0x2, 0xff, 0x50, 0x0, 0x0, 0x0, 0x9f, 0xd0,
    0x0, 0x5f, 0xf9, 0x20, 0x0, 0x3b, 0xff, 0x30,
    0x0, 0x5, 0xff, 0xfe, 0xdf, 0xff, 0xd3, 0x0,
    0x0, 0x0, 0x17, 0xce, 0xfe, 0xb6, 0x0, 0x0,

    /* U+00D5 "Õ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xee, 0x81, 0x9a, 0x0, 0x0,
    0x0, 0x0, 0xd, 0x62, 0xbf, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x2, 0x0, 0x1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x17, 0xce, 0xfe, 0xb6, 0x0, 0x0,
    0x0, 0x5, 0xff, 0xfe, 0xdf, 0xff, 0xd3, 0x0,
    0x0, 0x5f, 0xf9, 0x20, 0x0, 0x3b, 0xff, 0x30,
    0x2, 0xff, 0x50, 0x0, 0x0, 0x0, 0x9f, 0xd0,
    0x9, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf5,
    0xe, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfa,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfc,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfc,
    0xe, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfa,
    0x9, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf5,
    0x2, 0xff, 0x50, 0x0, 0x0, 0x0, 0x9f, 0xd0,
    0x0, 0x5f, 0xf9, 0x20, 0x0, 0x3b, 0xff, 0x30,
    0x0, 0x5, 0xff, 0xfe, 0xdf, 0xff, 0xd3, 0x0,
    0x0, 0x0, 0x17, 0xce, 0xfe, 0xb6, 0x0, 0x0,

    /* U+00D6 "Ö" */
    0x0, 0x0, 0x0, 0x10, 0x0, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xf6, 0x9, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xf5, 0x8, 0xe1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x17, 0xce, 0xfe, 0xb6, 0x0, 0x0,
    0x0, 0x5, 0xff, 0xfe, 0xdf, 0xff, 0xd3, 0x0,
    0x0, 0x5f, 0xf9, 0x20, 0x0, 0x3b, 0xff, 0x30,
    0x2, 0xff, 0x50, 0x0, 0x0, 0x0, 0x9f, 0xd0,
    0x9, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf5,
    0xe, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfa,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfc,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfc,
    0xe, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfa,
    0x9, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf5,
    0x2, 0xff, 0x50, 0x0, 0x0, 0x0, 0x9f, 0xd0,
    0x0, 0x5f, 0xf9, 0x20, 0x0, 0x3b, 0xff, 0x30,
    0x0, 0x5, 0xff, 0xfe, 0xdf, 0xff, 0xd3, 0x0,
    0x0, 0x0, 0x17, 0xce, 0xfe, 0xb6, 0x0, 0x0,

    /* U+00D7 "×" */
    0x0, 0x0, 0x0, 0x0, 0x4b, 0x0, 0x2, 0xc1,
    0x7f, 0xa0, 0x2e, 0xf3, 0x8, 0xfa, 0xef, 0x30,
    0x0, 0x9f, 0xf4, 0x0, 0x1, 0xdf, 0xf9, 0x0,
    0x1d, 0xf5, 0xaf, 0x90, 0xaf, 0x50, 0xa, 0xf4,
    0x15, 0x0, 0x0, 0x60,

    /* U+00D8 "Ø" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xb, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x30,
    0x0, 0x0, 0x17, 0xce, 0xfe, 0xb8, 0xf7, 0x0,
    0x0, 0x5, 0xff, 0xfe, 0xdf, 0xff, 0xf3, 0x0,
    0x0, 0x5f, 0xf9, 0x20, 0x0, 0xaf, 0xff, 0x30,
    0x2, 0xff, 0x50, 0x0, 0x2, 0xf6, 0x9f, 0xd0,
    0x9, 0xf9, 0x0, 0x0, 0xc, 0xb0, 0xd, 0xf5,
    0xe, 0xf2, 0x0, 0x0, 0x8e, 0x10, 0x6, 0xfa,
    0xf, 0xf0, 0x0, 0x3, 0xf5, 0x0, 0x3, 0xfc,
    0xf, 0xf0, 0x0, 0xd, 0xa0, 0x0, 0x3, 0xfc,
    0xe, 0xf2, 0x0, 0x9e, 0x10, 0x0, 0x6, 0xfa,
    0x9, 0xf9, 0x4, 0xf4, 0x0, 0x0, 0xd, 0xf5,
    0x2, 0xff, 0x6e, 0x90, 0x0, 0x0, 0x9f, 0xd0,
    0x0, 0x5f, 0xff, 0x30, 0x0, 0x3b, 0xff, 0x30,
    0x0, 0xa, 0xff, 0xfe, 0xdf, 0xff, 0xd3, 0x0,
    0x0, 0x1e, 0x97, 0xce, 0xfe, 0xb6, 0x0, 0x0,
    0x0, 0xbd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x82, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+00D9 "Ù" */
    0x0, 0x3, 0x87, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0x71,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0x0, 0x0, 0x0, 0x2, 0xfd, 0xf,
    0xf0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0xff, 0x0,
    0x0, 0x0, 0x2, 0xfd, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x2f, 0xd0, 0xff, 0x0, 0x0, 0x0, 0x2,
    0xfd, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0xff, 0x0, 0x0, 0x0, 0x2, 0xfd, 0xf, 0xf0,
    0x0, 0x0, 0x0, 0x2f, 0xc0, 0xff, 0x0, 0x0,
    0x0, 0x3, 0xfc, 0xe, 0xf2, 0x0, 0x0, 0x0,
    0x5f, 0xa0, 0xaf, 0x90, 0x0, 0x0, 0xc, 0xf6,
    0x2, 0xff, 0x80, 0x0, 0x1a, 0xfe, 0x0, 0x5,
    0xff, 0xfd, 0xef, 0xfe, 0x30, 0x0, 0x2, 0x9d,
    0xff, 0xd8, 0x10, 0x0,

    /* U+00DA "Ú" */
    0x0, 0x0, 0x0, 0x7a, 0x40, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0x0, 0x0, 0x0, 0x2, 0xfd, 0xf,
    0xf0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0xff, 0x0,
    0x0, 0x0, 0x2, 0xfd, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x2f, 0xd0, 0xff, 0x0, 0x0, 0x0, 0x2,
    0xfd, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0xff, 0x0, 0x0, 0x0, 0x2, 0xfd, 0xf, 0xf0,
    0x0, 0x0, 0x0, 0x2f, 0xc0, 0xff, 0x0, 0x0,
    0x0, 0x3, 0xfc, 0xe, 0xf2, 0x0, 0x0, 0x0,
    0x5f, 0xa0, 0xaf, 0x90, 0x0, 0x0, 0xc, 0xf6,
    0x2, 0xff, 0x80, 0x0, 0x1a, 0xfe, 0x0, 0x5,
    0xff, 0xfd, 0xef, 0xfe, 0x30, 0x0, 0x2, 0x9d,
    0xff, 0xd8, 0x10, 0x0,

    /* U+00DB "Û" */
    0x0, 0x0, 0x1, 0x87, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xde, 0xfb, 0x0, 0x0, 0x0, 0x0, 0xce,
    0x25, 0xf9, 0x0, 0x0, 0x0, 0x38, 0x20, 0x4,
    0x82, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0x0, 0x0, 0x0, 0x2, 0xfd, 0xf,
    0xf0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0xff, 0x0,
    0x0, 0x0, 0x2, 0xfd, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x2f, 0xd0, 0xff, 0x0, 0x0, 0x0, 0x2,
    0xfd, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0xff, 0x0, 0x0, 0x0, 0x2, 0xfd, 0xf, 0xf0,
    0x0, 0x0, 0x0, 0x2f, 0xc0, 0xff, 0x0, 0x0,
    0x0, 0x3, 0xfc, 0xe, 0xf2, 0x0, 0x0, 0x0,
    0x5f, 0xa0, 0xaf, 0x90, 0x0, 0x0, 0xc, 0xf6,
    0x2, 0xff, 0x80, 0x0, 0x1a, 0xfe, 0x0, 0x5,
    0xff, 0xfd, 0xef, 0xfe, 0x30, 0x0, 0x2, 0x9d,
    0xff, 0xd8, 0x10, 0x0,

    /* U+00DC "Ü" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xe0, 0x2f, 0xa0, 0x0, 0x0, 0x0, 0xbc,
    0x1, 0xe8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0x0, 0x0, 0x0, 0x2, 0xfd, 0xf,
    0xf0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0xff, 0x0,
    0x0, 0x0, 0x2, 0xfd, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x2f, 0xd0, 0xff, 0x0, 0x0, 0x0, 0x2,
    0xfd, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0xff, 0x0, 0x0, 0x0, 0x2, 0xfd, 0xf, 0xf0,
    0x0, 0x0, 0x0, 0x2f, 0xc0, 0xff, 0x0, 0x0,
    0x0, 0x3, 0xfc, 0xe, 0xf2, 0x0, 0x0, 0x0,
    0x5f, 0xa0, 0xaf, 0x90, 0x0, 0x0, 0xc, 0xf6,
    0x2, 0xff, 0x80, 0x0, 0x1a, 0xfe, 0x0, 0x5,
    0xff, 0xfd, 0xef, 0xfe, 0x30, 0x0, 0x2, 0x9d,
    0xff, 0xd8, 0x10, 0x0,

    /* U+00DD "Ý" */
    0x0, 0x0, 0x0, 0x3f, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x89, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xf5, 0x0, 0x0,
    0x0, 0x4, 0xfb, 0x3, 0xfe, 0x0, 0x0, 0x0,
    0xd, 0xf1, 0x0, 0x9f, 0x90, 0x0, 0x0, 0x8f,
    0x70, 0x0, 0xe, 0xf2, 0x0, 0x2, 0xfd, 0x0,
    0x0, 0x5, 0xfc, 0x0, 0xb, 0xf4, 0x0, 0x0,
    0x0, 0xbf, 0x60, 0x5f, 0xa0, 0x0, 0x0, 0x0,
    0x2f, 0xe2, 0xef, 0x10, 0x0, 0x0, 0x0, 0x8,
    0xfe, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x70, 0x0, 0x0,

    /* U+00DE "Þ" */
    0xef, 0x10, 0x0, 0x0, 0x0, 0x0, 0xef, 0xdc,
    0xcc, 0xb8, 0x30, 0x0, 0xef, 0xff, 0xff, 0xff,
    0xf9, 0x0, 0xef, 0x10, 0x0, 0x26, 0xef, 0x80,
    0xef, 0x10, 0x0, 0x0, 0x3f, 0xf1, 0xef, 0x10,
    0x0, 0x0, 0xc, 0xf4, 0xef, 0x10, 0x0, 0x0,
    0xa, 0xf6, 0xef, 0x10, 0x0, 0x0, 0xc, 0xf4,
    0xef, 0x10, 0x0, 0x0, 0x3f, 0xf1, 0xef, 0x10,
    0x0, 0x26, 0xef, 0x80, 0xef, 0xff, 0xff, 0xff,
    0xf9, 0x0, 0xef, 0xcc, 0xcc, 0xb8, 0x30, 0x0,
    0xef, 0x10, 0x0, 0x0, 0x0, 0x0, 0xef, 0x10,
    0x0, 0x0, 0x0, 0x0,

    /* U+00DF "ß" */
    0x0, 0x7, 0xdf, 0xfc, 0x50, 0x0, 0x0, 0xdf,
    0xfc, 0xdf, 0xf9, 0x0, 0x9, 0xfb, 0x10, 0x2,
    0xef, 0x30, 0xf, 0xf1, 0x0, 0x0, 0x7f, 0x70,
    0x2f, 0xc0, 0x0, 0x0, 0x8f, 0x50, 0x2f, 0xb0,
    0x0, 0x3, 0xfd, 0x0, 0x3f, 0xb0, 0x6, 0xdf,
    0xf2, 0x0, 0x3f, 0xb0, 0x9, 0xff, 0xfd, 0x30,
    0x3f, 0xb0, 0x0, 0x2, 0x8f, 0xf1, 0x3f, 0xb0,
    0x0, 0x0, 0x9, 0xf8, 0x3f, 0xb0, 0x0, 0x0,
    0x5, 0xfa, 0x3f, 0xb0, 0x0, 0x0, 0x6, 0xf9,
    0x3f, 0xb0, 0x0, 0x0, 0x2e, 0xf4, 0x3f, 0xb0,
    0x3d, 0xcd, 0xff, 0x90, 0x3f, 0xb0, 0x4d, 0xff,
    0xc5, 0x0,

    /* U+00E0 "à" */
    0x0, 0x4e, 0xe3, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xce, 0x30, 0x0, 0x0, 0x0, 0x0, 0x7, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xae, 0xfd, 0x70, 0xff, 0x0, 0x6f,
    0xfe, 0xce, 0xfc, 0xff, 0x3, 0xff, 0x50, 0x0,
    0x5f, 0xff, 0xa, 0xf6, 0x0, 0x0, 0x7, 0xff,
    0xe, 0xf0, 0x0, 0x0, 0x1, 0xff, 0xf, 0xf0,
    0x0, 0x0, 0x0, 0xff, 0xe, 0xf0, 0x0, 0x0,
    0x1, 0xff, 0xa, 0xf7, 0x0, 0x0, 0x7, 0xff,
    0x3, 0xff, 0x50, 0x0, 0x5f, 0xff, 0x0, 0x6f,
    0xfe, 0xce, 0xfc, 0xef, 0x0, 0x3, 0xae, 0xfd,
    0x70, 0xef,

    /* U+00E1 "á" */
    0x0, 0x0, 0xd, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x4a, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xae, 0xfd, 0x70, 0xff, 0x0, 0x6f,
    0xfe, 0xce, 0xfc, 0xff, 0x3, 0xff, 0x50, 0x0,
    0x5f, 0xff, 0xa, 0xf6, 0x0, 0x0, 0x7, 0xff,
    0xe, 0xf0, 0x0, 0x0, 0x1, 0xff, 0xf, 0xf0,
    0x0, 0x0, 0x0, 0xff, 0xe, 0xf0, 0x0, 0x0,
    0x1, 0xff, 0xa, 0xf7, 0x0, 0x0, 0x7, 0xff,
    0x3, 0xff, 0x50, 0x0, 0x5f, 0xff, 0x0, 0x6f,
    0xfe, 0xce, 0xfc, 0xef, 0x0, 0x3, 0xae, 0xfd,
    0x70, 0xef,

    /* U+00E2 "â" */
    0x0, 0x0, 0xaf, 0xf4, 0x0, 0x0, 0x0, 0xa,
    0xf5, 0xaf, 0x40, 0x0, 0x0, 0x49, 0x20, 0x6,
    0x81, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xae, 0xfd, 0x70, 0xff, 0x0, 0x6f,
    0xfe, 0xce, 0xfc, 0xff, 0x3, 0xff, 0x50, 0x0,
    0x5f, 0xff, 0xa, 0xf6, 0x0, 0x0, 0x7, 0xff,
    0xe, 0xf0, 0x0, 0x0, 0x1, 0xff, 0xf, 0xf0,
    0x0, 0x0, 0x0, 0xff, 0xe, 0xf0, 0x0, 0x0,
    0x1, 0xff, 0xa, 0xf7, 0x0, 0x0, 0x7, 0xff,
    0x3, 0xff, 0x50, 0x0, 0x5f, 0xff, 0x0, 0x6f,
    0xfe, 0xce, 0xfc, 0xef, 0x0, 0x3, 0xae, 0xfd,
    0x70, 0xef,

    /* U+00E3 "ã" */
    0x0, 0xb, 0xfb, 0x33, 0xf1, 0x0, 0x0, 0x6d,
    0x49, 0xff, 0x90, 0x0, 0x0, 0x11, 0x0, 0x12,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xae, 0xfd, 0x70, 0xff, 0x0, 0x6f,
    0xfe, 0xce, 0xfc, 0xff, 0x3, 0xff, 0x50, 0x0,
    0x5f, 0xff, 0xa, 0xf6, 0x0, 0x0, 0x7, 0xff,
    0xe, 0xf0, 0x0, 0x0, 0x1, 0xff, 0xf, 0xf0,
    0x0, 0x0, 0x0, 0xff, 0xe, 0xf0, 0x0, 0x0,
    0x1, 0xff, 0xa, 0xf7, 0x0, 0x0, 0x7, 0xff,
    0x3, 0xff, 0x50, 0x0, 0x5f, 0xff, 0x0, 0x6f,
    0xfe, 0xce, 0xfc, 0xef, 0x0, 0x3, 0xae, 0xfd,
    0x70, 0xef,

    /* U+00E4 "ä" */
    0x0, 0xd, 0xb0, 0x2e, 0x70, 0x0, 0x0, 0xe,
    0xc0, 0x3f, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xae, 0xfd, 0x70, 0xff, 0x0, 0x6f,
    0xfe, 0xce, 0xfc, 0xff, 0x3, 0xff, 0x50, 0x0,
    0x5f, 0xff, 0xa, 0xf6, 0x0, 0x0, 0x7, 0xff,
    0xe, 0xf0, 0x0, 0x0, 0x1, 0xff, 0xf, 0xf0,
    0x0, 0x0, 0x0, 0xff, 0xe, 0xf0, 0x0, 0x0,
    0x1, 0xff, 0xa, 0xf7, 0x0, 0x0, 0x7, 0xff,
    0x3, 0xff, 0x50, 0x0, 0x5f, 0xff, 0x0, 0x6f,
    0xfe, 0xce, 0xfc, 0xef, 0x0, 0x3, 0xae, 0xfd,
    0x70, 0xef,

    /* U+00E5 "å" */
    0x0, 0x0, 0x6d, 0xc1, 0x0, 0x0, 0x0, 0x3,
    0xc0, 0x4c, 0x0, 0x0, 0x0, 0x6, 0x80, 0xe,
    0x0, 0x0, 0x0, 0x3, 0xc0, 0x3c, 0x0, 0x0,
    0x0, 0x0, 0x6d, 0xc1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xae, 0xfd,
    0x70, 0xff, 0x0, 0x6f, 0xfe, 0xce, 0xfc, 0xff,
    0x3, 0xff, 0x50, 0x0, 0x5f, 0xff, 0xa, 0xf6,
    0x0, 0x0, 0x7, 0xff, 0xe, 0xf0, 0x0, 0x0,
    0x1, 0xff, 0xf, 0xf0, 0x0, 0x0, 0x0, 0xff,
    0xe, 0xf0, 0x0, 0x0, 0x1, 0xff, 0xa, 0xf7,
    0x0, 0x0, 0x7, 0xff, 0x3, 0xff, 0x50, 0x0,
    0x5f, 0xff, 0x0, 0x6f, 0xfe, 0xce, 0xfc, 0xef,
    0x0, 0x3, 0xae, 0xfd, 0x70, 0xef,

    /* U+00E6 "æ" */
    0x5, 0xbe, 0xfe, 0xb4, 0x1, 0x8d, 0xfe, 0xa2,
    0x0, 0x7f, 0xfd, 0xbd, 0xff, 0x6d, 0xfe, 0xbd,
    0xff, 0x50, 0x2a, 0x10, 0x0, 0x7f, 0xff, 0x80,
    0x0, 0x4f, 0xf2, 0x0, 0x0, 0x0, 0xd, 0xfb,
    0x0, 0x0, 0x6, 0xf9, 0x0, 0x1, 0x12, 0x2c,
    0xf7, 0x22, 0x22, 0x22, 0xfd, 0x8, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x9f, 0xb6,
    0x55, 0x5c, 0xf8, 0x55, 0x55, 0x55, 0x54, 0xff,
    0x0, 0x0, 0xd, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0xef, 0x40, 0x0, 0x7f, 0xff, 0x90, 0x0, 0x7,
    0x80, 0x7f, 0xfd, 0xce, 0xfc, 0x2d, 0xff, 0xcc,
    0xff, 0xd0, 0x5, 0xce, 0xfd, 0x70, 0x1, 0x8d,
    0xff, 0xd7, 0x0,

    /* U+00E7 "ç" */
    0x0, 0x3, 0xae, 0xfe, 0x91, 0x0, 0x7, 0xff,
    0xdc, 0xef, 0xe2, 0x5, 0xfe, 0x40, 0x0, 0x7f,
    0x50, 0xdf, 0x40, 0x0, 0x0, 0x10, 0x1f, 0xe0,
    0x0, 0x0, 0x0, 0x2, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0x40, 0x0, 0x0, 0x10, 0x5, 0xfe, 0x40, 0x0,
    0x7f, 0x50, 0x7, 0xff, 0xdc, 0xef, 0xe2, 0x0,
    0x3, 0xaf, 0xfe, 0x91, 0x0, 0x0, 0x0, 0xc6,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xe9, 0x0, 0x0,
    0x0, 0x1, 0x8, 0xe0, 0x0, 0x0, 0x1, 0xff,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0x0,

    /* U+00E8 "è" */
    0x0, 0x1c, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0x70, 0x0, 0x0, 0x0, 0x0, 0x5, 0x92,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xbe, 0xfc, 0x60, 0x0, 0x0, 0x9f,
    0xfc, 0xbe, 0xfb, 0x0, 0x5, 0xfd, 0x20, 0x0,
    0xaf, 0x80, 0xd, 0xf3, 0x0, 0x0, 0xd, 0xe0,
    0x1f, 0xe1, 0x11, 0x11, 0x19, 0xf3, 0x2f, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0x1f, 0xe4, 0x44, 0x44,
    0x44, 0x41, 0xd, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xfe, 0x40, 0x0, 0x2b, 0x20, 0x0, 0x8f,
    0xfe, 0xcd, 0xff, 0x50, 0x0, 0x3, 0xae, 0xfe,
    0xa3, 0x0,

    /* U+00E9 "é" */
    0x0, 0x0, 0x8, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x1a, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xbe, 0xfc, 0x60, 0x0, 0x0, 0x9f,
    0xfc, 0xbe, 0xfb, 0x0, 0x5, 0xfd, 0x20, 0x0,
    0xaf, 0x80, 0xd, 0xf3, 0x0, 0x0, 0xd, 0xe0,
    0x1f, 0xe1, 0x11, 0x11, 0x19, 0xf3, 0x2f, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0x1f, 0xe4, 0x44, 0x44,
    0x44, 0x41, 0xd, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xfe, 0x40, 0x0, 0x2b, 0x20, 0x0, 0x8f,
    0xfe, 0xcd, 0xff, 0x50, 0x0, 0x3, 0xae, 0xfe,
    0xa3, 0x0,

    /* U+00EA "ê" */
    0x0, 0x0, 0x5f, 0xf8, 0x0, 0x0, 0x0, 0x5,
    0xf9, 0x5f, 0x90, 0x0, 0x0, 0x19, 0x50, 0x3,
    0x93, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xbe, 0xfc, 0x60, 0x0, 0x0, 0x9f,
    0xfc, 0xbe, 0xfb, 0x0, 0x5, 0xfd, 0x20, 0x0,
    0xaf, 0x80, 0xd, 0xf3, 0x0, 0x0, 0xd, 0xe0,
    0x1f, 0xe1, 0x11, 0x11, 0x19, 0xf3, 0x2f, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0x1f, 0xe4, 0x44, 0x44,
    0x44, 0x41, 0xd, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xfe, 0x40, 0x0, 0x2b, 0x20, 0x0, 0x8f,
    0xfe, 0xcd, 0xff, 0x50, 0x0, 0x3, 0xae, 0xfe,
    0xa3, 0x0,

    /* U+00EB "ë" */
    0x0, 0x8, 0xe1, 0xc, 0xc0, 0x0, 0x0, 0x9,
    0xf2, 0xe, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xbe, 0xfc, 0x60, 0x0, 0x0, 0x9f,
    0xfc, 0xbe, 0xfb, 0x0, 0x5, 0xfd, 0x20, 0x0,
    0xaf, 0x80, 0xd, 0xf3, 0x0, 0x0, 0xd, 0xe0,
    0x1f, 0xe1, 0x11, 0x11, 0x19, 0xf3, 0x2f, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0x1f, 0xe4, 0x44, 0x44,
    0x44, 0x41, 0xd, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xfe, 0x40, 0x0, 0x2b, 0x20, 0x0, 0x8f,
    0xfe, 0xcd, 0xff, 0x50, 0x0, 0x3, 0xae, 0xfe,
    0xa3, 0x0,

    /* U+00EC "ì" */
    0x4e, 0xe2, 0x0, 0x1, 0xcf, 0x30, 0x0, 0x6,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xb0, 0x0,
    0x3f, 0xb0, 0x0, 0x3f, 0xb0, 0x0, 0x3f, 0xb0,
    0x0, 0x3f, 0xb0, 0x0, 0x3f, 0xb0, 0x0, 0x3f,
    0xb0, 0x0, 0x3f, 0xb0, 0x0, 0x3f, 0xb0, 0x0,
    0x3f, 0xb0, 0x0, 0x3f, 0xb0,

    /* U+00ED "í" */
    0xe, 0xf2, 0x3f, 0x90, 0x5a, 0x10, 0x0, 0x0,
    0x3f, 0xb0, 0x3f, 0xb0, 0x3f, 0xb0, 0x3f, 0xb0,
    0x3f, 0xb0, 0x3f, 0xb0, 0x3f, 0xb0, 0x3f, 0xb0,
    0x3f, 0xb0, 0x3f, 0xb0, 0x3f, 0xb0,

    /* U+00EE "î" */
    0x0, 0x9f, 0xe2, 0x0, 0x7f, 0x6c, 0xd1, 0x7,
    0x40, 0x7, 0x40, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xb0, 0x0, 0x3, 0xfb, 0x0, 0x0, 0x3f, 0xb0,
    0x0, 0x3, 0xfb, 0x0, 0x0, 0x3f, 0xb0, 0x0,
    0x3, 0xfb, 0x0, 0x0, 0x3f, 0xb0, 0x0, 0x3,
    0xfb, 0x0, 0x0, 0x3f, 0xb0, 0x0, 0x3, 0xfb,
    0x0, 0x0, 0x3f, 0xb0, 0x0,

    /* U+00EF "ï" */
    0x6e, 0x29, 0xe1, 0x7f, 0x29, 0xe1, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xfb, 0x0, 0x3,
    0xfb, 0x0, 0x3, 0xfb, 0x0, 0x3, 0xfb, 0x0,
    0x3, 0xfb, 0x0, 0x3, 0xfb, 0x0, 0x3, 0xfb,
    0x0, 0x3, 0xfb, 0x0, 0x3, 0xfb, 0x0, 0x3,
    0xfb, 0x0, 0x3, 0xfb, 0x0,

    /* U+00F0 "ð" */
    0x1, 0xbe, 0xff, 0xd9, 0x32, 0x70, 0x0, 0xfd,
    0xbb, 0xdf, 0xff, 0xf2, 0x0, 0x0, 0x7, 0xdf,
    0xff, 0x70, 0x0, 0x19, 0xff, 0xb4, 0x2f, 0xf1,
    0x0, 0x2e, 0x82, 0x0, 0x8, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xfb, 0x0, 0x7, 0xdf, 0xfb,
    0x41, 0xfd, 0x1, 0xdf, 0xfc, 0xbe, 0xf7, 0xfe,
    0xa, 0xfa, 0x10, 0x0, 0x8f, 0xfe, 0xf, 0xf0,
    0x0, 0x0, 0xc, 0xfc, 0x2f, 0xd0, 0x0, 0x0,
    0x9, 0xf9, 0xf, 0xf0, 0x0, 0x0, 0xc, 0xf4,
    0xa, 0xfa, 0x0, 0x0, 0x8f, 0xb0, 0x1, 0xdf,
    0xeb, 0xbe, 0xfc, 0x10, 0x0, 0x8, 0xdf, 0xec,
    0x60, 0x0,

    /* U+00F1 "ñ" */
    0x0, 0xb, 0xfb, 0x33, 0xf1, 0x0, 0x6, 0xd4,
    0x9f, 0xfa, 0x0, 0x0, 0x11, 0x0, 0x12, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xa2,
    0x9e, 0xfe, 0x80, 0x3, 0xfc, 0xff, 0xdd, 0xff,
    0xd0, 0x3f, 0xfc, 0x10, 0x2, 0xdf, 0x73, 0xff,
    0x20, 0x0, 0x5, 0xfb, 0x3f, 0xc0, 0x0, 0x0,
    0x1f, 0xd3, 0xfb, 0x0, 0x0, 0x0, 0xfe, 0x3f,
    0xb0, 0x0, 0x0, 0xf, 0xe3, 0xfb, 0x0, 0x0,
    0x0, 0xfe, 0x3f, 0xb0, 0x0, 0x0, 0xf, 0xe3,
    0xfb, 0x0, 0x0, 0x0, 0xfe, 0x3f, 0xb0, 0x0,
    0x0, 0xf, 0xe0,

    /* U+00F2 "ò" */
    0x0, 0xa, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x3, 0x94,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xbe, 0xfd, 0x81, 0x0, 0x0, 0x8f,
    0xfd, 0xce, 0xfe, 0x30, 0x5, 0xfe, 0x40, 0x0,
    0x7f, 0xe1, 0xd, 0xf4, 0x0, 0x0, 0x9, 0xf7,
    0x1f, 0xe0, 0x0, 0x0, 0x3, 0xfb, 0x2f, 0xc0,
    0x0, 0x0, 0x1, 0xfd, 0x1f, 0xe0, 0x0, 0x0,
    0x3, 0xfb, 0xc, 0xf4, 0x0, 0x0, 0x9, 0xf7,
    0x5, 0xfe, 0x40, 0x0, 0x7f, 0xe1, 0x0, 0x7f,
    0xfd, 0xce, 0xfe, 0x30, 0x0, 0x4, 0xbe, 0xfd,
    0x91, 0x0,

    /* U+00F3 "ó" */
    0x0, 0x0, 0x5, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x9, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xbe, 0xfd, 0x81, 0x0, 0x0, 0x8f,
    0xfd, 0xce, 0xfe, 0x30, 0x5, 0xfe, 0x40, 0x0,
    0x7f, 0xe1, 0xd, 0xf4, 0x0, 0x0, 0x9, 0xf7,
    0x1f, 0xe0, 0x0, 0x0, 0x3, 0xfb, 0x2f, 0xc0,
    0x0, 0x0, 0x1, 0xfd, 0x1f, 0xe0, 0x0, 0x0,
    0x3, 0xfb, 0xc, 0xf4, 0x0, 0x0, 0x9, 0xf7,
    0x5, 0xfe, 0x40, 0x0, 0x7f, 0xe1, 0x0, 0x7f,
    0xfd, 0xce, 0xfe, 0x30, 0x0, 0x4, 0xbe, 0xfd,
    0x91, 0x0,

    /* U+00F4 "ô" */
    0x0, 0x0, 0x3e, 0xfb, 0x0, 0x0, 0x0, 0x3,
    0xeb, 0x4e, 0xb0, 0x0, 0x0, 0x8, 0x70, 0x1,
    0x95, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xbe, 0xfd, 0x81, 0x0, 0x0, 0x8f,
    0xfd, 0xce, 0xfe, 0x30, 0x5, 0xfe, 0x40, 0x0,
    0x7f, 0xe1, 0xd, 0xf4, 0x0, 0x0, 0x9, 0xf7,
    0x1f, 0xe0, 0x0, 0x0, 0x3, 0xfb, 0x2f, 0xc0,
    0x0, 0x0, 0x1, 0xfd, 0x1f, 0xe0, 0x0, 0x0,
    0x3, 0xfb, 0xc, 0xf4, 0x0, 0x0, 0x9, 0xf7,
    0x5, 0xfe, 0x40, 0x0, 0x7f, 0xe1, 0x0, 0x7f,
    0xfd, 0xce, 0xfe, 0x30, 0x0, 0x4, 0xbe, 0xfd,
    0x91, 0x0,

    /* U+00F5 "õ" */
    0x0, 0x5, 0xee, 0x71, 0xa9, 0x0, 0x0, 0xe,
    0x86, 0xdf, 0xe2, 0x0, 0x0, 0x3, 0x0, 0x2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xbe, 0xfd, 0x81, 0x0, 0x0, 0x8f,
    0xfd, 0xce, 0xfe, 0x30, 0x5, 0xfe, 0x40, 0x0,
    0x7f, 0xe1, 0xd, 0xf4, 0x0, 0x0, 0x9, 0xf7,
    0x1f, 0xe0, 0x0, 0x0, 0x3, 0xfb, 0x2f, 0xc0,
    0x0, 0x0, 0x1, 0xfd, 0x1f, 0xe0, 0x0, 0x0,
    0x3, 0xfb, 0xc, 0xf4, 0x0, 0x0, 0x9, 0xf7,
    0x5, 0xfe, 0x40, 0x0, 0x7f, 0xe1, 0x0, 0x7f,
    0xfd, 0xce, 0xfe, 0x30, 0x0, 0x4, 0xbe, 0xfd,
    0x91, 0x0,

    /* U+00F6 "ö" */
    0x0, 0x5, 0xf4, 0x9, 0xe1, 0x0, 0x0, 0x6,
    0xf5, 0xa, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xbe, 0xfd, 0x81, 0x0, 0x0, 0x8f,
    0xfd, 0xce, 0xfe, 0x30, 0x5, 0xfe, 0x40, 0x0,
    0x7f, 0xe1, 0xd, 0xf4, 0x0, 0x0, 0x9, 0xf7,
    0x1f, 0xe0, 0x0, 0x0, 0x3, 0xfb, 0x2f, 0xc0,
    0x0, 0x0, 0x1, 0xfd, 0x1f, 0xe0, 0x0, 0x0,
    0x3, 0xfb, 0xc, 0xf4, 0x0, 0x0, 0x9, 0xf7,
    0x5, 0xfe, 0x40, 0x0, 0x7f, 0xe1, 0x0, 0x7f,
    0xfd, 0xce, 0xfe, 0x30, 0x0, 0x4, 0xbe, 0xfd,
    0x91, 0x0,

    /* U+00F7 "÷" */
    0x0, 0x0, 0x53, 0x0, 0x0, 0x0, 0x3, 0xfe,
    0x0, 0x0, 0x0, 0x1, 0xea, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0xff, 0xff, 0xff, 0xf4, 0x6a, 0xaa,
    0xaa, 0xaa, 0xa2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x53, 0x0, 0x0, 0x0, 0x3, 0xfe,
    0x0, 0x0, 0x0, 0x1, 0xea, 0x0, 0x0,

    /* U+00F8 "ø" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x71, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xa0, 0x0, 0x4, 0xbe, 0xfd,
    0xbf, 0x10, 0x0, 0x8f, 0xfd, 0xce, 0xff, 0x30,
    0x5, 0xfe, 0x40, 0x6, 0xff, 0xe1, 0xd, 0xf4,
    0x0, 0x1e, 0x29, 0xf7, 0x1f, 0xe0, 0x0, 0xa8,
    0x3, 0xfb, 0x2f, 0xc0, 0x4, 0xd0, 0x1, 0xfd,
    0x1f, 0xe0, 0xd, 0x40, 0x3, 0xfb, 0xc, 0xf4,
    0x8a, 0x0, 0x9, 0xf7, 0x5, 0xff, 0xf1, 0x0,
    0x7f, 0xe1, 0x0, 0x8f, 0xfd, 0xce, 0xfe, 0x30,
    0x0, 0x7f, 0xbe, 0xfd, 0x91, 0x0, 0x1, 0xe2,
    0x0, 0x0, 0x0, 0x0, 0x4, 0x50, 0x0, 0x0,
    0x0, 0x0,

    /* U+00F9 "ù" */
    0x0, 0x5f, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x2c,
    0xe3, 0x0, 0x0, 0x0, 0x0, 0x7, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xa0,
    0x0, 0x0, 0x3f, 0xb4, 0xfa, 0x0, 0x0, 0x3,
    0xfb, 0x4f, 0xa0, 0x0, 0x0, 0x3f, 0xb4, 0xfa,
    0x0, 0x0, 0x3, 0xfb, 0x4f, 0xa0, 0x0, 0x0,
    0x3f, 0xb4, 0xfa, 0x0, 0x0, 0x3, 0xfb, 0x4f,
    0xa0, 0x0, 0x0, 0x5f, 0xb2, 0xfd, 0x0, 0x0,
    0xa, 0xfb, 0xe, 0xf8, 0x0, 0x6, 0xff, 0xb0,
    0x4f, 0xfe, 0xce, 0xfb, 0xfb, 0x0, 0x3b, 0xef,
    0xd6, 0x2f, 0xb0,

    /* U+00FA "ú" */
    0x0, 0x0, 0xe, 0xf1, 0x0, 0x0, 0x0, 0x4,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x5a, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xa0,
    0x0, 0x0, 0x3f, 0xb4, 0xfa, 0x0, 0x0, 0x3,
    0xfb, 0x4f, 0xa0, 0x0, 0x0, 0x3f, 0xb4, 0xfa,
    0x0, 0x0, 0x3, 0xfb, 0x4f, 0xa0, 0x0, 0x0,
    0x3f, 0xb4, 0xfa, 0x0, 0x0, 0x3, 0xfb, 0x4f,
    0xa0, 0x0, 0x0, 0x5f, 0xb2, 0xfd, 0x0, 0x0,
    0xa, 0xfb, 0xe, 0xf8, 0x0, 0x6, 0xff, 0xb0,
    0x4f, 0xfe, 0xce, 0xfb, 0xfb, 0x0, 0x3b, 0xef,
    0xd6, 0x2f, 0xb0,

    /* U+00FB "û" */
    0x0, 0x0, 0xbf, 0xe3, 0x0, 0x0, 0x0, 0xce,
    0x4a, 0xf4, 0x0, 0x0, 0x47, 0x10, 0x6, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xa0,
    0x0, 0x0, 0x3f, 0xb4, 0xfa, 0x0, 0x0, 0x3,
    0xfb, 0x4f, 0xa0, 0x0, 0x0, 0x3f, 0xb4, 0xfa,
    0x0, 0x0, 0x3, 0xfb, 0x4f, 0xa0, 0x0, 0x0,
    0x3f, 0xb4, 0xfa, 0x0, 0x0, 0x3, 0xfb, 0x4f,
    0xa0, 0x0, 0x0, 0x5f, 0xb2, 0xfd, 0x0, 0x0,
    0xa, 0xfb, 0xe, 0xf8, 0x0, 0x6, 0xff, 0xb0,
    0x4f, 0xfe, 0xce, 0xfb, 0xfb, 0x0, 0x3b, 0xef,
    0xd6, 0x2f, 0xb0,

    /* U+00FC "ü" */
    0x0, 0x1e, 0x90, 0x3f, 0x50, 0x0, 0x1, 0xfb,
    0x4, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xa0,
    0x0, 0x0, 0x3f, 0xb4, 0xfa, 0x0, 0x0, 0x3,
    0xfb, 0x4f, 0xa0, 0x0, 0x0, 0x3f, 0xb4, 0xfa,
    0x0, 0x0, 0x3, 0xfb, 0x4f, 0xa0, 0x0, 0x0,
    0x3f, 0xb4, 0xfa, 0x0, 0x0, 0x3, 0xfb, 0x4f,
    0xa0, 0x0, 0x0, 0x5f, 0xb2, 0xfd, 0x0, 0x0,
    0xa, 0xfb, 0xe, 0xf8, 0x0, 0x6, 0xff, 0xb0,
    0x4f, 0xfe, 0xce, 0xfb, 0xfb, 0x0, 0x3b, 0xef,
    0xd6, 0x2f, 0xb0,

    /* U+00FD "ý" */
    0x0, 0x0, 0x5, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0x20, 0x0, 0x0, 0x0, 0x0, 0xa,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xf2, 0x0, 0x0, 0x0, 0xee,
    0x0, 0x6f, 0x90, 0x0, 0x0, 0x5f, 0x80, 0x0,
    0xff, 0x0, 0x0, 0xc, 0xf2, 0x0, 0x8, 0xf6,
    0x0, 0x2, 0xfa, 0x0, 0x0, 0x2f, 0xd0, 0x0,
    0x9f, 0x40, 0x0, 0x0, 0xbf, 0x40, 0x1f, 0xd0,
    0x0, 0x0, 0x4, 0xfb, 0x7, 0xf6, 0x0, 0x0,
    0x0, 0xd, 0xf2, 0xde, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xcf, 0x80, 0x0, 0x0, 0x0, 0x0, 0xef,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x8, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0x40, 0x0, 0x0,
    0x3, 0x0, 0x3f, 0xc0, 0x0, 0x0, 0x3, 0xfd,
    0xbf, 0xf3, 0x0, 0x0, 0x0, 0x8, 0xef, 0xc4,
    0x0, 0x0, 0x0, 0x0,

    /* U+00FE "þ" */
    0x3f, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xb1, 0x9e, 0xfd, 0x92, 0x0, 0x3f, 0xdd,
    0xfd, 0xce, 0xfe, 0x30, 0x3f, 0xfe, 0x30, 0x0,
    0x8f, 0xe1, 0x3f, 0xf3, 0x0, 0x0, 0xa, 0xf7,
    0x3f, 0xd0, 0x0, 0x0, 0x4, 0xfa, 0x3f, 0xb0,
    0x0, 0x0, 0x2, 0xfc, 0x3f, 0xd0, 0x0, 0x0,
    0x4, 0xfa, 0x3f, 0xf3, 0x0, 0x0, 0xa, 0xf6,
    0x3f, 0xfe, 0x30, 0x0, 0x8f, 0xe1, 0x3f, 0xde,
    0xfd, 0xcf, 0xff, 0x30, 0x3f, 0xb1, 0x8e, 0xfe,
    0x92, 0x0, 0x3f, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xb0, 0x0, 0x0,
    0x0, 0x0,

    /* U+00FF "ÿ" */
    0x0, 0x5, 0xf3, 0x9, 0xd0, 0x0, 0x0, 0x0,
    0x6f, 0x40, 0xbf, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xf2, 0x0, 0x0, 0x0, 0xee,
    0x0, 0x6f, 0x90, 0x0, 0x0, 0x5f, 0x80, 0x0,
    0xff, 0x0, 0x0, 0xc, 0xf2, 0x0, 0x8, 0xf6,
    0x0, 0x2, 0xfa, 0x0, 0x0, 0x2f, 0xd0, 0x0,
    0x9f, 0x40, 0x0, 0x0, 0xbf, 0x40, 0x1f, 0xd0,
    0x0, 0x0, 0x4, 0xfb, 0x7, 0xf6, 0x0, 0x0,
    0x0, 0xd, 0xf2, 0xde, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xcf, 0x80, 0x0, 0x0, 0x0, 0x0, 0xef,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x8, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0x40, 0x0, 0x0,
    0x3, 0x0, 0x3f, 0xc0, 0x0, 0x0, 0x3, 0xfd,
    0xbf, 0xf3, 0x0, 0x0, 0x0, 0x8, 0xef, 0xc4,
    0x0, 0x0, 0x0, 0x0,

    /* U+0100 "Ā" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xff, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x3, 0x33, 0x33, 0x31, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xaf, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xfa, 0x1f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xf3, 0xa, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xc0, 0x3, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x50, 0x0, 0xcf, 0x30, 0x0,
    0x0, 0x1, 0xfe, 0x0, 0x0, 0x5f, 0xa0, 0x0,
    0x0, 0x8, 0xf7, 0x0, 0x0, 0xe, 0xf2, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x0,
    0x0, 0x7f, 0xda, 0xaa, 0xaa, 0xaa, 0xff, 0x10,
    0x0, 0xef, 0x20, 0x0, 0x0, 0x0, 0x9f, 0x80,
    0x5, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xe0,
    0xd, 0xf3, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf6,

    /* U+0101 "ā" */
    0x0, 0x7f, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x13,
    0x33, 0x33, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xae, 0xfd, 0x70, 0xff,
    0x0, 0x6f, 0xfe, 0xce, 0xfc, 0xff, 0x3, 0xff,
    0x50, 0x0, 0x5f, 0xff, 0xa, 0xf6, 0x0, 0x0,
    0x7, 0xff, 0xe, 0xf0, 0x0, 0x0, 0x1, 0xff,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0xff, 0xe, 0xf0,
    0x0, 0x0, 0x1, 0xff, 0xa, 0xf7, 0x0, 0x0,
    0x7, 0xff, 0x3, 0xff, 0x50, 0x0, 0x5f, 0xff,
    0x0, 0x6f, 0xfe, 0xce, 0xfc, 0xef, 0x0, 0x3,
    0xae, 0xfd, 0x70, 0xef,

    /* U+0102 "Ă" */
    0x0, 0x0, 0xc, 0xa1, 0x3, 0xe6, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xcf, 0xff, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xaf, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xfa, 0x1f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xf3, 0xa, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xc0, 0x3, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x50, 0x0, 0xcf, 0x30, 0x0,
    0x0, 0x1, 0xfe, 0x0, 0x0, 0x5f, 0xa0, 0x0,
    0x0, 0x8, 0xf7, 0x0, 0x0, 0xe, 0xf2, 0x0,
    0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x0,
    0x0, 0x7f, 0xda, 0xaa, 0xaa, 0xaa, 0xff, 0x10,
    0x0, 0xef, 0x20, 0x0, 0x0, 0x0, 0x9f, 0x80,
    0x5, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xe0,
    0xd, 0xf3, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf6,

    /* U+0103 "ă" */
    0x0, 0x4f, 0x40, 0x9, 0xe0, 0x0, 0x0, 0x7,
    0xff, 0xfd, 0x30, 0x0, 0x0, 0x0, 0x1, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xae, 0xfd, 0x70, 0xff, 0x0, 0x6f,
    0xfe, 0xce, 0xfc, 0xff, 0x3, 0xff, 0x50, 0x0,
    0x5f, 0xff, 0xa, 0xf6, 0x0, 0x0, 0x7, 0xff,
    0xe, 0xf0, 0x0, 0x0, 0x1, 0xff, 0xf, 0xf0,
    0x0, 0x0, 0x0, 0xff, 0xe, 0xf0, 0x0, 0x0,
    0x1, 0xff, 0xa, 0xf7, 0x0, 0x0, 0x7, 0xff,
    0x3, 0xff, 0x50, 0x0, 0x5f, 0xff, 0x0, 0x6f,
    0xfe, 0xce, 0xfc, 0xef, 0x0, 0x3, 0xae, 0xfd,
    0x70, 0xef,

    /* U+0104 "Ą" */
    0x0, 0x0, 0x0, 0xe, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xff, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0xaf, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xa1, 0xfd, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xf3, 0xa, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xfc, 0x0, 0x3f,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x50, 0x0,
    0xcf, 0x30, 0x0, 0x0, 0x0, 0x1f, 0xe0, 0x0,
    0x5, 0xfa, 0x0, 0x0, 0x0, 0x8, 0xf7, 0x0,
    0x0, 0xe, 0xf2, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x90, 0x0, 0x0, 0x7f, 0xda,
    0xaa, 0xaa, 0xaa, 0xff, 0x10, 0x0, 0xe, 0xf2,
    0x0, 0x0, 0x0, 0x9, 0xf8, 0x0, 0x5, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xe0, 0x0, 0xdf,
    0x30, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3e, 0x81, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf7, 0x2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x20, 0x0,

    /* U+0105 "ą" */
    0x0, 0x3, 0xae, 0xfd, 0x70, 0xff, 0x0, 0x6f,
    0xfe, 0xce, 0xfc, 0xff, 0x3, 0xff, 0x50, 0x0,
    0x5f, 0xff, 0xa, 0xf6, 0x0, 0x0, 0x7, 0xff,
    0xe, 0xf0, 0x0, 0x0, 0x1, 0xff, 0xf, 0xf0,
    0x0, 0x0, 0x0, 0xff, 0xe, 0xf0, 0x0, 0x0,
    0x1, 0xff, 0xa, 0xf7, 0x0, 0x0, 0x7, 0xff,
    0x3, 0xff, 0x50, 0x0, 0x5f, 0xff, 0x0, 0x6f,
    0xfe, 0xce, 0xfc, 0xef, 0x0, 0x3, 0xae, 0xfd,
    0xd9, 0xef, 0x0, 0x0, 0x0, 0xb, 0xc3, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7e, 0x20, 0x10, 0x0, 0x0, 0x0, 0x1d,
    0xff, 0x70, 0x0, 0x0, 0x0, 0x0, 0x11, 0x0,

    /* U+0106 "Ć" */
    0x0, 0x0, 0x0, 0x4, 0xa7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x17, 0xce, 0xfe,
    0xa5, 0x0, 0x0, 0x5, 0xff, 0xfe, 0xdf, 0xff,
    0xc1, 0x0, 0x6f, 0xf9, 0x20, 0x0, 0x3b, 0xf5,
    0x2, 0xff, 0x50, 0x0, 0x0, 0x0, 0x30, 0x9,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xff, 0x50, 0x0, 0x0, 0x0, 0x30,
    0x0, 0x6f, 0xf9, 0x20, 0x0, 0x3b, 0xf5, 0x0,
    0x5, 0xff, 0xfe, 0xdf, 0xff, 0xc1, 0x0, 0x0,
    0x17, 0xce, 0xfe, 0xb5, 0x0,

    /* U+0107 "ć" */
    0x0, 0x0, 0x9, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0xed, 0x0, 0x0, 0x0, 0x0, 0x2a, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xae, 0xfe, 0x91, 0x0, 0x7, 0xff, 0xdc, 0xef,
    0xe2, 0x5, 0xfe, 0x40, 0x0, 0x7f, 0x50, 0xdf,
    0x40, 0x0, 0x0, 0x10, 0x1f, 0xe0, 0x0, 0x0,
    0x0, 0x2, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x40, 0x0,
    0x0, 0x10, 0x5, 0xfe, 0x40, 0x0, 0x7f, 0x50,
    0x7, 0xff, 0xdc, 0xef, 0xe2, 0x0, 0x3, 0xae,
    0xfe, 0x91, 0x0,

    /* U+0108 "Ĉ" */
    0x0, 0x0, 0x0, 0x7, 0x82, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0xee, 0x10, 0x0, 0x0, 0x0,
    0x7, 0xf6, 0x1d, 0xd1, 0x0, 0x0, 0x0, 0x17,
    0x40, 0x1, 0x74, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x17, 0xce, 0xfe,
    0xa5, 0x0, 0x0, 0x5, 0xff, 0xfe, 0xdf, 0xff,
    0xc1, 0x0, 0x6f, 0xf9, 0x20, 0x0, 0x3b, 0xf5,
    0x2, 0xff, 0x50, 0x0, 0x0, 0x0, 0x30, 0x9,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xff, 0x50, 0x0, 0x0, 0x0, 0x30,
    0x0, 0x6f, 0xf9, 0x20, 0x0, 0x3b, 0xf5, 0x0,
    0x5, 0xff, 0xfe, 0xdf, 0xff, 0xc1, 0x0, 0x0,
    0x17, 0xce, 0xfe, 0xb5, 0x0,

    /* U+0109 "ĉ" */
    0x0, 0x0, 0x6f, 0xf7, 0x0, 0x0, 0x0, 0x6f,
    0x86, 0xf8, 0x0, 0x0, 0x29, 0x50, 0x4, 0x92,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xae, 0xfe, 0x91, 0x0, 0x7, 0xff, 0xdc, 0xef,
    0xe2, 0x5, 0xfe, 0x40, 0x0, 0x7f, 0x50, 0xdf,
    0x40, 0x0, 0x0, 0x10, 0x1f, 0xe0, 0x0, 0x0,
    0x0, 0x2, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x40, 0x0,
    0x0, 0x10, 0x5, 0xfe, 0x40, 0x0, 0x7f, 0x50,
    0x7, 0xff, 0xdc, 0xef, 0xe2, 0x0, 0x3, 0xae,
    0xfe, 0x91, 0x0,

    /* U+010A "Ċ" */
    0x0, 0x0, 0x0, 0x2, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x17, 0xce, 0xfe,
    0xa5, 0x0, 0x0, 0x5, 0xff, 0xfe, 0xdf, 0xff,
    0xc1, 0x0, 0x6f, 0xf9, 0x20, 0x0, 0x3b, 0xf5,
    0x2, 0xff, 0x50, 0x0, 0x0, 0x0, 0x30, 0x9,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xff, 0x50, 0x0, 0x0, 0x0, 0x30,
    0x0, 0x6f, 0xf9, 0x20, 0x0, 0x3b, 0xf5, 0x0,
    0x5, 0xff, 0xfe, 0xdf, 0xff, 0xc1, 0x0, 0x0,
    0x17, 0xce, 0xfe, 0xb5, 0x0,

    /* U+010B "ċ" */
    0x0, 0x0, 0xc, 0xd0, 0x0, 0x0, 0x0, 0x1,
    0xff, 0x20, 0x0, 0x0, 0x0, 0x3, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xae, 0xfe, 0x91, 0x0, 0x7, 0xff, 0xdc, 0xef,
    0xe2, 0x5, 0xfe, 0x40, 0x0, 0x7f, 0x50, 0xdf,
    0x40, 0x0, 0x0, 0x10, 0x1f, 0xe0, 0x0, 0x0,
    0x0, 0x2, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x40, 0x0,
    0x0, 0x10, 0x5, 0xfe, 0x40, 0x0, 0x7f, 0x50,
    0x7, 0xff, 0xdc, 0xef, 0xe2, 0x0, 0x3, 0xae,
    0xfe, 0x91, 0x0,

    /* U+010C "Č" */
    0x0, 0x0, 0x17, 0x40, 0x1, 0x74, 0x0, 0x0,
    0x0, 0x7, 0xf6, 0x2d, 0xd1, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0xee, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x7, 0x82, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x17, 0xce, 0xfe,
    0xa5, 0x0, 0x0, 0x5, 0xff, 0xfe, 0xdf, 0xff,
    0xc1, 0x0, 0x6f, 0xf9, 0x20, 0x0, 0x3b, 0xf5,
    0x2, 0xff, 0x50, 0x0, 0x0, 0x0, 0x30, 0x9,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xff, 0x50, 0x0, 0x0, 0x0, 0x30,
    0x0, 0x6f, 0xf9, 0x20, 0x0, 0x3b, 0xf5, 0x0,
    0x5, 0xff, 0xfe, 0xdf, 0xff, 0xc1, 0x0, 0x0,
    0x17, 0xce, 0xfe, 0xb5, 0x0,

    /* U+010D "č" */
    0x0, 0x2e, 0xb1, 0xa, 0xe3, 0x0, 0x0, 0x2d,
    0xdd, 0xe2, 0x0, 0x0, 0x0, 0x19, 0x92, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xae, 0xfe, 0x91, 0x0, 0x7, 0xff, 0xdc, 0xef,
    0xe2, 0x5, 0xfe, 0x40, 0x0, 0x7f, 0x50, 0xdf,
    0x40, 0x0, 0x0, 0x10, 0x1f, 0xe0, 0x0, 0x0,
    0x0, 0x2, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x40, 0x0,
    0x0, 0x10, 0x5, 0xfe, 0x40, 0x0, 0x7f, 0x50,
    0x7, 0xff, 0xdc, 0xef, 0xe2, 0x0, 0x3, 0xae,
    0xfe, 0x91, 0x0,

    /* U+010E "Ď" */
    0x0, 0x7f, 0x60, 0x4e, 0x90, 0x0, 0x0, 0x0,
    0x6, 0xfb, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x58, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xef, 0xff, 0xff, 0xfd,
    0x94, 0x0, 0x0, 0xef, 0xdc, 0xcc, 0xdf, 0xff,
    0xb1, 0x0, 0xef, 0x10, 0x0, 0x0, 0x5d, 0xfd,
    0x0, 0xef, 0x10, 0x0, 0x0, 0x0, 0xcf, 0xa0,
    0xef, 0x10, 0x0, 0x0, 0x0, 0x1f, 0xf1, 0xef,
    0x10, 0x0, 0x0, 0x0, 0xa, 0xf5, 0xef, 0x10,
    0x0, 0x0, 0x0, 0x8, 0xf7, 0xef, 0x10, 0x0,
    0x0, 0x0, 0x8, 0xf7, 0xef, 0x10, 0x0, 0x0,
    0x0, 0xa, 0xf5, 0xef, 0x10, 0x0, 0x0, 0x0,
    0x1f, 0xf1, 0xef, 0x10, 0x0, 0x0, 0x0, 0xcf,
    0xa0, 0xef, 0x10, 0x0, 0x0, 0x4d, 0xfd, 0x0,
    0xef, 0xcc, 0xcc, 0xdf, 0xff, 0xb1, 0x0, 0xef,
    0xff, 0xff, 0xfd, 0xa4, 0x0, 0x0,

    /* U+010F "ď" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xfc, 0x6, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xfc, 0x6, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xfc, 0x6, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xfc, 0x0, 0x0,
    0x0, 0x4, 0xbe, 0xfc, 0x62, 0xfc, 0x0, 0x0,
    0x0, 0x8f, 0xfd, 0xce, 0xfb, 0xfc, 0x0, 0x0,
    0x5, 0xfe, 0x40, 0x0, 0x7f, 0xfc, 0x0, 0x0,
    0xd, 0xf4, 0x0, 0x0, 0x9, 0xfc, 0x0, 0x0,
    0x1f, 0xe0, 0x0, 0x0, 0x3, 0xfc, 0x0, 0x0,
    0x2f, 0xc0, 0x0, 0x0, 0x1, 0xfc, 0x0, 0x0,
    0x1f, 0xe0, 0x0, 0x0, 0x3, 0xfc, 0x0, 0x0,
    0xd, 0xf4, 0x0, 0x0, 0xa, 0xfc, 0x0, 0x0,
    0x5, 0xfe, 0x40, 0x0, 0x7f, 0xfc, 0x0, 0x0,
    0x0, 0x9f, 0xfd, 0xce, 0xfb, 0xfc, 0x0, 0x0,
    0x0, 0x4, 0xbe, 0xfc, 0x60, 0xfc, 0x0, 0x0,

    /* U+0110 "Đ" */
    0x0, 0xcf, 0xff, 0xff, 0xfd, 0xa5, 0x0, 0x0,
    0x0, 0xcf, 0xdc, 0xcc, 0xdf, 0xff, 0xc2, 0x0,
    0x0, 0xcf, 0x30, 0x0, 0x0, 0x4c, 0xfe, 0x20,
    0x0, 0xcf, 0x30, 0x0, 0x0, 0x0, 0xaf, 0xc0,
    0x0, 0xcf, 0x30, 0x0, 0x0, 0x0, 0xe, 0xf3,
    0x0, 0xcf, 0x30, 0x0, 0x0, 0x0, 0x8, 0xf8,
    0xdf, 0xff, 0xff, 0xff, 0x30, 0x0, 0x5, 0xfa,
    0x8a, 0xff, 0xda, 0xaa, 0x10, 0x0, 0x5, 0xfa,
    0x0, 0xcf, 0x30, 0x0, 0x0, 0x0, 0x8, 0xf8,
    0x0, 0xcf, 0x30, 0x0, 0x0, 0x0, 0xe, 0xf3,
    0x0, 0xcf, 0x30, 0x0, 0x0, 0x0, 0xaf, 0xc0,
    0x0, 0xcf, 0x30, 0x0, 0x0, 0x3c, 0xfe, 0x20,
    0x0, 0xcf, 0xdc, 0xcc, 0xdf, 0xff, 0xc2, 0x0,
    0x0, 0xcf, 0xff, 0xff, 0xfd, 0xa5, 0x0, 0x0,

    /* U+0111 "đ" */
    0x0, 0x0, 0x0, 0x11, 0x13, 0xfe, 0x10, 0x0,
    0x0, 0x4, 0xff, 0xff, 0xff, 0xfa, 0x0, 0x0,
    0x1, 0x44, 0x46, 0xff, 0x42, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xfc, 0x0, 0x0, 0x4, 0xbe, 0xfc,
    0x62, 0xfc, 0x0, 0x0, 0x8f, 0xfd, 0xce, 0xfb,
    0xfc, 0x0, 0x5, 0xfe, 0x40, 0x0, 0x7f, 0xfc,
    0x0, 0xd, 0xf4, 0x0, 0x0, 0x9, 0xfc, 0x0,
    0x1f, 0xe0, 0x0, 0x0, 0x3, 0xfc, 0x0, 0x2f,
    0xc0, 0x0, 0x0, 0x1, 0xfc, 0x0, 0x1f, 0xe0,
    0x0, 0x0, 0x3, 0xfc, 0x0, 0xd, 0xf4, 0x0,
    0x0, 0xa, 0xfc, 0x0, 0x5, 0xfe, 0x40, 0x0,
    0x7f, 0xfc, 0x0, 0x0, 0x9f, 0xfd, 0xce, 0xfb,
    0xfc, 0x0, 0x0, 0x4, 0xbe, 0xfc, 0x60, 0xfc,
    0x0,

    /* U+0112 "Ē" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff,
    0xff, 0xf4, 0x0, 0x0, 0x33, 0x33, 0x33, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xe, 0xfd, 0xcc, 0xcc, 0xcc,
    0xc0, 0xef, 0x10, 0x0, 0x0, 0x0, 0xe, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xef,
    0xff, 0xff, 0xff, 0xf1, 0xe, 0xfc, 0xcc, 0xcc,
    0xcc, 0x10, 0xef, 0x10, 0x0, 0x0, 0x0, 0xe,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0,
    0x0, 0x0, 0xe, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xcc, 0xcc, 0xcc, 0xcc, 0x2e, 0xff, 0xff,
    0xff, 0xff, 0xf3,

    /* U+0113 "ē" */
    0x0, 0x2f, 0xff, 0xff, 0xf6, 0x0, 0x0, 0x3,
    0x33, 0x33, 0x31, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xbe, 0xfc, 0x60, 0x0,
    0x0, 0x9f, 0xfc, 0xbe, 0xfb, 0x0, 0x5, 0xfd,
    0x20, 0x0, 0xaf, 0x80, 0xd, 0xf3, 0x0, 0x0,
    0xd, 0xe0, 0x1f, 0xe1, 0x11, 0x11, 0x19, 0xf3,
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x1f, 0xe4,
    0x44, 0x44, 0x44, 0x41, 0xd, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xfe, 0x40, 0x0, 0x2b, 0x20,
    0x0, 0x8f, 0xfe, 0xcd, 0xff, 0x50, 0x0, 0x3,
    0xae, 0xfe, 0xa3, 0x0,

    /* U+0114 "Ĕ" */
    0x1, 0xf7, 0x0, 0x6f, 0x20, 0x0, 0x5, 0xef,
    0xfe, 0x50, 0x0, 0x0, 0x0, 0x11, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xe, 0xfd, 0xcc, 0xcc, 0xcc,
    0xc0, 0xef, 0x10, 0x0, 0x0, 0x0, 0xe, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xef,
    0xff, 0xff, 0xff, 0xf1, 0xe, 0xfc, 0xcc, 0xcc,
    0xcc, 0x10, 0xef, 0x10, 0x0, 0x0, 0x0, 0xe,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0,
    0x0, 0x0, 0xe, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xcc, 0xcc, 0xcc, 0xcc, 0x2e, 0xff, 0xff,
    0xff, 0xff, 0xf3,

    /* U+0115 "ĕ" */
    0x0, 0xf, 0x80, 0x5, 0xf3, 0x0, 0x0, 0x4,
    0xdf, 0xfe, 0x60, 0x0, 0x0, 0x0, 0x1, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xbe, 0xfc, 0x60, 0x0, 0x0, 0x9f,
    0xfc, 0xbe, 0xfb, 0x0, 0x5, 0xfd, 0x20, 0x0,
    0xaf, 0x80, 0xd, 0xf3, 0x0, 0x0, 0xd, 0xe0,
    0x1f, 0xe1, 0x11, 0x11, 0x19, 0xf3, 0x2f, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0x1f, 0xe4, 0x44, 0x44,
    0x44, 0x41, 0xd, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xfe, 0x40, 0x0, 0x2b, 0x20, 0x0, 0x8f,
    0xfe, 0xcd, 0xff, 0x50, 0x0, 0x3, 0xae, 0xfe,
    0xa3, 0x0,

    /* U+0116 "Ė" */
    0x0, 0x0, 0x34, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0xcd, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xff, 0xff, 0xff, 0xff,
    0xf0, 0xef, 0xdc, 0xcc, 0xcc, 0xcc, 0xe, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x10, 0x0, 0x0, 0x0, 0xe, 0xff, 0xff, 0xff,
    0xff, 0x10, 0xef, 0xcc, 0xcc, 0xcc, 0xc1, 0xe,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0,
    0x0, 0x0, 0xe, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xef, 0x10, 0x0, 0x0, 0x0, 0xe, 0xfc, 0xcc,
    0xcc, 0xcc, 0xc2, 0xef, 0xff, 0xff, 0xff, 0xff,
    0x30,

    /* U+0117 "ė" */
    0x0, 0x0, 0xb, 0xe1, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x3, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xbe, 0xfc, 0x60, 0x0, 0x0, 0x9f,
    0xfc, 0xbe, 0xfb, 0x0, 0x5, 0xfd, 0x20, 0x0,
    0xaf, 0x80, 0xd, 0xf3, 0x0, 0x0, 0xd, 0xe0,
    0x1f, 0xe1, 0x11, 0x11, 0x19, 0xf3, 0x2f, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0x1f, 0xe4, 0x44, 0x44,
    0x44, 0x41, 0xd, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xfe, 0x40, 0x0, 0x2b, 0x20, 0x0, 0x8f,
    0xfe, 0xcd, 0xff, 0x50, 0x0, 0x3, 0xae, 0xfe,
    0xa3, 0x0,

    /* U+0118 "Ę" */
    0xef, 0xff, 0xff, 0xff, 0xff, 0xe, 0xfd, 0xcc,
    0xcc, 0xcc, 0xc0, 0xef, 0x10, 0x0, 0x0, 0x0,
    0xe, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xef, 0x10,
    0x0, 0x0, 0x0, 0xe, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0xef, 0xff, 0xff, 0xff, 0xf1, 0xe, 0xfc,
    0xcc, 0xcc, 0xcc, 0x10, 0xef, 0x10, 0x0, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x10, 0x0, 0x0, 0x0, 0xe, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0xef, 0xcc, 0xcc, 0xcc, 0xcc, 0x2e,
    0xff, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x0, 0x0,
    0x9, 0xe5, 0x0, 0x0, 0x0, 0x4, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0x20, 0x10, 0x0, 0x0,
    0x1, 0xdf, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x11,
    0x0,

    /* U+0119 "ę" */
    0x0, 0x4, 0xbe, 0xfc, 0x60, 0x0, 0x0, 0x8f,
    0xfc, 0xbe, 0xfb, 0x0, 0x5, 0xfd, 0x20, 0x0,
    0xaf, 0x80, 0xc, 0xf3, 0x0, 0x0, 0xd, 0xf0,
    0xf, 0xe1, 0x11, 0x11, 0x19, 0xf4, 0x2f, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0xf, 0xe4, 0x44, 0x44,
    0x44, 0x41, 0xc, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xfe, 0x40, 0x0, 0x2b, 0x20, 0x0, 0x7f,
    0xfe, 0xcd, 0xff, 0x60, 0x0, 0x3, 0xae, 0xff,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x2f, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x8c, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9d, 0x11, 0x0, 0x0, 0x0, 0x0, 0x2e,
    0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0x21, 0x0,

    /* U+011A "Ě" */
    0x2, 0xdb, 0x10, 0xbe, 0x20, 0x0, 0x1, 0xde,
    0xde, 0x20, 0x0, 0x0, 0x1, 0x77, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xe, 0xfd, 0xcc, 0xcc, 0xcc,
    0xc0, 0xef, 0x10, 0x0, 0x0, 0x0, 0xe, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xef,
    0xff, 0xff, 0xff, 0xf1, 0xe, 0xfc, 0xcc, 0xcc,
    0xcc, 0x10, 0xef, 0x10, 0x0, 0x0, 0x0, 0xe,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0,
    0x0, 0x0, 0xe, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xcc, 0xcc, 0xcc, 0xcc, 0x2e, 0xff, 0xff,
    0xff, 0xff, 0xf3,

    /* U+011B "ě" */
    0x0, 0x1d, 0xc1, 0xa, 0xf3, 0x0, 0x0, 0x1,
    0xde, 0xcf, 0x30, 0x0, 0x0, 0x0, 0x18, 0x93,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xbe, 0xfc, 0x60, 0x0, 0x0, 0x9f,
    0xfc, 0xbe, 0xfb, 0x0, 0x5, 0xfd, 0x20, 0x0,
    0xaf, 0x80, 0xd, 0xf3, 0x0, 0x0, 0xd, 0xe0,
    0x1f, 0xe1, 0x11, 0x11, 0x19, 0xf3, 0x2f, 0xff,
    0xff, 0xff, 0xff, 0xf5, 0x1f, 0xe4, 0x44, 0x44,
    0x44, 0x41, 0xd, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xfe, 0x40, 0x0, 0x2b, 0x20, 0x0, 0x8f,
    0xfe, 0xcd, 0xff, 0x50, 0x0, 0x3, 0xae, 0xfe,
    0xa3, 0x0,

    /* U+011C "Ĝ" */
    0x0, 0x0, 0x0, 0x7, 0x82, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0xee, 0x10, 0x0, 0x0, 0x0,
    0x8, 0xf6, 0x2e, 0xd0, 0x0, 0x0, 0x0, 0x17,
    0x40, 0x1, 0x74, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x17, 0xce, 0xfe,
    0xb6, 0x0, 0x0, 0x5, 0xff, 0xfe, 0xde, 0xff,
    0xd2, 0x0, 0x6f, 0xf9, 0x20, 0x0, 0x29, 0xf7,
    0x2, 0xff, 0x50, 0x0, 0x0, 0x0, 0x20, 0x9,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x11, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x3, 0xfb, 0xe, 0xf2, 0x0, 0x0, 0x0,
    0x3, 0xfb, 0x9, 0xf9, 0x0, 0x0, 0x0, 0x3,
    0xfb, 0x2, 0xff, 0x50, 0x0, 0x0, 0x3, 0xfb,
    0x0, 0x6f, 0xf9, 0x20, 0x0, 0x29, 0xfb, 0x0,
    0x5, 0xff, 0xfe, 0xde, 0xff, 0xe4, 0x0, 0x0,
    0x17, 0xce, 0xfe, 0xb6, 0x0,

    /* U+011D "ĝ" */
    0x0, 0x0, 0x1c, 0xfd, 0x20, 0x0, 0x0, 0x1,
    0xdd, 0x4c, 0xe2, 0x0, 0x0, 0x6, 0x81, 0x0,
    0x87, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xbe, 0xfd, 0x70, 0xef, 0x0, 0x9f,
    0xfd, 0xce, 0xfc, 0xef, 0x5, 0xfe, 0x40, 0x0,
    0x6f, 0xff, 0xd, 0xf4, 0x0, 0x0, 0x7, 0xff,
    0x1f, 0xe0, 0x0, 0x0, 0x1, 0xff, 0x2f, 0xc0,
    0x0, 0x0, 0x0, 0xff, 0x1f, 0xe0, 0x0, 0x0,
    0x1, 0xff, 0xd, 0xf4, 0x0, 0x0, 0x7, 0xff,
    0x5, 0xfe, 0x40, 0x0, 0x6f, 0xff, 0x0, 0x8f,
    0xfd, 0xbe, 0xfc, 0xfe, 0x0, 0x4, 0xbe, 0xfd,
    0x71, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x4, 0xfa,
    0x1, 0xa3, 0x0, 0x0, 0x2d, 0xf4, 0x5, 0xff,
    0xec, 0xbd, 0xff, 0x90, 0x0, 0x28, 0xce, 0xfe,
    0xb5, 0x0,

    /* U+011E "Ğ" */
    0x0, 0x0, 0x7, 0x20, 0x0, 0x72, 0x0, 0x0,
    0x0, 0xc, 0xb1, 0x7, 0xf2, 0x0, 0x0, 0x0,
    0x2, 0xcf, 0xfe, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x17, 0xce, 0xfe,
    0xb6, 0x0, 0x0, 0x5, 0xff, 0xfe, 0xde, 0xff,
    0xd2, 0x0, 0x6f, 0xf9, 0x20, 0x0, 0x29, 0xf7,
    0x2, 0xff, 0x50, 0x0, 0x0, 0x0, 0x20, 0x9,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x11, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x3, 0xfb, 0xe, 0xf2, 0x0, 0x0, 0x0,
    0x3, 0xfb, 0x9, 0xf9, 0x0, 0x0, 0x0, 0x3,
    0xfb, 0x2, 0xff, 0x50, 0x0, 0x0, 0x3, 0xfb,
    0x0, 0x6f, 0xf9, 0x20, 0x0, 0x29, 0xfb, 0x0,
    0x5, 0xff, 0xfe, 0xde, 0xff, 0xe4, 0x0, 0x0,
    0x17, 0xce, 0xfe, 0xb6, 0x0,

    /* U+011F "ğ" */
    0x0, 0x8, 0xd2, 0x1, 0xca, 0x0, 0x0, 0x0,
    0xaf, 0xff, 0xb1, 0x0, 0x0, 0x0, 0x0, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xbe, 0xfd, 0x70, 0xef, 0x0, 0x9f,
    0xfd, 0xce, 0xfc, 0xef, 0x5, 0xfe, 0x40, 0x0,
    0x6f, 0xff, 0xd, 0xf4, 0x0, 0x0, 0x7, 0xff,
    0x1f, 0xe0, 0x0, 0x0, 0x1, 0xff, 0x2f, 0xc0,
    0x0, 0x0, 0x0, 0xff, 0x1f, 0xe0, 0x0, 0x0,
    0x1, 0xff, 0xd, 0xf4, 0x0, 0x0, 0x7, 0xff,
    0x5, 0xfe, 0x40, 0x0, 0x6f, 0xff, 0x0, 0x8f,
    0xfd, 0xbe, 0xfc, 0xfe, 0x0, 0x4, 0xbe, 0xfd,
    0x71, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x4, 0xfa,
    0x1, 0xa3, 0x0, 0x0, 0x2d, 0xf4, 0x5, 0xff,
    0xec, 0xbd, 0xff, 0x90, 0x0, 0x28, 0xce, 0xfe,
    0xb5, 0x0,

    /* U+0120 "Ġ" */
    0x0, 0x0, 0x0, 0x2, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xa, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x17, 0xce, 0xfe,
    0xb6, 0x0, 0x0, 0x5, 0xff, 0xfe, 0xde, 0xff,
    0xd2, 0x0, 0x6f, 0xf9, 0x20, 0x0, 0x29, 0xf7,
    0x2, 0xff, 0x50, 0x0, 0x0, 0x0, 0x20, 0x9,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x11, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x3, 0xfb, 0xe, 0xf2, 0x0, 0x0, 0x0,
    0x3, 0xfb, 0x9, 0xf9, 0x0, 0x0, 0x0, 0x3,
    0xfb, 0x2, 0xff, 0x50, 0x0, 0x0, 0x3, 0xfb,
    0x0, 0x6f, 0xf9, 0x20, 0x0, 0x29, 0xfb, 0x0,
    0x5, 0xff, 0xfe, 0xde, 0xff, 0xe4, 0x0, 0x0,
    0x17, 0xce, 0xfe, 0xb6, 0x0,

    /* U+0121 "ġ" */
    0x0, 0x0, 0x5, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x51,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xbe, 0xfd, 0x70, 0xef, 0x0, 0x9f,
    0xfd, 0xce, 0xfc, 0xef, 0x5, 0xfe, 0x40, 0x0,
    0x6f, 0xff, 0xd, 0xf4, 0x0, 0x0, 0x7, 0xff,
    0x1f, 0xe0, 0x0, 0x0, 0x1, 0xff, 0x2f, 0xc0,
    0x0, 0x0, 0x0, 0xff, 0x1f, 0xe0, 0x0, 0x0,
    0x1, 0xff, 0xd, 0xf4, 0x0, 0x0, 0x7, 0xff,
    0x5, 0xfe, 0x40, 0x0, 0x6f, 0xff, 0x0, 0x8f,
    0xfd, 0xbe, 0xfc, 0xfe, 0x0, 0x4, 0xbe, 0xfd,
    0x71, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x4, 0xfa,
    0x1, 0xa3, 0x0, 0x0, 0x2d, 0xf4, 0x5, 0xff,
    0xec, 0xbd, 0xff, 0x90, 0x0, 0x28, 0xce, 0xfe,
    0xb5, 0x0,

    /* U+0122 "Ģ" */
    0x0, 0x0, 0x17, 0xce, 0xfe, 0xb6, 0x0, 0x0,
    0x5, 0xff, 0xfe, 0xde, 0xff, 0xd2, 0x0, 0x6f,
    0xf9, 0x20, 0x0, 0x29, 0xf7, 0x2, 0xff, 0x50,
    0x0, 0x0, 0x0, 0x20, 0x9, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x11, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x3, 0xfb,
    0xe, 0xf2, 0x0, 0x0, 0x0, 0x3, 0xfb, 0x9,
    0xf9, 0x0, 0x0, 0x0, 0x3, 0xfb, 0x2, 0xff,
    0x50, 0x0, 0x0, 0x3, 0xfb, 0x0, 0x6f, 0xf9,
    0x20, 0x0, 0x29, 0xfb, 0x0, 0x5, 0xff, 0xfe,
    0xde, 0xff, 0xe4, 0x0, 0x0, 0x17, 0xce, 0xfe,
    0xb6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0x20, 0x0, 0x0,

    /* U+0123 "ģ" */
    0x0, 0x0, 0x0, 0xb6, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xd6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xbe, 0xfd, 0x70, 0xef, 0x0, 0x9f, 0xfd, 0xce,
    0xfc, 0xef, 0x5, 0xfe, 0x40, 0x0, 0x6f, 0xff,
    0xd, 0xf4, 0x0, 0x0, 0x7, 0xff, 0x1f, 0xe0,
    0x0, 0x0, 0x1, 0xff, 0x2f, 0xc0, 0x0, 0x0,
    0x0, 0xff, 0x1f, 0xe0, 0x0, 0x0, 0x1, 0xff,
    0xd, 0xf4, 0x0, 0x0, 0x7, 0xff, 0x5, 0xfe,
    0x40, 0x0, 0x6f, 0xff, 0x0, 0x8f, 0xfd, 0xbe,
    0xfc, 0xfe, 0x0, 0x4, 0xbe, 0xfd, 0x71, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xfa, 0x1, 0xa3,
    0x0, 0x0, 0x2d, 0xf4, 0x5, 0xff, 0xec, 0xbd,
    0xff, 0x90, 0x0, 0x28, 0xce, 0xfe, 0xb5, 0x0,

    /* U+0124 "Ĥ" */
    0x0, 0x0, 0x6f, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0x75, 0xf9, 0x0, 0x0, 0x0, 0x17, 0x40,
    0x3, 0x83, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xef, 0x10, 0x0, 0x0, 0x0, 0xef,
    0x2e, 0xf1, 0x0, 0x0, 0x0, 0xe, 0xf2, 0xef,
    0x10, 0x0, 0x0, 0x0, 0xef, 0x2e, 0xf1, 0x0,
    0x0, 0x0, 0xe, 0xf2, 0xef, 0x10, 0x0, 0x0,
    0x0, 0xef, 0x2e, 0xf1, 0x0, 0x0, 0x0, 0xe,
    0xf2, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0x2e,
    0xfd, 0xcc, 0xcc, 0xcc, 0xcf, 0xf2, 0xef, 0x10,
    0x0, 0x0, 0x0, 0xef, 0x2e, 0xf1, 0x0, 0x0,
    0x0, 0xe, 0xf2, 0xef, 0x10, 0x0, 0x0, 0x0,
    0xef, 0x2e, 0xf1, 0x0, 0x0, 0x0, 0xe, 0xf2,
    0xef, 0x10, 0x0, 0x0, 0x0, 0xef, 0x2e, 0xf1,
    0x0, 0x0, 0x0, 0xe, 0xf2,

    /* U+0125 "ĥ" */
    0x0, 0xaf, 0xf4, 0x0, 0x0, 0x0, 0x0, 0xbe,
    0x49, 0xf4, 0x0, 0x0, 0x0, 0x47, 0x10, 0x5,
    0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xb1, 0x9e,
    0xfe, 0x80, 0x0, 0x3, 0xfd, 0xef, 0xdd, 0xff,
    0xd0, 0x0, 0x3f, 0xfc, 0x10, 0x2, 0xdf, 0x70,
    0x3, 0xff, 0x20, 0x0, 0x5, 0xfb, 0x0, 0x3f,
    0xc0, 0x0, 0x0, 0x1f, 0xd0, 0x3, 0xfb, 0x0,
    0x0, 0x0, 0xfe, 0x0, 0x3f, 0xb0, 0x0, 0x0,
    0xf, 0xe0, 0x3, 0xfb, 0x0, 0x0, 0x0, 0xfe,
    0x0, 0x3f, 0xb0, 0x0, 0x0, 0xf, 0xe0, 0x3,
    0xfb, 0x0, 0x0, 0x0, 0xfe, 0x0, 0x3f, 0xb0,
    0x0, 0x0, 0xf, 0xe0,

    /* U+0126 "Ħ" */
    0x0, 0xcf, 0x30, 0x0, 0x0, 0x0, 0xbf, 0x40,
    0x0, 0xc, 0xf3, 0x0, 0x0, 0x0, 0xb, 0xf4,
    0x0, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0x48, 0xaf, 0xfd, 0xaa, 0xaa, 0xaa, 0xaf,
    0xfe, 0xa2, 0x0, 0xcf, 0x30, 0x0, 0x0, 0x0,
    0xbf, 0x40, 0x0, 0xc, 0xf3, 0x0, 0x0, 0x0,
    0xb, 0xf4, 0x0, 0x0, 0xcf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x40, 0x0, 0xc, 0xfd, 0xcc, 0xcc,
    0xcc, 0xcf, 0xf4, 0x0, 0x0, 0xcf, 0x30, 0x0,
    0x0, 0x0, 0xbf, 0x40, 0x0, 0xc, 0xf3, 0x0,
    0x0, 0x0, 0xb, 0xf4, 0x0, 0x0, 0xcf, 0x30,
    0x0, 0x0, 0x0, 0xbf, 0x40, 0x0, 0xc, 0xf3,
    0x0, 0x0, 0x0, 0xb, 0xf4, 0x0, 0x0, 0xcf,
    0x30, 0x0, 0x0, 0x0, 0xbf, 0x40, 0x0, 0xc,
    0xf3, 0x0, 0x0, 0x0, 0xb, 0xf4, 0x0,

    /* U+0127 "ħ" */
    0x1, 0x4f, 0xd1, 0x11, 0x10, 0x0, 0x0, 0xff,
    0xff, 0xff, 0xfe, 0x0, 0x0, 0x4, 0x7f, 0xf4,
    0x44, 0x40, 0x0, 0x0, 0x3, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xb1, 0x9e, 0xfe, 0x80,
    0x0, 0x3, 0xfd, 0xef, 0xdd, 0xff, 0xd0, 0x0,
    0x3f, 0xfc, 0x10, 0x2, 0xdf, 0x70, 0x3, 0xff,
    0x20, 0x0, 0x5, 0xfb, 0x0, 0x3f, 0xc0, 0x0,
    0x0, 0x1f, 0xd0, 0x3, 0xfb, 0x0, 0x0, 0x0,
    0xfe, 0x0, 0x3f, 0xb0, 0x0, 0x0, 0xf, 0xe0,
    0x3, 0xfb, 0x0, 0x0, 0x0, 0xfe, 0x0, 0x3f,
    0xb0, 0x0, 0x0, 0xf, 0xe0, 0x3, 0xfb, 0x0,
    0x0, 0x0, 0xfe, 0x0, 0x3f, 0xb0, 0x0, 0x0,
    0xf, 0xe0,

    /* U+0128 "Ĩ" */
    0x0, 0x0, 0x0, 0x0, 0x8, 0xfd, 0x51, 0xd5,
    0x2f, 0x24, 0xef, 0xd0, 0x2, 0x0, 0x2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xf1, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0xe, 0xf1, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0xe, 0xf1, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0xe, 0xf1, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0xe, 0xf1, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0xe, 0xf1, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0xe, 0xf1, 0x0,
    0x0, 0xe, 0xf1, 0x0,

    /* U+0129 "ĩ" */
    0x7, 0xfb, 0x29, 0x80, 0xf6, 0xaf, 0xf3, 0x3,
    0x0, 0x11, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xb0, 0x0, 0x3, 0xfb, 0x0, 0x0, 0x3f, 0xb0,
    0x0, 0x3, 0xfb, 0x0, 0x0, 0x3f, 0xb0, 0x0,
    0x3, 0xfb, 0x0, 0x0, 0x3f, 0xb0, 0x0, 0x3,
    0xfb, 0x0, 0x0, 0x3f, 0xb0, 0x0, 0x3, 0xfb,
    0x0, 0x0, 0x3f, 0xb0, 0x0,

    /* U+012A "Ī" */
    0x0, 0x0, 0x0, 0x9f, 0xff, 0xfb, 0x13, 0x33,
    0x32, 0x0, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0,
    0xef, 0x10, 0x0, 0xef, 0x10, 0x0, 0xef, 0x10,
    0x0, 0xef, 0x10, 0x0, 0xef, 0x10, 0x0, 0xef,
    0x10, 0x0, 0xef, 0x10, 0x0, 0xef, 0x10, 0x0,
    0xef, 0x10, 0x0, 0xef, 0x10, 0x0, 0xef, 0x10,
    0x0, 0xef, 0x10, 0x0, 0xef, 0x10,

    /* U+012B "ī" */
    0xef, 0xff, 0xf6, 0x33, 0x33, 0x31, 0x0, 0x0,
    0x0, 0x3, 0xfb, 0x0, 0x3, 0xfb, 0x0, 0x3,
    0xfb, 0x0, 0x3, 0xfb, 0x0, 0x3, 0xfb, 0x0,
    0x3, 0xfb, 0x0, 0x3, 0xfb, 0x0, 0x3, 0xfb,
    0x0, 0x3, 0xfb, 0x0, 0x3, 0xfb, 0x0, 0x3,
    0xfb, 0x0,

    /* U+012C "Ĭ" */
    0xf, 0x70, 0x5, 0xf2, 0x4, 0xdf, 0xfe, 0x60,
    0x0, 0x1, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0xe, 0xf1, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0xe, 0xf1, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0xe, 0xf1, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0xe, 0xf1, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0xe, 0xf1, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0xe, 0xf1, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0xe, 0xf1, 0x0,

    /* U+012D "ĭ" */
    0xd8, 0x1, 0xe6, 0x4e, 0xff, 0xa0, 0x0, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xfb, 0x0, 0x3,
    0xfb, 0x0, 0x3, 0xfb, 0x0, 0x3, 0xfb, 0x0,
    0x3, 0xfb, 0x0, 0x3, 0xfb, 0x0, 0x3, 0xfb,
    0x0, 0x3, 0xfb, 0x0, 0x3, 0xfb, 0x0, 0x3,
    0xfb, 0x0, 0x3, 0xfb, 0x0,

    /* U+012E "Į" */
    0xe, 0xf1, 0xe, 0xf1, 0xe, 0xf1, 0xe, 0xf1,
    0xe, 0xf1, 0xe, 0xf1, 0xe, 0xf1, 0xe, 0xf1,
    0xe, 0xf1, 0xe, 0xf1, 0xe, 0xf1, 0xe, 0xf1,
    0xe, 0xf1, 0xf, 0xf1, 0xc, 0x90, 0x4f, 0x0,
    0x6f, 0x20, 0x1d, 0xfa, 0x0, 0x20,

    /* U+012F "į" */
    0x3e, 0xb0, 0x7f, 0xf0, 0x8, 0x40, 0x0, 0x0,
    0x3f, 0xb0, 0x3f, 0xb0, 0x3f, 0xb0, 0x3f, 0xb0,
    0x3f, 0xb0, 0x3f, 0xb0, 0x3f, 0xb0, 0x3f, 0xb0,
    0x3f, 0xb0, 0x3f, 0xb0, 0x3f, 0xf0, 0x2f, 0x40,
    0xab, 0x0, 0xcb, 0x0, 0x5f, 0xf4, 0x0, 0x10,

    /* U+0130 "İ" */
    0x3, 0x40, 0xf, 0xf2, 0xc, 0xd1, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xf1, 0xe, 0xf1, 0xe, 0xf1,
    0xe, 0xf1, 0xe, 0xf1, 0xe, 0xf1, 0xe, 0xf1,
    0xe, 0xf1, 0xe, 0xf1, 0xe, 0xf1, 0xe, 0xf1,
    0xe, 0xf1, 0xe, 0xf1, 0xe, 0xf1,

    /* U+0131 "ı" */
    0x3f, 0xb3, 0xfb, 0x3f, 0xb3, 0xfb, 0x3f, 0xb3,
    0xfb, 0x3f, 0xb3, 0xfb, 0x3f, 0xb3, 0xfb, 0x3f,
    0xb0,

    /* U+0132 "Ĳ" */
    0xf, 0xf0, 0x0, 0x0, 0x9, 0xf6, 0xf, 0xf0,
    0x0, 0x0, 0x9, 0xf6, 0xf, 0xf0, 0x0, 0x0,
    0x9, 0xf6, 0xf, 0xf0, 0x0, 0x0, 0x9, 0xf6,
    0xf, 0xf0, 0x0, 0x0, 0x9, 0xf6, 0xf, 0xf0,
    0x0, 0x0, 0x9, 0xf6, 0xf, 0xf0, 0x0, 0x0,
    0x9, 0xf6, 0xf, 0xf0, 0x0, 0x0, 0x9, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xe0, 0xa, 0x82, 0x0, 0x4, 0xef, 0x70,
    0x1e, 0xff, 0xed, 0xef, 0xfa, 0x0, 0x0, 0x6b,
    0xef, 0xeb, 0x50, 0x0,

    /* U+0133 "ĳ" */
    0x3e, 0xb0, 0x0, 0x8f, 0x67, 0xff, 0x0, 0xc,
    0xfa, 0x8, 0x40, 0x0, 0x38, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xb0, 0x0, 0x8f, 0x63, 0xfb,
    0x0, 0x8, 0xf6, 0x3f, 0xb0, 0x0, 0x8f, 0x63,
    0xfb, 0x0, 0x8, 0xf6, 0x3f, 0xb0, 0x0, 0x8f,
    0x63, 0xfb, 0x0, 0x8, 0xf6, 0x3f, 0xb0, 0x0,
    0x8f, 0x63, 0xfb, 0x0, 0x8, 0xf6, 0x3f, 0xb0,
    0x0, 0x8f, 0x63, 0xfb, 0x0, 0x8, 0xf6, 0x3f,
    0xb0, 0x0, 0x8f, 0x60, 0x0, 0x0, 0x8, 0xf6,
    0x0, 0x0, 0x0, 0xcf, 0x30, 0x0, 0xdb, 0xcf,
    0xd0, 0x0, 0x1b, 0xfe, 0xa1, 0x0,

    /* U+0134 "Ĵ" */
    0x0, 0x0, 0x38, 0x70, 0x0, 0x0, 0x2, 0xee,
    0xf9, 0x0, 0x0, 0x1d, 0xd1, 0x7f, 0x70, 0x0,
    0x47, 0x10, 0x5, 0x71, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xff, 0xff, 0xf4, 0x0, 0x9c,
    0xcc, 0xcf, 0xf4, 0x0, 0x0, 0x0, 0xb, 0xf4,
    0x0, 0x0, 0x0, 0xb, 0xf4, 0x0, 0x0, 0x0,
    0xb, 0xf4, 0x0, 0x0, 0x0, 0xb, 0xf4, 0x0,
    0x0, 0x0, 0xb, 0xf4, 0x0, 0x0, 0x0, 0xb,
    0xf4, 0x0, 0x0, 0x0, 0xb, 0xf4, 0x0, 0x0,
    0x0, 0xb, 0xf4, 0x1, 0x0, 0x0, 0xd, 0xf2,
    0xc, 0xc2, 0x0, 0x6f, 0xe0, 0xa, 0xff, 0xde,
    0xff, 0x60, 0x0, 0x6c, 0xff, 0xc5, 0x0,

    /* U+0135 "ĵ" */
    0x0, 0x7, 0xff, 0x30, 0x0, 0x5f, 0x7b, 0xe2,
    0x0, 0x75, 0x0, 0x75, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xfd, 0x0, 0x0, 0x1, 0xfd, 0x0,
    0x0, 0x1, 0xfd, 0x0, 0x0, 0x1, 0xfd, 0x0,
    0x0, 0x1, 0xfd, 0x0, 0x0, 0x1, 0xfd, 0x0,
    0x0, 0x1, 0xfd, 0x0, 0x0, 0x1, 0xfd, 0x0,
    0x0, 0x1, 0xfd, 0x0, 0x0, 0x1, 0xfd, 0x0,
    0x0, 0x1, 0xfd, 0x0, 0x0, 0x1, 0xfc, 0x0,
    0x0, 0x5, 0xfa, 0x0, 0x8d, 0xbf, 0xf3, 0x0,
    0x7e, 0xfd, 0x50, 0x0,

    /* U+0136 "Ķ" */
    0xef, 0x10, 0x0, 0x0, 0xc, 0xf7, 0xe, 0xf1,
    0x0, 0x0, 0xb, 0xf8, 0x0, 0xef, 0x10, 0x0,
    0xb, 0xf9, 0x0, 0xe, 0xf1, 0x0, 0xb, 0xfa,
    0x0, 0x0, 0xef, 0x10, 0xa, 0xfa, 0x0, 0x0,
    0xe, 0xf1, 0xa, 0xfb, 0x0, 0x0, 0x0, 0xef,
    0x19, 0xff, 0x30, 0x0, 0x0, 0xe, 0xfa, 0xff,
    0xfe, 0x10, 0x0, 0x0, 0xef, 0xfd, 0x1b, 0xfc,
    0x0, 0x0, 0xe, 0xfd, 0x10, 0xd, 0xfa, 0x0,
    0x0, 0xef, 0x20, 0x0, 0x1e, 0xf7, 0x0, 0xe,
    0xf1, 0x0, 0x0, 0x3f, 0xf4, 0x0, 0xef, 0x10,
    0x0, 0x0, 0x4f, 0xf2, 0xe, 0xf1, 0x0, 0x0,
    0x0, 0x6f, 0xd1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x2, 0x50, 0x0,
    0x0, 0x0,

    /* U+0137 "ķ" */
    0x3f, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xb0, 0x0, 0x2, 0xef, 0x50, 0x3f, 0xb0,
    0x0, 0x2e, 0xf5, 0x0, 0x3f, 0xb0, 0x3, 0xef,
    0x50, 0x0, 0x3f, 0xb0, 0x3f, 0xf6, 0x0, 0x0,
    0x3f, 0xb4, 0xff, 0x90, 0x0, 0x0, 0x3f, 0xef,
    0xff, 0xf2, 0x0, 0x0, 0x3f, 0xff, 0x49, 0xfc,
    0x0, 0x0, 0x3f, 0xf4, 0x0, 0xcf, 0x90, 0x0,
    0x3f, 0xb0, 0x0, 0x1e, 0xf5, 0x0, 0x3f, 0xb0,
    0x0, 0x4, 0xff, 0x20, 0x3f, 0xb0, 0x0, 0x0,
    0x7f, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9e, 0x20, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x5c, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x33, 0x0, 0x0, 0x0,

    /* U+0138 "ĸ" */
    0x3f, 0xb0, 0x0, 0x2, 0xdf, 0x50, 0x3f, 0xb0,
    0x0, 0x2e, 0xf6, 0x0, 0x3f, 0xb0, 0x3, 0xef,
    0x60, 0x0, 0x3f, 0xb0, 0x3f, 0xf6, 0x0, 0x0,
    0x3f, 0xb4, 0xff, 0x90, 0x0, 0x0, 0x3f, 0xef,
    0xff, 0xf2, 0x0, 0x0, 0x3f, 0xff, 0x49, 0xfd,
    0x0, 0x0, 0x3f, 0xf4, 0x0, 0xcf, 0x90, 0x0,
    0x3f, 0xb0, 0x0, 0x1e, 0xf6, 0x0, 0x3f, 0xb0,
    0x0, 0x4, 0xff, 0x20, 0x3f, 0xb0, 0x0, 0x0,
    0x7f, 0xd0,

    /* U+0139 "Ĺ" */
    0x9, 0xf7, 0x0, 0x0, 0x0, 0x0, 0xee, 0x0,
    0x0, 0x0, 0x0, 0x1a, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x10, 0x0, 0x0, 0x0, 0xe, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0xef, 0x10, 0x0, 0x0, 0x0, 0xe,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0,
    0x0, 0x0, 0xe, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0xef, 0x10, 0x0, 0x0, 0x0, 0xe, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0xef, 0x10, 0x0, 0x0, 0x0,
    0xe, 0xfc, 0xcc, 0xcc, 0xcc, 0x80, 0xef, 0xff,
    0xff, 0xff, 0xfa,

    /* U+013A "ĺ" */
    0x9, 0xa2, 0x1f, 0xc0, 0x6f, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xb0, 0x3f, 0xb0, 0x3f, 0xb0,
    0x3f, 0xb0, 0x3f, 0xb0, 0x3f, 0xb0, 0x3f, 0xb0,
    0x3f, 0xb0, 0x3f, 0xb0, 0x3f, 0xb0, 0x3f, 0xb0,
    0x3f, 0xb0, 0x3f, 0xb0, 0x3f, 0xb0, 0x3f, 0xb0,

    /* U+013B "Ļ" */
    0xef, 0x10, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0,
    0x0, 0x0, 0xef, 0x10, 0x0, 0x0, 0x0, 0xef,
    0x10, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0, 0x0,
    0x0, 0xef, 0x10, 0x0, 0x0, 0x0, 0xef, 0x10,
    0x0, 0x0, 0x0, 0xef, 0x10, 0x0, 0x0, 0x0,
    0xef, 0x10, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0,
    0x0, 0x0, 0xef, 0x10, 0x0, 0x0, 0x0, 0xef,
    0x10, 0x0, 0x0, 0x0, 0xef, 0xcc, 0xcc, 0xcc,
    0xc8, 0xef, 0xff, 0xff, 0xff, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbd, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x0, 0x0, 0x0, 0x0, 0x7a, 0x0, 0x0, 0x0,
    0x0, 0x52, 0x0, 0x0,

    /* U+013C "ļ" */
    0x3f, 0xb3, 0xfb, 0x3f, 0xb3, 0xfb, 0x3f, 0xb3,
    0xfb, 0x3f, 0xb3, 0xfb, 0x3f, 0xb3, 0xfb, 0x3f,
    0xb3, 0xfb, 0x3f, 0xb3, 0xfb, 0x3f, 0xb0, 0x0,
    0x0, 0x2, 0xe9, 0x1e, 0xa0, 0xd4, 0x7, 0x0,

    /* U+013D "Ľ" */
    0x0, 0x0, 0x0, 0x4f, 0x40, 0xef, 0x10, 0x0,
    0x4f, 0x30, 0xef, 0x10, 0x0, 0x4f, 0x20, 0xef,
    0x10, 0x0, 0x4f, 0x10, 0xef, 0x10, 0x0, 0x0,
    0x0, 0xef, 0x10, 0x0, 0x0, 0x0, 0xef, 0x10,
    0x0, 0x0, 0x0, 0xef, 0x10, 0x0, 0x0, 0x0,
    0xef, 0x10, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0,
    0x0, 0x0, 0xef, 0x10, 0x0, 0x0, 0x0, 0xef,
    0x10, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0, 0x0,
    0x0, 0xef, 0xcc, 0xcc, 0xcc, 0xc8, 0xef, 0xff,
    0xff, 0xff, 0xfa,

    /* U+013E "ľ" */
    0x0, 0x0, 0x7f, 0x3, 0xfb, 0x8, 0xf0, 0x3f,
    0xb0, 0x8e, 0x3, 0xfb, 0x8, 0xd0, 0x3f, 0xb0,
    0x0, 0x3, 0xfb, 0x0, 0x0, 0x3f, 0xb0, 0x0,
    0x3, 0xfb, 0x0, 0x0, 0x3f, 0xb0, 0x0, 0x3,
    0xfb, 0x0, 0x0, 0x3f, 0xb0, 0x0, 0x3, 0xfb,
    0x0, 0x0, 0x3f, 0xb0, 0x0, 0x3, 0xfb, 0x0,
    0x0, 0x3f, 0xb0, 0x0, 0x3, 0xfb, 0x0, 0x0,

    /* U+013F "Ŀ" */
    0xef, 0x10, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0,
    0x0, 0x0, 0xef, 0x10, 0x0, 0x0, 0x0, 0xef,
    0x10, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0, 0x66,
    0x0, 0xef, 0x10, 0x2, 0xff, 0x20, 0xef, 0x10,
    0x0, 0xdd, 0x0, 0xef, 0x10, 0x0, 0x0, 0x0,
    0xef, 0x10, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0,
    0x0, 0x0, 0xef, 0x10, 0x0, 0x0, 0x0, 0xef,
    0x10, 0x0, 0x0, 0x0, 0xef, 0xcc, 0xcc, 0xcc,
    0xc8, 0xef, 0xff, 0xff, 0xff, 0xfa,

    /* U+0140 "ŀ" */
    0x3f, 0xb0, 0x0, 0x3, 0xfb, 0x0, 0x0, 0x3f,
    0xb0, 0x0, 0x3, 0xfb, 0x0, 0x0, 0x3f, 0xb0,
    0x0, 0x3, 0xfb, 0x0, 0x0, 0x3f, 0xb0, 0x14,
    0x3, 0xfb, 0xd, 0xf4, 0x3f, 0xb0, 0xae, 0x23,
    0xfb, 0x0, 0x0, 0x3f, 0xb0, 0x0, 0x3, 0xfb,
    0x0, 0x0, 0x3f, 0xb0, 0x0, 0x3, 0xfb, 0x0,
    0x0, 0x3f, 0xb0, 0x0, 0x0,

    /* U+0141 "Ł" */
    0x0, 0xcf, 0x30, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0x30, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x30, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0x32, 0x90, 0x0, 0x0,
    0x0, 0xcf, 0xaf, 0xd1, 0x0, 0x0, 0x0, 0xcf,
    0xfa, 0x0, 0x0, 0x0, 0x2, 0xff, 0xa0, 0x0,
    0x0, 0x0, 0x5f, 0xff, 0x30, 0x0, 0x0, 0x0,
    0x6b, 0xdf, 0x30, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0x30, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x30, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0x30, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0xdc, 0xcc, 0xcc, 0xca, 0x0, 0xcf,
    0xff, 0xff, 0xff, 0xfd,

    /* U+0142 "ł" */
    0x0, 0xf, 0xe0, 0x0, 0x0, 0xfe, 0x0, 0x0,
    0xf, 0xe0, 0x0, 0x0, 0xfe, 0x0, 0x0, 0xf,
    0xe0, 0x0, 0x0, 0xfe, 0x56, 0x0, 0xf, 0xff,
    0xa0, 0x2, 0xff, 0x70, 0x4, 0xff, 0xf0, 0x0,
    0xec, 0xfe, 0x0, 0x2, 0x1f, 0xe0, 0x0, 0x0,
    0xfe, 0x0, 0x0, 0xf, 0xe0, 0x0, 0x0, 0xfe,
    0x0, 0x0, 0xf, 0xe0, 0x0,

    /* U+0143 "Ń" */
    0x0, 0x0, 0x9, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xee, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1a,
    0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xef, 0x20, 0x0, 0x0, 0x0, 0xef,
    0x2e, 0xfd, 0x10, 0x0, 0x0, 0xe, 0xf2, 0xef,
    0xfb, 0x0, 0x0, 0x0, 0xef, 0x2e, 0xfe, 0xf8,
    0x0, 0x0, 0xe, 0xf2, 0xef, 0x4f, 0xf5, 0x0,
    0x0, 0xef, 0x2e, 0xf1, 0x5f, 0xf3, 0x0, 0xe,
    0xf2, 0xef, 0x10, 0x8f, 0xd1, 0x0, 0xef, 0x2e,
    0xf1, 0x0, 0xbf, 0xb0, 0xe, 0xf2, 0xef, 0x10,
    0x1, 0xdf, 0x90, 0xef, 0x2e, 0xf1, 0x0, 0x2,
    0xff, 0x5e, 0xf2, 0xef, 0x10, 0x0, 0x5, 0xff,
    0xff, 0x2e, 0xf1, 0x0, 0x0, 0x8, 0xff, 0xf2,
    0xef, 0x10, 0x0, 0x0, 0xb, 0xff, 0x2e, 0xf1,
    0x0, 0x0, 0x0, 0x1d, 0xf2,

    /* U+0144 "ń" */
    0x0, 0x0, 0xd, 0xf3, 0x0, 0x0, 0x0, 0x2,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x4a, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xa2,
    0x9e, 0xfe, 0x80, 0x3, 0xfc, 0xff, 0xdd, 0xff,
    0xd0, 0x3f, 0xfc, 0x10, 0x2, 0xdf, 0x73, 0xff,
    0x20, 0x0, 0x5, 0xfb, 0x3f, 0xc0, 0x0, 0x0,
    0x1f, 0xd3, 0xfb, 0x0, 0x0, 0x0, 0xfe, 0x3f,
    0xb0, 0x0, 0x0, 0xf, 0xe3, 0xfb, 0x0, 0x0,
    0x0, 0xfe, 0x3f, 0xb0, 0x0, 0x0, 0xf, 0xe3,
    0xfb, 0x0, 0x0, 0x0, 0xfe, 0x3f, 0xb0, 0x0,
    0x0, 0xf, 0xe0,

    /* U+0145 "Ņ" */
    0xef, 0x20, 0x0, 0x0, 0x0, 0xef, 0x2e, 0xfd,
    0x10, 0x0, 0x0, 0xe, 0xf2, 0xef, 0xfb, 0x0,
    0x0, 0x0, 0xef, 0x2e, 0xfe, 0xf8, 0x0, 0x0,
    0xe, 0xf2, 0xef, 0x4f, 0xf5, 0x0, 0x0, 0xef,
    0x2e, 0xf1, 0x5f, 0xf3, 0x0, 0xe, 0xf2, 0xef,
    0x10, 0x8f, 0xd1, 0x0, 0xef, 0x2e, 0xf1, 0x0,
    0xbf, 0xb0, 0xe, 0xf2, 0xef, 0x10, 0x1, 0xdf,
    0x90, 0xef, 0x2e, 0xf1, 0x0, 0x2, 0xff, 0x5e,
    0xf2, 0xef, 0x10, 0x0, 0x5, 0xff, 0xff, 0x2e,
    0xf1, 0x0, 0x0, 0x8, 0xff, 0xf2, 0xef, 0x10,
    0x0, 0x0, 0xb, 0xff, 0x2e, 0xf1, 0x0, 0x0,
    0x0, 0x1d, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x52, 0x0,
    0x0, 0x0,

    /* U+0146 "ņ" */
    0x3f, 0xa2, 0x9e, 0xfe, 0x80, 0x3, 0xfc, 0xff,
    0xdd, 0xff, 0xd0, 0x3f, 0xfc, 0x10, 0x2, 0xdf,
    0x73, 0xff, 0x20, 0x0, 0x5, 0xfb, 0x3f, 0xc0,
    0x0, 0x0, 0x1f, 0xd3, 0xfb, 0x0, 0x0, 0x0,
    0xfe, 0x3f, 0xb0, 0x0, 0x0, 0xf, 0xe3, 0xfb,
    0x0, 0x0, 0x0, 0xfe, 0x3f, 0xb0, 0x0, 0x0,
    0xf, 0xe3, 0xfb, 0x0, 0x0, 0x0, 0xfe, 0x3f,
    0xb0, 0x0, 0x0, 0xf, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xea, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0xb6, 0x0, 0x0,
    0x0, 0x0, 0x7, 0x0, 0x0, 0x0,

    /* U+0147 "Ň" */
    0x0, 0x1d, 0xc1, 0xa, 0xe3, 0x0, 0x0, 0x0,
    0x1d, 0xed, 0xe2, 0x0, 0x0, 0x0, 0x0, 0x17,
    0x82, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xef, 0x20, 0x0, 0x0, 0x0, 0xef,
    0x2e, 0xfd, 0x10, 0x0, 0x0, 0xe, 0xf2, 0xef,
    0xfb, 0x0, 0x0, 0x0, 0xef, 0x2e, 0xfe, 0xf8,
    0x0, 0x0, 0xe, 0xf2, 0xef, 0x4f, 0xf5, 0x0,
    0x0, 0xef, 0x2e, 0xf1, 0x5f, 0xf3, 0x0, 0xe,
    0xf2, 0xef, 0x10, 0x8f, 0xd1, 0x0, 0xef, 0x2e,
    0xf1, 0x0, 0xbf, 0xb0, 0xe, 0xf2, 0xef, 0x10,
    0x1, 0xdf, 0x90, 0xef, 0x2e, 0xf1, 0x0, 0x2,
    0xff, 0x5e, 0xf2, 0xef, 0x10, 0x0, 0x5, 0xff,
    0xff, 0x2e, 0xf1, 0x0, 0x0, 0x8, 0xff, 0xf2,
    0xef, 0x10, 0x0, 0x0, 0xb, 0xff, 0x2e, 0xf1,
    0x0, 0x0, 0x0, 0x1d, 0xf2,

    /* U+0148 "ň" */
    0x0, 0x4f, 0x90, 0x1c, 0xd1, 0x0, 0x0, 0x3f,
    0xce, 0xc1, 0x0, 0x0, 0x0, 0x39, 0x81, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xa2,
    0x9e, 0xfe, 0x80, 0x3, 0xfc, 0xff, 0xdd, 0xff,
    0xd0, 0x3f, 0xfc, 0x10, 0x2, 0xdf, 0x73, 0xff,
    0x20, 0x0, 0x5, 0xfb, 0x3f, 0xc0, 0x0, 0x0,
    0x1f, 0xd3, 0xfb, 0x0, 0x0, 0x0, 0xfe, 0x3f,
    0xb0, 0x0, 0x0, 0xf, 0xe3, 0xfb, 0x0, 0x0,
    0x0, 0xfe, 0x3f, 0xb0, 0x0, 0x0, 0xf, 0xe3,
    0xfb, 0x0, 0x0, 0x0, 0xfe, 0x3f, 0xb0, 0x0,
    0x0, 0xf, 0xe0,

    /* U+0149 "ŉ" */
    0x9f, 0x40, 0x0, 0x0, 0x0, 0x0, 0xe, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9c, 0x4f, 0x92, 0xae, 0xfd, 0x80,
    0x9, 0x54, 0xfc, 0xff, 0xcd, 0xff, 0xc0, 0x0,
    0x4f, 0xfc, 0x10, 0x2, 0xef, 0x60, 0x4, 0xff,
    0x10, 0x0, 0x5, 0xfa, 0x0, 0x4f, 0xb0, 0x0,
    0x0, 0x2f, 0xc0, 0x4, 0xfa, 0x0, 0x0, 0x1,
    0xfd, 0x0, 0x4f, 0xa0, 0x0, 0x0, 0x1f, 0xd0,
    0x4, 0xfa, 0x0, 0x0, 0x1, 0xfd, 0x0, 0x4f,
    0xa0, 0x0, 0x0, 0x1f, 0xd0, 0x4, 0xfa, 0x0,
    0x0, 0x1, 0xfd, 0x0, 0x4f, 0xa0, 0x0, 0x0,
    0x1f, 0xd0,

    /* U+014A "Ŋ" */
    0xef, 0x20, 0x0, 0x0, 0x0, 0xdf, 0x2e, 0xfd,
    0x10, 0x0, 0x0, 0xd, 0xf2, 0xef, 0xfb, 0x0,
    0x0, 0x0, 0xdf, 0x2e, 0xfe, 0xf8, 0x0, 0x0,
    0xd, 0xf2, 0xef, 0x4f, 0xf5, 0x0, 0x0, 0xdf,
    0x2e, 0xf1, 0x5f, 0xf3, 0x0, 0xd, 0xf2, 0xef,
    0x10, 0x8f, 0xe1, 0x0, 0xdf, 0x2e, 0xf1, 0x0,
    0xbf, 0xc0, 0xd, 0xf2, 0xef, 0x10, 0x1, 0xdf,
    0x90, 0xdf, 0x2e, 0xf1, 0x0, 0x2, 0xff, 0x6d,
    0xf2, 0xef, 0x10, 0x0, 0x5, 0xff, 0xff, 0x2e,
    0xf1, 0x0, 0x0, 0x8, 0xff, 0xf2, 0xef, 0x10,
    0x0, 0x0, 0xb, 0xff, 0x2e, 0xf1, 0x0, 0x0,
    0x0, 0xf, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x0, 0x0, 0x3, 0xb1, 0x0, 0x8f, 0xc0,
    0x0, 0x0, 0x8f, 0xfc, 0xef, 0xf4, 0x0, 0x0,
    0x0, 0x6c, 0xff, 0xb3, 0x0,

    /* U+014B "ŋ" */
    0x3f, 0xa2, 0x9e, 0xfe, 0x91, 0x3, 0xfc, 0xff,
    0xdd, 0xff, 0xd0, 0x3f, 0xfc, 0x20, 0x2, 0xdf,
    0x73, 0xff, 0x20, 0x0, 0x4, 0xfc, 0x3f, 0xd0,
    0x0, 0x0, 0x1f, 0xe3, 0xfb, 0x0, 0x0, 0x0,
    0xfe, 0x3f, 0xb0, 0x0, 0x0, 0xf, 0xe3, 0xfb,
    0x0, 0x0, 0x0, 0xfe, 0x3f, 0xb0, 0x0, 0x0,
    0xf, 0xe3, 0xfb, 0x0, 0x0, 0x0, 0xfe, 0x3f,
    0xb0, 0x0, 0x0, 0xf, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xb0,
    0x0, 0x0, 0x7d, 0xbf, 0xf5, 0x0, 0x0, 0x6,
    0xdf, 0xd6, 0x0,

    /* U+014C "Ō" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xff, 0xff, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0x2, 0x33, 0x33, 0x32, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x17, 0xce, 0xfe, 0xb6, 0x0, 0x0,
    0x0, 0x5, 0xff, 0xfe, 0xdf, 0xff, 0xd3, 0x0,
    0x0, 0x5f, 0xf9, 0x20, 0x0, 0x3b, 0xff, 0x30,
    0x2, 0xff, 0x50, 0x0, 0x0, 0x0, 0x9f, 0xd0,
    0x9, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf5,
    0xe, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfa,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfc,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfc,
    0xe, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfa,
    0x9, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf5,
    0x2, 0xff, 0x50, 0x0, 0x0, 0x0, 0x9f, 0xd0,
    0x0, 0x5f, 0xf9, 0x20, 0x0, 0x3b, 0xff, 0x30,
    0x0, 0x5, 0xff, 0xfe, 0xdf, 0xff, 0xd3, 0x0,
    0x0, 0x0, 0x17, 0xce, 0xfe, 0xb6, 0x0, 0x0,

    /* U+014D "ō" */
    0x0, 0xf, 0xff, 0xff, 0xf9, 0x0, 0x0, 0x3,
    0x33, 0x33, 0x32, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xbe, 0xfd, 0x81, 0x0,
    0x0, 0x8f, 0xfd, 0xce, 0xfe, 0x30, 0x5, 0xfe,
    0x40, 0x0, 0x7f, 0xe1, 0xd, 0xf4, 0x0, 0x0,
    0x9, 0xf7, 0x1f, 0xe0, 0x0, 0x0, 0x3, 0xfb,
    0x2f, 0xc0, 0x0, 0x0, 0x1, 0xfd, 0x1f, 0xe0,
    0x0, 0x0, 0x3, 0xfb, 0xc, 0xf4, 0x0, 0x0,
    0x9, 0xf7, 0x5, 0xfe, 0x40, 0x0, 0x7f, 0xe1,
    0x0, 0x7f, 0xfd, 0xce, 0xfe, 0x30, 0x0, 0x4,
    0xbe, 0xfd, 0x91, 0x0,

    /* U+014E "Ŏ" */
    0x0, 0x0, 0x6, 0x40, 0x0, 0x54, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xd2, 0x4, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0xff, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x17, 0xce, 0xfe, 0xb6, 0x0, 0x0,
    0x0, 0x5, 0xff, 0xfe, 0xdf, 0xff, 0xd3, 0x0,
    0x0, 0x5f, 0xf9, 0x20, 0x0, 0x3b, 0xff, 0x30,
    0x2, 0xff, 0x50, 0x0, 0x0, 0x0, 0x9f, 0xd0,
    0x9, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf5,
    0xe, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfa,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfc,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfc,
    0xe, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfa,
    0x9, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf5,
    0x2, 0xff, 0x50, 0x0, 0x0, 0x0, 0x9f, 0xd0,
    0x0, 0x5f, 0xf9, 0x20, 0x0, 0x3b, 0xff, 0x30,
    0x0, 0x5, 0xff, 0xfe, 0xdf, 0xff, 0xd3, 0x0,
    0x0, 0x0, 0x17, 0xce, 0xfe, 0xb6, 0x0, 0x0,

    /* U+014F "ŏ" */
    0x0, 0xc, 0xb1, 0x3, 0xe6, 0x0, 0x0, 0x2,
    0xcf, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xbe, 0xfd, 0x81, 0x0, 0x0, 0x8f,
    0xfd, 0xce, 0xfe, 0x30, 0x5, 0xfe, 0x40, 0x0,
    0x7f, 0xe1, 0xd, 0xf4, 0x0, 0x0, 0x9, 0xf7,
    0x1f, 0xe0, 0x0, 0x0, 0x3, 0xfb, 0x2f, 0xc0,
    0x0, 0x0, 0x1, 0xfd, 0x1f, 0xe0, 0x0, 0x0,
    0x3, 0xfb, 0xc, 0xf4, 0x0, 0x0, 0x9, 0xf7,
    0x5, 0xfe, 0x40, 0x0, 0x7f, 0xe1, 0x0, 0x7f,
    0xfd, 0xce, 0xfe, 0x30, 0x0, 0x4, 0xbe, 0xfd,
    0x91, 0x0,

    /* U+0150 "Ő" */
    0x0, 0x0, 0x0, 0x6, 0xa4, 0x1a, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0xb0, 0xaf, 0x30, 0x0,
    0x0, 0x0, 0x0, 0xcd, 0x5, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x17, 0xce, 0xfe, 0xb6, 0x0, 0x0,
    0x0, 0x5, 0xff, 0xfe, 0xdf, 0xff, 0xd3, 0x0,
    0x0, 0x5f, 0xf9, 0x20, 0x0, 0x3b, 0xff, 0x30,
    0x2, 0xff, 0x50, 0x0, 0x0, 0x0, 0x9f, 0xd0,
    0x9, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf5,
    0xe, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfa,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfc,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfc,
    0xe, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfa,
    0x9, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf5,
    0x2, 0xff, 0x50, 0x0, 0x0, 0x0, 0x9f, 0xd0,
    0x0, 0x5f, 0xf9, 0x20, 0x0, 0x3b, 0xff, 0x30,
    0x0, 0x5, 0xff, 0xfe, 0xdf, 0xff, 0xd3, 0x0,
    0x0, 0x0, 0x17, 0xce, 0xfe, 0xb6, 0x0, 0x0,

    /* U+0151 "ő" */
    0x0, 0x0, 0xc, 0xf3, 0x4f, 0xa0, 0x0, 0x0,
    0x7f, 0x50, 0xec, 0x0, 0x0, 0x0, 0xa7, 0x5,
    0xa1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xbe, 0xfd, 0x81, 0x0, 0x0, 0x8f,
    0xfd, 0xce, 0xfe, 0x30, 0x5, 0xfe, 0x40, 0x0,
    0x7f, 0xe1, 0xd, 0xf4, 0x0, 0x0, 0x9, 0xf7,
    0x1f, 0xe0, 0x0, 0x0, 0x3, 0xfb, 0x2f, 0xc0,
    0x0, 0x0, 0x1, 0xfd, 0x1f, 0xe0, 0x0, 0x0,
    0x3, 0xfb, 0xc, 0xf4, 0x0, 0x0, 0x9, 0xf7,
    0x5, 0xfe, 0x40, 0x0, 0x7f, 0xe1, 0x0, 0x7f,
    0xfd, 0xce, 0xfe, 0x30, 0x0, 0x4, 0xbe, 0xfd,
    0x91, 0x0,

    /* U+0152 "Œ" */
    0x0, 0x0, 0x17, 0xce, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf1, 0x0, 0x5, 0xff, 0xfe, 0xdc,
    0xcf, 0xfd, 0xcc, 0xcc, 0xcc, 0xc1, 0x0, 0x6f,
    0xf9, 0x20, 0x0, 0xc, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xff, 0x40, 0x0, 0x0, 0xc, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xf9, 0x0, 0x0,
    0x0, 0xc, 0xf3, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xf2, 0x0, 0x0, 0x0, 0xc, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0x0, 0xc,
    0xff, 0xff, 0xff, 0xff, 0x30, 0xf, 0xf0, 0x0,
    0x0, 0x0, 0xc, 0xfc, 0xcc, 0xcc, 0xcc, 0x20,
    0xd, 0xf2, 0x0, 0x0, 0x0, 0xc, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xf9, 0x0, 0x0, 0x0,
    0xc, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x2, 0xff,
    0x40, 0x0, 0x0, 0xc, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xf8, 0x20, 0x0, 0xc, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xff, 0xfe,
    0xcc, 0xcf, 0xfd, 0xcc, 0xcc, 0xcc, 0xc4, 0x0,
    0x0, 0x17, 0xce, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf6,

    /* U+0153 "œ" */
    0x0, 0x3, 0xae, 0xfd, 0x81, 0x0, 0x3a, 0xef,
    0xd7, 0x0, 0x0, 0x7, 0xff, 0xcb, 0xdf, 0xe2,
    0x5f, 0xfc, 0xbe, 0xfc, 0x0, 0x4, 0xfe, 0x30,
    0x0, 0x6f, 0xdf, 0xe3, 0x0, 0x9, 0xf9, 0x0,
    0xcf, 0x40, 0x0, 0x0, 0x9f, 0xf4, 0x0, 0x0,
    0xc, 0xf1, 0xf, 0xe0, 0x0, 0x0, 0x3, 0xff,
    0x11, 0x11, 0x11, 0x7f, 0x52, 0xfc, 0x0, 0x0,
    0x0, 0x1f, 0xff, 0xff, 0xff, 0xff, 0xf7, 0xf,
    0xe0, 0x0, 0x0, 0x3, 0xff, 0x44, 0x44, 0x44,
    0x44, 0x20, 0xcf, 0x50, 0x0, 0x0, 0x9f, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xfe, 0x40, 0x0,
    0x7f, 0xef, 0xe4, 0x0, 0x1, 0xa3, 0x0, 0x7,
    0xff, 0xec, 0xef, 0xe3, 0x5f, 0xfe, 0xcd, 0xff,
    0x70, 0x0, 0x3, 0xae, 0xfd, 0x81, 0x0, 0x29,
    0xdf, 0xeb, 0x40, 0x0,

    /* U+0154 "Ŕ" */
    0x0, 0x0, 0x4f, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0x30, 0x0, 0x0, 0x0, 0x0, 0x88, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xff, 0xff, 0xec, 0x70, 0x0, 0xef, 0xdc,
    0xcd, 0xef, 0xfd, 0x10, 0xef, 0x10, 0x0, 0x2,
    0xcf, 0xc0, 0xef, 0x10, 0x0, 0x0, 0x1e, 0xf2,
    0xef, 0x10, 0x0, 0x0, 0xb, 0xf5, 0xef, 0x10,
    0x0, 0x0, 0xb, 0xf4, 0xef, 0x10, 0x0, 0x0,
    0x2f, 0xf1, 0xef, 0x10, 0x0, 0x15, 0xef, 0x90,
    0xef, 0xff, 0xff, 0xff, 0xfa, 0x0, 0xef, 0xcc,
    0xcb, 0xdf, 0x90, 0x0, 0xef, 0x10, 0x0, 0x1e,
    0xf2, 0x0, 0xef, 0x10, 0x0, 0x5, 0xfd, 0x0,
    0xef, 0x10, 0x0, 0x0, 0x9f, 0x80, 0xef, 0x10,
    0x0, 0x0, 0xd, 0xf4,

    /* U+0155 "ŕ" */
    0x0, 0xf, 0xf1, 0x0, 0x5, 0xf7, 0x0, 0x0,
    0x6a, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xa2,
    0xae, 0x73, 0xfc, 0xff, 0xe6, 0x3f, 0xfd, 0x30,
    0x3, 0xff, 0x30, 0x0, 0x3f, 0xd0, 0x0, 0x3,
    0xfb, 0x0, 0x0, 0x3f, 0xb0, 0x0, 0x3, 0xfb,
    0x0, 0x0, 0x3f, 0xb0, 0x0, 0x3, 0xfb, 0x0,
    0x0, 0x3f, 0xb0, 0x0, 0x0,

    /* U+0156 "Ŗ" */
    0xef, 0xff, 0xff, 0xec, 0x70, 0x0, 0xef, 0xdc,
    0xcd, 0xef, 0xfd, 0x10, 0xef, 0x10, 0x0, 0x2,
    0xcf, 0xc0, 0xef, 0x10, 0x0, 0x0, 0x1e, 0xf2,
    0xef, 0x10, 0x0, 0x0, 0xb, 0xf5, 0xef, 0x10,
    0x0, 0x0, 0xb, 0xf4, 0xef, 0x10, 0x0, 0x0,
    0x2f, 0xf1, 0xef, 0x10, 0x0, 0x15, 0xef, 0x90,
    0xef, 0xff, 0xff, 0xff, 0xfa, 0x0, 0xef, 0xcc,
    0xcb, 0xdf, 0x90, 0x0, 0xef, 0x10, 0x0, 0x1e,
    0xf2, 0x0, 0xef, 0x10, 0x0, 0x5, 0xfd, 0x0,
    0xef, 0x10, 0x0, 0x0, 0x9f, 0x80, 0xef, 0x10,
    0x0, 0x0, 0xd, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0x40, 0x0, 0x0, 0x0, 0x0, 0x2e, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x24, 0x0, 0x0, 0x0,

    /* U+0157 "ŗ" */
    0x3f, 0xa2, 0xae, 0x73, 0xfc, 0xff, 0xe6, 0x3f,
    0xfd, 0x30, 0x3, 0xff, 0x30, 0x0, 0x3f, 0xd0,
    0x0, 0x3, 0xfb, 0x0, 0x0, 0x3f, 0xb0, 0x0,
    0x3, 0xfb, 0x0, 0x0, 0x3f, 0xb0, 0x0, 0x3,
    0xfb, 0x0, 0x0, 0x3f, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xe9, 0x0,
    0x0, 0x1e, 0xa0, 0x0, 0x0, 0xd4, 0x0, 0x0,
    0x7, 0x0, 0x0, 0x0,

    /* U+0158 "Ř" */
    0x0, 0xae, 0x40, 0x6f, 0x70, 0x0, 0x0, 0x9,
    0xfb, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x68, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xff, 0xff, 0xec, 0x70, 0x0, 0xef, 0xdc,
    0xcd, 0xef, 0xfd, 0x10, 0xef, 0x10, 0x0, 0x2,
    0xcf, 0xc0, 0xef, 0x10, 0x0, 0x0, 0x1e, 0xf2,
    0xef, 0x10, 0x0, 0x0, 0xb, 0xf5, 0xef, 0x10,
    0x0, 0x0, 0xb, 0xf4, 0xef, 0x10, 0x0, 0x0,
    0x2f, 0xf1, 0xef, 0x10, 0x0, 0x15, 0xef, 0x90,
    0xef, 0xff, 0xff, 0xff, 0xfa, 0x0, 0xef, 0xcc,
    0xcb, 0xdf, 0x90, 0x0, 0xef, 0x10, 0x0, 0x1e,
    0xf2, 0x0, 0xef, 0x10, 0x0, 0x5, 0xfd, 0x0,
    0xef, 0x10, 0x0, 0x0, 0x9f, 0x80, 0xef, 0x10,
    0x0, 0x0, 0xd, 0xf4,

    /* U+0159 "ř" */
    0x6f, 0x70, 0x3e, 0xa0, 0x5, 0xfb, 0xfa, 0x0,
    0x0, 0x48, 0x60, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xa2, 0xae, 0x70, 0x3f, 0xcf, 0xfe, 0x60,
    0x3f, 0xfd, 0x30, 0x0, 0x3f, 0xf3, 0x0, 0x0,
    0x3f, 0xd0, 0x0, 0x0, 0x3f, 0xb0, 0x0, 0x0,
    0x3f, 0xb0, 0x0, 0x0, 0x3f, 0xb0, 0x0, 0x0,
    0x3f, 0xb0, 0x0, 0x0, 0x3f, 0xb0, 0x0, 0x0,
    0x3f, 0xb0, 0x0, 0x0,

    /* U+015A "Ś" */
    0x0, 0x0, 0x1, 0xa9, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xf7, 0x0, 0x0, 0x0, 0x0, 0xc, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xce, 0xfe, 0xc7, 0x10, 0x1, 0xcf, 0xfd, 0xcd,
    0xff, 0xd0, 0x8, 0xfb, 0x10, 0x0, 0x6, 0x60,
    0xc, 0xf2, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xfe, 0x61, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0xff, 0xc8, 0x40, 0x0,
    0x0, 0x1, 0x6b, 0xff, 0xfd, 0x40, 0x0, 0x0,
    0x0, 0x3, 0x9f, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xf7, 0x1, 0x0, 0x0, 0x0, 0x7, 0xf8,
    0xd, 0xb3, 0x0, 0x0, 0x3e, 0xf4, 0xb, 0xff,
    0xfc, 0xcd, 0xff, 0x90, 0x0, 0x39, 0xdf, 0xfe,
    0xa4, 0x0,

    /* U+015B "ś" */
    0x0, 0x0, 0xbf, 0x50, 0x0, 0x0, 0x0, 0xfc,
    0x0, 0x0, 0x0, 0x3, 0xa3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6c, 0xff, 0xea,
    0x50, 0x9, 0xff, 0xcb, 0xdf, 0xc0, 0x1f, 0xe1,
    0x0, 0x2, 0x30, 0x2f, 0xc0, 0x0, 0x0, 0x0,
    0xe, 0xfc, 0x63, 0x0, 0x0, 0x2, 0xbf, 0xff,
    0xfb, 0x30, 0x0, 0x1, 0x47, 0xcf, 0xf1, 0x0,
    0x0, 0x0, 0x9, 0xf6, 0x9, 0x30, 0x0, 0xc,
    0xf4, 0x5f, 0xfe, 0xbb, 0xef, 0xc0, 0x5, 0xae,
    0xff, 0xc7, 0x0,

    /* U+015C "Ŝ" */
    0x0, 0x0, 0x5, 0x84, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xef, 0x40, 0x0, 0x0, 0x4, 0xf9, 0xb,
    0xf2, 0x0, 0x0, 0x7, 0x60, 0x0, 0x76, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xce, 0xfe, 0xc7, 0x10, 0x1, 0xcf, 0xfd, 0xcd,
    0xff, 0xd0, 0x8, 0xfb, 0x10, 0x0, 0x6, 0x60,
    0xc, 0xf2, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xfe, 0x61, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0xff, 0xc8, 0x40, 0x0,
    0x0, 0x1, 0x6b, 0xff, 0xfd, 0x40, 0x0, 0x0,
    0x0, 0x3, 0x9f, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xf7, 0x1, 0x0, 0x0, 0x0, 0x7, 0xf8,
    0xd, 0xb3, 0x0, 0x0, 0x3e, 0xf4, 0xb, 0xff,
    0xfc, 0xcd, 0xff, 0x90, 0x0, 0x39, 0xdf, 0xfe,
    0xa4, 0x0,

    /* U+015D "ŝ" */
    0x0, 0x7, 0xff, 0x60, 0x0, 0x0, 0x8f, 0x68,
    0xf6, 0x0, 0x3, 0x94, 0x0, 0x59, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6c, 0xff, 0xea,
    0x50, 0x9, 0xff, 0xcb, 0xdf, 0xc0, 0x1f, 0xe1,
    0x0, 0x2, 0x30, 0x2f, 0xc0, 0x0, 0x0, 0x0,
    0xe, 0xfc, 0x63, 0x0, 0x0, 0x2, 0xbf, 0xff,
    0xfb, 0x30, 0x0, 0x1, 0x47, 0xcf, 0xf1, 0x0,
    0x0, 0x0, 0x9, 0xf6, 0x9, 0x30, 0x0, 0xc,
    0xf4, 0x5f, 0xfe, 0xbb, 0xef, 0xc0, 0x5, 0xae,
    0xff, 0xc7, 0x0,

    /* U+015E "Ş" */
    0x0, 0x7, 0xce, 0xfe, 0xc7, 0x10, 0x1, 0xcf,
    0xfd, 0xcd, 0xff, 0xd0, 0x8, 0xfb, 0x10, 0x0,
    0x6, 0x60, 0xc, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x7, 0xfe,
    0x61, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xc8,
    0x40, 0x0, 0x0, 0x1, 0x6b, 0xff, 0xfd, 0x40,
    0x0, 0x0, 0x0, 0x3, 0x9f, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xf7, 0x1, 0x0, 0x0, 0x0,
    0x7, 0xf8, 0xd, 0xb3, 0x0, 0x0, 0x3e, 0xf4,
    0xb, 0xff, 0xfc, 0xcd, 0xff, 0x90, 0x0, 0x39,
    0xdf, 0xfe, 0xa4, 0x0, 0x0, 0x0, 0x5, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xbe, 0x20, 0x0,
    0x0, 0x0, 0x10, 0x1f, 0x50, 0x0, 0x0, 0x0,
    0xaf, 0xfc, 0x10, 0x0, 0x0, 0x0, 0x1, 0x10,
    0x0, 0x0,

    /* U+015F "ş" */
    0x0, 0x6c, 0xff, 0xea, 0x50, 0x9, 0xff, 0xcb,
    0xdf, 0xc0, 0x1f, 0xe1, 0x0, 0x2, 0x30, 0x2f,
    0xc0, 0x0, 0x0, 0x0, 0xe, 0xfc, 0x63, 0x0,
    0x0, 0x2, 0xbf, 0xff, 0xfb, 0x30, 0x0, 0x1,
    0x47, 0xcf, 0xf1, 0x0, 0x0, 0x0, 0x9, 0xf6,
    0x9, 0x30, 0x0, 0xc, 0xf4, 0x5f, 0xfe, 0xbb,
    0xef, 0xc0, 0x5, 0xae, 0xff, 0xc7, 0x0, 0x0,
    0x0, 0xd5, 0x0, 0x0, 0x0, 0x0, 0x9e, 0x80,
    0x0, 0x0, 0x1, 0x9, 0xe0, 0x0, 0x0, 0x2f,
    0xff, 0x60, 0x0, 0x0, 0x0, 0x10, 0x0, 0x0,

    /* U+0160 "Š" */
    0x0, 0x7, 0x60, 0x0, 0x76, 0x0, 0x0, 0x4,
    0xf9, 0xb, 0xf2, 0x0, 0x0, 0x0, 0x6f, 0xef,
    0x40, 0x0, 0x0, 0x0, 0x5, 0x84, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xce, 0xfe, 0xc7, 0x10, 0x1, 0xcf, 0xfd, 0xcd,
    0xff, 0xd0, 0x8, 0xfb, 0x10, 0x0, 0x6, 0x60,
    0xc, 0xf2, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xfe, 0x61, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0xff, 0xc8, 0x40, 0x0,
    0x0, 0x1, 0x6b, 0xff, 0xfd, 0x40, 0x0, 0x0,
    0x0, 0x3, 0x9f, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x9, 0xf7, 0x1, 0x0, 0x0, 0x0, 0x7, 0xf8,
    0xd, 0xb3, 0x0, 0x0, 0x3e, 0xf4, 0xb, 0xff,
    0xfc, 0xcd, 0xff, 0x90, 0x0, 0x39, 0xdf, 0xfe,
    0xa4, 0x0,

    /* U+0161 "š" */
    0x3, 0xea, 0x1, 0xcd, 0x20, 0x0, 0x2e, 0xde,
    0xd1, 0x0, 0x0, 0x2, 0x99, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6c, 0xff, 0xea,
    0x50, 0x9, 0xff, 0xcb, 0xdf, 0xc0, 0x1f, 0xe1,
    0x0, 0x2, 0x30, 0x2f, 0xc0, 0x0, 0x0, 0x0,
    0xe, 0xfc, 0x63, 0x0, 0x0, 0x2, 0xbf, 0xff,
    0xfb, 0x30, 0x0, 0x1, 0x47, 0xcf, 0xf1, 0x0,
    0x0, 0x0, 0x9, 0xf6, 0x9, 0x30, 0x0, 0xc,
    0xf4, 0x5f, 0xfe, 0xbb, 0xef, 0xc0, 0x5, 0xae,
    0xff, 0xc7, 0x0,

    /* U+0162 "Ţ" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xbc, 0xcc,
    0xdf, 0xfc, 0xcc, 0xc8, 0x0, 0x0, 0x2f, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xe, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x1a, 0xe6, 0x0, 0x0,
    0x0, 0x0, 0x10, 0xac, 0x0, 0x0, 0x0, 0x3,
    0xff, 0xe5, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0,
    0x0, 0x0,

    /* U+0163 "ţ" */
    0x0, 0x78, 0x0, 0x0, 0x0, 0xef, 0x0, 0x0,
    0x0, 0xef, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xf1,
    0x7a, 0xff, 0xaa, 0xa0, 0x0, 0xef, 0x0, 0x0,
    0x0, 0xef, 0x0, 0x0, 0x0, 0xef, 0x0, 0x0,
    0x0, 0xef, 0x0, 0x0, 0x0, 0xef, 0x0, 0x0,
    0x0, 0xef, 0x0, 0x0, 0x0, 0xcf, 0x40, 0x0,
    0x0, 0x6f, 0xfb, 0xd7, 0x0, 0x7, 0xff, 0xd5,
    0x0, 0x0, 0xb7, 0x0, 0x0, 0x0, 0x8d, 0xa0,
    0x0, 0x1, 0x7, 0xf0, 0x0, 0x1f, 0xff, 0x70,
    0x0, 0x0, 0x10, 0x0,

    /* U+0164 "Ť" */
    0x0, 0x4f, 0x90, 0x2c, 0xc1, 0x0, 0x0, 0x3,
    0xec, 0xec, 0x0, 0x0, 0x0, 0x0, 0x28, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xbc, 0xcc,
    0xdf, 0xfc, 0xcc, 0xc8, 0x0, 0x0, 0x2f, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xd0, 0x0, 0x0,

    /* U+0165 "ť" */
    0x0, 0x0, 0x5, 0xf2, 0x0, 0x0, 0x5, 0xf1,
    0x0, 0x89, 0x5, 0xf0, 0x0, 0xef, 0x2, 0x70,
    0xbf, 0xff, 0xff, 0xf1, 0x7a, 0xff, 0xaa, 0xa0,
    0x0, 0xef, 0x0, 0x0, 0x0, 0xef, 0x0, 0x0,
    0x0, 0xef, 0x0, 0x0, 0x0, 0xef, 0x0, 0x0,
    0x0, 0xef, 0x0, 0x0, 0x0, 0xef, 0x0, 0x0,
    0x0, 0xcf, 0x40, 0x0, 0x0, 0x6f, 0xfb, 0xd7,
    0x0, 0x7, 0xdf, 0xd5,

    /* U+0166 "Ŧ" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xbc, 0xcc,
    0xdf, 0xfc, 0xcc, 0xc8, 0x0, 0x0, 0x2f, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xd0, 0x0, 0x0, 0x1, 0xaa, 0xcf, 0xfa,
    0xa8, 0x0, 0x2, 0xff, 0xff, 0xff, 0xfd, 0x0,
    0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xd0, 0x0, 0x0,

    /* U+0167 "ŧ" */
    0x0, 0x68, 0x0, 0x0, 0x0, 0xdf, 0x10, 0x0,
    0x0, 0xdf, 0x10, 0x0, 0xaf, 0xff, 0xff, 0xf2,
    0x6a, 0xef, 0xaa, 0xa1, 0x0, 0xdf, 0x10, 0x0,
    0x1, 0xef, 0x31, 0x10, 0x6f, 0xff, 0xff, 0xe0,
    0x14, 0xff, 0x64, 0x40, 0x0, 0xdf, 0x10, 0x0,
    0x0, 0xcf, 0x10, 0x0, 0x0, 0xaf, 0x50, 0x0,
    0x0, 0x5f, 0xfb, 0xd8, 0x0, 0x6, 0xdf, 0xd6,

    /* U+0168 "Ũ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xfc, 0x31, 0xf2, 0x0, 0x0, 0x5, 0xd1,
    0x6f, 0xfa, 0x0, 0x0, 0x0, 0x11, 0x0, 0x2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0x0, 0x0, 0x0, 0x2, 0xfd, 0xf,
    0xf0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0xff, 0x0,
    0x0, 0x0, 0x2, 0xfd, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x2f, 0xd0, 0xff, 0x0, 0x0, 0x0, 0x2,
    0xfd, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0xff, 0x0, 0x0, 0x0, 0x2, 0xfd, 0xf, 0xf0,
    0x0, 0x0, 0x0, 0x2f, 0xc0, 0xff, 0x0, 0x0,
    0x0, 0x3, 0xfc, 0xe, 0xf2, 0x0, 0x0, 0x0,
    0x5f, 0xa0, 0xaf, 0x90, 0x0, 0x0, 0xc, 0xf6,
    0x2, 0xff, 0x80, 0x0, 0x1a, 0xfe, 0x0, 0x5,
    0xff, 0xfd, 0xef, 0xfe, 0x30, 0x0, 0x2, 0x9d,
    0xff, 0xd8, 0x10, 0x0,

    /* U+0169 "ũ" */
    0x0, 0x1c, 0xfa, 0x25, 0xf0, 0x0, 0x8, 0xc4,
    0xaf, 0xf8, 0x0, 0x0, 0x21, 0x0, 0x11, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xa0,
    0x0, 0x0, 0x3f, 0xb4, 0xfa, 0x0, 0x0, 0x3,
    0xfb, 0x4f, 0xa0, 0x0, 0x0, 0x3f, 0xb4, 0xfa,
    0x0, 0x0, 0x3, 0xfb, 0x4f, 0xa0, 0x0, 0x0,
    0x3f, 0xb4, 0xfa, 0x0, 0x0, 0x3, 0xfb, 0x4f,
    0xa0, 0x0, 0x0, 0x5f, 0xb2, 0xfd, 0x0, 0x0,
    0xa, 0xfb, 0xe, 0xf8, 0x0, 0x6, 0xff, 0xb0,
    0x4f, 0xfe, 0xce, 0xfb, 0xfb, 0x0, 0x3b, 0xef,
    0xd6, 0x2f, 0xb0,

    /* U+016A "Ū" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xff, 0xff, 0xf2, 0x0, 0x0, 0x1, 0x33,
    0x33, 0x33, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0x0, 0x0, 0x0, 0x2, 0xfd, 0xf,
    0xf0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0xff, 0x0,
    0x0, 0x0, 0x2, 0xfd, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x2f, 0xd0, 0xff, 0x0, 0x0, 0x0, 0x2,
    0xfd, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0xff, 0x0, 0x0, 0x0, 0x2, 0xfd, 0xf, 0xf0,
    0x0, 0x0, 0x0, 0x2f, 0xc0, 0xff, 0x0, 0x0,
    0x0, 0x3, 0xfc, 0xe, 0xf2, 0x0, 0x0, 0x0,
    0x5f, 0xa0, 0xaf, 0x90, 0x0, 0x0, 0xc, 0xf6,
    0x2, 0xff, 0x80, 0x0, 0x1a, 0xfe, 0x0, 0x5,
    0xff, 0xfd, 0xef, 0xfe, 0x30, 0x0, 0x2, 0x9d,
    0xff, 0xd8, 0x10, 0x0,

    /* U+016B "ū" */
    0x0, 0x9f, 0xff, 0xff, 0xf0, 0x0, 0x1, 0x33,
    0x33, 0x33, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xfa, 0x0, 0x0, 0x3, 0xfb, 0x4f, 0xa0,
    0x0, 0x0, 0x3f, 0xb4, 0xfa, 0x0, 0x0, 0x3,
    0xfb, 0x4f, 0xa0, 0x0, 0x0, 0x3f, 0xb4, 0xfa,
    0x0, 0x0, 0x3, 0xfb, 0x4f, 0xa0, 0x0, 0x0,
    0x3f, 0xb4, 0xfa, 0x0, 0x0, 0x5, 0xfb, 0x2f,
    0xd0, 0x0, 0x0, 0xaf, 0xb0, 0xef, 0x80, 0x0,
    0x6f, 0xfb, 0x4, 0xff, 0xec, 0xef, 0xbf, 0xb0,
    0x3, 0xbe, 0xfd, 0x62, 0xfb,

    /* U+016C "Ŭ" */
    0x0, 0x2, 0x70, 0x0, 0x18, 0x0, 0x0, 0x0,
    0x1f, 0x80, 0x1a, 0xd0, 0x0, 0x0, 0x0, 0x4d,
    0xff, 0xc2, 0x0, 0x0, 0x0, 0x0, 0x1, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0x0, 0x0, 0x0, 0x2, 0xfd, 0xf,
    0xf0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0xff, 0x0,
    0x0, 0x0, 0x2, 0xfd, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x2f, 0xd0, 0xff, 0x0, 0x0, 0x0, 0x2,
    0xfd, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0xff, 0x0, 0x0, 0x0, 0x2, 0xfd, 0xf, 0xf0,
    0x0, 0x0, 0x0, 0x2f, 0xc0, 0xff, 0x0, 0x0,
    0x0, 0x3, 0xfc, 0xe, 0xf2, 0x0, 0x0, 0x0,
    0x5f, 0xa0, 0xaf, 0x90, 0x0, 0x0, 0xc, 0xf6,
    0x2, 0xff, 0x80, 0x0, 0x1a, 0xfe, 0x0, 0x5,
    0xff, 0xfd, 0xef, 0xfe, 0x30, 0x0, 0x2, 0x9d,
    0xff, 0xd8, 0x10, 0x0,

    /* U+016D "ŭ" */
    0x0, 0x6e, 0x30, 0x1a, 0xc0, 0x0, 0x0, 0x8f,
    0xff, 0xc2, 0x0, 0x0, 0x0, 0x1, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xa0,
    0x0, 0x0, 0x3f, 0xb4, 0xfa, 0x0, 0x0, 0x3,
    0xfb, 0x4f, 0xa0, 0x0, 0x0, 0x3f, 0xb4, 0xfa,
    0x0, 0x0, 0x3, 0xfb, 0x4f, 0xa0, 0x0, 0x0,
    0x3f, 0xb4, 0xfa, 0x0, 0x0, 0x3, 0xfb, 0x4f,
    0xa0, 0x0, 0x0, 0x5f, 0xb2, 0xfd, 0x0, 0x0,
    0xa, 0xfb, 0xe, 0xf8, 0x0, 0x6, 0xff, 0xb0,
    0x4f, 0xfe, 0xce, 0xfb, 0xfb, 0x0, 0x3b, 0xef,
    0xd6, 0x2f, 0xb0,

    /* U+016E "Ů" */
    0x0, 0x0, 0x6, 0xdd, 0x30, 0x0, 0x0, 0x0,
    0x3, 0xc0, 0x1e, 0x0, 0x0, 0x0, 0x0, 0x3c,
    0x1, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x6d, 0xc4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xf0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0xff, 0x0,
    0x0, 0x0, 0x2, 0xfd, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x2f, 0xd0, 0xff, 0x0, 0x0, 0x0, 0x2,
    0xfd, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0xff, 0x0, 0x0, 0x0, 0x2, 0xfd, 0xf, 0xf0,
    0x0, 0x0, 0x0, 0x2f, 0xd0, 0xff, 0x0, 0x0,
    0x0, 0x2, 0xfc, 0xf, 0xf0, 0x0, 0x0, 0x0,
    0x3f, 0xc0, 0xef, 0x20, 0x0, 0x0, 0x5, 0xfa,
    0xa, 0xf9, 0x0, 0x0, 0x0, 0xcf, 0x60, 0x2f,
    0xf8, 0x0, 0x1, 0xaf, 0xe0, 0x0, 0x5f, 0xff,
    0xde, 0xff, 0xe3, 0x0, 0x0, 0x29, 0xdf, 0xfd,
    0x81, 0x0,

    /* U+016F "ů" */
    0x0, 0x0, 0x7e, 0xb1, 0x0, 0x0, 0x0, 0x4b,
    0x5, 0xa0, 0x0, 0x0, 0x7, 0x60, 0xe, 0x0,
    0x0, 0x0, 0x4b, 0x5, 0xa0, 0x0, 0x0, 0x0,
    0x7d, 0xb1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0xa0, 0x0, 0x0, 0x3f, 0xb4, 0xfa,
    0x0, 0x0, 0x3, 0xfb, 0x4f, 0xa0, 0x0, 0x0,
    0x3f, 0xb4, 0xfa, 0x0, 0x0, 0x3, 0xfb, 0x4f,
    0xa0, 0x0, 0x0, 0x3f, 0xb4, 0xfa, 0x0, 0x0,
    0x3, 0xfb, 0x4f, 0xa0, 0x0, 0x0, 0x5f, 0xb2,
    0xfd, 0x0, 0x0, 0xa, 0xfb, 0xe, 0xf8, 0x0,
    0x6, 0xff, 0xb0, 0x4f, 0xfe, 0xce, 0xfb, 0xfb,
    0x0, 0x3b, 0xef, 0xd6, 0x2f, 0xb0,

    /* U+0170 "Ű" */
    0x0, 0x0, 0x1, 0xa9, 0x6, 0xa3, 0x0, 0x0,
    0x0, 0xaf, 0x32, 0xfa, 0x0, 0x0, 0x0, 0x5f,
    0x50, 0xcd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0x0, 0x0, 0x0, 0x2, 0xfd, 0xf,
    0xf0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0xff, 0x0,
    0x0, 0x0, 0x2, 0xfd, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x2f, 0xd0, 0xff, 0x0, 0x0, 0x0, 0x2,
    0xfd, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0xff, 0x0, 0x0, 0x0, 0x2, 0xfd, 0xf, 0xf0,
    0x0, 0x0, 0x0, 0x2f, 0xc0, 0xff, 0x0, 0x0,
    0x0, 0x3, 0xfc, 0xe, 0xf2, 0x0, 0x0, 0x0,
    0x5f, 0xa0, 0xaf, 0x90, 0x0, 0x0, 0xc, 0xf6,
    0x2, 0xff, 0x80, 0x0, 0x1a, 0xfe, 0x0, 0x5,
    0xff, 0xfd, 0xef, 0xfe, 0x30, 0x0, 0x2, 0x9d,
    0xff, 0xd8, 0x10, 0x0,

    /* U+0171 "ű" */
    0x0, 0x0, 0x6f, 0x90, 0xde, 0x10, 0x0, 0x1f,
    0xb0, 0x9f, 0x30, 0x0, 0x6, 0xa1, 0x1a, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xa0,
    0x0, 0x0, 0x3f, 0xb4, 0xfa, 0x0, 0x0, 0x3,
    0xfb, 0x4f, 0xa0, 0x0, 0x0, 0x3f, 0xb4, 0xfa,
    0x0, 0x0, 0x3, 0xfb, 0x4f, 0xa0, 0x0, 0x0,
    0x3f, 0xb4, 0xfa, 0x0, 0x0, 0x3, 0xfb, 0x4f,
    0xa0, 0x0, 0x0, 0x5f, 0xb2, 0xfd, 0x0, 0x0,
    0xa, 0xfb, 0xe, 0xf8, 0x0, 0x6, 0xff, 0xb0,
    0x4f, 0xfe, 0xce, 0xfb, 0xfb, 0x0, 0x3b, 0xef,
    0xd6, 0x2f, 0xb0,

    /* U+0172 "Ų" */
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0xff,
    0x0, 0x0, 0x0, 0x2, 0xfd, 0xf, 0xf0, 0x0,
    0x0, 0x0, 0x2f, 0xd0, 0xff, 0x0, 0x0, 0x0,
    0x2, 0xfd, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x2f,
    0xd0, 0xff, 0x0, 0x0, 0x0, 0x2, 0xfd, 0xf,
    0xf0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0xff, 0x0,
    0x0, 0x0, 0x2, 0xfd, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x2f, 0xc0, 0xef, 0x20, 0x0, 0x0, 0x5,
    0xfa, 0xa, 0xf9, 0x0, 0x0, 0x0, 0xbf, 0x50,
    0x3f, 0xf7, 0x0, 0x0, 0x8f, 0xd0, 0x0, 0x7f,
    0xff, 0xcc, 0xff, 0xd1, 0x0, 0x0, 0x4b, 0xef,
    0xfd, 0x60, 0x0, 0x0, 0x0, 0x4, 0xe5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xe7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0x80, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x7f, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0x0, 0x0, 0x0,

    /* U+0173 "ų" */
    0x4f, 0xa0, 0x0, 0x0, 0x3f, 0xb0, 0x4f, 0xa0,
    0x0, 0x0, 0x3f, 0xb0, 0x4f, 0xa0, 0x0, 0x0,
    0x3f, 0xb0, 0x4f, 0xa0, 0x0, 0x0, 0x3f, 0xb0,
    0x4f, 0xa0, 0x0, 0x0, 0x3f, 0xb0, 0x4f, 0xa0,
    0x0, 0x0, 0x3f, 0xb0, 0x4f, 0xa0, 0x0, 0x0,
    0x5f, 0xb0, 0x2f, 0xd0, 0x0, 0x0, 0xaf, 0xb0,
    0xe, 0xf8, 0x0, 0x6, 0xff, 0xb0, 0x4, 0xff,
    0xec, 0xef, 0xbf, 0xb0, 0x0, 0x3b, 0xef, 0xd6,
    0x4f, 0xe0, 0x0, 0x0, 0x0, 0x4, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0xe, 0x70, 0x0, 0x0, 0x0,
    0x0, 0xf, 0x80, 0x20, 0x0, 0x0, 0x0, 0x7,
    0xff, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0,

    /* U+0174 "Ŵ" */
    0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xa4, 0xeb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x75, 0x0, 0x17, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xd0, 0x0, 0x0,
    0x0, 0xcf, 0x60, 0x0, 0x0, 0x3, 0xfb, 0xd,
    0xf2, 0x0, 0x0, 0x1, 0xff, 0xb0, 0x0, 0x0,
    0x8, 0xf5, 0x8, 0xf8, 0x0, 0x0, 0x7, 0xff,
    0xf1, 0x0, 0x0, 0xe, 0xf0, 0x3, 0xfd, 0x0,
    0x0, 0xc, 0xf9, 0xf6, 0x0, 0x0, 0x3f, 0xb0,
    0x0, 0xdf, 0x20, 0x0, 0x2f, 0xb2, 0xfc, 0x0,
    0x0, 0x9f, 0x50, 0x0, 0x8f, 0x80, 0x0, 0x7f,
    0x50, 0xdf, 0x10, 0x0, 0xef, 0x0, 0x0, 0x3f,
    0xd0, 0x0, 0xdf, 0x0, 0x7f, 0x60, 0x3, 0xfb,
    0x0, 0x0, 0xd, 0xf2, 0x2, 0xfa, 0x0, 0x2f,
    0xc0, 0x9, 0xf5, 0x0, 0x0, 0x8, 0xf8, 0x8,
    0xf5, 0x0, 0xc, 0xf1, 0xe, 0xf0, 0x0, 0x0,
    0x3, 0xfd, 0xd, 0xf0, 0x0, 0x7, 0xf7, 0x4f,
    0xb0, 0x0, 0x0, 0x0, 0xdf, 0x6f, 0xa0, 0x0,
    0x1, 0xfc, 0x9f, 0x50, 0x0, 0x0, 0x0, 0x8f,
    0xff, 0x40, 0x0, 0x0, 0xcf, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xfe, 0x0, 0x0, 0x0, 0x6f,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf9, 0x0,
    0x0, 0x0, 0x1f, 0xf5, 0x0, 0x0,

    /* U+0175 "ŵ" */
    0x0, 0x0, 0x0, 0x8, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0x68, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0x83, 0x0, 0x48,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0x10, 0x0, 0x0,
    0xff, 0x0, 0x0, 0x1, 0xfa, 0x5f, 0x70, 0x0,
    0x5, 0xff, 0x50, 0x0, 0x6, 0xf4, 0xf, 0xc0,
    0x0, 0xb, 0xff, 0xb0, 0x0, 0xc, 0xe0, 0xa,
    0xf2, 0x0, 0x1f, 0xab, 0xf1, 0x0, 0x2f, 0x90,
    0x4, 0xf8, 0x0, 0x7f, 0x45, 0xf6, 0x0, 0x8f,
    0x30, 0x0, 0xed, 0x0, 0xce, 0x0, 0xfc, 0x0,
    0xdd, 0x0, 0x0, 0x9f, 0x32, 0xf8, 0x0, 0x9f,
    0x23, 0xf7, 0x0, 0x0, 0x3f, 0x88, 0xf2, 0x0,
    0x3f, 0x79, 0xf2, 0x0, 0x0, 0xd, 0xee, 0xc0,
    0x0, 0xd, 0xde, 0xc0, 0x0, 0x0, 0x7, 0xff,
    0x60, 0x0, 0x8, 0xff, 0x60, 0x0, 0x0, 0x2,
    0xff, 0x10, 0x0, 0x2, 0xff, 0x10, 0x0,

    /* U+0176 "Ŷ" */
    0x0, 0x0, 0x0, 0x23, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xff, 0xe2, 0x0, 0x0, 0x0, 0x0,
    0x2e, 0xc3, 0xdd, 0x10, 0x0, 0x0, 0x0, 0x8a,
    0x10, 0x1a, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xf5, 0x0, 0x0, 0x0,
    0x4, 0xfb, 0x3, 0xfe, 0x0, 0x0, 0x0, 0xd,
    0xf1, 0x0, 0x9f, 0x90, 0x0, 0x0, 0x8f, 0x70,
    0x0, 0xe, 0xf2, 0x0, 0x2, 0xfd, 0x0, 0x0,
    0x5, 0xfc, 0x0, 0xb, 0xf4, 0x0, 0x0, 0x0,
    0xbf, 0x60, 0x5f, 0xa0, 0x0, 0x0, 0x0, 0x2f,
    0xe2, 0xef, 0x10, 0x0, 0x0, 0x0, 0x8, 0xfe,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0x70, 0x0, 0x0,

    /* U+0177 "ŷ" */
    0x0, 0x0, 0x3e, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0xa4, 0xec, 0x0, 0x0, 0x0, 0x7, 0x60,
    0x1, 0x74, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xf2, 0x0, 0x0, 0x0, 0xee,
    0x0, 0x6f, 0x90, 0x0, 0x0, 0x5f, 0x80, 0x0,
    0xff, 0x0, 0x0, 0xc, 0xf2, 0x0, 0x8, 0xf6,
    0x0, 0x2, 0xfa, 0x0, 0x0, 0x2f, 0xd0, 0x0,
    0x9f, 0x40, 0x0, 0x0, 0xbf, 0x40, 0x1f, 0xd0,
    0x0, 0x0, 0x4, 0xfb, 0x7, 0xf6, 0x0, 0x0,
    0x0, 0xd, 0xf2, 0xde, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xcf, 0x80, 0x0, 0x0, 0x0, 0x0, 0xef,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x8, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0x40, 0x0, 0x0,
    0x3, 0x0, 0x3f, 0xc0, 0x0, 0x0, 0x3, 0xfd,
    0xbf, 0xf3, 0x0, 0x0, 0x0, 0x8, 0xef, 0xc4,
    0x0, 0x0, 0x0, 0x0,

    /* U+0178 "Ÿ" */
    0x0, 0x0, 0x3f, 0x60, 0x7e, 0x20, 0x0, 0x0,
    0x0, 0x4f, 0x70, 0x8f, 0x30, 0x0, 0x0, 0x0,
    0x1, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xf5, 0x0, 0x0,
    0x0, 0x4, 0xfb, 0x3, 0xfe, 0x0, 0x0, 0x0,
    0xd, 0xf1, 0x0, 0x9f, 0x90, 0x0, 0x0, 0x8f,
    0x70, 0x0, 0xe, 0xf2, 0x0, 0x2, 0xfd, 0x0,
    0x0, 0x5, 0xfc, 0x0, 0xb, 0xf4, 0x0, 0x0,
    0x0, 0xbf, 0x60, 0x5f, 0xa0, 0x0, 0x0, 0x0,
    0x2f, 0xe2, 0xef, 0x10, 0x0, 0x0, 0x0, 0x8,
    0xfe, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x70, 0x0, 0x0,

    /* U+0179 "Ź" */
    0x0, 0x0, 0x0, 0xef, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0x80, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xa1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x40, 0xcc, 0xcc, 0xcc, 0xcc, 0xef, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0x1d, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0x5, 0xfe, 0x10,
    0x0, 0x0, 0x0, 0x3, 0xff, 0x20, 0x0, 0x0,
    0x0, 0x1, 0xef, 0x50, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0x80, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xe2, 0x0, 0x0, 0x0, 0x0,
    0x1e, 0xfe, 0xcc, 0xcc, 0xcc, 0xcc, 0x62, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8,

    /* U+017A "ź" */
    0x0, 0x0, 0x7f, 0x90, 0x0, 0x0, 0x0, 0xcf,
    0x10, 0x0, 0x0, 0x0, 0xa6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xff,
    0xf8, 0xa, 0xaa, 0xaa, 0xaf, 0xf4, 0x0, 0x0,
    0x0, 0x9f, 0x90, 0x0, 0x0, 0x6, 0xfc, 0x0,
    0x0, 0x0, 0x3f, 0xe1, 0x0, 0x0, 0x1, 0xdf,
    0x30, 0x0, 0x0, 0xb, 0xf7, 0x0, 0x0, 0x0,
    0x7f, 0xa0, 0x0, 0x0, 0x4, 0xfd, 0x0, 0x0,
    0x0, 0x1e, 0xfc, 0xaa, 0xaa, 0xa6, 0x3f, 0xff,
    0xff, 0xff, 0xfa,

    /* U+017B "Ż" */
    0x0, 0x0, 0x0, 0x52, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xe9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4, 0xc,
    0xcc, 0xcc, 0xcc, 0xce, 0xff, 0x20, 0x0, 0x0,
    0x0, 0x1, 0xdf, 0x60, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0x90, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0xe1, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x1e, 0xf5, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xfe, 0x20, 0x0, 0x0, 0x0, 0x1, 0xef,
    0xec, 0xcc, 0xcc, 0xcc, 0xc6, 0x2f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x80,

    /* U+017C "ż" */
    0x0, 0x0, 0xae, 0x20, 0x0, 0x0, 0x0, 0xdf,
    0x50, 0x0, 0x0, 0x0, 0x25, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xff,
    0xf8, 0xa, 0xaa, 0xaa, 0xaf, 0xf4, 0x0, 0x0,
    0x0, 0x9f, 0x90, 0x0, 0x0, 0x6, 0xfc, 0x0,
    0x0, 0x0, 0x3f, 0xe1, 0x0, 0x0, 0x1, 0xdf,
    0x30, 0x0, 0x0, 0xb, 0xf7, 0x0, 0x0, 0x0,
    0x7f, 0xa0, 0x0, 0x0, 0x4, 0xfd, 0x0, 0x0,
    0x0, 0x1e, 0xfc, 0xaa, 0xaa, 0xa6, 0x3f, 0xff,
    0xff, 0xff, 0xfa,

    /* U+017D "Ž" */
    0x0, 0x5, 0xf7, 0x3, 0xeb, 0x0, 0x0, 0x0,
    0x5, 0xfc, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x3,
    0x86, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x40, 0xcc, 0xcc, 0xcc, 0xcc, 0xef, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0x1d, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x8,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0x5, 0xfe, 0x10,
    0x0, 0x0, 0x0, 0x3, 0xff, 0x20, 0x0, 0x0,
    0x0, 0x1, 0xef, 0x50, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0x80, 0x0, 0x0, 0x0, 0x0, 0xaf, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xe2, 0x0, 0x0, 0x0, 0x0,
    0x1e, 0xfe, 0xcc, 0xcc, 0xcc, 0xcc, 0x62, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8,

    /* U+017E "ž" */
    0x0, 0xcd, 0x20, 0x8f, 0x40, 0x0, 0xb, 0xfc,
    0xf4, 0x0, 0x0, 0x0, 0x78, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xff, 0xff,
    0xf8, 0xa, 0xaa, 0xaa, 0xaf, 0xf4, 0x0, 0x0,
    0x0, 0x9f, 0x90, 0x0, 0x0, 0x6, 0xfc, 0x0,
    0x0, 0x0, 0x3f, 0xe1, 0x0, 0x0, 0x1, 0xdf,
    0x30, 0x0, 0x0, 0xb, 0xf7, 0x0, 0x0, 0x0,
    0x7f, 0xa0, 0x0, 0x0, 0x4, 0xfd, 0x0, 0x0,
    0x0, 0x1e, 0xfc, 0xaa, 0xaa, 0xa6, 0x3f, 0xff,
    0xff, 0xff, 0xfa,

    /* U+017F "ſ" */
    0x0, 0x4, 0xcf, 0xe8, 0x0, 0x3f, 0xfb, 0xb9,
    0x0, 0x9f, 0x70, 0x0, 0x0, 0xbf, 0x30, 0x0,
    0x8f, 0xff, 0x30, 0x0, 0x5a, 0xef, 0x30, 0x0,
    0x0, 0xbf, 0x30, 0x0, 0x0, 0xbf, 0x30, 0x0,
    0x0, 0xbf, 0x30, 0x0, 0x0, 0xbf, 0x30, 0x0,
    0x0, 0xbf, 0x30, 0x0, 0x0, 0xbf, 0x30, 0x0,
    0x0, 0xbf, 0x30, 0x0, 0x0, 0xbf, 0x30, 0x0,
    0x0, 0xbf, 0x30, 0x0,

    /* U+0384 "΄" */
    0x1a, 0x90, 0x6f, 0x70, 0xce, 0x0,

    /* U+0386 "Ά" */
    0x0, 0x7f, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0x10, 0xe, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0xa6, 0x0, 0x5f, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0x7f, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xf9, 0xf, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xf2, 0x9, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xc0, 0x2, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x50, 0x0, 0xbf, 0x30, 0x0,
    0x0, 0x1, 0xfe, 0x0, 0x0, 0x5f, 0xb0, 0x0,
    0x0, 0x8, 0xf7, 0x0, 0x0, 0xe, 0xf2, 0x0,
    0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x0,
    0x0, 0x6f, 0xda, 0xaa, 0xaa, 0xaa, 0xff, 0x10,
    0x0, 0xdf, 0x30, 0x0, 0x0, 0x0, 0x9f, 0x80,
    0x5, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xe0,
    0xc, 0xf4, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf6,

    /* U+0388 "Έ" */
    0xa, 0xc2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xfa, 0x7, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x5c,
    0x20, 0x7f, 0xec, 0xcc, 0xcc, 0xcc, 0x50, 0x0,
    0x7, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xff,
    0xff, 0xff, 0xff, 0x90, 0x0, 0x0, 0x7f, 0xec,
    0xcc, 0xcc, 0xc6, 0x0, 0x0, 0x7, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xfe, 0xcc, 0xcc, 0xcc,
    0xc8, 0x0, 0x0, 0x7f, 0xff, 0xff, 0xff, 0xff,
    0xb0,

    /* U+0389 "Ή" */
    0x2f, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xf5, 0xa, 0xf5, 0x0, 0x0, 0x0, 0xa,
    0xf6, 0x79, 0x0, 0xaf, 0x50, 0x0, 0x0, 0x0,
    0xaf, 0x60, 0x0, 0xa, 0xf5, 0x0, 0x0, 0x0,
    0xa, 0xf6, 0x0, 0x0, 0xaf, 0x50, 0x0, 0x0,
    0x0, 0xaf, 0x60, 0x0, 0xa, 0xf5, 0x0, 0x0,
    0x0, 0xa, 0xf6, 0x0, 0x0, 0xaf, 0x50, 0x0,
    0x0, 0x0, 0xaf, 0x60, 0x0, 0xa, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf6, 0x0, 0x0, 0xaf, 0xdc,
    0xcc, 0xcc, 0xcc, 0xef, 0x60, 0x0, 0xa, 0xf5,
    0x0, 0x0, 0x0, 0xa, 0xf6, 0x0, 0x0, 0xaf,
    0x50, 0x0, 0x0, 0x0, 0xaf, 0x60, 0x0, 0xa,
    0xf5, 0x0, 0x0, 0x0, 0xa, 0xf6, 0x0, 0x0,
    0xaf, 0x50, 0x0, 0x0, 0x0, 0xaf, 0x60, 0x0,
    0xa, 0xf5, 0x0, 0x0, 0x0, 0xa, 0xf6, 0x0,
    0x0, 0xaf, 0x50, 0x0, 0x0, 0x0, 0xaf, 0x60,

    /* U+038A "Ί" */
    0x2f, 0xd0, 0x0, 0x7, 0xf5, 0x9, 0xf6, 0x79,
    0x0, 0x9f, 0x60, 0x0, 0x9, 0xf6, 0x0, 0x0,
    0x9f, 0x60, 0x0, 0x9, 0xf6, 0x0, 0x0, 0x9f,
    0x60, 0x0, 0x9, 0xf6, 0x0, 0x0, 0x9f, 0x60,
    0x0, 0x9, 0xf6, 0x0, 0x0, 0x9f, 0x60, 0x0,
    0x9, 0xf6, 0x0, 0x0, 0x9f, 0x60, 0x0, 0x9,
    0xf6, 0x0, 0x0, 0x9f, 0x60,

    /* U+038C "Ό" */
    0x1f, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0x60, 0x17, 0xce, 0xfe, 0xb6, 0x0, 0x0,
    0x79, 0x5, 0xef, 0xfe, 0xdf, 0xff, 0xd3, 0x0,
    0x0, 0x5f, 0xf9, 0x20, 0x0, 0x3b, 0xff, 0x30,
    0x1, 0xff, 0x50, 0x0, 0x0, 0x0, 0x8f, 0xd0,
    0x9, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf5,
    0xd, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfa,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfc,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfc,
    0xd, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfa,
    0x9, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf5,
    0x1, 0xff, 0x50, 0x0, 0x0, 0x0, 0x8f, 0xd0,
    0x0, 0x5f, 0xf9, 0x20, 0x0, 0x3b, 0xff, 0x30,
    0x0, 0x5, 0xef, 0xfe, 0xdf, 0xff, 0xd3, 0x0,
    0x0, 0x0, 0x17, 0xce, 0xfe, 0xb6, 0x0, 0x0,

    /* U+038E "Ύ" */
    0x1f, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0x60, 0x4f, 0xd0, 0x0, 0x0, 0x0,
    0xc, 0xf3, 0x79, 0x0, 0xa, 0xf7, 0x0, 0x0,
    0x0, 0x6f, 0x90, 0x0, 0x0, 0x1, 0xff, 0x20,
    0x0, 0x1, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0xb0, 0x0, 0xa, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xf5, 0x0, 0x4f, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xfe, 0x0, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0x88, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1e, 0xff, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0,

    /* U+038F "Ώ" */
    0xf, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0x70, 0x4, 0xad, 0xff, 0xd9, 0x30,
    0x0, 0x0, 0x6a, 0x1, 0xbf, 0xff, 0xdd, 0xff,
    0xfa, 0x0, 0x0, 0x0, 0xc, 0xfd, 0x50, 0x0,
    0x5, 0xef, 0xc0, 0x0, 0x0, 0x8f, 0xd1, 0x0,
    0x0, 0x0, 0x1d, 0xf8, 0x0, 0x0, 0xff, 0x30,
    0x0, 0x0, 0x0, 0x3, 0xff, 0x0, 0x4, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x40, 0x6,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x50,
    0x5, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x50, 0x3, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0x30, 0x0, 0xef, 0x30, 0x0, 0x0, 0x0,
    0x3, 0xfd, 0x0, 0x0, 0x6f, 0xc0, 0x0, 0x0,
    0x0, 0xd, 0xf5, 0x0, 0x0, 0x9, 0xfb, 0x10,
    0x0, 0x1, 0xcf, 0x90, 0x0, 0xac, 0xcc, 0xff,
    0xe1, 0x0, 0x1f, 0xff, 0xcc, 0xc9, 0xdf, 0xff,
    0xff, 0xf1, 0x0, 0x2f, 0xff, 0xff, 0xfc,

    /* U+0390 "ΐ" */
    0x0, 0xa, 0xa0, 0x0, 0x4f, 0x90, 0x0, 0xaf,
    0x10, 0x0, 0x0, 0x0, 0xbc, 0x1, 0xe8, 0xde,
    0x2, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xfe, 0x0,
    0x0, 0xfe, 0x0, 0x0, 0xfe, 0x0, 0x0, 0xfe,
    0x0, 0x0, 0xfe, 0x0, 0x0, 0xfe, 0x0, 0x0,
    0xfe, 0x0, 0x0, 0xfe, 0x0, 0x0, 0xfe, 0x0,
    0x0, 0xfe, 0x0, 0x0, 0xfe, 0x0,

    /* U+0391 "Α" */
    0x0, 0x0, 0x0, 0xe, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xaf, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xfa, 0x1f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xf3, 0xa, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xc0, 0x3, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x50, 0x0, 0xcf, 0x30, 0x0,
    0x0, 0x1, 0xfe, 0x0, 0x0, 0x5f, 0xb0, 0x0,
    0x0, 0x8, 0xf7, 0x0, 0x0, 0xe, 0xf2, 0x0,
    0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x0,
    0x0, 0x6f, 0xda, 0xaa, 0xaa, 0xaa, 0xff, 0x10,
    0x0, 0xdf, 0x30, 0x0, 0x0, 0x0, 0x9f, 0x80,
    0x5, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xe0,
    0xc, 0xf4, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf6,

    /* U+0392 "Β" */
    0xef, 0xff, 0xff, 0xfe, 0xb5, 0x0, 0xe, 0xfb,
    0xaa, 0xab, 0xdf, 0xf9, 0x0, 0xef, 0x10, 0x0,
    0x0, 0x4f, 0xf3, 0xe, 0xf1, 0x0, 0x0, 0x0,
    0xaf, 0x60, 0xef, 0x10, 0x0, 0x0, 0xc, 0xf4,
    0xe, 0xf1, 0x0, 0x0, 0x29, 0xfc, 0x0, 0xef,
    0xff, 0xff, 0xff, 0xfe, 0x10, 0xe, 0xfb, 0xaa,
    0xaa, 0xce, 0xfd, 0x20, 0xef, 0x10, 0x0, 0x0,
    0x8, 0xfc, 0xe, 0xf1, 0x0, 0x0, 0x0, 0xf,
    0xf0, 0xef, 0x10, 0x0, 0x0, 0x0, 0xff, 0x1e,
    0xf1, 0x0, 0x0, 0x0, 0x8f, 0xe0, 0xef, 0xbb,
    0xbb, 0xbc, 0xef, 0xf4, 0xe, 0xff, 0xff, 0xff,
    0xfd, 0x92, 0x0,

    /* U+0393 "Γ" */
    0xdf, 0xff, 0xff, 0xff, 0xf5, 0xdf, 0xdc, 0xcc,
    0xcc, 0xc4, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xdf,
    0x20, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xdf, 0x20,
    0x0, 0x0, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x0,
    0xdf, 0x20, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0,
    0x0, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xdf,
    0x20, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0xdf, 0x20, 0x0, 0x0, 0x0,

    /* U+0394 "Δ" */
    0x0, 0x0, 0x0, 0xe, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0x9f, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xfa, 0x1f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xf3, 0x9, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xc0, 0x2, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x50, 0x0, 0xbf, 0x30, 0x0,
    0x0, 0x1, 0xfd, 0x0, 0x0, 0x4f, 0xb0, 0x0,
    0x0, 0x8, 0xf6, 0x0, 0x0, 0xd, 0xf2, 0x0,
    0x0, 0xe, 0xe0, 0x0, 0x0, 0x6, 0xf9, 0x0,
    0x0, 0x6f, 0x80, 0x0, 0x0, 0x0, 0xef, 0x10,
    0x0, 0xdf, 0x10, 0x0, 0x0, 0x0, 0x8f, 0x80,
    0x5, 0xff, 0xcc, 0xcc, 0xcc, 0xcc, 0xdf, 0xe0,
    0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,

    /* U+0395 "Ε" */
    0xef, 0xff, 0xff, 0xff, 0xff, 0xe, 0xfd, 0xcc,
    0xcc, 0xcc, 0xc0, 0xef, 0x10, 0x0, 0x0, 0x0,
    0xe, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xef, 0x10,
    0x0, 0x0, 0x0, 0xe, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0xef, 0xff, 0xff, 0xff, 0xf2, 0xe, 0xfc,
    0xcc, 0xcc, 0xcc, 0x10, 0xef, 0x10, 0x0, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x10, 0x0, 0x0, 0x0, 0xe, 0xf1, 0x0, 0x0,
    0x0, 0x0, 0xef, 0xcc, 0xcc, 0xcc, 0xcc, 0x3e,
    0xff, 0xff, 0xff, 0xff, 0xf4,

    /* U+0396 "Ζ" */
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0xcc,
    0xcc, 0xcc, 0xcc, 0xef, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x1d, 0xf6, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x8, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xfe, 0x10, 0x0, 0x0,
    0x0, 0x3, 0xff, 0x30, 0x0, 0x0, 0x0, 0x1,
    0xef, 0x50, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x9f, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x1e, 0xfe,
    0xcc, 0xcc, 0xcc, 0xcc, 0x72, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf9,

    /* U+0397 "Η" */
    0xef, 0x10, 0x0, 0x0, 0x0, 0xdf, 0x2e, 0xf1,
    0x0, 0x0, 0x0, 0xd, 0xf2, 0xef, 0x10, 0x0,
    0x0, 0x0, 0xdf, 0x2e, 0xf1, 0x0, 0x0, 0x0,
    0xd, 0xf2, 0xef, 0x10, 0x0, 0x0, 0x0, 0xdf,
    0x2e, 0xf1, 0x0, 0x0, 0x0, 0xd, 0xf2, 0xef,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x2e, 0xfd, 0xcc,
    0xcc, 0xcc, 0xcf, 0xf2, 0xef, 0x10, 0x0, 0x0,
    0x0, 0xdf, 0x2e, 0xf1, 0x0, 0x0, 0x0, 0xd,
    0xf2, 0xef, 0x10, 0x0, 0x0, 0x0, 0xdf, 0x2e,
    0xf1, 0x0, 0x0, 0x0, 0xd, 0xf2, 0xef, 0x10,
    0x0, 0x0, 0x0, 0xdf, 0x2e, 0xf1, 0x0, 0x0,
    0x0, 0xd, 0xf2,

    /* U+0398 "Θ" */
    0x0, 0x0, 0x17, 0xce, 0xfe, 0xb6, 0x0, 0x0,
    0x0, 0x5, 0xef, 0xfe, 0xdf, 0xff, 0xd3, 0x0,
    0x0, 0x5f, 0xf9, 0x20, 0x0, 0x3b, 0xff, 0x30,
    0x1, 0xff, 0x50, 0x0, 0x0, 0x0, 0x8f, 0xd0,
    0x9, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf5,
    0xd, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfa,
    0xf, 0xf0, 0x9f, 0xff, 0xff, 0xff, 0x73, 0xfc,
    0xf, 0xf0, 0x8e, 0xee, 0xee, 0xee, 0x63, 0xfc,
    0xd, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfa,
    0x9, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf5,
    0x1, 0xff, 0x50, 0x0, 0x0, 0x0, 0x8f, 0xd0,
    0x0, 0x5f, 0xf9, 0x20, 0x0, 0x3b, 0xff, 0x30,
    0x0, 0x5, 0xef, 0xfe, 0xdf, 0xff, 0xd3, 0x0,
    0x0, 0x0, 0x17, 0xce, 0xfe, 0xb6, 0x0, 0x0,

    /* U+0399 "Ι" */
    0xef, 0x1e, 0xf1, 0xef, 0x1e, 0xf1, 0xef, 0x1e,
    0xf1, 0xef, 0x1e, 0xf1, 0xef, 0x1e, 0xf1, 0xef,
    0x1e, 0xf1, 0xef, 0x1e, 0xf1,

    /* U+039A "Κ" */
    0xef, 0x10, 0x0, 0x0, 0xb, 0xf8, 0xe, 0xf1,
    0x0, 0x0, 0xb, 0xf8, 0x0, 0xef, 0x10, 0x0,
    0xb, 0xf9, 0x0, 0xe, 0xf1, 0x0, 0xa, 0xfa,
    0x0, 0x0, 0xef, 0x10, 0xa, 0xfb, 0x0, 0x0,
    0xe, 0xf1, 0xa, 0xfb, 0x0, 0x0, 0x0, 0xef,
    0x19, 0xff, 0x30, 0x0, 0x0, 0xe, 0xfa, 0xff,
    0xfe, 0x10, 0x0, 0x0, 0xef, 0xfd, 0x1b, 0xfc,
    0x0, 0x0, 0xe, 0xfd, 0x10, 0xc, 0xfa, 0x0,
    0x0, 0xef, 0x20, 0x0, 0x1e, 0xf7, 0x0, 0xe,
    0xf1, 0x0, 0x0, 0x2f, 0xf4, 0x0, 0xef, 0x10,
    0x0, 0x0, 0x4f, 0xf2, 0xe, 0xf1, 0x0, 0x0,
    0x0, 0x6f, 0xd1,

    /* U+039B "Λ" */
    0x0, 0x0, 0x0, 0xe, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0x9f, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xfa, 0x1f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xf3, 0x9, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xc0, 0x2, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x50, 0x0, 0xbf, 0x30, 0x0,
    0x0, 0x1, 0xfe, 0x0, 0x0, 0x4f, 0xb0, 0x0,
    0x0, 0x8, 0xf7, 0x0, 0x0, 0xd, 0xf2, 0x0,
    0x0, 0xe, 0xf1, 0x0, 0x0, 0x6, 0xf9, 0x0,
    0x0, 0x6f, 0x90, 0x0, 0x0, 0x0, 0xef, 0x10,
    0x0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0x8f, 0x80,
    0x5, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xe0,
    0xc, 0xf4, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf6,

    /* U+039C "Μ" */
    0xef, 0x10, 0x0, 0x0, 0x0, 0x0, 0xe, 0xfe,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0xef,
    0xf3, 0x0, 0x0, 0x0, 0x2, 0xff, 0xfe, 0xff,
    0xc0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xef, 0x9f,
    0x60, 0x0, 0x0, 0x4f, 0xaf, 0xfe, 0xf1, 0xee,
    0x10, 0x0, 0xd, 0xf1, 0xff, 0xef, 0x6, 0xf9,
    0x0, 0x7, 0xf7, 0xe, 0xfe, 0xf0, 0xc, 0xf3,
    0x1, 0xfd, 0x0, 0xef, 0xef, 0x0, 0x3f, 0xc0,
    0xaf, 0x40, 0xe, 0xfe, 0xf0, 0x0, 0x9f, 0x9f,
    0xa0, 0x0, 0xef, 0xef, 0x0, 0x1, 0xef, 0xf1,
    0x0, 0xe, 0xfe, 0xf0, 0x0, 0x6, 0xf7, 0x0,
    0x0, 0xef, 0xef, 0x0, 0x0, 0x4, 0x0, 0x0,
    0xe, 0xfe, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xef,

    /* U+039D "Ν" */
    0xef, 0x20, 0x0, 0x0, 0x0, 0xdf, 0x2e, 0xfd,
    0x10, 0x0, 0x0, 0xd, 0xf2, 0xef, 0xfb, 0x0,
    0x0, 0x0, 0xdf, 0x2e, 0xfe, 0xf8, 0x0, 0x0,
    0xd, 0xf2, 0xef, 0x4f, 0xf5, 0x0, 0x0, 0xdf,
    0x2e, 0xf1, 0x5f, 0xf3, 0x0, 0xd, 0xf2, 0xef,
    0x10, 0x8f, 0xe1, 0x0, 0xdf, 0x2e, 0xf1, 0x0,
    0xbf, 0xc0, 0xd, 0xf2, 0xef, 0x10, 0x1, 0xdf,
    0x90, 0xdf, 0x2e, 0xf1, 0x0, 0x2, 0xff, 0x6d,
    0xf2, 0xef, 0x10, 0x0, 0x5, 0xff, 0xff, 0x2e,
    0xf1, 0x0, 0x0, 0x8, 0xff, 0xf2, 0xef, 0x10,
    0x0, 0x0, 0xb, 0xff, 0x2e, 0xf1, 0x0, 0x0,
    0x0, 0xd, 0xf2,

    /* U+039E "Ξ" */
    0xaf, 0xff, 0xff, 0xff, 0xff, 0xfe, 0x8, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcc, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xff, 0xff, 0xff, 0xff, 0x70, 0x0, 0x2c, 0xcc,
    0xcc, 0xcc, 0xc5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbc, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcc, 0x2e, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf3,

    /* U+039F "Ο" */
    0x0, 0x0, 0x17, 0xce, 0xfe, 0xb6, 0x0, 0x0,
    0x0, 0x5, 0xef, 0xfe, 0xdf, 0xff, 0xd3, 0x0,
    0x0, 0x5f, 0xf9, 0x20, 0x0, 0x3b, 0xff, 0x30,
    0x1, 0xff, 0x50, 0x0, 0x0, 0x0, 0x8f, 0xd0,
    0x9, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf5,
    0xd, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfa,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfc,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfc,
    0xd, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfa,
    0x9, 0xf9, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf5,
    0x1, 0xff, 0x50, 0x0, 0x0, 0x0, 0x8f, 0xd0,
    0x0, 0x5f, 0xf9, 0x20, 0x0, 0x3b, 0xff, 0x30,
    0x0, 0x5, 0xef, 0xfe, 0xdf, 0xff, 0xd3, 0x0,
    0x0, 0x0, 0x17, 0xce, 0xfe, 0xb6, 0x0, 0x0,

    /* U+03A0 "Π" */
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3d, 0xfd,
    0xcc, 0xcc, 0xcc, 0xcf, 0xf3, 0xdf, 0x20, 0x0,
    0x0, 0x0, 0xbf, 0x3d, 0xf2, 0x0, 0x0, 0x0,
    0xb, 0xf3, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xbf,
    0x3d, 0xf2, 0x0, 0x0, 0x0, 0xb, 0xf3, 0xdf,
    0x20, 0x0, 0x0, 0x0, 0xbf, 0x3d, 0xf2, 0x0,
    0x0, 0x0, 0xb, 0xf3, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0xbf, 0x3d, 0xf2, 0x0, 0x0, 0x0, 0xb,
    0xf3, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xbf, 0x3d,
    0xf2, 0x0, 0x0, 0x0, 0xb, 0xf3, 0xdf, 0x20,
    0x0, 0x0, 0x0, 0xbf, 0x3d, 0xf2, 0x0, 0x0,
    0x0, 0xb, 0xf3,

    /* U+03A1 "Ρ" */
    0xef, 0xff, 0xff, 0xec, 0x70, 0x0, 0xef, 0xdc,
    0xcd, 0xef, 0xfe, 0x20, 0xef, 0x10, 0x0, 0x2,
    0xbf, 0xc0, 0xef, 0x10, 0x0, 0x0, 0xe, 0xf3,
    0xef, 0x10, 0x0, 0x0, 0xa, 0xf5, 0xef, 0x10,
    0x0, 0x0, 0xb, 0xf5, 0xef, 0x10, 0x0, 0x0,
    0x2f, 0xf2, 0xef, 0x10, 0x0, 0x15, 0xdf, 0xa0,
    0xef, 0xff, 0xff, 0xff, 0xfa, 0x0, 0xef, 0xcc,
    0xcc, 0xb8, 0x30, 0x0, 0xef, 0x10, 0x0, 0x0,
    0x0, 0x0, 0xef, 0x10, 0x0, 0x0, 0x0, 0x0,
    0xef, 0x10, 0x0, 0x0, 0x0, 0x0, 0xef, 0x10,
    0x0, 0x0, 0x0, 0x0,

    /* U+03A3 "Σ" */
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xf9, 0x1f, 0xff,
    0xff, 0xff, 0xff, 0xf8, 0x5, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xff, 0x40, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff,
    0x20, 0x0, 0x0, 0x0, 0x8, 0xff, 0x20, 0x0,
    0x0, 0x0, 0x7f, 0xf4, 0x0, 0x0, 0x0, 0x6,
    0xff, 0x40, 0x0, 0x0, 0x0, 0x5f, 0xf5, 0x0,
    0x0, 0x0, 0x5, 0xff, 0x50, 0x0, 0x0, 0x0,
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x1f, 0xff,
    0xff, 0xff, 0xff, 0xf9,

    /* U+03A4 "Τ" */
    0xef, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xbc, 0xcc,
    0xdf, 0xfc, 0xcc, 0xc8, 0x0, 0x0, 0x2f, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xd0, 0x0, 0x0,

    /* U+03A5 "Υ" */
    0xc, 0xf5, 0x0, 0x0, 0x0, 0x4, 0xfb, 0x0,
    0x2f, 0xe1, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0,
    0x8f, 0x90, 0x0, 0x0, 0x7f, 0x70, 0x0, 0x0,
    0xef, 0x30, 0x0, 0x2f, 0xd0, 0x0, 0x0, 0x5,
    0xfc, 0x0, 0xb, 0xf4, 0x0, 0x0, 0x0, 0xb,
    0xf6, 0x5, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x2f,
    0xe2, 0xef, 0x10, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0xef, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xf7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xf7, 0x0, 0x0,
    0x0,

    /* U+03A6 "Φ" */
    0x0, 0x0, 0x0, 0x2, 0x73, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x2, 0x8c, 0xef, 0xff, 0xec, 0x82,
    0x0, 0x0, 0x7, 0xff, 0xeb, 0xcf, 0xdb, 0xef,
    0xf9, 0x0, 0x8, 0xfe, 0x50, 0x6, 0xf7, 0x0,
    0x4d, 0xfa, 0x2, 0xfe, 0x20, 0x0, 0x6f, 0x70,
    0x0, 0x1d, 0xf4, 0x8f, 0x70, 0x0, 0x6, 0xf7,
    0x0, 0x0, 0x5f, 0xab, 0xf3, 0x0, 0x0, 0x6f,
    0x70, 0x0, 0x1, 0xfc, 0xcf, 0x20, 0x0, 0x6,
    0xf7, 0x0, 0x0, 0xf, 0xda, 0xf4, 0x0, 0x0,
    0x6f, 0x70, 0x0, 0x2, 0xfc, 0x6f, 0xa0, 0x0,
    0x6, 0xf7, 0x0, 0x0, 0x8f, 0x80, 0xef, 0x60,
    0x0, 0x6f, 0x70, 0x0, 0x4f, 0xf1, 0x3, 0xff,
    0xb4, 0x16, 0xf7, 0x14, 0xaf, 0xf4, 0x0, 0x2,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xc3, 0x0, 0x0,
    0x0, 0x26, 0x8b, 0xfc, 0x86, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0x70, 0x0, 0x0, 0x0,

    /* U+03A7 "Χ" */
    0x1f, 0xf3, 0x0, 0x0, 0x0, 0xbf, 0x70, 0x5,
    0xfe, 0x10, 0x0, 0x6, 0xfb, 0x0, 0x0, 0x9f,
    0xa0, 0x0, 0x2f, 0xe1, 0x0, 0x0, 0xd, 0xf6,
    0x0, 0xdf, 0x40, 0x0, 0x0, 0x3, 0xff, 0x29,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xef, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xff, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x1e, 0xff, 0x70, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0x9f, 0xf3, 0x0, 0x0, 0x0,
    0x7, 0xfc, 0x6, 0xfd, 0x0, 0x0, 0x0, 0x3f,
    0xf2, 0x0, 0xaf, 0xa0, 0x0, 0x0, 0xdf, 0x50,
    0x0, 0xd, 0xf5, 0x0, 0xa, 0xfa, 0x0, 0x0,
    0x3, 0xff, 0x20, 0x5f, 0xd0, 0x0, 0x0, 0x0,
    0x7f, 0xc0,

    /* U+03A8 "Ψ" */
    0x0, 0x0, 0x0, 0x2, 0x73, 0x0, 0x0, 0x0,
    0xc, 0xf2, 0x0, 0x0, 0x6f, 0x70, 0x0, 0x1,
    0xfd, 0xcf, 0x20, 0x0, 0x6, 0xf7, 0x0, 0x0,
    0x1f, 0xdc, 0xf2, 0x0, 0x0, 0x6f, 0x70, 0x0,
    0x1, 0xfd, 0xcf, 0x20, 0x0, 0x6, 0xf7, 0x0,
    0x0, 0x1f, 0xdb, 0xf3, 0x0, 0x0, 0x6f, 0x70,
    0x0, 0x3, 0xfb, 0x8f, 0x70, 0x0, 0x6, 0xf7,
    0x0, 0x0, 0x6f, 0x93, 0xfd, 0x0, 0x0, 0x6f,
    0x70, 0x0, 0xd, 0xf3, 0xb, 0xf9, 0x0, 0x6,
    0xf7, 0x0, 0x8, 0xfc, 0x0, 0x1e, 0xfc, 0x41,
    0x6f, 0x71, 0x4b, 0xfe, 0x10, 0x0, 0x1a, 0xff,
    0xff, 0xff, 0xff, 0xfb, 0x10, 0x0, 0x0, 0x1,
    0x68, 0xcf, 0xc8, 0x62, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x6, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0x70, 0x0, 0x0, 0x0,

    /* U+03A9 "Ω" */
    0x0, 0x0, 0x4, 0xad, 0xff, 0xd9, 0x30, 0x0,
    0x0, 0x0, 0x1, 0xbf, 0xff, 0xdd, 0xff, 0xfa,
    0x0, 0x0, 0x0, 0xc, 0xfd, 0x50, 0x0, 0x5,
    0xef, 0xc0, 0x0, 0x0, 0x8f, 0xd1, 0x0, 0x0,
    0x0, 0x1d, 0xf8, 0x0, 0x0, 0xff, 0x30, 0x0,
    0x0, 0x0, 0x3, 0xff, 0x0, 0x4, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0x40, 0x6, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x50, 0x5,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x50,
    0x3, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0x30, 0x0, 0xef, 0x30, 0x0, 0x0, 0x0, 0x3,
    0xfd, 0x0, 0x0, 0x6f, 0xc0, 0x0, 0x0, 0x0,
    0xd, 0xf5, 0x0, 0x0, 0x9, 0xfb, 0x10, 0x0,
    0x1, 0xcf, 0x90, 0x0, 0xac, 0xcc, 0xff, 0xe1,
    0x0, 0x1f, 0xff, 0xcc, 0xc9, 0xdf, 0xff, 0xff,
    0xf1, 0x0, 0x2f, 0xff, 0xff, 0xfc,

    /* U+03AA "Ϊ" */
    0x3f, 0x60, 0x7e, 0x24, 0xf7, 0x8, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x90, 0x0, 0x6, 0xf9, 0x0, 0x0, 0x6f, 0x90,
    0x0, 0x6, 0xf9, 0x0, 0x0, 0x6f, 0x90, 0x0,
    0x6, 0xf9, 0x0, 0x0, 0x6f, 0x90, 0x0, 0x6,
    0xf9, 0x0, 0x0, 0x6f, 0x90, 0x0, 0x6, 0xf9,
    0x0, 0x0, 0x6f, 0x90, 0x0, 0x6, 0xf9, 0x0,
    0x0, 0x6f, 0x90, 0x0, 0x6, 0xf9, 0x0,

    /* U+03AB "Ϋ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xf8, 0x7, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x2e, 0x70, 0x6f, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf5,
    0x0, 0x0, 0x0, 0x4, 0xfb, 0x0, 0x2f, 0xe1,
    0x0, 0x0, 0x0, 0xdf, 0x20, 0x0, 0x8f, 0x90,
    0x0, 0x0, 0x7f, 0x70, 0x0, 0x0, 0xef, 0x30,
    0x0, 0x2f, 0xd0, 0x0, 0x0, 0x5, 0xfc, 0x0,
    0xb, 0xf4, 0x0, 0x0, 0x0, 0xb, 0xf6, 0x5,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xe2, 0xef,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xef, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x8f, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xf7, 0x0, 0x0, 0x0,

    /* U+03AC "ά" */
    0x0, 0x0, 0x0, 0x9f, 0x70, 0x0, 0x0, 0x0,
    0xe, 0xe0, 0x0, 0x0, 0x0, 0x1, 0xa4, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3a,
    0xef, 0xd7, 0xf, 0xf0, 0x6f, 0xfe, 0xce, 0xfc,
    0xff, 0x3f, 0xf5, 0x0, 0x5, 0xff, 0xfa, 0xf7,
    0x0, 0x0, 0x6, 0xff, 0xef, 0x10, 0x0, 0x0,
    0xf, 0xff, 0xf0, 0x0, 0x0, 0x0, 0xff, 0xef,
    0x10, 0x0, 0x0, 0x1f, 0xfa, 0xf7, 0x0, 0x0,
    0x7, 0xff, 0x3f, 0xf5, 0x0, 0x5, 0xff, 0xf0,
    0x6f, 0xfe, 0xce, 0xfc, 0xef, 0x0, 0x3a, 0xef,
    0xd7, 0xe, 0xf0,

    /* U+03AD "έ" */
    0x0, 0x0, 0x1, 0xfe, 0x10, 0x0, 0x0, 0x0,
    0x5f, 0x60, 0x0, 0x0, 0x0, 0x6, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x18,
    0xdf, 0xfd, 0xa5, 0x0, 0x1e, 0xfd, 0xa9, 0xbe,
    0xd0, 0x9, 0xf9, 0x0, 0x0, 0x2, 0x0, 0x9f,
    0x60, 0x0, 0x0, 0x0, 0x3, 0xef, 0x98, 0x88,
    0x30, 0x0, 0x1b, 0xff, 0xff, 0xf7, 0x0, 0xc,
    0xf7, 0x10, 0x0, 0x0, 0x1, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xf5, 0x0, 0x0, 0x2a, 0x10,
    0x6f, 0xfd, 0xbb, 0xdf, 0xf5, 0x0, 0x4a, 0xef,
    0xfd, 0x93, 0x0,

    /* U+03AE "ή" */
    0x0, 0x0, 0x1, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0x60, 0x0, 0x0, 0x0, 0x7, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xa2,
    0x9e, 0xfe, 0x91, 0x3, 0xfc, 0xff, 0xdd, 0xff,
    0xd0, 0x3f, 0xfc, 0x20, 0x2, 0xdf, 0x73, 0xff,
    0x20, 0x0, 0x4, 0xfc, 0x3f, 0xd0, 0x0, 0x0,
    0x1f, 0xe3, 0xfb, 0x0, 0x0, 0x0, 0xfe, 0x3f,
    0xb0, 0x0, 0x0, 0xf, 0xe3, 0xfb, 0x0, 0x0,
    0x0, 0xfe, 0x3f, 0xb0, 0x0, 0x0, 0xf, 0xe3,
    0xfb, 0x0, 0x0, 0x0, 0xfe, 0x3f, 0xb0, 0x0,
    0x0, 0xf, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0xfe, 0x0, 0x0, 0x0, 0x0, 0xf,
    0xe0,

    /* U+03AF "ί" */
    0x4, 0xfc, 0x0, 0x9f, 0x30, 0x8, 0x80, 0x0,
    0x0, 0x0, 0x3f, 0xb0, 0x3, 0xfb, 0x0, 0x3f,
    0xb0, 0x3, 0xfb, 0x0, 0x3f, 0xb0, 0x3, 0xfb,
    0x0, 0x3f, 0xb0, 0x3, 0xfb, 0x0, 0x3f, 0xb0,
    0x3, 0xfb, 0x0, 0x3f, 0xb0, 0x0,

    /* U+03B0 "ΰ" */
    0x0, 0x0, 0x0, 0xaa, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0x90, 0x0, 0x0, 0x0, 0x9, 0xf1, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0x50, 0x6, 0x30, 0x0, 0x0, 0xef, 0x12, 0xfc,
    0x0, 0x0, 0x5, 0x70, 0x7, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xa0, 0x0, 0x0,
    0x3f, 0xb4, 0xfa, 0x0, 0x0, 0x3, 0xfb, 0x4f,
    0xa0, 0x0, 0x0, 0x3f, 0xb4, 0xfa, 0x0, 0x0,
    0x3, 0xfb, 0x4f, 0xa0, 0x0, 0x0, 0x3f, 0xb4,
    0xfa, 0x0, 0x0, 0x3, 0xfb, 0x3f, 0xb0, 0x0,
    0x0, 0x4f, 0xa1, 0xfe, 0x0, 0x0, 0x8, 0xf7,
    0xb, 0xfa, 0x0, 0x4, 0xff, 0x20, 0x1e, 0xff,
    0xcd, 0xff, 0x70, 0x0, 0x19, 0xdf, 0xeb, 0x40,
    0x0,

    /* U+03B1 "α" */
    0x0, 0x3a, 0xef, 0xd7, 0xf, 0xf0, 0x6f, 0xfe,
    0xce, 0xfc, 0xff, 0x3f, 0xf5, 0x0, 0x5, 0xff,
    0xfa, 0xf7, 0x0, 0x0, 0x6, 0xff, 0xef, 0x10,
    0x0, 0x0, 0xf, 0xff, 0xf0, 0x0, 0x0, 0x0,
    0xff, 0xef, 0x10, 0x0, 0x0, 0x1f, 0xfa, 0xf7,
    0x0, 0x0, 0x7, 0xff, 0x3f, 0xf6, 0x0, 0x5,
    0xff, 0xf0, 0x6f, 0xfe, 0xce, 0xfc, 0xef, 0x0,
    0x3a, 0xef, 0xd7, 0xd, 0xf0,

    /* U+03B2 "β" */
    0x0, 0x4, 0xae, 0xfe, 0x91, 0x0, 0x0, 0x9f,
    0xfe, 0xce, 0xfc, 0x0, 0x7, 0xfe, 0x40, 0x0,
    0xdf, 0x30, 0xf, 0xf2, 0x0, 0x0, 0xdf, 0x20,
    0x5f, 0xb0, 0x0, 0xb, 0xfb, 0x0, 0x7f, 0x80,
    0x0, 0xaf, 0xc0, 0x0, 0x7f, 0x70, 0xa, 0xff,
    0xfc, 0x50, 0x8f, 0x70, 0xaf, 0xc7, 0x9f, 0xf4,
    0x8f, 0x7a, 0xfa, 0x0, 0x5, 0xfb, 0x8f, 0xef,
    0x90, 0x0, 0x2, 0xfd, 0x8f, 0xf8, 0x0, 0x0,
    0x6, 0xfd, 0x8f, 0xf6, 0x0, 0x0, 0x5e, 0xf8,
    0x8f, 0xff, 0xfd, 0xdf, 0xff, 0xe1, 0x8f, 0x98,
    0xce, 0xff, 0xd9, 0x10, 0x8f, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0x70, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x70,
    0x0, 0x0, 0x0, 0x0,

    /* U+03B3 "γ" */
    0x3f, 0xd0, 0x0, 0x0, 0x6, 0xf9, 0xc, 0xf4,
    0x0, 0x0, 0xc, 0xf2, 0x4, 0xfb, 0x0, 0x0,
    0x3f, 0xb0, 0x0, 0xdf, 0x20, 0x0, 0xaf, 0x40,
    0x0, 0x6f, 0x90, 0x2, 0xfc, 0x0, 0x0, 0xe,
    0xf1, 0x8, 0xf5, 0x0, 0x0, 0x7, 0xf7, 0xf,
    0xd0, 0x0, 0x0, 0x1, 0xfe, 0x7f, 0x60, 0x0,
    0x0, 0x0, 0x9f, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xf2, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf2,
    0x0, 0x0,

    /* U+03B4 "δ" */
    0x0, 0x0, 0x57, 0x75, 0x10, 0x0, 0x0, 0x5e,
    0xff, 0xff, 0xf9, 0x0, 0x2, 0xff, 0x74, 0x46,
    0xb5, 0x0, 0x5, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xef, 0x95, 0x30, 0x0, 0x0, 0x0, 0x7f,
    0xff, 0xff, 0x90, 0x0, 0x6, 0xfe, 0x85, 0x6c,
    0xfd, 0x10, 0x2f, 0xe1, 0x0, 0x0, 0x8f, 0x90,
    0x9f, 0x60, 0x0, 0x0, 0xe, 0xf0, 0xcf, 0x20,
    0x0, 0x0, 0xc, 0xf2, 0xbf, 0x30, 0x0, 0x0,
    0xd, 0xf2, 0x8f, 0x90, 0x0, 0x0, 0x2f, 0xe0,
    0x1f, 0xf7, 0x0, 0x3, 0xdf, 0x70, 0x4, 0xff,
    0xec, 0xdf, 0xfa, 0x0, 0x0, 0x29, 0xdf, 0xeb,
    0x50, 0x0,

    /* U+03B5 "ε" */
    0x0, 0x18, 0xdf, 0xfd, 0xa5, 0x0, 0x1e, 0xfd,
    0xa9, 0xbe, 0xd0, 0x9, 0xf9, 0x0, 0x0, 0x2,
    0x0, 0x9f, 0x60, 0x0, 0x0, 0x0, 0x3, 0xef,
    0x98, 0x88, 0x30, 0x0, 0x1b, 0xff, 0xff, 0xf7,
    0x0, 0xc, 0xf7, 0x10, 0x0, 0x0, 0x1, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xf5, 0x0, 0x0,
    0x2a, 0x10, 0x6f, 0xfd, 0xbb, 0xdf, 0xf5, 0x0,
    0x4a, 0xef, 0xfd, 0x93, 0x0,

    /* U+03B6 "ζ" */
    0x1f, 0xff, 0xff, 0xff, 0xd0, 0xcc, 0xcc, 0xcf,
    0xfd, 0x0, 0x0, 0x5, 0xff, 0x30, 0x0, 0x3,
    0xff, 0x60, 0x0, 0x1, 0xdf, 0x90, 0x0, 0x0,
    0xbf, 0xc0, 0x0, 0x0, 0x6f, 0xe1, 0x0, 0x0,
    0x1f, 0xf4, 0x0, 0x0, 0xa, 0xfa, 0x0, 0x0,
    0x1, 0xff, 0x20, 0x0, 0x0, 0x6f, 0xd0, 0x0,
    0x0, 0x6, 0xff, 0x40, 0x0, 0x0, 0x2f, 0xff,
    0xfe, 0xd6, 0x0, 0x2a, 0xef, 0xff, 0xf5, 0x0,
    0x0, 0x1, 0xcf, 0x90, 0x0, 0x0, 0x7, 0xf8,
    0x0, 0x0, 0x0, 0xaf, 0x50, 0x0, 0x0, 0x1f,
    0xf0,

    /* U+03B7 "η" */
    0x3f, 0xa2, 0x9e, 0xfe, 0x91, 0x3, 0xfc, 0xff,
    0xdd, 0xff, 0xd0, 0x3f, 0xfc, 0x20, 0x2, 0xdf,
    0x73, 0xff, 0x20, 0x0, 0x4, 0xfc, 0x3f, 0xd0,
    0x0, 0x0, 0x1f, 0xe3, 0xfb, 0x0, 0x0, 0x0,
    0xfe, 0x3f, 0xb0, 0x0, 0x0, 0xf, 0xe3, 0xfb,
    0x0, 0x0, 0x0, 0xfe, 0x3f, 0xb0, 0x0, 0x0,
    0xf, 0xe3, 0xfb, 0x0, 0x0, 0x0, 0xfe, 0x3f,
    0xb0, 0x0, 0x0, 0xf, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0xfe, 0x0, 0x0, 0x0, 0x0, 0xf, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xe0,

    /* U+03B8 "θ" */
    0x0, 0x0, 0x6c, 0xef, 0xea, 0x30, 0x0, 0x0,
    0xc, 0xff, 0xed, 0xff, 0xf7, 0x0, 0x0, 0xbf,
    0xc3, 0x0, 0x6, 0xff, 0x50, 0x4, 0xfe, 0x10,
    0x0, 0x0, 0x5f, 0xe0, 0xb, 0xf7, 0x0, 0x0,
    0x0, 0xc, 0xf5, 0xe, 0xf1, 0x0, 0x0, 0x0,
    0x7, 0xf8, 0xf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfa, 0xf, 0xfe, 0xee, 0xee, 0xee, 0xee, 0xfa,
    0xe, 0xf1, 0x0, 0x0, 0x0, 0x7, 0xf8, 0xb,
    0xf6, 0x0, 0x0, 0x0, 0xc, 0xf5, 0x4, 0xfe,
    0x10, 0x0, 0x0, 0x5f, 0xe0, 0x0, 0xbf, 0xc3,
    0x0, 0x6, 0xff, 0x50, 0x0, 0xb, 0xff, 0xed,
    0xff, 0xf7, 0x0, 0x0, 0x0, 0x6c, 0xef, 0xea,
    0x30, 0x0,

    /* U+03B9 "ι" */
    0x2f, 0xc2, 0xfc, 0x2f, 0xc2, 0xfc, 0x2f, 0xc2,
    0xfc, 0x2f, 0xc2, 0xfc, 0x2f, 0xc2, 0xfc, 0x2f,
    0xc0,

    /* U+03BA "κ" */
    0x3f, 0xb0, 0x0, 0x2, 0xdf, 0x50, 0x3f, 0xb0,
    0x0, 0x2e, 0xf6, 0x0, 0x3f, 0xb0, 0x2, 0xef,
    0x60, 0x0, 0x3f, 0xb0, 0x3e, 0xf7, 0x0, 0x0,
    0x3f, 0xb3, 0xff, 0x90, 0x0, 0x0, 0x3f, 0xef,
    0xff, 0xe1, 0x0, 0x0, 0x3f, 0xff, 0x59, 0xfc,
    0x0, 0x0, 0x3f, 0xf5, 0x0, 0xcf, 0x90, 0x0,
    0x3f, 0xb0, 0x0, 0x1e, 0xf5, 0x0, 0x3f, 0xb0,
    0x0, 0x4, 0xff, 0x20, 0x3f, 0xb0, 0x0, 0x0,
    0x7f, 0xd0,

    /* U+03BB "λ" */
    0x1, 0x57, 0x40, 0x0, 0x0, 0x0, 0x3, 0xff,
    0xff, 0xc0, 0x0, 0x0, 0x0, 0xa, 0x53, 0xaf,
    0x90, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0xff, 0x70, 0x0, 0x0, 0x0, 0xa,
    0xf4, 0xed, 0x0, 0x0, 0x0, 0x2, 0xfd, 0x8,
    0xf5, 0x0, 0x0, 0x0, 0x9f, 0x60, 0x1f, 0xc0,
    0x0, 0x0, 0x1f, 0xe0, 0x0, 0xaf, 0x30, 0x0,
    0x7, 0xf8, 0x0, 0x3, 0xfa, 0x0, 0x0, 0xef,
    0x10, 0x0, 0xc, 0xf1, 0x0, 0x5f, 0xa0, 0x0,
    0x0, 0x5f, 0x80, 0xc, 0xf3, 0x0, 0x0, 0x0,
    0xdf, 0x0,

    /* U+03BC "μ" */
    0x4f, 0xa0, 0x0, 0x0, 0x3f, 0xb4, 0xfa, 0x0,
    0x0, 0x3, 0xfb, 0x4f, 0xa0, 0x0, 0x0, 0x3f,
    0xb4, 0xfa, 0x0, 0x0, 0x3, 0xfb, 0x4f, 0xa0,
    0x0, 0x0, 0x3f, 0xb4, 0xfa, 0x0, 0x0, 0x3,
    0xfb, 0x4f, 0xb0, 0x0, 0x0, 0x4f, 0xb4, 0xfd,
    0x0, 0x0, 0x9, 0xfb, 0x4f, 0xf7, 0x0, 0x4,
    0xff, 0xb4, 0xff, 0xfd, 0xac, 0xfd, 0xfb, 0x4f,
    0xa7, 0xdf, 0xd8, 0x2f, 0xb4, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xa0, 0x0, 0x0, 0x0, 0x4,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xa0, 0x0,
    0x0, 0x0, 0x0,

    /* U+03BD "ν" */
    0x3f, 0xc0, 0x0, 0x0, 0x4, 0xfa, 0xc, 0xf3,
    0x0, 0x0, 0xa, 0xf3, 0x5, 0xfa, 0x0, 0x0,
    0x1f, 0xc0, 0x0, 0xef, 0x10, 0x0, 0x8f, 0x50,
    0x0, 0x8f, 0x70, 0x0, 0xee, 0x0, 0x0, 0x1f,
    0xd0, 0x6, 0xf8, 0x0, 0x0, 0xa, 0xf4, 0xc,
    0xf1, 0x0, 0x0, 0x4, 0xfb, 0x3f, 0xa0, 0x0,
    0x0, 0x0, 0xdf, 0xbf, 0x30, 0x0, 0x0, 0x0,
    0x6f, 0xfd, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf6,
    0x0, 0x0,

    /* U+03BE "ξ" */
    0xe, 0xff, 0xff, 0xff, 0xa0, 0xef, 0xff, 0xff,
    0xf9, 0x0, 0xaf, 0x92, 0x0, 0x0, 0x8f, 0xa0,
    0x0, 0x0, 0xa, 0xf9, 0x0, 0x0, 0x0, 0x8f,
    0xf6, 0x21, 0x10, 0x0, 0xae, 0xff, 0xfd, 0x0,
    0x3c, 0xff, 0xff, 0xd0, 0xe, 0xf9, 0x30, 0x0,
    0x4, 0xfb, 0x0, 0x0, 0x0, 0x5f, 0xa0, 0x0,
    0x0, 0x2, 0xff, 0x50, 0x0, 0x0, 0xb, 0xff,
    0xfe, 0xd7, 0x0, 0x8, 0xdf, 0xff, 0xf5, 0x0,
    0x0, 0x1, 0xbf, 0x80, 0x0, 0x0, 0x7, 0xf8,
    0x0, 0x0, 0x0, 0xaf, 0x50, 0x0, 0x0, 0xf,
    0xf0,

    /* U+03BF "ο" */
    0x0, 0x3, 0xae, 0xfd, 0x91, 0x0, 0x0, 0x7f,
    0xfd, 0xce, 0xfe, 0x40, 0x4, 0xfe, 0x40, 0x0,
    0x7f, 0xe1, 0xc, 0xf4, 0x0, 0x0, 0x9, 0xf7,
    0xf, 0xe0, 0x0, 0x0, 0x3, 0xfb, 0x2f, 0xc0,
    0x0, 0x0, 0x1, 0xfd, 0xf, 0xe0, 0x0, 0x0,
    0x3, 0xfb, 0xc, 0xf4, 0x0, 0x0, 0x9, 0xf7,
    0x4, 0xfe, 0x40, 0x0, 0x7f, 0xe1, 0x0, 0x7f,
    0xfd, 0xce, 0xfe, 0x30, 0x0, 0x3, 0xae, 0xfd,
    0x91, 0x0,

    /* U+03C0 "π" */
    0x5f, 0xff, 0xff, 0xff, 0xff, 0xb5, 0xfd, 0xaa,
    0xaa, 0xab, 0xfb, 0x5f, 0x90, 0x0, 0x0, 0x3f,
    0xb5, 0xf9, 0x0, 0x0, 0x3, 0xfb, 0x5f, 0x90,
    0x0, 0x0, 0x3f, 0xb5, 0xf9, 0x0, 0x0, 0x3,
    0xfb, 0x5f, 0x90, 0x0, 0x0, 0x3f, 0xb5, 0xf9,
    0x0, 0x0, 0x3, 0xfb, 0x5f, 0x90, 0x0, 0x0,
    0x3f, 0xb5, 0xf9, 0x0, 0x0, 0x3, 0xfb, 0x5f,
    0x90, 0x0, 0x0, 0x3f, 0xb0,

    /* U+03C1 "ρ" */
    0x0, 0x2, 0x9e, 0xfe, 0x92, 0x0, 0x0, 0x5f,
    0xfe, 0xce, 0xff, 0x50, 0x2, 0xff, 0x50, 0x0,
    0x5f, 0xf2, 0xa, 0xf7, 0x0, 0x0, 0x7, 0xf9,
    0xe, 0xf0, 0x0, 0x0, 0x0, 0xfe, 0xf, 0xf0,
    0x0, 0x0, 0x0, 0xff, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0xfe, 0xf, 0xf7, 0x0, 0x0, 0x7, 0xf9,
    0xf, 0xff, 0x50, 0x0, 0x5f, 0xf2, 0xf, 0xff,
    0xfe, 0xce, 0xff, 0x50, 0xf, 0xe2, 0xae, 0xfe,
    0xa2, 0x0, 0xf, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xe0, 0x0, 0x0,
    0x0, 0x0,

    /* U+03C2 "ς" */
    0x0, 0x6c, 0xff, 0xea, 0x50, 0x8, 0xff, 0xcb,
    0xdf, 0xd0, 0x1f, 0xe1, 0x0, 0x2, 0x30, 0x2f,
    0xd0, 0x0, 0x0, 0x0, 0xd, 0xfc, 0x73, 0x0,
    0x0, 0x1, 0xbf, 0xff, 0xfb, 0x30, 0x0, 0x1,
    0x47, 0xcf, 0xf2, 0x0, 0x0, 0x0, 0x9, 0xf6,
    0x9, 0x30, 0x0, 0xb, 0xf5, 0x5f, 0xfe, 0xbb,
    0xef, 0xc0, 0x4, 0xae, 0xff, 0xd7, 0x0,

    /* U+03C3 "σ" */
    0x0, 0x3, 0xae, 0xff, 0xff, 0xff, 0xb0, 0x7,
    0xff, 0xdc, 0xef, 0xfa, 0x74, 0x4, 0xfe, 0x40,
    0x0, 0x7f, 0xe0, 0x0, 0xcf, 0x40, 0x0, 0x0,
    0x9f, 0x70, 0xf, 0xe0, 0x0, 0x0, 0x3, 0xfb,
    0x2, 0xfc, 0x0, 0x0, 0x0, 0x1f, 0xd0, 0xf,
    0xe0, 0x0, 0x0, 0x3, 0xfb, 0x0, 0xcf, 0x40,
    0x0, 0x0, 0x9f, 0x70, 0x4, 0xfe, 0x40, 0x0,
    0x7f, 0xe1, 0x0, 0x7, 0xff, 0xdc, 0xef, 0xe3,
    0x0, 0x0, 0x3, 0xae, 0xfd, 0x91, 0x0, 0x0,

    /* U+03C4 "τ" */
    0xaf, 0xff, 0xff, 0xff, 0xff, 0x66, 0xaa, 0xad,
    0xfc, 0xaa, 0xa4, 0x0, 0x0, 0x9f, 0x50, 0x0,
    0x0, 0x0, 0x9, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0x50, 0x0, 0x0, 0x0, 0x9, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0x50, 0x0, 0x0, 0x0,
    0x9, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x50,
    0x0, 0x0, 0x0, 0x9, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x9f, 0x50, 0x0, 0x0,

    /* U+03C5 "υ" */
    0x4f, 0xa0, 0x0, 0x0, 0x3f, 0xb4, 0xfa, 0x0,
    0x0, 0x3, 0xfb, 0x4f, 0xa0, 0x0, 0x0, 0x3f,
    0xb4, 0xfa, 0x0, 0x0, 0x3, 0xfb, 0x4f, 0xa0,
    0x0, 0x0, 0x3f, 0xb4, 0xfa, 0x0, 0x0, 0x3,
    0xfb, 0x3f, 0xb0, 0x0, 0x0, 0x4f, 0xa1, 0xfe,
    0x0, 0x0, 0x8, 0xf7, 0xb, 0xfa, 0x0, 0x4,
    0xff, 0x20, 0x1e, 0xff, 0xcd, 0xff, 0x70, 0x0,
    0x19, 0xdf, 0xeb, 0x40, 0x0,

    /* U+03C6 "φ" */
    0x0, 0x0, 0x0, 0x7, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0x9d, 0xff, 0xff, 0xd8, 0x10, 0x0,
    0x0, 0x5f, 0xfe, 0xcf, 0xfc, 0xff, 0xe3, 0x0,
    0x3, 0xff, 0x60, 0xf, 0xd0, 0x8, 0xfe, 0x10,
    0xb, 0xf7, 0x0, 0xf, 0xd0, 0x0, 0x9f, 0x80,
    0xf, 0xf0, 0x0, 0xf, 0xd0, 0x0, 0x2f, 0xd0,
    0x1f, 0xd0, 0x0, 0xf, 0xd0, 0x0, 0xf, 0xf0,
    0xf, 0xe0, 0x0, 0xf, 0xd0, 0x0, 0x1f, 0xe0,
    0xc, 0xf6, 0x0, 0xf, 0xd0, 0x0, 0x8f, 0x90,
    0x4, 0xff, 0x60, 0xf, 0xd0, 0x7, 0xff, 0x20,
    0x0, 0x5f, 0xfe, 0xcf, 0xfc, 0xef, 0xe4, 0x0,
    0x0, 0x2, 0x9d, 0xff, 0xff, 0xd9, 0x10, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xe0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xe0, 0x0, 0x0, 0x0,

    /* U+03C7 "χ" */
    0x3f, 0xd0, 0x0, 0x0, 0xcf, 0x40, 0xbf, 0x50,
    0x0, 0x5f, 0xb0, 0x2, 0xfd, 0x0, 0xd, 0xf2,
    0x0, 0x9, 0xf5, 0x5, 0xf9, 0x0, 0x0, 0x1f,
    0xd0, 0xdf, 0x10, 0x0, 0x0, 0x8f, 0xaf, 0x80,
    0x0, 0x0, 0x0, 0xef, 0xe0, 0x0, 0x0, 0x0,
    0x9, 0xf9, 0x0, 0x0, 0x0, 0x1, 0xff, 0xf1,
    0x0, 0x0, 0x0, 0x9f, 0x8f, 0x90, 0x0, 0x0,
    0x2f, 0xc0, 0xcf, 0x30, 0x0, 0xb, 0xf3, 0x3,
    0xfc, 0x0, 0x4, 0xfb, 0x0, 0xb, 0xf5, 0x0,
    0xdf, 0x30, 0x0, 0x3f, 0xd0, 0x7f, 0xa0, 0x0,
    0x0, 0xaf, 0x70,

    /* U+03C8 "ψ" */
    0x0, 0x0, 0x0, 0x27, 0x40, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0x90, 0x0, 0x0, 0x1, 0xff,
    0x0, 0x4, 0xf9, 0x0, 0xa, 0xf6, 0x2f, 0xe0,
    0x0, 0x4f, 0x90, 0x0, 0x9f, 0x72, 0xfd, 0x0,
    0x4, 0xf9, 0x0, 0x8, 0xf7, 0x2f, 0xc0, 0x0,
    0x4f, 0x90, 0x0, 0x7f, 0x72, 0xfd, 0x0, 0x4,
    0xf9, 0x0, 0x8, 0xf7, 0xf, 0xf0, 0x0, 0x4f,
    0x90, 0x0, 0xaf, 0x50, 0xcf, 0x40, 0x4, 0xf9,
    0x0, 0xf, 0xf1, 0x6, 0xfe, 0x10, 0x4f, 0x90,
    0xa, 0xfb, 0x0, 0xc, 0xfe, 0x66, 0xfa, 0x5c,
    0xff, 0x20, 0x0, 0x1b, 0xff, 0xff, 0xff, 0xfe,
    0x40, 0x0, 0x0, 0x5, 0xbe, 0xff, 0xc7, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xfa, 0x0, 0x0, 0x0,

    /* U+03C9 "ω" */
    0x0, 0x5, 0x0, 0x0, 0x0, 0x0, 0x5, 0x0,
    0x0, 0xc, 0xf1, 0x0, 0x0, 0x0, 0x1, 0xfd,
    0x0, 0x6, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x1c,
    0xf8, 0x0, 0xcf, 0x40, 0x0, 0x48, 0x40, 0x0,
    0x2f, 0xd0, 0xf, 0xd0, 0x0, 0x7, 0xf8, 0x0,
    0x0, 0xdf, 0x11, 0xfb, 0x0, 0x0, 0x7f, 0x80,
    0x0, 0xc, 0xf2, 0x1f, 0xc0, 0x0, 0x8, 0xf8,
    0x0, 0x0, 0xcf, 0x20, 0xff, 0x10, 0x0, 0xcf,
    0xa0, 0x0, 0x1f, 0xf0, 0x9, 0xfc, 0x32, 0x8f,
    0xff, 0x62, 0x5d, 0xfa, 0x0, 0x1d, 0xff, 0xff,
    0xf4, 0xff, 0xff, 0xfe, 0x20, 0x0, 0x1a, 0xef,
    0xb3, 0x4, 0xcf, 0xe9, 0x10, 0x0,

    /* U+03CA "ϊ" */
    0x44, 0x0, 0x62, 0xff, 0x3, 0xfb, 0x66, 0x0,
    0x83, 0x0, 0x0, 0x0, 0x2, 0xfc, 0x0, 0x2,
    0xfc, 0x0, 0x2, 0xfc, 0x0, 0x2, 0xfc, 0x0,
    0x2, 0xfc, 0x0, 0x2, 0xfc, 0x0, 0x2, 0xfc,
    0x0, 0x2, 0xfc, 0x0, 0x2, 0xfc, 0x0, 0x2,
    0xfc, 0x0, 0x2, 0xfc, 0x0,

    /* U+03CB "ϋ" */
    0x0, 0x5, 0x40, 0x6, 0x20, 0x0, 0x0, 0xfe,
    0x5, 0xfa, 0x0, 0x0, 0x6, 0x50, 0x8, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xa0,
    0x0, 0x0, 0x3f, 0xb4, 0xfa, 0x0, 0x0, 0x3,
    0xfb, 0x4f, 0xa0, 0x0, 0x0, 0x3f, 0xb4, 0xfa,
    0x0, 0x0, 0x3, 0xfb, 0x4f, 0xa0, 0x0, 0x0,
    0x3f, 0xb4, 0xfa, 0x0, 0x0, 0x3, 0xfb, 0x3f,
    0xb0, 0x0, 0x0, 0x4f, 0xa1, 0xfe, 0x0, 0x0,
    0x8, 0xf7, 0xb, 0xfa, 0x0, 0x4, 0xff, 0x20,
    0x1e, 0xff, 0xcd, 0xff, 0x70, 0x0, 0x19, 0xdf,
    0xeb, 0x40, 0x0,

    /* U+03CC "ό" */
    0x0, 0x0, 0x0, 0xcf, 0x40, 0x0, 0x0, 0x0,
    0x1, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x3, 0xa2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xae, 0xfd, 0x91, 0x0, 0x0, 0x7f,
    0xfd, 0xce, 0xfe, 0x40, 0x4, 0xfe, 0x40, 0x0,
    0x7f, 0xe1, 0xc, 0xf4, 0x0, 0x0, 0x9, 0xf7,
    0xf, 0xe0, 0x0, 0x0, 0x3, 0xfb, 0x2f, 0xc0,
    0x0, 0x0, 0x1, 0xfd, 0xf, 0xe0, 0x0, 0x0,
    0x3, 0xfb, 0xc, 0xf4, 0x0, 0x0, 0x9, 0xf7,
    0x4, 0xfe, 0x40, 0x0, 0x7f, 0xe1, 0x0, 0x7f,
    0xfd, 0xce, 0xfe, 0x30, 0x0, 0x3, 0xae, 0xfd,
    0x91, 0x0,

    /* U+03CD "ύ" */
    0x0, 0x0, 0x5, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0x20, 0x0, 0x0, 0x0, 0xa, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xa0,
    0x0, 0x0, 0x3f, 0xa4, 0xfa, 0x0, 0x0, 0x3,
    0xfa, 0x4f, 0xa0, 0x0, 0x0, 0x3f, 0xa4, 0xfa,
    0x0, 0x0, 0x3, 0xfa, 0x4f, 0xa0, 0x0, 0x0,
    0x3f, 0xa4, 0xfa, 0x0, 0x0, 0x3, 0xfa, 0x3f,
    0xb0, 0x0, 0x0, 0x5f, 0x91, 0xfe, 0x0, 0x0,
    0x8, 0xf7, 0xb, 0xf9, 0x0, 0x4, 0xff, 0x10,
    0x2e, 0xff, 0xcd, 0xff, 0x60, 0x0, 0x19, 0xdf,
    0xeb, 0x40, 0x0,

    /* U+03CE "ώ" */
    0x0, 0x0, 0x0, 0x0, 0x9f, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xa5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3, 0x0, 0x0, 0x0, 0x0,
    0x3, 0x0, 0x0, 0xb, 0xf1, 0x0, 0x0, 0x0,
    0x1, 0xfc, 0x0, 0x5, 0xfd, 0x10, 0x0, 0x0,
    0x0, 0x1d, 0xf7, 0x0, 0xcf, 0x20, 0x0, 0x36,
    0x30, 0x0, 0x2f, 0xd0, 0xf, 0xb0, 0x0, 0x7,
    0xf8, 0x0, 0x0, 0xdf, 0x11, 0xfa, 0x0, 0x0,
    0x7f, 0x80, 0x0, 0xc, 0xf2, 0x1f, 0xc0, 0x0,
    0x8, 0xf8, 0x0, 0x0, 0xcf, 0x20, 0xef, 0x20,
    0x0, 0xcf, 0xb0, 0x0, 0x2f, 0xf0, 0x9, 0xfe,
    0x64, 0x9f, 0xff, 0x84, 0x7e, 0xfa, 0x0, 0x1d,
    0xff, 0xff, 0xf7, 0xff, 0xff, 0xfd, 0x10, 0x0,
    0x1a, 0xef, 0xc4, 0x4, 0xcf, 0xe8, 0x0, 0x0,

    /* U+0400 "Ѐ" */
    0x1, 0xcf, 0x70, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x48, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xd, 0xfd, 0xcc, 0xcc, 0xcc,
    0xc0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xd, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0xd, 0xf2, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0xff, 0xff, 0xff, 0xf3, 0xd, 0xfc, 0xcc, 0xcc,
    0xcc, 0x20, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xd,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0,
    0x0, 0x0, 0xd, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0xdc, 0xcc, 0xcc, 0xcc, 0x3d, 0xff, 0xff,
    0xff, 0xff, 0xf5,

    /* U+0401 "Ё" */
    0x0, 0x8e, 0x10, 0xcc, 0x0, 0x0, 0x9, 0xf2,
    0xe, 0xd0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xd, 0xfd, 0xcc, 0xcc, 0xcc,
    0xc0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xd, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0xd, 0xf2, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0xff, 0xff, 0xff, 0xf3, 0xd, 0xfc, 0xcc, 0xcc,
    0xcc, 0x20, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xd,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0,
    0x0, 0x0, 0xd, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0xdc, 0xcc, 0xcc, 0xcc, 0x3d, 0xff, 0xff,
    0xff, 0xff, 0xf5,

    /* U+0402 "Ђ" */
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x40, 0x0,
    0x9c, 0xcc, 0xcf, 0xfc, 0xcc, 0xcc, 0x30, 0x0,
    0x0, 0x0, 0xe, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xf2, 0x69, 0xba, 0x83, 0x0,
    0x0, 0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0xa0,
    0x0, 0x0, 0xe, 0xfa, 0x52, 0x1, 0x6f, 0xf6,
    0x0, 0x0, 0xe, 0xf0, 0x0, 0x0, 0x6, 0xfc,
    0x0, 0x0, 0xe, 0xf0, 0x0, 0x0, 0x1, 0xfd,
    0x0, 0x0, 0xe, 0xf0, 0x0, 0x0, 0x3, 0xfd,
    0x0, 0x0, 0xe, 0xf0, 0x0, 0x0, 0x1c, 0xf8,
    0x0, 0x0, 0xe, 0xf0, 0x3, 0xcc, 0xff, 0xd1,
    0x0, 0x0, 0xe, 0xf0, 0x5, 0xef, 0xe9, 0x10,

    /* U+0403 "Ѓ" */
    0x0, 0x1, 0xfe, 0x0, 0x0, 0x0, 0x6, 0xf6,
    0x0, 0x0, 0x0, 0x7, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xff,
    0xf5, 0xdf, 0xdc, 0xcc, 0xcc, 0xc4, 0xdf, 0x20,
    0x0, 0x0, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x0,
    0xdf, 0x20, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0,
    0x0, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xdf,
    0x20, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xdf, 0x20,
    0x0, 0x0, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x0,
    0xdf, 0x20, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0,
    0x0, 0x0,

    /* U+0404 "Є" */
    0x0, 0x1, 0x8d, 0xff, 0xda, 0x40, 0x0, 0x5,
    0xff, 0xfe, 0xdf, 0xff, 0xb0, 0x5, 0xff, 0x81,
    0x0, 0x3, 0xbf, 0x31, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x20, 0x7f, 0x90, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0xff, 0xff, 0xff, 0xe0, 0x0, 0xe, 0xfb, 0xaa,
    0xaa, 0xa9, 0x0, 0x0, 0xcf, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0xf7, 0x0, 0x0, 0x0, 0x4, 0x0,
    0x5f, 0xfa, 0x20, 0x0, 0x4d, 0xf4, 0x0, 0x5f,
    0xff, 0xee, 0xff, 0xfa, 0x0, 0x0, 0x18, 0xdf,
    0xfd, 0xa4, 0x0,

    /* U+0405 "Ѕ" */
    0x0, 0x5, 0xbe, 0xff, 0xc8, 0x20, 0x0, 0xbf,
    0xfd, 0xcc, 0xff, 0xf0, 0x6, 0xfd, 0x20, 0x0,
    0x5, 0x70, 0xa, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x4, 0xff,
    0x71, 0x0, 0x0, 0x0, 0x0, 0x6e, 0xff, 0xd9,
    0x40, 0x0, 0x0, 0x0, 0x5a, 0xef, 0xfe, 0x60,
    0x0, 0x0, 0x0, 0x2, 0x8f, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xfa, 0x1, 0x0, 0x0, 0x0,
    0x4, 0xfa, 0xb, 0xc4, 0x0, 0x0, 0x2c, 0xf6,
    0x9, 0xff, 0xfd, 0xcd, 0xff, 0xb0, 0x0, 0x28,
    0xcf, 0xfe, 0xb5, 0x0,

    /* U+0406 "І" */
    0xdf, 0x2d, 0xf2, 0xdf, 0x2d, 0xf2, 0xdf, 0x2d,
    0xf2, 0xdf, 0x2d, 0xf2, 0xdf, 0x2d, 0xf2, 0xdf,
    0x2d, 0xf2, 0xdf, 0x2d, 0xf2,

    /* U+0407 "Ї" */
    0x8e, 0x10, 0xcb, 0xaf, 0x20, 0xed, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0,
    0xef, 0x10, 0x0, 0xef, 0x10, 0x0, 0xef, 0x10,
    0x0, 0xef, 0x10, 0x0, 0xef, 0x10, 0x0, 0xef,
    0x10, 0x0, 0xef, 0x10, 0x0, 0xef, 0x10, 0x0,
    0xef, 0x10, 0x0, 0xef, 0x10, 0x0, 0xef, 0x10,
    0x0, 0xef, 0x10, 0x0, 0xef, 0x10,

    /* U+0408 "Ј" */
    0x3, 0xff, 0xff, 0xff, 0xc0, 0x2c, 0xcc, 0xcd,
    0xfc, 0x0, 0x0, 0x0, 0x3f, 0xc0, 0x0, 0x0,
    0x3, 0xfc, 0x0, 0x0, 0x0, 0x3f, 0xc0, 0x0,
    0x0, 0x3, 0xfc, 0x0, 0x0, 0x0, 0x3f, 0xc0,
    0x0, 0x0, 0x3, 0xfc, 0x0, 0x0, 0x0, 0x3f,
    0xc0, 0x0, 0x0, 0x3, 0xfc, 0x2, 0x0, 0x0,
    0x5f, 0xb4, 0xf6, 0x0, 0x1c, 0xf7, 0x3f, 0xfe,
    0xdf, 0xfe, 0x10, 0x29, 0xef, 0xe9, 0x10,

    /* U+0409 "Љ" */
    0x0, 0x4, 0xff, 0xff, 0xff, 0xff, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xec, 0xcc,
    0xcc, 0xff, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xf6, 0x0, 0x0, 0xb, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0x60, 0x0, 0x0,
    0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xf5, 0x0, 0x0, 0xb, 0xff, 0xaa, 0xa9, 0x96,
    0x10, 0x0, 0x0, 0x7f, 0x40, 0x0, 0x0, 0xbf,
    0xff, 0xff, 0xff, 0xff, 0x70, 0x0, 0x8, 0xf4,
    0x0, 0x0, 0xb, 0xff, 0x0, 0x0, 0x27, 0xff,
    0x40, 0x0, 0x9f, 0x30, 0x0, 0x0, 0xbf, 0xf0,
    0x0, 0x0, 0x7, 0xfb, 0x0, 0xb, 0xf1, 0x0,
    0x0, 0xb, 0xff, 0x0, 0x0, 0x0, 0x2f, 0xe0,
    0x0, 0xdf, 0x0, 0x0, 0x0, 0xbf, 0xf0, 0x0,
    0x0, 0x2, 0xfe, 0x0, 0x2f, 0xc0, 0x0, 0x0,
    0xb, 0xff, 0x0, 0x0, 0x0, 0x7f, 0xb0, 0xb,
    0xf8, 0x0, 0x0, 0x0, 0xbf, 0xf0, 0x0, 0x1,
    0x7f, 0xf6, 0xaf, 0xff, 0x10, 0x0, 0x0, 0xb,
    0xff, 0xee, 0xef, 0xff, 0xfa, 0xa, 0xfc, 0x30,
    0x0, 0x0, 0x0, 0xbf, 0xff, 0xff, 0xfe, 0xb5,
    0x0,

    /* U+040A "Њ" */
    0xdf, 0x20, 0x0, 0x0, 0x1, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xf2, 0x0, 0x0, 0x0, 0x1f,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0,
    0x0, 0x1, 0xfe, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xf2, 0x0, 0x0, 0x0, 0x1f, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x1, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xfd, 0xcc, 0xcc,
    0xcc, 0xcf, 0xfc, 0xcc, 0xcc, 0xa5, 0x0, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0xd, 0xf2, 0x0, 0x0, 0x0, 0x1f, 0xe0,
    0x0, 0x1, 0x7f, 0xf7, 0xdf, 0x20, 0x0, 0x0,
    0x1, 0xfe, 0x0, 0x0, 0x0, 0x7f, 0xcd, 0xf2,
    0x0, 0x0, 0x0, 0x1f, 0xe0, 0x0, 0x0, 0x3,
    0xfd, 0xdf, 0x20, 0x0, 0x0, 0x1, 0xfe, 0x0,
    0x0, 0x0, 0x5f, 0xcd, 0xf2, 0x0, 0x0, 0x0,
    0x1f, 0xe0, 0x0, 0x0, 0x1d, 0xf7, 0xdf, 0x20,
    0x0, 0x0, 0x1, 0xff, 0xaa, 0xaa, 0xbf, 0xfc,
    0xd, 0xf2, 0x0, 0x0, 0x0, 0x1f, 0xff, 0xff,
    0xff, 0xc7, 0x0,

    /* U+040B "Ћ" */
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0,
    0x9c, 0xcc, 0xcf, 0xfc, 0xcc, 0xcc, 0x20, 0x0,
    0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xf2, 0x7a, 0xcc, 0xa4, 0x0,
    0x0, 0x0, 0xf, 0xff, 0xff, 0xff, 0xff, 0x90,
    0x0, 0x0, 0xf, 0xfb, 0x62, 0x2, 0x8f, 0xf5,
    0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0x8, 0xfb,
    0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0x3, 0xfd,
    0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0x1, 0xfd,
    0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0x1, 0xfe,
    0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0x1, 0xfe,
    0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0x1, 0xfe,

    /* U+040C "Ќ" */
    0x0, 0x0, 0x8f, 0x80, 0x0, 0x0, 0x0, 0x0,
    0xde, 0x10, 0x0, 0x0, 0x0, 0x0, 0xa5, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0x20, 0x0, 0x0, 0xd, 0xf4, 0xdf, 0x20,
    0x0, 0x0, 0x9f, 0x80, 0xdf, 0x20, 0x0, 0x5,
    0xfc, 0x0, 0xdf, 0x20, 0x0, 0x2f, 0xe1, 0x0,
    0xdf, 0x20, 0x0, 0xcf, 0x40, 0x0, 0xdf, 0x20,
    0x8, 0xf8, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xd0,
    0x0, 0x0, 0xdf, 0xdd, 0xdf, 0xf3, 0x0, 0x0,
    0xdf, 0x20, 0x7, 0xfd, 0x0, 0x0, 0xdf, 0x20,
    0x0, 0xbf, 0x90, 0x0, 0xdf, 0x20, 0x0, 0x1e,
    0xf5, 0x0, 0xdf, 0x20, 0x0, 0x4, 0xff, 0x10,
    0xdf, 0x20, 0x0, 0x0, 0x8f, 0xc0, 0xdf, 0x20,
    0x0, 0x0, 0xc, 0xf7,

    /* U+040D "Ѝ" */
    0x0, 0x1b, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0x83, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x1, 0xef,
    0x4d, 0xf2, 0x0, 0x0, 0x0, 0xbf, 0xf4, 0xdf,
    0x20, 0x0, 0x0, 0x7f, 0xff, 0x4d, 0xf2, 0x0,
    0x0, 0x4f, 0xfd, 0xf4, 0xdf, 0x20, 0x0, 0x1e,
    0xf5, 0xbf, 0x4d, 0xf2, 0x0, 0xc, 0xf8, 0xb,
    0xf4, 0xdf, 0x20, 0x9, 0xfc, 0x0, 0xbf, 0x4d,
    0xf2, 0x5, 0xfe, 0x10, 0xb, 0xf4, 0xdf, 0x22,
    0xff, 0x30, 0x0, 0xbf, 0x4d, 0xf2, 0xdf, 0x70,
    0x0, 0xb, 0xf4, 0xdf, 0xcf, 0xb0, 0x0, 0x0,
    0xbf, 0x4d, 0xff, 0xd0, 0x0, 0x0, 0xb, 0xf4,
    0xdf, 0xf3, 0x0, 0x0, 0x0, 0xbf, 0x4d, 0xf6,
    0x0, 0x0, 0x0, 0xb, 0xf4,

    /* U+040E "Ў" */
    0x0, 0x4, 0x60, 0x0, 0x18, 0x10, 0x0, 0x0,
    0x6, 0xf5, 0x1, 0xaf, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xff, 0xd4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x11, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xb0, 0x0, 0x0, 0x0,
    0xa, 0xf5, 0xd, 0xf3, 0x0, 0x0, 0x0, 0x2f,
    0xc0, 0x5, 0xfb, 0x0, 0x0, 0x0, 0xbf, 0x40,
    0x0, 0xcf, 0x40, 0x0, 0x3, 0xfb, 0x0, 0x0,
    0x4f, 0xc0, 0x0, 0xc, 0xf2, 0x0, 0x0, 0xb,
    0xf5, 0x0, 0x4f, 0x90, 0x0, 0x0, 0x2, 0xfd,
    0x0, 0xdf, 0x10, 0x0, 0x0, 0x0, 0xaf, 0x56,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xde, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1d, 0xf5, 0x0, 0x0, 0x0, 0x1,
    0xec, 0xff, 0x90, 0x0, 0x0, 0x0, 0x3, 0xdf,
    0xe7, 0x0, 0x0, 0x0, 0x0,

    /* U+040F "Џ" */
    0xdf, 0x20, 0x0, 0x0, 0x0, 0xff, 0xdf, 0x20,
    0x0, 0x0, 0x0, 0xff, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0xff, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xff,
    0xdf, 0x20, 0x0, 0x0, 0x0, 0xff, 0xdf, 0x20,
    0x0, 0x0, 0x0, 0xff, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0xff, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xff,
    0xdf, 0x20, 0x0, 0x0, 0x0, 0xff, 0xdf, 0x20,
    0x0, 0x0, 0x0, 0xff, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0xff, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xff,
    0xdf, 0xdc, 0xcc, 0xcc, 0xcc, 0xff, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0xd, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x6, 0x70, 0x0, 0x0,

    /* U+0410 "А" */
    0x0, 0x0, 0x0, 0xaf, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xff, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xf9, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xfe, 0xd, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0x70, 0x6f, 0x90, 0x0, 0x0, 0x0, 0xe,
    0xf1, 0x0, 0xef, 0x10, 0x0, 0x0, 0x6, 0xf9,
    0x0, 0x8, 0xf7, 0x0, 0x0, 0x0, 0xdf, 0x20,
    0x0, 0x1f, 0xe0, 0x0, 0x0, 0x4f, 0xb0, 0x0,
    0x0, 0xaf, 0x60, 0x0, 0xb, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0x0, 0x3, 0xfe, 0xaa, 0xaa, 0xaa,
    0xae, 0xf5, 0x0, 0xaf, 0x60, 0x0, 0x0, 0x0,
    0x5f, 0xc0, 0x1f, 0xe0, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0x38, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xfa,

    /* U+0411 "Б" */
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xb0, 0xdf, 0xcc,
    0xcc, 0xcc, 0xcc, 0x80, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0x20, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xaa,
    0xaa, 0x98, 0x61, 0x0, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0x50, 0xdf, 0x20, 0x0, 0x2, 0x9f, 0xf2,
    0xdf, 0x20, 0x0, 0x0, 0xa, 0xf7, 0xdf, 0x20,
    0x0, 0x0, 0x6, 0xf9, 0xdf, 0x20, 0x0, 0x0,
    0x8, 0xf8, 0xdf, 0x20, 0x0, 0x0, 0x3f, 0xf3,
    0xdf, 0xaa, 0xaa, 0xac, 0xff, 0x80, 0xdf, 0xff,
    0xff, 0xfe, 0xb4, 0x0,

    /* U+0412 "В" */
    0xdf, 0xff, 0xff, 0xfd, 0xa3, 0x0, 0xdf, 0xaa,
    0xaa, 0xad, 0xff, 0x60, 0xdf, 0x20, 0x0, 0x0,
    0x7f, 0xe0, 0xdf, 0x20, 0x0, 0x0, 0xf, 0xf0,
    0xdf, 0x20, 0x0, 0x0, 0x1f, 0xe0, 0xdf, 0x20,
    0x0, 0x3, 0xcf, 0x60, 0xdf, 0xff, 0xff, 0xff,
    0xf7, 0x0, 0xdf, 0xa9, 0x99, 0x9a, 0xef, 0x90,
    0xdf, 0x20, 0x0, 0x0, 0xb, 0xf6, 0xdf, 0x20,
    0x0, 0x0, 0x5, 0xfb, 0xdf, 0x20, 0x0, 0x0,
    0x5, 0xfb, 0xdf, 0x20, 0x0, 0x0, 0x1c, 0xf8,
    0xdf, 0xaa, 0xaa, 0xab, 0xff, 0xd1, 0xdf, 0xff,
    0xff, 0xff, 0xc7, 0x0,

    /* U+0413 "Г" */
    0xdf, 0xff, 0xff, 0xff, 0xf5, 0xdf, 0xdc, 0xcc,
    0xcc, 0xc4, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xdf,
    0x20, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xdf, 0x20,
    0x0, 0x0, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x0,
    0xdf, 0x20, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0,
    0x0, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xdf,
    0x20, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0xdf, 0x20, 0x0, 0x0, 0x0,

    /* U+0414 "Д" */
    0x0, 0x6, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x0,
    0x0, 0x6, 0xfd, 0xcc, 0xcc, 0xce, 0xf7, 0x0,
    0x0, 0x7, 0xf5, 0x0, 0x0, 0x8, 0xf7, 0x0,
    0x0, 0x7, 0xf4, 0x0, 0x0, 0x8, 0xf7, 0x0,
    0x0, 0x8, 0xf3, 0x0, 0x0, 0x8, 0xf7, 0x0,
    0x0, 0x9, 0xf2, 0x0, 0x0, 0x8, 0xf7, 0x0,
    0x0, 0xa, 0xf1, 0x0, 0x0, 0x8, 0xf7, 0x0,
    0x0, 0xb, 0xf0, 0x0, 0x0, 0x8, 0xf7, 0x0,
    0x0, 0xd, 0xf0, 0x0, 0x0, 0x8, 0xf7, 0x0,
    0x0, 0xf, 0xc0, 0x0, 0x0, 0x8, 0xf7, 0x0,
    0x0, 0x5f, 0x80, 0x0, 0x0, 0x8, 0xf7, 0x0,
    0x0, 0xcf, 0x10, 0x0, 0x0, 0x8, 0xf7, 0x0,
    0x9e, 0xfe, 0xcc, 0xcc, 0xcc, 0xce, 0xfe, 0xc6,
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8,
    0xbf, 0x20, 0x0, 0x0, 0x0, 0x0, 0x5, 0xf8,
    0xbf, 0x20, 0x0, 0x0, 0x0, 0x0, 0x5, 0xf8,
    0xbf, 0x20, 0x0, 0x0, 0x0, 0x0, 0x5, 0xf8,
    0x12, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x21,

    /* U+0415 "Е" */
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xd, 0xfd, 0xcc,
    0xcc, 0xcc, 0xc0, 0xdf, 0x20, 0x0, 0x0, 0x0,
    0xd, 0xf2, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x20,
    0x0, 0x0, 0x0, 0xd, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0xdf, 0xff, 0xff, 0xff, 0xf3, 0xd, 0xfc,
    0xcc, 0xcc, 0xcc, 0x20, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0xd, 0xf2, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0x20, 0x0, 0x0, 0x0, 0xd, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0xdc, 0xcc, 0xcc, 0xcc, 0x3d,
    0xff, 0xff, 0xff, 0xff, 0xf5,

    /* U+0416 "Ж" */
    0x1e, 0xf2, 0x0, 0x0, 0xb, 0xf4, 0x0, 0x0,
    0x9, 0xf8, 0x0, 0x5f, 0xc0, 0x0, 0x0, 0xbf,
    0x40, 0x0, 0x3, 0xfd, 0x0, 0x0, 0xbf, 0x60,
    0x0, 0xb, 0xf4, 0x0, 0x0, 0xdf, 0x40, 0x0,
    0x1, 0xff, 0x10, 0x0, 0xbf, 0x40, 0x0, 0x7f,
    0x90, 0x0, 0x0, 0x6, 0xfa, 0x0, 0xb, 0xf4,
    0x0, 0x2f, 0xe1, 0x0, 0x0, 0x0, 0xc, 0xf4,
    0x0, 0xbf, 0x40, 0xb, 0xf5, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xfe, 0xdd, 0xff, 0xdd,
    0xdf, 0xf2, 0x0, 0x0, 0x0, 0x2, 0xff, 0x30,
    0xb, 0xf4, 0x0, 0xaf, 0xb0, 0x0, 0x0, 0x0,
    0xcf, 0x90, 0x0, 0xbf, 0x40, 0x1, 0xef, 0x50,
    0x0, 0x0, 0x6f, 0xe0, 0x0, 0xb, 0xf4, 0x0,
    0x5, 0xfe, 0x10, 0x0, 0x1f, 0xf4, 0x0, 0x0,
    0xbf, 0x40, 0x0, 0xb, 0xf9, 0x0, 0xa, 0xfa,
    0x0, 0x0, 0xb, 0xf4, 0x0, 0x0, 0x2f, 0xf4,
    0x4, 0xff, 0x10, 0x0, 0x0, 0xbf, 0x40, 0x0,
    0x0, 0x7f, 0xd0,

    /* U+0417 "З" */
    0x0, 0x6b, 0xef, 0xfd, 0x81, 0x0, 0xb, 0xff,
    0xed, 0xdf, 0xff, 0x40, 0x4, 0x61, 0x0, 0x1,
    0x9f, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0xc0, 0x0, 0x7,
    0xaa, 0xbd, 0xfc, 0x20, 0x0, 0xb, 0xff, 0xff,
    0xfa, 0x10, 0x0, 0x0, 0x0, 0x2, 0x8f, 0xd1,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xfa, 0x1, 0x0, 0x0, 0x0,
    0xa, 0xf9, 0xe, 0x81, 0x0, 0x0, 0x8f, 0xf2,
    0x2d, 0xff, 0xdb, 0xcf, 0xff, 0x50, 0x0, 0x6b,
    0xff, 0xfd, 0x92, 0x0,

    /* U+0418 "И" */
    0xdf, 0x20, 0x0, 0x0, 0x1, 0xef, 0x4d, 0xf2,
    0x0, 0x0, 0x0, 0xbf, 0xf4, 0xdf, 0x20, 0x0,
    0x0, 0x7f, 0xff, 0x4d, 0xf2, 0x0, 0x0, 0x4f,
    0xfd, 0xf4, 0xdf, 0x20, 0x0, 0x1e, 0xf5, 0xbf,
    0x4d, 0xf2, 0x0, 0xc, 0xf8, 0xb, 0xf4, 0xdf,
    0x20, 0x8, 0xfc, 0x0, 0xbf, 0x4d, 0xf2, 0x5,
    0xfe, 0x10, 0xb, 0xf4, 0xdf, 0x22, 0xff, 0x40,
    0x0, 0xbf, 0x4d, 0xf3, 0xdf, 0x70, 0x0, 0xb,
    0xf4, 0xdf, 0xcf, 0xb0, 0x0, 0x0, 0xbf, 0x4d,
    0xff, 0xd1, 0x0, 0x0, 0xb, 0xf4, 0xdf, 0xf3,
    0x0, 0x0, 0x0, 0xbf, 0x4d, 0xf6, 0x0, 0x0,
    0x0, 0xb, 0xf4,

    /* U+0419 "Й" */
    0x0, 0x2f, 0x70, 0x3, 0xf7, 0x0, 0x0, 0x0,
    0x6e, 0xff, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x1, 0xef,
    0x4d, 0xf2, 0x0, 0x0, 0x0, 0xbf, 0xf4, 0xdf,
    0x20, 0x0, 0x0, 0x7f, 0xff, 0x4d, 0xf2, 0x0,
    0x0, 0x4f, 0xfd, 0xf4, 0xdf, 0x20, 0x0, 0x1e,
    0xf5, 0xbf, 0x4d, 0xf2, 0x0, 0xc, 0xf8, 0xb,
    0xf4, 0xdf, 0x20, 0x9, 0xfc, 0x0, 0xbf, 0x4d,
    0xf2, 0x5, 0xfe, 0x10, 0xb, 0xf4, 0xdf, 0x22,
    0xff, 0x30, 0x0, 0xbf, 0x4d, 0xf2, 0xdf, 0x70,
    0x0, 0xb, 0xf4, 0xdf, 0xcf, 0xb0, 0x0, 0x0,
    0xbf, 0x4d, 0xff, 0xd0, 0x0, 0x0, 0xb, 0xf4,
    0xdf, 0xf3, 0x0, 0x0, 0x0, 0xbf, 0x4d, 0xf6,
    0x0, 0x0, 0x0, 0xb, 0xf4,

    /* U+041A "К" */
    0xdf, 0x20, 0x0, 0x0, 0xd, 0xf4, 0xdf, 0x20,
    0x0, 0x0, 0x9f, 0x80, 0xdf, 0x20, 0x0, 0x5,
    0xfc, 0x0, 0xdf, 0x20, 0x0, 0x1e, 0xe1, 0x0,
    0xdf, 0x20, 0x0, 0xcf, 0x40, 0x0, 0xdf, 0x20,
    0x8, 0xf8, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xd0,
    0x0, 0x0, 0xdf, 0xdd, 0xdf, 0xf3, 0x0, 0x0,
    0xdf, 0x20, 0x6, 0xfd, 0x0, 0x0, 0xdf, 0x20,
    0x0, 0xbf, 0xa0, 0x0, 0xdf, 0x20, 0x0, 0x1e,
    0xf5, 0x0, 0xdf, 0x20, 0x0, 0x3, 0xff, 0x20,
    0xdf, 0x20, 0x0, 0x0, 0x8f, 0xc0, 0xdf, 0x20,
    0x0, 0x0, 0xc, 0xf8,

    /* U+041B "Л" */
    0x0, 0x4, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0,
    0x4, 0xfe, 0xcc, 0xcc, 0xcd, 0xfa, 0x0, 0x5,
    0xf6, 0x0, 0x0, 0x5, 0xfa, 0x0, 0x5, 0xf6,
    0x0, 0x0, 0x5, 0xfa, 0x0, 0x6, 0xf5, 0x0,
    0x0, 0x5, 0xfa, 0x0, 0x6, 0xf5, 0x0, 0x0,
    0x5, 0xfa, 0x0, 0x7, 0xf4, 0x0, 0x0, 0x5,
    0xfa, 0x0, 0x9, 0xf3, 0x0, 0x0, 0x5, 0xfa,
    0x0, 0xb, 0xf2, 0x0, 0x0, 0x5, 0xfa, 0x0,
    0xd, 0xf0, 0x0, 0x0, 0x5, 0xfa, 0x0, 0x2f,
    0xc0, 0x0, 0x0, 0x5, 0xfa, 0x0, 0xbf, 0x80,
    0x0, 0x0, 0x5, 0xfa, 0x9f, 0xff, 0x10, 0x0,
    0x0, 0x5, 0xfa, 0xaf, 0xd4, 0x0, 0x0, 0x0,
    0x5, 0xfa,

    /* U+041C "М" */
    0xdf, 0x20, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf0,
    0xdf, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xf1,
    0xdf, 0xf4, 0x0, 0x0, 0x0, 0x1, 0xff, 0xf1,
    0xdf, 0xfd, 0x0, 0x0, 0x0, 0xa, 0xff, 0xf1,
    0xdf, 0x9f, 0x70, 0x0, 0x0, 0x3f, 0xbd, 0xf1,
    0xdf, 0x2e, 0xf1, 0x0, 0x0, 0xcf, 0x2d, 0xf1,
    0xdf, 0x15, 0xfa, 0x0, 0x6, 0xf8, 0xd, 0xf1,
    0xdf, 0x10, 0xbf, 0x40, 0xe, 0xe0, 0xd, 0xf1,
    0xdf, 0x10, 0x2f, 0xd0, 0x8f, 0x50, 0xd, 0xf1,
    0xdf, 0x10, 0x8, 0xf9, 0xfb, 0x0, 0xd, 0xf1,
    0xdf, 0x10, 0x0, 0xef, 0xf2, 0x0, 0xd, 0xf1,
    0xdf, 0x10, 0x0, 0x5f, 0x80, 0x0, 0xd, 0xf1,
    0xdf, 0x10, 0x0, 0x4, 0x0, 0x0, 0xd, 0xf1,
    0xdf, 0x10, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf1,

    /* U+041D "Н" */
    0xdf, 0x20, 0x0, 0x0, 0x0, 0xcf, 0x3d, 0xf2,
    0x0, 0x0, 0x0, 0xc, 0xf3, 0xdf, 0x20, 0x0,
    0x0, 0x0, 0xcf, 0x3d, 0xf2, 0x0, 0x0, 0x0,
    0xc, 0xf3, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xcf,
    0x3d, 0xf2, 0x0, 0x0, 0x0, 0xc, 0xf3, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x3d, 0xfd, 0xcc,
    0xcc, 0xcc, 0xcf, 0xf3, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0xcf, 0x3d, 0xf2, 0x0, 0x0, 0x0, 0xc,
    0xf3, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xcf, 0x3d,
    0xf2, 0x0, 0x0, 0x0, 0xc, 0xf3, 0xdf, 0x20,
    0x0, 0x0, 0x0, 0xcf, 0x3d, 0xf2, 0x0, 0x0,
    0x0, 0xc, 0xf3,

    /* U+041E "О" */
    0x0, 0x0, 0x7c, 0xef, 0xeb, 0x60, 0x0, 0x0,
    0x4, 0xef, 0xfe, 0xde, 0xff, 0xe3, 0x0, 0x5,
    0xff, 0x92, 0x0, 0x3, 0xbf, 0xf3, 0x1, 0xff,
    0x60, 0x0, 0x0, 0x0, 0x8f, 0xe0, 0x8f, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0x6d, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xfb, 0xff, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0xdf, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xfd, 0xdf, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xb8, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xf6, 0x1f, 0xf6, 0x0, 0x0, 0x0,
    0x8, 0xfe, 0x0, 0x5f, 0xfa, 0x20, 0x0, 0x3b,
    0xff, 0x30, 0x0, 0x4e, 0xff, 0xed, 0xff, 0xfe,
    0x30, 0x0, 0x0, 0x7, 0xce, 0xfe, 0xb6, 0x0,
    0x0,

    /* U+041F "П" */
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x3d, 0xfd,
    0xcc, 0xcc, 0xcc, 0xcf, 0xf3, 0xdf, 0x20, 0x0,
    0x0, 0x0, 0xbf, 0x3d, 0xf2, 0x0, 0x0, 0x0,
    0xb, 0xf3, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xbf,
    0x3d, 0xf2, 0x0, 0x0, 0x0, 0xb, 0xf3, 0xdf,
    0x20, 0x0, 0x0, 0x0, 0xbf, 0x3d, 0xf2, 0x0,
    0x0, 0x0, 0xb, 0xf3, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0xbf, 0x3d, 0xf2, 0x0, 0x0, 0x0, 0xb,
    0xf3, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xbf, 0x3d,
    0xf2, 0x0, 0x0, 0x0, 0xb, 0xf3, 0xdf, 0x20,
    0x0, 0x0, 0x0, 0xbf, 0x3d, 0xf2, 0x0, 0x0,
    0x0, 0xb, 0xf3,

    /* U+0420 "Р" */
    0xdf, 0xff, 0xff, 0xec, 0x70, 0x0, 0xdf, 0xdc,
    0xcc, 0xef, 0xfe, 0x20, 0xdf, 0x20, 0x0, 0x2,
    0xbf, 0xd0, 0xdf, 0x20, 0x0, 0x0, 0xd, 0xf3,
    0xdf, 0x20, 0x0, 0x0, 0x9, 0xf6, 0xdf, 0x20,
    0x0, 0x0, 0xa, 0xf6, 0xdf, 0x20, 0x0, 0x0,
    0x1e, 0xf2, 0xdf, 0x20, 0x0, 0x15, 0xdf, 0xb0,
    0xdf, 0xff, 0xff, 0xff, 0xfb, 0x0, 0xdf, 0xdc,
    0xcc, 0xb9, 0x40, 0x0, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0x20, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x20,
    0x0, 0x0, 0x0, 0x0,

    /* U+0421 "С" */
    0x0, 0x0, 0x7c, 0xef, 0xeb, 0x50, 0x0, 0x4,
    0xef, 0xfe, 0xde, 0xff, 0xd1, 0x5, 0xff, 0xa2,
    0x0, 0x3, 0xbf, 0x61, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x30, 0x8f, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0x10, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0xf6, 0x0, 0x0, 0x0, 0x3, 0x0,
    0x5f, 0xfa, 0x20, 0x0, 0x3b, 0xf6, 0x0, 0x4e,
    0xff, 0xed, 0xff, 0xfc, 0x10, 0x0, 0x7, 0xce,
    0xfe, 0xb5, 0x0,

    /* U+0422 "Т" */
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x9c, 0xcc,
    0xcf, 0xfc, 0xcc, 0xca, 0x0, 0x0, 0xf, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xf0, 0x0, 0x0,

    /* U+0423 "У" */
    0x6f, 0xb0, 0x0, 0x0, 0x0, 0x9, 0xf5, 0xd,
    0xf3, 0x0, 0x0, 0x0, 0x2f, 0xc0, 0x5, 0xfc,
    0x0, 0x0, 0x0, 0xaf, 0x40, 0x0, 0xcf, 0x40,
    0x0, 0x3, 0xfb, 0x0, 0x0, 0x3f, 0xc0, 0x0,
    0xc, 0xf3, 0x0, 0x0, 0xb, 0xf5, 0x0, 0x4f,
    0xa0, 0x0, 0x0, 0x2, 0xfd, 0x0, 0xdf, 0x10,
    0x0, 0x0, 0x0, 0x9f, 0x65, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x1f, 0xdd, 0xe1, 0x0, 0x0, 0x0,
    0x0, 0x8, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1d,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0xec, 0xff, 0x90,
    0x0, 0x0, 0x0, 0x3, 0xdf, 0xe8, 0x0, 0x0,
    0x0, 0x0,

    /* U+0424 "Ф" */
    0x0, 0x0, 0x0, 0x0, 0x47, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x49, 0xde, 0xff, 0xfe,
    0xc7, 0x10, 0x0, 0x0, 0x1b, 0xff, 0xdb, 0xef,
    0xbb, 0xff, 0xe5, 0x0, 0x0, 0xcf, 0xb2, 0x0,
    0xaf, 0x30, 0x6, 0xff, 0x50, 0x7, 0xfb, 0x0,
    0x0, 0xaf, 0x30, 0x0, 0x4f, 0xe0, 0xd, 0xf3,
    0x0, 0x0, 0xaf, 0x30, 0x0, 0xa, 0xf5, 0xf,
    0xf0, 0x0, 0x0, 0xaf, 0x30, 0x0, 0x6, 0xf8,
    0xf, 0xe0, 0x0, 0x0, 0xaf, 0x30, 0x0, 0x5,
    0xf9, 0xf, 0xf0, 0x0, 0x0, 0xaf, 0x30, 0x0,
    0x7, 0xf7, 0xb, 0xf5, 0x0, 0x0, 0xaf, 0x30,
    0x0, 0xd, 0xf3, 0x4, 0xfe, 0x30, 0x0, 0xaf,
    0x30, 0x0, 0x9f, 0xc0, 0x0, 0x7f, 0xf9, 0x30,
    0xaf, 0x31, 0x5c, 0xfe, 0x10, 0x0, 0x4, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0x91, 0x0, 0x0, 0x0,
    0x3, 0x78, 0xdf, 0xa8, 0x51, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0x30, 0x0, 0x0, 0x0,

    /* U+0425 "Х" */
    0x1e, 0xf5, 0x0, 0x0, 0x1, 0xff, 0x40, 0x4,
    0xfe, 0x10, 0x0, 0xc, 0xf9, 0x0, 0x0, 0x9f,
    0xc0, 0x0, 0x7f, 0xd0, 0x0, 0x0, 0xd, 0xf7,
    0x3, 0xff, 0x30, 0x0, 0x0, 0x3, 0xff, 0x4d,
    0xf7, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0xff, 0x70, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xcf, 0xf2, 0x0, 0x0, 0x0,
    0x7, 0xfd, 0x9, 0xfd, 0x0, 0x0, 0x0, 0x3f,
    0xf2, 0x0, 0xdf, 0x80, 0x0, 0x0, 0xdf, 0x60,
    0x0, 0x2f, 0xf4, 0x0, 0x9, 0xfb, 0x0, 0x0,
    0x6, 0xfe, 0x10, 0x4f, 0xe1, 0x0, 0x0, 0x0,
    0xbf, 0xa0,

    /* U+0426 "Ц" */
    0xdf, 0x20, 0x0, 0x0, 0x0, 0xff, 0x0, 0xd,
    0xf2, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0, 0xdf,
    0x20, 0x0, 0x0, 0x0, 0xff, 0x0, 0xd, 0xf2,
    0x0, 0x0, 0x0, 0xf, 0xf0, 0x0, 0xdf, 0x20,
    0x0, 0x0, 0x0, 0xff, 0x0, 0xd, 0xf2, 0x0,
    0x0, 0x0, 0xf, 0xf0, 0x0, 0xdf, 0x20, 0x0,
    0x0, 0x0, 0xff, 0x0, 0xd, 0xf2, 0x0, 0x0,
    0x0, 0xf, 0xf0, 0x0, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0xff, 0x0, 0xd, 0xf2, 0x0, 0x0, 0x0,
    0xf, 0xf0, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x0,
    0xff, 0x0, 0xd, 0xf2, 0x0, 0x0, 0x0, 0xf,
    0xf0, 0x0, 0xdf, 0xdc, 0xcc, 0xcc, 0xcc, 0xff,
    0xcc, 0x1d, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0x80,

    /* U+0427 "Ч" */
    0xef, 0x10, 0x0, 0x0, 0x7, 0xf8, 0xef, 0x10,
    0x0, 0x0, 0x7, 0xf8, 0xef, 0x10, 0x0, 0x0,
    0x7, 0xf8, 0xef, 0x10, 0x0, 0x0, 0x7, 0xf8,
    0xef, 0x20, 0x0, 0x0, 0x7, 0xf8, 0xcf, 0x60,
    0x0, 0x0, 0x7, 0xf8, 0x7f, 0xf5, 0x0, 0x0,
    0x4c, 0xf8, 0xc, 0xff, 0xfd, 0xef, 0xff, 0xf8,
    0x0, 0x6c, 0xef, 0xeb, 0x78, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xf8,

    /* U+0428 "Ш" */
    0xdf, 0x20, 0x0, 0x0, 0xff, 0x0, 0x0, 0x3,
    0xfb, 0xdf, 0x20, 0x0, 0x0, 0xff, 0x0, 0x0,
    0x3, 0xfb, 0xdf, 0x20, 0x0, 0x0, 0xff, 0x0,
    0x0, 0x3, 0xfb, 0xdf, 0x20, 0x0, 0x0, 0xff,
    0x0, 0x0, 0x3, 0xfb, 0xdf, 0x20, 0x0, 0x0,
    0xff, 0x0, 0x0, 0x3, 0xfb, 0xdf, 0x20, 0x0,
    0x0, 0xff, 0x0, 0x0, 0x3, 0xfb, 0xdf, 0x20,
    0x0, 0x0, 0xff, 0x0, 0x0, 0x3, 0xfb, 0xdf,
    0x20, 0x0, 0x0, 0xff, 0x0, 0x0, 0x3, 0xfb,
    0xdf, 0x20, 0x0, 0x0, 0xff, 0x0, 0x0, 0x3,
    0xfb, 0xdf, 0x20, 0x0, 0x0, 0xff, 0x0, 0x0,
    0x3, 0xfb, 0xdf, 0x20, 0x0, 0x0, 0xff, 0x0,
    0x0, 0x3, 0xfb, 0xdf, 0x20, 0x0, 0x0, 0xff,
    0x0, 0x0, 0x3, 0xfb, 0xdf, 0xdc, 0xcc, 0xcc,
    0xff, 0xcc, 0xcc, 0xcd, 0xfb, 0xdf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfb,

    /* U+0429 "Щ" */
    0xdf, 0x20, 0x0, 0x0, 0xfe, 0x0, 0x0, 0x4,
    0xfb, 0x0, 0xdf, 0x20, 0x0, 0x0, 0xfe, 0x0,
    0x0, 0x4, 0xfb, 0x0, 0xdf, 0x20, 0x0, 0x0,
    0xfe, 0x0, 0x0, 0x4, 0xfb, 0x0, 0xdf, 0x20,
    0x0, 0x0, 0xfe, 0x0, 0x0, 0x4, 0xfb, 0x0,
    0xdf, 0x20, 0x0, 0x0, 0xfe, 0x0, 0x0, 0x4,
    0xfb, 0x0, 0xdf, 0x20, 0x0, 0x0, 0xfe, 0x0,
    0x0, 0x4, 0xfb, 0x0, 0xdf, 0x20, 0x0, 0x0,
    0xfe, 0x0, 0x0, 0x4, 0xfb, 0x0, 0xdf, 0x20,
    0x0, 0x0, 0xfe, 0x0, 0x0, 0x4, 0xfb, 0x0,
    0xdf, 0x20, 0x0, 0x0, 0xfe, 0x0, 0x0, 0x4,
    0xfb, 0x0, 0xdf, 0x20, 0x0, 0x0, 0xfe, 0x0,
    0x0, 0x4, 0xfb, 0x0, 0xdf, 0x20, 0x0, 0x0,
    0xfe, 0x0, 0x0, 0x4, 0xfb, 0x0, 0xdf, 0x20,
    0x0, 0x0, 0xfe, 0x0, 0x0, 0x4, 0xfb, 0x0,
    0xdf, 0xcc, 0xcc, 0xcc, 0xff, 0xcc, 0xcc, 0xcf,
    0xff, 0xc9, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xfc,

    /* U+042A "Ъ" */
    0xbf, 0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x9c, 0xcc, 0xef, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x70, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0xca, 0xaa, 0x99, 0x61, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0xff, 0xff, 0xff, 0x50,
    0x0, 0x0, 0x8f, 0x70, 0x0, 0x2, 0x9f, 0xf2,
    0x0, 0x0, 0x8f, 0x70, 0x0, 0x0, 0xa, 0xf8,
    0x0, 0x0, 0x8f, 0x70, 0x0, 0x0, 0x5, 0xfb,
    0x0, 0x0, 0x8f, 0x70, 0x0, 0x0, 0x4, 0xfb,
    0x0, 0x0, 0x8f, 0x70, 0x0, 0x0, 0x8, 0xf9,
    0x0, 0x0, 0x8f, 0x70, 0x0, 0x0, 0x4f, 0xf3,
    0x0, 0x0, 0x8f, 0xca, 0xaa, 0xad, 0xff, 0x80,
    0x0, 0x0, 0x8f, 0xff, 0xff, 0xfe, 0xb4, 0x0,

    /* U+042B "Ы" */
    0xdf, 0x20, 0x0, 0x0, 0x0, 0x0, 0x5, 0xfa,
    0xdf, 0x20, 0x0, 0x0, 0x0, 0x0, 0x5, 0xfa,
    0xdf, 0x20, 0x0, 0x0, 0x0, 0x0, 0x5, 0xfa,
    0xdf, 0x20, 0x0, 0x0, 0x0, 0x0, 0x5, 0xfa,
    0xdf, 0xaa, 0xaa, 0x98, 0x40, 0x0, 0x5, 0xfa,
    0xdf, 0xff, 0xff, 0xff, 0xfd, 0x20, 0x5, 0xfa,
    0xdf, 0x20, 0x0, 0x14, 0xcf, 0xd0, 0x5, 0xfa,
    0xdf, 0x20, 0x0, 0x0, 0xe, 0xf3, 0x5, 0xfa,
    0xdf, 0x20, 0x0, 0x0, 0xa, 0xf6, 0x5, 0xfa,
    0xdf, 0x20, 0x0, 0x0, 0x9, 0xf6, 0x5, 0xfa,
    0xdf, 0x20, 0x0, 0x0, 0xd, 0xf4, 0x5, 0xfa,
    0xdf, 0x20, 0x0, 0x0, 0x8f, 0xe0, 0x5, 0xfa,
    0xdf, 0xaa, 0xaa, 0xbe, 0xff, 0x40, 0x5, 0xfa,
    0xdf, 0xff, 0xff, 0xfd, 0x92, 0x0, 0x5, 0xfa,

    /* U+042C "Ь" */
    0xdf, 0x20, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x20,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0xaa, 0xaa, 0x98, 0x40, 0x0, 0xdf, 0xff,
    0xff, 0xff, 0xfd, 0x20, 0xdf, 0x20, 0x0, 0x14,
    0xcf, 0xd0, 0xdf, 0x20, 0x0, 0x0, 0xd, 0xf4,
    0xdf, 0x20, 0x0, 0x0, 0x9, 0xf7, 0xdf, 0x20,
    0x0, 0x0, 0x9, 0xf7, 0xdf, 0x20, 0x0, 0x0,
    0xc, 0xf4, 0xdf, 0x20, 0x0, 0x0, 0x8f, 0xe0,
    0xdf, 0xaa, 0xaa, 0xbe, 0xff, 0x40, 0xdf, 0xff,
    0xff, 0xfd, 0x92, 0x0,

    /* U+042D "Э" */
    0x0, 0x39, 0xdf, 0xfd, 0x92, 0x0, 0x0, 0x9,
    0xff, 0xfe, 0xef, 0xff, 0x70, 0x0, 0x2e, 0xd5,
    0x0, 0x1, 0x7f, 0xf7, 0x0, 0x2, 0x0, 0x0,
    0x0, 0x3, 0xff, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x8f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xe0, 0x0, 0x0, 0xcf, 0xff, 0xff, 0xff,
    0xf0, 0x0, 0x0, 0x8b, 0xbb, 0xbb, 0xbf, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xa0, 0x2, 0x10,
    0x0, 0x0, 0x4, 0xff, 0x20, 0x2e, 0xd5, 0x0,
    0x1, 0x8f, 0xf7, 0x0, 0x9, 0xff, 0xfe, 0xef,
    0xff, 0x70, 0x0, 0x0, 0x39, 0xdf, 0xfd, 0x92,
    0x0, 0x0,

    /* U+042E "Ю" */
    0xdf, 0x20, 0x0, 0x0, 0x4a, 0xef, 0xec, 0x71,
    0x0, 0xd, 0xf2, 0x0, 0x0, 0xaf, 0xfd, 0xbc,
    0xff, 0xf5, 0x0, 0xdf, 0x20, 0x0, 0xbf, 0xd3,
    0x0, 0x0, 0x7f, 0xf5, 0xd, 0xf2, 0x0, 0x6f,
    0xd0, 0x0, 0x0, 0x0, 0x4f, 0xe1, 0xdf, 0x20,
    0xd, 0xf4, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x7d,
    0xf2, 0x2, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xfb, 0xdf, 0xff, 0xff, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x2f, 0xdd, 0xfe, 0xee, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xfd, 0xdf, 0x20, 0x2f, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0xbd, 0xf2, 0x0,
    0xef, 0x50, 0x0, 0x0, 0x0, 0xb, 0xf7, 0xdf,
    0x20, 0x7, 0xfe, 0x20, 0x0, 0x0, 0x7, 0xfe,
    0x1d, 0xf2, 0x0, 0xb, 0xfe, 0x60, 0x0, 0x29,
    0xff, 0x40, 0xdf, 0x20, 0x0, 0xa, 0xff, 0xfe,
    0xef, 0xff, 0x50, 0xd, 0xf2, 0x0, 0x0, 0x4,
    0xae, 0xff, 0xc7, 0x10, 0x0,

    /* U+042F "Я" */
    0x0, 0x3a, 0xdf, 0xff, 0xff, 0xf7, 0x7, 0xff,
    0xfd, 0xcc, 0xce, 0xf7, 0x3f, 0xf6, 0x0, 0x0,
    0x8, 0xf7, 0xaf, 0x80, 0x0, 0x0, 0x8, 0xf7,
    0xcf, 0x40, 0x0, 0x0, 0x8, 0xf7, 0xcf, 0x40,
    0x0, 0x0, 0x8, 0xf7, 0x9f, 0x90, 0x0, 0x0,
    0x8, 0xf7, 0x2f, 0xf9, 0x20, 0x0, 0x8, 0xf7,
    0x5, 0xef, 0xff, 0xff, 0xff, 0xf7, 0x0, 0x1e,
    0xfb, 0xbb, 0xbd, 0xf7, 0x0, 0x8f, 0x80, 0x0,
    0x8, 0xf7, 0x3, 0xfd, 0x0, 0x0, 0x8, 0xf7,
    0xd, 0xf4, 0x0, 0x0, 0x8, 0xf7, 0x8f, 0x90,
    0x0, 0x0, 0x8, 0xf7,

    /* U+0430 "а" */
    0x0, 0x3, 0xae, 0xfd, 0x70, 0xfe, 0x0, 0x7f,
    0xfe, 0xce, 0xfb, 0xfe, 0x3, 0xff, 0x50, 0x0,
    0x6f, 0xfe, 0xb, 0xf6, 0x0, 0x0, 0x7, 0xfe,
    0xf, 0xf0, 0x0, 0x0, 0x1, 0xfe, 0xf, 0xe0,
    0x0, 0x0, 0x0, 0xfe, 0xf, 0xf0, 0x0, 0x0,
    0x1, 0xfe, 0xb, 0xf6, 0x0, 0x0, 0x8, 0xfe,
    0x3, 0xff, 0x50, 0x0, 0x6f, 0xfe, 0x0, 0x7f,
    0xfe, 0xce, 0xfc, 0xfe, 0x0, 0x3, 0xbe, 0xfd,
    0x70, 0xee,

    /* U+0431 "б" */
    0x0, 0x0, 0x0, 0x0, 0x3, 0x30, 0x0, 0x0,
    0x4, 0x8c, 0xff, 0xa0, 0x0, 0x8, 0xef, 0xff,
    0xea, 0x50, 0x0, 0xcf, 0xf9, 0x51, 0x0, 0x0,
    0x9, 0xfb, 0x10, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x63, 0xae, 0xfd,
    0x80, 0x0, 0xaf, 0x8f, 0xfd, 0xdf, 0xfd, 0x10,
    0xbf, 0xfa, 0x10, 0x2, 0xcf, 0xb0, 0xbf, 0xc0,
    0x0, 0x0, 0x1e, 0xf2, 0xaf, 0x70, 0x0, 0x0,
    0xa, 0xf4, 0x8f, 0x70, 0x0, 0x0, 0xa, 0xf4,
    0x4f, 0xc0, 0x0, 0x0, 0xe, 0xf1, 0xd, 0xf9,
    0x0, 0x0, 0xbf, 0xa0, 0x2, 0xef, 0xeb, 0xbf,
    0xfc, 0x0, 0x0, 0x19, 0xdf, 0xec, 0x60, 0x0,

    /* U+0432 "в" */
    0x2f, 0xff, 0xff, 0xeb, 0x40, 0x2, 0xfd, 0x88,
    0x8a, 0xff, 0x50, 0x2f, 0xb0, 0x0, 0x5, 0xfb,
    0x2, 0xfb, 0x0, 0x0, 0x3f, 0xa0, 0x2f, 0xc1,
    0x11, 0x3c, 0xf3, 0x2, 0xff, 0xff, 0xff, 0xf9,
    0x0, 0x2f, 0xd4, 0x44, 0x5a, 0xfa, 0x2, 0xfb,
    0x0, 0x0, 0xd, 0xf0, 0x2f, 0xb0, 0x0, 0x0,
    0xef, 0x12, 0xfd, 0x88, 0x89, 0xdf, 0xb0, 0x2f,
    0xff, 0xff, 0xfd, 0x80, 0x0,

    /* U+0433 "г" */
    0x2f, 0xff, 0xff, 0xff, 0xa2, 0xff, 0xbb, 0xbb,
    0xb7, 0x2f, 0xc0, 0x0, 0x0, 0x2, 0xfc, 0x0,
    0x0, 0x0, 0x2f, 0xc0, 0x0, 0x0, 0x2, 0xfc,
    0x0, 0x0, 0x0, 0x2f, 0xc0, 0x0, 0x0, 0x2,
    0xfc, 0x0, 0x0, 0x0, 0x2f, 0xc0, 0x0, 0x0,
    0x2, 0xfc, 0x0, 0x0, 0x0, 0x2f, 0xc0, 0x0,
    0x0, 0x0,

    /* U+0434 "д" */
    0x0, 0x3f, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x4,
    0xfd, 0xbb, 0xbb, 0xff, 0x0, 0x0, 0x4f, 0x70,
    0x0, 0xe, 0xf0, 0x0, 0x5, 0xf6, 0x0, 0x0,
    0xef, 0x0, 0x0, 0x6f, 0x50, 0x0, 0xe, 0xf0,
    0x0, 0x7, 0xf4, 0x0, 0x0, 0xef, 0x0, 0x0,
    0xaf, 0x20, 0x0, 0xe, 0xf0, 0x0, 0xd, 0xf0,
    0x0, 0x0, 0xef, 0x0, 0x3, 0xfa, 0x0, 0x0,
    0xe, 0xf0, 0x9, 0xff, 0xdb, 0xbb, 0xbb, 0xff,
    0xb7, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0xad,
    0xf0, 0x0, 0x0, 0x0, 0x2, 0xfa, 0xdf, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0xa6, 0x80, 0x0, 0x0,
    0x0, 0x1, 0x85,

    /* U+0435 "е" */
    0x0, 0x4, 0xbe, 0xfc, 0x60, 0x0, 0x0, 0x8f,
    0xfc, 0xbe, 0xfb, 0x0, 0x5, 0xfd, 0x20, 0x0,
    0x9f, 0x80, 0xc, 0xf3, 0x0, 0x0, 0xd, 0xf0,
    0xf, 0xe1, 0x11, 0x11, 0x18, 0xf4, 0x1f, 0xff,
    0xff, 0xff, 0xff, 0xf6, 0xf, 0xe4, 0x44, 0x44,
    0x44, 0x41, 0xc, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xfe, 0x40, 0x0, 0x2b, 0x20, 0x0, 0x7f,
    0xfe, 0xcd, 0xff, 0x60, 0x0, 0x3, 0xae, 0xfe,
    0xa3, 0x0,

    /* U+0436 "ж" */
    0x2f, 0xd0, 0x0, 0x7, 0xf7, 0x0, 0x0, 0xef,
    0x20, 0x8f, 0x70, 0x0, 0x7f, 0x70, 0x0, 0x7f,
    0x80, 0x0, 0xde, 0x10, 0x7, 0xf7, 0x0, 0x1f,
    0xe0, 0x0, 0x3, 0xf9, 0x0, 0x7f, 0x70, 0xa,
    0xf5, 0x0, 0x0, 0x9, 0xf2, 0x7, 0xf7, 0x3,
    0xfc, 0x0, 0x0, 0x0, 0x4f, 0xff, 0xff, 0xff,
    0xff, 0x30, 0x0, 0x0, 0xd, 0xfc, 0xbd, 0xfd,
    0xbc, 0xfa, 0x0, 0x0, 0x7, 0xfd, 0x0, 0x7f,
    0x70, 0xe, 0xf5, 0x0, 0x2, 0xff, 0x30, 0x7,
    0xf7, 0x0, 0x4f, 0xe1, 0x0, 0xcf, 0x80, 0x0,
    0x7f, 0x70, 0x0, 0x9f, 0xb0, 0x6f, 0xd0, 0x0,
    0x7, 0xf7, 0x0, 0x0, 0xdf, 0x60,

    /* U+0437 "з" */
    0x3, 0x9d, 0xff, 0xd8, 0x10, 0xd, 0xfd, 0xbc,
    0xff, 0xd0, 0x4, 0x20, 0x0, 0xc, 0xf6, 0x0,
    0x0, 0x0, 0x8, 0xf7, 0x0, 0x1, 0x12, 0x5e,
    0xe1, 0x0, 0x9, 0xff, 0xfe, 0x30, 0x0, 0x2,
    0x45, 0x7e, 0xf4, 0x0, 0x0, 0x0, 0x3, 0xfb,
    0x7, 0x10, 0x0, 0x8, 0xfa, 0x4f, 0xfd, 0xbc,
    0xef, 0xe2, 0x4, 0xad, 0xff, 0xd9, 0x10,

    /* U+0438 "и" */
    0x2f, 0xc0, 0x0, 0x0, 0x2f, 0xf0, 0x2f, 0xc0,
    0x0, 0x1, 0xdf, 0xf0, 0x2f, 0xc0, 0x0, 0xb,
    0xff, 0xf0, 0x2f, 0xc0, 0x0, 0x8f, 0xae, 0xf0,
    0x2f, 0xc0, 0x5, 0xfd, 0xe, 0xf0, 0x2f, 0xc0,
    0x3f, 0xe2, 0xe, 0xf0, 0x2f, 0xc1, 0xef, 0x40,
    0xe, 0xf0, 0x2f, 0xcc, 0xf7, 0x0, 0xe, 0xf0,
    0x2f, 0xff, 0xa0, 0x0, 0xe, 0xf0, 0x2f, 0xfc,
    0x0, 0x0, 0xe, 0xf0, 0x2f, 0xe1, 0x0, 0x0,
    0xe, 0xf0,

    /* U+0439 "й" */
    0x0, 0x4f, 0x0, 0x7, 0xd0, 0x0, 0x1, 0xe9,
    0x2, 0xe9, 0x0, 0x0, 0x4, 0xef, 0xfb, 0x10,
    0x0, 0x0, 0x0, 0x11, 0x0, 0x0, 0x2f, 0xc0,
    0x0, 0x0, 0x2f, 0xf2, 0xfc, 0x0, 0x0, 0x1d,
    0xff, 0x2f, 0xc0, 0x0, 0xb, 0xff, 0xf2, 0xfc,
    0x0, 0x9, 0xfa, 0xef, 0x2f, 0xc0, 0x6, 0xfc,
    0xe, 0xf2, 0xfc, 0x3, 0xfe, 0x10, 0xef, 0x2f,
    0xc1, 0xef, 0x40, 0xe, 0xf2, 0xfc, 0xcf, 0x60,
    0x0, 0xef, 0x2f, 0xff, 0x90, 0x0, 0xe, 0xf2,
    0xff, 0xc0, 0x0, 0x0, 0xef, 0x2f, 0xe1, 0x0,
    0x0, 0xe, 0xf0,

    /* U+043A "к" */
    0x2f, 0xc0, 0x0, 0x0, 0xdf, 0x22, 0xfc, 0x0,
    0x0, 0x9f, 0x70, 0x2f, 0xc0, 0x0, 0x4f, 0xb0,
    0x2, 0xfc, 0x0, 0x1e, 0xe1, 0x0, 0x2f, 0xc0,
    0xa, 0xf5, 0x0, 0x2, 0xff, 0xff, 0xfb, 0x0,
    0x0, 0x2f, 0xeb, 0xbf, 0xf3, 0x0, 0x2, 0xfc,
    0x0, 0x5f, 0xe1, 0x0, 0x2f, 0xc0, 0x0, 0x8f,
    0xc0, 0x2, 0xfc, 0x0, 0x0, 0xaf, 0x90, 0x2f,
    0xc0, 0x0, 0x0, 0xdf, 0x60,

    /* U+043B "л" */
    0x0, 0x3f, 0xff, 0xff, 0xff, 0xf0, 0x4, 0xfd,
    0xbb, 0xbb, 0xff, 0x0, 0x4f, 0x70, 0x0, 0xf,
    0xf0, 0x5, 0xf6, 0x0, 0x0, 0xff, 0x0, 0x6f,
    0x50, 0x0, 0xf, 0xf0, 0x7, 0xf3, 0x0, 0x0,
    0xff, 0x0, 0x9f, 0x20, 0x0, 0xf, 0xf0, 0xb,
    0xf0, 0x0, 0x0, 0xff, 0x1, 0xfc, 0x0, 0x0,
    0xf, 0xf8, 0xef, 0x60, 0x0, 0x0, 0xff, 0xcf,
    0x90, 0x0, 0x0, 0xf, 0xf0,

    /* U+043C "м" */
    0x2f, 0xf2, 0x0, 0x0, 0x0, 0x1e, 0xf1, 0x2f,
    0xfa, 0x0, 0x0, 0x0, 0x9f, 0xf1, 0x2f, 0xff,
    0x30, 0x0, 0x2, 0xff, 0xf1, 0x2f, 0xbf, 0xc0,
    0x0, 0xb, 0xfc, 0xf1, 0x2f, 0xa7, 0xf5, 0x0,
    0x5f, 0x7a, 0xf1, 0x2f, 0xa0, 0xde, 0x0, 0xdd,
    0xa, 0xf1, 0x2f, 0xa0, 0x5f, 0x77, 0xf4, 0xa,
    0xf1, 0x2f, 0xa0, 0xc, 0xff, 0xb0, 0xa, 0xf1,
    0x2f, 0xa0, 0x2, 0xff, 0x20, 0xa, 0xf1, 0x2f,
    0xa0, 0x0, 0x87, 0x0, 0xa, 0xf1, 0x2f, 0xa0,
    0x0, 0x0, 0x0, 0xa, 0xf1,

    /* U+043D "н" */
    0x2f, 0xc0, 0x0, 0x0, 0x3f, 0xb2, 0xfc, 0x0,
    0x0, 0x3, 0xfb, 0x2f, 0xc0, 0x0, 0x0, 0x3f,
    0xb2, 0xfc, 0x0, 0x0, 0x3, 0xfb, 0x2f, 0xc0,
    0x0, 0x0, 0x3f, 0xb2, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x2f, 0xeb, 0xbb, 0xbb, 0xcf, 0xb2, 0xfc,
    0x0, 0x0, 0x3, 0xfb, 0x2f, 0xc0, 0x0, 0x0,
    0x3f, 0xb2, 0xfc, 0x0, 0x0, 0x3, 0xfb, 0x2f,
    0xc0, 0x0, 0x0, 0x3f, 0xb0,

    /* U+043E "о" */
    0x0, 0x3, 0xae, 0xfd, 0x92, 0x0, 0x0, 0x7f,
    0xfd, 0xce, 0xff, 0x40, 0x4, 0xfe, 0x40, 0x0,
    0x7f, 0xe1, 0xc, 0xf5, 0x0, 0x0, 0x9, 0xf8,
    0xf, 0xe0, 0x0, 0x0, 0x3, 0xfc, 0x1f, 0xd0,
    0x0, 0x0, 0x1, 0xfd, 0xf, 0xe0, 0x0, 0x0,
    0x3, 0xfc, 0xc, 0xf5, 0x0, 0x0, 0x9, 0xf7,
    0x4, 0xfe, 0x40, 0x0, 0x7f, 0xe1, 0x0, 0x7f,
    0xfe, 0xce, 0xfe, 0x40, 0x0, 0x3, 0xae, 0xfd,
    0x92, 0x0,

    /* U+043F "п" */
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xb2, 0xff, 0xbb,
    0xbb, 0xbc, 0xfb, 0x2f, 0xc0, 0x0, 0x0, 0x3f,
    0xb2, 0xfc, 0x0, 0x0, 0x3, 0xfb, 0x2f, 0xc0,
    0x0, 0x0, 0x3f, 0xb2, 0xfc, 0x0, 0x0, 0x3,
    0xfb, 0x2f, 0xc0, 0x0, 0x0, 0x3f, 0xb2, 0xfc,
    0x0, 0x0, 0x3, 0xfb, 0x2f, 0xc0, 0x0, 0x0,
    0x3f, 0xb2, 0xfc, 0x0, 0x0, 0x3, 0xfb, 0x2f,
    0xc0, 0x0, 0x0, 0x3f, 0xb0,

    /* U+0440 "р" */
    0x2f, 0xb1, 0x9e, 0xfd, 0x92, 0x0, 0x2f, 0xde,
    0xfb, 0xad, 0xff, 0x40, 0x2f, 0xfd, 0x20, 0x0,
    0x6f, 0xe1, 0x2f, 0xf3, 0x0, 0x0, 0x9, 0xf7,
    0x2f, 0xd0, 0x0, 0x0, 0x3, 0xfb, 0x2f, 0xc0,
    0x0, 0x0, 0x2, 0xfc, 0x2f, 0xe0, 0x0, 0x0,
    0x4, 0xfb, 0x2f, 0xf4, 0x0, 0x0, 0xa, 0xf7,
    0x2f, 0xfe, 0x30, 0x0, 0x8f, 0xe1, 0x2f, 0xde,
    0xfd, 0xce, 0xff, 0x40, 0x2f, 0xc1, 0x8d, 0xfe,
    0x92, 0x0, 0x2f, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xc0, 0x0, 0x0,
    0x0, 0x0,

    /* U+0441 "с" */
    0x0, 0x3, 0xae, 0xfe, 0x92, 0x0, 0x7, 0xff,
    0xdc, 0xef, 0xf3, 0x4, 0xfe, 0x40, 0x0, 0x6f,
    0x60, 0xcf, 0x50, 0x0, 0x0, 0x10, 0xf, 0xe0,
    0x0, 0x0, 0x0, 0x1, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0x50, 0x0, 0x0, 0x10, 0x4, 0xfe, 0x40, 0x0,
    0x6f, 0x60, 0x7, 0xff, 0xec, 0xef, 0xe3, 0x0,
    0x3, 0xae, 0xfe, 0x91, 0x0,

    /* U+0442 "т" */
    0xef, 0xff, 0xff, 0xff, 0xfc, 0xab, 0xbb, 0xff,
    0xbb, 0xb8, 0x0, 0x0, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0xfe, 0x0, 0x0, 0x0, 0x0, 0xfe, 0x0,
    0x0, 0x0, 0x0, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0xfe, 0x0, 0x0, 0x0, 0x0, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0xfe, 0x0, 0x0, 0x0, 0x0, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0xfe, 0x0, 0x0,

    /* U+0443 "у" */
    0xb, 0xf4, 0x0, 0x0, 0x0, 0xcf, 0x10, 0x4f,
    0xb0, 0x0, 0x0, 0x3f, 0xa0, 0x0, 0xdf, 0x20,
    0x0, 0xa, 0xf3, 0x0, 0x7, 0xf8, 0x0, 0x1,
    0xfc, 0x0, 0x0, 0xf, 0xe0, 0x0, 0x7f, 0x50,
    0x0, 0x0, 0x9f, 0x60, 0xe, 0xe0, 0x0, 0x0,
    0x2, 0xfc, 0x5, 0xf8, 0x0, 0x0, 0x0, 0xb,
    0xf3, 0xcf, 0x10, 0x0, 0x0, 0x0, 0x4f, 0xcf,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x8f, 0x50, 0x0, 0x0, 0x3, 0x0,
    0x2f, 0xe0, 0x0, 0x0, 0x1, 0xfe, 0xbf, 0xf5,
    0x0, 0x0, 0x0, 0x7, 0xef, 0xd5, 0x0, 0x0,
    0x0, 0x0,

    /* U+0444 "ф" */
    0x0, 0x0, 0x0, 0xe, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0x9d, 0xff, 0xff, 0xda, 0x30, 0x0,
    0x0, 0x7f, 0xfe, 0xcf, 0xfc, 0xef, 0xf8, 0x0,
    0x5, 0xff, 0x50, 0xe, 0xf0, 0x4, 0xef, 0x60,
    0xd, 0xf4, 0x0, 0xe, 0xf0, 0x0, 0x3f, 0xe0,
    0xf, 0xe0, 0x0, 0xe, 0xf0, 0x0, 0xc, 0xf2,
    0x1f, 0xc0, 0x0, 0xe, 0xf0, 0x0, 0xb, 0xf3,
    0xf, 0xe0, 0x0, 0xe, 0xf0, 0x0, 0xc, 0xf2,
    0xc, 0xf5, 0x0, 0xe, 0xf0, 0x0, 0x3f, 0xe0,
    0x5, 0xff, 0x50, 0xe, 0xf0, 0x5, 0xef, 0x60,
    0x0, 0x7f, 0xfe, 0xbf, 0xfb, 0xef, 0xf8, 0x0,
    0x0, 0x3, 0x9d, 0xff, 0xff, 0xda, 0x30, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe, 0xf0, 0x0, 0x0, 0x0,

    /* U+0445 "х" */
    0x4f, 0xd0, 0x0, 0x1, 0xee, 0x10, 0x8f, 0x90,
    0x0, 0xcf, 0x50, 0x0, 0xcf, 0x50, 0x8f, 0x90,
    0x0, 0x1, 0xee, 0x6f, 0xc0, 0x0, 0x0, 0x4,
    0xff, 0xf2, 0x0, 0x0, 0x0, 0xd, 0xfa, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xf4, 0x0, 0x0, 0x4,
    0xfd, 0x2f, 0xe1, 0x0, 0x1, 0xef, 0x20, 0x5f,
    0xc0, 0x0, 0xbf, 0x60, 0x0, 0xaf, 0x80, 0x7f,
    0xa0, 0x0, 0x0, 0xdf, 0x40,

    /* U+0446 "ц" */
    0x2f, 0xc0, 0x0, 0x0, 0x6f, 0x80, 0x2, 0xfc,
    0x0, 0x0, 0x6, 0xf8, 0x0, 0x2f, 0xc0, 0x0,
    0x0, 0x6f, 0x80, 0x2, 0xfc, 0x0, 0x0, 0x6,
    0xf8, 0x0, 0x2f, 0xc0, 0x0, 0x0, 0x6f, 0x80,
    0x2, 0xfc, 0x0, 0x0, 0x6, 0xf8, 0x0, 0x2f,
    0xc0, 0x0, 0x0, 0x6f, 0x80, 0x2, 0xfc, 0x0,
    0x0, 0x6, 0xf8, 0x0, 0x2f, 0xc0, 0x0, 0x0,
    0x6f, 0x80, 0x2, 0xff, 0xbb, 0xbb, 0xbd, 0xfd,
    0xb2, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x5, 0x81,

    /* U+0447 "ч" */
    0x2f, 0xc0, 0x0, 0x0, 0x9f, 0x52, 0xfc, 0x0,
    0x0, 0x9, 0xf5, 0x2f, 0xc0, 0x0, 0x0, 0x9f,
    0x52, 0xfc, 0x0, 0x0, 0x9, 0xf5, 0x1f, 0xe0,
    0x0, 0x0, 0x9f, 0x50, 0xdf, 0xa2, 0x2, 0x6d,
    0xf5, 0x3, 0xef, 0xff, 0xff, 0xff, 0x50, 0x0,
    0x68, 0x86, 0x29, 0xf5, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0x50, 0x0, 0x0, 0x0, 0x9, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x9f, 0x50,

    /* U+0448 "ш" */
    0x2f, 0xc0, 0x0, 0x8, 0xf6, 0x0, 0x0, 0xff,
    0x2f, 0xc0, 0x0, 0x8, 0xf6, 0x0, 0x0, 0xff,
    0x2f, 0xc0, 0x0, 0x8, 0xf6, 0x0, 0x0, 0xff,
    0x2f, 0xc0, 0x0, 0x8, 0xf6, 0x0, 0x0, 0xff,
    0x2f, 0xc0, 0x0, 0x8, 0xf6, 0x0, 0x0, 0xff,
    0x2f, 0xc0, 0x0, 0x8, 0xf6, 0x0, 0x0, 0xff,
    0x2f, 0xc0, 0x0, 0x8, 0xf6, 0x0, 0x0, 0xff,
    0x2f, 0xc0, 0x0, 0x8, 0xf6, 0x0, 0x0, 0xff,
    0x2f, 0xc0, 0x0, 0x8, 0xf6, 0x0, 0x0, 0xff,
    0x2f, 0xfb, 0xbb, 0xbe, 0xfd, 0xbb, 0xbb, 0xff,
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,

    /* U+0449 "щ" */
    0x2f, 0xc0, 0x0, 0x9, 0xf5, 0x0, 0x0, 0xff,
    0x0, 0x2f, 0xc0, 0x0, 0x9, 0xf5, 0x0, 0x0,
    0xff, 0x0, 0x2f, 0xc0, 0x0, 0x9, 0xf5, 0x0,
    0x0, 0xff, 0x0, 0x2f, 0xc0, 0x0, 0x9, 0xf5,
    0x0, 0x0, 0xff, 0x0, 0x2f, 0xc0, 0x0, 0x9,
    0xf5, 0x0, 0x0, 0xff, 0x0, 0x2f, 0xc0, 0x0,
    0x9, 0xf5, 0x0, 0x0, 0xff, 0x0, 0x2f, 0xc0,
    0x0, 0x9, 0xf5, 0x0, 0x0, 0xff, 0x0, 0x2f,
    0xc0, 0x0, 0x9, 0xf5, 0x0, 0x0, 0xff, 0x0,
    0x2f, 0xc0, 0x0, 0x9, 0xf5, 0x0, 0x0, 0xff,
    0x0, 0x2f, 0xfb, 0xbb, 0xbe, 0xfd, 0xbb, 0xbc,
    0xff, 0xb5, 0x2f, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2, 0x84,

    /* U+044A "ъ" */
    0xef, 0xff, 0xf3, 0x0, 0x0, 0x0, 0xa, 0xbb,
    0xef, 0x30, 0x0, 0x0, 0x0, 0x0, 0xb, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x52, 0x21,
    0x0, 0x0, 0x0, 0xb, 0xff, 0xff, 0xff, 0x90,
    0x0, 0x0, 0xbf, 0x75, 0x56, 0xcf, 0xb0, 0x0,
    0xb, 0xf3, 0x0, 0x0, 0xef, 0x10, 0x0, 0xbf,
    0x30, 0x0, 0xd, 0xf2, 0x0, 0xb, 0xf3, 0x0,
    0x2, 0xff, 0x0, 0x0, 0xbf, 0x98, 0x89, 0xef,
    0x80, 0x0, 0xb, 0xff, 0xff, 0xec, 0x50, 0x0,

    /* U+044B "ы" */
    0x2f, 0xc0, 0x0, 0x0, 0x0, 0xa, 0xf4, 0x2f,
    0xc0, 0x0, 0x0, 0x0, 0xa, 0xf4, 0x2f, 0xc0,
    0x0, 0x0, 0x0, 0xa, 0xf4, 0x2f, 0xc2, 0x21,
    0x0, 0x0, 0xa, 0xf4, 0x2f, 0xff, 0xff, 0xfc,
    0x40, 0xa, 0xf4, 0x2f, 0xd5, 0x55, 0x8f, 0xf4,
    0xa, 0xf4, 0x2f, 0xc0, 0x0, 0x6, 0xfa, 0xa,
    0xf4, 0x2f, 0xc0, 0x0, 0x3, 0xfb, 0xa, 0xf4,
    0x2f, 0xc0, 0x0, 0x8, 0xf9, 0xa, 0xf4, 0x2f,
    0xe7, 0x78, 0xbf, 0xf2, 0xa, 0xf4, 0x2f, 0xff,
    0xff, 0xda, 0x20, 0xa, 0xf4,

    /* U+044C "ь" */
    0x2f, 0xc0, 0x0, 0x0, 0x0, 0x2f, 0xc0, 0x0,
    0x0, 0x0, 0x2f, 0xc0, 0x0, 0x0, 0x0, 0x2f,
    0xc2, 0x21, 0x0, 0x0, 0x2f, 0xff, 0xff, 0xfd,
    0x60, 0x2f, 0xd5, 0x55, 0x7e, 0xf6, 0x2f, 0xc0,
    0x0, 0x4, 0xfc, 0x2f, 0xc0, 0x0, 0x1, 0xfe,
    0x2f, 0xc0, 0x0, 0x6, 0xfb, 0x2f, 0xe8, 0x88,
    0xaf, 0xf4, 0x2f, 0xff, 0xff, 0xea, 0x30,

    /* U+044D "э" */
    0x1, 0x8d, 0xfe, 0xc6, 0x0, 0x3, 0xff, 0xca,
    0xae, 0xfc, 0x10, 0xb, 0x40, 0x0, 0x9, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xf3, 0x0, 0x1,
    0x22, 0x22, 0x7f, 0x80, 0x0, 0x8f, 0xff, 0xff,
    0xf9, 0x0, 0x2, 0x55, 0x55, 0x8f, 0x80, 0x0,
    0x0, 0x0, 0xa, 0xf3, 0x9, 0x30, 0x0, 0x8,
    0xfb, 0x3, 0xff, 0xca, 0xbe, 0xfc, 0x10, 0x1,
    0x8d, 0xfe, 0xc6, 0x0, 0x0,

    /* U+044E "ю" */
    0x2f, 0xc0, 0x0, 0x5, 0xbe, 0xfd, 0x70, 0x0,
    0x2f, 0xc0, 0x0, 0xaf, 0xfb, 0xad, 0xfd, 0x20,
    0x2f, 0xc0, 0x7, 0xfd, 0x20, 0x0, 0x8f, 0xc0,
    0x2f, 0xc0, 0xe, 0xf3, 0x0, 0x0, 0xb, 0xf4,
    0x2f, 0xfd, 0xdf, 0xe0, 0x0, 0x0, 0x6, 0xf8,
    0x2f, 0xff, 0xff, 0xc0, 0x0, 0x0, 0x4, 0xf9,
    0x2f, 0xc0, 0xf, 0xe0, 0x0, 0x0, 0x6, 0xf8,
    0x2f, 0xc0, 0xb, 0xf4, 0x0, 0x0, 0xc, 0xf4,
    0x2f, 0xc0, 0x3, 0xfe, 0x30, 0x0, 0x9f, 0xc0,
    0x2f, 0xc0, 0x0, 0x6f, 0xfd, 0xcf, 0xfd, 0x10,
    0x2f, 0xc0, 0x0, 0x3, 0xbe, 0xfd, 0x80, 0x0,

    /* U+044F "я" */
    0x0, 0x29, 0xdf, 0xff, 0xff, 0x50, 0x3f, 0xfe,
    0xbb, 0xbc, 0xf5, 0xb, 0xf8, 0x0, 0x0, 0x5f,
    0x50, 0xef, 0x10, 0x0, 0x5, 0xf5, 0xd, 0xf2,
    0x0, 0x0, 0x5f, 0x50, 0x7f, 0xc4, 0x21, 0x16,
    0xf5, 0x0, 0x8f, 0xff, 0xff, 0xff, 0x50, 0x0,
    0xcf, 0x64, 0x48, 0xf5, 0x0, 0x6f, 0x90, 0x0,
    0x5f, 0x50, 0x1f, 0xe0, 0x0, 0x5, 0xf5, 0xb,
    0xf5, 0x0, 0x0, 0x5f, 0x50,

    /* U+0450 "ѐ" */
    0x0, 0x17, 0x71, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0x3, 0x83, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xbe, 0xfc, 0x60, 0x0, 0x0, 0x8f, 0xfc, 0xbe,
    0xfb, 0x0, 0x5, 0xfd, 0x20, 0x0, 0x9f, 0x80,
    0xc, 0xf3, 0x0, 0x0, 0xd, 0xf0, 0xf, 0xe1,
    0x11, 0x11, 0x18, 0xf4, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0xf6, 0xf, 0xe4, 0x44, 0x44, 0x44, 0x41,
    0xc, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x4, 0xfe,
    0x40, 0x0, 0x2b, 0x20, 0x0, 0x7f, 0xfe, 0xcd,
    0xff, 0x60, 0x0, 0x3, 0xae, 0xfe, 0xa3, 0x0,

    /* U+0451 "ё" */
    0x0, 0x7, 0xe2, 0xc, 0xc0, 0x0, 0x0, 0x8,
    0xf2, 0xd, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xbe, 0xfc, 0x60, 0x0,
    0x0, 0x8f, 0xfc, 0xbe, 0xfb, 0x0, 0x5, 0xfd,
    0x20, 0x0, 0x9f, 0x80, 0xc, 0xf3, 0x0, 0x0,
    0xd, 0xf0, 0xf, 0xe1, 0x11, 0x11, 0x18, 0xf4,
    0x1f, 0xff, 0xff, 0xff, 0xff, 0xf6, 0xf, 0xe4,
    0x44, 0x44, 0x44, 0x41, 0xc, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xfe, 0x40, 0x0, 0x2b, 0x20,
    0x0, 0x7f, 0xfe, 0xcd, 0xff, 0x60, 0x0, 0x3,
    0xae, 0xfe, 0xa3, 0x0,

    /* U+0452 "ђ" */
    0x0, 0x18, 0x50, 0x0, 0x0, 0x0, 0x0, 0x13,
    0xfb, 0x11, 0x11, 0x0, 0x0, 0x3f, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0x0, 0x45, 0xfc, 0x44, 0x44,
    0x20, 0x0, 0x0, 0x2f, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xfb, 0x19, 0xef, 0xe9, 0x10, 0x0,
    0x2f, 0xde, 0xfd, 0xdf, 0xfd, 0x0, 0x2, 0xff,
    0xd2, 0x0, 0x1d, 0xf8, 0x0, 0x2f, 0xf3, 0x0,
    0x0, 0x3f, 0xc0, 0x2, 0xfe, 0x0, 0x0, 0x0,
    0xfe, 0x0, 0x2f, 0xc0, 0x0, 0x0, 0xf, 0xf0,
    0x2, 0xfc, 0x0, 0x0, 0x0, 0xff, 0x0, 0x2f,
    0xc0, 0x0, 0x0, 0xf, 0xf0, 0x2, 0xfc, 0x0,
    0x0, 0x0, 0xff, 0x0, 0x2f, 0xc0, 0x0, 0x0,
    0xf, 0xf0, 0x2, 0xfc, 0x0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xfc, 0x0, 0x0, 0x0,
    0x6, 0xdb, 0xff, 0x50, 0x0, 0x0, 0x0, 0x6d,
    0xfd, 0x60,

    /* U+0453 "ѓ" */
    0x0, 0x0, 0xdf, 0x30, 0x0, 0x0, 0x2f, 0xa0,
    0x0, 0x0, 0x4, 0xa1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xff, 0xff, 0xff, 0xa2, 0xfe,
    0xbb, 0xbb, 0xb7, 0x2f, 0xc0, 0x0, 0x0, 0x2,
    0xfc, 0x0, 0x0, 0x0, 0x2f, 0xc0, 0x0, 0x0,
    0x2, 0xfc, 0x0, 0x0, 0x0, 0x2f, 0xc0, 0x0,
    0x0, 0x2, 0xfc, 0x0, 0x0, 0x0, 0x2f, 0xc0,
    0x0, 0x0, 0x2, 0xfc, 0x0, 0x0, 0x0, 0x2f,
    0xc0, 0x0, 0x0, 0x0,

    /* U+0454 "є" */
    0x0, 0x2, 0x9d, 0xfe, 0xb5, 0x0, 0x0, 0x6f,
    0xfc, 0xab, 0xef, 0xb0, 0x3, 0xfe, 0x30, 0x0,
    0x8, 0x50, 0xb, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xd2, 0x22, 0x22, 0x0, 0x0, 0x1f, 0xff,
    0xff, 0xff, 0x0, 0x0, 0xf, 0xe5, 0x55, 0x55,
    0x0, 0x0, 0xb, 0xf3, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xfe, 0x30, 0x0, 0x8, 0x50, 0x0, 0x6f,
    0xfc, 0xab, 0xef, 0xa0, 0x0, 0x3, 0xae, 0xfe,
    0xb5, 0x0,

    /* U+0455 "ѕ" */
    0x0, 0x2a, 0xef, 0xec, 0x70, 0x3, 0xff, 0xdb,
    0xcf, 0xf2, 0xb, 0xf6, 0x0, 0x0, 0x40, 0xc,
    0xf2, 0x0, 0x0, 0x0, 0x8, 0xfe, 0x84, 0x10,
    0x0, 0x0, 0x8e, 0xff, 0xfd, 0x70, 0x0, 0x0,
    0x36, 0x9f, 0xf7, 0x0, 0x0, 0x0, 0x3, 0xfc,
    0x6, 0x50, 0x0, 0x6, 0xfa, 0xe, 0xff, 0xcb,
    0xdf, 0xf3, 0x2, 0x8d, 0xff, 0xea, 0x20,

    /* U+0456 "і" */
    0x7, 0x50, 0x6f, 0xf0, 0x3e, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xc0, 0x2f, 0xc0, 0x2f, 0xc0,
    0x2f, 0xc0, 0x2f, 0xc0, 0x2f, 0xc0, 0x2f, 0xc0,
    0x2f, 0xc0, 0x2f, 0xc0, 0x2f, 0xc0, 0x2f, 0xc0,

    /* U+0457 "ї" */
    0x6e, 0x29, 0xe1, 0x7f, 0x29, 0xe1, 0x0, 0x0,
    0x0, 0x3, 0xfb, 0x0, 0x3, 0xfb, 0x0, 0x3,
    0xfb, 0x0, 0x3, 0xfb, 0x0, 0x3, 0xfb, 0x0,
    0x3, 0xfb, 0x0, 0x3, 0xfb, 0x0, 0x3, 0xfb,
    0x0, 0x3, 0xfb, 0x0, 0x3, 0xfb, 0x0, 0x3,
    0xfb, 0x0,

    /* U+0458 "ј" */
    0x0, 0x0, 0x75, 0x0, 0x0, 0x6f, 0xf1, 0x0,
    0x3, 0xeb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0xc0, 0x0, 0x2, 0xfc,
    0x0, 0x0, 0x2f, 0xc0, 0x0, 0x2, 0xfc, 0x0,
    0x0, 0x2f, 0xc0, 0x0, 0x2, 0xfc, 0x0, 0x0,
    0x2f, 0xc0, 0x0, 0x2, 0xfc, 0x0, 0x0, 0x2f,
    0xc0, 0x0, 0x2, 0xfc, 0x0, 0x0, 0x2f, 0xc0,
    0x0, 0x2, 0xfc, 0x0, 0x0, 0x6f, 0x90, 0x8c,
    0xbf, 0xf3, 0x7, 0xef, 0xc4, 0x0,

    /* U+0459 "љ" */
    0x0, 0x3f, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xfd, 0xbb, 0xbb, 0xff, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4f, 0x60, 0x0, 0xf,
    0xf0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xf5, 0x0,
    0x0, 0xff, 0x22, 0x10, 0x0, 0x0, 0x0, 0x6f,
    0x40, 0x0, 0xf, 0xff, 0xff, 0xfe, 0x70, 0x0,
    0x7, 0xf3, 0x0, 0x0, 0xff, 0x55, 0x57, 0xdf,
    0x80, 0x0, 0x9f, 0x20, 0x0, 0xf, 0xf0, 0x0,
    0x1, 0xfe, 0x0, 0xb, 0xf0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0xf, 0xf0, 0x1, 0xfc, 0x0, 0x0,
    0xf, 0xf0, 0x0, 0x5, 0xfe, 0x8, 0xef, 0x60,
    0x0, 0x0, 0xff, 0xaa, 0xac, 0xff, 0x60, 0xdf,
    0x90, 0x0, 0x0, 0xf, 0xff, 0xff, 0xeb, 0x40,
    0x0,

    /* U+045A "њ" */
    0x2f, 0xc0, 0x0, 0x0, 0x6f, 0x80, 0x0, 0x0,
    0x0, 0x2f, 0xc0, 0x0, 0x0, 0x6f, 0x80, 0x0,
    0x0, 0x0, 0x2f, 0xc0, 0x0, 0x0, 0x6f, 0x80,
    0x0, 0x0, 0x0, 0x2f, 0xc0, 0x0, 0x0, 0x6f,
    0x80, 0x0, 0x0, 0x0, 0x2f, 0xeb, 0xbb, 0xbb,
    0xdf, 0xdb, 0xbb, 0x95, 0x0, 0x2f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x2f, 0xc0,
    0x0, 0x0, 0x6f, 0x80, 0x0, 0x3e, 0xf5, 0x2f,
    0xc0, 0x0, 0x0, 0x6f, 0x80, 0x0, 0x7, 0xf7,
    0x2f, 0xc0, 0x0, 0x0, 0x6f, 0x80, 0x0, 0xa,
    0xf5, 0x2f, 0xc0, 0x0, 0x0, 0x6f, 0xc7, 0x77,
    0xbf, 0xd0, 0x2f, 0xc0, 0x0, 0x0, 0x6f, 0xff,
    0xff, 0xd8, 0x10,

    /* U+045B "ћ" */
    0x0, 0x4, 0x30, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0xbf, 0xff, 0xff,
    0xff, 0xf8, 0x0, 0x1, 0x24, 0xfd, 0x22, 0x22,
    0x10, 0x0, 0x0, 0x2f, 0xc0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xfc, 0x19, 0xef, 0xe9, 0x10, 0x0,
    0x2f, 0xee, 0xfd, 0xdf, 0xfd, 0x0, 0x2, 0xff,
    0xd2, 0x0, 0x1d, 0xf8, 0x0, 0x2f, 0xf3, 0x0,
    0x0, 0x4f, 0xc0, 0x2, 0xfe, 0x0, 0x0, 0x0,
    0xfe, 0x0, 0x2f, 0xc0, 0x0, 0x0, 0xf, 0xf0,
    0x2, 0xfc, 0x0, 0x0, 0x0, 0xff, 0x0, 0x2f,
    0xc0, 0x0, 0x0, 0xf, 0xf0, 0x2, 0xfc, 0x0,
    0x0, 0x0, 0xff, 0x0, 0x2f, 0xc0, 0x0, 0x0,
    0xf, 0xf0, 0x2, 0xfc, 0x0, 0x0, 0x0, 0xff,

    /* U+045C "ќ" */
    0x0, 0x0, 0x8f, 0x80, 0x0, 0x0, 0x0, 0xd,
    0xe0, 0x0, 0x0, 0x0, 0x1, 0xa5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xc0,
    0x0, 0x0, 0xdf, 0x22, 0xfc, 0x0, 0x0, 0x9f,
    0x60, 0x2f, 0xc0, 0x0, 0x4f, 0xb0, 0x2, 0xfc,
    0x0, 0x1e, 0xe1, 0x0, 0x2f, 0xc0, 0xa, 0xf4,
    0x0, 0x2, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x2f,
    0xeb, 0xbf, 0xf3, 0x0, 0x2, 0xfc, 0x0, 0x6f,
    0xe1, 0x0, 0x2f, 0xc0, 0x0, 0x8f, 0xc0, 0x2,
    0xfc, 0x0, 0x0, 0xbf, 0x90, 0x2f, 0xc0, 0x0,
    0x0, 0xdf, 0x60,

    /* U+045D "ѝ" */
    0x0, 0x4e, 0xe3, 0x0, 0x0, 0x0, 0x0, 0x1b,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x6, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xc0,
    0x0, 0x0, 0x2f, 0xf2, 0xfc, 0x0, 0x0, 0x1d,
    0xff, 0x2f, 0xc0, 0x0, 0xb, 0xff, 0xf2, 0xfc,
    0x0, 0x9, 0xfa, 0xef, 0x2f, 0xc0, 0x6, 0xfc,
    0xe, 0xf2, 0xfc, 0x3, 0xfe, 0x10, 0xef, 0x2f,
    0xc1, 0xef, 0x40, 0xe, 0xf2, 0xfc, 0xcf, 0x60,
    0x0, 0xef, 0x2f, 0xff, 0x90, 0x0, 0xe, 0xf2,
    0xff, 0xc0, 0x0, 0x0, 0xef, 0x2f, 0xe1, 0x0,
    0x0, 0xe, 0xf0,

    /* U+045E "ў" */
    0x0, 0x5, 0x50, 0x0, 0x64, 0x0, 0x0, 0x0,
    0x7e, 0x30, 0x4f, 0x50, 0x0, 0x0, 0x0, 0xaf,
    0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xbf, 0x40, 0x0, 0x0, 0xc, 0xf1, 0x4,
    0xfb, 0x0, 0x0, 0x3, 0xfa, 0x0, 0xd, 0xf2,
    0x0, 0x0, 0xaf, 0x30, 0x0, 0x7f, 0x80, 0x0,
    0x1f, 0xc0, 0x0, 0x0, 0xfe, 0x0, 0x7, 0xf5,
    0x0, 0x0, 0x9, 0xf6, 0x0, 0xee, 0x0, 0x0,
    0x0, 0x2f, 0xc0, 0x5f, 0x80, 0x0, 0x0, 0x0,
    0xbf, 0x3c, 0xf1, 0x0, 0x0, 0x0, 0x4, 0xfc,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0xd, 0xff, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xf5, 0x0, 0x0, 0x0, 0x30,
    0x2, 0xfe, 0x0, 0x0, 0x0, 0x1f, 0xeb, 0xff,
    0x50, 0x0, 0x0, 0x0, 0x7e, 0xfd, 0x50, 0x0,
    0x0, 0x0,

    /* U+045F "џ" */
    0x2f, 0xc0, 0x0, 0x0, 0xef, 0x2, 0xfc, 0x0,
    0x0, 0xe, 0xf0, 0x2f, 0xc0, 0x0, 0x0, 0xef,
    0x2, 0xfc, 0x0, 0x0, 0xe, 0xf0, 0x2f, 0xc0,
    0x0, 0x0, 0xef, 0x2, 0xfc, 0x0, 0x0, 0xe,
    0xf0, 0x2f, 0xc0, 0x0, 0x0, 0xef, 0x2, 0xfc,
    0x0, 0x0, 0xe, 0xf0, 0x2f, 0xc0, 0x0, 0x0,
    0xef, 0x2, 0xff, 0xbb, 0xbb, 0xbf, 0xf0, 0x2f,
    0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x7, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x7f, 0x60, 0x0, 0x0,
    0x0, 0x3, 0x83, 0x0, 0x0,

    /* U+0462 "Ѣ" */
    0x0, 0x0, 0x78, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xef, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xef, 0x10, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0xff, 0xff, 0xff, 0xff, 0x50, 0x0, 0x0,
    0x58, 0x88, 0xff, 0x88, 0x88, 0x20, 0x0, 0x0,
    0x0, 0x0, 0xef, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xef, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xef, 0xff, 0xff, 0xfe, 0xb4, 0x0,
    0x0, 0x0, 0xef, 0xaa, 0xaa, 0xbd, 0xff, 0x70,
    0x0, 0x0, 0xef, 0x10, 0x0, 0x0, 0x6f, 0xf1,
    0x0, 0x0, 0xef, 0x10, 0x0, 0x0, 0xc, 0xf5,
    0x0, 0x0, 0xef, 0x10, 0x0, 0x0, 0xa, 0xf6,
    0x0, 0x0, 0xef, 0x10, 0x0, 0x0, 0xc, 0xf4,
    0x0, 0x0, 0xef, 0x10, 0x0, 0x0, 0x7f, 0xe0,
    0x0, 0x0, 0xef, 0xaa, 0xaa, 0xbd, 0xff, 0x40,
    0x0, 0x0, 0xef, 0xff, 0xff, 0xfd, 0x92, 0x0,

    /* U+0463 "ѣ" */
    0x0, 0x38, 0x40, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x80, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0x80, 0x0, 0x0, 0x0, 0xff, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x77, 0xaf, 0xb7, 0x77,
    0x30, 0x0, 0x0, 0x6f, 0x80, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0x92, 0x21, 0x0, 0x0, 0x0, 0x6f,
    0xff, 0xff, 0xfc, 0x30, 0x0, 0x6f, 0xb5, 0x55,
    0x9f, 0xf2, 0x0, 0x6f, 0x80, 0x0, 0x8, 0xf8,
    0x0, 0x6f, 0x80, 0x0, 0x5, 0xfa, 0x0, 0x6f,
    0x80, 0x0, 0xa, 0xf7, 0x0, 0x6f, 0xc8, 0x88,
    0xcf, 0xe1, 0x0, 0x6f, 0xff, 0xff, 0xd9, 0x10,

    /* U+046A "Ѫ" */
    0x0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0xcf, 0xc9, 0x99, 0x99, 0x99, 0x9c,
    0xfc, 0x0, 0x0, 0x1d, 0xf3, 0x0, 0x0, 0x0,
    0x3f, 0xc0, 0x0, 0x0, 0x1, 0xde, 0x30, 0x0,
    0x2, 0xed, 0x10, 0x0, 0x0, 0x0, 0x1e, 0xe2,
    0x0, 0x2e, 0xd1, 0x0, 0x0, 0x0, 0x0, 0x2,
    0xee, 0x22, 0xee, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x4, 0xaf, 0xed, 0xfa, 0x40, 0x0, 0x0, 0x0,
    0x2, 0xdf, 0xff, 0xff, 0xff, 0xfd, 0x20, 0x0,
    0x0, 0x1e, 0xf9, 0x20, 0xff, 0x2, 0x9f, 0xe1,
    0x0, 0x0, 0x9f, 0x80, 0x0, 0xff, 0x0, 0x9,
    0xfa, 0x0, 0x2, 0xfe, 0x0, 0x0, 0xff, 0x0,
    0x0, 0xef, 0x20, 0x8, 0xf7, 0x0, 0x0, 0xff,
    0x0, 0x0, 0x7f, 0x90, 0xf, 0xf1, 0x0, 0x0,
    0xff, 0x0, 0x0, 0x1f, 0xf0, 0x6f, 0xa0, 0x0,
    0x0, 0xff, 0x0, 0x0, 0xa, 0xf6,

    /* U+046B "ѫ" */
    0x7, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0x3,
    0xfe, 0x66, 0x66, 0x66, 0xef, 0x30, 0x0, 0x4f,
    0x90, 0x0, 0x9, 0xf4, 0x0, 0x0, 0x4, 0xf9,
    0x0, 0x8f, 0x40, 0x0, 0x0, 0x0, 0x5f, 0x88,
    0xf5, 0x0, 0x0, 0x0, 0x9, 0xff, 0xff, 0xff,
    0xa1, 0x0, 0x0, 0xaf, 0xa4, 0xde, 0x49, 0xfc,
    0x0, 0x4, 0xfa, 0x0, 0xdd, 0x0, 0x8f, 0x50,
    0xb, 0xf2, 0x0, 0xdd, 0x0, 0x1f, 0xc0, 0x1f,
    0xb0, 0x0, 0xdd, 0x0, 0xa, 0xf2, 0x7f, 0x60,
    0x0, 0xdd, 0x0, 0x4, 0xf9,

    /* U+0472 "Ѳ" */
    0x0, 0x0, 0x7c, 0xef, 0xeb, 0x60, 0x0, 0x0,
    0x4, 0xef, 0xfe, 0xde, 0xff, 0xe3, 0x0, 0x5,
    0xff, 0x92, 0x0, 0x2, 0xaf, 0xf3, 0x1, 0xff,
    0x50, 0x0, 0x0, 0x0, 0x6f, 0xe0, 0x8f, 0x90,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0x6d, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xfb, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xdf, 0xfa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xab, 0xfd, 0xdf, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0xb8, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xf6, 0x1f, 0xf7, 0x0, 0x0, 0x0,
    0x8, 0xfe, 0x0, 0x5f, 0xfa, 0x20, 0x0, 0x3b,
    0xff, 0x30, 0x0, 0x4e, 0xff, 0xed, 0xff, 0xfe,
    0x30, 0x0, 0x0, 0x7, 0xce, 0xfe, 0xb6, 0x0,
    0x0,

    /* U+0473 "ѳ" */
    0x0, 0x3, 0xae, 0xfe, 0xa3, 0x0, 0x0, 0x7,
    0xff, 0xb9, 0xbf, 0xf6, 0x0, 0x4, 0xfd, 0x20,
    0x0, 0x2e, 0xf3, 0x0, 0xcf, 0x30, 0x0, 0x0,
    0x4f, 0xb0, 0xf, 0xd1, 0x11, 0x11, 0x11, 0xef,
    0x1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0xf,
    0xe4, 0x44, 0x44, 0x44, 0xef, 0x0, 0xcf, 0x20,
    0x0, 0x0, 0x3f, 0xb0, 0x4, 0xfd, 0x20, 0x0,
    0x2d, 0xf3, 0x0, 0x7, 0xff, 0xb9, 0xbf, 0xf6,
    0x0, 0x0, 0x3, 0xae, 0xfe, 0xa3, 0x0, 0x0,

    /* U+0474 "Ѵ" */
    0x8f, 0xa0, 0x0, 0x0, 0x0, 0x4, 0xcf, 0xe1,
    0xff, 0x10, 0x0, 0x0, 0x3, 0xff, 0xfc, 0xb,
    0xf7, 0x0, 0x0, 0x0, 0xbf, 0x90, 0x0, 0x4f,
    0xe0, 0x0, 0x0, 0x2f, 0xe0, 0x0, 0x0, 0xdf,
    0x50, 0x0, 0x8, 0xf7, 0x0, 0x0, 0x7, 0xfb,
    0x0, 0x0, 0xdf, 0x10, 0x0, 0x0, 0x1f, 0xf2,
    0x0, 0x3f, 0xc0, 0x0, 0x0, 0x0, 0xaf, 0x80,
    0x9, 0xf6, 0x0, 0x0, 0x0, 0x3, 0xfe, 0x0,
    0xff, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf6, 0x5f,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xcb, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xff, 0xfe, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xff, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xf3, 0x0, 0x0,
    0x0,

    /* U+0475 "ѵ" */
    0xaf, 0x60, 0x0, 0x0, 0x1b, 0xfc, 0x3f, 0xd0,
    0x0, 0x0, 0xaf, 0xea, 0xd, 0xf4, 0x0, 0x1,
    0xfe, 0x0, 0x6, 0xfa, 0x0, 0x7, 0xf7, 0x0,
    0x0, 0xff, 0x10, 0xd, 0xf1, 0x0, 0x0, 0x9f,
    0x70, 0x3f, 0xb0, 0x0, 0x0, 0x2f, 0xe0, 0x9f,
    0x50, 0x0, 0x0, 0xb, 0xf5, 0xef, 0x0, 0x0,
    0x0, 0x5, 0xfe, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xd0,
    0x0, 0x0,

    /* U+048A "Ҋ" */
    0x0, 0x2f, 0x70, 0x3, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x6e, 0xff, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x20,
    0x0, 0x0, 0x1, 0xef, 0x40, 0xd, 0xf2, 0x0,
    0x0, 0x0, 0xbf, 0xf4, 0x0, 0xdf, 0x20, 0x0,
    0x0, 0x8f, 0xff, 0x40, 0xd, 0xf2, 0x0, 0x0,
    0x4f, 0xed, 0xf4, 0x0, 0xdf, 0x20, 0x0, 0x1e,
    0xf4, 0xbf, 0x40, 0xd, 0xf2, 0x0, 0xc, 0xf8,
    0xb, 0xf4, 0x0, 0xdf, 0x20, 0x9, 0xfc, 0x0,
    0xbf, 0x40, 0xd, 0xf2, 0x5, 0xfe, 0x10, 0xb,
    0xf4, 0x0, 0xdf, 0x22, 0xff, 0x30, 0x0, 0xbf,
    0x40, 0xd, 0xf3, 0xdf, 0x70, 0x0, 0xb, 0xf4,
    0x0, 0xdf, 0xcf, 0xa0, 0x0, 0x0, 0xbf, 0x40,
    0xd, 0xff, 0xd0, 0x0, 0x0, 0xb, 0xf4, 0x0,
    0xdf, 0xf2, 0x0, 0x0, 0x0, 0xff, 0xfc, 0x2d,
    0xf6, 0x0, 0x0, 0x0, 0xf, 0xff, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xf0, 0x0,

    /* U+048B "ҋ" */
    0x0, 0x4f, 0x40, 0x9, 0xe0, 0x0, 0x0, 0x0,
    0x7f, 0xff, 0xd3, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xc0, 0x0, 0x0, 0x2f, 0xf0,
    0x2, 0xfc, 0x0, 0x0, 0x1d, 0xff, 0x0, 0x2f,
    0xc0, 0x0, 0xb, 0xff, 0xf0, 0x2, 0xfc, 0x0,
    0x9, 0xfa, 0xef, 0x0, 0x2f, 0xc0, 0x6, 0xfc,
    0xe, 0xf0, 0x2, 0xfc, 0x3, 0xfe, 0x10, 0xef,
    0x0, 0x2f, 0xc1, 0xef, 0x40, 0xe, 0xf0, 0x2,
    0xfc, 0xcf, 0x60, 0x0, 0xef, 0x0, 0x2f, 0xff,
    0x90, 0x0, 0xe, 0xf0, 0x2, 0xff, 0xc0, 0x0,
    0x0, 0xff, 0xb6, 0x2f, 0xe1, 0x0, 0x0, 0xf,
    0xff, 0x50, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0x40,

    /* U+048C "Ҍ" */
    0x0, 0x28, 0x50, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5f,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff,
    0xff, 0xf0, 0x0, 0x0, 0x38, 0xaf, 0xd8, 0x88,
    0x70, 0x0, 0x0, 0x0, 0x5f, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xff, 0xff, 0xff, 0xd8, 0x10,
    0x0, 0x5f, 0xda, 0xaa, 0xab, 0xff, 0xe1, 0x0,
    0x5f, 0xa0, 0x0, 0x0, 0x1c, 0xfa, 0x0, 0x5f,
    0xa0, 0x0, 0x0, 0x3, 0xfe, 0x0, 0x5f, 0xa0,
    0x0, 0x0, 0x1, 0xff, 0x0, 0x5f, 0xa0, 0x0,
    0x0, 0x3, 0xfd, 0x0, 0x5f, 0xa0, 0x0, 0x0,
    0x1c, 0xf8, 0x0, 0x5f, 0xda, 0xaa, 0xab, 0xff,
    0xc0, 0x0, 0x5f, 0xff, 0xff, 0xff, 0xc7, 0x0,

    /* U+048D "ҍ" */
    0x12, 0x9f, 0x72, 0x22, 0x0, 0x0, 0x9f, 0xff,
    0xff, 0xff, 0x50, 0x0, 0x25, 0xaf, 0x95, 0x55,
    0x10, 0x0, 0x0, 0x8f, 0x72, 0x21, 0x0, 0x0,
    0x0, 0x8f, 0xff, 0xff, 0xfb, 0x30, 0x0, 0x8f,
    0x95, 0x55, 0x9f, 0xf2, 0x0, 0x8f, 0x60, 0x0,
    0x9, 0xf7, 0x0, 0x8f, 0x60, 0x0, 0x7, 0xf8,
    0x0, 0x8f, 0x60, 0x0, 0xb, 0xf6, 0x0, 0x8f,
    0xb8, 0x88, 0xcf, 0xd0, 0x0, 0x8f, 0xff, 0xff,
    0xd8, 0x10,

    /* U+048E "Ҏ" */
    0xdf, 0xff, 0xff, 0xec, 0x71, 0x0, 0xdf, 0xdc,
    0xcc, 0xef, 0xfe, 0x20, 0xdf, 0x30, 0x0, 0x1,
    0xaf, 0xd0, 0xdf, 0x30, 0x0, 0x0, 0xd, 0xf4,
    0xdf, 0x30, 0x3, 0x10, 0x9, 0xf6, 0xdf, 0x30,
    0xe, 0xb0, 0xa, 0xf6, 0xdf, 0x30, 0x3, 0xf8,
    0x1e, 0xf3, 0xdf, 0x30, 0x0, 0x8f, 0xdf, 0xb0,
    0xdf, 0xff, 0xff, 0xff, 0xfc, 0x10, 0xdf, 0xcc,
    0xcc, 0xb8, 0xdd, 0x0, 0xdf, 0x30, 0x0, 0x0,
    0x3f, 0x90, 0xdf, 0x30, 0x0, 0x0, 0x6, 0xd0,
    0xdf, 0x30, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x30,
    0x0, 0x0, 0x0, 0x0,

    /* U+048F "ҏ" */
    0x2f, 0xb0, 0x7d, 0xfe, 0xa3, 0x0, 0x2f, 0xbb,
    0xfc, 0xad, 0xff, 0x50, 0x2f, 0xfe, 0x20, 0x0,
    0x5f, 0xf2, 0x2f, 0xf4, 0x0, 0x0, 0x8, 0xf8,
    0x2f, 0xe0, 0x0, 0x0, 0x2, 0xfc, 0x2f, 0xc0,
    0x0, 0x0, 0x0, 0xfe, 0x2f, 0xe0, 0x0, 0x19,
    0x12, 0xfc, 0x2f, 0xf4, 0x0, 0x1e, 0xb8, 0xf8,
    0x2f, 0xfe, 0x40, 0x4, 0xff, 0xf2, 0x2f, 0xca,
    0xfd, 0xce, 0xff, 0x80, 0x2f, 0xc0, 0x6d, 0xfe,
    0xab, 0xe1, 0x2f, 0xc0, 0x0, 0x0, 0x1, 0xd5,
    0x2f, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x2f, 0xc0, 0x0, 0x0,
    0x0, 0x0,

    /* U+0490 "Ґ" */
    0x0, 0x0, 0x0, 0x3, 0x82, 0x0, 0x0, 0x0,
    0x7, 0xf5, 0x0, 0x0, 0x0, 0x7, 0xf5, 0x0,
    0x0, 0x0, 0x7, 0xf5, 0xdf, 0xff, 0xff, 0xff,
    0xf5, 0xdf, 0xdc, 0xcc, 0xcc, 0xc4, 0xdf, 0x20,
    0x0, 0x0, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x0,
    0xdf, 0x20, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0,
    0x0, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xdf,
    0x20, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xdf, 0x20,
    0x0, 0x0, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x0,
    0xdf, 0x20, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0,
    0x0, 0x0,

    /* U+0491 "ґ" */
    0x0, 0x0, 0x0, 0x9f, 0x30, 0x0, 0x0, 0x9,
    0xf3, 0x2f, 0xff, 0xff, 0xff, 0x32, 0xff, 0xbb,
    0xbb, 0xb2, 0x2f, 0xc0, 0x0, 0x0, 0x2, 0xfc,
    0x0, 0x0, 0x0, 0x2f, 0xc0, 0x0, 0x0, 0x2,
    0xfc, 0x0, 0x0, 0x0, 0x2f, 0xc0, 0x0, 0x0,
    0x2, 0xfc, 0x0, 0x0, 0x0, 0x2f, 0xc0, 0x0,
    0x0, 0x2, 0xfc, 0x0, 0x0, 0x0, 0x2f, 0xc0,
    0x0, 0x0, 0x0,

    /* U+0492 "Ғ" */
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x4f,
    0xec, 0xcc, 0xcc, 0xcb, 0x0, 0x4f, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xa0, 0x0, 0x0, 0x0, 0x38, 0xaf, 0xd8, 0x88,
    0x88, 0x40, 0x6f, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x4f, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xb0, 0x0, 0x0, 0x0,

    /* U+0493 "ғ" */
    0x0, 0xdf, 0xff, 0xff, 0xff, 0x0, 0xdf, 0xbb,
    0xbb, 0xbb, 0x0, 0xdf, 0x10, 0x0, 0x0, 0x0,
    0xdf, 0x10, 0x0, 0x0, 0x0, 0xdf, 0x10, 0x0,
    0x0, 0x1, 0xdf, 0x21, 0x11, 0x0, 0x2f, 0xff,
    0xff, 0xff, 0xa0, 0x4, 0xdf, 0x54, 0x44, 0x20,
    0x0, 0xdf, 0x10, 0x0, 0x0, 0x0, 0xdf, 0x10,
    0x0, 0x0, 0x0, 0xdf, 0x10, 0x0, 0x0,

    /* U+0494 "Ҕ" */
    0xdf, 0xff, 0xff, 0xff, 0xfc, 0x0, 0xdf, 0xdc,
    0xcc, 0xcc, 0xc9, 0x0, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0x20, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x20,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0x59, 0xdf, 0xec,
    0x60, 0x0, 0xdf, 0xff, 0xca, 0xcf, 0xfa, 0x0,
    0xdf, 0x91, 0x0, 0x3, 0xef, 0x70, 0xdf, 0x20,
    0x0, 0x0, 0x5f, 0xd0, 0xdf, 0x20, 0x0, 0x0,
    0xf, 0xf0, 0xdf, 0x20, 0x0, 0x0, 0xe, 0xf1,
    0xdf, 0x20, 0x0, 0x0, 0xf, 0xf0, 0xdf, 0x20,
    0x0, 0x0, 0x6f, 0xb0, 0x0, 0x0, 0x0, 0x5,
    0xff, 0x30, 0x0, 0x0, 0x4c, 0xef, 0xf6, 0x0,
    0x0, 0x0, 0x6f, 0xeb, 0x30, 0x0,

    /* U+0495 "ҕ" */
    0x2f, 0xff, 0xff, 0xff, 0x70, 0x2, 0xff, 0xbb,
    0xbb, 0xb5, 0x0, 0x2f, 0xc0, 0x0, 0x0, 0x0,
    0x2, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xc0,
    0x0, 0x0, 0x0, 0x2, 0xfd, 0x8d, 0xfe, 0xb4,
    0x0, 0x2f, 0xff, 0xdb, 0xdf, 0xf6, 0x2, 0xfe,
    0x20, 0x0, 0x5f, 0xf1, 0x2f, 0xc0, 0x0, 0x0,
    0xaf, 0x62, 0xfc, 0x0, 0x0, 0x7, 0xf8, 0x2f,
    0xc0, 0x0, 0x0, 0x7f, 0x70, 0x0, 0x0, 0x0,
    0xc, 0xf4, 0x0, 0x0, 0x0, 0x8, 0xfd, 0x0,
    0x0, 0xa, 0xcf, 0xff, 0x30, 0x0, 0x0, 0xdf,
    0xea, 0x20, 0x0,

    /* U+0496 "Җ" */
    0x1e, 0xf2, 0x0, 0x0, 0xb, 0xf4, 0x0, 0x0,
    0x9, 0xf8, 0x0, 0x5, 0xfc, 0x0, 0x0, 0xb,
    0xf4, 0x0, 0x0, 0x3f, 0xd0, 0x0, 0x0, 0xbf,
    0x60, 0x0, 0xb, 0xf4, 0x0, 0x0, 0xdf, 0x30,
    0x0, 0x0, 0x1f, 0xe1, 0x0, 0xb, 0xf4, 0x0,
    0x7, 0xf9, 0x0, 0x0, 0x0, 0x6, 0xfa, 0x0,
    0xb, 0xf4, 0x0, 0x2f, 0xe1, 0x0, 0x0, 0x0,
    0x0, 0xcf, 0x40, 0xb, 0xf4, 0x0, 0xbf, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xff,
    0xff, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f,
    0xed, 0xdf, 0xfd, 0xdd, 0xff, 0x10, 0x0, 0x0,
    0x0, 0x2, 0xff, 0x30, 0xb, 0xf4, 0x0, 0xaf,
    0xb0, 0x0, 0x0, 0x0, 0xc, 0xf8, 0x0, 0xb,
    0xf4, 0x0, 0x1e, 0xf5, 0x0, 0x0, 0x0, 0x6f,
    0xe0, 0x0, 0xb, 0xf4, 0x0, 0x6, 0xfe, 0x10,
    0x0, 0x1, 0xff, 0x40, 0x0, 0xb, 0xf4, 0x0,
    0x0, 0xbf, 0x90, 0x0, 0xb, 0xfa, 0x0, 0x0,
    0xb, 0xf4, 0x0, 0x0, 0x2f, 0xff, 0xc0, 0x5f,
    0xe1, 0x0, 0x0, 0xb, 0xf4, 0x0, 0x0, 0xa,
    0xff, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xc, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xf1,

    /* U+0497 "җ" */
    0x3f, 0xd0, 0x0, 0x8, 0xf6, 0x0, 0x0, 0xef,
    0x20, 0x8, 0xf6, 0x0, 0x8, 0xf6, 0x0, 0x8,
    0xf8, 0x0, 0x0, 0xde, 0x10, 0x8, 0xf6, 0x0,
    0x1f, 0xe0, 0x0, 0x0, 0x4f, 0x90, 0x8, 0xf6,
    0x0, 0xaf, 0x50, 0x0, 0x0, 0xa, 0xf2, 0x8,
    0xf6, 0x3, 0xfc, 0x0, 0x0, 0x0, 0x4, 0xff,
    0xff, 0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0xd,
    0xfc, 0xbd, 0xfd, 0xbd, 0xfa, 0x0, 0x0, 0x0,
    0x8f, 0xd0, 0x8, 0xf6, 0x1, 0xef, 0x40, 0x0,
    0x2, 0xff, 0x30, 0x8, 0xf6, 0x0, 0x4f, 0xe1,
    0x0, 0xc, 0xf8, 0x0, 0x8, 0xf6, 0x0, 0x9,
    0xff, 0xb5, 0x7f, 0xd0, 0x0, 0x8, 0xf6, 0x0,
    0x0, 0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x1, 0x84,

    /* U+0498 "Ҙ" */
    0x0, 0x6b, 0xef, 0xfd, 0x81, 0x0, 0xb, 0xff,
    0xed, 0xdf, 0xff, 0x30, 0x4, 0x61, 0x0, 0x1,
    0x9f, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0xc0, 0x0, 0x8,
    0xaa, 0xbd, 0xfc, 0x20, 0x0, 0xc, 0xff, 0xff,
    0xfa, 0x10, 0x0, 0x0, 0x0, 0x2, 0x8f, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x9, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xf9, 0x1, 0x0, 0x0, 0x0,
    0xa, 0xf8, 0x1e, 0x81, 0x0, 0x0, 0x8f, 0xf2,
    0x2d, 0xff, 0xcb, 0xcf, 0xff, 0x50, 0x0, 0x6b,
    0xff, 0xfd, 0x92, 0x0, 0x0, 0x0, 0xe, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0xe, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0xe, 0xf0, 0x0, 0x0,

    /* U+0499 "ҙ" */
    0x3, 0x9d, 0xff, 0xd8, 0x10, 0xd, 0xfd, 0xbc,
    0xff, 0xd0, 0x4, 0x20, 0x0, 0xc, 0xf6, 0x0,
    0x0, 0x0, 0x8, 0xf7, 0x0, 0x1, 0x12, 0x5e,
    0xe1, 0x0, 0x9, 0xff, 0xfe, 0x30, 0x0, 0x2,
    0x45, 0x7d, 0xf4, 0x0, 0x0, 0x0, 0x3, 0xfc,
    0xb, 0x40, 0x0, 0x1a, 0xfa, 0x3f, 0xff, 0xef,
    0xff, 0xd1, 0x1, 0x7a, 0xff, 0xa6, 0x0, 0x0,
    0x0, 0xef, 0x0, 0x0, 0x0, 0x0, 0xef, 0x0,
    0x0,

    /* U+049A "Қ" */
    0xdf, 0x20, 0x0, 0x0, 0xd, 0xf4, 0xd, 0xf2,
    0x0, 0x0, 0x9, 0xf8, 0x0, 0xdf, 0x20, 0x0,
    0x5, 0xfc, 0x0, 0xd, 0xf2, 0x0, 0x2, 0xfe,
    0x10, 0x0, 0xdf, 0x20, 0x0, 0xcf, 0x40, 0x0,
    0xd, 0xf2, 0x0, 0x8f, 0x80, 0x0, 0x0, 0xdf,
    0xff, 0xff, 0xd0, 0x0, 0x0, 0xd, 0xfd, 0xdd,
    0xff, 0x30, 0x0, 0x0, 0xdf, 0x20, 0x7, 0xfd,
    0x0, 0x0, 0xd, 0xf2, 0x0, 0xb, 0xf9, 0x0,
    0x0, 0xdf, 0x20, 0x0, 0x1e, 0xf5, 0x0, 0xd,
    0xf2, 0x0, 0x0, 0x4f, 0xf1, 0x0, 0xdf, 0x20,
    0x0, 0x0, 0x8f, 0xfc, 0x9d, 0xf2, 0x0, 0x0,
    0x0, 0xff, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xc0,

    /* U+049B "қ" */
    0x2f, 0xc0, 0x0, 0x0, 0xdf, 0x20, 0x2f, 0xc0,
    0x0, 0x9, 0xf6, 0x0, 0x2f, 0xc0, 0x0, 0x4f,
    0xb0, 0x0, 0x2f, 0xc0, 0x1, 0xee, 0x10, 0x0,
    0x2f, 0xc0, 0xa, 0xf4, 0x0, 0x0, 0x2f, 0xff,
    0xff, 0xb0, 0x0, 0x0, 0x2f, 0xeb, 0xbf, 0xf3,
    0x0, 0x0, 0x2f, 0xc0, 0x6, 0xfe, 0x10, 0x0,
    0x2f, 0xc0, 0x0, 0x8f, 0xc0, 0x0, 0x2f, 0xc0,
    0x0, 0xb, 0xff, 0xb6, 0x2f, 0xc0, 0x0, 0x0,
    0xff, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x2, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x2, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x84,

    /* U+049C "Ҝ" */
    0xdf, 0x20, 0x0, 0x0, 0x6, 0xfb, 0xd, 0xf2,
    0x0, 0x0, 0x1, 0xff, 0x10, 0xdf, 0x20, 0x0,
    0x0, 0xbf, 0x60, 0xd, 0xf2, 0x7f, 0x0, 0x5f,
    0xb0, 0x0, 0xdf, 0x27, 0xf0, 0x1e, 0xf1, 0x0,
    0xd, 0xf2, 0x7f, 0xa, 0xf6, 0x0, 0x0, 0xdf,
    0xff, 0xff, 0xfc, 0x0, 0x0, 0xd, 0xfd, 0xef,
    0xdf, 0xf2, 0x0, 0x0, 0xdf, 0x27, 0xf0, 0x9f,
    0xc0, 0x0, 0xd, 0xf2, 0x7f, 0x0, 0xdf, 0x60,
    0x0, 0xdf, 0x24, 0x90, 0x3, 0xff, 0x20, 0xd,
    0xf2, 0x0, 0x0, 0x9, 0xfc, 0x0, 0xdf, 0x20,
    0x0, 0x0, 0xd, 0xf6, 0xd, 0xf2, 0x0, 0x0,
    0x0, 0x3f, 0xf2,

    /* U+049D "ҝ" */
    0x3f, 0xb0, 0x0, 0x0, 0x9f, 0x60, 0x3f, 0xb0,
    0x0, 0x2, 0xfc, 0x0, 0x3f, 0xb0, 0x0, 0xc,
    0xf3, 0x0, 0x3f, 0xb4, 0xf2, 0x5f, 0x90, 0x0,
    0x3f, 0xb4, 0xf2, 0xee, 0x10, 0x0, 0x3f, 0xff,
    0xff, 0xf7, 0x0, 0x0, 0x3f, 0xec, 0xfc, 0xfd,
    0x0, 0x0, 0x3f, 0xb4, 0xf2, 0xbf, 0x90, 0x0,
    0x3f, 0xb3, 0xc1, 0x1e, 0xf4, 0x0, 0x3f, 0xb0,
    0x0, 0x4, 0xfe, 0x10, 0x3f, 0xb0, 0x0, 0x0,
    0x8f, 0xb0,

    /* U+049E "Ҟ" */
    0x0, 0x6f, 0x90, 0x0, 0x0, 0x6, 0xfb, 0x0,
    0x27, 0xfa, 0x22, 0x10, 0x2, 0xfe, 0x10, 0x4f,
    0xff, 0xff, 0xff, 0x0, 0xdf, 0x30, 0x1, 0x59,
    0xfb, 0x55, 0x40, 0x9f, 0x70, 0x0, 0x0, 0x6f,
    0x90, 0x0, 0x5f, 0xb0, 0x0, 0x0, 0x6, 0xf9,
    0x0, 0x2f, 0xe1, 0x0, 0x0, 0x0, 0x6f, 0xff,
    0xff, 0xf4, 0x0, 0x0, 0x0, 0x6, 0xfe, 0xdd,
    0xef, 0xa0, 0x0, 0x0, 0x0, 0x6f, 0x90, 0x1,
    0xef, 0x50, 0x0, 0x0, 0x6, 0xf9, 0x0, 0x4,
    0xff, 0x20, 0x0, 0x0, 0x6f, 0x90, 0x0, 0x8,
    0xfc, 0x0, 0x0, 0x6, 0xf9, 0x0, 0x0, 0xc,
    0xf8, 0x0, 0x0, 0x6f, 0x90, 0x0, 0x0, 0x1e,
    0xf3, 0x0, 0x6, 0xf9, 0x0, 0x0, 0x0, 0x5f,
    0xe1,

    /* U+049F "ҟ" */
    0x0, 0x43, 0x0, 0x0, 0x0, 0x0, 0x13, 0xfd,
    0x11, 0x10, 0x0, 0x0, 0xff, 0xff, 0xff, 0xd0,
    0x0, 0x0, 0x46, 0xfd, 0x44, 0x40, 0x0, 0x0,
    0x2, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x2, 0xfc,
    0x0, 0x0, 0xd, 0xf2, 0x2, 0xfc, 0x0, 0x0,
    0x9f, 0x70, 0x2, 0xfc, 0x0, 0x4, 0xfb, 0x0,
    0x2, 0xfc, 0x0, 0x1e, 0xe1, 0x0, 0x2, 0xfc,
    0x0, 0xaf, 0x50, 0x0, 0x2, 0xff, 0xff, 0xfb,
    0x0, 0x0, 0x2, 0xfe, 0xbb, 0xff, 0x30, 0x0,
    0x2, 0xfc, 0x0, 0x6f, 0xe1, 0x0, 0x2, 0xfc,
    0x0, 0x8, 0xfc, 0x0, 0x2, 0xfc, 0x0, 0x0,
    0xbf, 0x90, 0x2, 0xfc, 0x0, 0x0, 0xd, 0xf6,

    /* U+04A0 "Ҡ" */
    0xbf, 0xff, 0xff, 0x70, 0x0, 0x0, 0x8, 0xf9,
    0x9, 0xcc, 0xce, 0xf7, 0x0, 0x0, 0x4, 0xfc,
    0x0, 0x0, 0x0, 0x8f, 0x70, 0x0, 0x1, 0xef,
    0x20, 0x0, 0x0, 0x8, 0xf7, 0x0, 0x0, 0xbf,
    0x50, 0x0, 0x0, 0x0, 0x8f, 0x70, 0x0, 0x7f,
    0x90, 0x0, 0x0, 0x0, 0x8, 0xf7, 0x0, 0x3f,
    0xd0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0xff,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0x8, 0xfe, 0xdd,
    0xef, 0x80, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x70,
    0x2, 0xff, 0x30, 0x0, 0x0, 0x0, 0x8, 0xf7,
    0x0, 0x6, 0xfe, 0x10, 0x0, 0x0, 0x0, 0x8f,
    0x70, 0x0, 0xa, 0xfa, 0x0, 0x0, 0x0, 0x8,
    0xf7, 0x0, 0x0, 0xd, 0xf6, 0x0, 0x0, 0x0,
    0x8f, 0x70, 0x0, 0x0, 0x3f, 0xf2, 0x0, 0x0,
    0x8, 0xf7, 0x0, 0x0, 0x0, 0x6f, 0xd0,

    /* U+04A1 "ҡ" */
    0xef, 0xff, 0xf3, 0x0, 0x0, 0x7f, 0xa0, 0xab,
    0xbe, 0xf3, 0x0, 0x2, 0xfd, 0x0, 0x0, 0xb,
    0xf3, 0x0, 0xc, 0xf3, 0x0, 0x0, 0xb, 0xf3,
    0x0, 0x8f, 0x70, 0x0, 0x0, 0xb, 0xf3, 0x3,
    0xfc, 0x0, 0x0, 0x0, 0xb, 0xff, 0xff, 0xf2,
    0x0, 0x0, 0x0, 0xb, 0xfc, 0xbd, 0xfa, 0x0,
    0x0, 0x0, 0xb, 0xf3, 0x0, 0xdf, 0x70, 0x0,
    0x0, 0xb, 0xf3, 0x0, 0x2e, 0xf4, 0x0, 0x0,
    0xb, 0xf3, 0x0, 0x4, 0xfe, 0x20, 0x0, 0xb,
    0xf3, 0x0, 0x0, 0x6f, 0xd0,

    /* U+04A2 "Ң" */
    0xdf, 0x20, 0x0, 0x0, 0x0, 0xcf, 0x30, 0xd,
    0xf2, 0x0, 0x0, 0x0, 0xc, 0xf3, 0x0, 0xdf,
    0x20, 0x0, 0x0, 0x0, 0xcf, 0x30, 0xd, 0xf2,
    0x0, 0x0, 0x0, 0xc, 0xf3, 0x0, 0xdf, 0x20,
    0x0, 0x0, 0x0, 0xcf, 0x30, 0xd, 0xf2, 0x0,
    0x0, 0x0, 0xc, 0xf3, 0x0, 0xdf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x30, 0xd, 0xfd, 0xcc, 0xcc,
    0xcc, 0xcf, 0xf3, 0x0, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0xcf, 0x30, 0xd, 0xf2, 0x0, 0x0, 0x0,
    0xc, 0xf3, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x0,
    0xcf, 0x30, 0xd, 0xf2, 0x0, 0x0, 0x0, 0xc,
    0xf3, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xff,
    0xfc, 0x4d, 0xf2, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0x60, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf6,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x60,

    /* U+04A3 "ң" */
    0x2f, 0xc0, 0x0, 0x0, 0x3f, 0xb0, 0x2, 0xfc,
    0x0, 0x0, 0x3, 0xfb, 0x0, 0x2f, 0xc0, 0x0,
    0x0, 0x3f, 0xb0, 0x2, 0xfc, 0x0, 0x0, 0x3,
    0xfb, 0x0, 0x2f, 0xc0, 0x0, 0x0, 0x3f, 0xb0,
    0x2, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x0, 0x2f,
    0xeb, 0xbb, 0xbb, 0xcf, 0xb0, 0x2, 0xfc, 0x0,
    0x0, 0x3, 0xfb, 0x0, 0x2f, 0xc0, 0x0, 0x0,
    0x3f, 0xb0, 0x2, 0xfc, 0x0, 0x0, 0x5, 0xff,
    0xb4, 0x2f, 0xc0, 0x0, 0x0, 0x6f, 0xff, 0x60,
    0x0, 0x0, 0x0, 0x0, 0x6, 0xf6, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x3, 0x83,

    /* U+04A4 "Ҥ" */
    0xdf, 0x20, 0x0, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xf7, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xff,
    0xfc, 0xcc, 0xcc, 0xc5, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0xff, 0x70, 0x0, 0x0, 0x0, 0xdf, 0x20,
    0x0, 0x0, 0x0, 0xff, 0x70, 0x0, 0x0, 0x0,
    0xdf, 0x20, 0x0, 0x0, 0x0, 0xff, 0x70, 0x0,
    0x0, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xff,
    0x70, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x70, 0x0, 0x0, 0x0, 0xdf, 0xdc,
    0xcc, 0xcc, 0xcc, 0xff, 0x70, 0x0, 0x0, 0x0,
    0xdf, 0x20, 0x0, 0x0, 0x0, 0xff, 0x70, 0x0,
    0x0, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xff,
    0x70, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0xff, 0x70, 0x0, 0x0, 0x0, 0xdf, 0x20,
    0x0, 0x0, 0x0, 0xff, 0x70, 0x0, 0x0, 0x0,
    0xdf, 0x20, 0x0, 0x0, 0x0, 0xff, 0x70, 0x0,
    0x0, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xff,
    0x70, 0x0, 0x0, 0x0,

    /* U+04A5 "ҥ" */
    0x2f, 0xc0, 0x0, 0x0, 0x6f, 0xff, 0xff, 0xff,
    0x92, 0xfc, 0x0, 0x0, 0x6, 0xff, 0xbb, 0xbb,
    0xb6, 0x2f, 0xc0, 0x0, 0x0, 0x6f, 0xf0, 0x0,
    0x0, 0x2, 0xfc, 0x0, 0x0, 0x6, 0xff, 0x0,
    0x0, 0x0, 0x2f, 0xc0, 0x0, 0x0, 0x6f, 0xf0,
    0x0, 0x0, 0x2, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x0, 0x0, 0x0, 0x2f, 0xeb, 0xbb, 0xbb, 0xff,
    0xf0, 0x0, 0x0, 0x2, 0xfc, 0x0, 0x0, 0x6,
    0xff, 0x0, 0x0, 0x0, 0x2f, 0xc0, 0x0, 0x0,
    0x6f, 0xf0, 0x0, 0x0, 0x2, 0xfc, 0x0, 0x0,
    0x6, 0xff, 0x0, 0x0, 0x0, 0x2f, 0xc0, 0x0,
    0x0, 0x6f, 0xf0, 0x0, 0x0, 0x0,

    /* U+04A6 "Ҧ" */
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xdc, 0xcc, 0xcc, 0xcc,
    0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x20,
    0x0, 0x0, 0x0, 0xbf, 0x30, 0x0, 0x0, 0x0,
    0x0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xbf, 0x30,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0xbf, 0x30, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0x20, 0x0, 0x0, 0x0, 0xbf, 0x30, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xbf,
    0x69, 0xdf, 0xec, 0x60, 0x0, 0xdf, 0x20, 0x0,
    0x0, 0x0, 0xbf, 0xff, 0xdb, 0xcf, 0xfb, 0x0,
    0xdf, 0x20, 0x0, 0x0, 0x0, 0xbf, 0x91, 0x0,
    0x3, 0xef, 0x70, 0xdf, 0x20, 0x0, 0x0, 0x0,
    0xbf, 0x30, 0x0, 0x0, 0x4f, 0xe0, 0xdf, 0x20,
    0x0, 0x0, 0x0, 0xbf, 0x30, 0x0, 0x0, 0xe,
    0xf1, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xbf, 0x30,
    0x0, 0x0, 0xd, 0xf1, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0xbf, 0x30, 0x0, 0x0, 0xf, 0xf0, 0xdf,
    0x20, 0x0, 0x0, 0x0, 0xbf, 0x30, 0x0, 0x0,
    0x5f, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x4, 0xff, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x4c, 0xef, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0xeb, 0x30, 0x0,

    /* U+04A7 "ҧ" */
    0x2f, 0xff, 0xff, 0xff, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x2, 0xff, 0xbb, 0xbb, 0xbd, 0xf6, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0xc0, 0x0, 0x0, 0x8f,
    0x60, 0x0, 0x0, 0x0, 0x2, 0xfc, 0x0, 0x0,
    0x8, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xc0,
    0x0, 0x0, 0x8f, 0x60, 0x0, 0x0, 0x0, 0x2,
    0xfc, 0x0, 0x0, 0x8, 0xfa, 0xbe, 0xfd, 0x81,
    0x0, 0x2f, 0xc0, 0x0, 0x0, 0x8f, 0xff, 0xcb,
    0xef, 0xd1, 0x2, 0xfc, 0x0, 0x0, 0x8, 0xf9,
    0x0, 0x0, 0xbf, 0x90, 0x2f, 0xc0, 0x0, 0x0,
    0x8f, 0x60, 0x0, 0x1, 0xff, 0x2, 0xfc, 0x0,
    0x0, 0x8, 0xf6, 0x0, 0x0, 0xe, 0xf1, 0x2f,
    0xc0, 0x0, 0x0, 0x8f, 0x60, 0x0, 0x0, 0xef,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2d, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3c, 0xdf, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xff, 0xc6, 0x0, 0x0,

    /* U+04A8 "Ҩ" */
    0x0, 0x1b, 0x70, 0x0, 0x29, 0xdf, 0xea, 0x20,
    0x0, 0x1, 0xdf, 0x90, 0x4, 0xff, 0xfd, 0xff,
    0xf5, 0x0, 0xa, 0xfa, 0x0, 0x1e, 0xf9, 0x0,
    0x9, 0xff, 0x20, 0x2f, 0xe0, 0x0, 0x8f, 0xb0,
    0x0, 0x0, 0xbf, 0x80, 0x8f, 0x80, 0x0, 0xdf,
    0x50, 0x0, 0x0, 0x5f, 0xc0, 0xbf, 0x40, 0x0,
    0xef, 0x10, 0x0, 0x0, 0x2f, 0xe0, 0xdf, 0x20,
    0x0, 0xff, 0x10, 0x0, 0x0, 0x1f, 0xd0, 0xcf,
    0x30, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x3f, 0xa0,
    0x9f, 0x70, 0x0, 0x9f, 0x50, 0x0, 0x0, 0x6f,
    0x60, 0x4f, 0xd0, 0x0, 0x2f, 0xa0, 0x0, 0x0,
    0xce, 0x0, 0xc, 0xf9, 0x0, 0x8, 0xf4, 0x0,
    0x5, 0xf4, 0x0, 0x2, 0xef, 0xa1, 0x0, 0xbe,
    0x30, 0x4e, 0x50, 0x0, 0x0, 0x2c, 0xff, 0xca,
    0x9f, 0xfa, 0xfc, 0x89, 0xc0, 0x0, 0x0, 0x4a,
    0xdf, 0xfd, 0xa8, 0xcf, 0xfe, 0xb0,

    /* U+04A9 "ҩ" */
    0x0, 0x1c, 0x80, 0x1, 0x9e, 0xfd, 0x70, 0x0,
    0xc, 0xf8, 0x2, 0xef, 0xdb, 0xef, 0xb0, 0x7,
    0xfa, 0x0, 0xbf, 0x80, 0x1, 0xcf, 0x50, 0xdf,
    0x20, 0xf, 0xe0, 0x0, 0x4, 0xfa, 0xf, 0xf0,
    0x2, 0xfb, 0x0, 0x0, 0x1f, 0xb0, 0xfe, 0x0,
    0x1f, 0xc0, 0x0, 0x3, 0xfa, 0xe, 0xf1, 0x0,
    0xef, 0x0, 0x0, 0x6f, 0x50, 0x8f, 0x80, 0x8,
    0xf7, 0x0, 0xd, 0xd0, 0x1, 0xef, 0x70, 0xd,
    0xf5, 0x1b, 0xf3, 0x0, 0x3, 0xdf, 0xe9, 0x9f,
    0xff, 0xfb, 0x88, 0x0, 0x0, 0x7c, 0xef, 0xeb,
    0xad, 0xfe, 0xa0,

    /* U+04AA "Ҫ" */
    0x0, 0x0, 0x7c, 0xef, 0xeb, 0x50, 0x0, 0x4,
    0xef, 0xfe, 0xde, 0xff, 0xd1, 0x5, 0xff, 0xa2,
    0x0, 0x3, 0xbf, 0x61, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x30, 0x8f, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0x10, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xcf, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0xf6, 0x0, 0x0, 0x0, 0x3, 0x0,
    0x5f, 0xfa, 0x20, 0x0, 0x3b, 0xf6, 0x0, 0x4e,
    0xff, 0xed, 0xff, 0xfc, 0x10, 0x0, 0x7, 0xcf,
    0xfe, 0xb5, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0x0, 0x0, 0x0,

    /* U+04AB "ҫ" */
    0x0, 0x3, 0xae, 0xfe, 0x92, 0x0, 0x7, 0xff,
    0xdc, 0xef, 0xf3, 0x4, 0xfe, 0x40, 0x0, 0x6f,
    0x60, 0xcf, 0x50, 0x0, 0x0, 0x10, 0xf, 0xe0,
    0x0, 0x0, 0x0, 0x1, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0xf, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0x50, 0x0, 0x0, 0x10, 0x4, 0xfe, 0x40, 0x0,
    0x6f, 0x60, 0x7, 0xff, 0xec, 0xef, 0xe3, 0x0,
    0x3, 0xaf, 0xff, 0x91, 0x0, 0x0, 0x0, 0xaf,
    0x30, 0x0, 0x0, 0x0, 0xa, 0xf3, 0x0, 0x0,

    /* U+04AC "Ҭ" */
    0xcf, 0xff, 0xff, 0xff, 0xff, 0xfc, 0x9c, 0xcc,
    0xcf, 0xfc, 0xcc, 0xc9, 0x0, 0x0, 0xf, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xfc, 0xc1, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0xb, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xf2, 0x0,

    /* U+04AD "ҭ" */
    0xef, 0xff, 0xff, 0xff, 0xfc, 0xab, 0xbb, 0xff,
    0xbb, 0xb8, 0x0, 0x0, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0xfe, 0x0, 0x0, 0x0, 0x0, 0xfe, 0x0,
    0x0, 0x0, 0x0, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0xfe, 0x0, 0x0, 0x0, 0x0, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0xfe, 0x0, 0x0, 0x0, 0x0, 0xff,
    0xf8, 0x0, 0x0, 0x0, 0xff, 0xf8, 0x0, 0x0,
    0x0, 0x4, 0xf8, 0x0, 0x0, 0x0, 0x4, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x10, 0x0,

    /* U+04AE "Ү" */
    0x8f, 0x90, 0x0, 0x0, 0x0, 0x1f, 0xd0, 0xe,
    0xf3, 0x0, 0x0, 0x0, 0xaf, 0x40, 0x5, 0xfc,
    0x0, 0x0, 0x4, 0xfb, 0x0, 0x0, 0xbf, 0x60,
    0x0, 0xd, 0xf1, 0x0, 0x0, 0x2f, 0xe1, 0x0,
    0x8f, 0x70, 0x0, 0x0, 0x8, 0xf9, 0x2, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0x3b, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xef, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xff, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xfa, 0x0,
    0x0, 0x0,

    /* U+04AF "ү" */
    0xaf, 0x50, 0x0, 0x0, 0xb, 0xf2, 0x3f, 0xc0,
    0x0, 0x0, 0x2f, 0xb0, 0xd, 0xf2, 0x0, 0x0,
    0x8f, 0x40, 0x6, 0xf9, 0x0, 0x0, 0xfd, 0x0,
    0x0, 0xff, 0x0, 0x6, 0xf7, 0x0, 0x0, 0x9f,
    0x60, 0xd, 0xf1, 0x0, 0x0, 0x2f, 0xd0, 0x4f,
    0x90, 0x0, 0x0, 0xb, 0xf3, 0xaf, 0x30, 0x0,
    0x0, 0x4, 0xfc, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0xef, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xb0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xb0,
    0x0, 0x0,

    /* U+04B0 "Ұ" */
    0x8f, 0x90, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0xd,
    0xf3, 0x0, 0x0, 0x0, 0xbf, 0x40, 0x4, 0xfd,
    0x0, 0x0, 0x6, 0xf9, 0x0, 0x0, 0x9f, 0x80,
    0x0, 0x1e, 0xe1, 0x0, 0x0, 0x1e, 0xf2, 0x0,
    0xaf, 0x50, 0x0, 0x0, 0x5, 0xfc, 0x4, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0x7e, 0xf1, 0x0,
    0x0, 0x0, 0x11, 0x3f, 0xff, 0x81, 0x10, 0x0,
    0x0, 0xaf, 0xff, 0xff, 0xff, 0xe0, 0x0, 0x0,
    0x34, 0x48, 0xfc, 0x44, 0x40, 0x0, 0x0, 0x0,
    0x5, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xfa, 0x0,
    0x0, 0x0,

    /* U+04B1 "ұ" */
    0xaf, 0x50, 0x0, 0x0, 0xb, 0xf2, 0x3f, 0xc0,
    0x0, 0x0, 0x2f, 0xb0, 0xc, 0xf3, 0x0, 0x0,
    0x9f, 0x40, 0x6, 0xfa, 0x0, 0x1, 0xfd, 0x0,
    0x0, 0xef, 0x10, 0x7, 0xf6, 0x0, 0x0, 0x8f,
    0x70, 0xe, 0xe0, 0x0, 0x0, 0x1f, 0xe0, 0x5f,
    0x80, 0x0, 0x0, 0xa, 0xf5, 0xcf, 0x20, 0x0,
    0x0, 0x3, 0xfd, 0xfa, 0x0, 0x0, 0x0, 0x11,
    0xdf, 0xf5, 0x11, 0x0, 0x9, 0xff, 0xff, 0xff,
    0xff, 0x0, 0x2, 0x44, 0x7f, 0xc4, 0x44, 0x0,
    0x0, 0x0, 0x3f, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xb0,
    0x0, 0x0,

    /* U+04B2 "Ҳ" */
    0x1e, 0xf4, 0x0, 0x0, 0x2, 0xff, 0x40, 0x4,
    0xfe, 0x10, 0x0, 0xc, 0xf8, 0x0, 0x0, 0x9f,
    0xb0, 0x0, 0x8f, 0xd0, 0x0, 0x0, 0xd, 0xf7,
    0x3, 0xff, 0x20, 0x0, 0x0, 0x3, 0xff, 0x4e,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xff, 0xb0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xff, 0x10, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0xff, 0x60, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xbf, 0xf2, 0x0, 0x0, 0x0,
    0x8, 0xfc, 0x9, 0xfc, 0x0, 0x0, 0x0, 0x3f,
    0xf2, 0x0, 0xdf, 0x80, 0x0, 0x0, 0xdf, 0x60,
    0x0, 0x2f, 0xf4, 0x0, 0xa, 0xfb, 0x0, 0x0,
    0x6, 0xff, 0xda, 0x5f, 0xe1, 0x0, 0x0, 0x0,
    0xff, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xfd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfd,

    /* U+04B3 "ҳ" */
    0x4f, 0xd0, 0x0, 0x1, 0xee, 0x10, 0x8, 0xf9,
    0x0, 0xc, 0xf5, 0x0, 0x0, 0xcf, 0x50, 0x8f,
    0x90, 0x0, 0x0, 0x1e, 0xe6, 0xfc, 0x0, 0x0,
    0x0, 0x5, 0xff, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0xa0, 0x0, 0x0, 0x0, 0x7, 0xff, 0xf4,
    0x0, 0x0, 0x0, 0x3f, 0xd3, 0xfe, 0x10, 0x0,
    0x1, 0xef, 0x20, 0x6f, 0xc0, 0x0, 0xb, 0xf6,
    0x0, 0xa, 0xff, 0xb5, 0x7f, 0xa0, 0x0, 0x0,
    0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x3, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x84,

    /* U+04B4 "Ҵ" */
    0xbf, 0xff, 0xff, 0xff, 0xff, 0xf4, 0x0, 0x2f,
    0xd0, 0x9, 0xcc, 0xcc, 0xff, 0xcc, 0xcc, 0x30,
    0x2, 0xfd, 0x0, 0x0, 0x0, 0xe, 0xf0, 0x0,
    0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0, 0x0, 0xef,
    0x0, 0x0, 0x0, 0x2, 0xfd, 0x0, 0x0, 0x0,
    0xe, 0xf0, 0x0, 0x0, 0x0, 0x2f, 0xd0, 0x0,
    0x0, 0x0, 0xef, 0x0, 0x0, 0x0, 0x2, 0xfd,
    0x0, 0x0, 0x0, 0xe, 0xf0, 0x0, 0x0, 0x0,
    0x2f, 0xd0, 0x0, 0x0, 0x0, 0xef, 0x0, 0x0,
    0x0, 0x2, 0xfd, 0x0, 0x0, 0x0, 0xe, 0xf0,
    0x0, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0, 0x0,
    0xef, 0x0, 0x0, 0x0, 0x2, 0xfd, 0x0, 0x0,
    0x0, 0xe, 0xf0, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0x0, 0x0, 0x0, 0xef, 0x0, 0x0, 0x0, 0x2,
    0xfd, 0x0, 0x0, 0x0, 0xe, 0xfc, 0xcc, 0xcc,
    0xcc, 0xcf, 0xfc, 0xc0, 0x0, 0x0, 0xef, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x68,

    /* U+04B5 "ҵ" */
    0xef, 0xff, 0xff, 0xff, 0xf0, 0xb, 0xf3, 0xa,
    0xbb, 0xbf, 0xfb, 0xbb, 0x0, 0xbf, 0x30, 0x0,
    0x0, 0xfe, 0x0, 0x0, 0xb, 0xf3, 0x0, 0x0,
    0xf, 0xe0, 0x0, 0x0, 0xbf, 0x30, 0x0, 0x0,
    0xfe, 0x0, 0x0, 0xb, 0xf3, 0x0, 0x0, 0xf,
    0xe0, 0x0, 0x0, 0xbf, 0x30, 0x0, 0x0, 0xfe,
    0x0, 0x0, 0xb, 0xf3, 0x0, 0x0, 0xf, 0xe0,
    0x0, 0x0, 0xbf, 0x30, 0x0, 0x0, 0xfe, 0x0,
    0x0, 0xb, 0xf3, 0x0, 0x0, 0xf, 0xfb, 0xbb,
    0xbb, 0xef, 0xc8, 0x0, 0x0, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xfb, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x53,

    /* U+04B6 "Ҷ" */
    0xff, 0x0, 0x0, 0x0, 0x7, 0xf8, 0x0, 0xff,
    0x0, 0x0, 0x0, 0x7, 0xf8, 0x0, 0xff, 0x0,
    0x0, 0x0, 0x7, 0xf8, 0x0, 0xff, 0x0, 0x0,
    0x0, 0x7, 0xf8, 0x0, 0xef, 0x10, 0x0, 0x0,
    0x7, 0xf8, 0x0, 0xdf, 0x60, 0x0, 0x0, 0x7,
    0xf8, 0x0, 0x7f, 0xf5, 0x0, 0x0, 0x4c, 0xf8,
    0x0, 0xc, 0xff, 0xfd, 0xef, 0xff, 0xf8, 0x0,
    0x0, 0x6c, 0xff, 0xeb, 0x68, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xff, 0xc8, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xff, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfa,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfa,

    /* U+04B7 "ҷ" */
    0x3f, 0xb0, 0x0, 0x0, 0xaf, 0x40, 0x3f, 0xb0,
    0x0, 0x0, 0xaf, 0x40, 0x3f, 0xb0, 0x0, 0x0,
    0xaf, 0x40, 0x2f, 0xb0, 0x0, 0x0, 0xaf, 0x40,
    0x1f, 0xe0, 0x0, 0x0, 0xaf, 0x40, 0xd, 0xf9,
    0x20, 0x26, 0xef, 0x40, 0x4, 0xef, 0xff, 0xff,
    0xff, 0x40, 0x0, 0x6, 0x98, 0x61, 0xaf, 0x40,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0x40, 0x0, 0x0,
    0x0, 0x0, 0xff, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0xff, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x67,

    /* U+04B8 "Ҹ" */
    0xff, 0x0, 0x0, 0x0, 0x7, 0xf8, 0xff, 0x0,
    0x0, 0x0, 0x7, 0xf8, 0xff, 0x0, 0x0, 0x0,
    0x7, 0xf8, 0xff, 0x0, 0x0, 0x0, 0x7, 0xf8,
    0xef, 0x10, 0x9, 0x30, 0x7, 0xf8, 0xdf, 0x50,
    0x1f, 0x60, 0x7, 0xf8, 0x8f, 0xe3, 0x1f, 0x60,
    0x3b, 0xf8, 0x1d, 0xff, 0xdf, 0xde, 0xff, 0xf8,
    0x1, 0x9e, 0xff, 0xfd, 0x99, 0xf8, 0x0, 0x0,
    0x1f, 0x60, 0x7, 0xf8, 0x0, 0x0, 0x1f, 0x60,
    0x7, 0xf8, 0x0, 0x0, 0x1f, 0x60, 0x7, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xf8,

    /* U+04B9 "ҹ" */
    0x2f, 0xc0, 0x0, 0x0, 0xaf, 0x42, 0xfc, 0x0,
    0x0, 0xa, 0xf4, 0x2f, 0xc0, 0x0, 0x0, 0xaf,
    0x42, 0xfc, 0x0, 0x0, 0xa, 0xf4, 0x1f, 0xe0,
    0x3f, 0x30, 0xaf, 0x40, 0xef, 0x73, 0xf3, 0x3c,
    0xf4, 0x5, 0xff, 0xff, 0xff, 0xff, 0x40, 0x2,
    0x9c, 0xfa, 0x4a, 0xf4, 0x0, 0x0, 0x3f, 0x30,
    0xaf, 0x40, 0x0, 0x2, 0xd2, 0xa, 0xf4, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0x40,

    /* U+04BA "Һ" */
    0xdf, 0x20, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x20,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0x35, 0x9b, 0xcb, 0x71, 0x0, 0xdf, 0xff,
    0xff, 0xff, 0xfe, 0x30, 0xdf, 0xd7, 0x20, 0x13,
    0xbf, 0xe0, 0xdf, 0x20, 0x0, 0x0, 0xd, 0xf6,
    0xdf, 0x20, 0x0, 0x0, 0x7, 0xf9, 0xdf, 0x20,
    0x0, 0x0, 0x5, 0xfa, 0xdf, 0x20, 0x0, 0x0,
    0x5, 0xfa, 0xdf, 0x20, 0x0, 0x0, 0x5, 0xfa,
    0xdf, 0x20, 0x0, 0x0, 0x5, 0xfa, 0xdf, 0x20,
    0x0, 0x0, 0x5, 0xfa,

    /* U+04BB "һ" */
    0x4, 0x30, 0x0, 0x0, 0x0, 0x2, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0xc0, 0x0, 0x0, 0x0,
    0x2, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xc0,
    0x0, 0x0, 0x0, 0x2, 0xfc, 0x29, 0xef, 0xe9,
    0x10, 0x2f, 0xee, 0xfd, 0xdf, 0xfd, 0x2, 0xff,
    0xd2, 0x0, 0x1d, 0xf7, 0x2f, 0xf2, 0x0, 0x0,
    0x4f, 0xc2, 0xfd, 0x0, 0x0, 0x1, 0xfe, 0x2f,
    0xc0, 0x0, 0x0, 0xf, 0xe2, 0xfc, 0x0, 0x0,
    0x0, 0xfe, 0x2f, 0xc0, 0x0, 0x0, 0xf, 0xe2,
    0xfc, 0x0, 0x0, 0x0, 0xfe, 0x2f, 0xc0, 0x0,
    0x0, 0xf, 0xe2, 0xfc, 0x0, 0x0, 0x0, 0xfe,

    /* U+04BC "Ҽ" */
    0x0, 0x0, 0x0, 0x0, 0x4a, 0xdf, 0xfc, 0x81,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xbf, 0xff, 0xdd,
    0xff, 0xf6, 0x0, 0x4, 0x20, 0x0, 0xcf, 0xd4,
    0x0, 0x1, 0x7f, 0xf6, 0x2, 0xfc, 0x0, 0x8f,
    0xc0, 0x0, 0x0, 0x0, 0x4f, 0xf2, 0x5f, 0x90,
    0x1f, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x83,
    0xfe, 0x24, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xfd, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xe0, 0x7, 0xbd, 0xfe, 0xcc, 0xcc,
    0xcc, 0xcc, 0xcc, 0xca, 0x0, 0x0, 0x3f, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xef, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xfe, 0x20, 0x0, 0x0, 0x1, 0x30,
    0x0, 0x0, 0x0, 0xb, 0xfe, 0x60, 0x0, 0x17,
    0xef, 0x40, 0x0, 0x0, 0x0, 0x9, 0xff, 0xfe,
    0xef, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x3,
    0x9d, 0xff, 0xd8, 0x20, 0x0,

    /* U+04BD "ҽ" */
    0x0, 0x0, 0x0, 0x4b, 0xef, 0xd7, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0xfc, 0xbe, 0xfd, 0x10, 0x3b,
    0x30, 0x6f, 0xd2, 0x0, 0x8, 0xfb, 0x8, 0xf2,
    0xe, 0xf2, 0x0, 0x0, 0xb, 0xf3, 0x8f, 0x84,
    0xfc, 0x22, 0x22, 0x22, 0x7f, 0x71, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf9, 0x0, 0x37, 0xfd,
    0x55, 0x55, 0x55, 0x55, 0x20, 0x0, 0xf, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xd3,
    0x0, 0x1, 0xa3, 0x0, 0x0, 0x0, 0x9f, 0xfe,
    0xcd, 0xff, 0x80, 0x0, 0x0, 0x0, 0x4a, 0xef,
    0xeb, 0x40, 0x0,

    /* U+04BE "Ҿ" */
    0x0, 0x0, 0x0, 0x0, 0x4a, 0xef, 0xfc, 0x81,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xbf, 0xff, 0xdd,
    0xff, 0xf6, 0x0, 0x4, 0x20, 0x1, 0xdf, 0xd4,
    0x0, 0x1, 0x7f, 0xf6, 0x2, 0xfc, 0x0, 0x9f,
    0xc0, 0x0, 0x0, 0x0, 0x4f, 0xf1, 0x5f, 0x80,
    0x1f, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x83,
    0xfd, 0x25, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xfc, 0xc, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xe0, 0x7, 0xbd, 0xfe, 0xcc, 0xcc,
    0xcc, 0xcc, 0xcc, 0xca, 0x0, 0x0, 0x3f, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xef, 0x40, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xfe, 0x10, 0x0, 0x0, 0x2, 0x30,
    0x0, 0x0, 0x0, 0xb, 0xfe, 0x60, 0x0, 0x17,
    0xef, 0x40, 0x0, 0x0, 0x0, 0xa, 0xff, 0xfe,
    0xef, 0xff, 0x80, 0x0, 0x0, 0x0, 0x0, 0x3,
    0x9d, 0xff, 0xc8, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xd0, 0x0,
    0x0, 0x0,

    /* U+04BF "ҿ" */
    0x0, 0x0, 0x0, 0x5b, 0xef, 0xd7, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0xfc, 0xbe, 0xfd, 0x10, 0x4b,
    0x30, 0x7f, 0xc1, 0x0, 0x9, 0xfb, 0x8, 0xf2,
    0xe, 0xf1, 0x0, 0x0, 0xc, 0xf2, 0x8f, 0x74,
    0xfc, 0x22, 0x22, 0x22, 0x8f, 0x72, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf8, 0x0, 0x37, 0xfc,
    0x55, 0x55, 0x55, 0x55, 0x20, 0x0, 0xf, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xd3,
    0x0, 0x2, 0xb3, 0x0, 0x0, 0x0, 0x9f, 0xfe,
    0xcd, 0xff, 0x80, 0x0, 0x0, 0x0, 0x4a, 0xff,
    0xfb, 0x40, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf3,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x30,
    0x0, 0x0,

    /* U+04C0 "Ӏ" */
    0xdf, 0x3d, 0xf3, 0xdf, 0x3d, 0xf3, 0xdf, 0x3d,
    0xf3, 0xdf, 0x3d, 0xf3, 0xdf, 0x3d, 0xf3, 0xdf,
    0x3d, 0xf3, 0xdf, 0x3d, 0xf3,

    /* U+04C1 "Ӂ" */
    0x0, 0x0, 0x0, 0xf, 0x90, 0x2, 0xe9, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5d, 0xff,
    0xfb, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1e, 0xf2, 0x0, 0x0, 0xb, 0xf4,
    0x0, 0x0, 0x9, 0xf8, 0x0, 0x5f, 0xc0, 0x0,
    0x0, 0xbf, 0x40, 0x0, 0x3, 0xfd, 0x0, 0x0,
    0xbf, 0x60, 0x0, 0xb, 0xf4, 0x0, 0x0, 0xdf,
    0x30, 0x0, 0x1, 0xfe, 0x10, 0x0, 0xbf, 0x40,
    0x0, 0x7f, 0x90, 0x0, 0x0, 0x6, 0xfa, 0x0,
    0xb, 0xf4, 0x0, 0x2f, 0xe1, 0x0, 0x0, 0x0,
    0xc, 0xf4, 0x0, 0xbf, 0x40, 0xb, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0x8, 0xfe, 0xdd,
    0xff, 0xdd, 0xdf, 0xf1, 0x0, 0x0, 0x0, 0x2,
    0xff, 0x30, 0xb, 0xf4, 0x0, 0xaf, 0xb0, 0x0,
    0x0, 0x0, 0xcf, 0x80, 0x0, 0xbf, 0x40, 0x1,
    0xef, 0x50, 0x0, 0x0, 0x6f, 0xe0, 0x0, 0xb,
    0xf4, 0x0, 0x6, 0xfe, 0x10, 0x0, 0x1f, 0xf4,
    0x0, 0x0, 0xbf, 0x40, 0x0, 0xb, 0xf9, 0x0,
    0xb, 0xfa, 0x0, 0x0, 0xb, 0xf4, 0x0, 0x0,
    0x2f, 0xf3, 0x5, 0xfe, 0x10, 0x0, 0x0, 0xbf,
    0x40, 0x0, 0x0, 0x7f, 0xd0,

    /* U+04C2 "ӂ" */
    0x0, 0x0, 0x9, 0xb0, 0x0, 0xc8, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0x40, 0x5f, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xff, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xd0, 0x0, 0x8, 0xf6, 0x0,
    0x0, 0xef, 0x20, 0x8f, 0x60, 0x0, 0x8f, 0x60,
    0x0, 0x8f, 0x80, 0x0, 0xde, 0x10, 0x8, 0xf6,
    0x0, 0x1f, 0xe0, 0x0, 0x4, 0xf9, 0x0, 0x8f,
    0x60, 0xa, 0xf5, 0x0, 0x0, 0xa, 0xf2, 0x8,
    0xf6, 0x3, 0xfc, 0x0, 0x0, 0x0, 0x4f, 0xff,
    0xff, 0xff, 0xff, 0x30, 0x0, 0x0, 0xd, 0xfc,
    0xbd, 0xfd, 0xbd, 0xfa, 0x0, 0x0, 0x8, 0xfd,
    0x0, 0x8f, 0x60, 0x1e, 0xf4, 0x0, 0x2, 0xff,
    0x30, 0x8, 0xf6, 0x0, 0x4f, 0xe1, 0x0, 0xcf,
    0x80, 0x0, 0x8f, 0x60, 0x0, 0x9f, 0xa0, 0x7f,
    0xd0, 0x0, 0x8, 0xf6, 0x0, 0x0, 0xdf, 0x50,

    /* U+04C3 "Ӄ" */
    0xdf, 0x20, 0x0, 0x0, 0xd, 0xf4, 0xdf, 0x20,
    0x0, 0x0, 0x9f, 0x80, 0xdf, 0x20, 0x0, 0x5,
    0xfc, 0x0, 0xdf, 0x20, 0x0, 0x1e, 0xe1, 0x0,
    0xdf, 0x20, 0x0, 0xcf, 0x40, 0x0, 0xdf, 0x20,
    0x8, 0xf8, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xd0,
    0x0, 0x0, 0xdf, 0xdd, 0xdf, 0xf6, 0x0, 0x0,
    0xdf, 0x20, 0x4, 0xff, 0x50, 0x0, 0xdf, 0x20,
    0x0, 0x4f, 0xf3, 0x0, 0xdf, 0x20, 0x0, 0x6,
    0xfe, 0x10, 0xdf, 0x20, 0x0, 0x0, 0xaf, 0xa0,
    0xdf, 0x20, 0x0, 0x0, 0x1f, 0xf3, 0xdf, 0x20,
    0x0, 0x0, 0x9, 0xf9, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x9, 0xfa,
    0x0, 0x0, 0x0, 0x9d, 0xdf, 0xf4, 0x0, 0x0,
    0x0, 0x7d, 0xfd, 0x50,

    /* U+04C4 "ӄ" */
    0x2f, 0xc0, 0x0, 0x1, 0xdf, 0x22, 0xfc, 0x0,
    0x0, 0xbf, 0x40, 0x2f, 0xc0, 0x0, 0x8f, 0x70,
    0x2, 0xfc, 0x0, 0x5f, 0xa0, 0x0, 0x2f, 0xeb,
    0xbf, 0xd0, 0x0, 0x2, 0xff, 0xff, 0xff, 0x40,
    0x0, 0x2f, 0xc0, 0x4, 0xff, 0x30, 0x2, 0xfc,
    0x0, 0x5, 0xfd, 0x0, 0x2f, 0xc0, 0x0, 0x9,
    0xf8, 0x2, 0xfc, 0x0, 0x0, 0x1f, 0xf0, 0x2f,
    0xc0, 0x0, 0x0, 0xaf, 0x40, 0x0, 0x0, 0x0,
    0x8, 0xf6, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x50,
    0x0, 0x0, 0xbb, 0xcf, 0xe0, 0x0, 0x0, 0xa,
    0xef, 0xb2, 0x0,

    /* U+04C6 "ӆ" */
    0x0, 0x3f, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x4,
    0xfd, 0xbb, 0xbb, 0xff, 0x0, 0x0, 0x4f, 0x60,
    0x0, 0xf, 0xf0, 0x0, 0x5, 0xf5, 0x0, 0x0,
    0xff, 0x0, 0x0, 0x6f, 0x40, 0x0, 0xf, 0xf0,
    0x0, 0x7, 0xf3, 0x0, 0x0, 0xff, 0x0, 0x0,
    0x9f, 0x20, 0x0, 0xf, 0xf0, 0x0, 0xb, 0xf0,
    0x0, 0x0, 0xff, 0x0, 0x1, 0xfc, 0x0, 0x0,
    0xf, 0xf0, 0x8, 0xef, 0x60, 0x0, 0x0, 0xff,
    0xa5, 0xdf, 0x90, 0x0, 0x0, 0xf, 0xff, 0x40,
    0x0, 0x0, 0x0, 0x0, 0xa, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdb, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0x40,

    /* U+04C7 "Ӈ" */
    0xdf, 0x20, 0x0, 0x0, 0x0, 0xdf, 0x2d, 0xf2,
    0x0, 0x0, 0x0, 0xd, 0xf2, 0xdf, 0x20, 0x0,
    0x0, 0x0, 0xdf, 0x2d, 0xf2, 0x0, 0x0, 0x0,
    0xd, 0xf2, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xdf,
    0x2d, 0xf2, 0x0, 0x0, 0x0, 0xd, 0xf2, 0xdf,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x2d, 0xfd, 0xcc,
    0xcc, 0xcc, 0xcf, 0xf2, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0xdf, 0x2d, 0xf2, 0x0, 0x0, 0x0, 0xd,
    0xf2, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xdf, 0x2d,
    0xf2, 0x0, 0x0, 0x0, 0xd, 0xf2, 0xdf, 0x20,
    0x0, 0x0, 0x0, 0xdf, 0x2d, 0xf2, 0x0, 0x0,
    0x0, 0xd, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0x10, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xf0,
    0x0, 0x0, 0x0, 0x4e, 0xbf, 0xfa, 0x0, 0x0,
    0x0, 0x4, 0xdf, 0xe9, 0x0,

    /* U+04C8 "ӈ" */
    0x2f, 0xc0, 0x0, 0x0, 0x1f, 0xd2, 0xfc, 0x0,
    0x0, 0x1, 0xfd, 0x2f, 0xc0, 0x0, 0x0, 0x1f,
    0xd2, 0xfc, 0x0, 0x0, 0x1, 0xfd, 0x2f, 0xeb,
    0xbb, 0xbb, 0xbf, 0xd2, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0x2f, 0xc0, 0x0, 0x0, 0x1f, 0xd2, 0xfc,
    0x0, 0x0, 0x1, 0xfd, 0x2f, 0xc0, 0x0, 0x0,
    0x1f, 0xd2, 0xfc, 0x0, 0x0, 0x1, 0xfd, 0x2f,
    0xc0, 0x0, 0x0, 0x1f, 0xd0, 0x0, 0x0, 0x0,
    0x1, 0xfd, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xb0,
    0x0, 0x0, 0x7d, 0xbf, 0xf5, 0x0, 0x0, 0x6,
    0xdf, 0xd6, 0x0,

    /* U+04C9 "Ӊ" */
    0xdf, 0x20, 0x0, 0x0, 0x0, 0xcf, 0x30, 0xd,
    0xf2, 0x0, 0x0, 0x0, 0xc, 0xf3, 0x0, 0xdf,
    0x20, 0x0, 0x0, 0x0, 0xcf, 0x30, 0xd, 0xf2,
    0x0, 0x0, 0x0, 0xc, 0xf3, 0x0, 0xdf, 0x20,
    0x0, 0x0, 0x0, 0xcf, 0x30, 0xd, 0xf2, 0x0,
    0x0, 0x0, 0xc, 0xf3, 0x0, 0xdf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x30, 0xd, 0xfd, 0xcc, 0xcc,
    0xcc, 0xcf, 0xf3, 0x0, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0xcf, 0x30, 0xd, 0xf2, 0x0, 0x0, 0x0,
    0xc, 0xf3, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x0,
    0xcf, 0x30, 0xd, 0xf2, 0x0, 0x0, 0x0, 0xc,
    0xf3, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xff,
    0xfc, 0x1d, 0xf2, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf0, 0x0,

    /* U+04CA "ӊ" */
    0x2f, 0xc0, 0x0, 0x0, 0x3f, 0xb0, 0x2, 0xfc,
    0x0, 0x0, 0x3, 0xfb, 0x0, 0x2f, 0xc0, 0x0,
    0x0, 0x3f, 0xb0, 0x2, 0xfc, 0x0, 0x0, 0x3,
    0xfb, 0x0, 0x2f, 0xc0, 0x0, 0x0, 0x3f, 0xb0,
    0x2, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x0, 0x2f,
    0xeb, 0xbb, 0xbb, 0xcf, 0xb0, 0x2, 0xfc, 0x0,
    0x0, 0x3, 0xfb, 0x0, 0x2f, 0xc0, 0x0, 0x0,
    0x3f, 0xb0, 0x2, 0xfc, 0x0, 0x0, 0x5, 0xff,
    0xb3, 0x2f, 0xc0, 0x0, 0x0, 0x6f, 0xff, 0x10,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x18, 0x20,

    /* U+04CB "Ӌ" */
    0xff, 0x0, 0x0, 0x0, 0x8, 0xf7, 0xff, 0x0,
    0x0, 0x0, 0x8, 0xf7, 0xff, 0x0, 0x0, 0x0,
    0x8, 0xf7, 0xff, 0x0, 0x0, 0x0, 0x8, 0xf7,
    0xff, 0x10, 0x0, 0x0, 0x8, 0xf7, 0xdf, 0x60,
    0x0, 0x0, 0x8, 0xf7, 0x7f, 0xf7, 0x20, 0x13,
    0x8e, 0xf7, 0xa, 0xff, 0xff, 0xff, 0xff, 0xf7,
    0x0, 0x49, 0xcc, 0xb8, 0x38, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x8, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x8, 0xf7,
    0x0, 0x0, 0x0, 0xb, 0xce, 0xf7, 0x0, 0x0,
    0x0, 0xf, 0xff, 0xf7, 0x0, 0x0, 0x0, 0xf,
    0xe0, 0x0, 0x0, 0x0, 0x0, 0xf, 0xe0, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xe0, 0x0,

    /* U+04CC "ӌ" */
    0x3f, 0xb0, 0x0, 0x0, 0xaf, 0x43, 0xfb, 0x0,
    0x0, 0xa, 0xf4, 0x3f, 0xb0, 0x0, 0x0, 0xaf,
    0x43, 0xfc, 0x0, 0x0, 0xa, 0xf4, 0x1f, 0xf3,
    0x0, 0x1, 0xbf, 0x40, 0x9f, 0xfb, 0xac, 0xff,
    0xf4, 0x0, 0x6c, 0xfe, 0xc8, 0xbf, 0x40, 0x0,
    0x0, 0x0, 0xa, 0xf4, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0x40, 0x0, 0x0, 0x7, 0xff, 0xf4, 0x0,
    0x0, 0x0, 0x8f, 0xff, 0x40, 0x0, 0x0, 0x8,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x50, 0x0,

    /* U+04CD "Ӎ" */
    0xdf, 0x20, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf0,
    0x0, 0xdf, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0xf0, 0x0, 0xdf, 0xf4, 0x0, 0x0, 0x0, 0x1,
    0xff, 0xf0, 0x0, 0xdf, 0xfd, 0x0, 0x0, 0x0,
    0xa, 0xff, 0xf0, 0x0, 0xdf, 0x9f, 0x70, 0x0,
    0x0, 0x3f, 0xae, 0xf0, 0x0, 0xdf, 0x1e, 0xf1,
    0x0, 0x0, 0xdf, 0x2e, 0xf0, 0x0, 0xdf, 0x15,
    0xfa, 0x0, 0x6, 0xf7, 0xd, 0xf0, 0x0, 0xdf,
    0x10, 0xbf, 0x40, 0x1e, 0xd0, 0xd, 0xf0, 0x0,
    0xdf, 0x10, 0x2f, 0xd0, 0x9f, 0x40, 0xd, 0xf0,
    0x0, 0xdf, 0x10, 0x8, 0xf9, 0xfb, 0x0, 0xd,
    0xf0, 0x0, 0xdf, 0x10, 0x0, 0xef, 0xf2, 0x0,
    0xd, 0xf0, 0x0, 0xdf, 0x10, 0x0, 0x5f, 0x80,
    0x0, 0xd, 0xf0, 0x0, 0xdf, 0x10, 0x0, 0x3,
    0x0, 0x0, 0xf, 0xfd, 0xc1, 0xdf, 0x10, 0x0,
    0x0, 0x0, 0x0, 0xf, 0xff, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0x90, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x40,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf,
    0x0,

    /* U+04CE "ӎ" */
    0x2f, 0xf1, 0x0, 0x0, 0x0, 0x1f, 0xf1, 0x2,
    0xff, 0xa0, 0x0, 0x0, 0x9, 0xff, 0x10, 0x2f,
    0xff, 0x30, 0x0, 0x2, 0xff, 0xf1, 0x2, 0xfb,
    0xfc, 0x0, 0x0, 0xbe, 0xcf, 0x10, 0x2f, 0x98,
    0xf5, 0x0, 0x5f, 0x6b, 0xf1, 0x2, 0xf9, 0xe,
    0xd0, 0xd, 0xd0, 0xbf, 0x10, 0x2f, 0x90, 0x5f,
    0x77, 0xf4, 0xb, 0xf1, 0x2, 0xf9, 0x0, 0xcf,
    0xfa, 0x0, 0xbf, 0x10, 0x2f, 0x90, 0x3, 0xff,
    0x20, 0xb, 0xf1, 0x2, 0xf9, 0x0, 0x8, 0x70,
    0x0, 0xff, 0xc9, 0x2f, 0x90, 0x0, 0x0, 0x0,
    0xf, 0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x9f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0x60,

    /* U+04CF "ӏ" */
    0x4, 0x32, 0xfc, 0x2f, 0xc2, 0xfc, 0x2f, 0xc2,
    0xfc, 0x2f, 0xc2, 0xfc, 0x2f, 0xc2, 0xfc, 0x2f,
    0xc2, 0xfc, 0x2f, 0xc2, 0xfc, 0x2f, 0xc2, 0xfc,

    /* U+04D0 "Ӑ" */
    0x0, 0x0, 0xbc, 0x10, 0x1b, 0xe0, 0x0, 0x0,
    0x0, 0x2, 0xcf, 0xff, 0xd3, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xf9, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x1, 0xfe,
    0xd, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x70,
    0x6f, 0x90, 0x0, 0x0, 0x0, 0xe, 0xf1, 0x0,
    0xef, 0x10, 0x0, 0x0, 0x6, 0xf9, 0x0, 0x8,
    0xf7, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0, 0x1f,
    0xe0, 0x0, 0x0, 0x4f, 0xb0, 0x0, 0x0, 0xaf,
    0x60, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0x0, 0x3, 0xfe, 0xaa, 0xaa, 0xaa, 0xae, 0xf5,
    0x0, 0xaf, 0x60, 0x0, 0x0, 0x0, 0x5f, 0xc0,
    0x1f, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x38,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfa,

    /* U+04D1 "ӑ" */
    0x0, 0x27, 0x0, 0x3, 0x60, 0x0, 0x0, 0x2f,
    0x60, 0x2d, 0xb0, 0x0, 0x0, 0x6, 0xff, 0xfc,
    0x20, 0x0, 0x0, 0x0, 0x2, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xae, 0xfd, 0x70, 0xfe, 0x0, 0x7f, 0xfe, 0xce,
    0xfb, 0xfe, 0x3, 0xff, 0x50, 0x0, 0x6f, 0xfe,
    0xb, 0xf6, 0x0, 0x0, 0x7, 0xfe, 0xf, 0xf0,
    0x0, 0x0, 0x1, 0xfe, 0xf, 0xe0, 0x0, 0x0,
    0x0, 0xfe, 0xf, 0xf0, 0x0, 0x0, 0x1, 0xfe,
    0xb, 0xf6, 0x0, 0x0, 0x8, 0xfe, 0x3, 0xff,
    0x50, 0x0, 0x6f, 0xfe, 0x0, 0x7f, 0xfe, 0xce,
    0xfc, 0xfe, 0x0, 0x3, 0xbe, 0xfd, 0x70, 0xee,

    /* U+04D2 "Ӓ" */
    0x0, 0x0, 0x2e, 0x70, 0x5f, 0x30, 0x0, 0x0,
    0x0, 0x2, 0xf9, 0x7, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x1, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0x9,
    0xf9, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x1, 0xfe,
    0xd, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x70,
    0x6f, 0x90, 0x0, 0x0, 0x0, 0xe, 0xf1, 0x0,
    0xef, 0x10, 0x0, 0x0, 0x6, 0xf9, 0x0, 0x8,
    0xf7, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0, 0x1f,
    0xe0, 0x0, 0x0, 0x4f, 0xb0, 0x0, 0x0, 0xaf,
    0x60, 0x0, 0xb, 0xff, 0xff, 0xff, 0xff, 0xfd,
    0x0, 0x3, 0xfe, 0xaa, 0xaa, 0xaa, 0xae, 0xf5,
    0x0, 0xaf, 0x60, 0x0, 0x0, 0x0, 0x5f, 0xc0,
    0x1f, 0xe0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x38,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfa,

    /* U+04D3 "ӓ" */
    0x0, 0xd, 0xa0, 0x3e, 0x60, 0x0, 0x0, 0xe,
    0xc0, 0x4f, 0x70, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xae, 0xfd, 0x70, 0xfe,
    0x0, 0x7f, 0xfe, 0xce, 0xfb, 0xfe, 0x3, 0xff,
    0x50, 0x0, 0x6f, 0xfe, 0xb, 0xf6, 0x0, 0x0,
    0x7, 0xfe, 0xf, 0xf0, 0x0, 0x0, 0x1, 0xfe,
    0xf, 0xe0, 0x0, 0x0, 0x0, 0xfe, 0xf, 0xf0,
    0x0, 0x0, 0x1, 0xfe, 0xb, 0xf6, 0x0, 0x0,
    0x8, 0xfe, 0x3, 0xff, 0x50, 0x0, 0x6f, 0xfe,
    0x0, 0x7f, 0xfe, 0xce, 0xfc, 0xfe, 0x0, 0x3,
    0xbe, 0xfd, 0x70, 0xee,

    /* U+04D4 "Ӕ" */
    0x0, 0x0, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xff,
    0xff, 0xfb, 0x0, 0x0, 0x0, 0x7, 0xfe, 0xff,
    0xcc, 0xcc, 0xcc, 0xc8, 0x0, 0x0, 0x0, 0x1f,
    0xe4, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xaf, 0x63, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xfc, 0x3, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xf3, 0x3, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xa0,
    0x3, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x0, 0x1,
    0xef, 0x10, 0x3, 0xff, 0xcc, 0xcc, 0xcc, 0x90,
    0x0, 0x9, 0xf7, 0x0, 0x3, 0xfc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0xaa, 0xaa,
    0xab, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfb,
    0x0, 0x0, 0x3, 0xfc, 0x0, 0x0, 0x0, 0x0,
    0x1e, 0xf2, 0x0, 0x0, 0x3, 0xff, 0xcc, 0xcc,
    0xcc, 0xcb, 0x9f, 0x70, 0x0, 0x0, 0x3, 0xff,
    0xff, 0xff, 0xff, 0xff,

    /* U+04D5 "ӕ" */
    0x0, 0x5b, 0xef, 0xeb, 0x30, 0x18, 0xdf, 0xea,
    0x20, 0x0, 0x8f, 0xfc, 0xbe, 0xff, 0x6d, 0xfe,
    0xbd, 0xff, 0x40, 0x3, 0x91, 0x0, 0x8, 0xff,
    0xf7, 0x0, 0x5, 0xff, 0x10, 0x0, 0x0, 0x0,
    0xe, 0xfa, 0x0, 0x0, 0x7, 0xf8, 0x0, 0x0,
    0x11, 0x22, 0xcf, 0x52, 0x22, 0x22, 0x3f, 0xc0,
    0x9, 0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xfd, 0xa, 0xfb, 0x65, 0x55, 0xdf, 0x75, 0x55,
    0x55, 0x55, 0x40, 0xfe, 0x0, 0x0, 0xe, 0xf9,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xf3, 0x0, 0x8,
    0xff, 0xf8, 0x0, 0x0, 0x87, 0x0, 0x8f, 0xfd,
    0xce, 0xfc, 0x3e, 0xff, 0xcc, 0xff, 0xc0, 0x0,
    0x5c, 0xef, 0xd7, 0x0, 0x18, 0xdf, 0xfc, 0x70,
    0x0,

    /* U+04D6 "Ӗ" */
    0x2, 0xf6, 0x0, 0x4f, 0x60, 0x0, 0x7, 0xef,
    0xff, 0x90, 0x0, 0x0, 0x0, 0x11, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0xff,
    0xff, 0xff, 0xff, 0xd, 0xfd, 0xcc, 0xcc, 0xcc,
    0xc0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xd, 0xf2,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0xd, 0xf2, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0xff, 0xff, 0xff, 0xf3, 0xd, 0xfc, 0xcc, 0xcc,
    0xcc, 0x20, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xd,
    0xf2, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0,
    0x0, 0x0, 0xd, 0xf2, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0xdc, 0xcc, 0xcc, 0xcc, 0x3d, 0xff, 0xff,
    0xff, 0xff, 0xf5,

    /* U+04D7 "ӗ" */
    0x0, 0x7, 0x20, 0x0, 0x82, 0x0, 0x0, 0xc,
    0xb1, 0x8, 0xf1, 0x0, 0x0, 0x2, 0xdf, 0xfe,
    0x60, 0x0, 0x0, 0x0, 0x1, 0x20, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4,
    0xbe, 0xfc, 0x60, 0x0, 0x0, 0x8f, 0xfc, 0xbe,
    0xfb, 0x0, 0x5, 0xfd, 0x20, 0x0, 0x9f, 0x80,
    0xc, 0xf3, 0x0, 0x0, 0xd, 0xf0, 0xf, 0xe1,
    0x11, 0x11, 0x18, 0xf4, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0xf6, 0xf, 0xe4, 0x44, 0x44, 0x44, 0x41,
    0xc, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x4, 0xfe,
    0x40, 0x0, 0x2b, 0x20, 0x0, 0x7f, 0xfe, 0xcd,
    0xff, 0x60, 0x0, 0x3, 0xae, 0xfe, 0xa3, 0x0,

    /* U+04D8 "Ә" */
    0x0, 0x0, 0x39, 0xdf, 0xfd, 0x93, 0x0, 0x0,
    0x0, 0x1b, 0xff, 0xfd, 0xef, 0xff, 0xa0, 0x0,
    0x0, 0x6f, 0xc5, 0x0, 0x0, 0x6e, 0xfc, 0x0,
    0x0, 0x3, 0x0, 0x0, 0x0, 0x1, 0xdf, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xf0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf4,
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6,
    0x2f, 0xf8, 0x88, 0x88, 0x88, 0x88, 0x8d, 0xf5,
    0xf, 0xf1, 0x0, 0x0, 0x0, 0x0, 0xd, 0xf3,
    0xb, 0xf7, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xe0,
    0x4, 0xff, 0x30, 0x0, 0x0, 0x1, 0xef, 0x70,
    0x0, 0x8f, 0xf7, 0x0, 0x0, 0x6e, 0xfb, 0x0,
    0x0, 0x7, 0xff, 0xfd, 0xdf, 0xff, 0x90, 0x0,
    0x0, 0x0, 0x28, 0xdf, 0xfd, 0x93, 0x0, 0x0,

    /* U+04D9 "ә" */
    0x0, 0x7c, 0xff, 0xc7, 0x0, 0x0, 0xdf, 0xfc,
    0xcf, 0xfd, 0x20, 0x9, 0x70, 0x0, 0x1a, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xf4, 0x11, 0x11,
    0x11, 0x11, 0x6f, 0x9d, 0xff, 0xff, 0xff, 0xff,
    0xfa, 0xcf, 0x54, 0x44, 0x44, 0x8f, 0x98, 0xf5,
    0x0, 0x0, 0xa, 0xf5, 0x1f, 0xe3, 0x0, 0x6,
    0xfd, 0x0, 0x5f, 0xfc, 0xbe, 0xfe, 0x20, 0x0,
    0x3a, 0xef, 0xd8, 0x10, 0x0,

    /* U+04DA "Ӛ" */
    0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xf4, 0xc, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0x6, 0xe3, 0xa, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x49, 0xdf, 0xfd, 0x93, 0x0, 0x0,
    0x0, 0x1c, 0xff, 0xfd, 0xef, 0xff, 0x90, 0x0,
    0x0, 0x7f, 0xc5, 0x0, 0x0, 0x6e, 0xfb, 0x0,
    0x0, 0x3, 0x0, 0x0, 0x0, 0x1, 0xdf, 0x70,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc, 0xf3,
    0x3f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,
    0x2f, 0xe8, 0x88, 0x88, 0x88, 0x88, 0x8d, 0xf5,
    0xf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xf3,
    0xb, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xe0,
    0x4, 0xff, 0x20, 0x0, 0x0, 0x1, 0xef, 0x70,
    0x0, 0x9f, 0xf6, 0x0, 0x0, 0x6e, 0xfb, 0x0,
    0x0, 0x8, 0xff, 0xfd, 0xdf, 0xff, 0x90, 0x0,
    0x0, 0x0, 0x29, 0xdf, 0xfd, 0x93, 0x0, 0x0,

    /* U+04DB "ӛ" */
    0x0, 0x4f, 0x40, 0x8e, 0x10, 0x0, 0x5, 0xf5,
    0xa, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xcf, 0xfc, 0x70, 0x0, 0xd, 0xff,
    0xcc, 0xff, 0xd1, 0x0, 0x97, 0x0, 0x1, 0xaf,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x41, 0x11,
    0x11, 0x11, 0x16, 0xf8, 0xef, 0xff, 0xff, 0xff,
    0xff, 0xac, 0xf4, 0x44, 0x44, 0x48, 0xf8, 0x8f,
    0x50, 0x0, 0x0, 0xaf, 0x42, 0xfe, 0x30, 0x0,
    0x7f, 0xd0, 0x5, 0xff, 0xcb, 0xef, 0xe2, 0x0,
    0x3, 0xae, 0xfd, 0x81, 0x0,

    /* U+04DC "Ӝ" */
    0x0, 0x0, 0x0, 0x5, 0xf3, 0x9, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x40,
    0xbf, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1e, 0xf2, 0x0, 0x0, 0xb, 0xf4,
    0x0, 0x0, 0x9, 0xf8, 0x0, 0x5f, 0xc0, 0x0,
    0x0, 0xbf, 0x40, 0x0, 0x3, 0xfd, 0x0, 0x0,
    0xbf, 0x60, 0x0, 0xb, 0xf4, 0x0, 0x0, 0xdf,
    0x30, 0x0, 0x1, 0xfe, 0x10, 0x0, 0xbf, 0x40,
    0x0, 0x7f, 0x90, 0x0, 0x0, 0x6, 0xfa, 0x0,
    0xb, 0xf4, 0x0, 0x2f, 0xe1, 0x0, 0x0, 0x0,
    0xc, 0xf4, 0x0, 0xbf, 0x40, 0xb, 0xf5, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0xff, 0xff, 0xff, 0xff,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0x8, 0xfe, 0xdd,
    0xff, 0xdd, 0xdf, 0xf1, 0x0, 0x0, 0x0, 0x2,
    0xff, 0x30, 0xb, 0xf4, 0x0, 0xaf, 0xb0, 0x0,
    0x0, 0x0, 0xcf, 0x80, 0x0, 0xbf, 0x40, 0x1,
    0xef, 0x50, 0x0, 0x0, 0x6f, 0xe0, 0x0, 0xb,
    0xf4, 0x0, 0x6, 0xfe, 0x10, 0x0, 0x1f, 0xf4,
    0x0, 0x0, 0xbf, 0x40, 0x0, 0xb, 0xf9, 0x0,
    0xb, 0xfa, 0x0, 0x0, 0xb, 0xf4, 0x0, 0x0,
    0x2f, 0xf3, 0x5, 0xfe, 0x10, 0x0, 0x0, 0xbf,
    0x40, 0x0, 0x0, 0x7f, 0xd0,

    /* U+04DD "ӝ" */
    0x0, 0x0, 0x3, 0xf6, 0x7, 0xe2, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0x70, 0x8f, 0x30, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xfd, 0x0, 0x0, 0x8f, 0x60, 0x0,
    0xe, 0xf2, 0x8, 0xf6, 0x0, 0x8, 0xf6, 0x0,
    0x8, 0xf8, 0x0, 0xd, 0xe1, 0x0, 0x8f, 0x60,
    0x1, 0xfe, 0x0, 0x0, 0x4f, 0x90, 0x8, 0xf6,
    0x0, 0xaf, 0x50, 0x0, 0x0, 0xaf, 0x20, 0x8f,
    0x60, 0x3f, 0xc0, 0x0, 0x0, 0x4, 0xff, 0xff,
    0xff, 0xff, 0xf3, 0x0, 0x0, 0x0, 0xdf, 0xcb,
    0xdf, 0xdb, 0xdf, 0xa0, 0x0, 0x0, 0x8f, 0xd0,
    0x8, 0xf6, 0x1, 0xef, 0x40, 0x0, 0x2f, 0xf3,
    0x0, 0x8f, 0x60, 0x4, 0xfe, 0x10, 0xc, 0xf8,
    0x0, 0x8, 0xf6, 0x0, 0x9, 0xfa, 0x7, 0xfd,
    0x0, 0x0, 0x8f, 0x60, 0x0, 0xd, 0xf5,

    /* U+04DE "Ӟ" */
    0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xf5, 0xa, 0xf1, 0x0, 0x0, 0x4, 0xf4, 0x8,
    0xe1, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x6b,
    0xef, 0xfd, 0x81, 0x0, 0xb, 0xff, 0xed, 0xdf,
    0xff, 0x30, 0x4, 0x61, 0x0, 0x1, 0x9f, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xc0, 0x0, 0x8, 0xaa, 0xbd,
    0xfc, 0x20, 0x0, 0xc, 0xff, 0xff, 0xfa, 0x10,
    0x0, 0x0, 0x0, 0x2, 0x8f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xf7, 0x0, 0x0, 0x0, 0x0,
    0x6, 0xf9, 0x1, 0x0, 0x0, 0x0, 0xa, 0xf8,
    0x1e, 0x81, 0x0, 0x0, 0x8f, 0xf2, 0x2d, 0xff,
    0xcb, 0xcf, 0xff, 0x50, 0x0, 0x6b, 0xff, 0xfd,
    0x92, 0x0,

    /* U+04DF "ӟ" */
    0x0, 0x6e, 0x30, 0xad, 0x0, 0x0, 0x7f, 0x40,
    0xce, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0x9d, 0xff, 0xd8, 0x0, 0xd, 0xfd, 0xbc, 0xff,
    0xd0, 0x4, 0x20, 0x0, 0x1c, 0xf6, 0x0, 0x0,
    0x0, 0x8, 0xf6, 0x0, 0x1, 0x12, 0x6e, 0xe1,
    0x0, 0x9, 0xff, 0xfe, 0x20, 0x0, 0x2, 0x45,
    0x7e, 0xf4, 0x0, 0x0, 0x0, 0x4, 0xfb, 0x7,
    0x10, 0x0, 0x9, 0xfa, 0x4f, 0xfd, 0xbb, 0xef,
    0xe2, 0x4, 0xad, 0xff, 0xd8, 0x10,

    /* U+04E0 "Ӡ" */
    0xd, 0xff, 0xff, 0xff, 0xff, 0xd0, 0xa, 0xcc,
    0xcc, 0xcc, 0xef, 0xa0, 0x0, 0x0, 0x0, 0x5,
    0xfb, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xb0, 0x0,
    0x0, 0x0, 0x5, 0xfb, 0x0, 0x0, 0x0, 0x0,
    0x4f, 0xf8, 0x40, 0x0, 0x0, 0x0, 0x6f, 0xff,
    0xfd, 0x20, 0x0, 0x0, 0x0, 0x13, 0xbf, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0xd, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xf7, 0x2, 0x0, 0x0, 0x0,
    0xc, 0xf5, 0x1f, 0x93, 0x0, 0x1, 0x9f, 0xf0,
    0x2d, 0xff, 0xed, 0xdf, 0xff, 0x40, 0x0, 0x5a,
    0xef, 0xfd, 0x92, 0x0,

    /* U+04E1 "ӡ" */
    0xe, 0xff, 0xff, 0xff, 0xff, 0x40, 0xac, 0xcc,
    0xcc, 0xcf, 0xf2, 0x0, 0x0, 0x0, 0x9, 0xf7,
    0x0, 0x0, 0x0, 0x5, 0xfb, 0x0, 0x0, 0x0,
    0x2, 0xfe, 0x10, 0x0, 0x0, 0x0, 0xcf, 0x40,
    0x0, 0x0, 0x0, 0x8f, 0xd6, 0x20, 0x0, 0x0,
    0xa, 0xff, 0xff, 0x80, 0x0, 0x0, 0x0, 0x16,
    0xff, 0x50, 0x0, 0x0, 0x0, 0x6, 0xfb, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0xd0, 0x20, 0x0, 0x0,
    0x5, 0xfb, 0x1f, 0x92, 0x0, 0x3, 0xef, 0x62,
    0xdf, 0xfe, 0xdf, 0xff, 0xa0, 0x0, 0x6b, 0xef,
    0xec, 0x60, 0x0,

    /* U+04E2 "Ӣ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xff, 0xff, 0xff, 0x70, 0x0, 0x0, 0x3, 0x33,
    0x33, 0x31, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x1, 0xef,
    0x4d, 0xf2, 0x0, 0x0, 0x0, 0xbf, 0xf4, 0xdf,
    0x20, 0x0, 0x0, 0x7f, 0xff, 0x4d, 0xf2, 0x0,
    0x0, 0x4f, 0xfd, 0xf4, 0xdf, 0x20, 0x0, 0x1e,
    0xf5, 0xbf, 0x4d, 0xf2, 0x0, 0xc, 0xf8, 0xb,
    0xf4, 0xdf, 0x20, 0x9, 0xfc, 0x0, 0xbf, 0x4d,
    0xf2, 0x5, 0xfe, 0x10, 0xb, 0xf4, 0xdf, 0x22,
    0xff, 0x30, 0x0, 0xbf, 0x4d, 0xf2, 0xdf, 0x70,
    0x0, 0xb, 0xf4, 0xdf, 0xcf, 0xb0, 0x0, 0x0,
    0xbf, 0x4d, 0xff, 0xd0, 0x0, 0x0, 0xb, 0xf4,
    0xdf, 0xf3, 0x0, 0x0, 0x0, 0xbf, 0x4d, 0xf6,
    0x0, 0x0, 0x0, 0xb, 0xf4,

    /* U+04E3 "ӣ" */
    0x0, 0x7f, 0xff, 0xff, 0xf1, 0x0, 0x1, 0x33,
    0x33, 0x33, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xfc, 0x0, 0x0, 0x2, 0xff, 0x2f, 0xc0,
    0x0, 0x1, 0xdf, 0xf2, 0xfc, 0x0, 0x0, 0xbf,
    0xff, 0x2f, 0xc0, 0x0, 0x9f, 0xae, 0xf2, 0xfc,
    0x0, 0x6f, 0xc0, 0xef, 0x2f, 0xc0, 0x3f, 0xe1,
    0xe, 0xf2, 0xfc, 0x1e, 0xf4, 0x0, 0xef, 0x2f,
    0xcc, 0xf6, 0x0, 0xe, 0xf2, 0xff, 0xf9, 0x0,
    0x0, 0xef, 0x2f, 0xfc, 0x0, 0x0, 0xe, 0xf2,
    0xfe, 0x10, 0x0, 0x0, 0xef,

    /* U+04E4 "Ӥ" */
    0x0, 0x7, 0xe2, 0xb, 0xc0, 0x0, 0x0, 0x0,
    0x8f, 0x30, 0xde, 0x0, 0x0, 0x0, 0x0, 0x10,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x1, 0xef,
    0x4d, 0xf2, 0x0, 0x0, 0x0, 0xbf, 0xf4, 0xdf,
    0x20, 0x0, 0x0, 0x7f, 0xff, 0x4d, 0xf2, 0x0,
    0x0, 0x4f, 0xfd, 0xf4, 0xdf, 0x20, 0x0, 0x1e,
    0xf5, 0xbf, 0x4d, 0xf2, 0x0, 0xc, 0xf8, 0xb,
    0xf4, 0xdf, 0x20, 0x9, 0xfc, 0x0, 0xbf, 0x4d,
    0xf2, 0x5, 0xfe, 0x10, 0xb, 0xf4, 0xdf, 0x22,
    0xff, 0x30, 0x0, 0xbf, 0x4d, 0xf2, 0xdf, 0x70,
    0x0, 0xb, 0xf4, 0xdf, 0xcf, 0xb0, 0x0, 0x0,
    0xbf, 0x4d, 0xff, 0xd0, 0x0, 0x0, 0xb, 0xf4,
    0xdf, 0xf3, 0x0, 0x0, 0x0, 0xbf, 0x4d, 0xf6,
    0x0, 0x0, 0x0, 0xb, 0xf4,

    /* U+04E5 "ӥ" */
    0x0, 0xd, 0xb0, 0x2e, 0x70, 0x0, 0x0, 0xec,
    0x3, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xfc, 0x0, 0x0, 0x2, 0xff, 0x2f, 0xc0,
    0x0, 0x1, 0xdf, 0xf2, 0xfc, 0x0, 0x0, 0xbf,
    0xff, 0x2f, 0xc0, 0x0, 0x9f, 0xae, 0xf2, 0xfc,
    0x0, 0x6f, 0xc0, 0xef, 0x2f, 0xc0, 0x3f, 0xe1,
    0xe, 0xf2, 0xfc, 0x1e, 0xf4, 0x0, 0xef, 0x2f,
    0xcc, 0xf6, 0x0, 0xe, 0xf2, 0xff, 0xf9, 0x0,
    0x0, 0xef, 0x2f, 0xfc, 0x0, 0x0, 0xe, 0xf2,
    0xfe, 0x10, 0x0, 0x0, 0xef,

    /* U+04E6 "Ӧ" */
    0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xf7, 0x8, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0x60, 0x7e, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xce, 0xfe, 0xb6, 0x0, 0x0, 0x0, 0x4e, 0xff,
    0xed, 0xef, 0xfe, 0x30, 0x0, 0x5f, 0xf9, 0x20,
    0x0, 0x3b, 0xff, 0x30, 0x1f, 0xf6, 0x0, 0x0,
    0x0, 0x8, 0xfe, 0x8, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xf6, 0xdf, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x5f, 0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xfd, 0xff, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0xdd, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xfb, 0x8f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0x61, 0xff, 0x60, 0x0, 0x0, 0x0, 0x8f, 0xe0,
    0x5, 0xff, 0xa2, 0x0, 0x3, 0xbf, 0xf3, 0x0,
    0x4, 0xef, 0xfe, 0xdf, 0xff, 0xe3, 0x0, 0x0,
    0x0, 0x7c, 0xef, 0xeb, 0x60, 0x0, 0x0,

    /* U+04E7 "ӧ" */
    0x0, 0x4, 0xf4, 0x8, 0xe1, 0x0, 0x0, 0x5,
    0xf5, 0xa, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xae, 0xfd, 0x92, 0x0,
    0x0, 0x7f, 0xfd, 0xce, 0xff, 0x40, 0x4, 0xfe,
    0x40, 0x0, 0x7f, 0xe1, 0xc, 0xf5, 0x0, 0x0,
    0x9, 0xf8, 0xf, 0xe0, 0x0, 0x0, 0x3, 0xfc,
    0x1f, 0xd0, 0x0, 0x0, 0x1, 0xfd, 0xf, 0xe0,
    0x0, 0x0, 0x3, 0xfc, 0xc, 0xf5, 0x0, 0x0,
    0x9, 0xf7, 0x4, 0xfe, 0x40, 0x0, 0x7f, 0xe1,
    0x0, 0x7f, 0xfe, 0xce, 0xfe, 0x40, 0x0, 0x3,
    0xae, 0xfd, 0x92, 0x0,

    /* U+04E8 "Ө" */
    0x0, 0x0, 0x7b, 0xef, 0xeb, 0x60, 0x0, 0x0,
    0x4, 0xef, 0xfe, 0xde, 0xff, 0xe3, 0x0, 0x4,
    0xff, 0x92, 0x0, 0x2, 0xaf, 0xf4, 0x1, 0xff,
    0x50, 0x0, 0x0, 0x0, 0x6f, 0xe0, 0x8f, 0x90,
    0x0, 0x0, 0x0, 0x0, 0xaf, 0x6c, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xfb, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xdf, 0xfa, 0xaa, 0xaa,
    0xaa, 0xaa, 0xab, 0xfd, 0xcf, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0xb8, 0xfb, 0x0, 0x0, 0x0,
    0x0, 0xc, 0xf6, 0x1e, 0xf7, 0x0, 0x0, 0x0,
    0x8, 0xfe, 0x0, 0x4f, 0xfa, 0x30, 0x0, 0x3b,
    0xff, 0x40, 0x0, 0x4e, 0xff, 0xed, 0xff, 0xfe,
    0x30, 0x0, 0x0, 0x7, 0xbe, 0xfe, 0xb6, 0x0,
    0x0,

    /* U+04E9 "ө" */
    0x0, 0x3, 0xae, 0xfe, 0xa3, 0x0, 0x0, 0x6,
    0xff, 0xb9, 0xbf, 0xf6, 0x0, 0x4, 0xfe, 0x20,
    0x0, 0x2e, 0xf4, 0x0, 0xbf, 0x30, 0x0, 0x0,
    0x3f, 0xb0, 0xf, 0xe1, 0x11, 0x11, 0x11, 0xef,
    0x1, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0xf,
    0xe4, 0x44, 0x44, 0x44, 0xef, 0x0, 0xbf, 0x30,
    0x0, 0x0, 0x3f, 0xb0, 0x4, 0xfd, 0x20, 0x0,
    0x2d, 0xf4, 0x0, 0x6, 0xff, 0xb9, 0xbf, 0xf6,
    0x0, 0x0, 0x3, 0xae, 0xfe, 0xa3, 0x0, 0x0,

    /* U+04EA "Ӫ" */
    0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x0, 0x0,
    0x0, 0x4, 0xf7, 0x8, 0xf3, 0x0, 0x0, 0x0,
    0x0, 0x3f, 0x60, 0x7e, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7,
    0xce, 0xfe, 0xb6, 0x0, 0x0, 0x0, 0x4e, 0xff,
    0xed, 0xef, 0xfe, 0x30, 0x0, 0x5f, 0xf9, 0x20,
    0x0, 0x2a, 0xff, 0x30, 0x1f, 0xf5, 0x0, 0x0,
    0x0, 0x6, 0xfe, 0x8, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xf6, 0xdf, 0x30, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0xbf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xfd, 0xff, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
    0xbf, 0xdd, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x6,
    0xfb, 0x8f, 0xb0, 0x0, 0x0, 0x0, 0x0, 0xcf,
    0x61, 0xff, 0x70, 0x0, 0x0, 0x0, 0x8f, 0xe0,
    0x5, 0xff, 0xa2, 0x0, 0x3, 0xbf, 0xf3, 0x0,
    0x4, 0xef, 0xfe, 0xdf, 0xff, 0xe3, 0x0, 0x0,
    0x0, 0x7c, 0xef, 0xeb, 0x60, 0x0, 0x0,

    /* U+04EB "ӫ" */
    0x0, 0x3, 0xe6, 0x7, 0xe2, 0x0, 0x0, 0x0,
    0x4f, 0x70, 0x8f, 0x30, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x3a, 0xef, 0xea,
    0x30, 0x0, 0x0, 0x7f, 0xfb, 0x9b, 0xff, 0x60,
    0x0, 0x4f, 0xd2, 0x0, 0x2, 0xef, 0x30, 0xc,
    0xf3, 0x0, 0x0, 0x4, 0xfb, 0x0, 0xfd, 0x11,
    0x11, 0x11, 0x1e, 0xf0, 0x1f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x10, 0xfe, 0x44, 0x44, 0x44, 0x4e,
    0xf0, 0xc, 0xf2, 0x0, 0x0, 0x3, 0xfb, 0x0,
    0x4f, 0xd2, 0x0, 0x2, 0xdf, 0x30, 0x0, 0x7f,
    0xfb, 0x9b, 0xff, 0x60, 0x0, 0x0, 0x3a, 0xef,
    0xea, 0x30, 0x0,

    /* U+04EC "Ӭ" */
    0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5, 0xf6, 0xa, 0xf2, 0x0, 0x0, 0x0, 0x4,
    0xf5, 0x8, 0xe1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x39, 0xdf, 0xfd, 0x92,
    0x0, 0x0, 0x9, 0xff, 0xfe, 0xef, 0xff, 0x70,
    0x0, 0x2e, 0xd5, 0x0, 0x1, 0x8f, 0xf7, 0x0,
    0x2, 0x0, 0x0, 0x0, 0x4, 0xff, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0x90, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0xe0, 0x0, 0x0, 0xcf,
    0xff, 0xff, 0xff, 0xf0, 0x0, 0x0, 0x8b, 0xbb,
    0xbb, 0xbf, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0x90, 0x2, 0x0, 0x0, 0x0, 0x4, 0xff, 0x20,
    0x2f, 0xd5, 0x0, 0x1, 0x8f, 0xf7, 0x0, 0x9,
    0xff, 0xfe, 0xef, 0xff, 0x70, 0x0, 0x0, 0x39,
    0xdf, 0xfd, 0x92, 0x0, 0x0,

    /* U+04ED "ӭ" */
    0x0, 0x6e, 0x30, 0xad, 0x0, 0x0, 0x7, 0xf4,
    0xc, 0xe0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x18, 0xdf, 0xec, 0x60, 0x0, 0x3f, 0xfc,
    0xaa, 0xef, 0xc1, 0x0, 0xb4, 0x0, 0x0, 0xaf,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x30, 0x0,
    0x12, 0x22, 0x27, 0xf8, 0x0, 0x8, 0xff, 0xff,
    0xff, 0x90, 0x0, 0x25, 0x55, 0x58, 0xf7, 0x0,
    0x0, 0x0, 0x0, 0xaf, 0x30, 0x93, 0x0, 0x0,
    0x8f, 0xb0, 0x3f, 0xfc, 0xab, 0xef, 0xc1, 0x0,
    0x18, 0xdf, 0xec, 0x60, 0x0,

    /* U+04EE "Ӯ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xff, 0xff, 0xff, 0x0, 0x0, 0x0, 0x1,
    0x33, 0x33, 0x33, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xb0, 0x0, 0x0, 0x0,
    0xa, 0xf5, 0xd, 0xf3, 0x0, 0x0, 0x0, 0x2f,
    0xc0, 0x5, 0xfb, 0x0, 0x0, 0x0, 0xbf, 0x40,
    0x0, 0xcf, 0x40, 0x0, 0x3, 0xfb, 0x0, 0x0,
    0x4f, 0xc0, 0x0, 0xc, 0xf2, 0x0, 0x0, 0xb,
    0xf5, 0x0, 0x4f, 0x90, 0x0, 0x0, 0x2, 0xfd,
    0x0, 0xdf, 0x10, 0x0, 0x0, 0x0, 0xaf, 0x56,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xde, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1d, 0xf5, 0x0, 0x0, 0x0, 0x1,
    0xec, 0xff, 0x90, 0x0, 0x0, 0x0, 0x3, 0xdf,
    0xe7, 0x0, 0x0, 0x0, 0x0,

    /* U+04EF "ӯ" */
    0x0, 0xd, 0xff, 0xff, 0xfb, 0x0, 0x0, 0x0,
    0x23, 0x33, 0x33, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0x40, 0x0, 0x0,
    0xc, 0xf1, 0x4, 0xfb, 0x0, 0x0, 0x3, 0xfa,
    0x0, 0xd, 0xf2, 0x0, 0x0, 0xaf, 0x30, 0x0,
    0x7f, 0x80, 0x0, 0x1f, 0xc0, 0x0, 0x0, 0xfe,
    0x0, 0x7, 0xf5, 0x0, 0x0, 0x9, 0xf6, 0x0,
    0xee, 0x0, 0x0, 0x0, 0x2f, 0xc0, 0x5f, 0x80,
    0x0, 0x0, 0x0, 0xbf, 0x3c, 0xf1, 0x0, 0x0,
    0x0, 0x4, 0xfc, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xf5, 0x0,
    0x0, 0x0, 0x30, 0x2, 0xfe, 0x0, 0x0, 0x0,
    0x1f, 0xeb, 0xff, 0x50, 0x0, 0x0, 0x0, 0x7e,
    0xfd, 0x50, 0x0, 0x0, 0x0,

    /* U+04F0 "Ӱ" */
    0x0, 0x0, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0,
    0x0, 0xec, 0x3, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0xdb, 0x3, 0xe6, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xb0, 0x0, 0x0, 0x0,
    0xa, 0xf5, 0xd, 0xf3, 0x0, 0x0, 0x0, 0x2f,
    0xc0, 0x5, 0xfb, 0x0, 0x0, 0x0, 0xbf, 0x40,
    0x0, 0xcf, 0x40, 0x0, 0x3, 0xfb, 0x0, 0x0,
    0x4f, 0xc0, 0x0, 0xc, 0xf2, 0x0, 0x0, 0xb,
    0xf5, 0x0, 0x4f, 0x90, 0x0, 0x0, 0x2, 0xfd,
    0x0, 0xdf, 0x10, 0x0, 0x0, 0x0, 0xaf, 0x56,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xde, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1d, 0xf5, 0x0, 0x0, 0x0, 0x1,
    0xec, 0xff, 0x90, 0x0, 0x0, 0x0, 0x3, 0xdf,
    0xe7, 0x0, 0x0, 0x0, 0x0,

    /* U+04F1 "ӱ" */
    0x0, 0x3, 0xf5, 0x8, 0xe2, 0x0, 0x0, 0x0,
    0x4f, 0x60, 0x9f, 0x20, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0x40, 0x0, 0x0,
    0xc, 0xf1, 0x4, 0xfb, 0x0, 0x0, 0x3, 0xfa,
    0x0, 0xd, 0xf2, 0x0, 0x0, 0xaf, 0x30, 0x0,
    0x7f, 0x80, 0x0, 0x1f, 0xc0, 0x0, 0x0, 0xfe,
    0x0, 0x7, 0xf5, 0x0, 0x0, 0x9, 0xf6, 0x0,
    0xee, 0x0, 0x0, 0x0, 0x2f, 0xc0, 0x5f, 0x80,
    0x0, 0x0, 0x0, 0xbf, 0x3c, 0xf1, 0x0, 0x0,
    0x0, 0x4, 0xfc, 0xfa, 0x0, 0x0, 0x0, 0x0,
    0xd, 0xff, 0x30, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xf5, 0x0,
    0x0, 0x0, 0x30, 0x2, 0xfe, 0x0, 0x0, 0x0,
    0x1f, 0xeb, 0xff, 0x50, 0x0, 0x0, 0x0, 0x7e,
    0xfd, 0x50, 0x0, 0x0, 0x0,

    /* U+04F2 "Ӳ" */
    0x0, 0x0, 0x2, 0xa8, 0x7, 0xa2, 0x0, 0x0,
    0x0, 0xc, 0xe2, 0x4f, 0x90, 0x0, 0x0, 0x0,
    0x7f, 0x40, 0xeb, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xb0, 0x0, 0x0, 0x0,
    0xa, 0xf5, 0xd, 0xf3, 0x0, 0x0, 0x0, 0x2f,
    0xc0, 0x5, 0xfb, 0x0, 0x0, 0x0, 0xbf, 0x40,
    0x0, 0xcf, 0x40, 0x0, 0x3, 0xfb, 0x0, 0x0,
    0x4f, 0xc0, 0x0, 0xc, 0xf2, 0x0, 0x0, 0xb,
    0xf5, 0x0, 0x4f, 0x90, 0x0, 0x0, 0x2, 0xfd,
    0x0, 0xdf, 0x10, 0x0, 0x0, 0x0, 0xaf, 0x56,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x1f, 0xde, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x8, 0xff, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xfd, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1d, 0xf5, 0x0, 0x0, 0x0, 0x1,
    0xec, 0xff, 0x90, 0x0, 0x0, 0x0, 0x3, 0xdf,
    0xe7, 0x0, 0x0, 0x0, 0x0,

    /* U+04F3 "ӳ" */
    0x0, 0x0, 0xa, 0xf4, 0x3f, 0xb0, 0x0, 0x0,
    0x5, 0xf7, 0xd, 0xd1, 0x0, 0x0, 0x0, 0x98,
    0x4, 0xa2, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xb, 0xf4, 0x0, 0x0, 0x0, 0xcf,
    0x10, 0x4f, 0xb0, 0x0, 0x0, 0x3f, 0xa0, 0x0,
    0xdf, 0x20, 0x0, 0xa, 0xf3, 0x0, 0x7, 0xf8,
    0x0, 0x1, 0xfc, 0x0, 0x0, 0xf, 0xe0, 0x0,
    0x7f, 0x50, 0x0, 0x0, 0x9f, 0x60, 0xe, 0xe0,
    0x0, 0x0, 0x2, 0xfc, 0x5, 0xf8, 0x0, 0x0,
    0x0, 0xb, 0xf3, 0xcf, 0x10, 0x0, 0x0, 0x0,
    0x4f, 0xcf, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0xf3, 0x0, 0x0, 0x0, 0x0, 0x7, 0xfc, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0x50, 0x0, 0x0,
    0x3, 0x0, 0x2f, 0xe0, 0x0, 0x0, 0x1, 0xfe,
    0xbf, 0xf5, 0x0, 0x0, 0x0, 0x7, 0xef, 0xd5,
    0x0, 0x0, 0x0, 0x0,

    /* U+04F4 "Ӵ" */
    0x0, 0xd, 0xb0, 0x2e, 0x70, 0x0, 0x0, 0xe,
    0xc0, 0x3f, 0x80, 0x0, 0x0, 0x0, 0x0, 0x1,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x0, 0x0, 0x0, 0x7, 0xf8, 0xff, 0x0,
    0x0, 0x0, 0x7, 0xf8, 0xff, 0x0, 0x0, 0x0,
    0x7, 0xf8, 0xff, 0x0, 0x0, 0x0, 0x7, 0xf8,
    0xef, 0x10, 0x0, 0x0, 0x7, 0xf8, 0xdf, 0x60,
    0x0, 0x0, 0x7, 0xf8, 0x7f, 0xf5, 0x0, 0x0,
    0x4c, 0xf8, 0xc, 0xff, 0xfd, 0xef, 0xff, 0xf8,
    0x0, 0x6c, 0xff, 0xeb, 0x68, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xf8, 0x0, 0x0, 0x0, 0x0,
    0x7, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xf8,

    /* U+04F5 "ӵ" */
    0x0, 0x3e, 0x60, 0x6e, 0x20, 0x0, 0x3, 0xf7,
    0x7, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xfb, 0x0, 0x0, 0xa, 0xf4, 0x3f, 0xb0,
    0x0, 0x0, 0xaf, 0x43, 0xfb, 0x0, 0x0, 0xa,
    0xf4, 0x2f, 0xb0, 0x0, 0x0, 0xaf, 0x41, 0xfe,
    0x0, 0x0, 0xa, 0xf4, 0xd, 0xf9, 0x20, 0x26,
    0xef, 0x40, 0x4e, 0xff, 0xff, 0xff, 0xf4, 0x0,
    0x6, 0x98, 0x61, 0xaf, 0x40, 0x0, 0x0, 0x0,
    0xa, 0xf4, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x40,
    0x0, 0x0, 0x0, 0xa, 0xf4,

    /* U+04F6 "Ӷ" */
    0xdf, 0xff, 0xff, 0xff, 0xf5, 0xdf, 0xdc, 0xcc,
    0xcc, 0xc4, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xdf,
    0x20, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xdf, 0x20,
    0x0, 0x0, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x0,
    0xdf, 0x20, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0,
    0x0, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xdf,
    0x20, 0x0, 0x0, 0x0, 0xff, 0xec, 0x30, 0x0,
    0x0, 0xff, 0xff, 0x40, 0x0, 0x0, 0x0, 0x9f,
    0x40, 0x0, 0x0, 0x0, 0x9f, 0x40, 0x0, 0x0,
    0x0, 0x9f, 0x40, 0x0, 0x0,

    /* U+04F7 "ӷ" */
    0x2f, 0xff, 0xff, 0xff, 0xa2, 0xfe, 0xbb, 0xbb,
    0xb7, 0x2f, 0xc0, 0x0, 0x0, 0x2, 0xfc, 0x0,
    0x0, 0x0, 0x2f, 0xc0, 0x0, 0x0, 0x2, 0xfc,
    0x0, 0x0, 0x0, 0x2f, 0xc0, 0x0, 0x0, 0x2,
    0xfc, 0x0, 0x0, 0x0, 0x2f, 0xc0, 0x0, 0x0,
    0x4, 0xff, 0xb4, 0x0, 0x0, 0x5f, 0xff, 0x60,
    0x0, 0x0, 0x6, 0xf6, 0x0, 0x0, 0x0, 0x6f,
    0x60, 0x0, 0x0, 0x3, 0x83, 0x0, 0x0,

    /* U+04F8 "Ӹ" */
    0x0, 0x0, 0xb, 0xd0, 0x1e, 0x90, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xe0, 0x1f, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xdf, 0x20, 0x0, 0x0, 0x0, 0x0, 0x5, 0xfa,
    0xdf, 0x20, 0x0, 0x0, 0x0, 0x0, 0x5, 0xfa,
    0xdf, 0x20, 0x0, 0x0, 0x0, 0x0, 0x5, 0xfa,
    0xdf, 0x20, 0x0, 0x0, 0x0, 0x0, 0x5, 0xfa,
    0xdf, 0xaa, 0xaa, 0x98, 0x40, 0x0, 0x5, 0xfa,
    0xdf, 0xff, 0xff, 0xff, 0xfd, 0x20, 0x5, 0xfa,
    0xdf, 0x20, 0x0, 0x14, 0xcf, 0xd0, 0x5, 0xfa,
    0xdf, 0x20, 0x0, 0x0, 0xe, 0xf3, 0x5, 0xfa,
    0xdf, 0x20, 0x0, 0x0, 0xa, 0xf6, 0x5, 0xfa,
    0xdf, 0x20, 0x0, 0x0, 0x9, 0xf6, 0x5, 0xfa,
    0xdf, 0x20, 0x0, 0x0, 0xd, 0xf4, 0x5, 0xfa,
    0xdf, 0x20, 0x0, 0x0, 0x8f, 0xe0, 0x5, 0xfa,
    0xdf, 0xaa, 0xaa, 0xbe, 0xff, 0x40, 0x5, 0xfa,
    0xdf, 0xff, 0xff, 0xfd, 0x92, 0x0, 0x5, 0xfa,

    /* U+04F9 "ӹ" */
    0x0, 0x0, 0x5f, 0x30, 0x9d, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0x40, 0xbf, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xc0, 0x0,
    0x0, 0x0, 0xb, 0xf3, 0x2f, 0xc0, 0x0, 0x0,
    0x0, 0xb, 0xf3, 0x2f, 0xc0, 0x0, 0x0, 0x0,
    0xb, 0xf3, 0x2f, 0xc2, 0x21, 0x0, 0x0, 0xb,
    0xf3, 0x2f, 0xff, 0xff, 0xfc, 0x40, 0xb, 0xf3,
    0x2f, 0xd5, 0x55, 0x8f, 0xf3, 0xb, 0xf3, 0x2f,
    0xc0, 0x0, 0x6, 0xf9, 0xb, 0xf3, 0x2f, 0xc0,
    0x0, 0x4, 0xfb, 0xb, 0xf3, 0x2f, 0xc0, 0x0,
    0x8, 0xf9, 0xb, 0xf3, 0x2f, 0xe7, 0x78, 0xbf,
    0xf2, 0xb, 0xf3, 0x2f, 0xff, 0xff, 0xd9, 0x20,
    0xb, 0xf3,

    /* U+04FA "Ӻ" */
    0x0, 0x4f, 0xff, 0xff, 0xff, 0xfe, 0x0, 0x4f,
    0xec, 0xcc, 0xcc, 0xcb, 0x0, 0x4f, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xb0, 0x0, 0x0, 0x0, 0x38, 0xaf, 0xd8, 0x88,
    0x88, 0x40, 0x6f, 0xff, 0xff, 0xff, 0xff, 0x80,
    0x0, 0x4f, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x4f,
    0xb0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x4f, 0xec, 0x80, 0x0, 0x0, 0x0, 0x4f,
    0xff, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0x90, 0x0, 0x0,
    0xa, 0xcb, 0xff, 0x30, 0x0, 0x0, 0x8, 0xdf,
    0xd4, 0x0, 0x0, 0x0,

    /* U+04FB "ӻ" */
    0x0, 0xaf, 0xff, 0xff, 0xf5, 0x0, 0xaf, 0xcb,
    0xbb, 0xb3, 0x0, 0xaf, 0x40, 0x0, 0x0, 0x0,
    0xaf, 0x40, 0x0, 0x0, 0x1, 0xbf, 0x51, 0x11,
    0x0, 0x5f, 0xff, 0xff, 0xff, 0x70, 0x14, 0xcf,
    0x74, 0x44, 0x20, 0x0, 0xaf, 0x40, 0x0, 0x0,
    0x0, 0xaf, 0x40, 0x0, 0x0, 0x0, 0xaf, 0xdc,
    0x0, 0x0, 0x0, 0xaf, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0xfe, 0x0, 0x0, 0x0, 0x3, 0xfc, 0x0,
    0x0, 0x6d, 0xaf, 0xf6, 0x0, 0x0, 0x5d, 0xfe,
    0x70, 0x0, 0x0,

    /* U+04FC "Ӽ" */
    0x1e, 0xf3, 0x0, 0x0, 0x0, 0xcf, 0x60, 0x5f,
    0xe1, 0x0, 0x0, 0x7f, 0xb0, 0x0, 0x9f, 0xa0,
    0x0, 0x3f, 0xe1, 0x0, 0x0, 0xdf, 0x60, 0xd,
    0xf4, 0x0, 0x0, 0x2, 0xff, 0x29, 0xf8, 0x0,
    0x0, 0x0, 0x6, 0xfe, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xff, 0x20, 0x0, 0x0, 0x0, 0x1,
    0xef, 0xf8, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x9e,
    0xf5, 0x0, 0x0, 0x0, 0x7f, 0xc0, 0x4f, 0xf2,
    0x0, 0x0, 0x3f, 0xf2, 0x0, 0x7f, 0xd0, 0x0,
    0xd, 0xf5, 0x0, 0x0, 0xbf, 0x90, 0xa, 0xfa,
    0x0, 0x0, 0x1, 0xff, 0x25, 0xfe, 0x0, 0x0,
    0x0, 0x9, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x8, 0xfc,
    0x0, 0x0, 0x0, 0x7, 0xcb, 0xff, 0x50, 0x0,
    0x0, 0x0, 0x6d, 0xfd, 0x60,

    /* U+04FD "ӽ" */
    0x3f, 0xe1, 0x0, 0x1, 0xef, 0x20, 0x7f, 0xa0,
    0x0, 0xcf, 0x50, 0x0, 0xbf, 0x60, 0x8f, 0x90,
    0x0, 0x1, 0xef, 0x6f, 0xd0, 0x0, 0x0, 0x4,
    0xff, 0xf3, 0x0, 0x0, 0x0, 0xd, 0xfc, 0x0,
    0x0, 0x0, 0x7, 0xff, 0xf9, 0x0, 0x0, 0x3,
    0xfe, 0x2d, 0xf5, 0x0, 0x1, 0xef, 0x30, 0x2e,
    0xf2, 0x0, 0xaf, 0x80, 0x0, 0x5f, 0xc0, 0x6f,
    0xc0, 0x0, 0x0, 0xbf, 0x40, 0x0, 0x0, 0x0,
    0x5, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x8f, 0x80,
    0x0, 0x0, 0x9c, 0xbf, 0xf3, 0x0, 0x0, 0x8,
    0xdf, 0xd4, 0x0,

    /* U+04FE "Ӿ" */
    0xc, 0xf8, 0x0, 0x0, 0x0, 0xdf, 0x70, 0x2,
    0xff, 0x40, 0x0, 0x9, 0xfb, 0x0, 0x0, 0x5f,
    0xe1, 0x0, 0x5f, 0xe1, 0x0, 0x0, 0xa, 0xfb,
    0x2, 0xff, 0x40, 0x0, 0x0, 0x0, 0xdf, 0x7c,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xff, 0xd0,
    0x0, 0x0, 0x2, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x0, 0x1, 0x88, 0x9f, 0xff, 0xe8, 0x85, 0x0,
    0x0, 0x0, 0x9f, 0xcf, 0xf6, 0x0, 0x0, 0x0,
    0x5, 0xfe, 0x15, 0xff, 0x20, 0x0, 0x0, 0x1e,
    0xf4, 0x0, 0xaf, 0xc0, 0x0, 0x0, 0xbf, 0x90,
    0x0, 0xe, 0xf7, 0x0, 0x6, 0xfd, 0x0, 0x0,
    0x3, 0xff, 0x30, 0x2f, 0xf3, 0x0, 0x0, 0x0,
    0x8f, 0xd0,

    /* U+04FF "ӿ" */
    0x1e, 0xf3, 0x0, 0x0, 0xbf, 0x50, 0x4f, 0xd0,
    0x0, 0x7f, 0xa0, 0x0, 0x9f, 0x90, 0x2f, 0xd0,
    0x0, 0x0, 0xdf, 0x5d, 0xf3, 0x0, 0x0, 0x15,
    0xff, 0xf9, 0x11, 0x0, 0x4f, 0xff, 0xff, 0xff,
    0xa0, 0x1, 0x47, 0xff, 0xfc, 0x43, 0x0, 0x0,
    0xdf, 0x4d, 0xf5, 0x0, 0x0, 0xaf, 0x70, 0x2f,
    0xf2, 0x0, 0x6f, 0xb0, 0x0, 0x6f, 0xc0, 0x3f,
    0xe1, 0x0, 0x0, 0xaf, 0x80,

    /* U+0510 "Ԑ" */
    0x0, 0x29, 0xdf, 0xfd, 0xa5, 0x0, 0x6, 0xff,
    0xfd, 0xdf, 0xff, 0x90, 0x1f, 0xf7, 0x0, 0x0,
    0x27, 0x30, 0x3f, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0xe, 0xf3, 0x0, 0x0, 0x0, 0x0, 0x3, 0xdf,
    0xca, 0xaa, 0x60, 0x0, 0x3, 0xcf, 0xff, 0xff,
    0x90, 0x0, 0x2f, 0xf6, 0x10, 0x0, 0x0, 0x0,
    0xaf, 0x60, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x30,
    0x0, 0x0, 0x0, 0x0, 0xbf, 0x70, 0x0, 0x0,
    0x0, 0x10, 0x5f, 0xf6, 0x0, 0x0, 0x29, 0xd0,
    0x8, 0xff, 0xfc, 0xbd, 0xff, 0xc0, 0x0, 0x3a,
    0xdf, 0xfe, 0xa4, 0x0,

    /* U+0511 "ԑ" */
    0x1, 0x8d, 0xff, 0xd8, 0x20, 0x1e, 0xfe, 0xcb,
    0xef, 0xb0, 0x8f, 0xb0, 0x0, 0x3, 0x30, 0x9f,
    0x60, 0x0, 0x0, 0x0, 0x2f, 0xd5, 0x21, 0x0,
    0x0, 0x4, 0xff, 0xff, 0x70, 0x0, 0x6f, 0xd6,
    0x44, 0x20, 0x0, 0xef, 0x20, 0x0, 0x0, 0x0,
    0xcf, 0x70, 0x0, 0x2, 0x60, 0x4f, 0xfe, 0xcb,
    0xdf, 0xf2, 0x2, 0x9d, 0xff, 0xd9, 0x30,

    /* U+0512 "Ԓ" */
    0x0, 0x4, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0,
    0x4, 0xfe, 0xcc, 0xcc, 0xcd, 0xfa, 0x0, 0x5,
    0xf7, 0x0, 0x0, 0x5, 0xfa, 0x0, 0x5, 0xf6,
    0x0, 0x0, 0x5, 0xfa, 0x0, 0x6, 0xf5, 0x0,
    0x0, 0x5, 0xfa, 0x0, 0x7, 0xf5, 0x0, 0x0,
    0x5, 0xfa, 0x0, 0x8, 0xf4, 0x0, 0x0, 0x5,
    0xfa, 0x0, 0x9, 0xf3, 0x0, 0x0, 0x5, 0xfa,
    0x0, 0xb, 0xf1, 0x0, 0x0, 0x5, 0xfa, 0x0,
    0xd, 0xf0, 0x0, 0x0, 0x5, 0xfa, 0x0, 0x2f,
    0xc0, 0x0, 0x0, 0x5, 0xfa, 0x0, 0xbf, 0x80,
    0x0, 0x0, 0x5, 0xfa, 0x9f, 0xff, 0x10, 0x0,
    0x0, 0x5, 0xfa, 0xaf, 0xc3, 0x0, 0x0, 0x0,
    0x5, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x5,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0xbc, 0xdf, 0xf2, 0x0,
    0x0, 0x0, 0x0, 0x9e, 0xfc, 0x40,

    /* U+0513 "ԓ" */
    0x0, 0x3f, 0xff, 0xff, 0xff, 0xf0, 0x4, 0xfd,
    0xbb, 0xbb, 0xff, 0x0, 0x4f, 0x70, 0x0, 0xf,
    0xf0, 0x5, 0xf6, 0x0, 0x0, 0xff, 0x0, 0x6f,
    0x50, 0x0, 0xf, 0xf0, 0x7, 0xf3, 0x0, 0x0,
    0xff, 0x0, 0x9f, 0x20, 0x0, 0xf, 0xf0, 0xb,
    0xf0, 0x0, 0x0, 0xff, 0x2, 0xfc, 0x0, 0x0,
    0xf, 0xfa, 0xff, 0x60, 0x0, 0x0, 0xff, 0xcf,
    0x90, 0x0, 0x0, 0xf, 0xf0, 0x0, 0x0, 0x0,
    0x0, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xc0,
    0x0, 0x0, 0x5d, 0xbf, 0xf6, 0x0, 0x0, 0x5,
    0xdf, 0xd7, 0x0,

    /* U+051A "Ԛ" */
    0x0, 0x0, 0x7c, 0xef, 0xeb, 0x60, 0x0, 0x0,
    0x0, 0x4e, 0xff, 0xed, 0xef, 0xfe, 0x30, 0x0,
    0x4, 0xff, 0x92, 0x0, 0x3, 0xbf, 0xf3, 0x0,
    0x1f, 0xf6, 0x0, 0x0, 0x0, 0x8, 0xfe, 0x0,
    0x8f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x60,
    0xdf, 0x30, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xb0,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xd0,
    0xdf, 0x30, 0x0, 0x0, 0x0, 0x0, 0x5f, 0xb0,
    0x8f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0xcf, 0x60,
    0x1f, 0xf5, 0x0, 0x0, 0x0, 0x7, 0xfe, 0x0,
    0x5, 0xff, 0x91, 0x0, 0x2, 0xaf, 0xf4, 0x0,
    0x0, 0x5f, 0xff, 0xed, 0xef, 0xfe, 0x40, 0x0,
    0x0, 0x1, 0x8d, 0xff, 0xfd, 0x70, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x9, 0xfe, 0x20, 0x1, 0xa1,
    0x0, 0x0, 0x0, 0x0, 0x8f, 0xfb, 0xaf, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x4, 0xbe, 0xfc, 0x40,

    /* U+051B "ԛ" */
    0x0, 0x4, 0xbe, 0xfd, 0x70, 0xfe, 0x0, 0x7f,
    0xfe, 0xce, 0xfb, 0xfe, 0x4, 0xff, 0x40, 0x0,
    0x6f, 0xfe, 0xb, 0xf5, 0x0, 0x0, 0x8, 0xfe,
    0xf, 0xf0, 0x0, 0x0, 0x2, 0xfe, 0x1f, 0xd0,
    0x0, 0x0, 0x0, 0xfe, 0xf, 0xf0, 0x0, 0x0,
    0x2, 0xfe, 0xb, 0xf5, 0x0, 0x0, 0x8, 0xfe,
    0x4, 0xff, 0x40, 0x0, 0x6f, 0xfe, 0x0, 0x7f,
    0xfe, 0xce, 0xfb, 0xfe, 0x0, 0x4, 0xbe, 0xfd,
    0x60, 0xfe, 0x0, 0x0, 0x0, 0x0, 0x0, 0xfe,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xfe, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xfe,

    /* U+051C "Ԝ" */
    0x6f, 0xa0, 0x0, 0x0, 0x2, 0xff, 0x0, 0x0,
    0x0, 0xc, 0xf2, 0x1f, 0xf0, 0x0, 0x0, 0x8,
    0xff, 0x50, 0x0, 0x0, 0x2f, 0xc0, 0xc, 0xf5,
    0x0, 0x0, 0xd, 0xff, 0xa0, 0x0, 0x0, 0x7f,
    0x70, 0x6, 0xfa, 0x0, 0x0, 0x2f, 0xbe, 0xf0,
    0x0, 0x0, 0xcf, 0x20, 0x1, 0xff, 0x0, 0x0,
    0x8f, 0x58, 0xf5, 0x0, 0x2, 0xfd, 0x0, 0x0,
    0xcf, 0x40, 0x0, 0xdf, 0x3, 0xfa, 0x0, 0x7,
    0xf7, 0x0, 0x0, 0x6f, 0xa0, 0x3, 0xfa, 0x0,
    0xef, 0x0, 0xc, 0xf2, 0x0, 0x0, 0x1f, 0xe0,
    0x8, 0xf5, 0x0, 0x9f, 0x50, 0x2f, 0xd0, 0x0,
    0x0, 0xc, 0xf4, 0xd, 0xf0, 0x0, 0x3f, 0xa0,
    0x7f, 0x70, 0x0, 0x0, 0x6, 0xf9, 0x3f, 0xa0,
    0x0, 0xe, 0xf0, 0xcf, 0x20, 0x0, 0x0, 0x1,
    0xfe, 0x8f, 0x50, 0x0, 0x9, 0xf7, 0xfd, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xff, 0x0, 0x0, 0x3,
    0xff, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xfa,
    0x0, 0x0, 0x0, 0xef, 0xf2, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0xf4, 0x0, 0x0, 0x0, 0x9f, 0xd0,
    0x0, 0x0,

    /* U+051D "ԝ" */
    0xaf, 0x50, 0x0, 0x0, 0xaf, 0x70, 0x0, 0x0,
    0x7f, 0x54, 0xfb, 0x0, 0x0, 0xf, 0xfd, 0x0,
    0x0, 0xd, 0xf0, 0xe, 0xf1, 0x0, 0x6, 0xff,
    0xf3, 0x0, 0x3, 0xf9, 0x0, 0x8f, 0x70, 0x0,
    0xcf, 0x5f, 0x90, 0x0, 0x9f, 0x40, 0x2, 0xfc,
    0x0, 0x2f, 0xb0, 0xee, 0x0, 0xe, 0xe0, 0x0,
    0xc, 0xf2, 0x8, 0xf5, 0x8, 0xf5, 0x5, 0xf8,
    0x0, 0x0, 0x6f, 0x80, 0xee, 0x0, 0x2f, 0xb0,
    0xbf, 0x20, 0x0, 0x0, 0xfd, 0x4f, 0x90, 0x0,
    0xcf, 0x2f, 0xc0, 0x0, 0x0, 0xa, 0xfd, 0xf3,
    0x0, 0x6, 0xfd, 0xf6, 0x0, 0x0, 0x0, 0x4f,
    0xfd, 0x0, 0x0, 0x1f, 0xff, 0x10, 0x0, 0x0,
    0x0, 0xef, 0x70, 0x0, 0x0, 0xaf, 0xa0, 0x0,
    0x0,

    /* U+0524 "Ԥ" */
    0xdf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x30, 0xd,
    0xfd, 0xcc, 0xcc, 0xcc, 0xcf, 0xf3, 0x0, 0xdf,
    0x20, 0x0, 0x0, 0x0, 0xbf, 0x30, 0xd, 0xf2,
    0x0, 0x0, 0x0, 0xb, 0xf3, 0x0, 0xdf, 0x20,
    0x0, 0x0, 0x0, 0xbf, 0x30, 0xd, 0xf2, 0x0,
    0x0, 0x0, 0xb, 0xf3, 0x0, 0xdf, 0x20, 0x0,
    0x0, 0x0, 0xbf, 0x30, 0xd, 0xf2, 0x0, 0x0,
    0x0, 0xb, 0xf3, 0x0, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0xbf, 0x30, 0xd, 0xf2, 0x0, 0x0, 0x0,
    0xb, 0xf3, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x0,
    0xbf, 0x30, 0xd, 0xf2, 0x0, 0x0, 0x0, 0xb,
    0xf3, 0x0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0xff,
    0xfc, 0x4d, 0xf2, 0x0, 0x0, 0x0, 0xf, 0xff,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f,
    0x50, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7, 0xf5,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x50,

    /* U+0525 "ԥ" */
    0x2f, 0xff, 0xff, 0xff, 0xff, 0xa0, 0x2, 0xfe,
    0xbb, 0xbb, 0xbc, 0xfa, 0x0, 0x2f, 0xc0, 0x0,
    0x0, 0x4f, 0xa0, 0x2, 0xfc, 0x0, 0x0, 0x4,
    0xfa, 0x0, 0x2f, 0xc0, 0x0, 0x0, 0x4f, 0xa0,
    0x2, 0xfc, 0x0, 0x0, 0x4, 0xfa, 0x0, 0x2f,
    0xc0, 0x0, 0x0, 0x4f, 0xa0, 0x2, 0xfc, 0x0,
    0x0, 0x4, 0xfa, 0x0, 0x2f, 0xc0, 0x0, 0x0,
    0x4f, 0xa0, 0x2, 0xfc, 0x0, 0x0, 0x7, 0xff,
    0xb3, 0x2f, 0xc0, 0x0, 0x0, 0x8f, 0xff, 0x50,
    0x0, 0x0, 0x0, 0x0, 0x7, 0xf5, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x7f, 0x50, 0x0, 0x0, 0x0,
    0x0, 0x3, 0x82,

    /* U+0526 "Ԧ" */
    0xdf, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf,
    0x20, 0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xdf, 0x35, 0x9b, 0xcb,
    0x71, 0x0, 0x0, 0xdf, 0xff, 0xff, 0xff, 0xfe,
    0x30, 0x0, 0xdf, 0xc7, 0x20, 0x14, 0xcf, 0xe0,
    0x0, 0xdf, 0x20, 0x0, 0x0, 0xd, 0xf6, 0x0,
    0xdf, 0x20, 0x0, 0x0, 0x7, 0xf9, 0x0, 0xdf,
    0x20, 0x0, 0x0, 0x5, 0xf9, 0x0, 0xdf, 0x20,
    0x0, 0x0, 0x5, 0xfa, 0x0, 0xdf, 0x20, 0x0,
    0x0, 0x5, 0xfa, 0x0, 0xdf, 0x20, 0x0, 0x0,
    0x9, 0xff, 0xc9, 0xdf, 0x20, 0x0, 0x0, 0xb,
    0xff, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xfc,

    /* U+0527 "ԧ" */
    0x4, 0x30, 0x0, 0x0, 0x0, 0x0, 0x2, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x2, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xfc, 0x8, 0xdf, 0xea, 0x10, 0x0, 0x2f,
    0xdc, 0xfe, 0xef, 0xfe, 0x10, 0x2, 0xff, 0xe3,
    0x0, 0x2d, 0xf9, 0x0, 0x2f, 0xf3, 0x0, 0x0,
    0x4f, 0xd0, 0x2, 0xfe, 0x0, 0x0, 0x0, 0xfe,
    0x0, 0x2f, 0xc0, 0x0, 0x0, 0xf, 0xf0, 0x2,
    0xfc, 0x0, 0x0, 0x0, 0xff, 0x0, 0x2f, 0xc0,
    0x0, 0x0, 0xf, 0xf0, 0x2, 0xfc, 0x0, 0x0,
    0x0, 0xff, 0x0, 0x2f, 0xc0, 0x0, 0x0, 0xf,
    0xff, 0x82, 0xfc, 0x0, 0x0, 0x0, 0xff, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x80, 0x0,
    0x0, 0x0, 0x0, 0x4, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x1, 0x0,

    /* U+0528 "Ԩ" */
    0x0, 0x0, 0xcf, 0x20, 0x0, 0x0, 0x0, 0xdf,
    0x20, 0x0, 0xc, 0xf2, 0x0, 0x0, 0x0, 0xd,
    0xf2, 0x0, 0x0, 0xcf, 0x20, 0x0, 0x0, 0x0,
    0xdf, 0x20, 0x0, 0xc, 0xf2, 0x0, 0x0, 0x0,
    0xd, 0xf2, 0x0, 0x0, 0xcf, 0x20, 0x0, 0x0,
    0x0, 0xdf, 0x20, 0x0, 0xc, 0xf2, 0x0, 0x0,
    0x0, 0xd, 0xf2, 0x0, 0x0, 0xcf, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x20, 0x0, 0xc, 0xfd, 0xcc,
    0xcc, 0xcc, 0xcf, 0xf2, 0x0, 0x0, 0xcf, 0x20,
    0x0, 0x0, 0x0, 0xdf, 0x20, 0x0, 0xc, 0xf2,
    0x0, 0x0, 0x0, 0xd, 0xf2, 0x0, 0x0, 0xcf,
    0x20, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0, 0xc,
    0xf2, 0x0, 0x0, 0x0, 0xd, 0xf2, 0x0, 0x0,
    0xcf, 0x20, 0x0, 0x0, 0x0, 0xdf, 0x20, 0x0,
    0xc, 0xf2, 0x0, 0x0, 0x0, 0xd, 0xf2, 0x0,
    0x0, 0xcf, 0x20, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0xf0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3e, 0xbe, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xcf, 0xe9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+0529 "ԩ" */
    0x0, 0x2, 0xfc, 0x0, 0x0, 0x2, 0xfc, 0x0,
    0x2, 0xfc, 0x0, 0x0, 0x2, 0xfc, 0x0, 0x2,
    0xfc, 0x0, 0x0, 0x2, 0xfc, 0x0, 0x2, 0xfc,
    0x0, 0x0, 0x2, 0xfc, 0x0, 0x2, 0xff, 0xbb,
    0xbb, 0xbc, 0xfc, 0x0, 0x2, 0xff, 0xff, 0xff,
    0xff, 0xfc, 0x0, 0x2, 0xfc, 0x0, 0x0, 0x2,
    0xfc, 0x0, 0x2, 0xfc, 0x0, 0x0, 0x2, 0xfc,
    0x0, 0x2, 0xfc, 0x0, 0x0, 0x2, 0xfc, 0x0,
    0x2, 0xfc, 0x0, 0x0, 0x2, 0xfc, 0x0, 0x2,
    0xfc, 0x0, 0x0, 0x2, 0xfc, 0x0, 0x2, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x6, 0xfa, 0x0,
    0x0, 0x0, 0x0, 0x7c, 0xbf, 0xf3, 0x0, 0x0,
    0x0, 0x0, 0x6d, 0xfd, 0x50, 0x0, 0x0, 0x0,
    0x0,

    /* U+052E "Ԯ" */
    0x0, 0x4, 0xff, 0xff, 0xff, 0xff, 0xfa, 0x0,
    0x0, 0x4, 0xfe, 0xcc, 0xcc, 0xcd, 0xfa, 0x0,
    0x0, 0x5, 0xf6, 0x0, 0x0, 0x5, 0xfa, 0x0,
    0x0, 0x5, 0xf6, 0x0, 0x0, 0x5, 0xfa, 0x0,
    0x0, 0x6, 0xf5, 0x0, 0x0, 0x5, 0xfa, 0x0,
    0x0, 0x6, 0xf5, 0x0, 0x0, 0x5, 0xfa, 0x0,
    0x0, 0x7, 0xf4, 0x0, 0x0, 0x5, 0xfa, 0x0,
    0x0, 0x9, 0xf3, 0x0, 0x0, 0x5, 0xfa, 0x0,
    0x0, 0xb, 0xf2, 0x0, 0x0, 0x5, 0xfa, 0x0,
    0x0, 0xd, 0xf0, 0x0, 0x0, 0x5, 0xfa, 0x0,
    0x0, 0x2f, 0xc0, 0x0, 0x0, 0x5, 0xfa, 0x0,
    0x0, 0xbf, 0x80, 0x0, 0x0, 0x5, 0xfa, 0x0,
    0x9f, 0xff, 0x10, 0x0, 0x0, 0x5, 0xff, 0xeb,
    0xaf, 0xd4, 0x0, 0x0, 0x0, 0x5, 0xff, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0xfc,

    /* U+052F "ԯ" */
    0x0, 0x3f, 0xff, 0xff, 0xff, 0xf0, 0x0, 0x4,
    0xfd, 0xbb, 0xbb, 0xff, 0x0, 0x0, 0x4f, 0x60,
    0x0, 0xf, 0xf0, 0x0, 0x5, 0xf5, 0x0, 0x0,
    0xff, 0x0, 0x0, 0x6f, 0x40, 0x0, 0xf, 0xf0,
    0x0, 0x7, 0xf3, 0x0, 0x0, 0xff, 0x0, 0x0,
    0x9f, 0x20, 0x0, 0xf, 0xf0, 0x0, 0xb, 0xf0,
    0x0, 0x0, 0xff, 0x0, 0x1, 0xfc, 0x0, 0x0,
    0xf, 0xf0, 0x8, 0xef, 0x60, 0x0, 0x0, 0xff,
    0xa5, 0xdf, 0x90, 0x0, 0x0, 0xf, 0xff, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x3, 0xf9, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x3f, 0x90, 0x0, 0x0, 0x0,
    0x0, 0x1, 0x84,

    /* U+2007 " " */

    /* U+2008 " " */

    /* U+2009 " " */

    /* U+200A " " */

    /* U+200B "​" */

    /* U+2010 "‐" */
    0x9b, 0xbb, 0xb5, 0xef, 0xff, 0xf8,

    /* U+2012 "‒" */
    0x1, 0x11, 0x11, 0x11, 0x11, 0x11, 0x10, 0x1f,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x4, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x40,

    /* U+2013 "–" */
    0x11, 0x11, 0x11, 0x11, 0x11, 0xff, 0xff, 0xff,
    0xff, 0xff, 0x44, 0x44, 0x44, 0x44, 0x44,

    /* U+2014 "—" */
    0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
    0x11, 0x11, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0x44, 0x44, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44,

    /* U+2015 "―" */
    0x1, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
    0x11, 0x11, 0x10, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0x4, 0x44, 0x44,
    0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x40,

    /* U+2018 "‘" */
    0x0, 0xe5, 0x4, 0xf1, 0x9, 0xd0, 0xe, 0xf4,
    0xf, 0xf8, 0x6, 0xa1,

    /* U+2019 "’" */
    0xa, 0xe4, 0xf, 0xf9, 0x8, 0xf6, 0x6, 0xf1,
    0xa, 0xb0, 0x9, 0x50,

    /* U+201A "‚" */
    0x6, 0xa2, 0xf, 0xf8, 0xb, 0xf7, 0x5, 0xf2,
    0x9, 0xc0, 0xd, 0x70,

    /* U+201C "“" */
    0x0, 0xf5, 0x2, 0xf1, 0x4, 0xf1, 0x8, 0xd0,
    0x9, 0xd0, 0xd, 0xa0, 0xe, 0xf4, 0x2f, 0xe1,
    0xf, 0xf8, 0x4f, 0xf4, 0x6, 0xa1, 0x8, 0x90,

    /* U+201D "”" */
    0xa, 0xe3, 0xd, 0xd1, 0xf, 0xf8, 0x3f, 0xf5,
    0x8, 0xf6, 0xb, 0xf2, 0x6, 0xf1, 0xa, 0xd0,
    0xa, 0xb0, 0xe, 0x70, 0xa, 0x40, 0x1b, 0x20,

    /* U+201E "„" */
    0x6, 0xa1, 0x8, 0x90, 0xf, 0xf8, 0x3f, 0xf5,
    0xb, 0xf6, 0x1d, 0xf3, 0x5, 0xf1, 0x9, 0xe0,
    0x9, 0xc0, 0xd, 0x90, 0xd, 0x70, 0x1f, 0x30,

    /* U+2020 "†" */
    0x0, 0x0, 0x6f, 0x80, 0x0, 0x0, 0x0, 0x6,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x80, 0x0,
    0x0, 0x0, 0x6, 0xf8, 0x0, 0x0, 0x4b, 0xbb,
    0xdf, 0xdb, 0xbb, 0x66, 0xff, 0xff, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0x6f, 0x80, 0x0, 0x0, 0x0,
    0x6, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x80,
    0x0, 0x0, 0x0, 0x6, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0x80, 0x0, 0x0, 0x0, 0x6, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0x80, 0x0, 0x0,
    0x0, 0x6, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x80, 0x0, 0x0, 0x0, 0x6, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0x80, 0x0, 0x0, 0x0, 0x6,
    0xf8, 0x0, 0x0,

    /* U+2021 "‡" */
    0x0, 0x0, 0x6f, 0x80, 0x0, 0x0, 0x0, 0x6,
    0xf8, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x80, 0x0,
    0x0, 0x0, 0x6, 0xf8, 0x0, 0x0, 0x4b, 0xbb,
    0xdf, 0xdb, 0xbb, 0x66, 0xff, 0xff, 0xff, 0xff,
    0xf9, 0x0, 0x0, 0x6f, 0x80, 0x0, 0x0, 0x0,
    0x6, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x80,
    0x0, 0x0, 0x0, 0x6, 0xf8, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0x80, 0x0, 0x4, 0xbb, 0xbd, 0xfd,
    0xbb, 0xb6, 0x6f, 0xff, 0xff, 0xff, 0xff, 0x90,
    0x0, 0x6, 0xf8, 0x0, 0x0, 0x0, 0x0, 0x6f,
    0x80, 0x0, 0x0, 0x0, 0x6, 0xf8, 0x0, 0x0,
    0x0, 0x0, 0x6f, 0x80, 0x0, 0x0, 0x0, 0x6,
    0xf8, 0x0, 0x0,

    /* U+2022 "•" */
    0x9, 0xa2, 0x8f, 0xfc, 0x9f, 0xfd, 0x2d, 0xe5,

    /* U+2026 "…" */
    0x8, 0xb2, 0x1, 0xb9, 0x0, 0x4c, 0x50, 0xff,
    0x80, 0x6f, 0xf2, 0xc, 0xfd, 0xa, 0xe3, 0x2,
    0xec, 0x0, 0x6f, 0x70,

    /* U+2030 "‰" */
    0x0, 0x9e, 0xe9, 0x0, 0x0, 0x0, 0xda, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xb, 0xd4, 0x4d, 0xa0,
    0x0, 0x9, 0xe1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0x40, 0x4, 0xf1, 0x0, 0x4f, 0x40, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0x10, 0x1, 0xf3,
    0x1, 0xe9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2f, 0x30, 0x2, 0xf1, 0xa, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0xc, 0xb1, 0x1b, 0xc0,
    0x5f, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x2, 0xcf, 0xfc, 0x21, 0xe8, 0xa, 0xee, 0x70,
    0x0, 0x6d, 0xea, 0x10, 0x0, 0x1, 0x10, 0xa,
    0xd0, 0xbd, 0x45, 0xf6, 0x6, 0xf6, 0x4c, 0xc0,
    0x0, 0x0, 0x0, 0x5f, 0x32, 0xf3, 0x0, 0x7e,
    0xd, 0x80, 0x2, 0xf3, 0x0, 0x0, 0x1, 0xf7,
    0x5, 0xf0, 0x0, 0x4f, 0x1f, 0x40, 0x0, 0xe6,
    0x0, 0x0, 0xb, 0xc0, 0x5, 0xf0, 0x0, 0x3f,
    0x1f, 0x40, 0x0, 0xe6, 0x0, 0x0, 0x6f, 0x20,
    0x2, 0xf2, 0x0, 0x6e, 0xd, 0x70, 0x1, 0xf3,
    0x0, 0x2, 0xf7, 0x0, 0x0, 0xbb, 0x24, 0xe7,
    0x6, 0xe4, 0x2b, 0xc0, 0x0, 0xc, 0xc0, 0x0,
    0x0, 0x1a, 0xfe, 0x70, 0x0, 0x7e, 0xfb, 0x10,

    /* U+2032 "′" */
    0xbe, 0xbe, 0xad, 0xad, 0xad, 0x57,

    /* U+2033 "″" */
    0xbe, 0x1, 0xf8, 0xbe, 0x1, 0xf8, 0xad, 0x0,
    0xf7, 0xad, 0x0, 0xf7, 0xad, 0x0, 0xf7, 0x57,
    0x0, 0x83,

    /* U+2039 "‹" */
    0x0, 0x7, 0xd3, 0x0, 0x3f, 0x90, 0x0, 0xdd,
    0x0, 0xa, 0xf2, 0x0, 0xc, 0xe1, 0x0, 0x1,
    0xeb, 0x0, 0x0, 0x4f, 0x70, 0x0, 0x9, 0xf3,

    /* U+203A "›" */
    0x1c, 0xa0, 0x0, 0x5, 0xf6, 0x0, 0x0, 0xaf,
    0x30, 0x0, 0xd, 0xd0, 0x0, 0xc, 0xe1, 0x0,
    0x8f, 0x40, 0x3, 0xf8, 0x0, 0x1e, 0xc0, 0x0,

    /* U+2044 "⁄" */
    0x0, 0x0, 0x0, 0x0, 0x9, 0xe0, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0x40, 0x0, 0x0, 0x0, 0x0,
    0xe9, 0x0, 0x0, 0x0, 0x0, 0xa, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x4f, 0x30, 0x0, 0x0, 0x0,
    0x1, 0xe8, 0x0, 0x0, 0x0, 0x0, 0xa, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0x20, 0x0, 0x0,
    0x0, 0x1, 0xe7, 0x0, 0x0, 0x0, 0x0, 0xb,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0x20, 0x0,
    0x0, 0x0, 0x2, 0xf6, 0x0, 0x0, 0x0, 0x0,
    0xc, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0x10,
    0x0, 0x0, 0x0, 0x0,

    /* U+2052 "⁒" */
    0x3e, 0x90, 0x0, 0xf7, 0x6, 0xfd, 0x0, 0x6f,
    0x10, 0x5, 0x20, 0xb, 0xb0, 0x0, 0x0, 0x1,
    0xf5, 0x0, 0x0, 0x0, 0x7f, 0x0, 0x0, 0x0,
    0xd, 0xa0, 0x0, 0x0, 0x2, 0xf4, 0x0, 0x0,
    0x0, 0x8e, 0x0, 0x0, 0x0, 0xe, 0x90, 0x0,
    0x0, 0x4, 0xf3, 0x0, 0x0, 0x0, 0x9d, 0x0,
    0x0, 0x0, 0xf, 0x70, 0x3, 0x30, 0x5, 0xf2,
    0x1, 0xff, 0x20, 0xbc, 0x0, 0xc, 0xd0,

    /* U+2070 "⁰" */
    0x0, 0x9e, 0xfc, 0x40, 0x0, 0xbe, 0x64, 0x9f,
    0x40, 0x3f, 0x40, 0x0, 0xbc, 0x6, 0xf0, 0x0,
    0x7, 0xf0, 0x6f, 0x0, 0x0, 0x7f, 0x3, 0xf4,
    0x0, 0xb, 0xc0, 0xb, 0xe6, 0x49, 0xf4, 0x0,
    0x9, 0xef, 0xc4, 0x0,

    /* U+2074 "⁴" */
    0x0, 0x1, 0xe9, 0x0, 0x0, 0x0, 0xbc, 0x0,
    0x0, 0x0, 0x7e, 0x20, 0x0, 0x0, 0x4f, 0x40,
    0x84, 0x0, 0x1e, 0x80, 0xd, 0x60, 0x8, 0xff,
    0xff, 0xff, 0xf0, 0x12, 0x22, 0x2f, 0x82, 0x0,
    0x0, 0x0, 0xf6, 0x0,

    /* U+2075 "⁵" */
    0x4, 0xff, 0xff, 0xf1, 0x6, 0xe2, 0x22, 0x20,
    0x8, 0xb0, 0x0, 0x0, 0xa, 0xff, 0xec, 0x60,
    0x1, 0x22, 0x37, 0xf6, 0x0, 0x0, 0x0, 0xd9,
    0x3d, 0x64, 0x38, 0xf4, 0x18, 0xdf, 0xfc, 0x50,

    /* U+2076 "⁶" */
    0x0, 0x4b, 0xef, 0xd3, 0x5, 0xfa, 0x43, 0x61,
    0xe, 0x80, 0x0, 0x0, 0x3f, 0x6b, 0xed, 0x80,
    0x4f, 0xe5, 0x24, 0xea, 0x1f, 0x80, 0x0, 0x8e,
    0x9, 0xe4, 0x14, 0xea, 0x0, 0x8d, 0xfe, 0x90,

    /* U+2077 "⁷" */
    0x4f, 0xff, 0xff, 0xff, 0x4f, 0x22, 0x23, 0xe9,
    0x28, 0x0, 0x7, 0xf1, 0x0, 0x0, 0x1f, 0x80,
    0x0, 0x0, 0x9e, 0x0, 0x0, 0x2, 0xf7, 0x0,
    0x0, 0xa, 0xd0, 0x0, 0x0, 0x3f, 0x50, 0x0,

    /* U+2078 "⁸" */
    0x3, 0xbe, 0xfd, 0x80, 0x1, 0xf9, 0x21, 0x4e,
    0x90, 0xf, 0x80, 0x2, 0xd9, 0x0, 0x5f, 0xff,
    0xfd, 0x0, 0x2f, 0x93, 0x25, 0xda, 0x6, 0xf0,
    0x0, 0x7, 0xf0, 0x3f, 0x82, 0x14, 0xdb, 0x0,
    0x4c, 0xff, 0xe9, 0x10,

    /* U+2079 "⁹" */
    0x3, 0xbf, 0xfb, 0x30, 0x1f, 0x92, 0x28, 0xf3,
    0x5f, 0x0, 0x0, 0xfa, 0x2f, 0x70, 0x6, 0xfd,
    0x5, 0xef, 0xfb, 0xbc, 0x0, 0x1, 0x1, 0xe8,
    0x4, 0x43, 0x6d, 0xd1, 0x9, 0xef, 0xd8, 0x10,

    /* U+2080 "₀" */
    0x0, 0x9e, 0xfc, 0x40, 0x0, 0xbe, 0x64, 0x9f,
    0x40, 0x3f, 0x40, 0x0, 0xbc, 0x6, 0xf0, 0x0,
    0x7, 0xf0, 0x6f, 0x0, 0x0, 0x7f, 0x3, 0xf4,
    0x0, 0xb, 0xc0, 0xb, 0xe5, 0x39, 0xf4, 0x0,
    0x9, 0xef, 0xc4, 0x0,

    /* U+2081 "₁" */
    0x3f, 0xff, 0x50, 0x0, 0x23, 0xf5, 0x0, 0x0,
    0x1f, 0x50, 0x0, 0x1, 0xf5, 0x0, 0x0, 0x1f,
    0x50, 0x0, 0x1, 0xf5, 0x0, 0x12, 0x3f, 0x72,
    0x6, 0xff, 0xff, 0xf6,

    /* U+2082 "₂" */
    0x6, 0xdf, 0xeb, 0x30, 0x2d, 0x74, 0x4c, 0xf0,
    0x0, 0x0, 0x4, 0xf2, 0x0, 0x0, 0xc, 0xc0,
    0x0, 0x1, 0xcb, 0x0, 0x0, 0x3e, 0x90, 0x0,
    0x6, 0xf9, 0x22, 0x21, 0x1f, 0xff, 0xff, 0xf9,

    /* U+2083 "₃" */
    0x3f, 0xff, 0xff, 0xf3, 0x2, 0x22, 0x4e, 0x90,
    0x0, 0x1, 0xd9, 0x0, 0x0, 0xc, 0xf9, 0x30,
    0x0, 0x3, 0x59, 0xf3, 0x0, 0x0, 0x0, 0xd8,
    0x3c, 0x64, 0x38, 0xf5, 0x18, 0xdf, 0xfc, 0x60,

    /* U+2084 "₄" */
    0x0, 0x1, 0xe9, 0x0, 0x0, 0x0, 0xbc, 0x0,
    0x0, 0x0, 0x7e, 0x20, 0x0, 0x0, 0x4f, 0x40,
    0x84, 0x0, 0x1e, 0x80, 0xd, 0x60, 0x8, 0xff,
    0xff, 0xff, 0xf0, 0x12, 0x22, 0x2f, 0x82, 0x0,
    0x0, 0x0, 0xf6, 0x0,

    /* U+2085 "₅" */
    0x4, 0xff, 0xff, 0xf1, 0x6, 0xe2, 0x22, 0x20,
    0x8, 0xb0, 0x0, 0x0, 0xa, 0xff, 0xec, 0x60,
    0x1, 0x22, 0x37, 0xf6, 0x0, 0x0, 0x0, 0xd9,
    0x3c, 0x64, 0x38, 0xf5, 0x18, 0xdf, 0xfc, 0x50,

    /* U+2086 "₆" */
    0x0, 0x4b, 0xef, 0xd3, 0x5, 0xfa, 0x43, 0x61,
    0xe, 0x80, 0x0, 0x0, 0x3f, 0x6b, 0xed, 0x80,
    0x4f, 0xe5, 0x24, 0xea, 0x1f, 0x80, 0x0, 0x8e,
    0x9, 0xe4, 0x13, 0xda, 0x0, 0x8d, 0xfe, 0x90,

    /* U+2087 "₇" */
    0x4f, 0xff, 0xff, 0xff, 0x4f, 0x22, 0x23, 0xe9,
    0x28, 0x0, 0x7, 0xf1, 0x0, 0x0, 0x1f, 0x80,
    0x0, 0x0, 0x9e, 0x0, 0x0, 0x2, 0xf7, 0x0,
    0x0, 0xa, 0xd0, 0x0, 0x0, 0x3f, 0x50, 0x0,

    /* U+2088 "₈" */
    0x3, 0xbe, 0xfd, 0x80, 0x0, 0xf9, 0x21, 0x4e,
    0x90, 0xf, 0x80, 0x2, 0xd9, 0x0, 0x5f, 0xff,
    0xfd, 0x0, 0x2f, 0x93, 0x25, 0xda, 0x6, 0xf0,
    0x0, 0x7, 0xf0, 0x3f, 0x82, 0x14, 0xdb, 0x0,
    0x4c, 0xff, 0xe9, 0x10,

    /* U+2089 "₉" */
    0x3, 0xbf, 0xfb, 0x30, 0x1f, 0x92, 0x28, 0xf3,
    0x5f, 0x0, 0x0, 0xfa, 0x2f, 0x70, 0x6, 0xfc,
    0x5, 0xef, 0xfb, 0xbc, 0x0, 0x1, 0x1, 0xe8,
    0x3, 0x43, 0x6d, 0xd1, 0x9, 0xef, 0xd9, 0x10,

    /* U+20A1 "₡" */
    0x0, 0x0, 0x0, 0x0, 0xe5, 0xd, 0x60, 0x0,
    0x0, 0x0, 0x1, 0xf2, 0xf, 0x20, 0x0, 0x0,
    0x2, 0x7b, 0xf0, 0x3f, 0x0, 0x0, 0x1, 0xaf,
    0xff, 0xff, 0xdd, 0x0, 0x0, 0x1e, 0xfe, 0x8e,
    0xef, 0xff, 0xd1, 0x0, 0xcf, 0xc1, 0x1f, 0x40,
    0xed, 0xf5, 0x5, 0xfd, 0x0, 0x5f, 0x3, 0xf0,
    0x20, 0xb, 0xf6, 0x0, 0x9b, 0x7, 0xb0, 0x0,
    0xf, 0xf1, 0x0, 0xd7, 0xb, 0x70, 0x0, 0xf,
    0xf0, 0x1, 0xf3, 0xf, 0x30, 0x0, 0xf, 0xf0,
    0x5, 0xe0, 0x4e, 0x0, 0x0, 0xc, 0xf3, 0x9,
    0xa0, 0x8a, 0x0, 0x0, 0x7, 0xfa, 0xd, 0x60,
    0xc6, 0x0, 0x0, 0x1, 0xef, 0x7f, 0x21, 0xf2,
    0x0, 0x30, 0x0, 0x4f, 0xff, 0x25, 0xe0, 0x3b,
    0xf5, 0x0, 0x4, 0xef, 0xff, 0xff, 0xff, 0xc1,
    0x0, 0x0, 0xda, 0xcf, 0xfe, 0xb5, 0x0, 0x0,
    0x1, 0xf2, 0x1f, 0x20, 0x0, 0x0, 0x0, 0x5,
    0xe0, 0x4e, 0x0, 0x0, 0x0, 0x0, 0x3, 0x50,
    0x36, 0x0, 0x0, 0x0,

    /* U+20A3 "₣" */
    0x0, 0x5f, 0xff, 0xff, 0xff, 0xff, 0x80, 0x5,
    0xfe, 0xcc, 0xcc, 0xcc, 0xc6, 0x0, 0x5f, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x5, 0xfa, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xa0, 0x0, 0x0, 0x0,
    0x0, 0x5, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xec, 0xcc, 0xcc, 0xc8, 0x0, 0x5, 0xff,
    0xff, 0xff, 0xff, 0xb0, 0x0, 0x5f, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x5, 0xfa, 0x0, 0x0, 0x0,
    0x0, 0x6f, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x1,
    0x27, 0xfb, 0x22, 0x22, 0x0, 0x0, 0x0, 0x5f,
    0xa0, 0x0, 0x0, 0x0, 0x0, 0x5, 0xfa, 0x0,
    0x0, 0x0, 0x0,

    /* U+20A4 "₤" */
    0x0, 0x0, 0x5, 0xbe, 0xff, 0xd8, 0x10, 0x0,
    0xb, 0xff, 0xfd, 0xef, 0xf6, 0x0, 0x9, 0xfd,
    0x30, 0x0, 0x6, 0x0, 0x0, 0xff, 0x20, 0x0,
    0x0, 0x0, 0x0, 0x2f, 0xd0, 0x0, 0x0, 0x0,
    0x6, 0xff, 0xff, 0xff, 0xff, 0xf1, 0x0, 0x12,
    0x5f, 0xc2, 0x22, 0x22, 0x0, 0x0, 0x3, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xff, 0xff, 0xff,
    0xff, 0x10, 0x1, 0x25, 0xfc, 0x22, 0x22, 0x20,
    0x0, 0x0, 0x3f, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x5c, 0xdf,
    0xfc, 0xcc, 0xcc, 0xcc, 0x36, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf5,

    /* U+20A6 "₦" */
    0x0, 0x3f, 0xc0, 0x0, 0x0, 0x0, 0x3f, 0xd0,
    0x0, 0x3, 0xff, 0xa0, 0x0, 0x0, 0x3, 0xfd,
    0x0, 0x0, 0x3f, 0xff, 0x70, 0x0, 0x0, 0x3f,
    0xd0, 0x0, 0x3, 0xfe, 0xff, 0x40, 0x0, 0x3,
    0xfd, 0x0, 0x0, 0x3f, 0xc7, 0xfe, 0x20, 0x0,
    0x3f, 0xd0, 0x6, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x12, 0x5f, 0xc2, 0x2d, 0xfb,
    0x22, 0x5f, 0xd2, 0x20, 0x3, 0xfc, 0x0, 0x3f,
    0xf5, 0x3, 0xfd, 0x0, 0x6f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xf1, 0x25, 0xfc, 0x22,
    0x22, 0x9f, 0xe6, 0xfd, 0x22, 0x0, 0x3f, 0xc0,
    0x0, 0x0, 0xcf, 0xdf, 0xd0, 0x0, 0x3, 0xfc,
    0x0, 0x0, 0x1, 0xdf, 0xfd, 0x0, 0x0, 0x3f,
    0xc0, 0x0, 0x0, 0x2, 0xef, 0xd0, 0x0, 0x3,
    0xfc, 0x0, 0x0, 0x0, 0x4, 0xfd, 0x0,

    /* U+20A7 "₧" */
    0xef, 0xff, 0xff, 0xec, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe,
    0xfd, 0xcc, 0xde, 0xff, 0xd1, 0x0, 0x5, 0xe7,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x10, 0x0, 0x2, 0xcf, 0xc0, 0x0, 0x6f, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xf1,
    0x0, 0x0, 0x1, 0xef, 0x23, 0xff, 0xff, 0xff,
    0x90, 0x0, 0x7d, 0xff, 0xda, 0x40, 0xef, 0x10,
    0x0, 0x0, 0xb, 0xf5, 0x1a, 0xcf, 0xda, 0xa5,
    0x0, 0xbf, 0xea, 0xbd, 0xf9, 0xe, 0xf1, 0x0,
    0x0, 0x0, 0xbf, 0x40, 0x6, 0xf8, 0x0, 0x0,
    0x3f, 0xc0, 0x0, 0x3, 0x10, 0xef, 0x10, 0x0,
    0x0, 0x2f, 0xf1, 0x0, 0x6f, 0x80, 0x0, 0x5,
    0xfa, 0x0, 0x0, 0x0, 0xe, 0xf1, 0x0, 0x1,
    0x5d, 0xfa, 0x0, 0x6, 0xf8, 0x0, 0x0, 0x2f,
    0xfb, 0x63, 0x0, 0x0, 0xef, 0xff, 0xff, 0xff,
    0xfa, 0x0, 0x0, 0x6f, 0x80, 0x0, 0x0, 0x4e,
    0xff, 0xff, 0xa2, 0xe, 0xfc, 0xcc, 0xcb, 0x83,
    0x0, 0x0, 0x6, 0xf8, 0x0, 0x0, 0x0, 0x3,
    0x6a, 0xef, 0xe0, 0xef, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x5f, 0x80, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xdf, 0x3e, 0xf1, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x3, 0xfb, 0x0, 0x0, 0x16, 0x0, 0x0,
    0xd, 0xf1, 0xef, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xfb, 0x9c, 0x8, 0xfe, 0xb9, 0x9d,
    0xf9, 0xe, 0xf1, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2b, 0xef, 0xb1, 0x7, 0xbe, 0xff, 0xc6,
    0x0,

    /* U+20A9 "₩" */
    0xe, 0xf2, 0x0, 0x0, 0x0, 0x2f, 0xf1, 0x0,
    0x0, 0x0, 0x3f, 0xc0, 0x9, 0xf8, 0x0, 0x0,
    0x0, 0x8f, 0xf7, 0x0, 0x0, 0x0, 0x8f, 0x60,
    0x3, 0xfd, 0x0, 0x0, 0x0, 0xef, 0xfc, 0x0,
    0x0, 0x0, 0xef, 0x10, 0x0, 0xdf, 0x30, 0x0,
    0x3, 0xfa, 0xcf, 0x20, 0x0, 0x4, 0xfb, 0x0,
    0x0, 0x7f, 0x80, 0x0, 0x9, 0xf4, 0x7f, 0x80,
    0x0, 0x9, 0xf6, 0x0, 0x6f, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf4,
    0x12, 0x2d, 0xf6, 0x22, 0x7f, 0xa2, 0x2c, 0xf5,
    0x22, 0x6f, 0xb2, 0x20, 0x0, 0x8, 0xf8, 0x0,
    0x9f, 0x40, 0x6, 0xf8, 0x0, 0x9f, 0x60, 0x0,
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xf4, 0x12, 0x22, 0xdf, 0x57,
    0xfa, 0x22, 0x22, 0xbf, 0x56, 0xfb, 0x22, 0x20,
    0x0, 0x0, 0x7f, 0x9b, 0xf3, 0x0, 0x0, 0x5f,
    0x9a, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x2f, 0xef,
    0xd0, 0x0, 0x0, 0xf, 0xef, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xff, 0x70, 0x0, 0x0, 0x9,
    0xff, 0x90, 0x0, 0x0, 0x0, 0x0, 0x6, 0xff,
    0x10, 0x0, 0x0, 0x3, 0xff, 0x40, 0x0, 0x0,

    /* U+20AB "₫" */
    0x0, 0x0, 0x0, 0x0, 0x1, 0xfd, 0x0, 0x0,
    0x0, 0x4, 0xff, 0xff, 0xff, 0xf9, 0x0, 0x0,
    0x0, 0x22, 0x23, 0xfd, 0x21, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xfd, 0x0, 0x0, 0x4, 0xbe, 0xfc,
    0x61, 0xfd, 0x0, 0x0, 0x8f, 0xfd, 0xce, 0xfb,
    0xfd, 0x0, 0x5, 0xfe, 0x40, 0x0, 0x7f, 0xfd,
    0x0, 0xc, 0xf4, 0x0, 0x0, 0x9, 0xfd, 0x0,
    0xf, 0xe0, 0x0, 0x0, 0x3, 0xfd, 0x0, 0x2f,
    0xc0, 0x0, 0x0, 0x1, 0xfd, 0x0, 0xf, 0xe0,
    0x0, 0x0, 0x3, 0xfd, 0x0, 0xc, 0xf4, 0x0,
    0x0, 0x9, 0xfd, 0x0, 0x5, 0xfe, 0x40, 0x0,
    0x7f, 0xfd, 0x0, 0x0, 0x8f, 0xfd, 0xce, 0xfa,
    0xfd, 0x0, 0x0, 0x4, 0xbe, 0xfc, 0x60, 0xfd,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xff, 0xff, 0xff, 0xff, 0xfd, 0x0, 0x2,
    0x22, 0x22, 0x22, 0x22, 0x22, 0x0,

    /* U+20AC "€" */
    0x0, 0x0, 0x0, 0x39, 0xdf, 0xfd, 0x93, 0x0,
    0x0, 0x0, 0x9, 0xff, 0xfe, 0xdf, 0xff, 0x90,
    0x0, 0x0, 0xbf, 0xe6, 0x10, 0x0, 0x5d, 0xe1,
    0x0, 0x7, 0xfe, 0x10, 0x0, 0x0, 0x0, 0x10,
    0x0, 0xe, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x0,
    0x12, 0x7f, 0xb2, 0x22, 0x22, 0x20, 0x0, 0x0,
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xf5, 0x0, 0x0,
    0x12, 0x2f, 0xf4, 0x22, 0x22, 0x20, 0x0, 0x0,
    0x0, 0xa, 0xf9, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x2, 0xff, 0x50, 0x0, 0x0, 0x3, 0x50,
    0x0, 0x0, 0x6f, 0xf9, 0x10, 0x1, 0x7f, 0xf2,
    0x0, 0x0, 0x6, 0xff, 0xfe, 0xef, 0xff, 0x70,
    0x0, 0x0, 0x0, 0x18, 0xdf, 0xfd, 0x92, 0x0,

    /* U+20AD "₭" */
    0x0, 0x5f, 0xa0, 0x0, 0x0, 0xaf, 0xb0, 0x0,
    0x5f, 0xa0, 0x0, 0x9, 0xfb, 0x0, 0x0, 0x5f,
    0xa0, 0x0, 0x9f, 0xc0, 0x0, 0x0, 0x5f, 0xa0,
    0x8, 0xfc, 0x0, 0x0, 0x0, 0x5f, 0xa0, 0x7f,
    0xd1, 0x0, 0x0, 0x1, 0x6f, 0xa7, 0xfe, 0x21,
    0x10, 0x0, 0x6f, 0xff, 0xff, 0xff, 0xff, 0xfb,
    0x0, 0x14, 0x8f, 0xba, 0xfe, 0x44, 0x42, 0x0,
    0x0, 0x5f, 0xa0, 0xcf, 0x90, 0x0, 0x0, 0x0,
    0x5f, 0xa0, 0x1e, 0xf6, 0x0, 0x0, 0x0, 0x5f,
    0xa0, 0x2, 0xff, 0x40, 0x0, 0x0, 0x5f, 0xa0,
    0x0, 0x4f, 0xe2, 0x0, 0x0, 0x5f, 0xa0, 0x0,
    0x7, 0xfd, 0x10, 0x0, 0x5f, 0xa0, 0x0, 0x0,
    0x9f, 0xb0,

    /* U+20AE "₮" */
    0xff, 0xff, 0xff, 0xff, 0xff, 0xfa, 0xcc, 0xcc,
    0xdf, 0xfc, 0xcc, 0xc7, 0x0, 0x0, 0x3f, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x3f, 0xd0, 0x1, 0x0,
    0x0, 0x0, 0x3f, 0xd1, 0x8f, 0x10, 0x0, 0x0,
    0x3f, 0xff, 0xa2, 0x0, 0x0, 0x1, 0x9f, 0xe2,
    0x3, 0x10, 0x1, 0x9f, 0xbf, 0xd3, 0xbe, 0x10,
    0x7, 0xa2, 0x3f, 0xfe, 0x70, 0x0, 0x0, 0x3,
    0xbf, 0xd0, 0x0, 0x0, 0x2, 0xbe, 0x9f, 0xd0,
    0x0, 0x0, 0x5, 0x70, 0x3f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xd0, 0x0, 0x0,

    /* U+20B1 "₱" */
    0x0, 0x3f, 0xff, 0xff, 0xfe, 0xa4, 0x0, 0x0,
    0x0, 0x3, 0xff, 0xcc, 0xcd, 0xff, 0xfa, 0x0,
    0x0, 0x0, 0x3f, 0xc0, 0x0, 0x0, 0x5e, 0xf7,
    0x0, 0x6, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf4, 0x2, 0x5f, 0xc2, 0x22, 0x22, 0x22,
    0xff, 0x22, 0x6, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xf4, 0x12, 0x5f, 0xc2, 0x22, 0x22,
    0x2d, 0xfa, 0x22, 0x0, 0x3, 0xfc, 0x0, 0x0,
    0x3b, 0xfe, 0x10, 0x0, 0x0, 0x3f, 0xff, 0xff,
    0xff, 0xfe, 0x30, 0x0, 0x0, 0x3, 0xff, 0xcc,
    0xcc, 0xa6, 0x0, 0x0, 0x0, 0x0, 0x3f, 0xc0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xfc,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3f,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3,
    0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+20B2 "₲" */
    0x0, 0x0, 0x0, 0x9, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x17,
    0xbf, 0xfe, 0xc7, 0x0, 0x0, 0x5, 0xff, 0xff,
    0xfe, 0xff, 0xe3, 0x0, 0x6f, 0xf9, 0x29, 0xb0,
    0x29, 0xf7, 0x1, 0xff, 0x50, 0x9, 0xb0, 0x0,
    0x20, 0x9, 0xf9, 0x0, 0x9, 0xb0, 0x0, 0x0,
    0xd, 0xf2, 0x0, 0x9, 0xb0, 0x0, 0x0, 0xf,
    0xf0, 0x0, 0x9, 0xb0, 0x0, 0x10, 0xf, 0xf0,
    0x0, 0x9, 0xb0, 0x3, 0xfb, 0xd, 0xf2, 0x0,
    0x9, 0xb0, 0x3, 0xfb, 0x9, 0xf9, 0x0, 0x9,
    0xb0, 0x3, 0xfb, 0x1, 0xff, 0x50, 0x9, 0xb0,
    0x3, 0xfb, 0x0, 0x5f, 0xf9, 0x29, 0xb0, 0x19,
    0xfb, 0x0, 0x5, 0xff, 0xff, 0xfe, 0xff, 0xf5,
    0x0, 0x0, 0x17, 0xbf, 0xff, 0xc7, 0x10, 0x0,
    0x0, 0x0, 0x9, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0x50, 0x0, 0x0,

    /* U+20B4 "₴" */
    0x0, 0x4, 0xad, 0xff, 0xd9, 0x20, 0x0, 0x0,
    0x4f, 0xff, 0xdc, 0xef, 0xf5, 0x0, 0x0, 0x8,
    0x30, 0x0, 0x5, 0xff, 0x10, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xdf, 0x40, 0x4f, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xf9, 0x2, 0x22, 0x22, 0x22, 0x22, 0x22,
    0x21, 0x4f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf9,
    0x2, 0xef, 0x82, 0x22, 0x22, 0x22, 0x21, 0x0,
    0xff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xff,
    0x10, 0x0, 0x0, 0x1, 0x0, 0x0, 0x9f, 0xb1,
    0x0, 0x1, 0x7e, 0x50, 0x0, 0xc, 0xff, 0xdc,
    0xdf, 0xff, 0x50, 0x0, 0x0, 0x6c, 0xef, 0xeb,
    0x71, 0x0,

    /* U+20B5 "₵" */
    0x0, 0x0, 0x0, 0x9, 0xb0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x18,
    0xcf, 0xfe, 0xc6, 0x0, 0x0, 0x6, 0xff, 0xff,
    0xfe, 0xff, 0xd1, 0x0, 0x6f, 0xf9, 0x29, 0xb0,
    0x2a, 0xf5, 0x2, 0xff, 0x50, 0x9, 0xb0, 0x0,
    0x20, 0x9, 0xf9, 0x0, 0x9, 0xb0, 0x0, 0x0,
    0xd, 0xf2, 0x0, 0x9, 0xb0, 0x0, 0x0, 0xf,
    0xf0, 0x0, 0x9, 0xb0, 0x0, 0x0, 0xf, 0xf0,
    0x0, 0x9, 0xb0, 0x0, 0x0, 0xd, 0xf2, 0x0,
    0x9, 0xb0, 0x0, 0x0, 0x9, 0xf9, 0x0, 0x9,
    0xb0, 0x0, 0x0, 0x2, 0xff, 0x50, 0x9, 0xb0,
    0x0, 0x30, 0x0, 0x6f, 0xf9, 0x29, 0xb0, 0x2b,
    0xf5, 0x0, 0x5, 0xff, 0xff, 0xfe, 0xff, 0xc1,
    0x0, 0x0, 0x17, 0xcf, 0xfe, 0xb6, 0x0, 0x0,
    0x0, 0x0, 0x9, 0xb0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x9, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x4, 0x50, 0x0, 0x0,

    /* U+20B8 "₸" */
    0x7f, 0xff, 0xff, 0xff, 0xff, 0xff, 0x11, 0x33,
    0x33, 0x33, 0x33, 0x33, 0x30, 0x7f, 0xff, 0xff,
    0xff, 0xff, 0xff, 0x11, 0x33, 0x33, 0xcf, 0x63,
    0x33, 0x30, 0x0, 0x0, 0xb, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xbf, 0x40, 0x0, 0x0, 0x0,
    0x0, 0xb, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0x40, 0x0, 0x0, 0x0, 0x0, 0xb, 0xf4,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x40, 0x0,
    0x0, 0x0, 0x0, 0xb, 0xf4, 0x0, 0x0, 0x0,
    0x0, 0x0, 0xbf, 0x40, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0xbf,
    0x40, 0x0, 0x0,

    /* U+20B9 "₹" */
    0x6f, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf6, 0x2,
    0x22, 0x22, 0x38, 0xff, 0x52, 0x20, 0x13, 0x33,
    0x33, 0x33, 0x7f, 0xe3, 0x31, 0x6e, 0xee, 0xee,
    0xee, 0xef, 0xff, 0xe5, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xf6, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xf4, 0x0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xe0,
    0x0, 0x0, 0x78, 0x88, 0x9d, 0xff, 0x40, 0x0,
    0x0, 0xef, 0xff, 0xff, 0xb2, 0x0, 0x0, 0x0,
    0x23, 0x32, 0x8f, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0xd, 0xf5, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3, 0xfe, 0x10, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x8f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd,
    0xf4, 0x0,

    /* U+20BA "₺" */
    0x0, 0x3f, 0xc0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3f, 0xc0, 0x0, 0x5d, 0x10, 0x0, 0x0, 0x3f,
    0xc0, 0x4d, 0xd5, 0x0, 0x0, 0x0, 0x3f, 0xdc,
    0xd5, 0x1, 0x0, 0x0, 0x0, 0x5f, 0xf6, 0x1,
    0x8f, 0x10, 0x0, 0x2b, 0xff, 0xc0, 0x7e, 0xa2,
    0x0, 0x0, 0x58, 0x4f, 0xee, 0xb3, 0x0, 0x0,
    0x10, 0x0, 0x7f, 0xe4, 0x0, 0x0, 0xa, 0xf5,
    0x3d, 0xef, 0xc0, 0x0, 0x0, 0xc, 0xf3, 0x45,
    0x3f, 0xc0, 0x0, 0x0, 0x2f, 0xe0, 0x0, 0x3f,
    0xc0, 0x0, 0x0, 0xbf, 0x90, 0x0, 0x3f, 0xc0,
    0x0, 0x3c, 0xfd, 0x0, 0x0, 0x3f, 0xfc, 0xdf,
    0xff, 0xb1, 0x0, 0x0, 0x3f, 0xff, 0xec, 0x93,
    0x0, 0x0,

    /* U+20BC "₼" */
    0x0, 0x0, 0x0, 0x7d, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x7d, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x3a, 0xdf, 0xff, 0xb5, 0x0, 0x0, 0x0, 0x6f,
    0xfd, 0xdf, 0xcf, 0xfa, 0x0, 0x0, 0x5f, 0xe4,
    0x7, 0xd0, 0x1b, 0xfa, 0x0, 0xe, 0xf2, 0x0,
    0x7d, 0x0, 0xc, 0xf4, 0x5, 0xf8, 0x0, 0x7,
    0xd0, 0x0, 0x3f, 0xa0, 0xaf, 0x30, 0x0, 0x7d,
    0x0, 0x0, 0xef, 0xc, 0xf0, 0x0, 0x7, 0xd0,
    0x0, 0xb, 0xf1, 0xef, 0x0, 0x0, 0x7d, 0x0,
    0x0, 0xaf, 0x3e, 0xf0, 0x0, 0x7, 0xd0, 0x0,
    0xa, 0xf3, 0xef, 0x0, 0x0, 0x7d, 0x0, 0x0,
    0xaf, 0x3e, 0xf0, 0x0, 0x7, 0xd0, 0x0, 0xa,
    0xf3, 0xef, 0x0, 0x0, 0x25, 0x0, 0x0, 0xaf,
    0x3e, 0xf0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xf3,
    0xef, 0x0, 0x0, 0x0, 0x0, 0x0, 0xaf, 0x30,

    /* U+20BD "₽" */
    0x0, 0x5f, 0xff, 0xff, 0xfe, 0xb5, 0x0, 0x0,
    0x5f, 0xec, 0xcc, 0xdf, 0xff, 0xb0, 0x0, 0x5f,
    0xa0, 0x0, 0x0, 0x4e, 0xf7, 0x0, 0x5f, 0xa0,
    0x0, 0x0, 0x5, 0xfd, 0x0, 0x5f, 0xa0, 0x0,
    0x0, 0x1, 0xfe, 0x0, 0x5f, 0xa0, 0x0, 0x0,
    0x4, 0xfd, 0x0, 0x5f, 0xa0, 0x0, 0x0, 0x3e,
    0xf7, 0x0, 0x5f, 0xeb, 0xbb, 0xbd, 0xff, 0xb0,
    0x0, 0x5f, 0xff, 0xff, 0xfe, 0xb5, 0x0, 0x0,
    0x5f, 0xa0, 0x0, 0x0, 0x0, 0x0, 0x6f, 0xff,
    0xff, 0xff, 0xf1, 0x0, 0x0, 0x12, 0x7f, 0xb2,
    0x22, 0x20, 0x0, 0x0, 0x0, 0x5f, 0xa0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x5f, 0xa0, 0x0, 0x0,
    0x0, 0x0,

    /* U+2113 "ℓ" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0xcf,
    0xd2, 0x0, 0x0, 0xea, 0x19, 0xa0, 0x0, 0x6f,
    0x0, 0x6b, 0x0, 0xa, 0xb0, 0x9, 0x90, 0x0,
    0xe8, 0x0, 0xe3, 0x0, 0xf, 0x60, 0x9a, 0x0,
    0x3, 0xf3, 0x6c, 0x0, 0x0, 0x6f, 0x7d, 0x10,
    0x0, 0x8, 0xfc, 0x10, 0x0, 0x2, 0xdb, 0x0,
    0x0, 0x3, 0xdf, 0x70, 0x0, 0x0, 0x1, 0xd8,
    0x0, 0x9, 0x70, 0xb, 0xe6, 0x6c, 0xd1, 0x0,
    0x2d, 0xfe, 0x90, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+2116 "№" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x1, 0x0, 0x0, 0xef, 0x20, 0x0, 0x0, 0x0,
    0xef, 0x10, 0x9, 0xff, 0xf9, 0x0, 0xef, 0xd1,
    0x0, 0x0, 0x0, 0xef, 0x10, 0x9e, 0x40, 0x4e,
    0x90, 0xef, 0xfb, 0x0, 0x0, 0x0, 0xef, 0x10,
    0xf6, 0x0, 0x6, 0xf0, 0xef, 0xef, 0x80, 0x0,
    0x0, 0xef, 0x10, 0xf5, 0x0, 0x5, 0xf0, 0xef,
    0x4f, 0xf5, 0x0, 0x0, 0xef, 0x10, 0xbd, 0x10,
    0x1d, 0xb0, 0xef, 0x15, 0xff, 0x20, 0x0, 0xef,
    0x10, 0x1c, 0xfd, 0xfc, 0x10, 0xef, 0x10, 0x9f,
    0xd1, 0x0, 0xef, 0x10, 0x0, 0x35, 0x30, 0x0,
    0xef, 0x10, 0xc, 0xfb, 0x0, 0xef, 0x10, 0x1,
    0x11, 0x11, 0x0, 0xef, 0x10, 0x1, 0xef, 0x80,
    0xef, 0x10, 0xaf, 0xff, 0xff, 0xa0, 0xef, 0x10,
    0x0, 0x3f, 0xf5, 0xef, 0x10, 0x23, 0x33, 0x33,
    0x20, 0xef, 0x10, 0x0, 0x5, 0xff, 0xff, 0x10,
    0x0, 0x0, 0x0, 0x0, 0xef, 0x10, 0x0, 0x0,
    0x9f, 0xff, 0x10, 0x0, 0x0, 0x0, 0x0, 0xef,
    0x10, 0x0, 0x0, 0xb, 0xff, 0x10, 0x0, 0x0,
    0x0, 0x0, 0xef, 0x10, 0x0, 0x0, 0x1, 0xef,
    0x10, 0x0, 0x0, 0x0, 0x0,

    /* U+2122 "™" */
    0xef, 0xff, 0xff, 0xf9, 0x3f, 0x40, 0x0, 0x0,
    0x1f, 0x72, 0x22, 0xe9, 0x22, 0x13, 0xfe, 0x0,
    0x0, 0xa, 0xf7, 0x0, 0xe, 0x80, 0x0, 0x3f,
    0xf9, 0x0, 0x5, 0xff, 0x70, 0x0, 0xe8, 0x0,
    0x3, 0xf6, 0xf3, 0x0, 0xe6, 0xe7, 0x0, 0xe,
    0x80, 0x0, 0x3f, 0x29, 0xd0, 0x9c, 0xe, 0x70,
    0x0, 0xe8, 0x0, 0x3, 0xf2, 0xd, 0xbf, 0x20,
    0xe7, 0x0, 0xe, 0x80, 0x0, 0x3f, 0x20, 0x4f,
    0x70, 0xe, 0x70, 0x0, 0xe8, 0x0, 0x3, 0xf2,
    0x0, 0x40, 0x0, 0xe7, 0x0, 0x4, 0x20, 0x0,
    0x14, 0x0, 0x0, 0x0, 0x4, 0x20,

    /* U+2126 "Ω" */
    0x0, 0x0, 0x0, 0x0, 0x11, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6, 0xcf, 0xff, 0xfc, 0x60,
    0x0, 0x0, 0x0, 0x2, 0xcf, 0xfd, 0xaa, 0xdf,
    0xfc, 0x10, 0x0, 0x0, 0x1d, 0xfc, 0x20, 0x0,
    0x2, 0xbf, 0xd1, 0x0, 0x0, 0x9f, 0xb0, 0x0,
    0x0, 0x0, 0xb, 0xf9, 0x0, 0x1, 0xff, 0x20,
    0x0, 0x0, 0x0, 0x1, 0xff, 0x10, 0x5, 0xfb,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xbf, 0x50, 0x6,
    0xf9, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x60,
    0x6, 0xfa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f,
    0x60, 0x4, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0,
    0xcf, 0x40, 0x0, 0xef, 0x30, 0x0, 0x0, 0x0,
    0x3, 0xfe, 0x0, 0x0, 0x6f, 0xc0, 0x0, 0x0,
    0x0, 0xc, 0xf6, 0x0, 0x0, 0xa, 0xfb, 0x10,
    0x0, 0x1, 0xbf, 0xa0, 0x0, 0x9b, 0xbc, 0xff,
    0xe0, 0x0, 0xe, 0xff, 0xcb, 0xb9, 0xdf, 0xff,
    0xff, 0xf1, 0x0, 0x1f, 0xff, 0xff, 0xfd,

    /* U+212A "K" */
    0xef, 0x10, 0x0, 0x0, 0xc, 0xf7, 0xe, 0xf1,
    0x0, 0x0, 0xb, 0xf8, 0x0, 0xef, 0x10, 0x0,
    0xb, 0xf9, 0x0, 0xe, 0xf1, 0x0, 0xb, 0xfa,
    0x0, 0x0, 0xef, 0x10, 0xa, 0xfa, 0x0, 0x0,
    0xe, 0xf1, 0xa, 0xfb, 0x0, 0x0, 0x0, 0xef,
    0x19, 0xff, 0x30, 0x0, 0x0, 0xe, 0xfa, 0xff,
    0xfe, 0x10, 0x0, 0x0, 0xef, 0xfd, 0x1b, 0xfc,
    0x0, 0x0, 0xe, 0xfd, 0x10, 0xd, 0xfa, 0x0,
    0x0, 0xef, 0x20, 0x0, 0x1e, 0xf7, 0x0, 0xe,
    0xf1, 0x0, 0x0, 0x3f, 0xf4, 0x0, 0xef, 0x10,
    0x0, 0x0, 0x4f, 0xf2, 0xe, 0xf1, 0x0, 0x0,
    0x0, 0x6f, 0xd1,

    /* U+212B "Å" */
    0x0, 0x0, 0x0, 0x9, 0xc7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa6, 0xa, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xe0, 0x4, 0xa0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa6, 0xa, 0x60, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xa, 0xc7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xd, 0xf9, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0xff, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xaf, 0x80, 0x0, 0x0,
    0x0, 0x0, 0x3, 0xfb, 0xf, 0xf0, 0x0, 0x0,
    0x0, 0x0, 0xa, 0xf4, 0x8, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0xd0, 0x1, 0xfe, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0x60, 0x0, 0xaf, 0x50, 0x0,
    0x0, 0x1, 0xfe, 0x0, 0x0, 0x3f, 0xc0, 0x0,
    0x0, 0x7, 0xf8, 0x0, 0x0, 0xc, 0xf4, 0x0,
    0x0, 0xe, 0xff, 0xff, 0xff, 0xff, 0xfb, 0x0,
    0x0, 0x6f, 0xc8, 0x88, 0x88, 0x88, 0xef, 0x20,
    0x0, 0xdf, 0x20, 0x0, 0x0, 0x0, 0x6f, 0xa0,
    0x5, 0xfb, 0x0, 0x0, 0x0, 0x0, 0xe, 0xf1,
    0xc, 0xf4, 0x0, 0x0, 0x0, 0x0, 0x8, 0xf8,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+212E "℮" */
    0x0, 0x0, 0x4, 0x87, 0x66, 0x78, 0x30, 0x0,
    0x0, 0x0, 0x2b, 0x50, 0x0, 0x0, 0x7, 0xa0,
    0x0, 0x0, 0x3d, 0x10, 0x0, 0x0, 0x0, 0x4,
    0xd1, 0x0, 0xe, 0xd0, 0x0, 0x0, 0x0, 0x0,
    0x1f, 0xa0, 0x7, 0xfd, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xff, 0x30, 0xdf, 0xd0, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0xf9, 0xf, 0xfe, 0x44, 0x44, 0x44,
    0x44, 0x45, 0xff, 0xb0, 0xff, 0xd1, 0x11, 0x11,
    0x11, 0x11, 0x11, 0x11, 0xd, 0xfd, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x7f, 0xd0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xed, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3, 0xe2,
    0x0, 0x0, 0x0, 0x0, 0x58, 0x0, 0x0, 0x2,
    0xa4, 0x0, 0x0, 0x0, 0x89, 0x0, 0x0, 0x0,
    0x0, 0x47, 0x76, 0x67, 0x83, 0x0, 0x0,

    /* U+2153 "⅓" */
    0x3f, 0xff, 0x50, 0x0, 0x0, 0x0, 0x1e, 0x80,
    0x0, 0x0, 0x34, 0xf5, 0x0, 0x0, 0x0, 0xa,
    0xd0, 0x0, 0x0, 0x0, 0x1f, 0x50, 0x0, 0x0,
    0x5, 0xf2, 0x0, 0x0, 0x0, 0x1, 0xf5, 0x0,
    0x0, 0x1, 0xe7, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0x50, 0x0, 0x0, 0xbc, 0x0, 0x0, 0x0, 0x0,
    0x1, 0xf5, 0x0, 0x0, 0x6f, 0x4f, 0xff, 0xff,
    0xf4, 0x0, 0x1f, 0x50, 0x0, 0x2f, 0x60, 0x33,
    0x33, 0xdc, 0x6, 0xff, 0xff, 0xf6, 0xc, 0xb0,
    0x0, 0x0, 0x8f, 0x20, 0x13, 0x33, 0x33, 0x17,
    0xf1, 0x0, 0x0, 0x4f, 0x50, 0x0, 0x0, 0x0,
    0x2, 0xf5, 0x0, 0x0, 0xc, 0xfd, 0x70, 0x0,
    0x0, 0x0, 0xca, 0x0, 0x0, 0x0, 0x12, 0x6f,
    0x60, 0x0, 0x0, 0x8e, 0x10, 0x0, 0x0, 0x0,
    0x0, 0xca, 0x0, 0x0, 0x3f, 0x50, 0x0, 0x2,
    0xc5, 0x32, 0x6f, 0x50, 0x0, 0xd, 0xa0, 0x0,
    0x0, 0x18, 0xce, 0xfd, 0x60,

    /* U+2154 "⅔" */
    0x6, 0xdf, 0xeb, 0x30, 0x0, 0x0, 0x1, 0xe8,
    0x0, 0x0, 0x2c, 0x74, 0x4c, 0xe0, 0x0, 0x0,
    0xa, 0xd0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xf2,
    0x0, 0x0, 0x5f, 0x20, 0x0, 0x0, 0x0, 0x0,
    0xb, 0xc0, 0x0, 0x1, 0xe7, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xbd, 0x10, 0x0, 0xb, 0xc0, 0x0,
    0x0, 0x0, 0x0, 0x2d, 0xb0, 0x0, 0x0, 0x6f,
    0x4f, 0xff, 0xff, 0xf4, 0x4, 0xe9, 0x0, 0x0,
    0x2, 0xf6, 0x3, 0x33, 0x3d, 0xc0, 0x1f, 0xff,
    0xff, 0xf9, 0xc, 0xb0, 0x0, 0x0, 0x8f, 0x20,
    0x3, 0x33, 0x33, 0x31, 0x7f, 0x10, 0x0, 0x4,
    0xf5, 0x0, 0x0, 0x0, 0x0, 0x2, 0xf5, 0x0,
    0x0, 0xc, 0xfd, 0x70, 0x0, 0x0, 0x0, 0xc,
    0xa0, 0x0, 0x0, 0x1, 0x26, 0xf6, 0x0, 0x0,
    0x0, 0x8e, 0x10, 0x0, 0x0, 0x0, 0x0, 0xca,
    0x0, 0x0, 0x3, 0xf5, 0x0, 0x0, 0x2c, 0x53,
    0x26, 0xf5, 0x0, 0x0, 0xd, 0xa0, 0x0, 0x0,
    0x18, 0xce, 0xfd, 0x60,

    /* U+215B "⅛" */
    0x3f, 0xff, 0x50, 0x0, 0x0, 0x0, 0x1e, 0x80,
    0x0, 0x0, 0x3, 0x4f, 0x50, 0x0, 0x0, 0x0,
    0xad, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x50, 0x0,
    0x0, 0x5, 0xf2, 0x0, 0x0, 0x0, 0x0, 0x1f,
    0x50, 0x0, 0x0, 0x1e, 0x70, 0x0, 0x0, 0x0,
    0x0, 0x1f, 0x50, 0x0, 0x0, 0xbc, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x1f, 0x50, 0x0, 0x6, 0xf2,
    0x19, 0xde, 0xc6, 0x0, 0x0, 0x1f, 0x50, 0x0,
    0x2f, 0x60, 0xbd, 0x42, 0x6f, 0x70, 0x6f, 0xff,
    0xff, 0x60, 0xcb, 0x0, 0xf5, 0x0, 0xa, 0xc0,
    0x13, 0x33, 0x33, 0x17, 0xf1, 0x0, 0xdb, 0x10,
    0x2e, 0x80, 0x0, 0x0, 0x0, 0x2f, 0x50, 0x0,
    0x3f, 0xff, 0xfe, 0x10, 0x0, 0x0, 0x0, 0xca,
    0x0, 0x1, 0xea, 0x32, 0x4d, 0xb0, 0x0, 0x0,
    0x8, 0xe1, 0x0, 0x5, 0xf1, 0x0, 0x5, 0xf0,
    0x0, 0x0, 0x3f, 0x50, 0x0, 0x2, 0xf8, 0x10,
    0x2c, 0xd0, 0x0, 0x0, 0xda, 0x0, 0x0, 0x0,
    0x3b, 0xef, 0xe9, 0x10,

    /* U+215C "⅜" */
    0x3f, 0xff, 0xff, 0xf3, 0x0, 0x0, 0x1, 0xe8,
    0x0, 0x0, 0x0, 0x33, 0x34, 0xe9, 0x0, 0x0,
    0x0, 0xad, 0x0, 0x0, 0x0, 0x0, 0x2, 0xd8,
    0x0, 0x0, 0x0, 0x5f, 0x20, 0x0, 0x0, 0x0,
    0x0, 0xdf, 0xb4, 0x0, 0x0, 0x1e, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x1, 0x26, 0xf4, 0x0, 0xb,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd,
    0x80, 0x6, 0xf2, 0x19, 0xde, 0xc6, 0x0, 0x3d,
    0x41, 0x16, 0xf5, 0x2, 0xf6, 0xb, 0xd4, 0x26,
    0xf7, 0x2, 0xbf, 0xff, 0xf8, 0x0, 0xcb, 0x0,
    0xf5, 0x0, 0xa, 0xc0, 0x0, 0x2, 0x20, 0x0,
    0x7f, 0x10, 0xd, 0xb1, 0x2, 0xe8, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0x50, 0x0, 0x3f, 0xff, 0xfe,
    0x10, 0x0, 0x0, 0x0, 0xc, 0xa0, 0x0, 0x1e,
    0xa3, 0x24, 0xdb, 0x0, 0x0, 0x0, 0x8, 0xe1,
    0x0, 0x5, 0xf1, 0x0, 0x5, 0xf0, 0x0, 0x0,
    0x3, 0xf5, 0x0, 0x0, 0x2f, 0x81, 0x2, 0xcd,
    0x0, 0x0, 0x0, 0xda, 0x0, 0x0, 0x0, 0x3b,
    0xef, 0xe9, 0x10,

    /* U+215D "⅝" */
    0x4, 0xff, 0xff, 0xf1, 0x0, 0x0, 0x1, 0xe8,
    0x0, 0x0, 0x0, 0x6e, 0x33, 0x33, 0x0, 0x0,
    0x0, 0xad, 0x0, 0x0, 0x0, 0x8, 0xb0, 0x0,
    0x0, 0x0, 0x0, 0x5f, 0x20, 0x0, 0x0, 0x0,
    0xaf, 0xff, 0xc6, 0x0, 0x0, 0x1e, 0x70, 0x0,
    0x0, 0x0, 0x1, 0x22, 0x38, 0xf5, 0x0, 0xb,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xd,
    0x90, 0x6, 0xf2, 0x19, 0xde, 0xc6, 0x0, 0x3d,
    0x41, 0x16, 0xf6, 0x2, 0xf6, 0xb, 0xd4, 0x26,
    0xf7, 0x2, 0xbf, 0xff, 0xf8, 0x0, 0xcb, 0x0,
    0xf5, 0x0, 0xa, 0xc0, 0x0, 0x2, 0x20, 0x0,
    0x7f, 0x10, 0xd, 0xb1, 0x2, 0xe8, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0x50, 0x0, 0x3f, 0xff, 0xfe,
    0x10, 0x0, 0x0, 0x0, 0xc, 0xa0, 0x0, 0x1e,
    0xa3, 0x24, 0xdb, 0x0, 0x0, 0x0, 0x8, 0xe1,
    0x0, 0x5, 0xf1, 0x0, 0x5, 0xf0, 0x0, 0x0,
    0x3, 0xf5, 0x0, 0x0, 0x2f, 0x81, 0x2, 0xcd,
    0x0, 0x0, 0x0, 0xda, 0x0, 0x0, 0x0, 0x3b,
    0xef, 0xe9, 0x10,

    /* U+215E "⅞" */
    0x4f, 0xff, 0xff, 0xff, 0x0, 0x0, 0x1, 0xe8,
    0x0, 0x0, 0x4, 0xf3, 0x33, 0x3e, 0xa0, 0x0,
    0x0, 0xad, 0x0, 0x0, 0x0, 0x26, 0x0, 0x7,
    0xf1, 0x0, 0x0, 0x5f, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x1, 0xe8, 0x0, 0x0, 0x1e, 0x70, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x8e, 0x10, 0x0, 0xb,
    0xc0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1f, 0x70,
    0x0, 0x6, 0xf2, 0x19, 0xde, 0xc6, 0x0, 0x0,
    0xa, 0xe0, 0x0, 0x2, 0xf6, 0xb, 0xd4, 0x26,
    0xf7, 0x0, 0x3, 0xf5, 0x0, 0x0, 0xcb, 0x0,
    0xf5, 0x0, 0xa, 0xc0, 0x0, 0x0, 0x0, 0x0,
    0x7f, 0x10, 0xd, 0xb1, 0x2, 0xe8, 0x0, 0x0,
    0x0, 0x0, 0x2f, 0x50, 0x0, 0x3f, 0xff, 0xfe,
    0x10, 0x0, 0x0, 0x0, 0xc, 0xa0, 0x0, 0x1e,
    0xa3, 0x24, 0xdb, 0x0, 0x0, 0x0, 0x8, 0xe1,
    0x0, 0x5, 0xf1, 0x0, 0x5, 0xf0, 0x0, 0x0,
    0x3, 0xf5, 0x0, 0x0, 0x2f, 0x81, 0x2, 0xcd,
    0x0, 0x0, 0x0, 0xda, 0x0, 0x0, 0x0, 0x3b,
    0xef, 0xe9, 0x10,

    /* U+2190 "←" */
    0x0, 0x4, 0x92, 0x0, 0x0, 0x0, 0x1e, 0xb0,
    0x0, 0x0, 0x0, 0xbf, 0x20, 0x0, 0x0, 0x6,
    0xfa, 0x33, 0x33, 0x32, 0xe, 0xff, 0xff, 0xff,
    0xfa, 0x6, 0xfa, 0x44, 0x44, 0x42, 0x0, 0xbf,
    0x10, 0x0, 0x0, 0x0, 0x2f, 0xb0, 0x0, 0x0,
    0x0, 0x5, 0xa2, 0x0, 0x0,

    /* U+2191 "↑" */
    0x0, 0x1, 0xa7, 0x0, 0x0, 0x5, 0xef, 0xfc,
    0x20, 0xa, 0xfb, 0xfc, 0xef, 0x73, 0xe6, 0xe,
    0xa0, 0x9e, 0x11, 0x0, 0xea, 0x0, 0x30, 0x0,
    0xe, 0xa0, 0x0, 0x0, 0x0, 0xea, 0x0, 0x0,
    0x0, 0xe, 0xa0, 0x0, 0x0, 0x0, 0xd9, 0x0,
    0x0,

    /* U+2192 "→" */
    0x0, 0x0, 0x29, 0x40, 0x0, 0x0, 0x0, 0xb,
    0xe1, 0x0, 0x0, 0x0, 0x2, 0xfb, 0x0, 0x23,
    0x33, 0x33, 0xaf, 0x60, 0xaf, 0xff, 0xff, 0xff,
    0xe0, 0x24, 0x44, 0x44, 0xaf, 0x60, 0x0, 0x0,
    0x1, 0xfb, 0x0, 0x0, 0x0, 0xb, 0xf1, 0x0,
    0x0, 0x0, 0x2a, 0x50, 0x0,

    /* U+2193 "↓" */
    0x0, 0x7, 0xd0, 0x0, 0x0, 0x0, 0x9f, 0x0,
    0x0, 0x0, 0x9, 0xf0, 0x0, 0x0, 0x0, 0x9f,
    0x0, 0x0, 0x20, 0x9, 0xf0, 0x0, 0x1d, 0x90,
    0x9f, 0x4, 0xe4, 0x7f, 0xdc, 0xfa, 0xfb, 0x10,
    0x2c, 0xff, 0xf6, 0x0, 0x0, 0x8, 0xc2, 0x0,
    0x0,

    /* U+2194 "↔" */
    0x0, 0x39, 0x30, 0x0, 0x69, 0x0, 0x0, 0x1e,
    0xc0, 0x0, 0x3, 0xf8, 0x0, 0xa, 0xf3, 0x0,
    0x0, 0x9, 0xf3, 0x4, 0xfa, 0x33, 0x33, 0x33,
    0x4f, 0xd0, 0xdf, 0xff, 0xff, 0xff, 0xff, 0xff,
    0x65, 0xfb, 0x44, 0x44, 0x44, 0x4f, 0xe0, 0xa,
    0xf2, 0x0, 0x0, 0x8, 0xf4, 0x0, 0x1e, 0xc0,
    0x0, 0x3, 0xf9, 0x0, 0x0, 0x4a, 0x30, 0x0,
    0x79, 0x0, 0x0,

    /* U+2195 "↕" */
    0x0, 0x1, 0xb8, 0x0, 0x0, 0x6, 0xff, 0xfd,
    0x30, 0xa, 0xfa, 0xfc, 0xdf, 0x73, 0xe5, 0xe,
    0xa0, 0x8e, 0x11, 0x0, 0xea, 0x0, 0x20, 0x0,
    0xe, 0xa0, 0x0, 0x0, 0x0, 0xea, 0x0, 0x0,
    0x0, 0xe, 0xa0, 0x0, 0x3c, 0x20, 0xea, 0x5,
    0xc1, 0xdf, 0x7e, 0xba, 0xfa, 0x0, 0x9f, 0xff,
    0xf6, 0x0, 0x0, 0x4e, 0xc2, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0,

    /* U+2196 "↖" */
    0x0, 0x3, 0x69, 0x30, 0xc, 0xff, 0xfd, 0x80,
    0x1f, 0xfa, 0x0, 0x0, 0x4f, 0xdf, 0x70, 0x0,
    0x7e, 0xc, 0xf7, 0x0, 0xab, 0x0, 0xcf, 0x70,
    0x67, 0x0, 0xc, 0xf6, 0x0, 0x0, 0x0, 0xc5,
    0x0, 0x0, 0x0, 0x0,

    /* U+2197 "↗" */
    0x0, 0x75, 0x20, 0x0, 0x0, 0x6e, 0xff, 0xfc,
    0x10, 0x0, 0x1, 0x7f, 0xf5, 0x0, 0x0, 0x2e,
    0xfe, 0x80, 0x0, 0x2e, 0xf3, 0xab, 0x0, 0x2e,
    0xf3, 0x7, 0xe0, 0x2e, 0xf3, 0x0, 0x4c, 0x3,
    0xe3, 0x0, 0x0, 0x10, 0x0, 0x0, 0x0, 0x0,
    0x0,

    /* U+2198 "↘" */
    0x2, 0x0, 0x0, 0x0, 0x4, 0xf6, 0x0, 0x0,
    0x20, 0x1c, 0xf6, 0x0, 0x4d, 0x0, 0x1d, 0xf6,
    0x7, 0xe0, 0x0, 0x1d, 0xf6, 0xab, 0x0, 0x0,
    0x1d, 0xff, 0x80, 0x0, 0x4, 0x9f, 0xf5, 0x0,
    0x6f, 0xff, 0xc9, 0x10, 0x0, 0x52, 0x0, 0x0,
    0x0,

    /* U+2199 "↙" */
    0x0, 0x0, 0x0, 0x30, 0x13, 0x0, 0x3, 0xf9,
    0xa9, 0x0, 0x3f, 0xe2, 0x9c, 0x3, 0xfe, 0x20,
    0x6f, 0x4f, 0xe2, 0x0, 0x3f, 0xfe, 0x20, 0x0,
    0xf, 0xfc, 0x73, 0x0, 0x6, 0x9d, 0xff, 0xa0,
    0x0, 0x0, 0x3, 0x0,

    /* U+2202 "∂" */
    0x1, 0x57, 0x86, 0x30, 0x0, 0x0, 0xa, 0xff,
    0xff, 0xfd, 0x50, 0x0, 0x4, 0x53, 0x24, 0x9f,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x3, 0xff, 0x20,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0x90, 0x0, 0x0,
    0x0, 0x0, 0xf, 0xe0, 0x0, 0x17, 0xab, 0x93,
    0xd, 0xf1, 0x5, 0xff, 0xfe, 0xff, 0x8b, 0xf2,
    0x2f, 0xf6, 0x0, 0x7, 0xff, 0xf3, 0x8f, 0x80,
    0x0, 0x0, 0x9f, 0xf1, 0xaf, 0x40, 0x0, 0x0,
    0x4f, 0xe0, 0x9f, 0x60, 0x0, 0x0, 0x6f, 0xa0,
    0x4f, 0xd1, 0x0, 0x2, 0xef, 0x20, 0xa, 0xfe,
    0x97, 0xaf, 0xf6, 0x0, 0x0, 0x6d, 0xff, 0xfb,
    0x30, 0x0, 0x0, 0x0, 0x11, 0x0, 0x0, 0x0,

    /* U+2205 "∅" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x20, 0x0, 0x3b,
    0xee, 0xa2, 0xa9, 0x0, 0x5f, 0xb6, 0x7d, 0xf9,
    0x0, 0x1f, 0x80, 0x0, 0xbe, 0xb0, 0x5, 0xf0,
    0x0, 0xc8, 0x4f, 0x10, 0x7e, 0x0, 0xc7, 0x2,
    0xf2, 0x5, 0xf2, 0xc6, 0x0, 0x5f, 0x0, 0xe,
    0xf6, 0x0, 0x1d, 0x90, 0x1, 0xdf, 0xd8, 0x9e,
    0xd1, 0x1, 0xd4, 0x29, 0xdc, 0x70, 0x0, 0x2,
    0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+2206 "∆" */
    0x0, 0x0, 0x0, 0xe, 0xf7, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x6f, 0xfe, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xdf, 0xaf, 0x50, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xf9, 0x2f, 0xd0, 0x0, 0x0,
    0x0, 0x0, 0xc, 0xf2, 0xb, 0xf4, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xb0, 0x3, 0xfb, 0x0, 0x0,
    0x0, 0x0, 0xaf, 0x40, 0x0, 0xcf, 0x20, 0x0,
    0x0, 0x2, 0xfd, 0x0, 0x0, 0x5f, 0xa0, 0x0,
    0x0, 0x9, 0xf6, 0x0, 0x0, 0xe, 0xf1, 0x0,
    0x0, 0x1f, 0xe0, 0x0, 0x0, 0x7, 0xf8, 0x0,
    0x0, 0x7f, 0x70, 0x0, 0x0, 0x1, 0xff, 0x0,
    0x0, 0xef, 0x10, 0x0, 0x0, 0x0, 0x9f, 0x70,
    0x6, 0xff, 0xbb, 0xbb, 0xbb, 0xbb, 0xdf, 0xe0,
    0xd, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf5,

    /* U+220F "∏" */
    0xef, 0xff, 0xff, 0xff, 0xff, 0xff, 0x1e, 0xfd,
    0xdd, 0xdd, 0xdd, 0xdf, 0xf1, 0xef, 0x10, 0x0,
    0x0, 0x0, 0xef, 0x1e, 0xf1, 0x0, 0x0, 0x0,
    0xe, 0xf1, 0xef, 0x10, 0x0, 0x0, 0x0, 0xef,
    0x1e, 0xf1, 0x0, 0x0, 0x0, 0xe, 0xf1, 0xef,
    0x10, 0x0, 0x0, 0x0, 0xef, 0x1e, 0xf1, 0x0,
    0x0, 0x0, 0xe, 0xf1, 0xef, 0x10, 0x0, 0x0,
    0x0, 0xef, 0x1e, 0xf1, 0x0, 0x0, 0x0, 0xe,
    0xf1, 0xef, 0x10, 0x0, 0x0, 0x0, 0xef, 0x1e,
    0xf1, 0x0, 0x0, 0x0, 0xe, 0xf1, 0xef, 0x10,
    0x0, 0x0, 0x0, 0xef, 0x1e, 0xf1, 0x0, 0x0,
    0x0, 0xe, 0xf1, 0xef, 0x10, 0x0, 0x0, 0x0,
    0xef, 0x1e, 0xf1, 0x0, 0x0, 0x0, 0xe, 0xf1,
    0xef, 0x10, 0x0, 0x0, 0x0, 0xef, 0x1c, 0xe1,
    0x0, 0x0, 0x0, 0xc, 0xe1,

    /* U+2211 "∑" */
    0xd, 0xff, 0xff, 0xff, 0xff, 0xff, 0x70, 0xaf,
    0xfb, 0xbb, 0xbb, 0xbb, 0xb5, 0x0, 0xcf, 0x80,
    0x0, 0x0, 0x0, 0x0, 0x1, 0xef, 0x60, 0x0,
    0x0, 0x0, 0x0, 0x3, 0xff, 0x40, 0x0, 0x0,
    0x0, 0x0, 0x5, 0xfe, 0x20, 0x0, 0x0, 0x0,
    0x0, 0x7, 0xfd, 0x10, 0x0, 0x0, 0x0, 0x0,
    0xa, 0xfc, 0x0, 0x0, 0x0, 0x0, 0x0, 0xc,
    0xf6, 0x0, 0x0, 0x0, 0x0, 0x1, 0xef, 0x40,
    0x0, 0x0, 0x0, 0x1, 0xdf, 0x80, 0x0, 0x0,
    0x0, 0x0, 0xcf, 0xa0, 0x0, 0x0, 0x0, 0x0,
    0xaf, 0xb0, 0x0, 0x0, 0x0, 0x0, 0x8f, 0xd0,
    0x0, 0x0, 0x0, 0x0, 0x6f, 0xe1, 0x0, 0x0,
    0x0, 0x0, 0x4f, 0xe2, 0x0, 0x0, 0x0, 0x0,
    0xf, 0xff, 0xff, 0xff, 0xff, 0xff, 0x90, 0xcc,
    0xcc, 0xcc, 0xcc, 0xcc, 0xc7,

    /* U+2212 "−" */
    0x8a, 0xaa, 0xaa, 0xaa, 0xa0, 0xdf, 0xff, 0xff,
    0xff, 0xf1,

    /* U+2215 "∕" */
    0x0, 0x0, 0x0, 0x1d, 0x80, 0x0, 0x0, 0x7,
    0xf4, 0x0, 0x0, 0x0, 0xce, 0x0, 0x0, 0x0,
    0x2f, 0x90, 0x0, 0x0, 0x8, 0xf3, 0x0, 0x0,
    0x0, 0xde, 0x0, 0x0, 0x0, 0x3f, 0x80, 0x0,
    0x0, 0x8, 0xf3, 0x0, 0x0, 0x0, 0xed, 0x0,
    0x0, 0x0, 0x4f, 0x70, 0x0, 0x0, 0x9, 0xf2,
    0x0, 0x0, 0x0, 0xec, 0x0, 0x0, 0x0, 0x4f,
    0x60, 0x0, 0x0, 0xa, 0xf1, 0x0, 0x0, 0x0,
    0xfb, 0x0, 0x0, 0x0, 0x5f, 0x60, 0x0, 0x0,
    0xb, 0xf0, 0x0, 0x0, 0x1, 0xfa, 0x0, 0x0,
    0x0, 0x6f, 0x50, 0x0, 0x0, 0x0,

    /* U+2219 "∙" */
    0x7, 0x50, 0x6f, 0xf1, 0x4f, 0xe0, 0x1, 0x0,

    /* U+221A "√" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xe0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x4f, 0x90,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x9f, 0x30,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0xed, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x4, 0xf8, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x9, 0xf3, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0xe, 0xd0, 0x0,
    0xaf, 0xff, 0x80, 0x0, 0x0, 0x4f, 0x80, 0x0,
    0x6a, 0xaf, 0xe0, 0x0, 0x0, 0xaf, 0x20, 0x0,
    0x0, 0xb, 0xf4, 0x0, 0x0, 0xfd, 0x0, 0x0,
    0x0, 0x5, 0xf9, 0x0, 0x5, 0xf7, 0x0, 0x0,
    0x0, 0x0, 0xff, 0x0, 0xa, 0xf2, 0x0, 0x0,
    0x0, 0x0, 0x9f, 0x50, 0xf, 0xc0, 0x0, 0x0,
    0x0, 0x0, 0x3f, 0xb0, 0x5f, 0x70, 0x0, 0x0,
    0x0, 0x0, 0xd, 0xf1, 0xbf, 0x10, 0x0, 0x0,
    0x0, 0x0, 0x8, 0xf7, 0xfc, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x2, 0xff, 0xf6, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0xcf, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x5b, 0x80, 0x0, 0x0, 0x0,

    /* U+221E "∞" */
    0x0, 0x3b, 0xee, 0xa2, 0x0, 0x6, 0xce, 0xd7,
    0x0, 0x4, 0xfe, 0xaa, 0xef, 0x40, 0xbf, 0xb9,
    0xcf, 0xb0, 0xd, 0xe2, 0x0, 0x1b, 0xfb, 0xf4,
    0x0, 0x8, 0xf5, 0x1f, 0x70, 0x0, 0x0, 0xdf,
    0x60, 0x0, 0x0, 0xf9, 0x1f, 0x70, 0x0, 0x0,
    0xdf, 0x60, 0x0, 0x0, 0xf8, 0xd, 0xe1, 0x0,
    0xb, 0xfb, 0xf4, 0x0, 0x8, 0xf4, 0x4, 0xfe,
    0x99, 0xef, 0x40, 0xbf, 0xb9, 0xcf, 0xb0, 0x0,
    0x3b, 0xee, 0xa2, 0x0, 0x7, 0xce, 0xd7, 0x0,

    /* U+222B "∫" */
    0x0, 0x0, 0x7, 0xdf, 0xd5, 0x0, 0x0, 0x7f,
    0xea, 0xd5, 0x0, 0x0, 0xdf, 0x20, 0x0, 0x0,
    0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0,
    0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0, 0x0,
    0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0xff,
    0x0, 0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0,
    0x0, 0xff, 0x0, 0x0, 0x0, 0x0, 0xff, 0x0,
    0x0, 0x0, 0x0, 0xff, 0x0, 0x0, 0x0, 0x0,
    0xff, 0x0, 0x0, 0x0, 0x0, 0xfe, 0x0, 0x0,
    0x0, 0x3, 0xfc, 0x0, 0x0, 0x5c, 0xae, 0xf6,
    0x0, 0x0, 0x5d, 0xfd, 0x70, 0x0, 0x0,

    /* U+2248 "≈" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xa, 0xfe, 0x70,
    0x0, 0xc6, 0x7f, 0x89, 0xfb, 0x26, 0xf3, 0xb9,
    0x0, 0x5e, 0xff, 0xa0, 0x21, 0x0, 0x1, 0x53,
    0x0, 0x0, 0x43, 0x0, 0x0, 0x21, 0x1e, 0xff,
    0xb1, 0x0, 0xe5, 0x9e, 0x34, 0xee, 0x7a, 0xf2,
    0xb7, 0x0, 0x1b, 0xfe, 0x60, 0x0, 0x0, 0x0,
    0x0, 0x0,

    /* U+2260 "≠" */
    0x0, 0x0, 0x0, 0x27, 0x20, 0x0, 0x0, 0x0,
    0xbe, 0x0, 0x0, 0x0, 0x4, 0xf6, 0x0, 0xef,
    0xff, 0xff, 0xff, 0xf1, 0x78, 0x88, 0xcf, 0x98,
    0x80, 0x0, 0x0, 0xdb, 0x0, 0x0, 0x0, 0x7,
    0xf2, 0x0, 0x0, 0x78, 0x8f, 0xd8, 0x88, 0x80,
    0xef, 0xff, 0xff, 0xff, 0xf1, 0x3, 0xf7, 0x0,
    0x0, 0x0, 0xb, 0xe0, 0x0, 0x0, 0x0, 0x6,
    0x30, 0x0, 0x0, 0x0,

    /* U+2264 "≤" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
    0x17, 0xd1, 0x0, 0x0, 0x5b, 0xff, 0xc0, 0x2,
    0x8e, 0xfe, 0x82, 0x0, 0xbf, 0xfb, 0x50, 0x0,
    0x0, 0xef, 0xc5, 0x0, 0x0, 0x0, 0x28, 0xef,
    0xe9, 0x30, 0x0, 0x0, 0x4, 0xaf, 0xfd, 0x60,
    0x0, 0x0, 0x1, 0x7d, 0xf1, 0x0, 0x0, 0x0,
    0x0, 0x30, 0x0, 0x0, 0x0, 0x0, 0x0, 0x89,
    0x99, 0x99, 0x99, 0x90, 0xef, 0xff, 0xff, 0xff,
    0xf1,

    /* U+2265 "≥" */
    0x0, 0x0, 0x0, 0x0, 0x0, 0xc8, 0x20, 0x0,
    0x0, 0x0, 0xaf, 0xfc, 0x60, 0x0, 0x0, 0x1,
    0x7d, 0xff, 0xa4, 0x0, 0x0, 0x0, 0x39, 0xff,
    0xd0, 0x0, 0x0, 0x3, 0xaf, 0xf1, 0x0, 0x17,
    0xdf, 0xf9, 0x30, 0x5b, 0xff, 0xc6, 0x0, 0x0,
    0xee, 0x82, 0x0, 0x0, 0x0, 0x30, 0x0, 0x0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x89,
    0x99, 0x99, 0x99, 0x90, 0xef, 0xff, 0xff, 0xff,
    0xf1,

    /* U+25A0 "■" */
    0x0, 0x0, 0x0, 0x0, 0xef, 0xff, 0xff, 0xfd,
    0xef, 0xff, 0xff, 0xfd, 0xef, 0xff, 0xff, 0xfd,
    0xef, 0xff, 0xff, 0xfd, 0xef, 0xff, 0xff, 0xfd,
    0xef, 0xff, 0xff, 0xfd, 0xef, 0xff, 0xff, 0xfd,
    0xab, 0xbb, 0xbb, 0xb9,

    /* U+25A1 "□" */
    0x23, 0x33, 0x33, 0x32, 0xef, 0xff, 0xff, 0xfe,
    0xe2, 0x0, 0x0, 0x2e, 0xe2, 0x0, 0x0, 0x2e,
    0xe2, 0x0, 0x0, 0x2e, 0xe2, 0x0, 0x0, 0x2e,
    0xe2, 0x0, 0x0, 0x2e, 0xe7, 0x55, 0x55, 0x7e,
    0xbc, 0xcc, 0xcc, 0xcb,

    /* U+25B2 "▲" */
    0x0, 0x0, 0x11, 0x0, 0x0, 0x0, 0x0, 0x88,
    0x0, 0x0, 0x0, 0x1, 0xff, 0x10, 0x0, 0x0,
    0x8, 0xff, 0x80, 0x0, 0x0, 0x1f, 0xff, 0xf1,
    0x0, 0x0, 0x8f, 0xff, 0xf8, 0x0, 0x1, 0xff,
    0xff, 0xff, 0x10, 0x8, 0xff, 0xff, 0xff, 0x80,
    0x1e, 0xff, 0xff, 0xff, 0xe1,

    /* U+25B3 "△" */
    0x0, 0x0, 0x11, 0x0, 0x0, 0x0, 0x0, 0x88,
    0x0, 0x0, 0x0, 0x1, 0xee, 0x10, 0x0, 0x0,
    0x8, 0x88, 0x80, 0x0, 0x0, 0x1e, 0x11, 0xe1,
    0x0, 0x0, 0x87, 0x0, 0x78, 0x0, 0x1, 0xe0,
    0x0, 0xe, 0x10, 0x8, 0x70, 0x0, 0x7, 0x80,
    0x1e, 0xff, 0xff, 0xff, 0xe1,

    /* U+25B6 "▶" */
    0x40, 0x0, 0x0, 0x0, 0xb, 0xe7, 0x0, 0x0,
    0x0, 0xbf, 0xfe, 0x70, 0x0, 0xb, 0xff, 0xff,
    0xe7, 0x0, 0xbf, 0xff, 0xff, 0xfe, 0x5b, 0xff,
    0xff, 0xfd, 0x50, 0xbf, 0xff, 0xd5, 0x0, 0xb,
    0xfd, 0x50, 0x0, 0x0, 0x85, 0x0, 0x0, 0x0,
    0x0,

    /* U+25B7 "▷" */
    0x50, 0x0, 0x0, 0x0, 0xe, 0xd5, 0x0, 0x0,
    0x0, 0xe3, 0xbd, 0x50, 0x0, 0xe, 0x0, 0x2a,
    0xd5, 0x0, 0xe0, 0x0, 0x2, 0xdd, 0x2e, 0x0,
    0x4, 0xcb, 0x30, 0xe0, 0x5c, 0xb3, 0x0, 0xe,
    0xdb, 0x30, 0x0, 0x0, 0xa3, 0x0, 0x0, 0x0,
    0x0,

    /* U+25BC "▼" */
    0x18, 0x99, 0x99, 0x99, 0x81, 0xb, 0xff, 0xff,
    0xff, 0xb0, 0x3, 0xff, 0xff, 0xff, 0x30, 0x0,
    0xbf, 0xff, 0xfb, 0x0, 0x0, 0x3f, 0xff, 0xf3,
    0x0, 0x0, 0xb, 0xff, 0xb0, 0x0, 0x0, 0x3,
    0xff, 0x30, 0x0, 0x0, 0x0, 0xbb, 0x0, 0x0,
    0x0, 0x0, 0x33, 0x0, 0x0,

    /* U+25BD "▽" */
    0x1c, 0xcc, 0xcc, 0xcc, 0xc1, 0xa, 0x83, 0x33,
    0x38, 0x90, 0x2, 0xd0, 0x0, 0xd, 0x20, 0x0,
    0xa6, 0x0, 0x69, 0x0, 0x0, 0x2d, 0x0, 0xd2,
    0x0, 0x0, 0x9, 0x66, 0x90, 0x0, 0x0, 0x2,
    0xee, 0x20, 0x0, 0x0, 0x0, 0x99, 0x0, 0x0,
    0x0, 0x0, 0x22, 0x0, 0x0,

    /* U+25C0 "◀" */
    0x0, 0x0, 0x0, 0x0, 0x40, 0x0, 0x0, 0x7,
    0xeb, 0x0, 0x0, 0x7e, 0xff, 0xb0, 0x7, 0xef,
    0xff, 0xfb, 0x5e, 0xff, 0xff, 0xff, 0xb0, 0x6d,
    0xff, 0xff, 0xfb, 0x0, 0x5, 0xdf, 0xff, 0xb0,
    0x0, 0x0, 0x5d, 0xfb, 0x0, 0x0, 0x0, 0x5,
    0x80,

    /* U+25C1 "◁" */
    0x0, 0x0, 0x0, 0x0, 0x40, 0x0, 0x0, 0x5,
    0xde, 0x0, 0x0, 0x5d, 0xb3, 0xe0, 0x5, 0xdb,
    0x30, 0xe, 0x3d, 0xd2, 0x0, 0x0, 0xe0, 0x4c,
    0xc4, 0x0, 0xe, 0x0, 0x4, 0xcc, 0x40, 0xe0,
    0x0, 0x0, 0x4c, 0xde, 0x0, 0x0, 0x0, 0x4,
    0xa0,

    /* U+25C6 "◆" */
    0x0, 0x0, 0x5, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xf5, 0x0, 0x0, 0x0, 0x5, 0xff, 0xff,
    0x40, 0x0, 0x0, 0x5f, 0xff, 0xff, 0xf4, 0x0,
    0x5, 0xff, 0xff, 0xff, 0xff, 0x40, 0x3f, 0xff,
    0xff, 0xff, 0xff, 0xf3, 0xa, 0xff, 0xff, 0xff,
    0xff, 0xa0, 0x0, 0xaf, 0xff, 0xff, 0xfa, 0x0,
    0x0, 0xa, 0xff, 0xff, 0xa0, 0x0, 0x0, 0x0,
    0xaf, 0xfa, 0x0, 0x0, 0x0, 0x0, 0xa, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+25C7 "◇" */
    0x0, 0x0, 0x5, 0x50, 0x0, 0x0, 0x0, 0x0,
    0x5f, 0xf5, 0x0, 0x0, 0x0, 0x5, 0xf5, 0x5f,
    0x40, 0x0, 0x0, 0x5f, 0x50, 0x5, 0xf4, 0x0,
    0x5, 0xf4, 0x0, 0x0, 0x4f, 0x40, 0x3f, 0x50,
    0x0, 0x0, 0x5, 0xf3, 0xa, 0xc0, 0x0, 0x0,
    0x1c, 0xa0, 0x0, 0xac, 0x10, 0x1, 0xca, 0x0,
    0x0, 0xa, 0xd1, 0x1d, 0xa0, 0x0, 0x0, 0x0,
    0xad, 0xda, 0x0, 0x0, 0x0, 0x0, 0xa, 0xa0,
    0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,

    /* U+25CA "◊" */
    0x0, 0x0, 0x33, 0x0, 0x0, 0x0, 0x0, 0xdd,
    0x0, 0x0, 0x0, 0x8, 0xdd, 0x80, 0x0, 0x0,
    0x3f, 0x33, 0xf3, 0x0, 0x0, 0xd8, 0x0, 0x8d,
    0x0, 0x8, 0xc0, 0x0, 0xc, 0x80, 0xf, 0x60,
    0x0, 0x6, 0xf0, 0x7, 0xe0, 0x0, 0x1e, 0x60,
    0x0, 0xca, 0x0, 0xab, 0x0, 0x0, 0x2f, 0x45,
    0xf2, 0x0, 0x0, 0x7, 0xee, 0x60, 0x0, 0x0,
    0x0, 0xcc, 0x0, 0x0, 0x0, 0x0, 0x22, 0x0,
    0x0,

    /* U+27E8 "⟨" */
    0x0, 0x1, 0xc7, 0x0, 0x7, 0xf4, 0x0, 0xc,
    0xe0, 0x0, 0x2f, 0xa0, 0x0, 0x8f, 0x40, 0x0,
    0xde, 0x0, 0x3, 0xfa, 0x0, 0x8, 0xf4, 0x0,
    0xe, 0xe0, 0x0, 0x3f, 0xa0, 0x0, 0xf, 0xe0,
    0x0, 0x9, 0xf3, 0x0, 0x4, 0xf9, 0x0, 0x0,
    0xee, 0x0, 0x0, 0x9f, 0x30, 0x0, 0x3f, 0x90,
    0x0, 0xd, 0xe0, 0x0, 0x8, 0xf3, 0x0, 0x2,
    0xf8,

    /* U+27E9 "⟩" */
    0xb, 0x80, 0x0, 0xb, 0xf0, 0x0, 0x6, 0xf6,
    0x0, 0x1, 0xfb, 0x0, 0x0, 0xbf, 0x10, 0x0,
    0x6f, 0x60, 0x0, 0x1f, 0xc0, 0x0, 0xb, 0xf2,
    0x0, 0x6, 0xf7, 0x0, 0x1, 0xfc, 0x0, 0x5,
    0xf8, 0x0, 0xa, 0xf3, 0x0, 0xf, 0xd0, 0x0,
    0x5f, 0x70, 0x0, 0xaf, 0x20, 0x0, 0xfc, 0x0,
    0x5, 0xf7, 0x0, 0xa, 0xf1, 0x0, 0xe, 0xb0,
    0x0,

    /* U+A78B "Ꞌ" */
    0x6f, 0x86, 0xf8, 0x6f, 0x76, 0xf7, 0x6f, 0x66,
    0xf6, 0x6f, 0x56, 0xf5, 0x14, 0x10,

    /* U+A78C "ꞌ" */
    0x27, 0x36, 0xf7, 0x6f, 0x76, 0xf6, 0x6f, 0x66,
    0xf5, 0x6f, 0x56, 0xf4,

    /* U+FB01 "ﬁ" */
    0x0, 0x7, 0xdf, 0xd5, 0x3e, 0xc0, 0x0, 0x7f,
    0xea, 0xd6, 0x6f, 0xf0, 0x0, 0xdf, 0x20, 0x0,
    0x4, 0x30, 0x0, 0xef, 0x0, 0x0, 0x0, 0x0,
    0xbf, 0xff, 0xff, 0xf1, 0x2f, 0xc0, 0x7a, 0xff,
    0xaa, 0xa0, 0x2f, 0xc0, 0x0, 0xef, 0x0, 0x0,
    0x2f, 0xc0, 0x0, 0xef, 0x0, 0x0, 0x2f, 0xc0,
    0x0, 0xef, 0x0, 0x0, 0x2f, 0xc0, 0x0, 0xef,
    0x0, 0x0, 0x2f, 0xc0, 0x0, 0xef, 0x0, 0x0,
    0x2f, 0xc0, 0x0, 0xef, 0x0, 0x0, 0x2f, 0xc0,
    0x0, 0xef, 0x0, 0x0, 0x2f, 0xc0, 0x0, 0xef,
    0x0, 0x0, 0x2f, 0xc0, 0x0, 0xef, 0x0, 0x0,
    0x2f, 0xc0,

    /* U+FB02 "ﬂ" */
    0x0, 0x7, 0xdf, 0xd5, 0x2f, 0xc0, 0x7, 0xfe,
    0xac, 0x62, 0xfc, 0x0, 0xdf, 0x20, 0x0, 0x2f,
    0xc0, 0xe, 0xf0, 0x0, 0x2, 0xfc, 0xbf, 0xff,
    0xff, 0xf1, 0x2f, 0xc7, 0xaf, 0xfa, 0xaa, 0x2,
    0xfc, 0x0, 0xef, 0x0, 0x0, 0x2f, 0xc0, 0xe,
    0xf0, 0x0, 0x2, 0xfc, 0x0, 0xef, 0x0, 0x0,
    0x2f, 0xc0, 0xe, 0xf0, 0x0, 0x2, 0xfc, 0x0,
    0xef, 0x0, 0x0, 0x2f, 0xc0, 0xe, 0xf0, 0x0,
    0x2, 0xfc, 0x0, 0xef, 0x0, 0x0, 0x2f, 0xc0,
    0xe, 0xf0, 0x0, 0x2, 0xfc, 0x0, 0xef, 0x0,
    0x0, 0x2f, 0xc0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 86, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 86, .box_w = 3, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21, .adv_w = 125, .box_w = 6, .box_h = 6, .ofs_x = 1, .ofs_y = 8},
    {.bitmap_index = 39, .adv_w = 225, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 137, .adv_w = 199, .box_w = 12, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 257, .adv_w = 270, .box_w = 17, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 376, .adv_w = 220, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 481, .adv_w = 67, .box_w = 2, .box_h = 6, .ofs_x = 1, .ofs_y = 8},
    {.bitmap_index = 487, .adv_w = 108, .box_w = 6, .box_h = 19, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 544, .adv_w = 108, .box_w = 5, .box_h = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 592, .adv_w = 128, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 624, .adv_w = 186, .box_w = 10, .box_h = 10, .ofs_x = 1, .ofs_y = 3},
    {.bitmap_index = 674, .adv_w = 73, .box_w = 4, .box_h = 6, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 686, .adv_w = 123, .box_w = 6, .box_h = 2, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 692, .adv_w = 73, .box_w = 4, .box_h = 3, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 698, .adv_w = 113, .box_w = 9, .box_h = 20, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 788, .adv_w = 213, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 879, .adv_w = 118, .box_w = 6, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 921, .adv_w = 184, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 998, .adv_w = 183, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1075, .adv_w = 214, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1173, .adv_w = 184, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1250, .adv_w = 197, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1334, .adv_w = 191, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1418, .adv_w = 206, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1502, .adv_w = 197, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1586, .adv_w = 73, .box_w = 4, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1608, .adv_w = 73, .box_w = 4, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1636, .adv_w = 186, .box_w = 10, .box_h = 10, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 1686, .adv_w = 186, .box_w = 10, .box_h = 7, .ofs_x = 1, .ofs_y = 4},
    {.bitmap_index = 1721, .adv_w = 186, .box_w = 10, .box_h = 10, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 1771, .adv_w = 183, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1848, .adv_w = 331, .box_w = 20, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 2028, .adv_w = 234, .box_w = 16, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2140, .adv_w = 242, .box_w = 13, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2231, .adv_w = 231, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2329, .adv_w = 264, .box_w = 14, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2427, .adv_w = 214, .box_w = 11, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2504, .adv_w = 203, .box_w = 10, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2574, .adv_w = 247, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2672, .adv_w = 260, .box_w = 13, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2763, .adv_w = 99, .box_w = 3, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2784, .adv_w = 164, .box_w = 10, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2854, .adv_w = 230, .box_w = 13, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 2945, .adv_w = 190, .box_w = 10, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3015, .adv_w = 306, .box_w = 15, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3120, .adv_w = 260, .box_w = 13, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3211, .adv_w = 269, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3323, .adv_w = 231, .box_w = 12, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3407, .adv_w = 269, .box_w = 17, .box_h = 17, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 3552, .adv_w = 233, .box_w = 12, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 3636, .adv_w = 199, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3720, .adv_w = 188, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3804, .adv_w = 253, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3895, .adv_w = 228, .box_w = 16, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4007, .adv_w = 360, .box_w = 22, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4161, .adv_w = 215, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4259, .adv_w = 207, .box_w = 15, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 4364, .adv_w = 210, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4455, .adv_w = 107, .box_w = 5, .box_h = 19, .ofs_x = 2, .ofs_y = -4},
    {.bitmap_index = 4503, .adv_w = 113, .box_w = 9, .box_h = 20, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 4593, .adv_w = 107, .box_w = 5, .box_h = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 4641, .adv_w = 187, .box_w = 10, .box_h = 9, .ofs_x = 1, .ofs_y = 3},
    {.bitmap_index = 4686, .adv_w = 160, .box_w = 10, .box_h = 3, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 4701, .adv_w = 192, .box_w = 6, .box_h = 3, .ofs_x = 2, .ofs_y = 12},
    {.bitmap_index = 4710, .adv_w = 219, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4771, .adv_w = 218, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4861, .adv_w = 183, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4922, .adv_w = 218, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5012, .adv_w = 196, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5078, .adv_w = 113, .box_w = 8, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5138, .adv_w = 221, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 5228, .adv_w = 218, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5311, .adv_w = 89, .box_w = 4, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5341, .adv_w = 91, .box_w = 7, .box_h = 19, .ofs_x = -2, .ofs_y = -4},
    {.bitmap_index = 5408, .adv_w = 197, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5498, .adv_w = 89, .box_w = 3, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5521, .adv_w = 338, .box_w = 19, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5626, .adv_w = 218, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5687, .adv_w = 203, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5753, .adv_w = 218, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 5843, .adv_w = 218, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 5933, .adv_w = 131, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 5972, .adv_w = 160, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6027, .adv_w = 132, .box_w = 8, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6083, .adv_w = 217, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6144, .adv_w = 179, .box_w = 13, .box_h = 11, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 6216, .adv_w = 288, .box_w = 18, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6315, .adv_w = 177, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6376, .adv_w = 179, .box_w = 13, .box_h = 15, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 6474, .adv_w = 167, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6529, .adv_w = 112, .box_w = 6, .box_h = 19, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 6586, .adv_w = 96, .box_w = 2, .box_h = 19, .ofs_x = 2, .ofs_y = -4},
    {.bitmap_index = 6605, .adv_w = 112, .box_w = 6, .box_h = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 6662, .adv_w = 186, .box_w = 10, .box_h = 4, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 6682, .adv_w = 86, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6682, .adv_w = 86, .box_w = 3, .box_h = 14, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 6703, .adv_w = 183, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 6791, .adv_w = 207, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6882, .adv_w = 224, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 6987, .adv_w = 226, .box_w = 16, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 7099, .adv_w = 96, .box_w = 2, .box_h = 19, .ofs_x = 2, .ofs_y = -4},
    {.bitmap_index = 7118, .adv_w = 160, .box_w = 10, .box_h = 17, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7203, .adv_w = 192, .box_w = 6, .box_h = 3, .ofs_x = 3, .ofs_y = 13},
    {.bitmap_index = 7212, .adv_w = 257, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7332, .adv_w = 129, .box_w = 7, .box_h = 6, .ofs_x = 0, .ofs_y = 9},
    {.bitmap_index = 7353, .adv_w = 161, .box_w = 10, .box_h = 8, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 7393, .adv_w = 186, .box_w = 10, .box_h = 6, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 7423, .adv_w = 123, .box_w = 6, .box_h = 2, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 7429, .adv_w = 257, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7549, .adv_w = 192, .box_w = 8, .box_h = 3, .ofs_x = 2, .ofs_y = 12},
    {.bitmap_index = 7561, .adv_w = 134, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 7593, .adv_w = 186, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 7658, .adv_w = 138, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 7690, .adv_w = 138, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 7722, .adv_w = 192, .box_w = 4, .box_h = 3, .ofs_x = 4, .ofs_y = 12},
    {.bitmap_index = 7728, .adv_w = 218, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 7811, .adv_w = 207, .box_w = 11, .box_h = 18, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 7910, .adv_w = 85, .box_w = 3, .box_h = 3, .ofs_x = 1, .ofs_y = 4},
    {.bitmap_index = 7915, .adv_w = 192, .box_w = 5, .box_h = 6, .ofs_x = 3, .ofs_y = -5},
    {.bitmap_index = 7930, .adv_w = 138, .box_w = 7, .box_h = 8, .ofs_x = 1, .ofs_y = 7},
    {.bitmap_index = 7958, .adv_w = 134, .box_w = 8, .box_h = 7, .ofs_x = 0, .ofs_y = 8},
    {.bitmap_index = 7986, .adv_w = 161, .box_w = 10, .box_h = 8, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 8026, .adv_w = 331, .box_w = 20, .box_h = 15, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8176, .adv_w = 331, .box_w = 19, .box_h = 15, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 8319, .adv_w = 331, .box_w = 21, .box_h = 15, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 8477, .adv_w = 183, .box_w = 11, .box_h = 14, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 8554, .adv_w = 234, .box_w = 16, .box_h = 18, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 8698, .adv_w = 234, .box_w = 16, .box_h = 18, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 8842, .adv_w = 234, .box_w = 16, .box_h = 18, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 8986, .adv_w = 234, .box_w = 16, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 9138, .adv_w = 234, .box_w = 16, .box_h = 18, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 9282, .adv_w = 234, .box_w = 16, .box_h = 20, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 9442, .adv_w = 335, .box_w = 21, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 9589, .adv_w = 231, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 9722, .adv_w = 214, .box_w = 11, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 9821, .adv_w = 214, .box_w = 11, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 9920, .adv_w = 214, .box_w = 11, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 10019, .adv_w = 214, .box_w = 11, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 10118, .adv_w = 99, .box_w = 6, .box_h = 18, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 10172, .adv_w = 99, .box_w = 4, .box_h = 18, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 10208, .adv_w = 99, .box_w = 8, .box_h = 18, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 10280, .adv_w = 99, .box_w = 6, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10334, .adv_w = 267, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10446, .adv_w = 260, .box_w = 13, .box_h = 19, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 10570, .adv_w = 269, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10722, .adv_w = 269, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 10874, .adv_w = 269, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11026, .adv_w = 269, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11178, .adv_w = 269, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 11330, .adv_w = 186, .box_w = 8, .box_h = 9, .ofs_x = 2, .ofs_y = 3},
    {.bitmap_index = 11366, .adv_w = 269, .box_w = 16, .box_h = 18, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 11510, .adv_w = 253, .box_w = 13, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11634, .adv_w = 253, .box_w = 13, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11758, .adv_w = 253, .box_w = 13, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 11882, .adv_w = 253, .box_w = 13, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12006, .adv_w = 207, .box_w = 14, .box_h = 18, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 12132, .adv_w = 231, .box_w = 12, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 12216, .adv_w = 216, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12306, .adv_w = 191, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12396, .adv_w = 191, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12486, .adv_w = 191, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12576, .adv_w = 191, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12666, .adv_w = 191, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12756, .adv_w = 191, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 12858, .adv_w = 316, .box_w = 18, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 12957, .adv_w = 183, .box_w = 11, .box_h = 16, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 13045, .adv_w = 196, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13135, .adv_w = 196, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13225, .adv_w = 196, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13315, .adv_w = 196, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13405, .adv_w = 89, .box_w = 6, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 13450, .adv_w = 89, .box_w = 4, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13480, .adv_w = 89, .box_w = 7, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 13533, .adv_w = 89, .box_w = 6, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13578, .adv_w = 205, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13668, .adv_w = 218, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 13751, .adv_w = 203, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13841, .adv_w = 203, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 13931, .adv_w = 203, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14021, .adv_w = 203, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14111, .adv_w = 203, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 14201, .adv_w = 186, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 14256, .adv_w = 203, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 14346, .adv_w = 217, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14429, .adv_w = 217, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14512, .adv_w = 217, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14595, .adv_w = 217, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 14678, .adv_w = 179, .box_w = 13, .box_h = 19, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 14802, .adv_w = 218, .box_w = 12, .box_h = 19, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 14916, .adv_w = 179, .box_w = 13, .box_h = 19, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 15040, .adv_w = 234, .box_w = 16, .box_h = 18, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 15184, .adv_w = 191, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15268, .adv_w = 234, .box_w = 16, .box_h = 18, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 15412, .adv_w = 191, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15502, .adv_w = 234, .box_w = 17, .box_h = 19, .ofs_x = -1, .ofs_y = -5},
    {.bitmap_index = 15664, .adv_w = 191, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 15760, .adv_w = 231, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15893, .adv_w = 183, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 15976, .adv_w = 231, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16109, .adv_w = 183, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16192, .adv_w = 231, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16325, .adv_w = 183, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16408, .adv_w = 231, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16541, .adv_w = 183, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16624, .adv_w = 264, .box_w = 14, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 16750, .adv_w = 218, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16878, .adv_w = 267, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 16990, .adv_w = 218, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17095, .adv_w = 214, .box_w = 11, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 17194, .adv_w = 196, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17278, .adv_w = 214, .box_w = 11, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 17377, .adv_w = 196, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17467, .adv_w = 214, .box_w = 11, .box_h = 19, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 17572, .adv_w = 196, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 17662, .adv_w = 214, .box_w = 11, .box_h = 19, .ofs_x = 2, .ofs_y = -5},
    {.bitmap_index = 17767, .adv_w = 196, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 17863, .adv_w = 214, .box_w = 11, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 17962, .adv_w = 196, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18052, .adv_w = 247, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18185, .adv_w = 221, .box_w = 12, .box_h = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 18299, .adv_w = 247, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18432, .adv_w = 221, .box_w = 12, .box_h = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 18546, .adv_w = 247, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 18679, .adv_w = 221, .box_w = 12, .box_h = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 18793, .adv_w = 247, .box_w = 14, .box_h = 20, .ofs_x = 0, .ofs_y = -6},
    {.bitmap_index = 18933, .adv_w = 221, .box_w = 12, .box_h = 20, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 19053, .adv_w = 260, .box_w = 13, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 19170, .adv_w = 218, .box_w = 13, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 19294, .adv_w = 265, .box_w = 17, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19413, .adv_w = 218, .box_w = 13, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 19511, .adv_w = 99, .box_w = 8, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 19587, .adv_w = 89, .box_w = 7, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 19640, .adv_w = 99, .box_w = 6, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19694, .adv_w = 89, .box_w = 6, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19736, .adv_w = 99, .box_w = 8, .box_h = 18, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 19808, .adv_w = 89, .box_w = 6, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 19853, .adv_w = 99, .box_w = 4, .box_h = 19, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 19891, .adv_w = 89, .box_w = 4, .box_h = 20, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 19931, .adv_w = 99, .box_w = 4, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 19969, .adv_w = 89, .box_w = 3, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 19986, .adv_w = 230, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 20070, .adv_w = 180, .box_w = 9, .box_h = 19, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 20156, .adv_w = 164, .box_w = 10, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 20251, .adv_w = 91, .box_w = 8, .box_h = 19, .ofs_x = -2, .ofs_y = -4},
    {.bitmap_index = 20327, .adv_w = 230, .box_w = 13, .box_h = 20, .ofs_x = 2, .ofs_y = -6},
    {.bitmap_index = 20457, .adv_w = 197, .box_w = 12, .box_h = 21, .ofs_x = 1, .ofs_y = -6},
    {.bitmap_index = 20583, .adv_w = 194, .box_w = 12, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 20649, .adv_w = 190, .box_w = 11, .box_h = 18, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 20748, .adv_w = 89, .box_w = 4, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 20788, .adv_w = 190, .box_w = 10, .box_h = 20, .ofs_x = 2, .ofs_y = -6},
    {.bitmap_index = 20888, .adv_w = 89, .box_w = 3, .box_h = 21, .ofs_x = 1, .ofs_y = -6},
    {.bitmap_index = 20920, .adv_w = 190, .box_w = 10, .box_h = 15, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 20995, .adv_w = 89, .box_w = 7, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21051, .adv_w = 190, .box_w = 10, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 21121, .adv_w = 110, .box_w = 7, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21174, .adv_w = 192, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 21258, .adv_w = 94, .box_w = 7, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 21311, .adv_w = 260, .box_w = 13, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 21428, .adv_w = 218, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21511, .adv_w = 260, .box_w = 13, .box_h = 20, .ofs_x = 2, .ofs_y = -6},
    {.bitmap_index = 21641, .adv_w = 218, .box_w = 11, .box_h = 17, .ofs_x = 1, .ofs_y = -6},
    {.bitmap_index = 21735, .adv_w = 260, .box_w = 13, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 21852, .adv_w = 218, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 21935, .adv_w = 233, .box_w = 13, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22033, .adv_w = 260, .box_w = 13, .box_h = 18, .ofs_x = 2, .ofs_y = -4},
    {.bitmap_index = 22150, .adv_w = 218, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 22233, .adv_w = 269, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22385, .adv_w = 203, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22469, .adv_w = 269, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22621, .adv_w = 203, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22711, .adv_w = 269, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22863, .adv_w = 203, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 22953, .adv_w = 360, .box_w = 22, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23107, .adv_w = 341, .box_w = 21, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23223, .adv_w = 233, .box_w = 12, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 23331, .adv_w = 131, .box_w = 7, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 23384, .adv_w = 233, .box_w = 12, .box_h = 20, .ofs_x = 2, .ofs_y = -6},
    {.bitmap_index = 23504, .adv_w = 131, .box_w = 7, .box_h = 17, .ofs_x = 1, .ofs_y = -6},
    {.bitmap_index = 23564, .adv_w = 233, .box_w = 12, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 23672, .adv_w = 131, .box_w = 8, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 23732, .adv_w = 199, .box_w = 12, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23846, .adv_w = 160, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 23921, .adv_w = 199, .box_w = 12, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24035, .adv_w = 160, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24110, .adv_w = 199, .box_w = 12, .box_h = 19, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 24224, .adv_w = 160, .box_w = 10, .box_h = 16, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 24304, .adv_w = 199, .box_w = 12, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24418, .adv_w = 160, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24493, .adv_w = 188, .box_w = 12, .box_h = 19, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 24607, .adv_w = 132, .box_w = 8, .box_h = 19, .ofs_x = 0, .ofs_y = -5},
    {.bitmap_index = 24683, .adv_w = 188, .box_w = 12, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24791, .adv_w = 132, .box_w = 8, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24851, .adv_w = 188, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24935, .adv_w = 136, .box_w = 8, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 24991, .adv_w = 253, .box_w = 13, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 25115, .adv_w = 217, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 25198, .adv_w = 253, .box_w = 13, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 25322, .adv_w = 217, .box_w = 11, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 25399, .adv_w = 253, .box_w = 13, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 25523, .adv_w = 217, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 25606, .adv_w = 253, .box_w = 13, .box_h = 20, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 25736, .adv_w = 217, .box_w = 11, .box_h = 17, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 25830, .adv_w = 253, .box_w = 13, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 25954, .adv_w = 217, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 26037, .adv_w = 253, .box_w = 13, .box_h = 19, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 26161, .adv_w = 217, .box_w = 12, .box_h = 16, .ofs_x = 1, .ofs_y = -5},
    {.bitmap_index = 26257, .adv_w = 360, .box_w = 22, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 26455, .adv_w = 288, .box_w = 18, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 26590, .adv_w = 207, .box_w = 14, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 26723, .adv_w = 179, .box_w = 13, .box_h = 19, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 26847, .adv_w = 207, .box_w = 14, .box_h = 18, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 26973, .adv_w = 210, .box_w = 13, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 27090, .adv_w = 167, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 27165, .adv_w = 210, .box_w = 13, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 27289, .adv_w = 167, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 27364, .adv_w = 210, .box_w = 13, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 27481, .adv_w = 167, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 27556, .adv_w = 98, .box_w = 8, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 27616, .adv_w = 52, .box_w = 4, .box_h = 3, .ofs_x = 0, .ofs_y = 12},
    {.bitmap_index = 27622, .adv_w = 234, .box_w = 16, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 27742, .adv_w = 254, .box_w = 15, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 27855, .adv_w = 296, .box_w = 17, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 27983, .adv_w = 136, .box_w = 7, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 28036, .adv_w = 269, .box_w = 16, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 28156, .adv_w = 279, .box_w = 18, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 28291, .adv_w = 287, .box_w = 18, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 28426, .adv_w = 92, .box_w = 6, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 28480, .adv_w = 234, .box_w = 16, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 28592, .adv_w = 242, .box_w = 13, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 28683, .adv_w = 185, .box_w = 10, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 28753, .adv_w = 234, .box_w = 16, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 28865, .adv_w = 214, .box_w = 11, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 28942, .adv_w = 210, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 29033, .adv_w = 260, .box_w = 13, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 29124, .adv_w = 269, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 29236, .adv_w = 99, .box_w = 3, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 29257, .adv_w = 230, .box_w = 13, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 29348, .adv_w = 234, .box_w = 16, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 29460, .adv_w = 306, .box_w = 15, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 29565, .adv_w = 260, .box_w = 13, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 29656, .adv_w = 261, .box_w = 13, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 29747, .adv_w = 269, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 29859, .adv_w = 263, .box_w = 13, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 29950, .adv_w = 231, .box_w = 12, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 30034, .adv_w = 204, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 30118, .adv_w = 188, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 30202, .adv_w = 207, .box_w = 15, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 30307, .adv_w = 274, .box_w = 17, .box_h = 16, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 30443, .adv_w = 215, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 30541, .adv_w = 272, .box_w = 17, .box_h = 16, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 30677, .adv_w = 287, .box_w = 18, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 30803, .adv_w = 143, .box_w = 7, .box_h = 18, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 30866, .adv_w = 207, .box_w = 15, .box_h = 18, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 31001, .adv_w = 219, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 31084, .adv_w = 179, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 31167, .adv_w = 218, .box_w = 11, .box_h = 19, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 31272, .adv_w = 91, .box_w = 5, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 31310, .adv_w = 216, .box_w = 11, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 31415, .adv_w = 219, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 31476, .adv_w = 222, .box_w = 12, .box_h = 18, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 31584, .adv_w = 173, .box_w = 12, .box_h = 15, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 31674, .adv_w = 215, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 31764, .adv_w = 181, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 31825, .adv_w = 170, .box_w = 9, .box_h = 18, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 31906, .adv_w = 218, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 31989, .adv_w = 234, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 32087, .adv_w = 89, .box_w = 3, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 32104, .adv_w = 197, .box_w = 12, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 32170, .adv_w = 179, .box_w = 13, .box_h = 15, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 32268, .adv_w = 215, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 32351, .adv_w = 199, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 32417, .adv_w = 158, .box_w = 9, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 32498, .adv_w = 203, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 32564, .adv_w = 213, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 32625, .adv_w = 202, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 32715, .adv_w = 160, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 32770, .adv_w = 216, .box_w = 13, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 32842, .adv_w = 172, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 32903, .adv_w = 216, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 32964, .adv_w = 254, .box_w = 16, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 33108, .adv_w = 177, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 33191, .adv_w = 245, .box_w = 15, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 33326, .adv_w = 273, .box_w = 17, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 33420, .adv_w = 92, .box_w = 6, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 33465, .adv_w = 216, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 33548, .adv_w = 203, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 33638, .adv_w = 215, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 33721, .adv_w = 273, .box_w = 17, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 33849, .adv_w = 213, .box_w = 11, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 33948, .adv_w = 213, .box_w = 11, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 34047, .adv_w = 267, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 34159, .adv_w = 185, .box_w = 10, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 34249, .adv_w = 227, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 34340, .adv_w = 204, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 34424, .adv_w = 101, .box_w = 3, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 34445, .adv_w = 99, .box_w = 6, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 34499, .adv_w = 173, .box_w = 9, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 34562, .adv_w = 380, .box_w = 23, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 34723, .adv_w = 378, .box_w = 21, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 34870, .adv_w = 269, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 34982, .adv_w = 228, .box_w = 12, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 35090, .adv_w = 263, .box_w = 13, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 35207, .adv_w = 221, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 35340, .adv_w = 258, .box_w = 12, .box_h = 18, .ofs_x = 2, .ofs_y = -4},
    {.bitmap_index = 35448, .adv_w = 243, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 35553, .adv_w = 234, .box_w = 12, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 35637, .adv_w = 239, .box_w = 12, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 35721, .adv_w = 185, .box_w = 10, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 35791, .adv_w = 257, .box_w = 16, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 35935, .adv_w = 213, .box_w = 11, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 36012, .adv_w = 329, .box_w = 21, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 36159, .adv_w = 205, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 36243, .adv_w = 263, .box_w = 13, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 36334, .adv_w = 263, .box_w = 13, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 36451, .adv_w = 228, .box_w = 12, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 36535, .adv_w = 253, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 36633, .adv_w = 308, .box_w = 16, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 36745, .adv_w = 262, .box_w = 13, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 36836, .adv_w = 271, .box_w = 15, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 36941, .adv_w = 263, .box_w = 13, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 37032, .adv_w = 228, .box_w = 12, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 37116, .adv_w = 230, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 37207, .adv_w = 193, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 37291, .adv_w = 221, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 37389, .adv_w = 296, .box_w = 18, .box_h = 16, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 37533, .adv_w = 214, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 37631, .adv_w = 265, .box_w = 15, .box_h = 18, .ofs_x = 2, .ofs_y = -4},
    {.bitmap_index = 37766, .adv_w = 236, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 37850, .adv_w = 350, .box_w = 18, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 37976, .adv_w = 359, .box_w = 20, .box_h = 17, .ofs_x = 2, .ofs_y = -3},
    {.bitmap_index = 38146, .adv_w = 265, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 38258, .adv_w = 318, .box_w = 16, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 38370, .adv_w = 228, .box_w = 12, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 38454, .adv_w = 226, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 38552, .adv_w = 352, .box_w = 19, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 38685, .adv_w = 234, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 38769, .adv_w = 188, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 38835, .adv_w = 212, .box_w = 12, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 38931, .adv_w = 196, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 38992, .adv_w = 156, .box_w = 9, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 39042, .adv_w = 212, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 39133, .adv_w = 201, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 39199, .adv_w = 272, .box_w = 17, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 39293, .adv_w = 174, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 39348, .adv_w = 222, .box_w = 12, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 39414, .adv_w = 222, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 39497, .adv_w = 191, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 39558, .adv_w = 205, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 39619, .adv_w = 255, .box_w = 14, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 39696, .adv_w = 218, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 39757, .adv_w = 205, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 39823, .adv_w = 217, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 39884, .adv_w = 220, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 39974, .adv_w = 183, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 40035, .adv_w = 158, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 40090, .adv_w = 183, .box_w = 13, .box_h = 15, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 40188, .adv_w = 258, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 40340, .adv_w = 173, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 40401, .adv_w = 221, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 40492, .adv_w = 195, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 40553, .adv_w = 301, .box_w = 16, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 40641, .adv_w = 301, .box_w = 18, .box_h = 14, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 40767, .adv_w = 204, .box_w = 13, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 40839, .adv_w = 258, .box_w = 14, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 40916, .adv_w = 184, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 40971, .adv_w = 184, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 41032, .adv_w = 280, .box_w = 16, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 41120, .adv_w = 196, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 41181, .adv_w = 202, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 41277, .adv_w = 201, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 41361, .adv_w = 216, .box_w = 13, .box_h = 20, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 41491, .adv_w = 156, .box_w = 9, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 41559, .adv_w = 185, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 41625, .adv_w = 172, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 41680, .adv_w = 91, .box_w = 4, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 41712, .adv_w = 89, .box_w = 6, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 41754, .adv_w = 91, .box_w = 7, .box_h = 20, .ofs_x = -2, .ofs_y = -4},
    {.bitmap_index = 41824, .adv_w = 299, .box_w = 19, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 41929, .adv_w = 305, .box_w = 18, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 42028, .adv_w = 216, .box_w = 13, .box_h = 16, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 42132, .adv_w = 191, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 42215, .adv_w = 222, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 42298, .adv_w = 183, .box_w = 13, .box_h = 20, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 42428, .adv_w = 207, .box_w = 11, .box_h = 14, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 42505, .adv_w = 260, .box_w = 16, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 42633, .adv_w = 196, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 42729, .adv_w = 288, .box_w = 18, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 42855, .adv_w = 225, .box_w = 14, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 42932, .adv_w = 271, .box_w = 15, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 43037, .adv_w = 208, .box_w = 13, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 43109, .adv_w = 244, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 43214, .adv_w = 191, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 43280, .adv_w = 273, .box_w = 15, .box_h = 21, .ofs_x = 2, .ofs_y = -3},
    {.bitmap_index = 43438, .adv_w = 229, .box_w = 13, .box_h = 18, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 43555, .adv_w = 236, .box_w = 14, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 43667, .adv_w = 194, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 43733, .adv_w = 235, .box_w = 12, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 43817, .adv_w = 224, .box_w = 12, .box_h = 15, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 43907, .adv_w = 186, .box_w = 10, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 43997, .adv_w = 149, .box_w = 9, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 44056, .adv_w = 198, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 44140, .adv_w = 165, .box_w = 10, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 44195, .adv_w = 225, .box_w = 12, .box_h = 17, .ofs_x = 2, .ofs_y = -3},
    {.bitmap_index = 44297, .adv_w = 192, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 44380, .adv_w = 341, .box_w = 22, .box_h = 17, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 44567, .adv_w = 283, .box_w = 18, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 44693, .adv_w = 205, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 44795, .adv_w = 174, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 44860, .adv_w = 242, .box_w = 13, .box_h = 17, .ofs_x = 2, .ofs_y = -3},
    {.bitmap_index = 44971, .adv_w = 191, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 45055, .adv_w = 237, .box_w = 13, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 45146, .adv_w = 196, .box_w = 12, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 45212, .adv_w = 235, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 45317, .adv_w = 191, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 45413, .adv_w = 265, .box_w = 17, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 45532, .adv_w = 214, .box_w = 14, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 45609, .adv_w = 271, .box_w = 15, .box_h = 17, .ofs_x = 2, .ofs_y = -3},
    {.bitmap_index = 45737, .adv_w = 224, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 45828, .adv_w = 348, .box_w = 20, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 45968, .adv_w = 284, .box_w = 17, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 46062, .adv_w = 383, .box_w = 22, .box_h = 17, .ofs_x = 2, .ofs_y = -3},
    {.bitmap_index = 46249, .adv_w = 312, .box_w = 19, .box_h = 15, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 46392, .adv_w = 312, .box_w = 18, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 46518, .adv_w = 258, .box_w = 15, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 46601, .adv_w = 230, .box_w = 13, .box_h = 17, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 46712, .adv_w = 183, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 46784, .adv_w = 193, .box_w = 12, .box_h = 17, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 46886, .adv_w = 158, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 46956, .adv_w = 213, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 47054, .adv_w = 184, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 47144, .adv_w = 213, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 47242, .adv_w = 184, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 47332, .adv_w = 226, .box_w = 14, .box_h = 17, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 47451, .adv_w = 173, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 47535, .adv_w = 312, .box_w = 19, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 47706, .adv_w = 247, .box_w = 15, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 47811, .adv_w = 244, .box_w = 14, .box_h = 17, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 47930, .adv_w = 203, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 48014, .adv_w = 236, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 48098, .adv_w = 195, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 48159, .adv_w = 236, .box_w = 12, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 48243, .adv_w = 216, .box_w = 11, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 48331, .adv_w = 316, .box_w = 19, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 48464, .adv_w = 247, .box_w = 15, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 48547, .adv_w = 316, .box_w = 19, .box_h = 17, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 48709, .adv_w = 247, .box_w = 15, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 48807, .adv_w = 102, .box_w = 3, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 48828, .adv_w = 329, .box_w = 21, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 49017, .adv_w = 272, .box_w = 17, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 49145, .adv_w = 228, .box_w = 12, .box_h = 18, .ofs_x = 2, .ofs_y = -4},
    {.bitmap_index = 49253, .adv_w = 191, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 49336, .adv_w = 212, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 49427, .adv_w = 261, .box_w = 13, .box_h = 18, .ofs_x = 2, .ofs_y = -4},
    {.bitmap_index = 49544, .adv_w = 220, .box_w = 11, .box_h = 15, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 49627, .adv_w = 271, .box_w = 15, .box_h = 17, .ofs_x = 2, .ofs_y = -3},
    {.bitmap_index = 49755, .adv_w = 225, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 49846, .adv_w = 234, .box_w = 12, .box_h = 17, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 49948, .adv_w = 194, .box_w = 11, .box_h = 13, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 50020, .adv_w = 320, .box_w = 18, .box_h = 17, .ofs_x = 2, .ofs_y = -3},
    {.bitmap_index = 50173, .adv_w = 265, .box_w = 15, .box_h = 14, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 50278, .adv_w = 91, .box_w = 3, .box_h = 16, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 50302, .adv_w = 243, .box_w = 15, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 50437, .adv_w = 188, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 50533, .adv_w = 243, .box_w = 15, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 50668, .adv_w = 188, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 50752, .adv_w = 335, .box_w = 20, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 50892, .adv_w = 318, .box_w = 19, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 50997, .adv_w = 213, .box_w = 11, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 51096, .adv_w = 202, .box_w = 12, .box_h = 16, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 51192, .adv_w = 263, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 51304, .adv_w = 201, .box_w = 11, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 51365, .adv_w = 263, .box_w = 16, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 51517, .adv_w = 201, .box_w = 11, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 51594, .adv_w = 329, .box_w = 21, .box_h = 18, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 51783, .adv_w = 272, .box_w = 17, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 51902, .adv_w = 205, .box_w = 12, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 52016, .adv_w = 174, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 52086, .adv_w = 199, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 52170, .adv_w = 169, .box_w = 11, .box_h = 15, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 52253, .adv_w = 263, .box_w = 13, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 52370, .adv_w = 222, .box_w = 11, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 52447, .adv_w = 263, .box_w = 13, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 52564, .adv_w = 222, .box_w = 11, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 52641, .adv_w = 271, .box_w = 15, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 52784, .adv_w = 205, .box_w = 12, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 52868, .adv_w = 271, .box_w = 15, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 52973, .adv_w = 208, .box_w = 13, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 53045, .adv_w = 271, .box_w = 15, .box_h = 19, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 53188, .adv_w = 208, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 53279, .adv_w = 226, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 53412, .adv_w = 184, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 53489, .adv_w = 221, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 53622, .adv_w = 183, .box_w = 13, .box_h = 18, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 53739, .adv_w = 221, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 53872, .adv_w = 183, .box_w = 13, .box_h = 18, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 53989, .adv_w = 221, .box_w = 14, .box_h = 19, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 54122, .adv_w = 183, .box_w = 13, .box_h = 19, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 54246, .adv_w = 236, .box_w = 12, .box_h = 18, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 54354, .adv_w = 195, .box_w = 11, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 54431, .adv_w = 185, .box_w = 10, .box_h = 17, .ofs_x = 2, .ofs_y = -3},
    {.bitmap_index = 54516, .adv_w = 156, .box_w = 9, .box_h = 14, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 54579, .adv_w = 318, .box_w = 16, .box_h = 18, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 54723, .adv_w = 258, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 54821, .adv_w = 198, .box_w = 12, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 54929, .adv_w = 157, .box_w = 10, .box_h = 15, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 55004, .adv_w = 215, .box_w = 13, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 55121, .adv_w = 173, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 55204, .adv_w = 219, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 55302, .adv_w = 182, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 55363, .adv_w = 205, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 55447, .adv_w = 174, .box_w = 10, .box_h = 11, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 55502, .adv_w = 253, .box_w = 14, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 55628, .adv_w = 205, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 55711, .adv_w = 273, .box_w = 16, .box_h = 17, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 55847, .adv_w = 220, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 55937, .adv_w = 347, .box_w = 22, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 56091, .adv_w = 300, .box_w = 19, .box_h = 11, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 56196, .adv_w = 271, .box_w = 15, .box_h = 17, .ofs_x = 2, .ofs_y = -3},
    {.bitmap_index = 56324, .adv_w = 217, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 56415, .adv_w = 258, .box_w = 14, .box_h = 17, .ofs_x = 2, .ofs_y = -3},
    {.bitmap_index = 56534, .adv_w = 224, .box_w = 13, .box_h = 19, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 56658, .adv_w = 261, .box_w = 17, .box_h = 18, .ofs_x = -2, .ofs_y = -4},
    {.bitmap_index = 56811, .adv_w = 218, .box_w = 14, .box_h = 15, .ofs_x = -2, .ofs_y = -4},
    {.bitmap_index = 56916, .adv_w = 261, .box_w = 16, .box_h = 17, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 57052, .adv_w = 212, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 57143, .adv_w = 224, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 57143, .adv_w = 73, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 57143, .adv_w = 43, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 57143, .adv_w = 32, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 57143, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 57143, .adv_w = 123, .box_w = 6, .box_h = 2, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 57149, .adv_w = 224, .box_w = 14, .box_h = 3, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 57170, .adv_w = 160, .box_w = 10, .box_h = 3, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 57185, .adv_w = 320, .box_w = 20, .box_h = 3, .ofs_x = 0, .ofs_y = 4},
    {.bitmap_index = 57215, .adv_w = 320, .box_w = 21, .box_h = 3, .ofs_x = -1, .ofs_y = 4},
    {.bitmap_index = 57247, .adv_w = 73, .box_w = 4, .box_h = 6, .ofs_x = 0, .ofs_y = 9},
    {.bitmap_index = 57259, .adv_w = 73, .box_w = 4, .box_h = 6, .ofs_x = 0, .ofs_y = 9},
    {.bitmap_index = 57271, .adv_w = 73, .box_w = 4, .box_h = 6, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 57283, .adv_w = 133, .box_w = 8, .box_h = 6, .ofs_x = 0, .ofs_y = 9},
    {.bitmap_index = 57307, .adv_w = 133, .box_w = 8, .box_h = 6, .ofs_x = 0, .ofs_y = 9},
    {.bitmap_index = 57331, .adv_w = 133, .box_w = 8, .box_h = 6, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 57355, .adv_w = 179, .box_w = 11, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 57454, .adv_w = 179, .box_w = 11, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 57553, .adv_w = 100, .box_w = 4, .box_h = 4, .ofs_x = 1, .ofs_y = 4},
    {.bitmap_index = 57561, .adv_w = 221, .box_w = 13, .box_h = 3, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 57581, .adv_w = 387, .box_w = 24, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 57749, .adv_w = 67, .box_w = 2, .box_h = 6, .ofs_x = 1, .ofs_y = 8},
    {.bitmap_index = 57755, .adv_w = 125, .box_w = 6, .box_h = 6, .ofs_x = 1, .ofs_y = 8},
    {.bitmap_index = 57773, .adv_w = 100, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 57797, .adv_w = 100, .box_w = 6, .box_h = 8, .ofs_x = 0, .ofs_y = 2},
    {.bitmap_index = 57821, .adv_w = 56, .box_w = 12, .box_h = 14, .ofs_x = -4, .ofs_y = 0},
    {.bitmap_index = 57905, .adv_w = 172, .box_w = 9, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 57968, .adv_w = 138, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 58004, .adv_w = 138, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 58040, .adv_w = 138, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 58072, .adv_w = 138, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 58104, .adv_w = 138, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 58136, .adv_w = 138, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 58172, .adv_w = 138, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 7},
    {.bitmap_index = 58204, .adv_w = 138, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 58240, .adv_w = 138, .box_w = 7, .box_h = 8, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 58268, .adv_w = 138, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 58300, .adv_w = 138, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 58332, .adv_w = 138, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 58368, .adv_w = 138, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 58400, .adv_w = 138, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 58432, .adv_w = 138, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 58464, .adv_w = 138, .box_w = 9, .box_h = 8, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 58500, .adv_w = 138, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 58532, .adv_w = 231, .box_w = 14, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 58672, .adv_w = 212, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 58763, .adv_w = 207, .box_w = 13, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 58854, .adv_w = 282, .box_w = 17, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 58973, .adv_w = 525, .box_w = 31, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 59190, .adv_w = 382, .box_w = 24, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 59358, .adv_w = 218, .box_w = 14, .box_h = 18, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 59484, .adv_w = 258, .box_w = 16, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 59596, .adv_w = 211, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 59694, .adv_w = 218, .box_w = 12, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 59778, .adv_w = 270, .box_w = 17, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 59897, .adv_w = 247, .box_w = 14, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 60037, .adv_w = 264, .box_w = 14, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 60135, .adv_w = 231, .box_w = 14, .box_h = 20, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 60275, .adv_w = 231, .box_w = 13, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 60366, .adv_w = 230, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 60464, .adv_w = 228, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 60562, .adv_w = 293, .box_w = 15, .box_h = 17, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 60690, .adv_w = 240, .box_w = 14, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 60788, .adv_w = 150, .box_w = 9, .box_h = 16, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 60860, .adv_w = 385, .box_w = 22, .box_h = 15, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 61025, .adv_w = 329, .box_w = 19, .box_h = 9, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 61111, .adv_w = 287, .box_w = 18, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 61246, .adv_w = 230, .box_w = 13, .box_h = 14, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 61337, .adv_w = 234, .box_w = 16, .box_h = 21, .ofs_x = -1, .ofs_y = -1},
    {.bitmap_index = 61505, .adv_w = 282, .box_w = 17, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 61624, .adv_w = 331, .box_w = 19, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 61757, .adv_w = 331, .box_w = 20, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 61897, .adv_w = 331, .box_w = 20, .box_h = 14, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 62037, .adv_w = 331, .box_w = 21, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 62184, .adv_w = 331, .box_w = 21, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 62331, .adv_w = 331, .box_w = 21, .box_h = 14, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 62478, .adv_w = 192, .box_w = 10, .box_h = 9, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 62523, .adv_w = 192, .box_w = 9, .box_h = 9, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 62564, .adv_w = 192, .box_w = 10, .box_h = 9, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 62609, .adv_w = 192, .box_w = 9, .box_h = 9, .ofs_x = 2, .ofs_y = 1},
    {.bitmap_index = 62650, .adv_w = 233, .box_w = 13, .box_h = 9, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 62709, .adv_w = 192, .box_w = 9, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 62768, .adv_w = 192, .box_w = 8, .box_h = 9, .ofs_x = 2, .ofs_y = 1},
    {.bitmap_index = 62804, .adv_w = 192, .box_w = 9, .box_h = 9, .ofs_x = 2, .ofs_y = 1},
    {.bitmap_index = 62845, .adv_w = 192, .box_w = 9, .box_h = 9, .ofs_x = 2, .ofs_y = 1},
    {.bitmap_index = 62886, .adv_w = 192, .box_w = 8, .box_h = 9, .ofs_x = 2, .ofs_y = 1},
    {.bitmap_index = 62922, .adv_w = 224, .box_w = 12, .box_h = 16, .ofs_x = 1, .ofs_y = -1},
    {.bitmap_index = 63018, .adv_w = 186, .box_w = 11, .box_h = 11, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 63079, .adv_w = 234, .box_w = 16, .box_h = 14, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 63191, .adv_w = 260, .box_w = 13, .box_h = 18, .ofs_x = 2, .ofs_y = -4},
    {.bitmap_index = 63308, .adv_w = 210, .box_w = 13, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 63425, .adv_w = 186, .box_w = 10, .box_h = 2, .ofs_x = 1, .ofs_y = 6},
    {.bitmap_index = 63435, .adv_w = 113, .box_w = 9, .box_h = 19, .ofs_x = -1, .ofs_y = -2},
    {.bitmap_index = 63521, .adv_w = 92, .box_w = 4, .box_h = 4, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 63529, .adv_w = 257, .box_w = 16, .box_h = 19, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 63681, .adv_w = 295, .box_w = 18, .box_h = 8, .ofs_x = 0, .ofs_y = 3},
    {.bitmap_index = 63753, .adv_w = 128, .box_w = 10, .box_h = 19, .ofs_x = -1, .ofs_y = -4},
    {.bitmap_index = 63848, .adv_w = 186, .box_w = 10, .box_h = 10, .ofs_x = 1, .ofs_y = 2},
    {.bitmap_index = 63898, .adv_w = 186, .box_w = 10, .box_h = 12, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 63958, .adv_w = 186, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 64023, .adv_w = 186, .box_w = 10, .box_h = 13, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 64088, .adv_w = 192, .box_w = 8, .box_h = 9, .ofs_x = 2, .ofs_y = 1},
    {.bitmap_index = 64124, .adv_w = 192, .box_w = 8, .box_h = 9, .ofs_x = 2, .ofs_y = 1},
    {.bitmap_index = 64160, .adv_w = 192, .box_w = 10, .box_h = 9, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 64205, .adv_w = 192, .box_w = 10, .box_h = 9, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 64250, .adv_w = 192, .box_w = 9, .box_h = 9, .ofs_x = 2, .ofs_y = 1},
    {.bitmap_index = 64291, .adv_w = 192, .box_w = 9, .box_h = 9, .ofs_x = 2, .ofs_y = 1},
    {.bitmap_index = 64332, .adv_w = 192, .box_w = 10, .box_h = 9, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 64377, .adv_w = 192, .box_w = 10, .box_h = 9, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 64422, .adv_w = 192, .box_w = 9, .box_h = 9, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 64463, .adv_w = 192, .box_w = 9, .box_h = 9, .ofs_x = 1, .ofs_y = 1},
    {.bitmap_index = 64504, .adv_w = 192, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 64576, .adv_w = 192, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 64648, .adv_w = 160, .box_w = 10, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 64713, .adv_w = 105, .box_w = 6, .box_h = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 64770, .adv_w = 105, .box_w = 6, .box_h = 19, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 64827, .adv_w = 83, .box_w = 3, .box_h = 9, .ofs_x = 1, .ofs_y = 5},
    {.bitmap_index = 64841, .adv_w = 82, .box_w = 3, .box_h = 8, .ofs_x = 1, .ofs_y = 6},
    {.bitmap_index = 64853, .adv_w = 202, .box_w = 12, .box_h = 15, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 64943, .adv_w = 202, .box_w = 11, .box_h = 15, .ofs_x = 0, .ofs_y = 0}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint8_t glyph_id_ofs_list_2[] = {
    0, 0, 1, 0, 2, 3, 4, 0,
    5
};

static const uint16_t unicode_list_6[] = {
    0x0, 0x1, 0x8, 0x9, 0x10, 0x11, 0x12, 0x13
};

static const uint16_t unicode_list_9[] = {
    0x0, 0x1, 0x2, 0x3, 0xa, 0xb, 0xc, 0xd,
    0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1e, 0x1f,
    0x1af7, 0x1af8, 0x1af9, 0x1afa, 0x1afb, 0x1b00, 0x1b02, 0x1b03,
    0x1b04, 0x1b05, 0x1b08, 0x1b09, 0x1b0a, 0x1b0c, 0x1b0d, 0x1b0e,
    0x1b10, 0x1b11, 0x1b12, 0x1b16, 0x1b20, 0x1b22, 0x1b23, 0x1b29,
    0x1b2a, 0x1b34, 0x1b42, 0x1b60, 0x1b64, 0x1b65, 0x1b66, 0x1b67,
    0x1b68, 0x1b69, 0x1b70, 0x1b71, 0x1b72, 0x1b73, 0x1b74, 0x1b75,
    0x1b76, 0x1b77, 0x1b78, 0x1b79, 0x1b91, 0x1b93, 0x1b94, 0x1b96,
    0x1b97, 0x1b99, 0x1b9b, 0x1b9c, 0x1b9d, 0x1b9e, 0x1ba1, 0x1ba2,
    0x1ba4, 0x1ba5, 0x1ba8, 0x1ba9, 0x1baa, 0x1bac, 0x1bad, 0x1c03,
    0x1c06, 0x1c12, 0x1c16, 0x1c1a, 0x1c1b, 0x1c1e, 0x1c43, 0x1c44,
    0x1c4b, 0x1c4c, 0x1c4d, 0x1c4e, 0x1c80, 0x1c81, 0x1c82, 0x1c83,
    0x1c84, 0x1c85, 0x1c86, 0x1c87, 0x1c88, 0x1c89, 0x1cf2, 0x1cf5,
    0x1cf6, 0x1cff, 0x1d01, 0x1d02, 0x1d05, 0x1d09, 0x1d0a, 0x1d0e,
    0x1d1b, 0x1d38, 0x1d50, 0x1d54, 0x1d55, 0x2090, 0x2091, 0x20a2,
    0x20a3, 0x20a6, 0x20a7, 0x20ac, 0x20ad, 0x20b0, 0x20b1, 0x20b6,
    0x20b7, 0x20ba, 0x22d8, 0x22d9, 0xa27b, 0xa27c, 0xf5f1, 0xf5f2
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 160, .range_length = 224, .glyph_id_start = 96,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 900, .range_length = 9, .glyph_id_start = 320,
        .unicode_list = NULL, .glyph_id_ofs_list = glyph_id_ofs_list_2, .list_length = 9, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_FULL
    },
    {
        .range_start = 910, .range_length = 20, .glyph_id_start = 326,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 931, .range_length = 44, .glyph_id_start = 346,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 1024, .range_length = 96, .glyph_id_start = 390,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 1122, .range_length = 20, .glyph_id_start = 486,
        .unicode_list = unicode_list_6, .glyph_id_ofs_list = NULL, .list_length = 8, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    },
    {
        .range_start = 1162, .range_length = 59, .glyph_id_start = 494,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 1222, .range_length = 58, .glyph_id_start = 553,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 1296, .range_length = 62963, .glyph_id_start = 611,
        .unicode_list = unicode_list_9, .glyph_id_ofs_list = NULL, .list_length = 136, .type = LV_FONT_FMT_TXT_CMAP_SPARSE_TINY
    }
};



/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

#if LVGL_VERSION_MAJOR == 8
/*Store all the custom data of the font*/
static  lv_font_fmt_txt_glyph_cache_t cache;
#endif

#if LVGL_VERSION_MAJOR >= 8
static const lv_font_fmt_txt_dsc_t font_dsc = {
#else
static lv_font_fmt_txt_dsc_t font_dsc = {
#endif
    .glyph_bitmap = glyph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = NULL,
    .kern_scale = 0,
    .cmap_num = 10,
    .bpp = 4,
    .kern_classes = 0,
    .bitmap_format = 0,
#if LVGL_VERSION_MAJOR == 8
    .cache = &cache
#endif
};



/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
#if LVGL_VERSION_MAJOR >= 8
const lv_font_t ui_font_montserrat_20 = {
#else
lv_font_t ui_font_montserrat_20 = {
#endif
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 26,          /*The maximum line height required by the font*/
    .base_line = 6,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
#if LV_VERSION_CHECK(7, 4, 0) || LVGL_VERSION_MAJOR >= 8
    .underline_position = -2,
    .underline_thickness = 1,
#endif
    .dsc = &font_dsc,          /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
#if LV_VERSION_CHECK(8, 2, 0) || LVGL_VERSION_MAJOR >= 9
    .fallback = NULL,
#endif
    .user_data = NULL,
};



#endif /*#if UI_FONT_MONTSERRAT_20*/

