#if HAS_TFT // VIEW_160x80

#include "graphics/view/TFT/TFTView_160x80.h"
#include "graphics/common/ViewController.h"
#include "graphics/driver/DisplayDriverFactory.h"
#include "ui.h" // this is the ui generated by lvgl / squareline editor
#include "util/ILog.h"
#include <cstdio>
#include <ctime>
#include <functional>

TFTView_160x80 *TFTView_160x80::gui = nullptr;

TFTView_160x80 *TFTView_160x80::instance(void)
{
    if (!gui)
        gui = new TFTView_160x80(nullptr, DisplayDriverFactory::create(160, 80));
    return gui;
}

TFTView_160x80 *TFTView_160x80::instance(const DisplayDriverConfig &cfg)
{
    if (!gui)
        gui = new TFTView_160x80(&cfg, DisplayDriverFactory::create(cfg));
    return gui;
}

TFTView_160x80::TFTView_160x80(const DisplayDriverConfig *cfg, DisplayDriver *driver)
    : MeshtasticView(cfg, driver, new ViewController)
{
}

void TFTView_160x80::init(IClientBase *client)
{
    ILOG_DEBUG("TFTView_160x80 init...");
    MeshtasticView::init(client);
}

void TFTView_160x80::task_handler(void)
{
    MeshtasticView::task_handler();
}

#endif