#ifndef LMATH_FIR_H
#define LMATH_FIR_H

#include "lmath_defs.h"

#ifdef __cplusplus
extern "C" {
#endif

/***************************************************************************//**
    Вычисление следующего отсчета на выходе FIR-фильтра

    @param[in]  coef            Набор коэффициентов (массив из tap-чисел)
    @param[in, out]  prev_x     Набор предыдущих значений, подаваемых на вход
                                фильтра. Массив из tap-чисел (первый элемент ---
                                самый новый).
                                Для расчета первого значения как правило заполняется
                                нулями. Функция обновляет этот массив и для расчета
                                последующих значений передается массив, полученный
                                при вычислении предыдущего значения.
                                Если используются параллельно несколько фильтров,
                                то для каждого должен использоваться свой
                                массив текущих рассчитанных значений.
    @param[in] ntap             Количество коэффициентов фильтра
    @param[in] new_x            Новое значение на входе фильтра
    @return                     Новое рассчитанное значение на выходе фильтра
*******************************************************************************/
double lmath_proc_fir(const double *coef, double *prev_y, int ntap, double new_x);

#ifdef __cplusplus
}
#endif

#endif // LMATH_FIR_H
