/***************************************************************************//**
  @ingroup ltimer
  @defgroup ltimer_cm_systick Порт таймера для Cortex-M
  Порт для работы с таймером для микроконтроллеров с ядром Cortex-M.
  Для получения системного счетчика использует системный таймер (SysTick).
  *****************************************************************************/

/***************************************************************************//**
  @ingroup ltimer_cm_systick
  @file ports/cm_systick/lclock_arch.h
  Файл содержит определение типов и констант для работы с системным счетчиком
  для процессоров с ядром Cortex-M с использованием системного таймера.

  Порт использует внешний файл chip.h, в котором должно быть определено
  значение частоты входной частоты системного таймера одним из следующих способов
  (в порядке убывания приоритетов):
    - определен явно макрос LCLOCK_IN_CLK_FREQ
    - определен макрос CHIP_CLK_SYSTICK_FREQ (в новых версиях библиотеки chip)
    - определен макрос LPC_SYSCLK (старая версия библиотеки chip или порта контроллера для LPC)
    - в проекте должна существовать глобальная переменная SystemCoreClock типа uint32_t,
        которая на момент lcock_init() должна содержать действительную частоту
        системного таймера
 ******************************************************************************/


#ifndef LCLOCK_ARCH_H_
#define LCLOCK_ARCH_H_

#include "lcspec.h"

/** Количество тиков системного таймера в секунду */
#define LCLOCK_TICKS_PER_SECOND 1000
/** Тип для представления количества системных тиков */
typedef unsigned int t_lclock_ticks;


extern volatile t_lclock_ticks lclock_systicks;


static LINLINE t_lclock_ticks lclock_get_ticks(void) {
    return lclock_systicks;
}

#endif /* LCLOCK_ARCH_H_ */
