Общий подход к использованию интерфейсных функций{#sect_gen_descr}
==============================================================

  Обработка данных преобразователя{#sect_gen_alg}
  ==============================================================

Данная библиотека предоставляет набор функций для обработки данных от преобразователя LPW25, которые позволяют получить из измеренных с заданной частотой преобразования значений напряжения на выходе преобразователя  соответствующие значения физической величины на его входе  с учетом коррекции некоторых изменений сигнала, вносимых преобразователем. 

Способ получения измерений напряжения с выхода LPW25 зависит от устройства сбора данных (далее УСД), к которому подключен преобразователь. В общем случае это может быть любое УСД, поддерживающее подключение ICP-датчиков (опционально поддерживающее чтение TEDS данных). В частности такими УСД могут быть модули [LTR24](http://www.lcard.ru/products/ltr/ltr24) и/или модули [LTR25](http://www.lcard.ru/products/ltr/ltr25) в составе [крейтовой системы LTR](http://www.lcard.ru/products/ltr/). 

 Последовательность действий для обработки данных преобразователя{#sect_gen_alg_proc} 
-------------------------------------------------------------------------------

Общая последовательность вызовов для обработки данных преобразователя  может выглядеть следующим образом:

1. Создать структуру #TLPW25_PROC_CTX, представляющую собой  контекст обработки данных от одного преобразователя LPW25, и проиницилизировать ее с помощью LPW25_ProcessInit(). В случае обработки данных от нескольких преобразователей необходимо создать  отдельный контекст для каждого преобразователя и выполнять для каждого контекста все действия, связанные с контекстом обработки данных.
2. Заполнить необходимые для обработки параметры контекста одним из двух способов:
    - Если  УСД поддерживает чтение данных TEDS преобразователя, то параметры могут быть заполнены  на основе прочитанных данных из самого преобразователя, для чего необходимо выполнить действия из раздела @ref sect_gen_alg_teds, передав ранее созданный контекст обработки в функцию LPW25_TEDSDecode().
    - Если УСД не поддерживает чтение данных TEDS преобразователя, то необходимо вручную записать коэффициент передачи из паспорта данного экземпляра LPW25 в поле @fieldref{TLPW25_PROC_CTX,Sens}  контекста обработки.
3. Записать в поле @fieldref{TLPW25_PROC_CTX,Fd} значение частоты в Гц, на которой будет оцифрован сигнал с выхода LPW25.
4. Выполнить запуск обработки данных, вызвав функцию LPW25_ProcessStart().
5. Запустить сбора данных с выхода LPW25 с помощью функций УСД, к которому подключен преобразователь LPW25.
6. Принять блок оцифрованных значений напряжения с выхода преобразователя LPW25 с помощью функций УСД, к которому подключен преобразователь LPW25.
7. Если известно входное сопротивление канала УСД, то при необходимости можно учесть его влияние на измеряемый сигнал, как описано в главе @ref sec_r_icp_in.
8. Выполнить обработку принятых измерений, вызвав LPW25_ProcessData().
9. Переход к пункту 6, если необходимо обработать еще данные, или к пункту 10, если все данные собраны и обработаны.
10. Завершить сбор данных с выхода LPW25 с помощью функций УСД, к которому подключен преобразователь LPW25.
11. Завершить обработку данных от LPW25, вызвав функцию LPW25_ProcessStop().

Далее в подразделах более подробно описаны некоторые аспекты обработки данных.

Коэффициент передачи преобразователя{#sec_sens}
------------------------------------------------------------------------------
Коэффициент передачи (или чувствительность) преобразователя определяет отношение изменения выходного сигнала преобразователя к соответствующему изменению сигнала на входе. Соответственно этот коэффициент используется для преобразования измеренных значений напряжения в соответствующие значения физических величин на входе преобразователя. 

Для каждого экземпляра преобразователя LPW25 на этапе калибровки вычисляется свой коэффициент передачи, который записывается в TEDS данные на энергонезависимой памяти самого преобразователя и также заносится в паспорт преобразователя. Для достижения указанной в спецификации точности измерения, необходимо использовать коэффициент передачи от конкретного экземпляра (а не приведенные теоретические значения для каждой модели).

В случае, если УСД, к которому подключен преобразователь, поддерживает чтение данных TEDS, получение коэффициента передачи и сопоставление с преобразователем может выполняться автоматизированно программными средствами без ручной настройки, что позволяет избежать ошибок конфигурации. В противном случае коэффициент передачи должен устанавливаться вручную значением из паспорта преобразователя и сопоставление каналов УСД и коэффициентов передачи выполняться внешними средствами.

Применение коэффициента передачи выполняется при обработке данных с помощью LPW25_ProcessData(), если функции передан флаг #LPW25_PROC_FLAG_PHYS.

Учет выходного сопротивления преобразователя{#sec_r_icp_in}
------------------------------------------------------------------------------
За счет взаимодействия выходного сопротивления преобразователя LPW25 (а также сопротивления кабеля подключения LPW25)  и входного сопротивления входа  УСД образуется делитель, на котором происходит падение измеряемого напряжения с датчика. 

Коэффициент передачи этого делителя составляет \f$ K = \frac{R_{in}}{R_{in} + R_{out}} \f$, где \f$ R_{in} \f$ --- входное сопротивление канала УСД, а \f$ R_{out} \f$ --- сумма выходного сопротивления преобразователя LPW25 и сопротивление кабеля подключения LPW25 к УСД. 

При этом выходное сопротивление LPW25 зависит от тока питания преобразователя, который также зависит от УСД и его настроек. Значение выходного сопротивления LPW25  соответствует 20 Ом для силы тока 2.86 мА (определяется константой #LPW25_ROUT_ISRC_2_86) и 13 Ом при токе питания 10 мА (определяется константой #LPW25_ROUT_ISRC_10). Эти значения также записываются в данные TEDS преобразователя LPW25 и возвращаются в структуре с информацией о преобразователе при их разборе.

При большой длине кабеля, если его сопротивление также может вносить значимый вклад в коэффициент падения напряжения, оно также может быть измерено и его значение  включено в рассчет \f$ R_{out} \f$ для дополнительной коррекции. Способ определения сопротивления кабеля при подключении LPW25 приведен на [соответствующей странице сайта](http://www.lcard.ru/products/accesories/lpw25?default=princip#cable_resistance).

Если в качестве УСД выступает модуль  [LTR24](http://www.lcard.ru/products/ltr/ltr24) или модуль [LTR25](http://www.lcard.ru/products/ltr/ltr25), то их API включает возможность задать выходное сопротивление датчиков, подключенных к соответствующим ICP входам для автоматического учета соответствующего падения напряжения. Токи питания ICP входов для этих модулей соответствуют токам для которых явно определены и записаны в TEDS выходные сопротивления LPW25.


Коррекция фазы{#sec_sensor_pha_cor}
------------------------------------------------------------------------------
Для задач, где важны фазы сигнала,  библиотека позволяет сделать коррекцию сдвига фазы преобразователей на низких частотах  с помощью фильтра, описанного в статье ["Фазовый корректор дифференцирующей RC-цепи"](http://www.lcard.ru/download/articles/iir_phase_corrector.pdf).

Для этого необходимо передать флаг #LPW25_PROC_FLAG_PHASE_COR в функцию LPW25_ProcessData() при обработке данных. При этом используется измеренное общее для преобразователей LPW25 значение смещения фазы преобразователя на частоте 50 Гц. Значение смещения фазы также хранится в данных TEDS преобразователя и используется для заполнения параметров контекста обработки данных при их разборе.

Важно отметить, что коррекция фазы имеет значение только для преобразователей, которые предназначены для измерения фазовых параметров сигнала (LPW25-U-2-230 и LPW25-I-1-5-1). Если используется преобразователь LPW25-I-1-5-2, то он не предназначен для этих целей и вносит значительно большие некорректируемые искажения фазы, в результате чего данная коррекция не имеет для него практического смысла.


Данные TEDS преобзователя{#dec_teds}
==============================

Преобразователь LPW25 имеет свою энергонезависимую память размером в 1Кбит типа DS2431, в которой содержится информация о канале преобразователя с его характеристиками в виде электронной спецификации (TEDS) преобразователя в формате, соответствующем стандарту [IEEE 1451.4](https://www.iso.org/standard/54368.html).

В случае многоканального преобразователя, каждый канал преобразователя имеет свою энергонезависимую память со своими характеристиками. По сути для УСД каждый канал многоканального преобразователя является своим независимым преобразователем, за исключением того факта, что они объединены в одном корпусе и имеют один серийный номер. Для возможности уникальной идентификации каналов многоканального преобразователя, каждый канал в рамках одного преобразователя имеет свой идентификатор модели (например, для LPW25-U-2-230  введены два разных идентификатора для первого и второго канала преобразователя).

Выполнить чтение информации из данной энергонезависимой памяти возможно только в случае, если  УСД, к которому подключен преобразователь,  поддерживает специальный режим чтения TEDS данных подключенного преобразователя и выполняется с помощью функций этого УСД.

Примером  УСД с поддержкой чтения TEDS данных является модуль  [LTR25](http://www.lcard.ru/products/ltr/ltr25) ревизии 2 или выше. В этом случае для чтения для чтения данных TEDS используются функции библиотеки  [ltr25api](http://www.lcard.ru/download/ltr25api.pdf).

Данная библиотека предоставляет функции для разбора прочитанных данных TEDS из памяти LPW25 с  сохранением их виде структуры типа #TLPW25_INFO, а также с возможностью автоматического заполнения параметров [контекста обработки данных](@ref TLPW25_PROC_CTX) преобразователя LPW25 на основе прочитанной информации.

Возвращаемая информация о преобразователе описывается в документации полей структуры #TLPW25_INFO.


Последовательность действий для разбора данных TEDS преобразователя{#sect_gen_alg_teds} 
-------------------------------------------------------------------------------
Для разбора данных TEDS LPW25 необходимо выполнить следующие действия:
1. Прочитать данные TEDS из энергонезависимой памяти преобразователя LPW25, сохранив их в байтовый массив, выполнив проверку и удалением байт контрольной суммы. Для этого используются функции УСД, обеспечивающие доступ к памяти TEDS преобразователя (функции [ltr25api](http://www.lcard.ru/download/ltr25api.pdf), если LPW25 подключен ко входу модуля  [LTR25](http://www.lcard.ru/products/ltr/ltr25)).
2. Создать экземпляр структуры #TLPW25_INFO и проинциализровать его с помощью функции LPW25_InfoInit().
3. В случае необходимости дальнейшей обработки данных от данного LPW25  необходимо создать контекст обработки данных, как описано в разделе @ref sect_gen_alg_proc
4. Выполнить разбор данных TEDS с помощью функции LPW25_TEDSDecode(), передав ей прочитанные данные TEDS и созданные на предыдущих этапах структуры.


Формат данных TEDS преобразователя LPW25{#sec_teds_format}
----------------------------------------------------------------------------------------------------

Данный раздел описывает, каким образом сохраняется информация в энергонезависимой памяти преобразователя. При использовании данной библиотеки как правило не требуется знать данной информации, т.к. для разбора данных предоставляется готовая функция LPW25_TEDSDecode(). Однако данный раздел может быть полезен в случае разбора информации сторонними средствами разбора TEDS данных.

Общие сведения о формате TEDS содержатся в [Руководстве программиста библиотеки ltedsapi](http://www.lcard.ru/download/ltedsapi.pdf), в данном же разделе описано как используется этот формат для сохранения именно данных для LPW25.

Как и для любого TEDS информация о LPW25 начинается с фиксированной базовой информации, которая в частности включает в себя:
 - Идентификатор производителя. Должен соответствовать коду "Л Кард" (2614, определен константой LTEDS_LCARD_MANUFACTURER_ID из  [ltedsapi](http://www.lcard.ru/download/ltedsapi.pdf)).
 - Идентификатор модели преобразователя. Идентификаторы моделей преобразователей  "Л Кард" определены перечислением e_LTEDS_LCARD_MODEL_ID из  [ltedsapi](http://www.lcard.ru/download/ltedsapi.pdf). Для разных каналов многоканального преобразователя определены разные идентификаторы моделей.
 - Числовой серийный номер преобразователя
 - Версия преобразователя
 
Остальная информация закодирована с помощью шаблонов. Используются следующие шаблоны (в порядке следования):
1. Стандартный шаблон "High-level voltage output sensors" (30), содержит общую информацию о данной модели преобразователя, включая измеряемые физические величины, их диапазон, дату последней калибровки. Следует отметить, что диапазон входных величин приведен для пиковых значений измеряемой величины, а диапазон выходных сигналов получен, исходя из теоретического номинального коэффициента передачи для данной модели. Для расчета коэффициента передачи конкретного экземпляра используются данные следующего шаблона.
2. Стандартный шаблон "Calibration table" (40). Содержит таблицу из одной точки, которая указывает отклонение коэффициента передачи от теоретически рассчитанного для данной модели (получаемого по диапазонам входного и выходного сигнала из предыдущего шаблона) при указанном амплитудном значении входного сигнала.
3. Шаблон производителя "Л Кард" с таблицей зависимости выходного сопротивления преобразователя от тока питания (идентификатор LTEDS_LCARD_TEMPLATE_ID_CUR_IMP_TABLE из [ltedsapi](http://www.lcard.ru/download/ltedsapi.pdf)) . Содержит две точки --- значение выходного сопротивления для токов питания 10 мА и 2.86 мА (токи, используемые в модулях  [LTR24](http://www.lcard.ru/products/ltr/ltr24) и [LTR25](http://www.lcard.ru/products/ltr/ltr25)).
4. Шаблон производителя "Л Кард" с таблицей зависимости сдвига фазы от частоты (идентификатор LTEDS_LCARD_TEMPLATE_ID_PHASE_FREQ_TABLE из [ltedsapi](http://www.lcard.ru/download/ltedsapi.pdf)). Содержит одну точку с измеренным сдвигом фазы на частоте 50 Гц, которая используется для корректирующего фазу  фильтра.



