Общий подход к использованию интерфейсных функций{#sect_gen_descr}
==============================================================

Назначение библиотеки ltedsapi{#sec_library_purpose}
================================================

Данная библиотека предоставляет функции декодирования данных [TEDS](http://www.lcard.ru/lexicon/1451_4_cl1_2wire_sensor), содержащих информацию о преобразователе и его характеристиках в соответствии со стандартом [IEEE 1451.4](https://www.iso.org/standard/54368.html). Функции сохраняют  извлеченную информацию в явно определенные структуры для дальнейшего использования.

Под преобразователем (transducer) в стандарте может подразумеваться как датчик (sensor), выполняющих  преобразование интересующего воздействие (физической величины) в электрический сигнал, так и воздействующее устройство (actuator), выполняющее обратное преобразование.

Библиотека не определяет способ получения данных из памяти преобразователя (или из другого хранилища, если датчик не имеет встроенной памяти), а выполняет только декодирование уже полученных данных.

Библиотека может использоваться совместно с библиотекой [ltr25api](http://www.lcard.ru/download/ltr25api.pdf) для разбора данных  TEDS датчиков, подключенных ко входам модуля [LTR25](http://www.lcard.ru/products/ltr/ltr25) крейтовой системы LTR. Однако она может использоваться и отдельно для разбора TEDS данных, полученных иным способом.

Общие сведения о формате данных TEDS{#sect_teds_format}
================================================

Преобразователи, соответствующие стандарту [IEEE 1451.4](https://www.iso.org/standard/54368.html), имеют  энергонезависимую память, в которой хранится электронная спецификация данного преобразователя, именуемая TEDS (transducer electronic datasheet).  Данная информация, должна хранится в специальном формате, описанном в данном стандарте. 

Для оптимального использования ограниченного места в памяти преобразователя, формат позволяет кодировать поля с помощью произвольного числа битов, т.е. в отличие от большинства других форматов поля могут быть не выравнены на байтовые границы.

Данные TEDS всегда начинаются с фиксированного блока базовой информации (Basic TEDS), которая занимает 64 бита и включает в себя информацию о производителе и модели преобразователя, а также о версии и серийном номере конкретного экземпляра. 

Каждый производитель должен иметь свой уникальный зарегистрированный идентификатор. Список идентификаторов можно посмотреть на [странице сайта IEEE]( http://standards-oui.ieee.org/manid/manid.txt), а также [скачать в виде файла](http://standards-oui.ieee.org/manid/publist.xdl) определенного  [IEEE 1451.4](https://www.iso.org/standard/54368.html) формата. Номера кодов моделей преобразователей, связанные с данным идентификатором производителя, определяются непосредственно самим производителем. Также производителем могут быть определены связанные с его идентификатором шаблоны производителя для кодирования информации о преобразователе, которая не может быть описана стандартными шаблонами (см. ниже).

Остальная часть данных TEDS, идущая после базовой информации, не является фиксированной и зависит от типа преобразователя. Эта область TEDS разбита на отдельные блоки. Каждый блок содержит информацию, соответствующую одному из шаблонов, который определяет, как декодировать данные блока и какое значение они имеют. Шаблон определяется идентификатором производителя, с которым связан шаблон, а также идентификатором шаблона, уникальным для данного производителя. Также в [IEEE 1451.4](https://www.iso.org/standard/54368.html) определен набор стандартных шаблонов, не связанных с конкретным производителем. Стандартные шаблоны позволяют описать общие свойства многих типичных вариантов преобразователей, а также результаты калибровки преобразователя. Длина идентификатора шаблона может быть своя у каждого производителя, но должна быть фиксированная для всех шаблонов одного производителя. Все стандартные шаблоны имеют длину идентификатора 8 бит. 

Каждый блок данных начинается с селектора, состоящего из 2-х бит, который и определяет, какой тип шаблона используется для разбора данных этого блока: стандартный шаблон (0), шаблон производителя преобразователя с идентификатором из базовой информации (1), пользовательский шаблон или шаблон другого производителя, код которого указан после селектора (2), либо может быть признаком окончания данных TEDS, описываемых шаблонами (3). В первых трех случаях следом за селектором (или кодом производителя для селектора с кодом 2) идет идентификатор шаблона, за которым уже следуют данные, закодированные в соответствии с указанным шаблоном. Завершаются данные TEDS блоком с селектором с кодом 3, после которого идет один завершающий бит, указывающих в каком формате представлены оставшиеся данные: в виде пользовательской ASCII строки (1) или данных в произвольном формате (0).

Для описания шаблонов стандарт [IEEE 1451.4](https://www.iso.org/standard/54368.html) определяет специальный язык TDL (Template Description Language) и формат файла для их хранения и подключения к приложению разбора данных TEDS. Эти файлы хранятся не в памяти датчика, а вместе с программой разбора данных TEDS. В общем случае по идентификатору шаблона и идентификатору производителя (для нестандартных шаблонов), извлеченных из данных TEDS преобразователя, программа разбора может найти описание нужного шаблона в файлах и по нему понять, как интерпретировать остальные данные блока. Описание шаблона может содержать как определение фиксированных значений свойств (общих для всех преобразователей, описываемых шаблоном, и не требующих извлечения информации из данных TEDS), так и свойств, значения которых берутся из данных TEDS. В последнем случае шаблон явно определяет, сколько бит  занимает значение свойства, тип данных (определяет каким образом значение закодировано) и значения дополнительных параметров, которые требуются для некоторых типов для вычисления значения свойства из закодированного числа в TEDS. 

Стандарт определяет типы для целых чисел, перечислений, даты, символов (5-битных, ASCII или Unicode) и 3 типа для представления вещественных чисел (в виде числа с плавающей запятой, целого числа с линейным разрешением или целого числа с относительным разрешением) для выбора оптимального представления для требуемого диапазона и точности. Данные также могут быть закодированы в виде массива произвольной длины, каждый элемент которого состоит из одинакового набора свойств стандартных типов.

Помимо этого шаблон может определять условные блоки информации. В этом случае  в TEDS записано значение, определяющее,  какая из ветвей описания шаблона будет использована для определения далее идущего набора свойств  и их формата, что в частности позволяет включать в TEDS часть информации, только если она действительно актуальна для данного преобразователя, или предоставить на выбор несколько вариантов кодирования одних параметров (например, в зависимости от требуемой точности для преобразователя). 

Наличие универсального языка описания шаблонов позволяет расширять количество шаблонов, которое может декодировать приложение, путем добавления внешних файлов с описаниями шаблонов без изменения самой программы разбора.

В связи с тем, что без описания шаблона невозможно извлечь связанную с ним информацию и даже узнать ее размер, то в случае обнаружения блока данных, для которого программа разбора не знает описания шаблона, дальнейший разбор данных TEDS становится невозможным.

Формат данных TEDS позволяет хранить любое количество шаблонов в любом порядке при условии достаточного места в памяти преобразователя.


Особенности реализации библиотеки ltedsapi и ее ограничения{#sec_library_constraints}
================================================

Особенностью библиотеки ltedsapi является то, что данная библиотека не использует файлы описания шаблонов на языке TDL. Вместо этого библиотека явно реализует свою функцию разбора для  каждого поддерживаемого стандартного шаблона (а также для всех шаблонов производителя "Л Кард") и  определяет свою структуру, содержащую всю декодированную информацию, соответствующую данному шаблону, в которой соответствующая функция и возвращает результат разбора. 

Это сильно упрощает как реализацию самой библиотеки (что позволяет реализовать ее на языке С без внешних зависимостей), так и ее использование в приложении, так как данный подход позволяет явно определить структуры для хранения результатов разбора, а не возвращать свойства обобщенным списком, который потребовал бы дополнительного анализа и разбора со стороны приложения.

В то же время это накладывает  ограничение, что библиотека может полностью разобрать данные TEDS, только если они представлены в виде блоков, описываемых шаблонами, разбор которых реализован в библиотеке. Однако библиотека предоставляет отдельные низкоуровневые функции для декодирования свойств каждого типа или других управляющих конструкций, что позволяет пользователю при необходимости явно реализовать разбор данных, описанных шаблоном, функция разбора которого не реализована в библиотеке, в случае необходимости.

Помимо реализации разбора стандартных шаблонов библиотека определяет значения  и функции для разбора данных, специфичных для производителя "Л Кард". 


Стандартная последовательность вызовов{#sec_std_alg}
================================================

Стандартно алгоритм разбора данных TEDS с помощью данной библиотеки выглядит следующим образом:
1. Чтение данных TEDS и сохранение их в массив байт. Выполняется внешними средствами. Массив должен оставаться действительным в течение всего времени разбора данных.
2. Создание экземпляра структуры #TLTEDS_DECODE_CONTEXT, представляющей собой контекст разбора данных.
3. Инициализация созданного контекста разбора данных с помощью функции LTEDS_DecodeInit(), указав буфер с данными TEDS и его размер в байтах.
4. Извлечение базовой информации TEDS с помощью LTEDS_GetBasicInfo().
5. Извлечение значения селектора  блока данных с помощью LTEDS_GetSelector().
6. Анализ значения селектора:
    - Если значение селектора равно #LTEDS_SEL_STANDARD, то переход к разбору стандартного шаблона (пункт 7).
    - Если значение селектора равно #LTEDS_SEL_MANUFACTURER, то переход к пункту 11.
    - Если значение селектора равно #LTEDS_SEL_OTHER_MANUFACTURER, то переход к пункту 10.
    - Если значение селектора равно #LTEDS_SEL_END, то переход к пункту 14.
7. Извлечение идентификатора стандартного шаблона с помощью функции LTEDS_GetStdTemplateID().
8. По полученному идентификатору выбрать функцию разбора для соответствующего стандартного шаблона и вызвать ее. Если нет функции разбора стандартного шаблона с полученным идентификатором, то переход к пункту 15.
9. Переход к разбору следующего блока данных --- пункт 6.
10. Извлечение идентификатора производителя, к которому относится шаблон, с помощью LTEDS_GetManufacturerID().
11. Если известен размер идентификатора шаблона для идентификатора производителя (из базовой информации или полученного на этапе 10), то получение идентификатора шаблона производителя с помощью LTEDS_GetManufacturerTemplateID() с указанием этого размера. Иначе --- переход к пункту 15.
12. Если пользователем или библиотекой реализован разбор шаблона, определяемого идентификатором производителя и идентификатором шаблона, то вызвать эту функцию разбора, иначе  --- переход к пункту 15.
13. Переход к разбору следующего блока данных --- пункт 6.
14. Получение расширения завершающего селектора с помощью функции LTEDS_GetEndExtendedSelector(), определяющего формат далее идущих пользовательских данных. Опциональный разбор этих данных при наличии достаточной информации для их разбора.
15. Завершение разбора данных TEDS  (из-за найденного окончания данных TEDS или .отсутствия информации о способе представления дальнейших данных).
  
