# Общий подход к использованию интерфейсных функций{#sect_gen_descr}

# Общий алгоритм работы с модулем{#sect_gen_alg}

Данный раздел описывает типичную последовательность действий при работе с модулем LTR12. Более подробно каждый шаг будет описан в последующих разделах. 

Типичная последовательность действий имеет следующий вид:
1. Создать экземпляр структуры TLTR12, представляющей собой описатель модуля. Описатель модуля содержит всю информацию о модуле и используется при вызове всех остальных функций.
2. Проинициализировать поля описателя с помощью LTR12_Init()
3. Установить соединение с интересующим модулем с помощью функции LTR12_Open().
4. Заполнить необходимые поля с настройками модуля подструктуры @fieldref{TLTR12,Cfg} [описателя модуля](@ref TLTR12) и вызвать LTR12_SetADC() для записи настроек в модуль. Для заполнения части полей доступны вспомогательные функции.
5. При необходимости выполнить измерение начального смещения нуля АЦП с помощью LTR12_MeasAdcZeroOffset().
6. Запуск сбора данных с помощью LTR12_Start().
7. Прием заданного количества слов с помощью LTR12_Recv(). Количество слов должно быть кратно размеру кадра (поле @fieldref{TLTR12_STATE,FrameWordsCount} подструктуры @fieldref{TLTR12,State}  [описателя модуля](@ref TLTR12))
8. Обработка принятых слов с помощью LTR12_ProcessData() для получения результатов измерения.
9. Переход к пункту 7, если нужны еще данные, или к пункту 10 при завершении сбора.
10. По завершению работы выполнить останов сбора данных с помощью LTR12_Stop().
12. Закрыть соединение с модулем, вызвав функцию LTR12_Close().

# Настройка модуля{#sect_gen_cfg}
После того как связь с модулем установлена, необходимо выполнить настройку модуля. Она выполняется аналогично большинству других модулей LTR: вначале значения всех параметров записываются в соответствующие поля [структуры описателя модуля](@ref TLTR12), затем вызывается функция LTR12_SetADC(), которая значения этих полей передает модулю.

Все поля, относящиеся к настройке модуля, объединены в структуру типа #TLTR12_CONFIG (поле  @fieldref{TLTR12,Cfg} [описателя модуля](@ref TLTR12)). Именно эти поля пользователь должен изменять  для настройки модуля  и именно эти поля влияют на параметры, записываемые LTR12_SetADC(). Часть полей пользователь может заполнять как явно, так и с помощью вспомогательных функций, которые позволяют рассчитать значение поля исходя из значения желаемого результирующего параметра, определяемого полем.

При настройке модуля задаются следующие параметры:
- Последовательность опроса каналов и режимы измерения (раздел @ref sect_gen_cfg_adc_ltable).
- Источник запуска сбора данных (раздел @ref sec_gen_cfg_acq_src).
- Источник запуска каждого преобразования АЦП  (раздел @ref sec_gen_cfg_adc_freq)
- Частота АЦП при внутреннем источнике запуска преобразований  (раздел @ref sec_gen_cfg_adc_freq) 

При выполнении LTR12_SetADC() функция проверяет корректность заполнения полей конфигурации, а также рассчитает ряд результирующих параметров, соответствующих настроенной конфигурации, которые будут сохранены в поля структуры состояния модуля  #TLTR12_STATE (поле @fieldref{TLTR12,State} [описателя модуля](@ref TLTR12)).


## Настройка последовательности и параметров опроса каналов{#sect_gen_cfg_adc_ltable}

LTR12 является модулем с коммутацией каналов. Это означает, что на модуле присутствует одна микросхема АЦП и в один момент времени выполняется преобразование лишь по одному каналу, а многоканальность достигается за счет последовательного опроса всех требуемых каналов. Как и в других АЦП "Л Кард"  с коммутацией каналов, последовательность опроса каналов и параметры измерения при каждом опросе задаются с помощью логической таблицы, которая представляет собой последовательность логических каналов. Количество логических каналов задается полем  @fieldref{TLTR12_CONFIG,LChCnt}, а сама таблица определяется первыми @fieldref{TLTR12_CONFIG,LChCnt} элементами массива @fieldref{TLTR12_CONFIG,LChTbl}. 

Параметры логического канала задаются структурой #TLTR12_LCHANNEL и определяют номер физического канала, который опрашивается за этот цикл, а также используемый режим измерения при данном цикле опроса. Соответственно, модуль сперва опрашивает физический канал, заданный в первом элементе логической таблицы, затем канал, определенный вторым элементом, и так до конца таблицы, после чего начинает снова опрос с первого логического канала. 

Один цикл опроса всех каналов из логической таблицы именуется кадром АЦП.

Дополнительно для LTR12 можно задать количество фоновых измерений с помощью поля @fieldref{TLTR12_CONFIG,BgLChCnt}. Если значение этого поля больше нуля, то в конец кадра после опроса всех каналов логической таблицы будет добавлено соответствующее количество измерений собственного нуля. При обработке принятых данных значения этих измерений не будут сохранены в массив с результатами обработки, но они могут использоваться для автоматической коррекции смещения нуля АЦП, как описано в разделах @ref sect_proc_zero и @ref sect_zero_cor.

Таким образом полная длина кадра (количество преобразований АЦП за один кадр) равна @fieldref{TLTR12_CONFIG,LChCnt} + @fieldref{TLTR12_CONFIG,BgLChCnt}. Это значение сохраняется в поле @fieldref{TLTR12_STATE,FrameWordsCount} состояния модуля после выполнения LTR12_SetADC().

## Источник запуска сбора данных{#sec_gen_cfg_acq_src}

По умолчанию сбор данных с АЦП запускается по команде с ПК при выполнении LTR12_Start(). Дополнительно LTR12 поддерживает запуск сбора данных по фронту или спаду внешнего сигнала, подаваемого на вход START сигнального разъема модуля. Это позволяет запустить синхронно сбор данных нескольких модулей, подав один и тот же внешний сигнал на все модули. 

Задать данный режим можно с помощью поля @fieldref{TLTR12_CONFIG,AcqStartSrc}.

При запуске по внешнему сигналу при выполнении функции LTR12_Start() модуль переходит в режим ожидания соответствующего условия и только при его возникновении запускает опрос каналов АЦП и передачу данных с измерениями. После обнаружения условия и запуска сбора модуль непрерывно выполняет сбор данных больше не анализируя сигнал на входе START. Останов сбора всегда выполняется по команде с ПК при вызове LTR12_Stop().

При внешнем старте после вызова LTR12_Start() даже если модуль не дождался внешнего сигнала запуска сбора, все равно необходимо вызывать останов сбора с помощью LTR12_Stop(), чтобы выйти из режима ожидания внешнего сигнала запуска сбора.

## Источник запуска и частота преобразований АЦП {#sec_gen_cfg_adc_freq}
Запуск каждого отдельного преобразования АЦП может выполняться как по внутреннему периодическому сигналу модуля, так и по каждому фронту или спаду внешнего сигнала, подаваемого на вход SYN сигнального разъема модуля. Источник сигнала запуска преобразования задается полем @fieldref{TLTR12_CONFIG,ConvStartSrc}.

При использовании внутреннего сигнала запуска преобразований преобразования выполняются с постоянной частотой, определяемой параметрами структуры в поле @fieldref{TLTR12_CONFIG,AdcFreqParams} конфигурации модуля. Способ задания частоты приведен в описании структуры #TLTR12_ADCFREQ_CFG. Для подбора значений параметров данной структуры по значению требуемой частотой преобразования можно воспользоваться функциями LTR12_FillAdcFreqParam() или LTR12_FindAdcFreqParams().

Также результирующее значение частоты будет сохранено в поле @fieldref{TLTR12_STATE,AdcFreq} структуры состояния модуля после вызова LTR12_SetADC(). Как и во всех АЦП с коммутацией каналов, так как опрос разных каналов выполняется последовательно, частота АЦП разделяется между всеми каналами. Частота дискретизации сигнала отдельного логического канала будет соответствовать частоте следования кадров и равна \f$ F_{ch} = F_{adc} / (LChCnt + BgLChCnt) \f$. Значение этой частоты будет сохранено в поле @fieldref{TLTR12_STATE,FrameFreq} структуры состояния модуля после вызова LTR12_SetADC().


При использовании внешнего сигнала преобразования частота преобразований определяется частотой внешнего сигнала (если этот сигнал в принципе  является периодическим). Соответственно она не задается в настройках модуля, а полученные значения @fieldref{TLTR12_STATE,AdcFreq} и  @fieldref{TLTR12_STATE,FrameFreq} структуры состояния модуля не соответствуют действительности.

# Прием и обработка данных{#sec_proc}
 Прием и обработка данных осуществляется таким же образом, как и во многих других модулях LTR. Сперва осуществляется прием сырых данных в виде 32-битных слов специального формата с помощью LTR12_Recv(), после чего эти данные передаются в LTR12_ProcessData() для проверки их корректности и перевода в величины (мА). Обработка данных всегда производится над массивами, кратными размеру кадра АЦП. 
 
 Количество 32-битных слов в одном кадре определяется полем @fieldref{TLTR12_STATE,FrameWordsCount}, устанавливаемым библиотекой после настройки модуля с помощью LTR12_SetADC(), а количество полученных измерений на один кадр соответствует размеру логической таблицы, который задается полем @fieldref{TLTR12_CONFIG,LChCnt} настроек модуля.
 
Ниже описаны некоторые особенности обработки данных с помощью LTR12_ProcessData(), которые специфичны для данного модуля.


## Особенности калибровки данных модулем{#sect_gen_cbr}
Как и в случае с большинством других модулей АЦП, при производстве производится  калибровка  модуля LTR12 с записью его индивидуальных заводский калибровочных коэффициентов во flash-память модуля.  Эти коэффициенты считываются в структуру в поле @fieldref{TLTR12_MODULE_INFO,Cbr} информации о модуле при успешном открытии соединения с модулем.

Применение коэффициентов происходит в LTR12_ProcessData() в том случае, если в функцию передан флаг #LTR12_PROC_FLAG_CALIBR. Калибровка выполняется по формуле \f$ Y = (X + Offset)*Scale \f$, где X --- принятый код АЦП, Y --- калиброванные данные, Offset --- коэффициент смещение нуля в кодах АЦП, а Scale --- коэффициент шкалы. 

В результате применения калибровки получается калиброванные коды АЦП, для которых код #LTR12_ADC_SCALE_CODE_MAX соответствует значению диапазона входной величины (#LTR12_ADC_RANGE_MA). Этот код может быть переведен в результирующую величину в мА, если передан флаг #LTR12_PROC_FLAG_CONV_UNIT.

В отличие от других модулей с коммутацией каналов в модуле LTR12 для каждого из 32 каналов АЦП используется свой   индивидуальный коэффициент шкалы , т.к. в каждом канале установлен свой токовый шунт и коэффициент шкалы каждого канала учитывает в том числе и разброс сопротивления шунтов. В режиме измерения с общей землей (#LTR12_CH_MODE_COMM) используется непосредственно  коэффициент соответствующего канала. В разностном режиме (#LTR12_CH_MODE_DIFF) точное определение коэффициента шкалы невозможно и используется среднее значение между коэффициентами шкалы соответствующих двух каналов, что обуславливает большее значение погрешности для данного режима измерения. Для режима измерения собственного нуля (#LTR12_CH_MODE_ZERO) калибровочные коэффициенты и перевод в физические величины вообще не применяется, как описано в разделе @ref sect_proc_zero.

Коэффициент смещения нуля используется общий для всех каналов, так как это характеристика самого АЦП. Кроме того, вместо заводского значения этого коэффициента может использоваться явно измеренное значение смещения нуля из поля @fieldref{TLTR12_STATE,AdcZeroOffsetCode}, если в LTR12_ProcessData()  передан флаг #LTR12_PROC_FLAG_ZERO_OFFS_COR.

## Особенности обработки измерений собственного нуля{#sect_proc_zero}
Модуль LTR12 позволяет выполнять измерение значения собственно нуля АЦП. Это значение может использоваться для корректировки смещения нуля измерений, как описано в разделе  @ref sect_zero_cor. При этом величина смещения нуля измеряется исключительно в некалиброванных кодах АЦП и не может быть приведена к каким-либо физическим величинам, поэтому LTR12_ProcessData() к измерениям нуля не применяет калибровку или перевод в величины независимо от переданных флагов.

Существуют два варианта включения  измерений собственного нуля в цикл опроса АЦП:
  - Фоновые измерения собственного нуля. Если в настройках модуля задано ненулевое значение поля @fieldref{TLTR12_CONFIG,BgLChCnt}, то после измерений, соответствующих основной логической таблице, модуль выполняет указанное количество измерений смещения нуля. Значения этих измерений не возвращаются в результирующим массиве на выходе LTR12_ProcessData(). Этот режим удобен для автокоррекции смещения нуля (с использованием флагов #LTR12_PROC_FLAG_ZERO_OFFS_COR и #LTR12_PROC_FLAG_ZERO_OFFS_AUTORECALC), когда сами измерения нуля не требуются пользователю и вся корректировка выполняется внутри LTR12_ProcessData().
  - Явно заданные измерения нуля. Соответствует случаю, когда в логической таблице (@fieldref{TLTR12_CONFIG,LChTbl}) явно задан логический канал с режимом измерения #LTR12_CH_MODE_ZERO. Данные от этого канала возвращаются вместе с остальными измерениями в массиве с результатами, но в отличие от других измерений они всегда возвращаются  в кодах без применения калибровки, независимо от флагов, переданных в LTR12_ProcessData(). Данный режим как правило не требуется при штатной работе и может быть использован для получения всех измерений собственного нуля, например для анализа уровня шумов при измерении нуля самого АЦП и т.п.
  
 В обоих случаях полученные коды смещения нуля могут использоваться для корректировки текущего значения измеренного значения смещения нуля, сохраняемого в поле @fieldref{TLTR12_STATE,AdcZeroOffsetCode}, если в LTR12_ProcessData() передан флаг #LTR12_PROC_FLAG_ZERO_OFFS_AUTORECALC.  
  
# Корректировка смещение нуля{#sect_zero_cor}

Корректировка смещения нуля АЦП при обработки измерений для модуля LT       R12 может выполняться одним из следующих способов:
1. Использование заводского калибровочного значения смещения нуля. Этот режим не требует каких-либо дополнительных специальных измерений. Для его использования достаточно передать флаг #LTR12_PROC_FLAG_CALIBR при обработке данных с помощью LTR12_ProcessData().
2. Однократное измерение смещения нуля перед стартом. В этом случае перед запуском сбора с помощью LTR12_Start() необходимо выполнить измерение нуля с помощью LTR12_MeasAdcZeroOffset(). После запуска измерений при обработке данных помимо флага #LTR12_PROC_FLAG_CALIBR необходимо передать флаг #LTR12_PROC_FLAG_ZERO_OFFS_COR, в результате чего вместо заводского калибровочного коэффициента будет использоваться измеренное во время вызов LTR12_MeasAdcZeroOffset() значение нуля. Этот способ позволяет компенсировать возможный уход нуля с момента заводской калибровки до начала измерений.
3. Автоматическая корректировка нуля во время сбора. В данном варианте помимо измерения собственного нуля перед стартом с помощью LTR12_MeasAdcZeroOffset() также выполняется постоянное измерение собственного смещения нуля непосредственно во время сбора данных. Для этого устанавливается ненулевое значение поля @fieldref{TLTR12_CONFIG,BgLChCnt}, в результате чего после измерений, соответствующих логической таблице модуля, в каждом кадре будет выполнено дополнительно @fieldref{TLTR12_CONFIG,BgLChCnt} измерений смещения нуля. При обработке данных в LTR12_ProcessData() помимо флагов  #LTR12_PROC_FLAG_CALIBR и #LTR12_PROC_FLAG_ZERO_OFFS_COR необходимо передать флаг #LTR12_PROC_FLAG_ZERO_OFFS_AUTORECALC, в результате чего функция будет использовать измерения собственного нуля для обновление расчетного значения смещения нуля, используемого для корректировки основных измерений. Эти дополнительные измерения нуля будут использоваться только внутри LTR12_ProcessData() и не будут включены в результат обработки. Этот способ позволяет учесть уход смещения нуля во время проведения длительного непрерывного эксперимента, однако он также требует дополнительного времени в цикле опроса АЦП во время сбора, что уменьшает максимально возможное значение частоты сбора на канал.
