# Общий подход к использованию интерфейсных функций{#sect_gen_descr}

# Общий алгоритм работы с модулем{#sect_gen_alg}

Данный раздел описывает типичную последовательность действий при работе с модулем LTR216. Более подробно каждый шаг будет описан в последующих разделах.

Типичная последовательность действий имеет следующий вид:
1. Создать экземпляр структуры TLTR216, представляющей собой описатель модуля. Описатель модуля содержит всю информацию о модуле и используется при вызове всех остальных функций.
2. Проинициализировать поля описателя с помощью LTR216_Init()
3. Установить соединение с интересующим модулем с помощью функции LTR216_Open().
4. Заполнить необходимые поля с настройками модуля подструктуры [Cfg](@ref TLTR216::Cfg) [описателя модуля](@ref TLTR216) и вызвать LTR216_SetADC() для записи настроек в модуль. Для заполнения части полей доступны вспомогательные функции.
5. Вызвать функцию LTR216_InitMeasParams() для определения начальных значений вспомогательных измерений.
6. Создание структуры #TLTR216_DATA_STATUS и массива структур #TLTR216_DATA_CH_STATUS  для получения состояния модуля  и каналов во время сбора. Проинициализировать их с помощью LTR216_DataStatusInit() и LTR216_DataChannelsStatusInit() соответственно.
7. Запуск сбора данных с помощью LTR216_Start().
8. Прием заданного количества слов с помощью LTR216_Recv(). Количество слов должно быть кратно размеру кадра (поле [FrameWordsCount](@ref TLTR216_STATE::FrameWordsCount) подструктуры [State](@ref TLTR216::State) [описателя модуля](@ref TLTR216))
9. Обработка принятых слов с помощью LTR216_ProcessData() для получения результатов измерения и признаков состояния модуля и каналов.
10. Переход к пункту 8, если нужны еще данные, или к пункту 11 при завершении сбора.
11. По завершению работы выполнить останов сбора данных с помощью LTR216_Stop().
12. Закрыть соединение с модулем, вызвав функцию LTR216_Close().
 

# Настройка модуля{#sect_gen_cfg}
После того как связь с модулем установлена, необходимо выполнить настройку модуля. Она выполняется аналогично большинству других модулей LTR: вначале значения всех параметров записываются в соответствующие поля [структуры описателя модуля](@ref TLTR216), затем вызывается функция LTR216_SetADC(), которая значения этих полей передает модулю.

Все поля, относящиеся к настройке модуля, объединены в структуру типа #TLTR216_CONFIG (поле  [Cfg](@ref TLTR216::Cfg) [описателя модуля](@ref TLTR216)). Именно эти поля пользователь должен изменять  для настройки модуля  и именно эти поля влияют на параметры, записываемые LTR216_SetADC(). Часть полей пользователь может заполнять как явно, так и с помощью вспомогательных функций, которые позволяют рассчитать значение поля исходя из значения желаемого результирующего параметра, определяемого полем.

При настройке модуля задаются следующие параметры:
- Одноканальный или многоканальный режим коммутации АЦП  (раздел @ref sect_gen_cfg_adc_swmode) 
- Настройки используемого фильтра АЦП, определяющие также его время преобразования (раздел @ref sect_gen_cfg_adc_filter)
- Частоту АЦП в многоканальном режиме (с учетом времени преобразования и времени на коммутацию) (раздел @ref sect_gen_cfg_swmode_multich)
- Последовательность опроса каналов и диапазоны измерения (раздел @ref sect_gen_cfg_adc_ltable)
- Значение силы тока питания датчиков (раздел @ref sect_gen_cfg_isrc)
- Используемую схему подключения опорного датчика (раздел @ref sect_gen_cfg_ch16uref)
- Разрешение фоновых измерений (раздел @ref sect_gen_cfg_bg_meas)
- Разрешение использования тарировки (раздел @ref sect_gen_cfg_tare)

При выполнении LTR216_SetADC() функция проверит корректность заполнения полей конфигурации, а также рассчитает ряд результирующих параметров, соответствующих настроенной конфигурации, которые будут сохранены в поля структуры состояния модуля  #TLTR216_STATE (поле [ State](@ref TLTR216::State) [описателя модуля](@ref TLTR216)).  
 
 
 ## Одноканальный и многоканальный режимы коммутации АЦП{#sect_gen_cfg_adc_swmode}
 
 
Данный режим задается с помощью поля [AdcSwMode](@ref TLTR216_CONFIG::AdcSwMode) структуры конфигурации и определяет, каким образом будет выполняться опрос каналов АЦП и задаваться временные параметры опроса. Этот режим влияет на значения части других параметров конфигурации и как правило заполняется в первую очередь. Ниже в подразделах будет подробно описан каждый из режимов.

### Одноканальный режим{#sect_gen_cfg_swmode_onech}

Для включения данного режима поле [AdcSwMode](@ref TLTR216_CONFIG::AdcSwMode)  должно иметь значение #LTR216_ADC_SWMODE_SIGNLECH_CONT.

В одноканальном режиме АЦП коммутация каналов не выполняется. Коммутатор настраивается перед сбором на нужный канал, после чего запускается непрерывный сбор данных с АЦП с максимально возможной скоростью (для выбранных параметров фильтрации). Частота  АЦП, соответствующая частоте получения отсчетов от АЦП, полностью определяется временем преобразования самой микросхемы АЦП и зависит только от установленных [настроек фильтра АЦП](@ref sect_gen_cfg_adc_filter). В этом режиме не происходит сброс фильтра, т.е. время установки фильтра требуется только для первого отсчета АЦП, поэтому в этом режиме часто используется SINC3 фильтр, имеющий большее время установления.

Хотя технически в данным режиме настройки фильтра АЦП позволяют получить  частоту сбора АЦП до 250 КГц, исходя из характеристик тракта модуля  практически полезным пределом частоты АЦП является частота 50 КГц. 
 
Данный режим имеет следующие особенности:
- Может быть настроен только один канал измерения. Размер логической таблицы (поле [LChCnt](@ref TLTR216_CONFIG::LChCnt)) всегда должно быть равно 1.
- Частота  АЦП определяется параметрами фильтра АЦП
- Невозможно выполнять фоновые измерения во время сбора. Соответственно, проверка целостности линий и измерение дополнительных параметром может выполняться только перед запуском пока сбор остановлен.

### Многоканальный режим{#sect_gen_cfg_swmode_multich}

Для включения данного режима поле [AdcSwMode](@ref TLTR216_CONFIG::AdcSwMode)  должно иметь значение #LTR216_ADC_SWMODE_MULTICH_SYNC.

Данный режим является основным и позволяет использовать все каналы, а также выполнять фоновую проверку линий и других контрольных параметров, автокорректировку смещения нуля и напряжения на опорном тензодатчике во время сбора данных. 

Частота АЦП в этом режиме соответствует частоте коммутации каналов и определяется частотой сигнала синхронизации АЦП, которая получается делением на целое число (делитель)  частоты  #LTR216_ADC_CLOCK Гц. Данный делитель задается полем [SyncFreqDiv](@ref TLTR216_CONFIG::SyncFreqDiv) структуры конфигурации, так что \f$ f_{adc} = f_{adc\_clock} / (SyncFreqDiv + 1) \f$.  Для подбора делителя по желаемой частоте АЦП реализована вспомогательная функция LTR216_FillSyncFreqDiv().

Измерения  каналов как и в остальных АЦП с коммутацией каналов выполняются последовательно. Время опроса одного канала соответствует частоте АЦП и определяется частотой синхронизации АЦП, как описано выше. При этом цикл опроса одного канала выглядит следующим образом:
1. На АЦП подается сигнал синхронизации, по которому выполняется сброс фильтра и начало нового преобразования
2.  АЦП выполняет преобразование в течение времени (далее называемом временем преобразования АЦП), которое определяется  [настройками фильтра АЦП](@ref sect_gen_cfg_adc_filter).
3. По завершению преобразования АЦП передает отсчет с результатом измерения и одновременно с этим происходит переключение коммутатора в соответствии с параметрами следующего измеряемого канала
4. По завершению периода частоты синхронизации АЦП на АЦП снова подается сигнал синхронизации и начинается выполнение следующего измерения в соответствии с пунктом 1.

Время выполнения стадии 4 цикла опроса одного канала называется временем коммутации, т.к. за него должны успеть завершится все коммутационные процессы, чтобы избежать влияние предыдущего измерения на следующее. Это время зависит от параметров кабеля и подключенных датчиков. Способ его определения описан в документе [\"Крейтовая система LTR. Руководство пользователя\"](http://www.lcard.ru/download/ltr.pdf). Таким образом, параметры фильтра АЦП и частота  АЦП должны быть выбраны таким образом, чтобы время выполнения преобразования было меньше времени опроса канала АЦП (обратная величина от частоты АЦП) не менее чем на требуемое время коммутации, соответствующее текущим параметрам подключения.

Настройка этих параметров может выполняться следующим образом:
 - определяется желаемая частота АЦП и подбирается делитель частоты синхронизации с помощью LTR216_FillSyncFreqDiv().
 - определяется необходимое время коммутации в соответствии с параметрами подключения и записывается в поле [AdcMinSwTimeUs](@ref TLTR216_CONFIG::AdcMinSwTimeUs).
 - определяются параметры фильтра АЦП, чтобы при полученном времени преобразования оставалось достаточно времени на выполнение коммутации. Для этого можно использовать функцию LTR216_FillFilterParams(), которая подбирает   оптимальные параметры фильтра, чтобы время на коммутацию было не ниже заданного при заданной частоте АЦП. Если заданное значение времени коммутации не достижимо при выбранной частоте АЦП, то функция вернет меньшее значение результирующего времени коммутации, а в в качестве результата
 будет возвращена ошибка #LTR216_ERR_UNSUF_SW_TIME.  В этом случае  частоту АЦП необходимо уменьшить. Минимальное время выполнения преобразования АЦП в многоканальном режиме составляет 20 мкс, т.е. частота АЦП должна быть не больше \f$1000000/(20 + AdcMinSwTimeUs) \f$ Гц.
 
 Возможен и обратный порядок, когда вручную подбираются параметры фильтра, исходя из нужных характеристик, затем определяется минимальное время коммутации и уже исходя из них рассчитывается и устанавливается частота АЦП.

## Настройка фильтра АЦП{#sect_gen_cfg_adc_filter}

В модуле установлена микросхема АЦП AD7176-2, которая имеет встроенные настраиваемые фильтры.  В данной главе будут дано общее описание возможностей настройки фильтров и способ задания этих настроек. Более развернутуя информация с графиками и подробными таблицами для каждого фильтра может быть найденна в [документации на данную микросхему](http://www.analog.com/media/en/technical-documentation/data-sheets/AD7176-2.pdf) в резделе "Digital Filters".

Может быть выбран один из трех типов фильтра, а также для каждого типа фильтра по своей формуле может быть настроена частота выдачи данных АЦП (ODR - Output data rate) --- величина, обратная времени выполнения преобразования (в одноканальном режиме эта частота соответствует частоте АЦП, а в многоканальном определяет максимальную частоту АЦП при заданном времени коммутации, как описано в разделе @ref sect_gen_cfg_swmode_multich). Уменьшение значения ODR ограничивает максимально возможную частоту АЦП, но при этом улачшает соотношение сигнал-шум, а также от него зависят значения частот наибольшей режекции фильтра.

Тип фильтра задается полем [FilterType](@ref TLTR216_CONFIG::FilterType), а время выполнения преобразования определяется полем [AdcOdrCode](@ref TLTR216_CONFIG::AdcOdrCode) по своей формуле, в завимости от типа фильтра и режима коммутации (одноканальный или многоканальный).

Всего доступно для настройки 3 типа фильтра (определяются перечислением #e_LTR216_FILTER_TYPE):
- Каскад из SINC5 и SINC1 фильтра. Обладает наименьшим временем установления (один период преобразования для ODR 10 КГц и ниже), поэтому наиболее подходит для многоканального режима на больших частотах АЦП. Поле [AdcOdrCode](@ref TLTR216_CONFIG::AdcOdrCode)  может принимать для этого типа фильтра значение от 0 до 20 и определяет одну из 21 предопределенных частот выдачи данных. Соответствие кодов поля и результирующей частоты выдачи данных (в обоих режимах), а также первой частоты режекции(Fnotch), приведены  в таблице:


| AdcOdrCode | ODR однокан., Гц  | ODR многокан., Гц  | Fnotch, Гц    |
|----------------|----------------------------------|--------------------------------------|---------------|
| 0                        | 250000                                            | 50000                                                    | 250000     |
| 1| 125000|    41667|    125000|
| 2|  62500|    31250|     62500|
| 3|  50000|    27778|     50000|
| 4|  31250|    20833|     31250|
| 5|  25000|    17857|     25000|
| 6|  15625|    12500|     15625|
| 7|  10000|    10000|     11905|
| 8|   5000|     5000|      5435|
| 9|   2500|     2500|      2604|
| 10|   1000|     1000|      1016|
| 11|    500|      500|       504|
| 12|  397.5|    397.5|       400|
| 13|    200|      200|    200.64|
| 14|  100.2|    100.2|     100.4|
| 15|  59.98|    59.98|     59.98|
| 16|  49.96|    49.96|     50.00|
| 17|     20|       20|     20.01|
| 18|  16.66|    16.66|     16.66|
| 19|     10|       10|        10|
| 20|      5|        5|         5|

- SINC3 фильтр. Имеет всегда время установления в 3 периода частоты ODR. Соответветственно часто используется в одноканальном режиме, где нет необходимости сбрасывать фильтр при каждом измерении, в результате чего в этом режиме позволяет получить лучшее соотношение сигнал-шум по сравнению с SYNC1+SINC5 фильтрами при той же частоте ODR. Также особенностью данного режима является то, что он позволяет более точно настроить частоту выдачи данных и соответственно при необходимости подобрать точно частоту режекции фильтра (если в задаче известны частоты наибольших помех). В этом случае  [AdcOdrCode](@ref TLTR216_CONFIG::AdcOdrCode) может принимать значение от 1 до \f$  2^{14}-1\f$, а частота выдачи данных в одноканальном режиме \f$ ODR = 8000000/(32 * AdcOdrCode) \f$ Гц, которая соответветствует и частоте наибольшей режекции. В многоканальном режиме частота выдачи данных в 3 раза меньше, чем в одноканальном.

- Фильтр улучшенной фильтрации на частоте 50 Гц (и 60 Гц). Доступен только на низких частотах (ODR не выше 27.27 Гц). Чем ниже частота, тем сильнее подавление на частотах 50 и 60 Гц. Поле  [AdcOdrCode](@ref TLTR216_CONFIG::AdcOdrCode) может принимать всего 4 значения, как указано в таблице:


| AdcOdrCode | ODR, Гц  | Уровень подавления на 50/60 Гц, дБ  |
|----------------|-----------|--------------------------------------------------------|
| 2                        | 27.27    | 47 | 
| 3                        | 25          | 62 |
| 5                        | 20          | 85 |
| 6                        | 16.667 | 90 |

Функция LTR216_GetFilterOutParams() позволяет получить указанные параметры фильтра, исходя из выбранных настроек. 

Настройки фильтра могут быть подобраны автоматически по заданному режиму коммутации АЦП, частоте АЦП и необходимому времени на коммутацию (для многоканального режим) с помощью LTR216_FillFilterParams() или LTR216_FindFilterParams(). 


## Настройка последовательности и параметров опроса каналов{#sect_gen_cfg_adc_ltable}

LTR216 является модулем с коммутацией каналов. Это означает, что на модуле присутствует одна микросхема АЦП и в один момент времени выполняется преобразование по одному каналу, а многоканальность достигается за счет последовательного опроса всех требуемых каналов. Как и в других АЦП "Л Кард"  с коммутацией каналов, последовательность опроса каналов и параметры измерения при каждом опросе задаются с помощью логической таблицы, которая представляет собой последовательность логических каналов. Количество логических каналов задается полем [LChCnt](@ref TLTR216_CONFIG::LChCnt), а сама таблица определяется первыми [LChCnt](@ref TLTR216_CONFIG::LChCnt) элементами массива [LChTbl](@ref TLTR216_CONFIG::LChTbl). Параметры логического канала задаются структурой #TLTR216_LCHANNEL и определяют номер физического канала, который опрашивается за этот цикл, а также используемый диапазон измерения при данном цикле опроса. Соответственно, модуль сперва опрашивает физический канал, заданный в первом элементе логической таблицы, затем канал, определенный вторым элементом и так до конца таблицы, после чего начинает снова опрос с первого логического канала.

В отличие от большинства других АЦП с коммутацией каналов, конечный цикл опроса каналов модуля LTR216 может быть более сложным, чем задан в логической таблице, т.к. помимо основных измерений могут выполняться дополнительные фоновые измерения (их назначение описано в разделе @ref sect_gen_cfg_bg_meas). После выполнения заданных в логической таблице измерений, если разрешены какие-то фоновые измерения, то модуль переходит к их опросу и только после этого завершает цикл и переходит снова к опросу первого логического канала таблицы. Если же фоновые измерения не разрешены, то после последнего канала таблицы модуль переходит сразу к первому каналу.

Полный цикл опроса всех логических каналов, как и в остальных АЦП с коммутацией каналов, называется кадром. Величина, обратная времени одного опроса всех каналов, называется частотой кадра. Так как за кадр получается по одному отсчету каждого логического канала, то по сути частота кадра соответствует частоте следования отсчетов одного логического канала (частота на канал). В простейшем случае, когда не используются фоновые измерения, частота кадров в  [LChCnt](@ref TLTR216_CONFIG::LChCnt)  раз меньше частоты АЦП, т.е. частота АЦП делится между всеми логическими каналами. В случае включения фоновых измерений, частота кадра будет ниже, т.к. необходимо время в кадре для дополнительных измерений. Величина снижения зависит от многих факторов: включенного набора фоновых измерения, частоты АЦП, используемых диапазонов и т.д.

Возможно уменьшить частоту кадров по сравнению с максимально возможной путем добавления холостых  дополнительных холостых циклов измерения. Для этого можно установить значение поля [AdcReqFrameFreq](@ref TLTR216_CONFIG::AdcReqFrameFreq). Если оно установлено и больше нуля, то при выполнении настройки библиотека пытается подобрать количество холостых тактов так, чтобы результирующая частота кадра была как можно ближе к установленной.

## Настройка тока питания датчиков {#sect_gen_cfg_isrc}
LTR216 имеет источники тока для питания подключаемых датчиков. Все источники тока согласованы, т.е. величины этих токов для разных каналов равны в пределах погрешности. Величина тока настраивается с помощью поля [ISrcCode](@ref TLTR216_CONFIG::ISrcCode), которое может быть в пределе от 0 до #LTR216_ISRC_CODE_MAX включительно. Значение тока задается как \f$  2048 * (ISrcCode + 1) / (4096 * 33.2) \f$ мА. Кроме того, источник тока калибруется на заводе производителя и его калибровочные коэффициенты записываются во Flash-память модуля (после открытия, они доступны для чтения в информации о модуле в поле [ISrc](@ref TLTR216_FABRIC_CBR::ISrc). При этом калибруется только опорный источник тока, а соответствие остальных опорному контролируется при производстве.

Функции LTR216_FillISrcCode() и LTR216_FindISrcCode() позволяют подобрать значение поля [ISrcCode](@ref TLTR216_CONFIG::ISrcCode) с использованием заводских калибровочных коэффициентов так, чтобы полученный ток был наиболее близок к заданному. Функция LTR216_CalcISrcValue() выполняет обратное преобразование --- по коду вычисляет значение тока.

## Настройка схемы подключения опорного датчика {#sect_gen_cfg_ch16uref}
Модуль позволяет подключить опорный датчик как по 2-х проводной, так и по 4-х проводной схеме подключения. 4-х проводная схема дает более точный результат, т.к. при ней на измерение напряжения на опорном датчике не влияет сопротивление проводов до этого датчика, однако для подключения второй пары проводов в ней используются выходы, соответствующие 16 каналу модуля. Соответственно, при 4-х проводной схеме подключения опорного датчика в модуле могут использоваться только 15, а не 16 каналов. Выбор режима осуществляется с помощью поля [Ch16ForUref](@ref TLTR216_CONFIG::Ch16ForUref) конфигурации модуля (если значение отлично от 0, то используется 4-х проводная схема подключения). Следует отметить, что все метрологические характеристики модуля получены именно для 4-х проводной схемы.

При использовании 2-х проводной схемы измерения и известном сопротивлении проводов его подключения можно учесть падение напряжения на проводах при вычислении значения разбаланса с помощью поля [RrefWireResistance](@ref TLTR216_CONFIG::RrefWireResistance) конфигурации модуля, установив его равным известному сопротивлению проводов. В этом случае падение только на датчике вычисляется как \f$ UrefR = Uref - 2 * RrefWireResistance * ISrcValue / 1000 \f$. Однако это позволяет учесть только постоянное значение сопротивления, для учета его тепловых уходов следует применять 4-х проводную схему подключения.

## Настройки используемых фоновых измерений{#sect_gen_cfg_bg_meas}
Модуль LTR216 позволяет в кадре выполнять не только пользовательские измерения, но и дополнительные фоновые. Это позволяет производить автокорректировку нуля и значений вспомогательных измерений, необходимых для вычисления разбаланса,  а также проверку исправности цепей подключения датчиков и режимов измерения, не останавливая сбор данных. Однако включение фоновых измерений приводит к уменьшению максимальной частоты кадра для заданной конфигурации каналов.

Для включения фоновых измерений достаточно заполнить значение поля [BgMeas](@ref TLTR216_CONFIG::BgMeas) путем объединения флагов из #e_LTR216_BG_MEAS по "ИЛИ", где каждый флаг соответствует включенному измерению. При вызове LTR216_SetADC() функция сама распределит фоновые измерения в кадрах (при этом опрос всех фоновых измерений может быть растянут на несколько кадров для уменьшения влияния на частоту АЦП).

Следует отметить, что данное поле относится именно к фоновым измерениям, выполняемым во время сбора и влияющим на формирование основного цикла опроса каналов АЦП. Его значение не влияет на начальное измерение параметров (функция LTR216_InitMeasParams()) или отдельной проверке исправности линий и режима измерения (функция LTR216_CheckMeasStatus()). Указанные функции принимают свой набор измерений в качестве отдельного параметра.

В зависимости от типа фонового измерения, его значение может автоматически учитываться для корректировки результата и/или результаты его анализа могут возвращаться в структурах  состояния модуля (#TLTR216_DATA_STATUS) или каналов (#TLTR216_DATA_CH_STATUS) при обработке данных с помощью LTR216_ProcessData().

Для настройки доступны следующие фоновые измерения:
- Измерение собственного нуля каналов измерения разностного напряжения (#LTR216_BG_MEAS_OFFS). Используется для автоматической корректировки смещения нуля основных измерительных каналов для учета его ухода  во время сбора данных.
- Измерение падения напряжения на опорном датчике (#LTR216_BG_MEAS_UREF). Используется для корректировки абсолютного значения \f$U  ref\f$, которое участвует в формуле расчета разбаланса моста.   Влияет также на значения [Uref](@ref TLTR216_DATA_STATUS::Uref) и [UrefR](@ref TLTR216_DATA_STATUS::UrefR) (последнее только при 4-х проводном подключении опорного датчика)  [структуры состояния модуля во время сбора](@ref TLTR216_DATA_STATUS).
- Измерение смещения нуля канала измерения напряжения на опорном датчике (#LTR216_BG_MEAS_UREF_OFFS). Позволяет учитывать уход смещения нуля при включенном измерении #LTR216_BG_MEAS_UREF.
- Измерение напряжения \f$Vadj\f$ (#LTR216_BG_MEAS_VADJ). Позволяет выполнять контроль данного напряжения на нахождение в требуемых пределах. Результат проверки и измеренное значение сохраняются в поле [Vadj](@ref TLTR216_DATA_STATUS::Vadj) [структуры состояния модуля во время сбора](@ref TLTR216_DATA_STATUS).
- Измерение падения напряжения в цепи \f$ U_- \f$ (#LTR216_BG_MEAS_UNEG). Измерение учитывается в других фоновых измерениях, выполняющихся относительно земли. Результаты измерения сохраняются в поле [Uneg](@ref TLTR216_DATA_STATUS::Uneg) [структуры состояния модуля  во время сбора](@ref TLTR216_DATA_STATUS)
- Проверка цепи подключения опорного датчика из 2-х или 4-х проводов (в зависимости от схемы подключения) на короткое замыкание (#LTR216_BG_MEAS_UREF_SHORT). Влияет на состояние измерения  [Uref](@ref TLTR216_DATA_STATUS::Uref) и [UrefR](@ref TLTR216_DATA_STATUS::UrefR) (последнее только при 4-х проводном подключении опорного датчика)  [структуры состояния модуля  во время сбора](@ref TLTR216_DATA_STATUS).
- Проверка цепи подключения опорного датчика из 2-х или 4-х проводов (в зависимости от схемы подключения) на обрыв (#LTR216_BG_MEAS_UREF_OPEN). Влияет на состояние измерения  [Uref](@ref TLTR216_DATA_STATUS::Uref) и [UrefR](@ref TLTR216_DATA_STATUS::UrefR) (последнее только при 4-х проводном подключении опорного датчика)  [структуры состояния модуля](@ref TLTR216_DATA_STATUS).
- Проверка цепи \f$ U_- \f$ на обрыв (#LTR216_BG_MEAS_UNEG_OPEN). Влияет на состояние измерения  [Uneg](@ref TLTR216_DATA_STATUS::Uneg) [структуры состояния модуля  во время сбора](@ref TLTR216_DATA_STATUS). Следует отметить, что при обрыве данной цепи все остальные измерения не могут быть корректно получены.
- Проверка цепей подключения датчиков на короткое замыкание (#LTR216_BG_MEAS_CH_SHORT). Выполняется для каждого разрешенного в логической таблице канала.  Влияет на состояние измерения  [Ux](@ref TLTR216_DATA_CH_STATUS::Ux) [структуры состояния каждого канала](@ref TLTR216_DATA_CH_STATUS).
- Проверка цепей подключения датчиков на обрыв (#LTR216_BG_MEAS_CH_OPEN). Выполняется для каждого разрешенного в логической таблице канала.  Влияет на состояние измерения  [Ux](@ref TLTR216_DATA_CH_STATUS::Ux) [структуры состояния каждого канала](@ref TLTR216_DATA_CH_STATUS).
- Измерение падения напряжения на тензодатчиках и проводах их подключения относительно \f$ U_- \f$  (#LTR216_BG_MEAS_CH_UX). Выполняется для каждого разрешенного в логической таблице канала.  Результат сохраняется в поле  [Ux](@ref TLTR216_DATA_CH_STATUS::Ux) [структуры состояния каждого канала](@ref TLTR216_DATA_CH_STATUS). Данное измерение также необходимо для рассчета синфазного напряжения.
- Измерение синфазного напряжения   каналов измерения разностного напряжения (#LTR216_BG_MEAS_CH_CM). Выполняется для каждого разрешенного в логической таблице канала.  Результат сохраняется в поле  [Ucm](@ref TLTR216_DATA_CH_STATUS::Ucm) [структуры состояния каждого канала](@ref TLTR216_DATA_CH_STATUS). Служит для контроля нахождения синфазного напряжения в требуемых для корректной работы границах. Разрешение данного значения также приводит к сохранению рассчитанных допустимых границ синфазного напряжения и сохранению их в полях  [UcmMin](@ref TLTR216_DATA_CH_STATUS::UcmMin) и [UcmMax](@ref TLTR216_DATA_CH_STATUS::UcmMax) [структуры состояния каждого канала](@ref TLTR216_DATA_CH_STATUS) для возможности оценки запаса по синфазному напряжению для каждого канал.

При проверке линий на короткое замыкание необходимо установить значение поля  [ShortThresholdR](@ref TLTR216_CONFIG::ShortThresholdR). Измеренное сопротивление линии сравнивается с данным порогом и в случае, если оно меньше него, считается, что обнаружено короткое замыкание. Таким образом этот порог  должен быть ниже минимального значения сопротивления датчика сложенного с сопротивлением проводов его подключения для каждой проверяемой на короткое замыкание линии.

При проверке линий на обрыв, в линию подается тестовый ток (burnout), который приводит к зашкалу канала измерения при обрыве. Для установления этого состояния может потребоваться время, превышающее стандартный цикл опроса канала АЦП. Время это зависит от длины кабеля подключения датчиков и его погонной емкости. Значения не ниже максимальных для используемых каналов должны быть записаны в поля [CableLength](@ref TLTR216_CONFIG::CableLength) и [CableCapacityPerUnit](@ref TLTR216_CONFIG::CableCapacityPerUnit). По этим параметрам библиотека вычисляет необходимое время подачи тестого тока для обнаружения условия обрыва и определяет, сколько штатных циклов измерения должна занимать данная проверка в цикле опроса.

## Настройка разрешения использования тарировки {#sect_gen_cfg_tare}
Модуль позволяет выполнять пользователю тарировку каналов измерения, как описано в разделе @ref sect_gen_tare. Разрешение применения тарировочных коэффициентов выполняется с помощью поля [TareEnabled](@ref TLTR216_CONFIG::TareEnabled) конфигурации модуля. Если данное поле не нулевое, то для всех каналов, для которых в [информации о модуле](@ref TLTR216_MODULE_INFO) присутствуют действительные тарировочные коэффициенты, эти коэффициенты будут использованы как для установки значения ЦАП для компенсации смещения нуля, так и при расчете возвращаемого значения разбаланса.

# Измерение начальных параметров{#sect_gen_initmeas}

После завершения конфигурации модуля и до запуска первого основного цикла сбора необходимо выполнить измерение дополнительных параметров, которые нужны для вычисления разбаланса или корректировки результатов измерений. Для этого необходимо вызвать функцию LTR216_InitMeasParams(), передав ей список измеряемых параметров.

Необходимость выполнения начальных измерений  не зависит от разрешения выполнения аналогичных фоновых  измерений, т.к. их значения нужны уже для расчета результатов начиная с первого кадра, когда фоновые измерения еще не выполнены. Таким образом, начальное измерение параметров позволяет получить начальные значения всех необходимых величин для расчета результата, начиная с первого кадра сбора, а опциональные соответствующие фоновые измерения позволяют корректировать их значения во время сбора, компенсирую их возможный уход во время выполнения измерений.

Могут быть вычислены следующие параметры:
- Смещение нуля для каналов измерения разностных напряжений (#LTR216_INIT_MEAS_OFFS).  Данное значение может быть использовано для компенсации смещения нуля измерительных каналов. Оно не возвращает напрямую результат пользователю, но сохраняет внутри описателя код смещения нуля для каждого разрешенного канала, которые будут использованы при последующем сборе данных при обработке в LTR216_ProcessData(). 
- Измерение напряжения на опорном датчике (#LTR216_INIT_MEAS_UREF). Так как данное значение участвует в расчете значения разбаланса, необходимо выполнить его измерение до сбора для получения корректных результатов. Результат измерения сохраняется внутри описателя для дальнейшего использования, а также доступен через поля [Uref](@ref TLTR216_DATA_STATUS::Uref) и [UrefR](@ref TLTR216_DATA_STATUS::UrefR) возвращаемой  [структуры состояния модуля во время сбора](@ref TLTR216_DATA_STATUS).

# Сбор и обработка данных{#sect_gen_recv}

В случае необходимости получения информации о результатах обработки фоновых измерений и иных проверок корректности условий измерений необходимо перед запуском создать и проинициализировать структуры, используемые для сохранения этих результатов:
- Для сохранения результатов, не связанных с конкретным каналом, нужно создать одну структуру типа #TLTR216_DATA_STATUS и проинициализировать ее, вызвав LTR216_DataStatusInit().
- Для сохранения результатов, связанных с каналами измерения, нужно создать массив из структур типа #TLTR216_DATA_CH_STATUS размером, равным количеству логических каналов в таблице (настройка [LChCnt](@ref TLTR216_CONFIG::LChCnt)) и проинициализировать его, вызвав LTR216_DataChannelsStatusInit()

Запуск сбора выполняется функцией LTR216_Start() после конфигурации модуля и измерения начальных параметров. После ее вызова модуль переходит в режим сбора данных и начинает опрос АЦП в соответствии с установленными настройками. При выполнении сбора данных недоступны никакие действия, кроме либо приема  и обработки новых данных, либо останова сбора. 

Для приема данных необходимо получать слова от модуля с помощью LTR216_Recv() со скоростью передачи их от модуля и выполнить обработку с помощью LTR216_ProcessData(). Обработку следует выполнять порциями, содержащими целое число кадров. Количество слов в кадре можно узнать по полю [FrameWordsCount](@ref TLTR216_STATE::FrameWordsCount) структуры состояния модуля (поле [State](@ref TLTR216::State) [описателя модуля](@ref TLTR216)), которое заполняется после вызова LTR216_SetADC(). 

В LTR216_ProcessData() следует передавать созданные и проинициализированные ранее структуры для сохранения результатов фоновой обработки, если эта информация требуется. Отслеживать состояние можно двумя способами, либо анализируя состояния измерений и флаги статуса каждой структуры, по которым можно узнать текущие результаты проверок. Либо можно проверять флаги в полях обнаружения ошибок, которые устанавливаются при их обнаружении и уже не сбрасываются без ручного обнуления пользователем, т.е. их можно использовать, чтобы проверить, что с момента начала сбора данных (или последнего ручного их сброса) не возникало ошибок измерений. Ошибки, сохраняемые в этих структурах, влияют на действительность выполняемых измерений, но не связаны с ошибками работ интерфейса модуля и не препятствуют дальнейшему сбору и обработке данных, поэтому они не влияют на код, возвращаемый самой функцией LTR216_ProcessData().

По завершению обработки необходимо остановить сбор данных с помощью LTR216_Stop(). 

# Проверка линий и условий измерения{#sect_gen_meascheck}

Проверку линий и условий измерений можно выполнить до сбора измерений, вызвав функцию LTR216_CheckMeasStatus(). Для ее вызова модуль должен быть уже сконфигурирован, но сбор данных не запущен. Функция принимает набор флагов, определяющих, какие измерения должны выполняться, аналогично тому, как задаются фоновые измерения с помощью поля [BgMeas](@ref TLTR216_CONFIG::BgMeas) конфигурации модуля. При этом набор переданных измерений может отличаться от набора настроенных фоновых измерений. Например, можно не разрешать фоновые измерения. чтобы увеличить частоту кадров при сборе данных, а проверять нужные условия только перед сбором данных.

Назначение этих измерений аналогично фоновым измерениям и подробно описано в резделе @ref sect_gen_cfg_bg_meas. Результаты проверок и обработки фоновых измерений возвращаются функцией LTR216_CheckMeasStatus() аналогично тому, как они возвращаются при включенных фоновых измерениях функцией LTR216_ProcessData(). Все структуры для сохранения результатов должны быть аналогично проинициализированны (можно использовать одни и те же, что при сборе, что при отдельной проверке).

# Выполнение тарировки{#sect_gen_tare}

Библиотека позволяет пользователю выполнять тарировку выбранных каналов модуля и сохранять полученные тарировочные коэффициенты в энергонезависимую память модуля. Тарировка позволяет подобрать коэффициенты всей измеретельной системы в целом  (датчики, кабели подключения, модуль АЦП) для получения резултатов, приведенных к пользовательской шкале измерения.  Кроме того, тарировка нуля позволяет скомпенсировать начальный разбаланс, превышающий используемый поддиапазон измерения в 2 раза за счет подстроечного ЦАП (\f$\pm70\f$ мВ для диапазона \f$\pm35\f$ мВ и \f$\pm140\f$ мВ для диапазона \f$\pm70\f$ мВ).

При выполнении тарировки  пользователь последовательно подает на вход системы величины, которые будет соответствовать сперва нулю, а затем максимальному значению шкалы в его измерительной системе. При этом уровень нуля должен быть ограничен двумя выставленными диапазонами измерения, а шкалы --- в пределах диапазона от скорректированного нуля. Если требуется только скомпенсировать начальное смещение, то тарировка шкалы может не проводиться.

Тарировка шкалы выполняется по значению разбаланса, для вычесления которого необходимо знать значение падения напряжения на опорном датчике. Поэтому до тарировки шкалы данное значение должно быть измерено с помощью LTR216_InitMeasParams() с флагом #LTR216_INIT_MEAS_UREF. Это измерение может выполняться непосредственно перед тарирокой шкалы для наиболее точного измерения, либо может быть использовано ранее полученное значение, если оно было получено при тех же настройках и значение падения напряжения на опорном датчике с тех пор не изменилось в пределах требуемой погрешности.

Тарирочные коэффициенты одного канала описываются структурой #TLTR216_TARE_CH_COEFS и хранятся в массиве [Tare](@ref TLTR216_MODULE_INFO::Tare) в структуре [ModuleInfo](@ref TLTR216::ModuleInfo) [описателя модуля](@ref TLTR216). Данная структура помимо самих значений коэффициентов имеет отдельные поля для проверки их действительности (указывающие, что была проведена успешная тарировка, в результате которой были рассчитаны эти коэффициенты), а также информацию о части конфигурационных параметров модуля, для которых она проводилась.

Полная тарировка выполняется следующим образом:
1. Заполняются настройки модуля. В логическую таблицу должны быть добавлены логические каналы, соответствующие всем физическим каналам, тарировку которых планируется провести.  Выполняется настройка модуля с помощью LTR216_SetAdc().
2. Тарировка нуля. Для этого на каждый тарируемый  канал измерительной системы подают уровень, соответствующее нулевому уровню пользовательской шкалы (начальный разбаланс), после чего вызывается функция LTR216_TareOffset().
3. Измерение напряжения на опорном датчике с помощью функции LTR216_InitMeasParams() с флагом #LTR216_INIT_MEAS_UREF, если оно не было выполнено раньше при текущих условиях и настройках модуля.
4. Тарировка шкалы (опционально). Для этого на каждый тарируемый канал измерительной системы подают уровень , соответствующее максимальному разбалансу в пользовательской шкале, после чего вызывается функция LTR216_TareScale(). Это значение  должно быть в пределах выбранного диапазона измерения и при получении данных с использованием тарировочных коэффициентов при данном уровне сигнала будет возвращаться значение, соответствующее границе выбранного диапазона.

После завершения тарировки полученные коэффициенты сохраняются только в самой структуре описателя модуля. Они могут быть применены для последующих измерений. Для этого необходимо установить значение поля [TareEnabled](@ref TLTR216_CONFIG::TareEnabled) конфигурации модуля и вызвать LTR216_SetADC(), после чего следующих сбор данных будет проведен с учетом тарировчных коэффициентов. При включенной тарировке функция LTR216_ProcessData() будет возвращать значения в шкале измерений, где 0 соответствует разбалансу, который был при тарировке нуля, а значение равное  диапазону измерения соответствует разбалансу при тарировке шкалы.

Важно отметить, что после изменения любым способом тарировочных коэффициентов модуля необходимо повторно сконфигурировать модуль путем вызова LTR216_SetADC(), так как тарировочные коэффициенты влияют на конфигурацию ЦАП для компенсации смещения нуля.

Полученные тарировочне коэффциенты можно сохранить в энергонезависимую память модуля путем вызова функции LTR216_WriteTareInfo(). Коэффциенты автоматически считываются из энергонезависимой памяти при последующем открытии соединения с модулем через LTR216_Open() и сохраняются в структуре [ModuleInfo](@ref TLTR216::ModuleInfo) [описателя модуля](@ref TLTR216). 

В случае, если во время работы коэффициенты в структуре модуля были изменены, но требуется вернуться снова к коэффциентым, которые были до этого записаны во flash-память, то можно прочитать коэффциенты явно, вызвав функцию LTR216_ReadTareInfo(). 

# Работа с пользовательской областью энергонезависимой памяти модуля{#sect_gen_userflash}

На модуле LTR216 присутствует энергонезависимая flash-память. Часть памяти используется для хранения стандартной информации, использующейся библиотекой, включая серийный номер модуля, заводские калибровки, а также результаты тарировки.

При этом часть этой памяти, начиная с адреса #LTR216_FLASH_USERDATA_ADDR, размером #LTR216_FLASH_USERDATA_SIZE отдана пользователю для возможности записи им любой своей информации. 

Эта область всегда доступна на чтение с помощью функции LTR216_FlashRead(). При этом она изначально защищена от записи, чтобы невозможно было случайно изменить ее содержимое.
Последовательность вызовов для изменения содержимого части информации в пользовательской области flash-памяти выглядит следующим образом:
1. Разрешение изменение содержимого пользовательской области flash-памяти с помощью LTR216_FlashWriteEnable().
2. Стирание информации в блоке памяти, содержимое которого нужно изменить, с помощью LTR216_FlashErase(). Начальный адрес и размер блока должен быть кратен 256 байт.
3. Запись информации в стертую ранее область Flash-памяти с помощью LTR216_FlashWrite().
4. При необходимости изменения еще одного блока можно повторить пункты 2 и 3 нужное количество раз.
5. По завершению изменения содержимого пользовательской области flash-памяти необходимо снова запретить возможность ее изменения, вызвав LTR216_FlashWriteDisable().


