Общий подход к использованию интерфейсных функций{#sect_gen_descr}
==============================================================

  Общий алгоритм работы с модулем{#sect_gen_alg}
  ==============================================================

Данный раздел описывает типичную последовательность действий при работе с модулем LTR24. Более подробно каждый шаг будет описан в последующих разделах.

Типичная последовательность действий имеет следующий вид:
1. Создать экземпляр структуры #TLTR24, представляющей собой описатель модуля. Описатель модуля содержит всю информацию о модуле и используется при вызове всех остальных функций.
2. Проинициализировать поля описателя с помощью LTR24_Init()
3. Установить соединение с интересующим модулем с помощью функции LTR24_Open().
4. Выполнить чтение информации из энергонезависимой памяти модуля (включая калибровочные коэффициенты) с помощью функции LTR24_GetConfig().
5. Заполнить поля конфигурации модуля из [описателя модуля](@ref TLTR24) в соответствии с требуемыми настройками и вызвать LTR24_SetADC() для записи настроек в модуль.
6. Запустить сбор данных с помощью LTR24_Start().
7. Прием и обработка данных, как описано ниже
9. По завершению работы выполнить останов сбора данных с помощью LTR24_Stop().
10. Закрыть соединение с модулем, вызвав функцию LTR24_Close().
 

Типичный цикл приема и обработки данных аналогичен большинству модулей АЦП системы LTR и выглядит следующим образом:
1. Прием заданного количества слов с данными от модуля с помощью LTR24_Recv().
2. Обработка принятых данных с помощью LTR24_ProcessData().




Настройка модуля{#sect_gen_cfg}
=============================================================
Настройка модуля выполняется аналогично большинству других модулей LTR: вначале значения всех параметров модуля записываются в соответствующие поля [структуры описателя модуля](@ref TLTR24), затем вызывается функция LTR24_SetADC(), которая значения этих полей передает модулю. Модуль должен быть настроен перед первым запуском сбора данных. Во время запущенного сбора данных изменение настроек не допускается.

Для полей, которые необходимо установить при конфигурации модуля, в описании поля явно указано, что "значение устанавливается пользователем при конфигурации модуля". 
Настройки, которые задаются для всего модуля или для всех каналов одновременно, определяются полями самой управляющей структуры и описаны в данном разделе, а настройки, которые задаются индивидуально для каждого канала, определяются полями массива структур @fieldref{TLTR24,ChannelMode} и описаны в разделе @ref sect_gen_cfg_adc_ch.

При настройке модуля задаются следующие параметры:
- Одинаковая для всех каналов частота сбора АЦП. Может быть выбрана одна из 16 предопределенных частот сбора с помощью записи соответствующего кода в поле @fieldref{TLTR24,ADCFreqCode}.
- Настройки каналов АЦП (раздел @ref sect_gen_cfg_adc_ch).
- Формат передаваемых данных задается полем @fieldref{TLTR24,DataFmt} (см. раздел @ref sec_gen_cfg_fmt).
- Значение источника тока (10 или 2.86 мА). Действительно только для LTR24-2. Задается на все каналы сразу с помощью поля @fieldref{TLTR24,ISrcValue}.
- Включение тестовых режимов с помощью поля @fieldref{TLTR24,TestMode} (см. раздел @ref sect_gen_cfg_adc_ch_mode).

После выполнения LTR24_SetADC() значение частоты АЦП в Гц, соответствующее установленном коду, записывается в поле @fieldref{TLTR24,ADCFreq} описателя модуля.

Настройка каналов АЦП{#sect_gen_cfg_adc_ch}
--------------------------------------------------
Каждый модуль LTR24 имеет четыре канала, которые выполняют преобразования параллельно с одинаковой частотой. 

Настройки каждого канала объединены в структуре #TLTR24_CHANNEL_CONFIG. Массив структур из #LTR24_CHANNEL_CNT элементов, каждый элемент которого соответствует определенному каналу, является полем @fieldref{TLTR24,ChannelMode} структуры #TLTR24.


Для каждого канала можно изменить следующие настройки
1. Разрешить или запретить прием данных по этому каналу с помощью поля @fieldref{TLTR24_CHANNEL_CONFIG,Enable}. Следует учитывать, что для 24-битного формата данных максимальное количество одновременно разрешенных каналов зависит от настроенной частоты сбора (подробнее см. в документе [\"Крейтовая система LTR. Руководство пользователя\"](http://www.lcard.ru/download/ltr.pdf) ).
2. Выбрать используемый для этого канала диапазон измерения (поле @fieldref{TLTR24_CHANNEL_CONFIG,Range}).
3. Включить или выключить режим отсечки постоянной составляющей для дифференциального режима измерения с помощью поля @fieldref{TLTR24_CHANNEL_CONFIG,AC} (см. раздел @ref sect_gen_cfg_adc_ch_mode)
4. Для LTR24-2 для каждого канала с помощью поля @fieldref{TLTR24_CHANNEL_CONFIG,ICPMode} независимо выбирается, будут ли производиться измерения в дифференциальном режиме или с входа подключения ICP датчиков (см. раздел @ref sect_gen_cfg_adc_ch_mode). LTR24-1 поддерживает только дифференциальный режим.
5. Если канал настроен на ICP режим, то можно также настроить сопротивление подключенного к каналу ICP датчика, если необходима дополнительная коррекция данных, как описано в разделе @ref sec_sensor_rout. Задается полем @fieldref{TLTR24_CHANNEL_CONFIG,SensorROut}.

Режим работы каждого канала{#sect_gen_cfg_adc_ch_mode}
------------------------------------------------------------
Полностью режим работы каждого канала определяется на основе комбинации значений нескольких полей: поля @fieldref{TLTR24,TestMode} описателя модуля, общего для всех каналов, и полей @fieldref{TLTR24_CHANNEL_CONFIG,AC} и @fieldref{TLTR24_CHANNEL_CONFIG,ICPMode} каждого канала.
Результирующий режим работы канала при каждой комбинации значений данных полей приведен в таблице:

|TestMode |ICPMode | AC  | Режим
|---------|--------|-----|-----------------------------------------------------
|FALSE    |FALSE   |FALSE| Дифференциальный вход без отсечки постоянной составляющей
|FALSE    |FALSE   |TRUE | Дифференциальный вход с отсечкой постоянной составляющей
|FALSE    |TRUE    |X    | Режим ICP-вход 
|TRUE     |FALSE   |X    | Режим измерения собственного нуля
|TRUE     |TRUE    |X    | Режим «ICP-тест»

Формат данных модуля{#sec_gen_cfg_fmt} 
---------------------------
Модуль поддерживает передачу отсчетов в двух разных форматах: 20-битном и 24-битном. Использование 24-битного формата данных увеличивает точность представления данных, но и в 2 раза увеличивает поток данных от модуля, что ограничивает количество разрешенных каналов на высоких частотах сбора  (см. [\"Крейтовая система LTR. Руководство пользователя\"](http://www.lcard.ru/download/ltr.pdf) ), а также увеличивает и общих поток данных от крейта, что также ограничивает возможное число одновременно используемых модулей в связи с ограничением скорости самого крейта. 

Также дополнительным преимуществом 24-битного режима является возможность отслеживания перегрузки разрядной сетки АЦП. Признак перегрузки передается с каждым отсчетом и анализируется при обработке данных (см. раздел @ref sec_proc_ovld).


 Прием и обработка данных{#sec_proc}
 ==========================================================
 Прием и обработка данных осуществляется таким же образом, как и во многих других модулях LTR. 
 
 После запуска сбора модуль начинает непрерывно выполнять преобразования с заданной частотой и передавать отсчеты в виде слов специального формата, специфичного для системы LTR. Отсчеты передаются в виде кадров, где каждый кадр соответствует одному отсчету от каждого разрешенного канала. Сперва передается 
 
 В программе необходимо сперва выполнить прием сырых данных от модуля в виде 32-битных слов специального формата с помощью LTR24_Recv(), после чего эти данные передаются в LTR24_ProcessData() для проверки их корректности, калибровки и перевода в Вольты. Обработка выполняется всегда над целым числом кадров. При этом следует учесть, что в зависимости от выбранного [формата](@ref e_LTR24_FORMATS) одному отсчету соответствует либо одно, либо два принятых слова.
 
 Ниже описаны некоторые особенности обработки данных с помощью LTR24_ProcessData(), которые специфичны для данного модуля.

 
 Анализ признака перегрузки разрядной сетки АЦП{#sec_proc_ovld}
----------------------------------------------------------------------
 Модуль LTR24 поддерживает обнаружение перегрузки разрядной сетки АЦП. Если в модуле настроен 24-битный формат данных, то вместе с каждым отсчетом передается признак возникновения перегрузки. Функция обработки данных принимает дополнительным параметром массив ovload логических значений, который должен быть таким же размером как результирующий массив данных, в который функция сохранит для каждого выходного отсчета извлеченный признак наличия перегрузки (в том же порядке, как и выходные отсчеты). 
 
 При использовании 20-битного режима данный признак не передается и если передан в функцию массив ovload, то он будет всегда заполнен признаком отсутствия перегрузки.

Калибровка данных{#sect_gen_cbr}
---------------------------------------------------------------------------

При передачи флага #LTR24_PROC_FLAG_CALIBR функция LTR24_ProcessData() выполняет калибровку модуля. Калибровка выполняется на основе двух коэффициентов (смещения и шкалы) по формуле: \f$ Y = (X + Offset)*Gain \f$, где X --- отсчет АЦП (20 или 24-битный), Y --- калиброванные данные, Offset --- смещение шкалы (деленное на 16 в 20-битном режиме), а Gain --- коэффициент шкалы. 

Заводские калибровочные коэффициенты индивидуальные для каждого модуля хранятся в энергонезависимой памяти модуля, что позволяет учесть особенности конкретного модуля (из-за разброса значений элементов). Используются свои коэффициенты для каждого канала, диапазона и каждой возможной частоты АЦП модуля.

Коэффициенты считываются из энергонезависимой памяти модуля при вызове LTR24_GetConfig(). Прочитанные коэффициенты записываются в массив @fieldref{TLTR24_MODULE_INFO,CalibCoef} структуры с информацией о модуле (поле @fieldref{TLTR24,ModuleInfo}), так и в массив @fieldref{TLTR24,CalibCoef} самого описателя модуля. Первые используются исключительно для информационных целей, а вторые непосредственно применяются при вызове LTR24_ProcessData() с флагом #LTR24_PROC_FLAG_CALIBR. 

Коррекция АЧХ{#sec_gen_afc_cor}
------------------------------------------------------------------------------
В библиотеке реализована возможность выполнения коррекции амплитудно-частотной характеристики (АЧХ) модуля. Для этого в функцию LTR24_ProcessData() должен быть передан флаг #LTR24_PROC_FLAG_AFC_COR_EX (должен использоваться в новых приложениях) или #LTR24_PROC_FLAG_AFC_COR (оставлен для обратной совместимости).

Для всех диапазонов и частот может выполняться корректировка наклона АЧХ с помощью КИХ-фильтра второго порядка в соответствии с методом, описанным в статье [Метод тонкой коррекции наклона АЧХ с помощью простого цифрового фильтра](http://www.lcard.ru/download/simple_fir_filter.pdf).

Кроме того, при использовании частот АЦП 39.0625 кГц и ниже может выполняться дополнительная корректировка неравномерности АЧХ самой микросхемы АЦП. Изначально данная корректировка выполнялась с помощью БИХ-фильтра 2-го порядка, однако данный фильтр искажает фазу сигнала на высоких частотах, что может быть неприемлемо для некоторых применений. В связи с этим данная компенсация была реализована в новой версии библиотеки с помощью линейного КИХ-фильтра.  Для сохранения совместимости со старыми приложениями, которые могли бы учитывать особенности фильтрации, при передачи флага #LTR24_PROC_FLAG_AFC_COR продолжает использоваться БИХ-фильтр, в то время как для использования нового фильтра необходимо указать новый флаг #LTR24_PROC_FLAG_AFC_COR_EX, использование которого рекомендуется для новых приложений.


Коррекция фазы{#sec_sensor_pha_cor}
------------------------------------------------------------------------------
RC цепь ICP-входа модуля LTR24-2 приводит к сдвигу фаз на малых частотах входного сигнала. Для задач, где важны фазы сигнала, этот сдвиг может быть неприемлем. В библиотеке реализован  фазовый фильтр для коррекции этого сдвига, описанный в статье ["Фазовый корректор дифференцирующей RC-цепи"](http://www.lcard.ru/download/articles/iir_phase_corrector.pdf).

По умолчанию данный фильтр не применяется для обеспечения совместимости со старыми программами, которые могли учитывать сдвиг фаз модуля самостоятельно.  Для применения этого фильтра к выходным данным необходимо передать флаг #LTR24_PROC_FLAG_ICP_PHASE_COR. Данный флаг влияет только на обработку данных от каналов работающих в ICP-режиме, т.к. дифференциальный вход не вносит данного искажения фазы.

Для расчета фильтра по умолчанию используются коэффициенты, рассчитанные исходя из фазового сдвига при номинальных значениях RC-цепи. В случае, если была проведена калибровка фазового сдвига, то коэффициенты фильтра рассчитываются на основании записанного во Flash-память модуля смещения фазы, что позволяет дополнительно учесть разброс элементов (в первую очередь емкости) цепи соответствующего канала.


Учет выходного сопротивления датчика{#sec_sensor_rout}
------------------------------------------------------------------------------

За счет взаимодействия выходного сопротивления ICP-датчика и входного сопротивления ICP-входа модуля образуется делитель, на котором происходит падение измеряемого напряжения с датчика. 

Коэффициент передачи этого делителя составляет \f$ K = \frac{R_{in}}{R_{in} + R_{out}} \f$, где \f$ R_{in} \f$ --- входное сопротивление ICP канала модуля LTR24 , а \f$ R_{out} \f$ --- выходное сопротивление подключенного ко входу датчика, которое также может учитывать при необходимости сопротивление проводов подключения датчика. Для модулей с расширенной полосой пропускания в области нижних частот (установлен флаг #LTR24_FEATURE_ICP_EXT_BANDWIDTH_LF в информации о модуле) входное сопротивление составляет 110 кОм, в то время как для старых модулей это сопротивление составляет 25,5 кОм.

В большинстве случаев это падение значительно меньше точности используемого датчика и им можно пренебречь, но если используется датчик, точность которого и значение выходного сопротивления таковы, что указанное падение напряжения может видимым образом влиять на результат и если для подключаемого датчика явно указано выходное сопротивление, то его можно явно учесть средствами библиотеки. Для этого необходимо во время конфигурации модуля (до вызова LTR24_SetADC())  в  структуре конфигурации соответствующего канала установить в поле [SensorROut](@ref TLTR24_CHANNEL_CONFIG::SensorROut)  значение выходного сопротивления датчика. Если значение этого поля больше нуля, то функция LTR24_ProcessData() корректирует результат для компенсации указанного падения.

В случае подключения к ICP-входу преобразователь [LPW25](http://www.lcard.ru/products/accesories/lpw25) способ учета его выходного сопротивления описан в его [Руководстве программиста](http://www.lcard.ru/download/lpw25api.pdf).
