/*
 * pgp.c
 *
 *  Created on: 12.03.2010
 *      Author: borisov
 */

#include "lcrypt/pgp.h"


/****************************************************************************************************
 *  Функция выполняет анализ формата, в котором PGP сохраняет цифровую подпись
 *  Параметры:
 *  	msg         - (in)  массив с данными в формате подписи PGP
 *  	size        - (in)  размер массива msg (должен быть равен SIGN_MSG_SIZE)
 *  	start_hash  - (out) 5 байт участвующих в рассчете hash-функции
 *  	left_sig    - (out) 2 байта - младшие 16 бит подписи (для быстрой проверки)
 *  	sign        - (out) в данном массиве возвращается непосредственно сама цифровая подпись
 *  Возвращаемое значение
 *      Код ошибки
 * ************************************************************************************************* */
int PGP_SignAnalys(uint8_t* msg, uint32_t size, uint8_t* start_hash, uint8_t* left_sig, uint8_t* sign)
{
	int res = 0,i;

	if ((msg==NULL) || (size != SIGN_MSG_SIZE))
		res = LCRYPT_ERR_PGP_SIGN_FORMAT;
	if ((msg[0]!=0x89) || (msg[1]!=0x01) || (msg[2]!=0x15) || (msg[3]!=0x3) || (msg[4]!=0x5))
		res = LCRYPT_ERR_PGP_SIGN_FORMAT;
	//копируем 5 байт участвующих в рассчете hash-функции, если указатель не NULL
	if ((res == 0) && (start_hash!=NULL))
	{
		for (i=0; i < msg[4]; i++)
			start_hash[i] = msg[5+i];
	}

	if ((res == 0) && (msg[18]!=ASYNC_ALG_RSA))
		res = LCRYPT_ERR_PGP_SIGN_UNSUPPORT_CRYPT_ALG;
	if ((res == 0) && (msg[19]!=HASH_ALG_SHA256))
		res = LCRYPT_ERR_PGP_SIGN_UNSUPPORT_HASH_ALG;

	if ((res==0) && (left_sig!=NULL))
	{
		left_sig[0] = msg[20]; left_sig[1] = msg[21];
	}

	if (res==0)
	{
		size = (((msg[22] << 8) + msg[23]) + 7)/8;
		if (size==SIGN_SIZE)
		{
			for (i=0; i < SIGN_SIZE; i++)
				sign[i] = msg[SIGN_SIZE + 23 - i];
		}
		else
			res = LCRYPT_ERR_PGP_SIGN_FORMAT;
	}

	return res;
}

//__attribute__ ((section(".flash_data")))
const uint8_t SHA256_ASN[] = {0x30, 0x31, 0x30, 0x0d, 0x06, 0x09, 0x60, 0x86, 0x48, 0x01, 0x65, 0x03, 0x04, 0x02, 0x01, 0x05, 0x00, 0x04, 0x20};

