/*
 * pgp.h
 *
 *  Created on: 12.03.2010
 *      Author: borisov
 */

#ifndef PGP_H_
#define PGP_H_

#include "stdint.h"
#include "lcrypt_defs.h"

#define SIGN_MSG_SIZE      (280)
#define SIGN_SIZE          (256)

//коды алгоритмов асинхронного шифрования
#define ASYNC_ALG_RSA      (1)

//коды алгоритмов подписи
#define HASH_ALG_SHA256    (8)

#define PGP_END_HASH_SIZE  (5)


#define SHA256_ASN_SIZE (19)

int PGP_SignAnalys(uint8_t* msg, uint32_t size, uint8_t* end_hash, uint8_t* left_sig, uint8_t* sign);

extern const uint8_t SHA256_ASN[SHA256_ASN_SIZE];

#endif /* PGP_H_ */
