#include "lclock_arch.h"

static char f_initialized = 0;


char lclock_is_initialized(void) {
    return f_initialized;
}

void lclock_init_val(t_lclock_ticks init_val) {
    chip_per_clk_en(CHIP_PER_CLK_NUM_SYSCTR);
    CHIP_REGS_SYSCTR_CTRL->CNTCR = 0;
    CHIP_REGS_SYSCTR_CTRL->CNTCV0 = init_val & 0xFFFFFFFFUL;
    CHIP_REGS_SYSCTR_CTRL->CNTCV1 = (init_val >> 32) & 0xFFFFFFFFUL;
    CHIP_REGS_SYSCTR_CTRL->CNTCR = CHIP_REGFLD_SYSCTR_CNTCR_EN | CHIP_REGFLD_SYSCTR_CNTCR_FCR(0);
    f_initialized = 1;
}

void lclock_disable(void) {
    CHIP_REGS_SYSCTR_CTRL->CNTCR = 0;
    chip_per_clk_dis(CHIP_PER_CLK_NUM_SYSCTR);
    f_initialized = 0;
}

t_lclock_ticks lclock_get_ticks(void) {
    chip_isb();
    uint32_t h1 = CHIP_REGS_SYSCTR_CTRL->CNTCV1;
    uint32_t l = CHIP_REGS_SYSCTR_CTRL->CNTCV0;
    uint32_t h2 = CHIP_REGS_SYSCTR_CTRL->CNTCV1;
    if ((h2 != h1) && (l > 0x80000000U)) {
        h2 = h1;
    }
    return ((uint64_t)h2 << 32) | l;
}
