#include "chip.h"
#include "lclock_arch.h"



void lclock_init_val(t_lclock_ticks init_val) {
    uint32_t l = init_val & 0xFFFFFFFF;
    uint32_t h = (init_val >> 32) & 0xFFFFFFFF;

    if (l < 0xE0000000) {
        CHIP_REGS_MCHTMR->MTIME.l = l;
        CHIP_REGS_MCHTMR->MTIME.h = h;
    } else {
        CHIP_REGS_MCHTMR->MTIME.l = 0;
        CHIP_REGS_MCHTMR->MTIME.h = h;
        CHIP_REGS_MCHTMR->MTIME.l = l;
    }
}

t_lclock_ticks lclock_get_ticks(void) {
    return CHIP_REGS_MCHTMR->MTIME.val64;
}
