#include "chip.h"
#include "lclock_arch.h"



void lclock_init_val(t_lclock_ticks init_val) {
    CHIP_REGS_STK->CTLR = 0;
    CHIP_REGS_STK->CNTH = (init_val >> 32) & 0xFFFFFFFF;
    CHIP_REGS_STK->CNTL = init_val & 0xFFFFFFFF;
    CHIP_REGS_STK->CTLR |= CHIP_REGFLD_STK_CTLR_STE;
}

t_lclock_ticks lclock_get_ticks(void) {
    uint32_t h = CHIP_REGS_STK->CNTH;
    uint32_t l = CHIP_REGS_STK->CNTL;
    uint32_t h2 = CHIP_REGS_STK->CNTH;
    return ((uint64_t)h << 32) | l;
}
