#ifndef TEDSWRITERDEVCEDETECTOR_H
#define TEDSWRITERDEVCEDETECTOR_H

#include <QObject>
#include <QTimer>
#include "TedsWriterDevice.h"

class TedsWriterDevceDetector : public QObject {
    Q_OBJECT
public:
    explicit TedsWriterDevceDetector(QObject *parent = nullptr);

    void start();

    TedsWriterDevice &device() {return m_dev;}
Q_SIGNALS:
    void connectionStatusChanged(bool connected);
    void tedsMemStatusChanged(bool detected);
private Q_SLOTS:
    void checkDevice();
private:
    bool m_connected {false};
    bool m_teds_detected {false};
    QTimer m_checkTmr;
    TedsWriterDevice m_dev;
};

#endif // TEDSWRITERDEVCEDETECTOR_H
