#ifndef TEDSWRITERDEVICE_H
#define TEDSWRITERDEVICE_H

#include "UsbDevice.h"
#include "TedsWriterDeviceInfo.h"

class TedsWriterDevice {
public:
    TedsWriterDevice();

    void detect(LQError &err);
    void close();
    bool checkTedsPresent(LQError &err);

    void writeTedsData(quint16 addr, const QByteArray &data, LQError &err);
    void readTedsData(quint16 addr, quint16 len, QByteArray &data, LQError &err);

    const TedsWriterDeviceInfo &info() const {return m_info;}
private:
    void ctlReqTx(quint8 req, quint16 wValue, quint16 wIndex, const QByteArray &data, LQError &err);
    void ctlReqRx(quint8 req, quint16 wValue, quint16 wIndex, quint16 reqLen, QByteArray &data, LQError &err);
    void getDevError(LQError &err);

    void readInfo(LQError &err);


    static constexpr int max_dev_string_len {256};

    UsbDevice m_dev;
    TedsWriterDeviceInfo m_info;
};

#endif // TEDSWRITERDEVICE_H
