#include "TedsWriterDeviceErrors.h"
#include "teds_writer_proto.h"

LQError TedsWriterDeviceErrors::error(int code, const QString &msg) {
    static const QString err_type {QStringLiteral("tedswrtr")};
    return LQError{code, msg, err_type};
}

LQError TedsWriterDeviceErrors::devError(quint32 code) {
    return code == 0 ? LQError::Success() : error(code, tr("Ошибка устройства TedsWriter с кодом %1: %2").arg(code).arg(devErrorString(code)));
}

QString TedsWriterDeviceErrors::devErrorString(quint32 code) {
    return code == TEDSWRTR_ERR_INVALID_REQ_TYPE ? tr("Неверный тип USB запроса") :
           code == TEDSWRTR_ERR_INVALID_REQ_PARAM ? tr("Неверный праметр USB запроса") :
           code == TEDSWRTR_ERR_OW_LINE_LOW ? tr("Постоянный нулевой уровень на однопроводной шине") :
           code == TEDSWRTR_ERR_OW_NO_PRESENT_RESP ? tr("Не обанаружен признак наличия устройства на однопроводной шине") :
           code == TEDSWRTR_ERR_OW_IDROM_CRC ? tr("Ошибка контрольной суммы идентификационных данных устройства на однопроводной шине") :
           code == TEDSWRTR_ERR_OWFLASH_NOT_DETECTED ? tr("Не подключена микросхема TEDS-памяти") :
           code == TEDSWRTR_ERR_OWFLASH_EXCH_ERROR   ? tr("Ошибка при обмене информацией по одновпроводной шине") :
           code == TEDSWRTR_ERR_OWFLASH_INVALID_ADDR ? tr("Неверный адрес TEDS-памяти") :
           code == TEDSWRTR_ERR_OWFLASH_INVALID_SIZE ? tr("Неверный размер данных TEDS-памяти") :
           code == TEDSWRTR_ERR_OWFLASH_WR_ADDR_ALIGN ? tr("Адрес записи в TEDS-память не выравнен на размер строки") :
           code == TEDSWRTR_ERR_OWFLASH_WR_STATUS ? tr("Неверное значение регистра статауса TEDS-памяти") :
           code == TEDSWRTR_ERR_OWFLASH_WR_DATA_CHECK ? tr("Ошибка проверки записанных данных в TEDS-память") :
           code == TEDSWRTR_ERR_OWFLASH_WR_DONE_ACK  ? tr("Неверное подтверждение завершения записи в TEDS-память") :
                                                       tr("Неизвестный код ошибки");
}
