#include "UsbDeviceErrors.h"
#include <QString>
#include <QStringBuilder>
#include "libusb-1.0/libusb.h"


LQError UsbDeviceErrors::error(int code, const QString &msg) {
    static const QString err_type {QStringLiteral("usbdev")};
    return LQError{code, msg, err_type};
}

LQError UsbDeviceErrors::devNotDetected() {
    return error(-1, tr("Устройство не обнаружено"));
}

LQError UsbDeviceErrors::devNotOpened() {
    return error(-2, tr("Не установлена связь с USB устройством "));
}

LQError UsbDeviceErrors::devOpen(int err_code) {
    return libUsbError(-3, tr("Ошибка открытия USB устройства"), err_code);
}

LQError UsbDeviceErrors::devIfaceClaim(int err_code) {
    return libUsbError(-4, tr("Ошибка запроса интерфейса USB устройства"), err_code);
}

LQError UsbDeviceErrors::devCtlReqFailed(int req_code, int err_code) {
    return libUsbError(-5, tr("Ошибка выполнения управляющего запроса %1 для USB устройства").arg(req_code), err_code);
}

LQError UsbDeviceErrors::devCtlReqInsufSize(int req_code, int req_size, int done_size) {
        return error(-6, tr("Управляющий запрос %1 к USB-устройству завершен с недостаточным количеством полученных данных (запрашивалось %2, получено %3)")
                     .arg(req_code).arg(req_size).arg(done_size));
}

LQError UsbDeviceErrors::libUsbError(int base_err, const QString &text, int err_code) {
    return error(base_err, text % QLatin1String(": ") %
                 tr("Ошибка библиотеки error %1 - %2").arg(err_code).arg(QString::fromLatin1(libusb_error_name(err_code))));
}

