#include "TedsWriterInfoWidget.h"
#include "ui_TedsWriterInfoWidget.h"
#include "Device/TedsWriterDeviceInfo.h"
#include "Device/TedsWriterDevice.h"

TedsWriterInfoWidget::TedsWriterInfoWidget(QWidget *parent) :
    TedsWriterDevBaseWidget{parent},
    m_ui{new Ui::TedsWriterInfoWidget} {
    m_ui->setupUi(this);
}

TedsWriterInfoWidget::~TedsWriterInfoWidget() {

}

void TedsWriterInfoWidget::devStateUpdate(bool connected) {
    setEnabled(connected);
    if (connected) {
        showInfo(device().info());
    } else {
        clear();
    }
}

void TedsWriterInfoWidget::showInfo(const TedsWriterDeviceInfo &info) {
    m_ui->fwName->setText(info.fwName());
    m_ui->fwVersion->setText(info.fwVersion());
    m_ui->fwAuthor->setText(info.fwAuthor());
    m_ui->organization->setText(info.organization());
    m_ui->burnDate->setText(info.burnDate().toString(QStringLiteral("hh:mm:ss dd.MM.yyyy")));
    m_ui->fwHash->setText(info.fwHashText());
}

void TedsWriterInfoWidget::clear() {
    m_ui->fwName->clear();
    m_ui->fwVersion->clear();
    m_ui->fwAuthor->clear();
    m_ui->organization->clear();
    m_ui->burnDate->clear();
    m_ui->fwHash->clear();
}
