#ifndef PORTLOADER_H
#define PORTLOADER_H

#include <QObject>
#include "protocol/BurnDeviceInfo.h"
class LQError;
class ProgressLog;
class BurnProtocol;

class PortLoader : public QObject {
    Q_OBJECT
public:
    PortLoader();
    ~PortLoader();

    void init(BurnProtocol &proto, LQError &err, ProgressLog &log);
    void cleanup(LQError &err, ProgressLog &log);
    void burn(const QString &filename, LQError &err, ProgressLog &log);
    void startApp(LQError &err, ProgressLog &log);
private:
    void checkDev(LQError &err, ProgressLog &log);

    BurnProtocol *m_proto {nullptr};


    BurnDeviceInfo m_devinfo;
    burn_mem_addr_t m_boot_addr {0x08000000};
};

#endif // PORTLOADER_H
