#include "PortLoaderErrors.h"


LQError PortLoaderErrors::error(int code, const QString &msg) {
    static const QString err_type {QStringLiteral("loader")};
    return LQError{code, msg, err_type};
}



LQError PortLoaderErrors::fileError(QFileDevice::FileError err_code) {
    return error(-3, tr("file error %1").arg(err_code));
}
