#ifndef PROGRESSLOG_H
#define PROGRESSLOG_H

#include <QString>
#include <QtGlobal>
class LQError;

class ProgressLog {
public:
    virtual void printDbg(const QString &msg, bool flush = true) = 0;
    virtual void printDbgLine(const QString &msg) = 0;
    virtual void printProgress(qint64 done, qint64 total) = 0;
    virtual void printError(const QString &msg, const LQError &err) = 0;
};

#endif // PROGRESSLOG_H
