#ifndef BURNDEVICEINFO_H
#define BURNDEVICEINFO_H

#include <QString>
#include <QList>

typedef uint32_t burn_mem_addr_t;

class BurnMemArea {
public:
    explicit  BurnMemArea(burn_mem_addr_t addr, burn_mem_addr_t size) :
        m_start_addr{addr}, m_size{size} {
    }

    unsigned startAddr() const {return m_start_addr;}
    unsigned size() const {return m_size;}
    unsigned lastAddr() const {return m_start_addr + m_size - 1;}
    unsigned nextAddr() const {return m_start_addr + m_size;}


private:
    burn_mem_addr_t m_start_addr;
    burn_mem_addr_t m_size;
};


class BurnDeviceTypeInfo {
public:
    explicit  BurnDeviceTypeInfo(const QString &name, QList<BurnMemArea> flash_banks) :
        m_name{name}, m_flash_bank_addrs{flash_banks} {

    }

    const QString &typeName() const {return m_name;}
    burn_mem_addr_t defaultBootAddr() const {return m_flash_bank_addrs.at(0).startAddr();}
private:
    QString m_name;
    QList<BurnMemArea> m_flash_bank_addrs;
};


class BurnDeviceInfo {
public:
    explicit  BurnDeviceInfo();

    const QString &bootloaderVersion() const {return m_bootldr_ver;}
    bool devTypeInfoValid() const {return m_dev_type_info != nullptr;}
    const BurnDeviceTypeInfo &devTypeInfo() const {return *m_dev_type_info;}

    void setBootloaderVersion(const QString &ver) {m_bootldr_ver = ver;}
    void setDevTypeInfo(const BurnDeviceTypeInfo &info) {m_dev_type_info = &info;}

    void clear();
private:
    QString m_bootldr_ver;
    const BurnDeviceTypeInfo *m_dev_type_info {nullptr};
};

#endif // BURNDEVICEINFO_H
