#ifndef BURNPROTOCOL_H
#define BURNPROTOCOL_H

#include "BurnDeviceInfo.h"
class LQError;
class QString;
class BurnPort;
class BurnDeviceInfo;
class ProgressLog;

/* общий интерфейс к протоколу обновления проишвки устройства */
class BurnProtocol {
public:
    virtual ~BurnProtocol();
    /* строка-идентификатор протокола для его выбора */
    virtual QString protoclolId() const = 0;

    /* максимальные размеры на чтение и запись данных */
    virtual int maxReadBlockSize() const = 0;
    virtual int maxWriteBlockSize() const = 0;
    virtual bool supportDevInfo() const = 0;

    virtual void detect(LQError &err) = 0;
    /* чтение информации о подклюученном устройстве */
    virtual void getDevInfo(BurnDeviceInfo &info, LQError &err) = 0;
    /* полная очистка подключенного устройства (стирание всей памяти, снятие защит записи) */
    virtual void devCleanup(burn_mem_addr_t start_addr, LQError &err) = 0;
    /* запись блока данных в память. Размер определяется по размеру data и не должен быть больше maxWriteBlockSize() */
    virtual void writeMemBlock(burn_mem_addr_t addr, const QByteArray &data, LQError &err) = 0;
    /* чтение блока данных из памяти заданного размера.  Размер не должен быть больше maxReadBlockSize() */
    virtual void readMemBlock(burn_mem_addr_t addr, int size, QByteArray &data, LQError &err) = 0;
    /* запуск приложения с указанного адреса */
    virtual void startApp(burn_mem_addr_t addr, LQError &err) = 0;
};

#endif // BURNPROTOCOL_H
