#include "BurnProtocolDfuErrors.h"


LQError BurnProtocolDfuErrors::error(int code, const QString &msg) {
    static const QString err_type {QStringLiteral("dfuproto")};
    return LQError{code, msg, err_type};
}

LQError BurnProtocolDfuErrors::devNotSet() {
    return error(-1, tr("Protocol device doesn't set"));
}

LQError BurnProtocolDfuErrors::unexpectedDevState(DfuDevice::State expState, DfuDevice::State devState) {
    return error(-2, tr("Unexpected DFU device state (expected %1, device %2)")
                 .arg(static_cast<int>(expState)).arg(static_cast<int>(devState)));
}

LQError BurnProtocolDfuErrors::opExecTimeout() {
    return error(-3, tr("Device operation execution timeout"));
}

LQError BurnProtocolDfuErrors::invalidDataSize() {
    return error(-4, tr("Invalid data block size"));
}
