#ifndef BURNPROTOCOLDFUSTM32_H
#define BURNPROTOCOLDFUSTM32_H

#include "../BurnProtocolDfu.h"

/* Реализация протокола загрузки STM-микроконтроллеров по USB интерфейсу
 * в соответствии с Application Note AN3156 */
class BurnProtocolDfuSTM32 : public BurnProtocolDfu {
public:
    QString protoclolId() const override;
    int maxReadBlockSize() const override;
    int maxWriteBlockSize() const override;
    bool supportDevInfo() const override {return false;}

    void detect(LQError &err) override;
    void getDevInfo(BurnDeviceInfo &info, LQError &err) override;
    void devCleanup(burn_mem_addr_t start_addr, LQError &err) override;
    void writeMemBlock(burn_mem_addr_t addr, const QByteArray &data, LQError &err) override;
    void readMemBlock(burn_mem_addr_t addr, int req_size, QByteArray &data, LQError &err) override;
    void startApp(burn_mem_addr_t addr, LQError &err) override;


private:
    void getCommandList(QByteArray &commands, LQError &err);
    void setAddrPointer(quint32 addr, LQError &err);
    void eraseChip(LQError &err);
    void erasePage(burn_mem_addr_t addr, LQError &err);
    void readUnprotect(LQError &err);

    void getStatusCheck(DfuDevice::State expState, LQError &err);
    void waitRdy(DfuDevice::StatusInfo &si, unsigned tout, LQError &err);
    void execBsyOp(unsigned tout, LQError &err);

    void startWrOp(LQError &err);
    void startRdOp(LQError &err);

    QByteArray m_sup_cmds;
    static const unsigned mass_erase_tout   {10000};
    static const unsigned page_erase_tout   {1000};
    static const unsigned mem_write_tout    {1000};
    static const unsigned set_addr_tout     {1000};
    static const unsigned reboot_wait_tout  {5000};
};

#endif // BURNPROTOCOLDFUSTM32_H
