#include "STM32BurnProtocolErrors.h"
#include "LQError.h"

LQError STM32BurnProtocolErrors::error(int code, const QString &msg) {
    static const QString err_type {QStringLiteral("stm32-proto")};
    return LQError{code, msg, err_type};
}

LQError STM32BurnProtocolErrors::autobaudNoResponse() {
    return error(-1, tr("no device autobaud response"));
}

LQError STM32BurnProtocolErrors::autobaudInvalidResponse(quint8 resp) {
    return error(-2, tr("invalid device autobaud response (0x%1)").arg(resp, 2, 16, QChar{'0'}));
}

LQError STM32BurnProtocolErrors::cmdNoResponse() {
    return error(-3, tr("no device response for command"));
}

LQError STM32BurnProtocolErrors::cmdRejected() {
    return error(-4, tr("command was rejected (NACK) by device"));
}

LQError STM32BurnProtocolErrors::cmdRejectedRDP() {
    return error(-5, tr("command was rejected (NACK) by device (probably readout protection is enabled)"));
}

LQError STM32BurnProtocolErrors::cmdInvalidResponse(quint8 resp) {
    return error(-6, tr("invalid command response (0x%01)").arg(resp, 2, 16, QChar{'0'}));
}

LQError STM32BurnProtocolErrors::cmdDataNoAck() {
    return error(-7, tr("no device acknowledge for command data"));
}

LQError STM32BurnProtocolErrors::cmdDataRejected() {
    return error(-8, tr("command data was rejected (NACK) by device"));
}

LQError STM32BurnProtocolErrors::cmdDataInvalidAck(quint8 resp) {
    return error(-9, tr("invalid command data acknowledge (0x%01)").arg(resp, 2, 16, QChar{'0'}));
}

LQError STM32BurnProtocolErrors::cmdInsufRespData() {
    return error(-10, tr("insufficient data received in command response"));
}

LQError STM32BurnProtocolErrors::cmdInvalidRespDataSize() {
    return error(-11, tr("invalid command response data size"));
}

LQError STM32BurnProtocolErrors::unknowPID(quint16 pid) {
    return error(-12, tr("unknown device product ID (0x%1)").arg(pid, 4, 16, QChar{'0'}));
}

LQError STM32BurnProtocolErrors::invalidMemBlockSizeParam(int size) {
    return error(-13, tr("invalid memory block size paremeter value (%1)").arg(size));
}

LQError STM32BurnProtocolErrors::deviceUnsupOptsAccess() {
    return error(-14, tr("device type doesn't support options access"));
}
