#ifndef STM32BURNPROTOCOLERRORS_H
#define STM32BURNPROTOCOLERRORS_H

#include <QObject>
#include <QSerialPort>
#include "LQError.h"


class STM32BurnProtocolErrors : public QObject {
    Q_OBJECT
public:
    static LQError error(int code, const QString &msg);

    static LQError autobaudNoResponse();
    static LQError autobaudInvalidResponse(quint8 resp);
    static LQError cmdNoResponse();
    static LQError cmdRejected();
    static LQError cmdRejectedRDP();
    static LQError cmdInvalidResponse(quint8 resp);
    static LQError cmdDataNoAck();
    static LQError cmdDataRejected();
    static LQError cmdDataInvalidAck(quint8 resp);

    static LQError cmdInsufRespData();
    static LQError cmdInvalidRespDataSize();
    static LQError unknowPID(quint16 pid);
    static LQError invalidMemBlockSizeParam(int size);
    static LQError deviceUnsupOptsAccess();
};

#endif // STM32BURNPROTOCOLERRORS_H
