#ifndef TEDSWRITER_FW_SUFFIX_H
#define TEDSWRITER_FW_SUFFIX_H

#include <stdint.h>

#define TEDSWRTR_FW_SUFFIX_OFFSET         0xF000
#define TEDSWRTR_FW_SUFFIX_SIGN           0xA55A5642
#define TEDSWRTR_FW_SUFFIX_HASH_SIZE      32

typedef struct {
    uint32_t sign;        /* признак наличия сфиикса - должен быть равен TEDSWRTR_FW_SUFFIX_SIGN */
    uint32_t suffix_size; /* Общий размер информации в суффексе */
    uint32_t fw_size;   /* Размер прошивки */
    uint32_t reserved;  /* Резерв */
    uint64_t burn_date; /* Время записи прошивки (Unix-time) */
    uint8_t  hash[TEDSWRTR_FW_SUFFIX_HASH_SIZE]; /* SHA256 hash */
} t_tedswrtr_fw_suffix;



#endif // TEDSWRITER_FW_SUFFIX_H
