/* Copyright 2021, Ableton AG, Berlin. All rights reserved.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you would like to incorporate Link into a proprietary software application,
 *  please contact <link-devs@ableton.com>.
 */

#pragma once

#include <algorithm>
#include <cassert>
#include <vector>

namespace ableton
{
namespace link
{

template <typename It>
double median(It begin, It end)
{
  const auto n = std::distance(begin, end);
  assert(n > 2);
  if (n % 2 == 0)
  {
    std::nth_element(begin, begin + n / 2, end);
    std::nth_element(begin, begin + (n - 1) / 2, end);
    return (*(begin + (n / 2)) + *(begin + (n - 1) / 2)) / 2.0;
  }
  else
  {
    std::nth_element(begin, begin + n / 2, end);
    return *(begin + (n / 2));
  }
};

} // namespace link
} // namespace ableton
