# eduActiv8

**Educational Activities for Kids**


[![ko-fi](https://ko-fi.com/img/githubbutton_sm.svg)](https://ko-fi.com/eduactiv8)

eduActiv8 is a **free and open-source** collection of fun and interactive educational activities designed for children aged 3 and up. Our aim is to make learning engaging and accessible, covering a wide range of subjects with a primary focus on mathematics.

## Key Features

* **Wide Range of Activities:** Hundreds of short, interactive activities including flashcards, simulations, and interactive worksheets (drill exercises).
* **Multiple Subjects:** Primarily focused on basic maths concepts (numbers, operations, fractions, time, shapes, etc.) but also includes language exercises (alphabet, words) and general logic/memory games.
* **Learning Through Play:** Activities are designed to support learning by doing and moving virtual objects, making it more engaging for young learners.
* **Cross-Platform Compatibility:** Runs directly from source on Windows, macOS, and Linux. Compiled versions are also available for Windows and macOS for easy installation without dependencies.
* **Suitable for Early Years and Primary:** Ideal for children in the first six years of primary school and can be used by pre-schoolers with some guidance.
* **Customizable:** Offers experimental higher contrast modes and a theme editor for activity icons. Advanced users can customize displayed activities and difficulty levels by editing XML files.
* **Translated by the Community:** Available in multiple languages thanks to the contributions of volunteers worldwide. Help us translate at [https://app.transifex.com/eduactiv8/eduactiv8/](https://app.transifex.com/eduactiv8/eduactiv8/).
* **Award-Winning:** Recipient of the SourceForge Community Leader in 2025 and SourceForge Community Choice Award and Favorite Award (2022), and the All Digital School Editors' Pick Award (2020).
* **Free and Open Source:** Licensed under GPLv3, meaning it's free for anyone to use, share, and modify.

## Getting Started

### Installation

1.  **Compiled Version (Recommended for most users):**
    * Download the latest compiled version for Windows or macOS from [https://sourceforge.net/projects/eduactiv8](https://sourceforge.net/projects/eduactiv8).
    * Follow the installation instructions available at [https://www.eduactiv8.org/installation/](https://www.eduactiv8.org/installation/).

2.  **Running from Source (for developers or advanced users):**
    * Ensure you have Python and Pygame installed on your system.
    * Clone this repository: `git clone https://github.com/imiolek-ireneusz/eduActiv8.git`
    * Navigate to the project directory: `cd eduActiv8`
    * Run the application: `python eduactiv8.py`

### Alternative Installation (Linux Only)

For advanced Linux users, **eduActiv8** can also be run inside an [Apptainer](https://apptainer.org/) container.  
This approach allows you to build and run the application in a self-contained environment, which can be useful if you encounter dependency issues or wish to run it on different distributions.

For instructions, see:  
[`linux_extras/apptainer/README.md`](linux_extras/apptainer/README.md)

### Learn More

* **Project Website:** [https://www.eduactiv8.org](https://www.eduactiv8.org)
* **Facebook Page:** [http://www.facebook.com/eduactiv8](http://www.facebook.com/eduactiv8)
* **Installation Guide:** [https://www.eduactiv8.org/installation/](https://www.eduactiv8.org/installation/)

## Contributing

eduActiv8 is an open-source project, and contributions are welcome! Here's how you can help:

* **Translation:** Help us reach more children by translating the application into new languages at [https://app.transifex.com/eduactiv8/eduactiv8/](https://app.transifex.com/eduactiv8/eduactiv8/).
* **Bug Reports:** If you find any issues, please report them on the GitHub issue tracker.
* **Feature Requests:** Have an idea for a new activity or improvement? Feel free to suggest it!
* **Code Contributions:** If you're a developer, you can contribute code by submitting pull requests. Please follow the project's coding style and guidelines.
* **Testing:** Help us ensure the quality of the application by testing new features and releases.
* **Documentation:** Help improve the documentation for users and developers.

## Support

If you appreciate eduActiv8 and want to support its ongoing development and maintenance, you can buy me a virtual coffee:

[![ko-fi](https://ko-fi.com/img/githubbutton_sm.svg)](https://ko-fi.com/eduactiv8)

Thank you for your support!

## License

eduActiv8 is licensed under the [GNU General Public License v3.0](LICENSE)