# A helper program to add new keys to all language files at once.
# The key still have to be added to the default.py and default.pot

import os
import sys

os.chdir(os.path.abspath(os.path.dirname(sys.argv[0])))

# recreates the default.pot file removing all translated entries
def extract_untranslated_po_entries(filename):
    # Ensure the extracted directory exists
    os.makedirs("extracted", exist_ok=True)

    input_path = os.path.join(os.getcwd(), filename)
    output_filename = f"extracted_{filename}"
    output_path = os.path.join("extracted", output_filename)

    with open(input_path, 'r', encoding='utf-8') as infile:
        lines = infile.readlines()

    new_entries = []
    msgid = None
    msgstr = None
    collecting = False

    for line in lines:
        stripped = line.strip()
        if stripped.startswith('msgid'):
            msgid = line
            collecting = True
        elif stripped.startswith('msgstr') and collecting:
            msgstr = line
            if stripped == 'msgstr ""':
                new_entries.extend(['\n', msgid, msgstr])
            collecting = False

    with open(output_path, 'w', encoding='utf-8') as outfile:
        outfile.writelines(new_entries)

    print(f"Extracted untranslated entries saved to: {output_path}")

# Example usage:
# extract_untranslated_po_entries("my_translation.po")


if __name__ == "__main__":
    extract_untranslated_po_entries('kab.po')
    print("Done!")

"""
argv = sys.argv
if len(argv) == 2:
    line = argv[1]
else:
    print("Enter the line to be added to all files (or press ENTER to exit):")
    line = raw_input()

if len(line) > 2 and line not in ["exit", "exit()", "cancel", "cancel()"]:
    for i in range(len(langs)):
        FILE = langs[i]
        with open(FILE,"a") as f:
            f.write("\n"+line)
    print("Completed...")
else:
    print("Aborting...")
"""


# Example usage:
# extract_untranslated_po_entries('original.po', 'untranslated.po')
