# -*- coding: utf-8 -*-

import sys
import time
from classes.rtl.arabic_reshaper import ArabicReshaper

from classes.rtl.bidi.algorithm import get_display

configuration_old = {
    'delete_harakat': False,
    'support_ligatures': True,
    'RIAL SIGN': True,  # Replace ر ي ا ل with ﷼
}

configuration = {
    'delete_harakat': False,
    'support_ligatures': False,
    'RIAL SIGN': False,  # Replace ر ي ا ل with ﷼
}

reshaper = ArabicReshaper(configuration=configuration_old)


def unival(value):
    val = value
    if sys.version_info < (3, 0):
        try:
            if not isinstance(value, unicode):
                val = unicode(value, "utf-8")
        except UnicodeDecodeError:
            val = value
        except TypeError:
            val = value
    else:
        val = value
    return val

s2 = unival("testtesttest testtesttest testtesttest testtesttest testtesttest")
s = unival("قنديل البحر" + " " + "افعى الكوبرا" + "النمر المرقط")
rs = reshaper.reshape(s)
rv = get_display(rs)

list_size = 1000

def function_1():
    for i in range(list_size):
        rs = reshaper.reshape(s)
    print("function 1 completed")

def function_2():
    for i in range(list_size):
        gd = get_display(s)
    print("function 2 completed")

start = time.perf_counter()
function_1()
end = time.perf_counter()
elapsed_time = (end - start)
print("function_1 took", elapsed_time, "seconds")

start = time.perf_counter()
function_2()
end = time.perf_counter()
elapsed_time = (end - start)
print("function_2 took", elapsed_time, "seconds")
