/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef ButBarr_included
#define ButBarr_included


#include <QObject>
#include <QPushButton>
#include <QEvent>
#include <QPixmap>
//Added by qt3to4:
#include <QPaintEvent>
#include <QResizeEvent>
#include "ActButt.h"

#define maxH 40

class ButBarr : public QWidget
{
 Q_OBJECT
public:

  ButBarr( QWidget *parent=0 );
  virtual ~ButBarr();

  void SetDbType(int T);

signals:
  void LActSel(int type);
  void MActSel(int type);


public slots:
  void ButSel(int type, int butt);
  void Escape();
  
  void SetAct(QString s,int b);

protected:

  void resizeEvent ( QResizeEvent * e);
  void paintEvent( QPaintEvent * e);

private:

  void Arrange();
  int Cn(int i);

private:

 ActButton * AB[kNButt+1];
 int LAct;
 int MAct;

 int HistL[maxH+1];
 int HistM[maxH+1];

 int DbT;

};

#endif
