/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "ColSel.h"

#include <QPainter>
#include <QPushButton>
#include <QFont>
#include <QEvent>
#include <QTextStream>
#include <QFile>
//#include <qiodev.h>
#include <QPalette>
//#include <qscrbar.h>
//Added by qt3to4:
#include <QMouseEvent>
#include <QPaintEvent>

#include <stdio.h>
#include "Error.h"


ColSel::ColSel(QColor col, QWidget *parent)
 :QDialog( parent)
{
  Col=col;
  Build();
}

ColSel::ColSel( QWidget *parent)
 :QDialog( parent )
{
//  pix=Col.alloc();
  Col.setRgb(0,0,0);
  Build();
}


void ColSel::Build()
{
 setMinimumSize( 300, 300 );
 setMaximumSize( 300, 300 );

 Col.getHsv(&H,&S,&V);

 int r,g,b;
 Col.getRgb(&r,&g,&b);

 QPushButton* Ok;
 Ok = new QPushButton( "OK", this);
 Ok->setGeometry( 215, 265, 75, 30 );
 Ok->setFont( QFont( "Times", 14, QFont::Bold ) );
 connect( Ok, SIGNAL(clicked()),this, SLOT(End()) );

 QPushButton* Ca;
 Ca = new QPushButton( "Cancel", this);
 Ca->setGeometry( 125, 265, 75, 30 );
 Ca->setFont( QFont( "Times", 14, QFont::Bold ) );
 connect( Ca, SIGNAL(clicked()),this, SLOT(accept()) );

 SR=new QScrollBar(Qt::Vertical,this);
 SR->setRange(0,255);
 SR->setPageStep(25);
 SR->setSliderPosition(255-r);
 SR->setGeometry(270,130,20,130);
 SR->setGeometry(120,130,20,130);
 connect(SR,SIGNAL(valueChanged(int)),this, SLOT(SetR(int)));

 SG=new QScrollBar(Qt::Vertical,this);
 SG->setRange(0,255);
 SG->setPageStep(25);
 SG->setSliderPosition(255-g);
 SG->setGeometry(270,130,20,130);
 SG->setGeometry(150,130,20,130);
 connect(SG,SIGNAL(valueChanged(int)),this, SLOT(SetG(int)));

 SB=new QScrollBar(Qt::Vertical,this);
 SB->setRange(0,255);
 SB->setPageStep(25);
 SB->setSliderPosition(255-b);
 SB->setGeometry(270,130,20,130);
 SB->setGeometry(180,130,20,130);
 connect(SB,SIGNAL(valueChanged(int)),this, SLOT(SetB(int)));

 SH=new QScrollBar(Qt::Vertical,this);
 SH->setRange(0,360);
 SH->setPageStep(25);
 SH->setSliderPosition(360-H);
 SH->setGeometry(270,130,20,130);
 SH->setGeometry(210,130,20,130);
 connect(SH,SIGNAL(valueChanged(int)),this, SLOT(SetH(int)));

 SS=new QScrollBar(Qt::Vertical,this);
 SS->setRange(0,255);
 SS->setPageStep(25);
 SS->setSliderPosition(255-S);
 SS->setGeometry(270,130,20,130);
 SS->setGeometry(240,130,20,130);
 connect(SS,SIGNAL(valueChanged(int)),this, SLOT(SetS(int)));

 SV=new QScrollBar(Qt::Vertical,this);
 SV->setRange(0,255);
 SV->setPageStep(25);
 SV->setSliderPosition(255-V);
 SV->setGeometry(270,130,20,130);
 SV->setGeometry(270,130,20,130);
 connect(SV,SIGNAL(valueChanged(int)),this, SLOT(SetV(int)));

}

void ColSel::SetR(int v)
{
 int r,g,b;
 v=255-v;
 Col.getRgb(&r,&g,&b);
 if(r!=v){
  Col.setRgb(v,g,b);
  Col.getHsv(&H,&S,&V);
  SH->setValue(360-H);
  SS->setValue(255-S);
  SV->setValue(255-V);
  repaint(10,110,100,100);
 }
}

void ColSel::SetG(int v)
{
 int r,g,b;
 v=255-v;
 Col.getRgb(&r,&g,&b);
 if(g!=v){
  Col.setRgb(r,v,b);
  Col.getHsv(&H,&S,&V);
  SH->setValue(360-H);
  SS->setValue(255-S);
  SV->setValue(255-V);
  repaint(10,110,100,100);
 }
}

void ColSel::SetB(int v)
{
 int r,g,b;
 v=255-v;
 Col.getRgb(&r,&g,&b);
 if(b!=v){
  Col.setRgb(r,g,v);
  Col.getHsv(&H,&S,&V);
  SH->setValue(360-H);
  SS->setValue(255-S);
  SV->setValue(255-V);
  repaint(10,110,100,100);
 }
}

void ColSel::SetH(int v)
{
 v=360-v;
 if(H!=v){
  int r,g,b;
  H=v;
  Col.setHsv(H,S,V);
  Col.getRgb(&r,&g,&b);
  SR->setValue(255-r);
  SG->setValue(255-g);
  SB->setValue(255-b);
  repaint(10,110,100,100);
 }
}

void ColSel::SetS(int v)
{
 v=255-v;
 if(S!=v){
  int r,g,b;
  S=v;
  Col.setHsv(H,S,V);
  Col.getRgb(&r,&g,&b);
  SR->setValue(255-r);
  SG->setValue(255-g);
  SB->setValue(255-b);
  repaint(10,110,100,100);
 }
}

void ColSel::SetV(int v)
{
 v=255-v;
 if(V!=v){
  int r,g,b;
  V=v;
  Col.setHsv(H,S,V);
  Col.getRgb(&r,&g,&b);
  SR->setValue(255-r);
  SG->setValue(255-g);
  SB->setValue(255-b);
  repaint(10,110,100,100);
 }
}

void ColSel::End()
{
 int r,g,b;
 Col.getRgb(&r,&g,&b);
 SetCol(r,g,b);
 accept();
}



void ColSel::paintEvent( QPaintEvent * e)
{
 QPainter paint( this );

 int i;
 QRect r;
 r=e->rect();
 paint.setFont(QFont( "Times", 14, QFont::Bold ));
 r.setRect(10,110,100,100);
 paint.setBrush(Col);
 paint.drawRect(r);

 QString s;
 s.setNum(Col.red());
 s="Red="+s;
 paint.setPen(Qt::red);
 r.setRect(20,220,100,20);
 paint.drawText(r,Qt::AlignCenter,s);

 s.setNum(Col.green());
 s="Green="+s;
 paint.setPen(Qt::green);
 r.setRect(20,240,100,20);
 paint.drawText(r,Qt::AlignCenter,s);

 s.setNum(Col.blue());
 s="Blue="+s;
 paint.setPen(Qt::blue);
 r.setRect(20,260,100,20);
 paint.drawText(r,Qt::AlignCenter,s);

 paint.setFont(QFont( "Times", 18, QFont::Bold ));
 paint.setPen(Qt::black);

 r.setRect(120,108,20,20);
 paint.drawText(r,Qt::AlignCenter,"R");
 r.setRect(150,108,20,20);
 paint.drawText(r,Qt::AlignCenter,"G");
 r.setRect(180,108,20,20);
 paint.drawText(r,Qt::AlignCenter,"B");
 r.setRect(210,108,20,20);
 paint.drawText(r,Qt::AlignCenter,"H");
 r.setRect(240,108,20,20);
 paint.drawText(r,Qt::AlignCenter,"S");
 r.setRect(270,108,20,20);
 paint.drawText(r,Qt::AlignCenter,"V");

 QColor c;
 for(i=0;i<6;i++){
  c.setHsv(i*60,255,255);
  r.setRect(12+i*48,12,36,36);
  paint.setBrush(c);
  paint.drawRect(r);
 }
 for(i=0;i<6;i++){
  c.setHsv(i*60,255,128);
  r.setRect(12+i*48,60,36,36);
  paint.setBrush(c);
  paint.drawRect(r);
 }
}

void ColSel::mousePressEvent ( QMouseEvent *e )
{

 QPoint p;
 p=e->pos();
 int x=p.x();
 int y=p.y();
 int v;
// int h;

 if(y>12 && y<48){
  v=255;
 }
 else if(y>60 && y<96){
  v=128;
 }
 else return;

 if((x%48)>12 && (x/48)<6){
  H=(x/48)*60;
  S=255;
  V=v;
  Col.setHsv(H,S,V);
   SH->setValue(360-H);
  SS->setValue(255-S);
  SV->setValue(255-V);
  int r,g,b;
  Col.getRgb(&r,&g,&b);
  SR->setValue(255-r);
  SG->setValue(255-g);
  SB->setValue(255-b);
  repaint(10,110,100,100);
 }
}

//-----------------------------------------------------------------------
//-----------------------------------------------------------------------


ColSelM::ColSelM(QColor * col, QWidget *parent)
 :QDialog( parent )
{
  Col=col;
  Col->getRgb(&R,&G,&B);
  Build();
}

/*ColSel::ColSel( QWidget *parent=0, const char *name=0 )
 :QDialog( parent, name )
{
  pix=Col.alloc();
  Col.setRgb(0,0,0);
  Build();
}
*/

void ColSelM::Build()
{
 setMinimumSize( 300, 300 );
 setMaximumSize( 300, 300 );

 Col->getHsv(&H,&S,&V);

 int r,g,b;
 Col->getRgb(&r,&g,&b);

 QPushButton* Ok;
 Ok = new QPushButton( "OK", this );
 Ok->setGeometry( 215, 265, 75, 30 );
 Ok->setFont( QFont( "Times", 18, QFont::Bold ) );
 connect( Ok, SIGNAL(clicked()),this, SLOT(End()) );

 Ok = new QPushButton( "Cancel", this);
 Ok->setGeometry( 125, 265, 75, 30 );
 Ok->setFont( QFont( "Times", 18, QFont::Bold ) );
 connect( Ok, SIGNAL(clicked()),this, SLOT(Cancel()) );

 SR=new QScrollBar( Qt::Vertical,this);
 SR->setRange(0,255);
 SR->setPageStep(25);
 SR->setSliderPosition(255-r);
 SR->setGeometry(120,130,20,130);
 connect(SR,SIGNAL(valueChanged(int)),this, SLOT(SetR(int)));

 SG=new QScrollBar( Qt::Vertical,this);
 SG->setRange(0,255);
 SG->setPageStep(25);
 SG->setSliderPosition(255-g);
 SG->setGeometry(150,130,20,130);
 connect(SG,SIGNAL(valueChanged(int)),this, SLOT(SetG(int)));

 SB=new QScrollBar( Qt::Vertical,this);
 SB->setRange(0,255);
 SB->setPageStep(25);
 SB->setSliderPosition(255-b);
 SB->setGeometry(180,130,20,130);
 connect(SB,SIGNAL(valueChanged(int)),this, SLOT(SetB(int)));

 SH=new QScrollBar( Qt::Vertical,this);
 SH->setRange(0,360);
 SH->setPageStep(25);
 SH->setSliderPosition(360-H);
 SH->setGeometry(210,130,20,130);
 connect(SH,SIGNAL(valueChanged(int)),this, SLOT(SetH(int)));

 SS=new QScrollBar( Qt::Vertical,this);
 SS->setRange(0,255);
 SS->setPageStep(25);
 SS->setSliderPosition(255-S);
 SS->setGeometry(240,130,20,130);
 connect(SS,SIGNAL(valueChanged(int)),this, SLOT(SetS(int)));

 SV=new QScrollBar( Qt::Vertical,this);
 SV->setRange(0,255);
 SV->setPageStep(25);
 SV->setSliderPosition(255-V);
 SV->setGeometry(270,130,20,130);
 connect(SV,SIGNAL(valueChanged(int)),this, SLOT(SetV(int)));

}

void ColSelM::SetR(int v)
{
 int r,g,b;
 v=255-v;
 Col->getRgb(&r,&g,&b);
 if(r!=v){
  Col->setRgb(v,g,b);
  Col->getHsv(&H,&S,&V);
  SH->setValue(360-H);
  SS->setValue(255-S);
  SV->setValue(255-V);
  repaint(10,210,100,90);
 }
}

void ColSelM::SetG(int v)
{
 int r,g,b;
 v=255-v;
 Col->getRgb(&r,&g,&b);
 if(g!=v){
  Col->setRgb(r,v,b);
  Col->getHsv(&H,&S,&V);
  SH->setValue(360-H);
  SS->setValue(255-S);
  SV->setValue(255-V);
  repaint(10,110,100,190);
 }
}

void ColSelM::SetB(int v)
{
 int r,g,b;
 v=255-v;
 Col->getRgb(&r,&g,&b);
 if(b!=v){
  Col->setRgb(r,g,v);
  Col->getHsv(&H,&S,&V);
  SH->setValue(360-H);
  SS->setValue(255-S);
  SV->setValue(255-V);
  repaint(10,110,100,190);
 }
}

void ColSelM::SetH(int v)
{
 v=360-v;
 if(H!=v){
  int r,g,b;
  H=v;
  Col->setHsv(H,S,V);
  Col->getRgb(&r,&g,&b);
  SR->setValue(255-r);
  SG->setValue(255-g);
  SB->setValue(255-b);
  repaint(10,110,100,190);
 }
}

void ColSelM::SetS(int v)
{
 v=255-v;
 if(S!=v){
  int r,g,b;
  S=v;
  Col->setHsv(H,S,V);
  Col->getRgb(&r,&g,&b);
  SR->setValue(255-r);
  SG->setValue(255-g);
  SB->setValue(255-b);
  repaint(10,110,100,190);
 }
}

void ColSelM::SetV(int v)
{
 v=255-v;
 if(V!=v){
  int r,g,b;
  V=v;
  Col->setHsv(H,S,V);
  Col->getRgb(&r,&g,&b);
  SR->setValue(255-r);
  SG->setValue(255-g);
  SB->setValue(255-b);
  repaint(10,110,100,190);
 }
}

void ColSelM::End()
{
// int r,g,b;
// Col->getRgb(&r,&g,&b);
// SetCol(r,g,b);
 accept();
 delete this;
}

void ColSelM::Cancel()
{
 Col->setRgb(R,G,B);
 reject();
 delete this;
}



void ColSelM::paintEvent( QPaintEvent * e)
{
 QPainter paint( this );

 int i;
 QRect r;
 r=e->rect();
 paint.setFont(QFont( "Times", 14, QFont::Bold ));
 r.setRect(10,110,100,100);
 paint.setBrush(*Col);
 paint.drawRect(r);

 QString s;
 s.setNum(Col->red());
 s="Red="+s;
 paint.setPen(Qt::red);
 r.setRect(10,220,100,20);
 paint.drawText(r,Qt::AlignCenter,s);

 s.setNum(Col->green());
 s="Green="+s;
 paint.setPen(Qt::green);
 r.setRect(10,240,100,20);
 paint.drawText(r,Qt::AlignCenter,s);

 s.setNum(Col->blue());
 s="Blue="+s;
 paint.setPen(Qt::blue);
 r.setRect(10,260,100,20);
 paint.drawText(r,Qt::AlignCenter,s);

 paint.setFont(QFont( "Times", 18, QFont::Bold ));
 paint.setPen(Qt::black);

 r.setRect(120,108,20,20);
 paint.drawText(r,Qt::AlignCenter,"R");
 r.setRect(150,108,20,20);
 paint.drawText(r,Qt::AlignCenter,"G");
 r.setRect(180,108,20,20);
 paint.drawText(r,Qt::AlignCenter,"B");
 r.setRect(210,108,20,20);
 paint.drawText(r,Qt::AlignCenter,"H");
 r.setRect(240,108,20,20);
 paint.drawText(r,Qt::AlignCenter,"S");
 r.setRect(270,108,20,20);
 paint.drawText(r,Qt::AlignCenter,"V");

 QColor c;
 for(i=0;i<6;i++){
  c.setHsv(i*60,255,255);
  r.setRect(12+i*48,12,36,36);
  paint.setBrush(c);
  paint.drawRect(r);
 }
 for(i=0;i<6;i++){
  c.setHsv(i*60,255,128);
  r.setRect(12+i*48,60,36,36);
  paint.setBrush(c);
  paint.drawRect(r);
 }
}

void ColSelM::mousePressEvent ( QMouseEvent *e )
{

 QPoint p;
 p=e->pos();
 int x=p.x();
 int y=p.y();
 int v;
// int h;

 if(y>12 && y<48){
  v=255;
 }
 else if(y>60 && y<96){
  v=128;
 }
 else return;

 if((x%48)>12 && (x/48)<6){
  H=(x/48)*60;
  S=255;
  V=v;
  Col->setHsv(H,S,V);
   SH->setValue(360-H);
  SS->setValue(255-S);
  SV->setValue(255-V);
  int r,g,b;
  Col->getRgb(&r,&g,&b);
  SR->setValue(255-r);
  SG->setValue(255-g);
  SB->setValue(255-b);
  repaint(10,110,100,190);
 }
}
