/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <QColor>
#include <QObject>
#include <QWidget>
#include <QEvent>
#include <QDialog>
#include <QLineEdit>
#include <QCheckBox>
#include <QScrollBar>
//Added by qt3to4:
#include <QPaintEvent>
#include <QMouseEvent>

class ColSel : public QDialog
{
 Q_OBJECT
public:
    ColSel( QWidget *parent=0 );
    ColSel( QColor col,QWidget *parent=0);

public slots:

    void SetR(int v);
    void SetG(int v);
    void SetB(int v);
    void SetH(int v);
    void SetS(int v);
    void SetV(int v);
    void End();

signals:

    void SetCol(int r,int g,int b);

protected:
    void Build();
    void paintEvent( QPaintEvent * e);
//    void mouseMoveEvent( QMouseEvent *e );
    void mousePressEvent ( QMouseEvent *e );
//    void mouseReleaseEvent ( QMouseEvent * e);
 //   void resizeEvent ( QResizeEvent * e);


private:

  QColor Col;
  uint pix;
  int H,S,V;

  QScrollBar * SR;
  QScrollBar * SG;
  QScrollBar * SB;
  QScrollBar * SH;
  QScrollBar * SS;
  QScrollBar * SV;

};


class ColSelM : public QDialog
{
 Q_OBJECT
public:
//    ColSelM( QWidget *parent=0 );
    ColSelM( QColor * col,QWidget *parent=0);

public slots:

    void SetR(int v);
    void SetG(int v);
    void SetB(int v);
    void SetH(int v);
    void SetS(int v);
    void SetV(int v);
    void End();
    void Cancel();

signals:

//    void SetCol(int r,int g,int b);

protected:
    void Build();
    void paintEvent( QPaintEvent * e);
//    void mouseMoveEvent( QMouseEvent *e );
    void mousePressEvent ( QMouseEvent *e );
//    void mouseReleaseEvent ( QMouseEvent * e);
 //   void resizeEvent ( QResizeEvent * e);


private:

  QColor * Col;
//  uint pix;
  int H,S,V;

  int R,G,B;

  QScrollBar * SR;
  QScrollBar * SG;
  QScrollBar * SB;
  QScrollBar * SH;
  QScrollBar * SS;
  QScrollBar * SV;

};

