/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef DRC_included
#define DRC_included

#include "Global.h"
#include "PicEl.h"
#include "PicGrp.h"

#include <qpoint.h>
#include <qrect.h>
#include <QPainterPath>

class DRC
{

struct DEl {
  PicEl * E;
  int Iden;
  QPoint P1;
  QPoint P2;
  QPainterPath Po;
  int W;
  int R;
  int Lo;
  QString N;
  DEl* Next;
};


public:

 DRC();
 virtual ~DRC();

 void GetParam(double & pp,double & pw,double & po,
                   double & ww,double & wo,double & oo);
 void SetParam(double pp,double pw,double po,
                   double ww,double wo,double oo);

 void AddEl(PicEl * E,int &Iden,QPoint &p1,QPoint &p2,int &W,int &R,
                        int &Lo,QString &N,QPainterPath Po);


 void AddErr(PicGrp * Db, DEl * L,unsigned long int le);

 double Distance(int IdenA,QPoint P1A,QPoint P2A,int WA,int RA,QPainterPath PoA,
              int IdenB,QPoint P1B,QPoint P2B,int WB,int RB,QPainterPath PoB);


 bool Check(PicGrp * Db=NULL);


 double DLinLin(QPoint P1A,QPoint P2A,QPoint P1B,QPoint P2B);
 double DPointLin(QPoint P1A,QPoint P1B,QPoint P2B);
 double DPointPoint(QPoint P1A,QPoint P1B);
 double DRecRec(QPoint P1A,QPoint P2A,QPoint P1B,QPoint P2B);
 double DRecFRecF(QPoint P1A,QPoint P2A,QPoint P1B,QPoint P2B);
 double DPointRecF(QPoint P1A,QPoint P1B,QPoint P2B);
 double DPointRec(QPoint P1A,QPoint P1B,QPoint P2B);
 double DLinRec(QPoint P1A,QPoint P2A,QPoint P1B,QPoint P2B);
 double DLinRecF(QPoint P1A,QPoint P2A,QPoint P1B,QPoint P2B);
 double DLinPoly(QPoint P1A,QPoint P2A,QPainterPath Po);
 double DPointPoly(QPoint P1A,QPainterPath Po);
 double DRecPoly(QPoint P1A,QPoint P2A,QPainterPath Po);
 double DRecFPoly(QPoint P1A,QPoint P2A,QPainterPath Po);
 double DPolyPoly(QPainterPath PoA,QPainterPath PoB);

 void Clear();

 void TextSave(QTextStream * S);
 void TextLoad(QTextStream * S);

private:

 double PP;
 double PW;
 double PO;
 double WW;
 double WO;
 double OO;

 DEl * LE;

};

#endif
