/*
    This file is part of peda.
    Copyright (C) 2000-2010  Petr Porazil <porazil@volny.cz>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "Global.h"
#include "DbPcb.h"
#include "PicPadS.h"
#include "Layers.h"
#include "Library.h"
#include "DRC.h"
#include "Error.h"
#include "Part.h"
#include "ObjEdit.h"

#include <QPainter>
#include <QPen>
#include <QColor>
//#include <qpntarry.h>
//Added by qt3to4:
#include <QTextStream>

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>

extern Library gLib;
extern Errors  gErr;


DbPcb::DbPcb(Layers *L)
 :PicGrp(L)
{
 ANet=NULL;
 ViaName="via1";
}


DbPcb::~DbPcb()
{
}

int DbPcb::GetIden()
{
 return kDbPcb;
}

void DbPcb::AddTreeList(TreeListItem * LI)
{
 LI->setText( 1,Name);
 PicGrp::AddTreeList(LI);
}

PComp * DbPcb::FindComp(QString ref)
{
 GrpEl * T=Data;
 QString s;
// int i;
// printf("Find PComp %s\n",ref.toLatin1().data());
 while(T){
  if(T->E->GetIden()==kPComp){
   s=(((PComp *)(T->E))->GetAtr(kAtrRef));
   if(!s.isEmpty()){
//    printf(" ref %s\n",s.toLatin1().data());
    if(ref==s){
     return (PComp *)(T->E);
    }
   }
  } 
  T=T->Next;
 }
 return NULL;
}

bool DbPcb::GetCompCenter(QString ref, QPoint & p, int & rot,int & mir,int & typ)
{
  GrpEl * T=Data;
  PComp * C=FindComp(ref);
  if(C){
    C->GetCenter(p,rot,mir,typ);
    p=CompRot(Rot,p,Mir);
    p=p+Ref;
    rot=(rot+Rot)&3;
    mir^=Mir;
    return true;
  }
//  typ=0;

  while(T){
   if(T->E->GetIden()==kDbPcb){
     if(((DbPcb *)(T->E))->GetCompCenter(ref, p, rot,mir,typ)) return true;
   }
   T=T->Next;
  }
  return false;
}

void DbPcb::GetPart(Part * P)
{
  GrpEl * T=Data;
 // int i;
  while(T){
    if(T->E->GetIden()==kPComp){
      if(!((PComp *)(T->E))->GetAtr(kAtrRef).isEmpty()){
	P->AddAtr(((PComp *)(T->E))->GetAtr());
      }
    }
    if(T->E->GetIden()==kDbPcb){
      ((DbPcb *)(T->E))->GetPart(P);
    }
    T=T->Next;
  }
}

void DbPcb::DelInvalid()
{
 GrpEl * T=Data;
 GrpEl * T1=Data;
 while(T){
  if(T->E->GetIden()==kPComp){
   if(!((PComp *)(T->E))->IsValid()){
    if(T==Data){
     Data=T->Next;
     delete T->E;
     delete T;
     T=Data;
    }
    else{
     T1->Next=T->Next;
     delete T->E;
     delete T;
     T=T1->Next;
    }
   }
   else{
    T1=T;
    T=T->Next;
   }
  }
  else{
   T1=T;
   T=T->Next;
  }
 }
}

void DbPcb::CleanNets()
{
 GrpEl * T;
 GrpEl * T1;
 GrpEl * N=Data;
 GrpEl * N1=Data;

 printf("CleanNets Start\n");

 while(N){
  if(N->E->GetIden()==kPicPNet){
   T=((PicPNet *)N->E)->GetData();
   ((PicPNet *)N->E)->ClrData();
   if(N==Data){
    Data=N->Next;
    delete N->E;
    delete N;
    N=Data;
   }
   else{
    N1->Next=N->Next;
    delete N->E;
    delete N;
    N=N1->Next;
   }
   if(T){
    T1=T;
    while(T1->Next){
     T1=T1->Next;
    }
    if(N==Data) N1=T1;
    T1->Next=Data;
    Data=T;
   }
  }
  else{
   N1=N;
   N=N->Next;
  }
 }
 printf("CleanNets End\n");
}


void DbPcb::MkNets()
{
 GrpEl * T=Data;
 GrpEl * T1=NULL;
 GrpEl * N=Data;
 PComp * P;
 PicPNet * PN=NULL;
 QString s;
 int i;
 int n;

 printf("MkNets Start\n");

//vymaze piny se vsech PNet
 N=Data;
 while(N){
  if(N->E->GetIden()==kPicPNet){
   ((PicPNet *)N->E)->DelPin();
  }
  N=N->Next;
 }

 printf("MkNets Step2\n");

//nacpe piny do PNet, prip. vytvori novy PNet
 while(T){
  if(T->E->GetIden()==kPComp){
   P=(PComp*)T->E;
   P->GetPinR();
   while(P->GetPin(&s,&i)){
//    printf("Pin: %s %d ",(const char *)s,i);
    if(s!="?"){
     N=Data;
     while(N){
      if(N->E->GetIden()==kPicPNet){
       if(s==((PicPNet *)N->E)->GetName()){
        break;
       }
      }
      N=N->Next;
     }
     if(!N){
//      printf(" new ");
      PN=new PicPNet(Layer);
      PN->SetName(s);
      AddItem(PN);
     }
     else PN=(PicPNet *)N->E;
     PN->AddPin(P,i);
    }
   }
  }
  T=T->Next;
 }

 printf("MkNets Step3\n");
//zrusi prazdne PNet
 N=Data;
 while(N){
  if(N->E->GetIden()==kPicPNet){
   if(((PicPNet *)(N->E))->IsEmpty()){
    if(N==Data){
     Data=N->Next;
     delete N->E;
     delete N;
     N=Data;
    }
    else{
     T->Next=N->Next;
     delete N->E;
     delete N;
     N=T->Next;
    }
   }
   else{
    T=N;
    N=N->Next;
   }
  }
  else{
   T=N;
   N=N->Next;
  }
 }

 printf("MkNets Step4\n");
//Nacpe do PNet spoje a pruchody
 N=Data;
 while(N){
  if(N->E->GetIden()==kPicPNet){
   PN=(PicPNet *)N->E;
   i=0;
   n=1;
   while(i || n){
    T=Data;
    n=i;
    i=0;
    while(T){
     if((T->E->GetIden()==kPicLine || T->E->GetIden()==kPicPadS
         || T->E->GetIden()==kPicPoly) && PN->IsConnect(T->E,2,n)){
      i++;
      if(T==Data){
       Data=T->Next;
       PN->AddItem(T);
       T=Data;
      }
      else{
       T1->Next=T->Next;
       PN->AddItem(T);
       T=T1->Next;
      }
     }
     else {
      T1=T;
      T=T->Next;
     }
    }
//    printf("  MkNets Step4 n=%d i=%d\n",n,i);
   }
//   PN->CheckCn();
  }
  N=N->Next;
 }

 printf("MkNets Step5\n");
 N=Data;
 while(N){
  if(N->E->GetIden()==kPicPNet){
   PN=(PicPNet *)N->E;
   i=0;
   n=1;
   while(i || n){
    T=Data;
    n=i;
    i=0;
    while(T){
     if((T->E->GetIden()==kPicLine || T->E->GetIden()==kPicPadS
         || T->E->GetIden()==kPicPoly) && PN->IsConnect(T->E,4,n)){
      i++;
      if(T==Data){
       Data=T->Next;
       PN->AddItem(T);
       T=Data;
      }
      else{
       T1->Next=T->Next;
       PN->AddItem(T);
       T=T1->Next;
      }
     }
     else {
      T1=T;
      T=T->Next;
     }
    }
//    printf("  MkNets Step5 n=%d i=%d\n",n,i);
   }
   PN->CheckCn();
  }
  N=N->Next;
 }

 printf("MkNets End\n");
}

int DbPcb::CheckCn()
{
 int n=0;
 int t=0;
 GrpEl* T;
 QString s;
 QString s1;

 printf("CheckCn Start\n");

 CleanNets();
 MkNets();

 printf("CheckCn Step2\n");
 T=Data;
 while(T){
  if (T->E->GetIden()==kPicPNet){
//   ((PicPNet *)T->E)->CheckCn();
   n+=((PicPNet *)T->E)->Disjoint(t);
  }
  T=T->Next;
 }
 s1.setNum(t);
 if(n){
  s.setNum(n);
  s="ERROR continuity check \nTotal disjoint nets "+s+"/"+s1;
  gErr.Err(s);
 }
 else{
  s="Continuity check OK "+s1+" connections";
  gErr.Msg(s);
 }
 printf("CheckCn End\n");
 return n;
}


bool DbPcb::IsConnect(QPoint p,int tol)
{
 GrpEl* T=Data;
 while(T){
  if (T->E->GetIden()==kPicPNet){
   if(((PicPNet *)T->E)->IsConnect(p,tol,Layer->GetAct())){
    ANet=(PicPNet *)T->E;
    ALy=Layer->GetAct();
    ANet->MinRts();
    ANet->HL();
    ANet->SelThis();
    Sel=2;
    ANet->SetORect();
    return true;
   }
  }
  T=T->Next;
 }
 return false;
}

void DbPcb::AddWire(QPoint l1,QPoint l2,int Wid,QRect & r,bool cln)
{
 if(ANet){
  QRect r1;
  l1=l1-Ref;
  l1=CompRot(4-Rot,l1,Mir+256);
  l2=l2-Ref;
  l2=CompRot(4-Rot,l2,Mir+256);
  if(ALy!=Layer->GetAct()){
   if(!ANet->IsVia(l1)){
    PicPadS * PP=new PicPadS(Layer);
    if (PP->LibPart(ViaName)){
     ANet->AddItem(PP);
     PP->MoveTo(l1);
    }
   }
   ALy=Layer->GetAct();
  }
  ANet->AddLine(l1,l2,Wid,r1,cln);

//  SetOutl();
  ANet->GetORect(&r);
  r=r.unite(r1);
  r=CompRot(Rot,r,Mir);
  r.translate(Ref.x(),Ref.y());
 }
}

void DbPcb::ANetORect(QRect & r)
{
 if(ANet){
  ANet->GetORect(&r);
  r=CompRot(Rot,r,Mir);
  r.translate(Ref.x(),Ref.y());
 }
}


bool DbPcb::Select(QPoint p,int mode,int mir)
{
 if(PicGrp::Select(p,mode,mir)){
  GrpEl* T=Data;
  GrpEl* T1;
  PComp * P;
  QString s;
  int i;
  QPoint p1;
  int mod=mode & 255;
  int xmod=mode/0x10000;
  unsigned long int t;

  while(T){
   if(T->E->GetIden()==kPComp && T->E->IsSelect()==1 && !xmod){
    T1=Data;
    t=Layer->GetRts();
    if (Layer->IsVis(t)){
     while(T1!=NULL){
      if (T1->E->GetIden()==kPicPNet) ((PicPNet *)T1->E)->SelRts((PComp *)T->E);
      T1=T1->Next;
     }
    }
    if(mod!=kSelActOnly){
     P=(PComp*)T->E;
     P->GetPinR();
     while(P->GetPin(&s,&i)){
      if(P->GetPinP(&p1,i)){
       SelPoint(p1,2,mir);
      }
     }
    }
   }
   T=T->Next;
  }
  return true;
 }
 return false;
}

/*bool DbPcb::Select(PicEl * E)
{
 if (PicEl::Select(E)) return true;
 if(Data!=NULL && !Lock){
  GrpEl* T=Data;
  while(T!=NULL){
   if (T->E->Select(E)){
    Sel=2;
    return true;
   }
   T=T->Next;
  }
 }
 return false;
}
*/

/*
bool DbPcb::Select(QRect r,int mode=0)
{
 int type=mode/0x10000;
 //int xmod=mode & 0xff00;
 //int mod=mode & 255;
 if (Lock) return(PicEl::Select(r,mode));
 r.translate(-Ref.x(),-Ref.y());
 r=CompRot(4-Rot,r,Mir+256);
 if(Data!=NULL && r.intersects(R) && Layer->IsVis(Ly)){
  GrpEl* T=Data;
  GrpEl* T1=NULL;
  while(T!=NULL){
   if(T->E->GetIden()==type || type==0  || T->E->GetIden()>=kPicGrp){
    if (T->E->Select(r,mode)){
     Sel=2;
    }
   }
   T=T->Next;
  }
  if (Sel) return true;
 }
 return false;
}
*/
void DbPcb::DeSelect()
{
 if (Lock) Sel=0;
 if(Data!=NULL){
  GrpEl* T=Data;
  while(T!=NULL){
   if(T->E->GetIden()==kPicPNet) ((PicPNet *)T->E)->DeSelRts();
   T->E->DeSelect();
   T=T->Next;
  }
  Sel=0;
 }
}

void DbPcb::DeleteSel()
{
 GrpEl* T=Data;
 while(T!=NULL){
  if(T->E->GetIden()==kPicPNet) ((PicPNet *)T->E)->RmSelPin();
  T=T->Next;
 }
// CleanNets();
 PicGrp::DeleteSel();
// MkNets();
}

void DbPcb::GetSelORect(QRect* r)
{
 if(Data!=NULL){
  QRect r1;
  GrpEl* T=Data;
  r->setRect(0,0,0,0);
  while(T!=NULL){
   if (T->E->IsSelect()){
    if (T->E->IsLock()) T->E->GetORect(&r1);
    else ((PicGrp *)(T->E))->GetSelORect(&r1);
    *r=r->unite(r1);
   }
   if(T->E->GetIden()==kPicPNet){
//    if (((PicPNet *)T->E)->IsSelRts()){
     T->E->GetORect(&r1);
     *r=r->unite(r1);
//    }
   }
   T=T->Next;
  }
  *r=CompRot(Rot,*r,Mir);
  r->translate(Ref.x(),Ref.y());
 }
}


void DbPcb::DelDrcErr()
{
 GrpEl * T=Data;
 GrpEl * T1=Data;
 unsigned long int le;
 QString s("DRCERR");
 le=Layer->GetLy(&s);

 while(T){
  if(T->E->GetLayer()==le && T->E->IsLock()){
   if(T==Data){
    Data=T->Next;
    delete T->E;
    delete T;
    T=Data;
   }
   else{
    T1->Next=T->Next;
    delete T->E;
    delete T;
    T=T1->Next;
   }
  }
  else{
   T1=T;
   T=T->Next;
  }
 }
}


bool DbPcb::Drc(DRC & D)
{
 int ID;
 QPoint P1;
 QPoint P2;
 int W;
 int R;
 int Lo;
 QPainterPath Po;
 QString N;
 PicEl * E;
 bool pad;

 int i=1;
 bool x=true;

 unsigned long int Ly;

 DelDrcErr();

 gErr.OpenLst();

 Ly=Layer->GetLyLevel(1);

 while(Ly){
  N="";
  Lo=0;
  E=GetEl(ID,P1,P2,W,R,Lo,N,Po,Ly,pad);
  while(E){
   D.AddEl(E,ID,P1,P2,W,R,Lo,N,Po);
   N="";
   Lo=0;
   E=GetNextEl(ID,P1,P2,W,R,Lo,N,Po,Ly,pad);
  }

  N.setNum(i);
  if(D.Check(this)){
   N="Layer level "+N+" DRC OK\n";
  }
  else{
   x=false;
   N="DRC ERROR on layer level "+N+"\n";
  }
  gErr.ToLst(N);
  D.Clear();

  i++;
  Ly=Layer->GetLyLevel(i);
 }
 gErr.ShowLst();
 UpdORect();
 return x;
}


void DbPcb::UpdateAtr()
{
 GrpEl * T=Data;
// int i;
 while(T){
  if(T->E->GetIden()==kPComp){
   ((PComp *)(T->E))->UpdateAtr();
  }
  T=T->Next;
 }
// LyChange();
}

int DbPcb::SelXPartL()
{
 int a;
 QString s;
 GrpEl * T=Data;
// int i;
 while(T){
  if(T->E->GetIden()==kPComp){
    s=(((PComp *)(T->E))->GetAtr(kAtrPartL));
    if(!s.isEmpty()){
      T->E->Select(T->E);
      Sel=2;
    }
  }
  else if(T->E->GetIden()==kDbPcb){
    a=((DbPcb *)(T->E))->SelXPartL();
    if(a==2) Sel=2;
  }
  T=T->Next;
 }
 return Sel;
// LyChange();
}

bool DbPcb::LibPart(QString name)
{
 Name=name;
 DbPcb * E=(DbPcb *)gLib.GetComp(name,Layer,kDbPcb);
 if (E){
  Data=E->GetData();
  Lock=true;
//  SetOutl();
  return true;
 }
 return false;
}

void DbPcb::SetName(QString n)
{
 Name=n;
}

void DbPcb::TextSave(QTextStream * S, bool sel)
{
 if (Lock){
  PicEl::TextSave(S,sel);
  *S << "    {Lock " << Lock << " }\n";
  *S << "    {Name " << Name << " }\n";
  *S << "   }\n";
 }
 else{
  PicGrp::TextSave(S,sel);
 }
}

bool  DbPcb::TLoadNext(QTextStream * S,QString* s)
{
 if (s->contains("Name")){
  QString s1;
  *S >> s1;
  TextLoadSkip(S);
  Name=s1;
  PicGrp * E=gLib.GetComp(s1,Layer,kDbPcb);
  if (E) Data=E->GetData();
 }
 else  return PicGrp::TLoadNext(S,s);
 return true;
}


//--------------------------------------------------------------------

PicPNet::PicPNet(Layers *L)
 :PicGrp(L)
{
 PL=NULL;
 Name="????";
 SR=false;
 MinX=32000;
 MinY=32000;
 MaxX=-32000;
 MaxY=-32000;
}


PicPNet::~PicPNet()
{
 PinLst * T=PL;
 while(T){
  T=T->Next;
  delete PL;
  PL=T;
 }
}

int PicPNet::GetIden()
{
 return kPicPNet;
}

void PicPNet::AddTreeList(TreeListItem * LI)
{
 LI->setText( 1,Name);
 PicGrp::AddTreeList(LI);
}


PicPNet::PinLst * PicPNet::GetPL()
{
 return PL;
}


bool PicPNet::IsEmpty()
{
 if(PL || Data) return false;
 return true;
}


void PicPNet::SetName(QString N)
{
 Name=N;
}

QString PicPNet::GetName()
{
 return Name;
}

void PicPNet::HLSel(int fl)
{
// printf("PicNet::HLSel Sel= %d\n",Sel);
  if(fl){
    if(Sel) HL();
  }
  else{
    PicGrp::HLSel(fl);
  }  
}

void PicPNet::AddItem(PicEl* E)
{
 QPoint p;
 PicGrp::AddItem(E);
 if(E->GetIden()==kPicLine){
  p=((PicLine *)(E))->GetBegin();
  if(p.x()<MinX) MinX=p.x();
  if(p.x()>MaxX) MaxX=p.x();
  if(p.y()<MinY) MinY=p.y();
  if(p.y()>MaxY) MaxY=p.y();
  p=((PicLine *)(E))->GetEnd();
  if(p.x()<MinX) MinX=p.x();
  if(p.x()>MaxX) MaxX=p.x();
  if(p.y()<MinY) MinY=p.y();
  if(p.y()>MaxY) MaxY=p.y();
 }
 else if(E->GetIden()==kPicPadS){
  p=E->Pos();
  if(p.x()<MinX) MinX=p.x();
  if(p.x()>MaxX) MaxX=p.x();
  if(p.y()<MinY) MinY=p.y();
  if(p.y()>MaxY) MaxY=p.y();
 }
 else if(E->GetIden()==kPicPoly){
  QRect r;
  E->GetORect(&r);
  if(r.left()<MinX) MinX=r.left();
  if(r.right()>MaxX) MaxX=r.right();
  if(r.top()<MinY) MinY=r.top();
  if(r.bottom()>MaxY) MaxY=r.bottom();
 }
}

void PicPNet::AddItem(GrpEl* T)
{
 QPoint p;
 PicGrp::AddItem(T);
 if(T->E->GetIden()==kPicLine){
  p=((PicLine *)(T->E))->GetBegin();
  if(p.x()<MinX) MinX=p.x();
  if(p.x()>MaxX) MaxX=p.x();
  if(p.y()<MinY) MinY=p.y();
  if(p.y()>MaxY) MaxY=p.y();
  p=((PicLine *)(T->E))->GetEnd();
  if(p.x()<MinX) MinX=p.x();
  if(p.x()>MaxX) MaxX=p.x();
  if(p.y()<MinY) MinY=p.y();
  if(p.y()>MaxY) MaxY=p.y();
 }
 else if(T->E->GetIden()==kPicPadS){
  p=T->E->Pos();
  if(p.x()<MinX) MinX=p.x();
  if(p.x()>MaxX) MaxX=p.x();
  if(p.y()<MinY) MinY=p.y();
  if(p.y()>MaxY) MaxY=p.y();
 }
 else if(T->E->GetIden()==kPicPoly){
  QRect r;
  T->E->GetORect(&r);
  if(r.left()<MinX) MinX=r.left();
  if(r.right()>MaxX) MaxX=r.right();
  if(r.top()<MinY) MinY=r.top();
  if(r.bottom()>MaxY) MaxY=r.bottom();
 }
}


bool PicPNet::IsConnect(QPoint p,int tol)
{
 GrpEl * T=Data;
 while(T){
  if(T->E->GetIden()==kPicLine){
   if (((PicLine *)(T->E))->IsConnect(p,tol)) return true;
  }
  T=T->Next;
 }
 return false;
}

bool PicPNet::IsConnect(QPoint p,int tol,unsigned int Ly)
{
 GrpEl * T=Data;
 PinLst * P=PL;
 QPoint p1;

 while(T){
  if(T->E->GetIden()==kPicLine){
   if (((PicLine *)(T->E))->IsConnect(p,tol) &&
       Layer->IsConnect(T->E->GetLayer(),Ly)) return true;
  }
  else if(T->E->GetIden()==kPicPadS){
   p1=p-T->E->Pos();
   if((p1.x()<=tol) && (p1.y()<=tol) && (p1.x()>=-tol) && (p1.y()>=-tol)){
    if ((p1.x()*p1.x()+p1.y()*p1.y())<tol &&
        Layer->IsConnect(T->E->GetLayer(),Ly)) return true;
   }	
  }
  else if(T->E->GetIden()==kPicPoly){
   if (((PicPoly *)(T->E))->IsConnect(p,tol) &&
       Layer->IsConnect(T->E->GetLayer(),Ly)) return true;
  }
  T=T->Next;
 }
 while(P){
  if(P->P->GetPinP(&p1,P->n)){
   p1=p1-p;
   if((p1.x()<=tol) && (p1.y()<=tol) && (p1.x()>=-tol) && (p1.y()>=-tol)){
    if ((p1.x()*p1.x()+p1.y()*p1.y())<tol){
     if(Layer->IsConnect(P->P->GetPinL(P->n),Ly))return true;
    }
   }  
  }
  P=P->Next;
 }
 return false;
}


//bool PicPNet::IsConnect(PicEl * L,int tol,GrpEl * X)
bool PicPNet::IsConnect(PicEl * L,int tol,int num)
{
 GrpEl * T=Data;
 PinLst * P=PL;
 QPoint p1;
 QPoint p2;

 QRect r;
 L->GetORect(&r);
// if (!r.intersects(R)) return false;

 if (L->GetIden()==kPicLine){
  p1=((PicLine *)L)->GetBegin();
  p2=((PicLine *)L)->GetEnd();
  if(p1.x()<(MinX-tol) && p2.x()<(MinX-tol)) return false;
  if(p1.x()>(MaxX+tol) && p2.x()>(MaxX+tol)) return false;
  if(p1.y()<(MinY-tol) && p2.y()<(MinY-tol)) return false;
  if(p1.y()>(MaxY+tol) && p2.y()>(MaxY+tol)) return false;

  while(T){
   if(T->E->GetIden()==kPicLine){
    if (Layer->IsConnect(T->E->GetLayer(),L->GetLayer()) &&
       ((PicLine *)(T->E))->IsX(((PicLine *)L)->GetBegin(),((PicLine *)L)->GetEnd())) return true;
   }
   if(T->E->GetIden()==kPicPadS){
    if(Layer->IsConnect(T->E->GetLayer(),L->GetLayer())
       && ((PicLine *)(L))->IsConnect(T->E->Pos(),tol)) return true;
   }
   if(T->E->GetIden()==kPicPoly){
    if (Layer->IsConnect(T->E->GetLayer(),L->GetLayer()) &&
         (((PicPoly *)(T->E))->IsConnect(((PicLine *)L)->GetBegin(),tol) || 
         ((PicPoly *)(T->E))->IsConnect(((PicLine *)L)->GetEnd(),tol))) return true;
   }
   T=T->Next;
   if(num){
    num--;
    if(num==0) return false;
   }
  }
  while(P){
   if(P->P->GetPinP(&p1,P->n)){
    if (Layer->IsConnect(P->P->GetPinL(P->n),L->GetLayer())){
     if(((PicLine *)(L))->IsConnect(p1,tol)) return true;
    }
   }
   P=P->Next;
  }
 }

 if (L->GetIden()==kPicPadS){
  p1=L->Pos();
  if(p1.x()<(MinX-tol) || p1.x()>(MaxX+tol)) return false;
  if(p1.y()<(MinY-tol) || p1.y()>(MaxY+tol)) return false;
  while(T){
//   if(T!=X){
    if(T->E->GetIden()==kPicLine){
     if (Layer->IsConnect(T->E->GetLayer(),L->GetLayer())
        && ((PicLine *)(T->E))->IsConnect(L->Pos(),tol)) return true;
    }
   if(T->E->GetIden()==kPicPoly){
    if (Layer->IsConnect(T->E->GetLayer(),L->GetLayer()) &&
          ((PicPoly *)(T->E))->IsConnect(L->Pos(),tol)) return true;
   }
//   }
   T=T->Next;
   if(num){
    num--;
    if(num==0) return false;
   }
  }
 }
 if (L->GetIden()==kPicPoly){
   if(((PicPoly *)L)->GetNet()==Name) return true;
 }
 return false;
}


void PicPNet::AddPin(PComp * P,int n)
{
// printf("%s:Add %d\n",(const char *)Name,n);
 PinLst * T;
 T=new PinLst;
 T->P=P;
 T->n=n;
 T->Act=-1;
 T->Next=PL;
 PL=T;

 QPoint p;
 P->GetPinP(&p,n);
 if(p.x()<MinX) MinX=p.x();
 if(p.x()>MaxX) MaxX=p.x();
 if(p.y()<MinY) MinY=p.y();
 if(p.y()>MaxY) MaxY=p.y();

// SetOutl();
}

void PicPNet::DelPin()
{
 PinLst * T=PL;
// printf("%s:Del ",(const char *)Name);
 while(T){
//  printf("%d ",T->n);
  T=T->Next;
  delete PL;
  PL=T;
 }
// printf("\n");
 PL=NULL;
}


void PicPNet::SelRts(PComp * P)
{
 PinLst * T=PL;
 while(T!=NULL){
  if(T->P==P){
   SR=true;
   Sel=2;
  }
  T=T->Next;
 }
}

void PicPNet::DeSelRts()
{
 SR=false;
}

bool PicPNet::IsSelRts()
{
 return SR;
}

bool PicPNet::GetInfo(QString & i,QPoint p,int mode,int mir)
{
  GrpEl * T=Data;
  int l=0;
  QString s;

  while(T){
    if(T->E->GetIden()==kPicLine){
      l+=((PicLine *)(T->E))->GetLen();
    }
    T=T->Next;
  }
  s.setNum(l);
  if(PicGrp::GetInfo(i,p,mode,mir)){
    i+=" Net:";
    i+=Name;
    i+=" TL:";
    i+=s;
    return true;
  }
  return false;
}


PicEl * PicPNet::GetEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                      int &Lo,QString &N,QPainterPath &Po,unsigned long int L,bool &pad)
{
 PicEl * E=PicGrp::GetEl(iden,p1,p2,W,r,Lo,N,Po,L,pad);
 if(E) N=Name;
 return E;
}

PicEl * PicPNet::GetNextEl(int &iden,QPoint &p1,QPoint &p2,int &W,int &r,
                          int &Lo,QString &N,QPainterPath &Po,unsigned long int L,bool &pad)
{
 PicEl * E=PicGrp::GetNextEl(iden,p1,p2,W,r,Lo,N,Po,L,pad);
 if(E) N=Name;
 return E;
}


/*
void PicPNet::SetOutl()
{

 R.setRect(0,0,0,0);
 Ly=0;
 PicGrp::SetOutl();
 Rp=R;
 unsigned long int t=Layer->GetRts();
 Ly=Ly|t;
 if (Layer->IsVis(t) || HiL){
  PinLst * T=PL;
  QRect r;
  QPoint p;
  int x1;
  int x2;
  int y1;
  int y2;
  if(Rp.isEmpty()){
   x1=30000;
   y1=30000;
   x2=-30000;
   y2=-30000;
  }
  else Rp.coords(&x1,&y1,&x2,&y2);
  while(T!=NULL){
   if(T->P->GetPinP(&p,T->n)){
    if(p.x()>x2) x2=p.x();
    if(p.x()<x1) x1=p.x();
    if(p.y()>y2) y2=p.y();
    if(p.y()<y1) y1=p.y();
   }
   T=T->Next;
  }
  if(HiL) R.setCoords(x1-21,y1-21,x2+21,y2+21);
  else R.setCoords(x1,y1,x2,y2);
 }
}
 */

void PicPNet::UpdORect(int mir)
{
 R.setRect(0,0,0,0);
 Ly=0;
 PicGrp::UpdORect(mir);
 Rp=R;
 unsigned long int t=Layer->GetRts();
 Ly=Ly|t;
 if (Layer->IsVis(t) || HiL){
  PinLst * T=PL;
  QRect r;
  QPoint p;
  int x1;
  int x2;
  int y1;
  int y2;
  if(Rp.isEmpty()){
   x1=30000;
   y1=30000;
   x2=-30000;
   y2=-30000;
  }
  else Rp.getCoords(&x1,&y1,&x2,&y2);
  while(T!=NULL){
   if(T->P->GetPinP(&p,T->n)){
    if(p.x()>x2) x2=p.x();
    if(p.x()<x1) x1=p.x();
    if(p.y()>y2) y2=p.y();
    if(p.y()<y1) y1=p.y();
   }
   T=T->Next;
  }
  if(x1<=x2 && y1<=y2){
//   if(HiL) 
   R.setCoords(x1-21,y1-21,x2+21,y2+21);
//   else R.setCoords(x1-1,y1+1,x2-1,y2+1);
  }
 }
}


void PicPNet::UpdSelORect(int mir)
{
 UpdORect(mir);
}



void PicPNet::Paint(QPainter* P,QRect* Rec,int flag,QColor* col,
                   int x,int y,int rot,int mir,bool HL)
{
 PicGrp::Paint(P,Rec,flag,col,x,y,rot,mir,HL);
 QPoint p1;
 QPoint p;
 p.setX(x);
 p.setY(y);
 int x1;
 int x2;
 int y1;
 int y2;

 unsigned long int t=Layer->GetRts();
 if (t && Layer->GetVisColor(&col,t) && (!SR || flag==kDrawSel)){
   PinLst * T;

  QPen pen;
  QPoint p2;

  int i;

//  if(SR) MinRts();

  if(SR || Sel) CheckCn();

  if(Rp.isEmpty()){
   x1=300000;
   y1=300000;
   x2=-300000;
   y2=-300000;
  }
  else Rp.getCoords(&x1,&y1,&x2,&y2);

  pen.setColor(*col);
  pen.setStyle(Qt::SolidLine);
  pen.setWidth(0);
  P->setBrush(Qt::NoBrush);
  P->setPen(pen);

  T=PL;
  while(T!=NULL){
   T->P->GetPinP(&p1,T->n);
   if(p1.x()>x2) x2=p1.x();
   if(p1.x()<x1) x1=p1.x();
   if(p1.y()>y2) y2=p1.y();
   if(p1.y()<y1) y1=p1.y();

   p1=CompRot(rot,p1,mir)+p;
   if(HiL){
    P->setPen(Qt::black);
    P->setBrush(Qt::black);
    if(!(flag & kDrawDummy)) P->drawEllipse(p1.x()-30,p1.y()-30,60,60);

    P->setBrush(Qt::NoBrush);
    P->setPen(pen);
   }
   for(i=0;i<=T->Act;i++){
    T->Cn[i]->P->GetPinP(&p2,T->Cn[i]->n);
    if(!(flag & kDrawDummy)) P->drawLine(p1,CompRot(rot,p2,mir)+p);
   }
   T=T->Next;
  }
  if(x1<x2 && y1<y2){
//   if(HiL) 
   R.setCoords(x1-21,y1-21,x2+21,y2+21);
//   else R.setCoords(x1,y1,x2,y2);
  }
 }
 else if(PL && HiL){
  PinLst * L;
  P->setPen(Qt::black);
  P->setBrush(Qt::black);
  if(Rp.isEmpty()){
   x1=300000;
   y1=300000;
   x2=-300000;
   y2=-300000;
  }
  else Rp.getCoords(&x1,&y1,&x2,&y2);
  L=PL;
  while(L){
   L->P->GetPinP(&p1,L->n);
   if(p1.x()>x2) x2=p1.x();
   if(p1.x()<x1) x1=p1.x();
   if(p1.y()>y2) y2=p1.y();
   if(p1.y()<y1) y1=p1.y();
   p1=CompRot(rot,p1,mir)+p;
   if(!(flag & kDrawDummy)) P->drawEllipse(p1.x()-30,p1.y()-30,60,60);
   L=L->Next;
  }
  if(x1<x2 && y1<y2){
   R.setCoords(x1-21,y1-21,x2+21,y2+21);
  }
 }
}

void PicPNet::MoveN(PinLst ** D,PinLst ** S,int Grp)
{
 PinLst * T=*S;
 PinLst * T1=*S;
 while(T){
  if(T->Grp==Grp){
   if(T==*S){
    *S=T->Next;
    T->Next=*D;
    *D=T;
    T=*S;
   }
   else{
    T1->Next=T->Next;
    T->Next=*D;
    *D=T;
    T=T1->Next;
   }
  }
  else {
   T1=T;
   T=T->Next;
  }
 }
}


void PicPNet::MinRts()
{
 if(PL){
  PinLst * T=PL;
  PinLst * T1=PL;
  PinLst * TM=PL;
  PinLst * T1M=PL;
  PinLst * D=PL;
  PinLst * S=PL;
  int i;
  long long int p=0;
  long long int min;
  QPoint p1;


  while (T){
   for(i=0;i<6;i++){
    T->Cn[i]=NULL;
   }
   T->Act=-1;
 //  T->Grp=p;
   T->P->GetPinP(&p1,T->n);
   T->x=p1.x();
   T->y=p1.y();

   p++;
   T=T->Next;
  }

  D=NULL;
  S=PL;
  MoveN(&D,&S,PL->Grp);
  while (S){
   T=D;
   min=-1;
   while (T){
    T1=S;
    while(T1){
     p=((long long)(T->x-T1->x)*(T->x-T1->x)+(long long)(T->y-T1->y)*(T->y-T1->y));
     if((min<0) || (p<min)){
      TM=T;
      T1M=T1;
      min=p;
     }
     T1=T1->Next;
    }
    T=T->Next;
   }
   TM->Act++;
   if(TM->Act>5) TM->Act=5;
   TM->Cn[TM->Act]=T1M;
   MoveN(&D,&S,T1M->Grp);
  }
  PL=D;
 }
}

void PicPNet::CheckCn()
{
 GrpEl * T=Data;
 GrpEl * T1=Data;
 GrpEl * T2=Data;
 PinLst * P=PL;
 PinLst * P1=PL;
 
 PicLine * L1=NULL;
 PicLine * L2=NULL;

 PicPoly * Po1=NULL;
 PicPoly * Po2=NULL;
 
 PicPadS * PS=NULL;
 
 QPoint p1;
 int i=2;
 int cn1=0;
 int cn2=0;
// printf("CheckCn : start\n");
 
 while(T){
  T->a=i;
  if(T->E->GetIden()==kPicPoly){
    i=((PicPoly *)(T->E))->SetCN(i);
  }
  i++;
  T=T->Next;
 }
 while(P){
  P->Grp=i;
  i++;
  P=P->Next;
 }
 T=Data;
 while(T){
  T1=T->Next;
  while(T1){
   T2=NULL;
   L1=NULL;
   L2=NULL;
   Po1=NULL;
   Po2=NULL;
   PS=NULL;
   cn1=0;
   cn2=0;
   if(T->E->GetIden()==kPicLine){
     L1=(PicLine *)(T->E);
   }
   if(T1->E->GetIden()==kPicLine){
     if(L1) L2=(PicLine *)(T1->E);
     else L1=(PicLine *)(T1->E);
   }
   if(T->E->GetIden()==kPicPoly){
     Po1=(PicPoly *)(T->E);
   }
   if(T1->E->GetIden()==kPicPoly){
     if(Po1) Po2=(PicPoly *)(T1->E);
     else Po1=(PicPoly *)(T1->E);
   }
   if(T->E->GetIden()==kPicPadS){
     PS=(PicPadS *)(T->E);
   }
   if(T1->E->GetIden()==kPicPadS){
     PS=(PicPadS *)(T1->E);
   }
//   printf("CheckCn : isCn\n");
   if(L1 && L2){
     if (T->a!=T1->a &&
         L2->IsX(L1->GetBegin(),L1->GetEnd()) &&
         Layer->IsConnect(L1->GetLayer(),L2->GetLayer())){
       T2=Data;
     }
   }
   else if(L1 && PS){
     if (L1->IsConnect(PS->Pos(),4)
        && Layer->IsConnect(L1->GetLayer(),PS->GetLayer())){
       T2=Data;
     }
   }
   else if(L1 && Po1){
     if (Layer->IsConnect(L1->GetLayer(),Po1->GetLayer())){
       cn1=Po1->IsConnect(L1->GetBegin(),4);
       cn2=Po1->IsConnect(L1->GetEnd(),4);
       if(cn2 && !cn1){
         cn1=cn2;
	 cn2=0;
       }
       if(cn1 || cn2) T2=Data;
     }
   }
   else if(PS && Po1){
     if (Layer->IsConnect(Po1->GetLayer(),PS->GetLayer())){
       cn1=Po1->IsConnect(PS->Pos(),4);
       if(cn1) T2=Data;
     }
   }
   else if(Po1 && Po2){
     QPainterPath po1=Po1->GetPoly(); //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
     if(Layer->IsConnect(Po1->GetLayer(),Po2->GetLayer())){
       cn1=Po2->IsConnect(po1,4);
       if(cn1) T2=Data;
     }
   }
   if((T1->E->GetIden()==kPicPoly) && (cn1>1)) i=cn1;
   else i=T1->a;
   if(((T->E->GetIden()!=kPicPoly)) || (cn1<=1)) cn1=T->a;
//   if(T2) printf("CheckCn : change %d,%d\n",i,cn1);

   while(T2){
    if(T2->a==i) T2->a=cn1;
    if(T2->E->GetIden()==kPicPoly) ((PicPoly *)(T2->E))->ChangeCN(i,cn1);
    T2=T2->Next;
   }
   if(cn2>1){
     T2=Data;
     while(T2){
      if(T2->a==cn2) T2->a=cn1;
      if(T2->E->GetIden()==kPicPoly) ((PicPoly *)(T2->E))->ChangeCN(cn2,cn1);
      T2=T2->Next;
     }
   }
   T1=T1->Next;
  }
  T=T->Next;
 }
 P=PL;

 int cn;
 while(P){
   T=Data;
   P->P->GetPinP(&p1,P->n);
   i=0;
   while(T){
     cn=0;
     if(T->E->GetIden()==kPicLine){
       if(((PicLine *)(T->E))->IsConnect(p1,4) &&
	   Layer->IsConnect(T->E->GetLayer(),P->P->GetPinL(P->n))){
	 cn=1;
       }
     }
     if(T->E->GetIden()==kPicPoly){
       if(Layer->IsConnect(T->E->GetLayer(),P->P->GetPinL(P->n))){
         cn1=((PicPoly *)(T->E))->IsConnect(p1,4);
	 if(cn1) cn=1;
       }
     }
     if(cn){
       if(i){
         if((T->E->GetIden()==kPicPoly) && (cn1>1)) i=cn1;
	 else i=T->a;
	 T2=Data;
	 while(T2){
	   if(T2->a==i) T2->a=P->Grp;
	   if(T2->E->GetIden()==kPicPoly) ((PicPoly*)(T2->E))->ChangeCN(i,P->Grp);
	   T2=T2->Next;
	 }
	 P1=PL;
	 while(P1){
	   if(P1->Grp==i) P1->Grp=P->Grp;
	   P1=P1->Next;
	 }
       }
       else{
         if((T->E->GetIden()==kPicPoly) && (cn1>1)) i=cn1;
	 else i=T->a;
	 P->Grp=i;
       }
     }
     T=T->Next;
   }
   P=P->Next;
 }
 MinRts();
}

void PicPNet::RmSelPin()
{
 PinLst * L;
 PinLst * L1=NULL;

 L=PL;
 while(L){
  if(L->P->IsSelect()){
    if(L==PL){
      PL=L->Next;
      delete L;
      L=PL;
    }
    else{
      L1->Next=L->Next;
      delete L;
      L=L1->Next;
    }
  }
  else{
   L1=L;
   L=L->Next;
  } 
 }
  
}


int PicPNet::Disjoint(int & t)
{
 PinLst * L;
 PinLst * L1;
 int n=0;
 int i;
 CheckCn();

 L=PL;
 if(L) t--;
 while(L){
  t++;
  if(L->Grp){
   n++;
   i=L->Grp;
   L1=PL;
   while(L1){
    if(L1->Grp==i) L1->Grp=0;
    L1=L1->Next;
   }
  }
  L=L->Next;
 }

 CheckCn();
 return n-1;
}

bool PicPNet::IsVia(QPoint p1)
{
 PinLst * L;
 QPoint p;
 GrpEl * T=Data;
 while(T){
  if(T->E->GetIden()==kPicPadS){
   if (T->E->Pos()==p1) return true;
  }
  T=T->Next;
 }

 L=PL;
 while(L){
  L->P->GetPinP(&p,L->n);
  if(p==p1) return true;
  L=L->Next;
 }

 return false;
}



void PicPNet::ClrData()
{
 Data=NULL;
}


void PicPNet::TextSave(QTextStream * S, bool sel)
{
// int i;
 PicEl::TextSave(S,sel);
 *S << "    {NetN " << Name << " }\n";
 PicGrp::TextSaveNext(S,sel);
}

bool  PicPNet::TLoadNext(QTextStream * S,QString* s)
{
 if (s->contains("NetN")){
  Name=TextLoadStr(S);
 }
 else  return PicGrp::TLoadNext(S,s);
 return true;
}

